; Contact Sam Cruise disassembly
; https;//skoolkit.ca
;
; Copyright 1986 Microsphere Computer Services Ltd (Contact Sam Cruise)
; Copyright 2010-2019 Richard Dymond (this disassembly)

write "zx_csc.com"  ; tell winApe to which output file to write

;**** set application area and run address here ****

application equ 20637 ; can be address from #4000 up to #FF00

appl_run equ 20637 ; after the program is loaded, execution starts here

use_interrupt equ 1 ;

READ "zx_incl.asm"  ; this include is required to start the Spectrum program from CP/M

;*** Manual ***
;
; This program can be assembled with WinApe (Amstrad simulator and assembler) on a PC.
; When you start winApe, it wants to install "DirectPlay", but you can skip that.
; The assembler delivers a ".com" file.
;
; On the Isetta computer, start the SymShell by double clicking on it's icon.
; If you like, select a full screen with the "full" command.
; Change the directory (with CD command) to the directory where the .com file and cpvm.com are.
;
; Then type "cpvm" to start the CP/M operating system,
;
; and in CP/M, type the name of the .com file, to start it.
;

;**************** ZX Spectrum application  ****************
  
  org application



  ORG 20637

  JP ENDCSCENE_3

; Graphic data for the bottom 4 lines of the screen
  DEFB 0,0,0,0,0,0,0,0,8,136,31,252,3,128,1,192,0
  DEFB 12,0,8,144
  DEFS 13
  DEFB 100,128,0,0,0,0,69,20,23,116,9,32,10,192
  DEFB 24,8,4,14,240,0,0,0,0,0,0,0,0,0,60,0
  DEFB 2,112,2,245,68,57,40,92
  DEFS 8
  DEFB 96,96,96,96,240,4,0,0,0,0,0,0,0,0,192,128
  DEFS 162
  DEFB 0,16,0,0,0,0,53,86,16,4,12,96,7,176
  DEFB 48,50,0,72,144
  DEFS 12
  DEFB 1,83,0,0,0,0,0,71,119,21,84,5,64,9,192
  DEFB 36,6,8,14,128,0,0,0,0,0,0,0,0,0,34,0
  DEFB 5,64,2,148,68,37,40,80,24,24,24,24,24,24,24,24
  DEFB 160,160,160,160,144,4,0,0,0,0,0,0,0,0,192,64
  DEFS 162
  DEFB 0,32,0,0,0,0,66,33,23,116,16,16,15,112
  DEFB 72,66,0,36,148,119,119,112
  DEFS 9
  DEFB 2,104,0,0,0,0,0,0,0,21,80,5,64,8,192
  DEFB 67,193,8,18,135,119,112,0,0,0,0,0,0,0,255,0
  DEFB 53,64,30,148,67,37,235,222,24,24,24,24,24,24,24,24
  DEFB 224,224,224,224,149,117,112,0,0,0,0,0,0,0,194,64
  DEFS 162
  DEFB 0,96,0,0,0,0,0,0,21,84,16,16,15,176
  DEFB 76,130,0,20,244,68,84,80
  DEFS 9
  DEFB 6,64,0,0,0,0,0,66,33,21,84,5,64,28,192
  DEFB 66,34,6,20,244,84,80,0,0,0,0,0,0,0,126,0
  DEFB 69,0,0,0,0,0,0,0,126,126,126,126,126,126,126,126
  DEFB 16,16,16,16,229,69,64,0,0,0,0,0,0,0,130,64
  DEFS 162
  DEFB 0,160,0,0,0,0,117,119,21,80,32,8,9,192
  DEFB 35,4,0,18,148,116,84,112
  DEFS 9
  DEFB 10,64,0,0,0,0,0,53,86,23,116,7,192,28,192
  DEFB 132,20,113,36,20,84,112,0,0,0,0,0,0,0,102,0
  DEFB 66,0,0,0,0,0,0,0,126,126,126,126,126,126,126,126
  DEFB 8,8,8,8,149,70,112,0,0,0,0,0,0,0,130,64
  DEFS 162
  DEFB 3,32,0,0,0,0,69,68,23,116,32,8,28,192
  DEFB 41,8,0,14,148,20,84,64
  DEFS 9
  DEFB 18,30,246,195,189,43,222,8,136,16,4,7,224,1,224
  DEFB 152,8,129,72,20,84,64,0,0,0,0,0,0,0,106,0
  DEFB 72,0,0,0,0,0,0,0,24,24,24,24,24,24,24,24
  DEFB 5,5,5,5,149,69,16,0,0,0,0,0,0,0,131,64
  DEFS 162
  DEFB 4,32,0,0,0,0,101,118,16,4,19,144,28,192
  DEFB 8,8,3,6,148,119,116,112
  DEFS 9
  DEFB 18,16,150,196,37,42,16,0,0,31,252,7,192,3,240
  DEFB 96,0,126,8,247,116,112,0,0,0,0,0,0,0,115,0
  DEFB 48,0,0,0,0,0,0,0,24,24,24,24,24,24,24,24
  DEFB 2,2,2,2,247,117,112,0,0,0,0,0,0,0,130,64
  DEFS 162
  DEFB 4,0,0,0,0,0,69,20,16,4,18,144,12,192,8,112,3,252
  DEFS 13
  DEFB 112,28,150,196,37,43,144,0,0,0,0,3,128,3,240
  DEFS 14
  DEFB 176,128
  DEFS 16
  DEFB 1,1,1,1,0,0,0,0,0,0,0,0,0,1,92,128

; Attribute file
  DEFS 640
  DEFB 15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
  DEFB 15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
  DEFB 23,23,23,23,23,23,23,23,48,48,48,48,48,48,48,48
  DEFB 48,48,48,48,32,32,32,32,32,32,32,32,32,87,87,87
  DEFB 23,23,23,23,23,23,23,23,48,48,48,48,48,48,48,48
  DEFB 48,48,48,48,32,32,32,32,32,32,32,32,32,87,87,87
  DEFB 23,23,23,23,23,23,23,23,50,50,50,50,50,50,50,50
  DEFB 48,48,48,48,32,32,32,32,32,32,32,32,32,87,87,87

; Message 55; 'A VOICE SAID 'ED - TELL THE OIL MAN THAT THE KEY TO  THE FAT
; MANS HOUSE IS AT NO 31 AND THAT THE BOSS WANTS TO SEE YOU BOTH AT NO 19''
;
; Appears in the phone message table entry at RINGPHONE1.
MSG055;
  DEFB 125                ; 125; 'A VOICE SAID ''
  DEFB 108                ; 108; 'ED '
  DEFM "- TELL"
  DEFB 100                ; 100; ' THE '
  DEFM "OIL"
  DEFB 115                ; 115; ' MAN'
  DEFM " "
  DEFB 31                 ; 31; 'THAT'
  DEFB 100                ; 100; ' THE '
  DEFB 4                  ; 4; 'KEY'
  DEFB 118                ; 118; ' TO '
  DEFB 100                ; 100; ' THE '
  DEFB 129                ; 129; 'FAT'
  DEFB 115                ; 115; ' MAN'
  DEFM "S HOUSE IS AT "
  DEFB 102                ; 102; 'NO '
  DEFM "31"
  DEFB 116                ; 116; ' AND '
  DEFB 31                 ; 31; 'THAT'
  DEFB 100                ; 100; ' THE '
  DEFM "BOSS WANTS"
  DEFB 118                ; 118; ' TO '
  DEFM "SEE"
  DEFB 126                ; 126; ' YOU'
  DEFM " BOTH AT "
  DEFB 102                ; 102; 'NO '
  DEFM "19'"
  DEFB 0                  ; End marker

; Message 56; 'DAISY SAID 'LANA RANG - SHE HAD TO GET OUT IN A HURRY - OH AND I
; HEARD NOISES IN THE CEILING''
;
; Appears in the phone message table entry at PHONEMSG1.
MSG056;
  DEFB 26                 ; 26; 'DAISY SAID ''
  DEFB 28                 ; 28; 'LANA RANG - '
  DEFM "SHE HAD"
  DEFB 118                ; 118; ' TO '
  DEFM "GET OUT IN"
  DEFB 113                ; 113; ' A '
  DEFM "HURRY - OH"
  DEFB 116                ; 116; ' AND '
  DEFB 103                ; 103; 'I '
  DEFM "HEARD NOISES IN"
  DEFB 100                ; 100; ' THE '
  DEFM "CEIL"
  DEFB 127                ; 127; 'ING'
  DEFM "'"
  DEFB 0                  ; End marker

; Message 57; 'OK ED - THE FAT MAN HAS THE KEY TO NO 27'
;
; Appears in the phone message table entry at RINGPHONE2.
MSG057;
  DEFM "OK "
  DEFB 108                ; 108; 'ED '
  DEFM "-"
  DEFB 100                ; 100; ' THE '
  DEFB 129                ; 129; 'FAT'
  DEFB 115                ; 115; ' MAN'
  DEFM " HAS"
  DEFB 100                ; 100; ' THE '
  DEFB 4                  ; 4; 'KEY'
  DEFB 118                ; 118; ' TO '
  DEFB 102                ; 102; 'NO '
  DEFM "27"
  DEFB 0                  ; End marker

; Message 58; 'DAISY SAID 'LANA RANG - HER NEW NUMBERS 7162. THE POLICE WERE
; HERE''
;
; Appears in the phone message table entry at PHONEMSG2.
MSG058;
  DEFB 26                 ; 26; 'DAISY SAID ''
  DEFB 28                 ; 28; 'LANA RANG - '
  DEFM "HER NEW NUMBERS 7162."
  DEFB 100                ; 100; ' THE '
  DEFM "POLICE WERE HERE'"
  DEFB 0                  ; End marker

; Message 70; 'SOMEONE BELOW SAID 'CRUISE WAS DRESSED AS THE OIL MAN. DONT LET
; ANYONE PAST''
;
; Appears in the message location table entry at ROPEMSG.
MSG070;
  DEFB 128                ; 128; 'SOMEONE '
  DEFM "BELOW "
  DEFB 124                ; 124; 'SAID '
  DEFM "'"
  DEFB 101                ; 101; 'CRUISE '
  DEFB 117                ; 117; 'WAS '
  DEFM "DRESS"
  DEFB 108                ; 108; 'ED '
  DEFM "AS"
  DEFB 100                ; 100; ' THE '
  DEFM "OIL"
  DEFB 115                ; 115; ' MAN'
  DEFM ". DONT LET ANY"
  DEFB 123                ; 123; 'ONE '
  DEFM "PAST'"
  DEFB 0                  ; End marker

; Message 71; 'THERES A SAFE WITH 4 LOCKS'
;
; Appears in the message location table entry at SAFE.
MSG071;
  DEFB 122                ; 122; 'THE'
  DEFM "RES"
  DEFB 113                ; 113; ' A '
  DEFM "SAFE WITH 4 LOCKS"
  DEFB 0                  ; End marker

  DEFS 10

; System variables REPDEL and REPPER
  DEFB 35                 ; Set REPDEL to 35
  DEFB 5                  ; Set REPPER to 5

  DEFS 48

; System variable FLAGS
  DEFB 8                  ; Set bit 3 so that the keyboard is read in 'L' mode

  DEFS 292

; Message 63; 'DAISY SAID 'SAM - A GANGSTER'S WATCHING FOR YOU OUTSIDE THE
; POLICE STATION''
;
; Appears in the phone message table entry at RINGPHONE3.
MSG063;
  DEFB 26                 ; 26; 'DAISY SAID ''
  DEFB 111                ; 111; 'SAM '
  DEFM "-"
  DEFB 113                ; 113; ' A '
  DEFM "GANGSTER'S WATCH"
  DEFB 30                 ; 30; 'ING '
  DEFM "FOR"
  DEFB 126                ; 126; ' YOU'
  DEFM " OUTSIDE"
  DEFB 100                ; 100; ' THE '
  DEFM "POLICE STATION'"
  DEFB 0                  ; End marker

; Message 76; 'DAISY SAID 'LANA RANG - THAT FAT MAN HAS TWO KEYS NOT JUST ONE
; ''
;
; Appears in the phone message table entry at PHONEMSG5.
MSG076;
  DEFB 26                 ; 26; 'DAISY SAID ''
  DEFB 28                 ; 28; 'LANA RANG - '
  DEFB 31                 ; 31; 'THAT'
  DEFM " "
  DEFB 129                ; 129; 'FAT'
  DEFB 115                ; 115; ' MAN'
  DEFM " HAS TWO "
  DEFB 4                  ; 4; 'KEY'
  DEFM "S NOT JUST "
  DEFB 123                ; 123; 'ONE '
  DEFM "'"
  DEFB 0                  ; End marker

; Message 64; 'A VOICE SAID 'OK FATS THE HOOK'S AT NO 74 AND ALS GUARDING IT''
;
; Appears in the phone message table entry at RINGPHONE4.
MSG064;
  DEFB 125                ; 125; 'A VOICE SAID ''
  DEFM "OK "
  DEFB 129                ; 129; 'FAT'
  DEFM "S"
  DEFB 100                ; 100; ' THE '
  DEFM "HOOK'S AT "
  DEFB 102                ; 102; 'NO '
  DEFM "74"
  DEFB 116                ; 116; ' AND '
  DEFM "ALS GUARD"
  DEFB 30                 ; 30; 'ING '
  DEFM "IT'"
  DEFB 0                  ; End marker

; Message 66; 'A VOICE SAID 'OK LANA THE KEY TO 74'S IN THE ROOM PAST THE
; CATWALK BUT THERE'S A GUARD''
;
; Appears in the phone message table entry at RINGPHONE5.
MSG066;
  DEFB 125                ; 125; 'A VOICE SAID ''
  DEFM "OK "
  DEFB 29                 ; 29; 'LANA'
  DEFB 100                ; 100; ' THE '
  DEFB 4                  ; 4; 'KEY'
  DEFB 118                ; 118; ' TO '
  DEFM "74'S IN"
  DEFB 100                ; 100; ' THE '
  DEFM "ROOM PAST"
  DEFB 100                ; 100; ' THE '
  DEFM "CATWALK BUT"
  DEFB 121                ; 121; ' THE'
  DEFM "RE'S"
  DEFB 113                ; 113; ' A '
  DEFM "GUARD'"
  DEFB 0                  ; End marker

; Message 67; 'SOMEONE HIT ME. I PLAYED DEAD. TWO MEN WALKED OFF. ONE SAID 'HEY
; DON AINT YOU SCARED THAT CRUISE WILL GET UP TO YOUR ROOM WHEN ALS ON THE
; PHONE ?''
;
; Appears in Sam's initialisation parameters for game mode 3 at SAMMODE3.
MSG067;
  DEFB 128                ; 128; 'SOMEONE '
  DEFM "HIT ME. "
  DEFB 103                ; 103; 'I '
  DEFB 5                  ; 5; 'PLAY'
  DEFB 108                ; 108; 'ED '
  DEFM "DEAD. TWO MEN WALK"
  DEFB 108                ; 108; 'ED '
  DEFM "OFF. "
  DEFB 123                ; 123; 'ONE '
  DEFB 124                ; 124; 'SAID '
  DEFM "'HEY "
  DEFB 107                ; 107; 'DON '
  DEFM "AINT"
  DEFB 126                ; 126; ' YOU'
  DEFM " SCAR"
  DEFB 108                ; 108; 'ED '
  DEFB 31                 ; 31; 'THAT'
  DEFM " "
  DEFB 101                ; 101; 'CRUISE '
  DEFM "WILL GET UP"
  DEFB 118                ; 118; ' TO '
  DEFB 126                ; 126; ' YOU'
  DEFM "R ROOM"
  DEFB 7                  ; 7; ' WHEN'
  DEFM " ALS ON"
  DEFB 100                ; 100; ' THE '
  DEFM "PH"
  DEFB 123                ; 123; 'ONE '
  DEFM "?'"
  DEFB 0                  ; End marker

; Message 68; 'DAISY SAID 'ALS NUMBER'S 6124''
;
; Appears in the phone message table entry at PHONEMSG7.
MSG068;
  DEFB 26                 ; 26; 'DAISY SAID ''
  DEFM "ALS NUMBER'S 6124'"
  DEFB 0                  ; End marker

; Message 69; 'TECHNICAL SERVICES HERE. TO USE A HOOK GET TO RIGHT PLACE AND
; PRESS C'
;
; Appears in the phone message table entry at RINGPHONE6.
MSG069;
  DEFM "TECHNIC"
  DEFB 104                ; 104; 'AL '
  DEFM "SERVICES HERE."
  DEFB 118                ; 118; ' TO '
  DEFM "USE"
  DEFB 113                ; 113; ' A '
  DEFM "HOOK GET TO"
  DEFB 6                  ; 6; ' RIGHT '
  DEFM "PLACE"
  DEFB 116                ; 116; ' AND '
  DEFB 3                  ; 3; 'PRESS'
  DEFM " C"
  DEFB 0                  ; End marker

; Message 72; 'LANA ANSWERED 'OOH SAM! YOUVE GOT THE BIRD. SEE YOU IN YOUR
; OFFICE''
;
; Appears in the phone message table entry at PHONEMSG8.
MSG072;
  DEFB 27                 ; 27; 'LANA ANSWERED 'OOH SAM! '
  DEFB 126                ; 126; ' YOU'
  DEFM "VE GOT"
  DEFB 100                ; 100; ' THE '
  DEFM "BIRD. SEE"
  DEFB 126                ; 126; ' YOU'
  DEFM " IN"
  DEFB 126                ; 126; ' YOU'
  DEFM "R OFFICE'"
  DEFB 0                  ; End marker

; Message 73; 'I STARED AT THE LOVELY LANA  WAS IT THOSE RUBY LIPS OR THE SLIM
; AUTOMATIC THAT TRANSFIXED ME? SHE SAID 'THANK YOU FOR THE BUDGIE SAM . ITS
; PRICELESS. IVE ALREADY KILLED ONCE FOR IT. AND NOW ITS GOODBYE SAM ''
;
; Used by the routine at SAMLANA.
MSG073;
  DEFB 103                ; 103; 'I '
  DEFM "STAR"
  DEFB 108                ; 108; 'ED '
  DEFM "AT"
  DEFB 100                ; 100; ' THE '
  DEFM "LOVELY "
  DEFB 29                 ; 29; 'LANA '
  DEFM " "
  DEFB 117                ; 117; 'WAS '
  DEFM "IT THOSE RUBY LIPS OR"
  DEFB 100                ; 100; ' THE '
  DEFM "SLIM AUTOMATIC "
  DEFB 31                 ; 31; 'THAT'
  DEFM " TRANSFIX"
  DEFB 108                ; 108; 'ED '
  DEFM "ME? SHE "
  DEFB 124                ; 124; 'SAID '
  DEFM "'THANK"
  DEFB 126                ; 126; ' YOU'
  DEFM " FOR"
  DEFB 100                ; 100; ' THE '
  DEFM "BUDGIE "
  DEFB 111                ; 111; 'SAM '
  DEFM ". ITS PRICELESS. "
  DEFM "IVE ALREADY KILL"
  DEFB 108                ; 108; 'ED '
  DEFM "ONCE FOR IT."
  DEFB 116                ; 116; ' AND '
  DEFM "NOW ITS GOODBYE "
  DEFB 111                ; 111; 'SAM '
  DEFM "'"
  DEFB 0                  ; End marker

; Message 74; 'SHE'S IN JAIL NOW. ANOTHER CASE SOLVED. BUT NOW THE MOB KNOWS
; IVE GOT THE BUDGIE AND THEYRE AFTER ME . .'
;
; Appears in Sam's initialisation parameters for game mode 4 at SAMMODE4.
MSG074;
  DEFM "SHE'S IN JAIL NOW. ANO"
  DEFB 122                ; 122; 'THE'
  DEFM "R CASE SOLVED. BUT NOW"
  DEFB 100                ; 100; ' THE '
  DEFM "MOB KNOWS IVE GOT"
  DEFB 100                ; 100; ' THE '
  DEFM "BUDGIE"
  DEFB 116                ; 116; ' AND '
  DEFB 122                ; 122; 'THE'
  DEFM "YRE AFTER ME . ."
  DEFB 0                  ; End marker

; Message 75; 'SHE FIRED'
;
; Used by the routine at SAMLANA.
MSG075;
  DEFM "SHE FIRED"
  DEFB 0                  ; End marker

; Message 97; 'JOYSTICK?'
;
; Used by the routine at JOYSTICK.
MSG097;
  DEFM "JOYSTICK?"
  DEFB 0                  ; End marker

; Unused
  DEFS 10

; Event table
;
; Initialised by the routine at INITOBJS, and processed on every pass through
; the main loop by the routine at EVENTS. Each of the 14 entries in this table
; corresponds to a significant event in the game that requires changes to be
; made (such as making a key available, or Daisy having a new message for Sam).
; The bits in the first byte of each entry have the following meanings;
;
; +--------+------------------------------------+
; | Bit(s) | Meaning if set                     |
; +--------+------------------------------------+
; | 7      | Entry should be inactive initially |
; | 6      | Entry should never be deactivated  |
; | 1-5    | Unused                             |
; | 0      | Entry is inactive                  |
; +--------+------------------------------------+
;
; The first entry makes Sam's oil man disguise work with the gangsters at no.
; 19, and makes the policemen roam the entire city (instead of just the
; sidewalk near Sam's office) while on the beat. It is triggered at the start
; of a new game.
EVENT01;
  DEFB 0
  DEFB 13                 ; 13 bytes until the next entry
  DEFB 1                  ; 1 condition follows
  DEFW GAMEMODE           ; GAMEMODE holds the game mode indicator
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 1                  ; Game mode
  DEFB 2                  ; 2 POKEs follow (to do if the game mode is 1)
  DEFW DISGUISE19         ; DISGUISE19 holds the disguise ID in the region
                          ; definition table at HOODREG3
  DEFB 7                  ; Disguise ID (oil man)
  DEFW 29540              ; Set the operand of the 'OR' instruction at
  DEFB 0                  ; COPDESTOR to 0 (to make the policemen roam the
                          ; entire city)
; The next entry makes Sam's oil man disguise known to the gangsters at no. 19.
; It is triggered when Sam passes the point on the rope above the roof of no.
; 19 where someone below says 'CRUISE WAS DRESSED AS THE OIL MAN. DONT LET
; ANYONE PAST'.
EVENT02;
  DEFB 0
  DEFB 10                 ; 10 bytes until the next entry
  DEFB 1                  ; 1 condition follows
  DEFW ROPEMSG            ; The object table entry at ROPEMSG is for where
                          ; someone below says 'CRUISE WAS DRESSED AS THE OIL
                          ; MAN...'
  DEFB 32                 ; JR NZ (for the instruction at EVENTJR)
  DEFB 32
  DEFB 1                  ; 1 POKE follows
  DEFW DISGUISE19         ; DISGUISE19 holds the disguise ID in the region
                          ; definition table at HOODREG3
  DEFB 255                ; Disguise ID (matches none of Sam's)
; The next entry lines up phone messages 58, 59 and 60 for Sam. It is triggered
; as soon as Sam's score hits 50 (about 4m10s after the game has started).
EVENT03;
  DEFB 0
  DEFB 16                 ; 16 bytes until the next entry
  DEFB 1                  ; 1 condition follows
  DEFW SCORE              ; SCORE holds the LSB of the score
  DEFB 48                 ; JR NC (for the instruction at EVENTJR)
  DEFB 50                 ; Score LSB for comparison
  DEFB 3                  ; 3 POKEs follow (to do when the score LSB is >= 50)
  DEFW PHONEMSG2          ; Initialise phone message 58; 'DAISY SAID 'LANA RANG
  DEFB 92                 ; - HER NEW NUMBERS 7162. THE POLICE WERE HERE''
  DEFW PHONEMSG3          ; Initialise phone message 59; 'LANA ANSWERED 'OOH
  DEFB 36                 ; SAM! THEY KILLED MY FIANCE AND STOLE THE BUDGIE''
  DEFW PHONEMSG4          ; Initialise phone message 60; 'LANA ANSWERED 'OOH
  DEFB 36                 ; SAM! THAT CROOK THE FAT MAN'S JUST MOVED INTO NO
                          ; 15''
; The next entry makes the required changes when Sam enters no. 15 using the
; key in game mode 1.
EVENT04;
  DEFB 0
  DEFB 39                 ; 39 bytes until the next entry
  DEFB 3                  ; 3 conditions follow
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 249
  DEFW 58882              ; This address holds Sam's y-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 29
  DEFW KEYINV             ; KEYINV holds the key inventory
  DEFB 48                 ; JR NC (for the instruction at EVENTJR)
  DEFB 64                 ; Bit 6 set; Sam has the key to no. 15
  DEFB 8                  ; 8 POKEs follow
  DEFW RINGPHONE3         ; Initialise phone message 63; 'DAISY SAID 'SAM - A
  DEFB 94                 ; GANGSTER'S WATCHING FOR YOU OUTSIDE THE POLICE
                          ; STATION''
  DEFW RINGPHONE4         ; Initialise phone message 64; 'A VOICE SAID 'OK FATS
  DEFB 94                 ; THE HOOK'S AT NO 74 AND ALS GUARDING IT''
  DEFW PHONEMSG5          ; Initialise phone message 76; 'DAISY SAID 'LANA RANG
  DEFB 92                 ; - THAT FAT MAN HAS TWO KEYS NOT JUST ONE ''
  DEFW PHONEMSG6          ; Initialise phone message 65; 'LANA ANSWERED 'OOH
  DEFB 36                 ; SAM! BUD SAID HE'D MEET ME ALONE IN THE HOTELS
                          ; RIGHT HAND GREEN ROOM. I'M SCARED - WILL YOU GO
                          ; INSTEAD?''
  DEFW NOKEYEH            ; Disable the object table entry at NOKEYEH (for
  DEFB 33                 ; where someone growls 'NO KEY EH!' in no. 15)
  DEFW 29964              ; Change the operand of the JP instruction at EVENTJP
  DEFB 82                 ; to PREPMODE (to display the cutscene before
  DEFW 29965              ; entering game mode 2)
  DEFB 97                 ;
  DEFW EVENT07            ; Activate the entry at EVENT07 (below)
  DEFB 128                ;
; The next entry changes the operand of the JP instruction at EVENTJP to
; SAMWANTED to send the police after Sam when he finds the dead body on the top
; floor of the hotel.
EVENT05;
  DEFB 0
  DEFB 17                 ; 17 bytes until the next entry
  DEFB 2                  ; 2 conditions follow
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 64                 ; x-coordinate for comparison
  DEFW 58882              ; This address holds Sam's y-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 7                  ; y-coordinate for comparison
  DEFB 2                  ; 2 POKEs follow
  DEFW 29964              ; Change the operand of the JP instruction at EVENTJP
  DEFB 4                  ; to SAMWANTED
  DEFW 29965              ;
  DEFB 122                ;
; The next entry restarts Al's command list when Sam calls 6124, thus giving
; Sam a chance to get past him and collect the hook.
EVENT06;
  DEFB 64                 ; Bit 6 set; always active
  DEFB 21                 ; 21 bytes until the next entry
  DEFB 3                  ; 3 conditions follow
  DEFW OPHONEID           ; OPHONEID holds the ID of the telephone Sam is
                          ; calling
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 102                ; Telephone ID; 6124 (no. 74, second floor)
  DEFW LEFTCOL            ; LEFTCOL holds X, the x-coordinate of the leftmost
                          ; column of the play area on screen
  DEFB 56                 ; JR C (for the instruction at EVENTJR)
  DEFB 56                 ; x-coordinate for comparison
  DEFW 56598              ; This is byte 22 of character 221's buffer (used by
                          ; Al at no. 74 when X<56)
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 12                 ; Command list offset for comparison (points at the
                          ; fourth command in the command list at CLIST05)
  DEFB 2                  ; 2 POKEs follow
  DEFW 56598              ; This is byte 22 of character 221's buffer (used by
                          ; Al at no. 74)
  DEFB 0                  ; Set this to 0 to restart Al's command list
  DEFW 56585              ; This is byte 9 of character 221's buffer (used by
                          ; Al at no. 74)
  DEFB 0                  ; Remove the primary command routine address
                          ; (AWAITSAM) from bytes 8 and 9 of Al's buffer (so
                          ; that the first command in the command list takes
                          ; over immediately)
; The next entry (activated by the one above at EVENT04) lines up phone message
; 66 ('A VOICE SAID 'OK LANA THE KEY TO 74'S IN THE ROOM PAST THE CATWALK BUT
; THERE'S A GUARD'') and makes the key to no. 74 available when Sam enters the
; hotel's right-hand green room while disguised as a woman.
EVENT07;
  DEFB 129
  DEFB 28                 ; 28 bytes until the next entry
  DEFB 4                  ; 4 conditions follow
  DEFW DISGUISEID         ; DISGUISEID holds the ID of Sam's current disguise
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 4                  ; Disguise ID (woman)
  DEFW 58882              ; This address holds Sam's y-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 13                 ; y-coordinate for comparison
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 48                 ; JR NC (for the instruction at EVENTJR)
  DEFB 94                 ; x-coordinate for comparison
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 56                 ; JR C (for the instruction at EVENTJR)
  DEFB 101                ; x-coordinate for comparison
  DEFB 3                  ; 3 POKEs follow
  DEFW RINGPHONE5         ; Line up phone message 66; 'A VOICE SAID 'OK LANA
  DEFB 44                 ; THE KEY TO 74'S IN THE ROOM PAST THE CATWALK BUT
                          ; THERE'S A GUARD''
  DEFW KEY74              ; Make the key to no. 74 available
  DEFB 144                ;
  DEFW EVENT08            ; Activate the next entry at EVENT08 (below)
  DEFB 128                ;
; The next entry (activated by the one above at EVENT07) lines up phone message
; 68 ('DAISY SAID 'ALS NUMBER'S 6124''), and displays the cutscene before
; entering game mode 3. It is triggered when Sam reaches the location with
; coordinates (10,8) (on the stairs leading up to the roof of the apartment
; building next to no. 74).
EVENT08;
  DEFB 129
  DEFB 20                 ; 20 bytes until the next entry
  DEFB 2                  ; 2 conditions follow
  DEFW 58882              ; This address holds Sam's y-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 8                  ; y-coordinate for comparison
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 10                 ; x-coordinate for comparison
  DEFB 3                  ; 3 POKEs follow
  DEFW PHONEMSG7          ; Line up phone message 68; 'DAISY SAID 'ALS NUMBER'S
  DEFB 92                 ; 6124''
  DEFW 29964              ; Change the operand of the JP instruction at EVENTJP
  DEFB 82                 ; to PREPMODE (to display the cutscene before
  DEFW 29965              ; entering game mode 3)
  DEFB 97                 ;
; The next entry makes the key to no. 27 available when Sam knocks the Fat Man
; over.
EVENT09;
  DEFB 0
  DEFB 10                 ; 10 bytes until the next entry
  DEFB 1                  ; 1 condition follows
  DEFW 57602              ; This address holds character 225's y-coordinate
                          ; (character 225 is the Fat Man in game mode 2)
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 37                 ; y-coordinate for comparison (lying on the road)
  DEFB 1                  ; 1 POKE follows
  DEFW KEY27              ; Make the key to no. 27 available
  DEFB 144                ;
; The next entry makes the required changes when Sam enters the room above his
; office while in possession of all four keys.
EVENT10;
  DEFB 0
  DEFB 24                 ; 24 bytes until the next entry
  DEFB 3                  ; 3 conditions follow
  DEFW 58882              ; This address holds Sam's y-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 13                 ; y-coordinate for comparison
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 232                ; x-coordinate for comparison
  DEFW KEYINV             ; KEYINV holds the key inventory
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 120                ; Bits 3-6 set; Sam has all four keys
  DEFB 3                  ; 3 POKEs follow
  DEFW BUDGIE             ; Make the budgie available
  DEFB 192                ;
  DEFW COPFLAGS           ; Clear all flags at COPFLAGS so that Sam won't be
  DEFB 0                  ; chased by the police
  DEFW 29540              ; Set the operand of the 'OR' instruction at
  DEFB 192                ; COPDESTOR to 192 (to make the policemen stay close
                          ; to Sam's office while on the beat)
; The next entry lines up phone message 72 ('LANA ANSWERED 'OOH SAM! YOUVE GOT
; THE BIRD. SEE YOU IN YOUR OFFICE'') when Sam gets the budgie.
EVENT11;
  DEFB 0
  DEFB 10                 ; 10 bytes until the next entry
  DEFB 1                  ; 1 condition follows
  DEFW OBJINV             ; OBJINV holds the object inventory
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 128                ; Bit 7 set; Sam has the budgie
  DEFB 1                  ; 1 POKE follows
  DEFW PHONEMSG8          ; Line up phone message 72; 'LANA ANSWERED 'OOH SAM!
  DEFB 36                 ; YOUVE GOT THE BIRD. SEE YOU IN YOUR OFFICE''
; The next entry disables phone message 72 ('LANA ANSWERED 'OOH SAM! YOUVE GOT
; THE BIRD. SEE YOU IN YOUR OFFICE'') if Sam doesn't have the budgie (either
; because he hasn't found it yet, or it's been taken from him).
EVENT12;
  DEFB 64                 ; Bit 6 set; always active
  DEFB 10                 ; 10 bytes until the next entry
  DEFB 1                  ; 1 condition follows
  DEFW OBJINV             ; OBJINV holds the object inventory
  DEFB 32                 ; JR NZ (for the instruction at EVENTJR)
  DEFB 128                ; Bit 7 set; Sam has the budgie (and only the budgie;
                          ; this is a bug)
  DEFB 1                  ; 1 POKE follows
  DEFW PHONEMSG8          ; Disable phone message 72; 'LANA ANSWERED 'OOH SAM!
  DEFB 0                  ; YOUVE GOT THE BIRD. SEE YOU IN YOUR OFFICE''
; The next entry sends Lana on her way to Sam's office when Sam phones her
; while in possession of the budgie.
EVENT13;
  DEFB 0
  DEFB 17                 ; 17 bytes until the next entry
  DEFB 2                  ; 2 conditions follow
  DEFW OBJINV             ; OBJINV holds the object inventory
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 128                ; Bit 7 set; Sam has the budgie (and only the budgie;
                          ; this is a bug)
  DEFW PHONEMSG8          ; This is the entry for phone message 72 for Sam
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 0                  ; 0 means the phone message has been received by Sam
  DEFB 2                  ; 2 POKES follow
  DEFW EVENT14            ; Activate the entry at EVENT14 (below)
  DEFB 128                ;
  DEFW 57609              ; Set byte 9 of character 225's buffer to 0
  DEFB 0                  ; (character 225 is Lana in game mode 3), triggering
                          ; a move to the next instruction; go to Sam's office
                          ; (see CLIST14)
; The next entry (activated by the one above at EVENT13) immobilises Sam until
; the end of the game when Lana meets him in his office.
EVENT14;
  DEFB 129
  DEFB 25                 ; 25 bytes until the next entry
  DEFB 4                  ; 4 conditions follow
  DEFW 57622              ; This is byte 22 of character 225's buffer
                          ; (character 225 is Lana in game mode 3)
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 8                  ; This command list offset points past the end of the
                          ; command list
  DEFW 58882              ; This address holds Sam's y-coordinate
  DEFB 40                 ; JR Z (for the instruction at EVENTJR)
  DEFB 19                 ; y-coordinate for comparison
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 48                 ; JR NC (for the instruction at EVENTJR)
  DEFB 222                ; x-coordinate for comparison
  DEFW 58881              ; This address holds Sam's x-coordinate
  DEFB 56                 ; JR C (for the instruction at EVENTJR)
  DEFB 231                ; x-coordinate for comparison
  DEFB 2                  ; 2 POKEs follow
  DEFW STATUS             ; Set bit 1 of Sam's status flags at STATUS
  DEFB 2                  ;
  DEFW 58893              ; Set byte 13 of Sam's buffer to 0 (to indicate that
  DEFB 0                  ; Sam has just met Lana; see SAMLANA)
; And finally the end marker.
  DEFB 255

; Unused
  DEFS 13

; Deal with Sam while he's transfixed by Lana
;
; Used by the routine at HANDLESAM when bit 1 at STATUS is set (by the routine
; at EVENTS, using the event entry at EVENT14), indicating that Sam has been
; immobilised after meeting Lana in his office.
;
; H 230 (Sam)
SAMLANA;
  LD L,8                  ; Set Sam's main action timer (in byte 8 of his
  LD (HL),L               ; buffer) to 8
  LD L,13                 ; Byte 13 of Sam's buffer holds 0 if Sam has only
  LD A,(HL)               ; just met Lana, or 1 otherwise
  AND A                   ; Has Sam only just met Lana in his office?
  JR NZ,SAMLANA_0         ; Jump if not
  INC (HL)                ; Increment byte 13 of Sam's buffer so that we don't
                          ; come here again
  LD A,73                 ; Message 73; 'I STARED AT THE LOVELY LANA...'
  LD (MSGNUM),A           ; Store the message number at MSGNUM (so that we can
                          ; check when it has been displayed)
  JP QUEUEMSGU            ; Queue the message urgently
; While Lana is transfixing Sam, we count the policemen who have shown up at
; Sam's office so far and been immobilised.
SAMLANA_0;
  LD BC,512               ; B=2 (2 policemen), C=0 (will count the number of
                          ; immobilised policemen)
  LD D,222                ; Character 222 is the first policeman
SAMLANA_1;
  LD E,9                  ; Point DE at byte 9 of the policeman's buffer
  INC C                   ; Assume that this policeman is already immobilised
  LD A,(DE)               ; A=MSB of the policeman's current primary command
                          ; routine
  CP 231                  ; Is it the MSB of DONOWT (RET)?
  JR Z,SAMLANA_2          ; Jump if so (this policeman is already immobilised)
  DEC C                   ; Decrement C because this policeman is not yet
                          ; immobilised
  LD E,2                  ; A=policeman's y-coordinate
  LD A,(DE)               ;
  CP 19                   ; Is the policeman on the third floor of a building?
  JR NZ,SAMLANA_2         ; Jump to consider the next policeman if not
  DEC E                   ; E=1
  LD A,(DE)               ; A=policeman's x-coordinate
  CP 239                  ; Consider the next policeman unless this one is in
  JR NC,SAMLANA_2         ; Sam's office
  CP 224                  ;
  JR C,SAMLANA_2          ;
  LD A,231                ; Place DONOWT (RET) into bytes 8 and 9 of the
  LD E,9                  ; policeman's buffer, thus immobilising him
  LD (DE),A               ;
  LD A,11                 ;
  DEC E                   ;
  LD (DE),A               ;
SAMLANA_2;
  INC D                   ; Point DE at the next policeman's buffer
  DJNZ SAMLANA_1          ; Jump back until both policemen have been checked
; Now C holds the number of policemen that have been immobilised in Sam's
; office.
  PUSH BC                 ; Save the number of immobilised policemen briefly
  CALL MSGINQUEUE         ; Check whether message 73 ('I STARED AT THE LOVELY
                          ; LANA...') is still in the message queue
  POP BC                  ; Restore the number of immobilised policemen to C
  RET Z                   ; Return unless the entire message has been displayed
  LD A,C                  ; A=number of immobilised policemen
  AND A                   ; Is it at least one?
  JR NZ,PREPMODE          ; Jump if so
  LD HL,0                 ; Set the number of bucks (stored at BUCKS) to 0
  LD (BUCKS),HL           ;
  LD A,75                 ; Message 75; 'SHE FIRED'
  JP SCORECASH_0          ; Display the cutscene with this message, and then
                          ; prepare to enter demo mode

; Prepare for the next game mode
;
; Used by the routine at EVENTS to prepare for game mode 2 (using the event
; table entry at EVENT04) or 3 (using the event table entry at EVENT08), and by
; the routine at SAMLANA to prepare for game mode 4 (when Sam has called the
; police just in time to take Lana into custody).
PREPMODE;
  LD SP,23898             ; Reset the stack to its base location
  NOP
  CALL PREPGAME_2         ; Display the appropriate cutscene and prepare for
                          ; game mode 2, 3 or 4
  JP MAINLOOP_0           ; Re-enter the main loop

; Unused
  DEFB 0

; Reset a gangster's location and restart the command list
;
; Used by the command list at CLIST01. Makes the gangster at no. 15 return to
; no. 15 instantly after dropping Sam off the roof of no. 19, and restarts his
; command list.
;
; H 224 (Gangster)
RESETHOOD;
  LD DE,6648              ; E=248, D=25 (coordinates of the spot where the
                          ; gangster at no. 15 waits for Sam)
  LD A,1                  ; 1=z-coordinate (indoors)
  JR RESETHOOD_0
; This entry point is used by the command list at CLIST11; it makes the
; gangster who watches for Sam outside the police station return instantly to
; the police station after dropping Sam off the roof of no. 19, and restarts
; his command list.
  LD DE,8851              ; E=147, D=34 (coordinates of the base location of
                          ; the gangster who watches for Sam outside the police
                          ; station)
  LD A,4                  ; 4=z-coordinate (on the sidewalk)
RESETHOOD_0;
  LD L,4                  ; Point HL at byte 4 of the gangster's buffer
  LD (HL),A               ; Set the gangster's x-, y- and z-coordinates
  DEC L                   ;
  DEC L                   ;
  LD (HL),D               ;
  DEC L                   ;
  LD (HL),E               ;
  DEC L                   ; Set the gangster's animatory state to 160
  LD (HL),160             ;
  JP RESTART              ; Restart the gangster's command list

; 'J' pressed - joystick
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'J' is
; pressed.
JOYSTICK;
  LD A,96                 ; Message 96; newline
  LD (MSGNUM),A           ; Store this message number at MSGNUM so that it can
                          ; be watched in the message queue
  CALL QUEUEMSGU          ; Queue the message urgently
  LD A,97                 ; Message 97; 'JOYSTICK?'
  CALL QUEUEMSGU          ; Queue this message urgently
JOYSTICK_0;
  CALL MSGINQUEUE         ; Wait until message 96 (newline) has left the queue
  JR Z,JOYSTICK_0         ; (and therefore 'JOYSTICK?' is displayed)
JOYSTICK_1;
  CALL READKEY            ; Wait for a keypress and collect its ASCII code in A
  JR Z,JOYSTICK_1         ;
  SET 5,A                 ; Convert the keypress to lower case
  LD HL,NOINT2            ; Point HL at the keypress offset patch table at
                          ; NOINT2
  LD DE,KEYTABLE          ; Point DE at the main keypress offset table
  LD BC,10                ; There will be 10 bytes to copy
  CP 107                  ; Was 'k' pressed?
  JR NZ,JOYSTICK_3        ; Jump if not
; Now HL points at the appropriate keypress offset patch table (INT2 if 'i'
; (Int2) was pressed, or NOINT2 otherwise), and A holds the input device
; indicator (107 if 'k' (Kempston) was pressed, or 0 otherwise).
JOYSTICK_2;
  PUSH HL                 ; Save the pointer to the keypress offset patch table
                          ; briefly
  LD HL,T_KEMPSTON        ; Set the input device indicator for future games at
  LD (HL),A               ; T_KEMPSTON
  LD H,127                ; Set the input device indicator for the current game
  LD (HL),A               ; at KEMPSTON
  POP HL                  ; Restore the address of the keypress offset patch
                          ; table to HL
  LDIR                    ; Update the entries for keys 0-9 in the keypress
                          ; offset table
  RET
; Some key other than 'k' (Kempston) was pressed.
JOYSTICK_3;
  CP 99                   ; Was 'c' (Cursor) pressed?
  JR Z,JOYSTICK_4         ; Jump if so
  CP 110                  ; Was 'n' (None) pressed?
  JR Z,JOYSTICK_4         ; Jump if so
  LD L,197                ; HL=INT2 (keypress offset patch table for Int2)
  CP 105                  ; Set the zero flag if 'i' was pressed
JOYSTICK_4;
  LD A,0                  ; 0 indicates that we're not using the Kempston
                          ; joystick
  JR Z,JOYSTICK_2         ; Jump if 'i' (Int2) was pressed
  JR JOYSTICK_1           ; Otherwise jump back to collect another keypress

; Keypress offset patch table for keys 0-9 (Kempston/Cursor/None)
;
; Used by the routine at JOYSTICK. These 10 bytes are copied over the first 10
; bytes of the keypress offset table at KEYTABLE (corresponding to keys 0-9) if
; Int2 is not selected.
NOINT2;
  DEFB 19                 ; '0'; Knock on or open a door
  DEFB 0                  ; '1'; Unused
  DEFB 0                  ; '2'; Unused
  DEFB 0                  ; '3'; Unused
  DEFB 0                  ; '4'; Unused
  DEFB 7                  ; '5'; Left (fast)
  DEFB 3                  ; '6'; Down (fast)
  DEFB 1                  ; '7'; Up (fast)
  DEFB 5                  ; '8'; Right (fast)
  DEFB 0                  ; '9'; Unused

; Keypress offset patch table for keys 0-9 (Int2)
;
; Used by the routine at JOYSTICK. These 10 bytes are copied over the first 10
; bytes of the keypress offset table at KEYTABLE (corresponding to keys 0-9) if
; Int2 is selected.
INT2;
  DEFB 19                 ; '0'; Knock on or open a door
  DEFB 7                  ; '1'; Left (fast)
  DEFB 5                  ; '2'; Right (fast)
  DEFB 3                  ; '3'; Down (fast)
  DEFB 1                  ; '4'; Up (fast)
  DEFB 19                 ; '5'; Knock on or open a door
  DEFB 7                  ; '6'; Left (fast)
  DEFB 5                  ; '7'; Right (fast)
  DEFB 3                  ; '8'; Down (fast)
  DEFB 1                  ; '9'; Up (fast)

; Add a random number of bucks to Sam's total
;
; Used by the routine at GOTNOTE. Adds $1, $5, $10 or $20 to Sam's cash supply,
; and prints the new total.
ADDRBUCKS;
  CALL GETRANDOM          ; Get a random number in A
  LD E,1                  ; Sam will get $1 if A<=127
  CP 128                  ;
  JR C,ADDRBUCKS_0        ;
  LD E,5                  ; Sam will get $5 if 128<=A<=209
  CP 210                  ;
  JR C,ADDRBUCKS_0        ;
  CP 248                  ; Sam will get $10 if 210<=A<=247
  LD E,10                 ;
  JR C,ADDRBUCKS_0        ;
  LD E,20                 ; Sam will get $20 if A>=248
ADDRBUCKS_0;
  LD A,E                  ; A=1, 5, 10 or 20
  JP CHGBUCKS_1           ; Add this number of bucks to Sam's total and print
                          ; the new total

; Command list; Keep guard at no. 15
;
; Used by the gangster at no. 15 (see C224MODE1).
CLIST01;
  DEFW WAITFORSAM         ; Lie in wait for Sam
  DEFW 62981              ; Carry Sam to and drop him off...
  DEFB 216,13             ; ...the roof of no. 19
  DEFW RESETHOOD          ; Return to the second floor of no. 15 and restart
                          ; the command list

; Check whether a gangster is close enough to Sam to pick him up
;
; Used by the routines at WAITFORSAM and HOODTOSAM2. Makes the gangster start
; or continue running, and returns with the carry flag set if he is close
; enough to Sam to pick him up.
;
; H Gangster's character number (215-224)
RUNFORSAM;
  LD L,3                  ; Set bit 7 of byte 3 of the gangster's buffer to
  SET 7,(HL)              ; make him run
  JP CHKNEARSAM           ; Check whether the gangster is close enough to Sam
                          ; to pick him up

; Make the gangster at no. 15 lie in wait for Sam
;
; Used by the command list at CLIST01.
;
; H 224 (Gangster)
WAITFORSAM;
  CALL RUNFORSAM          ; Is the gangster close enough to Sam to pick him up?
  RET NC                  ; Return if not
  JP LIFTSAM              ; Make the gangster pick Sam up

; Make a sound effect
;
; Used by the routines at SHOTSOUND (to make the sound effect of Sam being
; shot) and FIRESOUND (to make the sound effect of a sniper firing).
;
; A Initial border colour
; D Pitch adjustment
; E Initial pitch
SNDEFFECT1;
  ADD A,17                ; Flip bit 4 of A and increment the border colour in
                          ; bits 0-2
  AND 23                  ; Retain only bits 0-2 and 4
  OUT (254),A             ; Change the border colour and speaker state
  LD B,E                  ; Perform the pitch delay
SNDEFFECT1_0;
  DJNZ SNDEFFECT1_0       ;
  LD B,A                  ; Save A briefly
  LD A,E                  ; Adjust the pitch delay for the next pass
  ADD A,D                 ;
  LD E,A                  ;
  LD A,B                  ; Restore A
  JR NZ,SNDEFFECT1        ; Jump back unless the pitch delay is now 0
  RET

; Unused
  DEFB 0

; Potential x-coordinates for the sniper
;
; Used by the routine at MVSNIPER1.
SNIPERLOCS;
  DEFB 39,46              ; Left and right sides of the doorsteps of no. 74
  DEFB 111                ; Left side of the doorsteps of no. 31
  DEFB 153                ; No. 27
  DEFB 207                ; Left side of the doorsteps of no. 19
  DEFB 233                ; No. 17
  DEFB 249                ; No. 15

; Unused
;
; The bytes here look like remnants of the table of potential sniper
; x-coordinates at SNIPERLOCS.
  DEFB 207,241,233,255,249

; Control the sniper while active
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of the sniper's buffer by the routine at MVSNIPER1. It controls the
; sniper from the moment he appears until he hides again.
;
; H 227 (sniper)
MVSNIPER2;
  LD L,2                  ; A=sniper's y-coordinate
  LD A,(HL)               ;
  LD L,17                 ; Point HL at byte 17 of the sniper's buffer
  INC (HL)                ; Is it zero (meaning the sniper has not fired
  DEC (HL)                ; recently)?
  JR Z,MVSNIPER2_0        ; Jump if so
  DEC (HL)                ; Otherwise decrement byte 17
MVSNIPER2_0;
  DEC L                   ; L=16
  CP 50                   ; The sniper's y-coordinate is 50 when he's inactive
  JR NZ,MVSNIPER2_2       ; Jump if the sniper is currently active
; The sniper is currently inactive.
  DEC (HL)                ; Decrement byte 16 of the sniper's buffer
  JP Z,NEXTCMD_0          ; Terminate this subcommand if byte 16 is now 0
  CALL SAMINRANGE         ; Is the sniper on screen at least 8 x-coordinates
                          ; away from Sam?
  NOP
  JP NZ,NEXTCMD_0         ; Terminate this subcommand if not
  INC L                   ; Point HL at byte 2 of the sniper's buffer
  LD (HL),37              ; Set the sniper's y-coordinate to 37 (out of sight,
                          ; but ready to emerge)
  LD A,(58881)            ; A=Sam's x-coordinate
  DEC L                   ; L=1
  SUB (HL)                ; Subtract the sniper's x-coordinate
  CCF                     ; Compute the appropriate animatory state for the
  LD A,108                ; sniper; 54 if he's to the right of Sam, 182 if he's
  RRA                     ; to the left
  DEC HL                  ; Set the sniper's animatory state
  LD (HL),A               ;
; This entry point is used by the routine at FIRESOUND.
MVSNIPER2_1;
  LD L,2                  ; Collect the sniper's x- and y-coordinates in DE
  LD D,(HL)               ;
  DEC HL                  ;
  LD E,(HL)               ;
  DEC HL                  ; A=sniper's animatory state
  LD A,(HL)               ;
  JP UPDSNIPER            ; Update the sniper's sprite tile references
; The sniper is currently active (his y-coordinate is 34-37).
MVSNIPER2_2;
  LD A,(57014)            ; Collect the sprite tile reference for tile 7 of
                          ; animatory states 54/182; this will be 235 if the
                          ; sniper is firing, or 0, 110, 111 or 113 otherwise
  CP H                    ; Is the sniper firing?
  JP NC,FIRESOUND         ; If so, make the firing sound effect
  LD A,(TOPROW)           ; A=y-coordinate of the topmost row of the play area
                          ; on screen
  CP 20                   ; Is the sidewalk on screen?
  JR NZ,MVSNIPER2_3       ; If not, deactivate the sniper and terminate this
                          ; subcommand
  DEC (HL)                ; Decrement byte 16 of the sniper's buffer
  JR NZ,MVSNIPER2_8       ; Jump unless byte 16 is now zero
; Byte 16 of the sniper's buffer has been decremented to zero. The apparent
; intention here is to make the sniper duck out of sight and terminate this
; subcommand; however, if the sniper is not already out of sight, he will duck
; briefly but remain in view, and byte 16 will be decremented to 255 on the
; next pass through this routine. This is a bug.
  CALL UPDATESRB          ; Update the SRB for the sniper's current animatory
                          ; state and location
  LD A,D                  ; A=sniper's y-coordinate
  CP 37                   ; Is the sniper currently out of sight?
  JR NZ,MVSNIPER2_5       ; Jump if not to make him duck
MVSNIPER2_3;
  LD L,15                 ; Remove the address of this routine from bytes 14
  LD (HL),0               ; and 15 of the sniper's buffer
MVSNIPER2_4;
  LD L,2                  ; Set the sniper's y-coordinate to 50 (inactive)
  LD (HL),50              ;
  RET
; The sniper is in the process of ducking.
MVSNIPER2_5;
  INC D                   ; D=sniper's next y-coordinate (35-37)
MVSNIPER2_6;
  LD L,0                  ; Point HL at byte 0 of the sniper's buffer
  LD A,(HL)               ; A=sniper's animatory state
MVSNIPER2_7;
  AND A                   ; Reset the carry flag to indicate that the sniper is
                          ; not firing
  JP UPDSNIPER            ; Update the sniper's sprite tile references
; Byte 16 of the sniper's buffer is not zero.
MVSNIPER2_8;
  CALL SAMINRANGE         ; Compare the sniper's coordinates with Sam's
  JR Z,MVSNIPER2_9        ; Jump if the sniper is on screen and at least 8
                          ; x-coordinates away from Sam
  JR NC,MVSNIPER2_3       ; Terminate this subcommand if the sniper if off
                          ; screen
  CALL UPDATESRB          ; Update the SRB for the sniper's current animatory
                          ; state and location
  LD A,D                  ; A=sniper's y-coordinate
  CP 37                   ; Has the sniper already ducked out of sight?
  JR NZ,MVSNIPER2_5       ; Jump if not to make the sniper continue ducking
  JR MVSNIPER2_4          ; Deactivate the sniper
; The sniper is on screen and at least 8 x-coordinates away from Sam. If he's
; already popped his head out far enough (his y-coordinate is 34 or 35), he can
; consider shooting; otherwise he'll need to emerge a little further first.
MVSNIPER2_9;
  LD L,2                  ; Point HL at byte 2 of the sniper's buffer
  LD A,(HL)               ; A=sniper's y-coordinate
  CP 36                   ; Is at least half of the sniper visible?
  JR C,MVSNIPER2_10       ; Jump if so
  CALL UPDATESRB          ; Update the SRB for the sniper's current animatory
                          ; state and location
  DEC D                   ; D=sniper's next y-coordinate (35 or 36)
  JR MVSNIPER2_7          ; Jump back to update the sniper's sprite tile
                          ; references
; At least half of the sniper is visible (his y-coordinate is 34 or 35), which
; means he can shoot.
MVSNIPER2_10;
  LD L,16                 ; Collect byte 16 of the sniper's buffer
  LD A,(HL)               ;
  AND 3                   ; Is bit 0 or bit 1 set?
  JR NZ,MVSNIPER2_11      ; Jump if so
  CALL GETRANDOM          ; Get a random number in A
  CP 160                  ; Should the sniper consider shooting?
  JR C,MVSNIPER2_11       ; Jump if so (5 times out of 8)
  CALL UPDATESRB          ; Update the SRB for the sniper's current animatory
                          ; state and location
  LD A,D                  ; A=sniper's y-coordinate (34 or 35)
  XOR 1                   ; Toggle between 34 and 35
  LD D,A                  ; D=sniper's next y-coordinate (35 or 34)
  JR MVSNIPER2_6          ; Jump back to update the sniper's sprite tile
                          ; references
; The sniper will consider shooting.
MVSNIPER2_11;
  LD A,(58884)            ; A=Sam's z-coordinate
  RRCA                    ; Is Sam indoors?
  RET C                   ; Return if so
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND 129                 ; Is Sam falling from a building or being carried?
  RET NZ                  ; Return if so
  LD L,17                 ; Collect byte 17 of the sniper's buffer
  LD A,(HL)               ;
  AND A                   ; Has the sniper fired recently?
  RET NZ                  ; Return if so
  CALL GETRANDOM          ; Get a random number in A
  CP 84                   ; Should the sniper continue to consider shooting?
  RET NC                  ; Return if not (21 times out of 64)
  LD DE,32706             ; Point DE at the third byte of bullet buffer 1 (at
                          ; BULLET1)
  LD A,(DE)               ; Pick this up in A
  AND A                   ; Is bullet buffer 1 in use?
  JR Z,MVSNIPER2_12       ; Jump if not
  LD E,198                ; Point DE at the third byte of bullet buffer 2 (at
                          ; BULLET2)
  LD A,(DE)               ; Pick this up in A
  AND A                   ; Is bullet buffer 2 in use?
  RET NZ                  ; Return if so
; The sniper has decided to shoot, and a bullet buffer is available.
MVSNIPER2_12;
  LD (HL),12              ; Place 12 into byte 17 of the sniper's buffer
                          ; (indicating that he's just fired)
  CALL UPDATESRB          ; Update the SRB for the sniper's current animatory
                          ; state and location
  SCF                     ; Set the carry flag to indicate that the sniper is
                          ; firing
  JP UPDSNIPER            ; Update the sniper's sprite tile references and
                          ; initialise a bullet

; Unused
  DEFB 0

; Control the sniper
;
; Used by the command list at CLIST10. Checks whether conditions are right for
; the sniper to appear, and if they are, hands over control to the
; interruptible subcommand routine at MVSNIPER2.
;
; H 227 (sniper)
MVSNIPER1;
  LD A,(TOPROW)           ; TOPROW holds the y-coordinate of the topmost row of
                          ; the play area on screen
  CP 20                   ; Is the sidewalk on screen at the moment?
  RET NZ                  ; Return if not
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND 129                 ; Is Sam being carried or falling from a building at
                          ; the moment?
  RET NZ                  ; Return if so
  LD L,3                  ; Set bit 7 of byte 3 of the sniper's buffer, making
  SET 7,(HL)              ; him move quickly
  LD L,10                 ; Decrement and then collect byte 10 of the sniper's
  DEC (HL)                ; buffer
  LD A,(HL)               ;
  AND 15                  ; Are any of bits 0-3 set?
  RET NZ                  ; Return if so (15 times out of 16)
; Now we check how many keys Sam has collected. The exact number in Sam's
; possession affects the probability that the sniper will appear.
  LD A,(KEYINV)           ; Collect the key inventory flags from KEYINV
  LD B,31                 ; B=31 if Sam has no keys or one key, 63 if he has
MVSNIPER1_0;
  ADD A,A                 ; two keys, 127 if he has three, or 255 if he has all
  JR Z,MVSNIPER1_1        ; four
  JR NC,MVSNIPER1_0       ;
  RL B                    ;
  JR MVSNIPER1_0          ;
MVSNIPER1_1;
  CALL GETRANDOM          ; Get a random number in A
  CP B                    ; Is A>=B?
  RET NC                  ; Return if so
; The dice are telling us that the sniper should appear. But can we find a
; suitable spot for him?
  LD DE,SNIPERLOCS        ; Point DE at the table of potential x-coordinates
                          ; for the sniper at SNIPERLOCS
  LD L,1                  ; Point HL at byte 1 of the sniper's buffer
  LD B,7                  ; There are 7 entries in the table
MVSNIPER1_2;
  LD A,(DE)               ; A=potential x-coordinate for the sniper
  INC E                   ; Point DE at the next potential x-coordinate
  LD (HL),A               ; Set the sniper's x-coordinate for testing
  CALL SAMINRANGE_0       ; Would this bring the sniper on screen no less than
                          ; 8 x-coordinates away from Sam?
  JR Z,MVSNIPER1_3        ; Jump if so
  DJNZ MVSNIPER1_2        ; Otherwise consider the next potential x-coordinate
  RET
; We have found a suitable place for the sniper to emerge from.
MVSNIPER1_3;
  LD L,17                 ; Byte 17 of the sniper's buffer is used to regulate
  LD (HL),A               ; the delay between shots; initialise it to 0
  DEC L                   ; L=16
  CALL GETRANDOM          ; Get a random number in A
  AND 15                  ; Byte 16 of the sniper's buffer is used to decide
  ADD A,10                ; when to duck and when to shoot; initialise it to a
  LD (HL),A               ; number between 10 and 25
  LD BC,MVSNIPER2         ; Copy the address of the interruptible subcommand
  JP EXECISC              ; routine at MVSNIPER2 into bytes 14 and 15 of the
                          ; sniper's buffer, and then jump to it

; Make a gangster chase Sam
;
; Used by the command lists at CLIST04, CLIST05, CLIST06, CLIST07 and CLIST11.
; Makes a gangster start or continue chasing Sam (unless Sam is already being
; carried or is falling from the roof of a building).
;
; H Gangster's character number (215-224)
HOODTOSAM1;
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND 129                 ; Is Sam already being carried, or falling from the
                          ; roof of a building?
  JP Z,HOODTOSAM2         ; Jump if not
  RET

; Unused
  DEFB 201

; Banknote animation table
;
; Used by the routine at MVBANKNOTE. This animation table contains 5 entries of
; 5 bytes each, which are used to determine how far up, down or to the right
; the banknote should move next. The algorithm used is as follows;
;
; +------+--------------------------------------------------------------------+
; | Step | Description                                                        |
; +------+--------------------------------------------------------------------+
; | 1    | Determine which entry to use based on the banknote's height above  |
; |      | the ground                                                         |
; | 2    | Generate a random number, R, between 0 and 255                     |
; | 3    | Find the index, J, of the first byte in the entry that is greater  |
; |      | than R (J=0-4, or 5 if there is no such byte)                      |
; | 4    | Increment the banknote's x-coordinate if J<=2, or leave it alone   |
; |      | if J>2                                                             |
; | 5    | Increment the banknote's y-coordinate if J=0 or 3, decrement it if |
; |      | J=1 or 4, or leave it alone if J=2 or 5                            |
; +------+--------------------------------------------------------------------+
;
; The first entry is used when the banknote's height above the ground is -1.
; This can only happen when the banknote is below but adjacent to the sidewalk,
; having recently moved right from a spot at a height of 0 above the road. The
; probabilities with which the banknote's x- and y-coordinates will be adjusted
; are as follows;
;
; +-----+-----+---------+-------+-----+
; | x   | x+1 | y-1     | y     | y+1 |
; +-----+-----+---------+-------+-----+
; | 1/4 | 3/4 | 255/256 | 1/256 | 0   |
; +-----+-----+---------+-------+-----+
NOTEANIM;
  DEFB 0,192,192,192,255  ; J will be 1 (with probability 3/4), 4 (63/256) or 5
                          ; (1/256)
; The next entry is used when the banknote's height above the ground is 0 (i.e.
; it is on the road or sidewalk).
;
; +------+-------+------+-------+-----+
; | x    | x+1   | y-1  | y     | y+1 |
; +------+-------+------+-------+-----+
; | 3/16 | 13/16 | 7/32 | 25/32 | 0   |
; +------+-------+------+-------+-----+
  DEFB 0,48,208,208,216   ; J will be 1 (with probability 3/16), 2 (5/8), 4
                          ; (1/32) or 5 (5/32)
; The next entry is used when the banknote's height above the ground is 1.
;
; +-----+-----+-----+-------+-------+
; | x   | x+1 | y-1 | y     | y+1   |
; +-----+-----+-----+-------+-------+
; | 3/8 | 5/8 | 1/8 | 15/32 | 13/32 |
; +-----+-----+-----+-------+-------+
  DEFB 72,88,160,192,208  ; J will be 0 (with probability 9/32), 1 (1/16), 2
                          ; (9/32), 3 (1/8), 4 (1/16) or 5 (3/16)
; The next entry is used when the banknote's height above the ground is 2.
;
; +-----+-----+-----+-----+-----+
; | x   | x+1 | y-1 | y   | y+1 |
; +-----+-----+-----+-----+-----+
; | 3/8 | 5/8 | 0   | 1/4 | 3/4 |
; +-----+-----+-----+-----+-----+
  DEFB 128,128,160,224,224 ; J will be 0 (with probability 1/2), 2 (1/8), 3
                           ; (1/4) or 5 (1/8)
; The final entry is used when the banknote's height above the ground is 3.
; This can only happen when the banknote is above the road, having recently
; moved right from a spot at a height of 2 above the sidewalk.
;
; +-----+-----+-----+-------+---------+
; | x   | x+1 | y-1 | y     | y+1     |
; +-----+-----+-----+-------+---------+
; | 1/4 | 3/4 | 0   | 1/256 | 255/256 |
; +-----+-----+-----+-------+---------+
  DEFB 192,192,192,255,255 ; J will be 0 (with probability 3/4), 3 (63/256) or
                           ; 5 (1/256)

; Control a banknote
;
; Used by the command list at CLIST09. Calculates and sets the banknote's next
; animatory state and location. If the banknote is far enough off-screen to the
; left or right, it will be moved to a location just off-screen to the left.
;
; H 228 or 229 (banknote)
MVBANKNOTE;
  LD A,(OBJINV)           ; OBJINV holds Sam's object inventory
  RLCA                    ; Has Sam got the hook (bit 6 set)?
  RLCA                    ;
  JR NC,MVBANKNOTE_0      ; Jump if not
; Sam's got the hook; we bring this banknote out of service so that its
; character buffer is available for use by the hook when it's thrown. However,
; the banknote is not removed from view, which is a bug.
  CALL UPDATESRB          ; Update the SRB for the banknote's current animatory
                          ; state and location
  CALL CHGPRICMD          ; Change the banknote's primary command routine
                          ; address to FREEZENOTE (below)
FREEZENOTE;
  RET
; This entry point is used by the command list at CLIST08.
MVBANKNOTE_0;
  LD L,10                 ; Collect byte 10 of the banknote's buffer
  LD A,(HL)               ;
  AND A                   ; Reset the zero flag if Sam has just landed on this
                          ; banknote
  LD (HL),0               ; Set byte 10 to zero
  JR NZ,MVBANKNOTE_2      ; Jump if Sam has just landed on this banknote
; First we check whether the banknote is far off-screen to the left or right.
  LD L,1                  ; Point HL at byte 1 of the banknote's buffer
  LD A,(LEFTCOL)          ; A=X (the x-coordinate of the leftmost column of the
                          ; play area on screen)
  SUB 12                  ; Is X=0 or 8?
  JR C,MVBANKNOTE_1       ; Jump if so
  CP (HL)                 ; Is the banknote's x-coordinate greater than X-12?
  JR NC,MVBANKNOTE_2      ; Jump if not
MVBANKNOTE_1;
  ADD A,60                ; A=X+48
  JR C,MVBANKNOTE_4       ; Jump if X=0, 8, 208, 216 or 224
  CP (HL)                 ; Is the banknote's x-coordinate greater than X+48?
  JR NC,MVBANKNOTE_4      ; Jump if not
; The banknote is off-screen to the left by at least 12 x-coordinates, or it's
; off-screen to the right by at least 17 x-coordinates, or it's just been
; landed on by Sam. Time to reinitialise its animatory state and location.
MVBANKNOTE_2;
  CALL UPDATESRB          ; Update the SRB for the banknote's current animatory
                          ; state and location
  LD D,34                 ; Initialise the banknote's y-coordinate to 34
  LD A,(LEFTCOL)          ; A=X (the x-coordinate of the leftmost column of the
                          ; play area on screen)
  SUB 11                  ; Is X>8?
  JR NC,MVBANKNOTE_3      ; Jump if so
  SBC A,A                 ; A=255
MVBANKNOTE_3;
  LD E,A                  ; E=255 (if X<=8) or X-11
  JR MVBANKNOTE_5
; The banknote is on-screen or not far off it. Now we calculate the banknote's
; next animatory state and location.
MVBANKNOTE_4;
  CALL UPDATESRB          ; Update the SRB for the banknote's current animatory
                          ; state and location
MVBANKNOTE_5;
  PUSH AF                 ; Save the banknote's current animatory state briefly
  CALL GETRANDOM          ; Get a random number in A
  LD C,A                  ; Copy it to C
  AND 136                 ; Keep only bits 3 and 7
  ADD A,62                ; B=62, 70, 190, or 198 (banknote animatory states)
  LD B,A                  ;
  POP AF                  ; Restore the banknote's current animatory state to A
  CP B                    ; Is it equal to B?
  JR Z,MVBANKNOTE_5       ; Jump back to generate another animatory state if so
; At this point B holds the banknote's next animatory state. Now we calculate
; its next location.
  LD A,B                  ; A=banknote's next animatory state
  PUSH AF                 ; Save this briefly
  CALL RDORSWALK_1        ; Set the carry flag if the banknote is above the
                          ; road (as opposed to the sidewalk)
  ADC A,45                ; A=45 if the banknote is above the sidewalk, or 46
  SUB E                   ; if it's above the road
  SUB D                   ; Subtract the banknote's current y-coordinate
                          ; (32-35); now A=11+G, where G (-1<=G<=3) is the
                          ; height of the banknote above the ground
  LD B,A                  ; Multiply this value by 5 and add 1 (A=51, 56, 61,
  ADD A,A                 ; 66, or 71)
  ADD A,A                 ;
  ADD A,B                 ;
  INC A                   ;
  PUSH HL                 ; Save the banknote's character number
  LD L,A                  ; Point HL at the entry in the banknote animation
  LD H,99                 ; table at NOTEANIM that corresponds to the
                          ; banknote's height above the ground
  LD A,C                  ; A=random number generated earlier
  LD BC,1283              ; B=5 (number of bytes in the entry), C=3
MVBANKNOTE_6;
  CP (HL)                 ; Find the first byte in the entry that is greater
  JR C,MVBANKNOTE_7       ; than A
  INC HL                  ;
  DJNZ MVBANKNOTE_6       ;
MVBANKNOTE_7;
  LD A,B                  ; A=0-5
  CP C                    ; Is A<3?
  JR C,MVBANKNOTE_8       ; Jump if so
  INC E                   ; Otherwise increment the banknote's x-coordinate
  SUB C                   ; A=0-2
MVBANKNOTE_8;
  ADD A,A                 ; A=0, 2 or 4
  JR Z,MVBANKNOTE_9       ; Jump if A=0
  SUB C                   ; A=-1 or 1
MVBANKNOTE_9;
  ADD A,D                 ; Add -1, 0 or 1 to the banknote's current
  LD D,A                  ; y-coordinate
  POP HL                  ; Restore the banknote's character number to H
  POP AF                  ; Restore the banknote's next animatory state to A
  JP UPDATEAS             ; Update the banknote's animatory state and location
                          ; and update the SRB

; Check whether Sam has somersaulted onto a banknote
;
; Used by the routine at SOMERSAULT. Compares Sam's location with those of the
; two banknotes. If there's a match, and Sam has just finished a somersault,
; the banknote is added to Sam's cash supply.
;
; HL 58892 (byte 12 of Sam's buffer)
GOTNOTE;
  BIT 5,(HL)              ; Byte 12 of Sam's buffer holds the LSB of the
                          ; current roll/somersault animation phase table entry
  RET Z                   ; Return if Sam was rolling
  LD L,1                  ; Collect Sam's x- and y-coordinates in E and D
  LD E,(HL)               ;
  INC L                   ;
  LD D,(HL)               ;
  LD B,L                  ; B=2 (there are 2 banknotes)
GOTNOTE_0;
  DEC H                   ; H=228 or 229
  LD A,D                  ; A=Sam's y-coordinate
  CP (HL)                 ; Compare it with the banknote's y-coordinate
  DEC HL                  ; Point HL at byte 1 of the banknote's buffer
  JR NZ,GOTNOTE_1         ; Jump unless Sam's y-coordinate matches the
                          ; banknote's
  LD A,E                  ; A=Sam's x-coordinate
  CP (HL)                 ; Has Sam landed on a banknote?
  JR Z,GOTNOTE_2          ; Jump if so
GOTNOTE_1;
  INC HL                  ; Point HL at byte 2 of the banknote's buffer
  DJNZ GOTNOTE_0          ; Jump back until both banknotes have been checked
  RET
; Sam has landed on something that is using one of the banknote buffers. Here
; we check that the object looks like a banknote. But this check is redundant,
; since no object except a banknote or the hook can use buffer 228 or 229, and
; Sam cannot land on the hook.
GOTNOTE_2;
  DEC L                   ; L=0
  LD A,(HL)               ; A=banknote's animatory state
  AND 127                 ; Discard bit 7
  SUB 62                  ; Is the banknote's animatory state 62 or 190?
  JR Z,GOTNOTE_3          ; Jump if so
  SUB 8                   ; Is the banknote's animatory state 70 or 198?
  RET NZ                  ; Return if not (this never happens)
; Sam has landed on something that looks like a banknote.
GOTNOTE_3;
  LD L,10                 ; Set byte 10 of the banknote's buffer to 1 to
  INC (HL)                ; indicate that Sam's just landed on it (see
                          ; MVBANKNOTE)
  CALL ADDRBUCKS          ; Add 1, 5, 10 or 20 bucks to Sam's total
; Finally we make an appropriate sound effect.
  XOR A                   ; Prepare the sound effect parameters; A=0 (initial
  LD DE,1529              ; border colour), D=5 (duration), E=249 (initial
                          ; pitch)
GOTNOTE_4;
  INC A                   ; Increment the border colour
  XOR 16                  ; Flip bit 4 of A
  AND 23                  ; Retain only bits 0-2 (border colour) and 4 (speaker
                          ; state)
  OUT (254),A             ; Change the border colour and speaker state
  LD B,E                  ; Perform the pitch delay
GOTNOTE_5;
  DJNZ GOTNOTE_5          ;
  DEC E                   ; Decrement the pitch delay
  JR NZ,GOTNOTE_4         ; Jump back unless it's zero
  DEC D                   ; Decrement the duration counter
  JR NZ,GOTNOTE_4         ; Jump back unless it's zero
  RET

; Copy source sprite tiles over target sprite tiles
;
; Used by the routine at PREPTILES to prepare sprite tiles 239-247, which are
; used by animatory states 9, 10, 15 and 31 (corresponding to the sprites of
; Sam rolling and somersaulting).
;
; C Number of tiles to copy
; E Target sprite tile reference
; L Source sprite tile reference
COPYTILES;
  LD H,199                ; This is the base page of the graphic data for the
                          ; source tile
; This entry point is used by the routine at PREPTILES with H=215.
COPYTILES_0;
  LD D,199                ; This is the base page of the graphic data for the
                          ; target tile
  LD B,16                 ; Copy the source sprite tile over the target sprite
COPYTILES_1;
  LD A,(HL)               ; tile (8 bytes of graphic data interleaved with 8
  LD (DE),A               ; bytes of mask data)
  INC H                   ;
  INC D                   ;
  DJNZ COPYTILES_1        ;
  INC L                   ; Move to the next source sprite tile reference
  INC E                   ; Move to the next target sprite tile reference
  DEC C                   ; Have all the sprite tiles been copied yet?
  JR NZ,COPYTILES         ; Jump back if not
  RET

; Prepare sprite tiles used by Sam when somersaulting or rolling
;
; Used by the routine at SOMERSAULT. Animatory states 9, 10, 15 and 31 -
; corresponding to the sprites of Sam rolling and somersaulting - use sprite
; tiles 239-247. These sprite tiles are initialised before Sam starts his
; acrobatic manoeuvre, and later rotated as he moves through each phase of
; animation.
PREPTILES;
  LD L,2                  ; Copy sprite tiles 2-7 over sprite tiles 239-244
  LD E,239                ;
  LD C,6                  ;
  CALL COPYTILES          ;
  LD E,242                ; Copy sprite tile 170 over sprite tile 242
  LD L,170                ;
  INC C                   ;
  CALL COPYTILES          ;
  LD A,181                ; Copy sprite tiles 181, 189 and 197 from base page
  LD E,245                ; 215 over sprite tiles 245-247
PREPTILES_0;
  LD L,A                  ;
  LD H,215                ;
  INC C                   ;
  CALL COPYTILES_0        ;
  LD A,L                  ;
  ADD A,7                 ;
  CP 205                  ;
  JR NZ,PREPTILES_0       ;
  LD B,8                  ; Superimpose sprite tile 205 from base page 215 over
  LD HL,55245             ; sprite tile 243 (which is currently a copy of
  LD DE,51187             ; sprite tile 6, the centre tile of Sam's base
PREPTILES_1;
  LD A,(DE)               ; animatory state); this makes Sam appear to bend his
  OR (HL)                 ; arms and hold his knees while performing the
  INC H                   ; acrobatic feat, at the expense of losing some
  AND (HL)                ; detail from his current disguise
  INC H                   ;
  LD (DE),A               ;
  INC D                   ;
  LD (DE),A               ;
  INC D                   ;
  DJNZ PREPTILES_1        ;
; This entry point is used by the routine at SOMERSAULT. Here we rotate sprite
; tiles 239-247 and store the results in sprite tile slots 238-246.
PREPTILES_2;
  LD L,239                ; Tile 239 is the first source tile
PREPTILES_3;
  LD E,L                  ; E=238 (the first target tile)
  DEC E                   ;
  LD D,199                ; The base page for these tiles is 199
  LD B,8                  ; Rotate the source sprite tile 90 degrees
PREPTILES_4;
  LD H,198                ; anticlockwise and copy it over the target sprite
  LD C,1                  ; tile
PREPTILES_5;
  INC H                   ;
  RRC (HL)                ;
  RLA                     ;
  INC H                   ;
  RRC (HL)                ;
  RL C                    ;
  JR NC,PREPTILES_5       ;
  LD (DE),A               ;
  INC D                   ;
  LD A,C                  ;
  LD (DE),A               ;
  INC D                   ;
  DJNZ PREPTILES_4        ;
  INC L                   ; Move to the next source sprite tile reference
  BIT 3,L                 ; Have we rotated sprite tiles 239-247 yet?
  JR Z,PREPTILES_3        ; Jump back if not
; Next we move sprite tiles 238-246 up to 239-247.
  LD A,16                 ; There are 16 bytes of graphic and mask data in each
                          ; tile
PREPTILES_6;
  LD E,247                ; Copy sprite tiles 238-246 into slots 239-247
  LD L,246                ;
  LD C,9                  ;
  DEC D                   ;
  LD H,D                  ;
  LDDR                    ;
  DEC A                   ;
  JR NZ,PREPTILES_6       ;
  RET                     ; Return with the zero flag set

; Unused
  DEFB 0

; Animation phase table for Sam when rolling
;
; Used by the routine at ROLL. Each entry in this table comprises 4 bytes. The
; first entry corresponds to animation phase 1.
ROLLANIM;
  DEFB 0                  ; x-coordinate increment (if facing left)
  DEFB 0                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 6                  ; Bits 0-6; base animatory state (6); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 2.
  DEFB 253                ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 2                  ; y-coordinate increment
  DEFB 15                 ; Bits 0-6; base animatory state (15); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 3.
  DEFB 1                  ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 255                ; y-coordinate increment
  DEFB 9                  ; Bits 0-6; base animatory state (9); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 4.
  DEFB 254                ; x-coordinate increment (if facing left)
  DEFB 0                  ; x-coordinate increment (if facing right)
  DEFB 2                  ; y-coordinate increment
  DEFB 31                 ; Bits 0-6; base animatory state (31); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 5.
  DEFB 1                  ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 252                ; y-coordinate increment
  DEFB 138                ; Bits 0-6; base animatory state (10); bit 7 set;
                          ; check whether Sam has landed on his feet
; The next entry corresponds to animation phase 6.
  DEFB 255                ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 128                ; Bits 0-6; base animatory state (0); bit 7 set;
                          ; check whether Sam has landed on his feet

; Animation phase table for Sam when somersaulting
;
; Used by the routine at SOMERSAULT. Each entry in this table comprises 4
; bytes. The first entry corresponds to animation phase 1.
SSAULTANIM;
  DEFB 0                  ; x-coordinate increment (if facing left)
  DEFB 0                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 6                  ; Bits 0-6; base animatory state (6); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 2.
  DEFB 0                  ; x-coordinate increment (if facing left)
  DEFB 0                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 0                  ; Bits 0-6; base animatory state (0); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 3.
  DEFB 253                ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 15                 ; Bits 0-6; base animatory state (15); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 4.
  DEFB 1                  ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 254                ; y-coordinate increment
  DEFB 9                  ; Bits 0-6; base animatory state (9); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 5.
  DEFB 255                ; x-coordinate increment (if facing left)
  DEFB 255                ; x-coordinate increment (if facing right)
  DEFB 3                  ; y-coordinate increment
  DEFB 31                 ; Bits 0-6; base animatory state (31); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 6.
  DEFB 1                  ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 253                ; y-coordinate increment
  DEFB 10                 ; Bits 0-6; base animatory state (10); bit 7 reset;
                          ; Sam cannot land on his feet yet
; The next entry corresponds to animation phase 7.
  DEFB 255                ; x-coordinate increment (if facing left)
  DEFB 1                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 128                ; Bits 0-6; base animatory state (0); bit 7 set;
                          ; check whether Sam has landed on his feet
; The next entry corresponds to animation phase 8.
  DEFB 0                  ; x-coordinate increment (if facing left)
  DEFB 0                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 128                ; Bits 0-6; base animatory state (0); bit 7 set;
                          ; check whether Sam has landed on his feet
; The next entry corresponds to animation phase 9.
  DEFB 0                  ; x-coordinate increment (if facing left)
  DEFB 0                  ; x-coordinate increment (if facing right)
  DEFB 0                  ; y-coordinate increment
  DEFB 128                ; Bits 0-6; base animatory state (0); bit 7 set;
                          ; check whether Sam has landed on his feet

; 'R' pressed - forward roll
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'R' is
; pressed.
ROLL;
  LD HL,ROLLANIM          ; The animation phase table for Sam when rolling is
                          ; at ROLLANIM
  JR SOMERSAULT_0

; 'S' pressed - somersault
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'S' is
; pressed.
SOMERSAULT;
  LD HL,SSAULTANIM        ; The animation phase table for Sam when
                          ; somersaulting is at SSAULTANIM
; This entry point is used by the routine at ROLL with HL=ROLLANIM.
SOMERSAULT_0;
  PUSH HL                 ; Save the address of the animation phase table
  CALL CANROLL            ; Return to the main loop if Sam cannot roll or
                          ; somersault from his current location
  LD A,8                  ; Set bit 3 of Sam's status flags at STATUS
  LD (STATUS),A           ;
  POP HL                  ; Restore the address of the animation phase table to
                          ; HL
  LD (58892),HL           ; Copy the address of the animation phase table into
                          ; bytes 12 and 13 of Sam's buffer
; This entry point is used by the routine at HANDLESAM when bit 3 at STATUS is
; set (by this routine - see above).
SOMERSAULT_1;
  LD HL,58888             ; Reset Sam's main action timer (in byte 8 of his
  LD (HL),6               ; buffer) to 6
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  LD HL,(58892)           ; Point HL at the first byte of the current entry in
                          ; the animation phase table
  AND 128                 ; Set the zero flag if Sam is facing left
  LD B,A                  ; B=0 if Sam is facing left, 128 if facing right
  LD A,(HL)               ; A=first byte of the animation phase table entry
  INC HL                  ; Point HL at the second byte in the entry
  JR Z,SOMERSAULT_2       ; Jump if Sam is facing left
  LD A,(HL)               ; A=second byte of the animation phase table entry
SOMERSAULT_2;
  ADD A,E                 ; Add Sam's current x-coordinate
  LD E,A                  ; E=Sam's next x-coordinate
  INC HL                  ; A=third byte of the animation phase table entry
  LD A,(HL)               ;
  ADD A,D                 ; Add Sam's current y-coordinate
  LD D,A                  ; D=Sam's next y-coordinate
  INC HL                  ; A=fourth byte of the animation phase table entry
  LD A,(HL)               ;
  INC HL                  ; Point HL at the first byte of the next entry
  LD (58892),HL           ; Store this address in bytes 12 and 13 of Sam's
                          ; buffer
  RLCA                    ; C=Sam's next base animatory state (bit 7 reset)
  AND A                   ;
  RRA                     ;
  LD C,A                  ;
  JR NC,SOMERSAULT_6      ; Jump unless it's time to check whether Sam has
                          ; landed
; It's time to check whether Sam has landed on his feet yet.
  PUSH DE                 ; Save Sam's new coordinates briefly
  AND A                   ; Is Sam's next animatory state 0 or 128 (standing
                          ; upright)?
  JR Z,SOMERSAULT_3       ; Jump if so
  DEC E                   ; Subtract 1 from Sam's new x-coordinate
  BIT 7,B                 ; Is Sam facing left?
  JR Z,SOMERSAULT_3       ; Jump if so
  INC E                   ; Add 1 to Sam's new x-coordinate
  INC E                   ;
SOMERSAULT_3;
  CALL RDORSWALK_0        ; Has Sam landed on the sidewalk or the road yet?
  JR NC,SOMERSAULT_4      ; Jump if so
  LD A,E                  ; A=Sam's adjusted new x-coordinate
  POP DE                  ; Restore Sam's new x-coordinate to E
  INC D                   ; Add 1 to Sam's new y-coordinate (move him down a
                          ; level)
  PUSH DE                 ; Save Sam's adjusted new coordinates briefly
  LD E,A                  ; E=Sam's adjusted new x-coordinate
  CALL RDORSWALK_0        ; Set the carry flag unless Sam has landed on the
                          ; sidewalk or road
SOMERSAULT_4;
  POP DE                  ; Restore Sam's adjusted new y-coordinate to D, and
                          ; his new x-coordinate to E
  JR C,SOMERSAULT_5       ; Jump if Sam has not landed yet
  LD A,C                  ; A=Sam's next base animatory state (bit 7 reset)
  AND A                   ; Is it 0 or 128 (standing upright)?
  JR NZ,SOMERSAULT_5      ; Jump if not
  LD (STATUS),A           ; Clear all of Sam's status flags at STATUS (Sam has
                          ; landed)
SOMERSAULT_5;
  LD A,C                  ; A=Sam's next base animatory state (bit 7 reset)
SOMERSAULT_6;
  CP 9                    ; Is the new base animatory state < 9 (meaning Sam
                          ; has just started or is just finishing a roll or
                          ; somersault)?
  JR C,SOMERSAULT_7       ; Jump if so
  PUSH BC                 ; Save Sam's direction indicator and next base
                          ; animatory state
  PUSH DE                 ; Save Sam's next x- and y-coordinates
  CP 15                   ; Is the new base animatory state 15 (meaning Sam is
                          ; going to rotate 90 degrees for the first part of
                          ; the roll or somersault)?
  CALL Z,PREPTILES        ; If so, prepare sprite tiles 239-247 for this
                          ; animatory state
  CALL NZ,PREPTILES_2     ; Otherwise, rotate sprite tiles 239-247 for
                          ; animatory state 9, 31 or 10
  POP DE                  ; Restore Sam's next x- and y-coordinates to E and D
  POP BC                  ; Restore Sam's direction indicator and next base
                          ; animatory state to B and C
SOMERSAULT_7;
  LD H,230                ; 230=Sam
  LD A,B                  ; A=Sam's new animatory state
  OR C                    ;
  CALL UPDATEAS           ; Update Sam's animatory state and location and
                          ; update the SRB
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND A                   ; Has Sam landed yet?
  RET NZ                  ; Return if not
  CALL SNDEFFECT2         ; Make a sound effect
  LD L,12                 ; Point HL at byte 12 of Sam's buffer
  CALL GOTNOTE            ; Check whether Sam has somersaulted onto a banknote
  LD H,230                ; 230=Sam
  JP MVSAM_0              ; Now that Sam has landed, scroll the screen left or
                          ; right if necessary

; Check whether Sam can roll or somersault from his current location
;
; Used by the routine at SOMERSAULT. Returns to the caller if Sam can roll or
; somersault from his current location; otherwise returns to the main loop.
CANROLL;
  LD H,230                ; 230=Sam
  CALL RDORSWALK          ; Is Sam on the sidewalk or the road?
  JR C,CANROLL_1          ; Jump if not
  LD L,0                  ; Point HL at byte 0 of Sam's buffer
  BIT 7,(HL)              ; Reset the zero flag if Sam is facing right
  INC HL                  ; Point HL at byte 1 of Sam's buffer
  LD A,(HL)               ; A=Sam's x-coordinate
  JR NZ,CANROLL_0         ; Jump if Sam is facing right
  CP 4                    ; Return if Sam is facing left and his x-coordinate
  RET NC                  ; is >= 4
  JR C,CANROLL_1          ; Jump if Sam is facing left and his x-coordinate is
                          ; < 4
CANROLL_0;
  CP 250                  ; Return if Sam is facing right and his x-coordinate
  RET C                   ; is < 250
CANROLL_1;
  POP BC                  ; Drop the return address from the stack
  POP BC                  ; Drop the address of the animation phase table from
                          ; the stack
  RET                     ; Return to the main loop at MAINLOOP_3

; Determine Sam's location
;
; Used by the routines at CHKNEARSAM, DESTTOSAM and COPTOSAM. Returns with
; Sam's x-, y- and z-coordinates (adjusted appropriately if Sam is falling,
; rolling, somersaulting or being carried) in E, D and A.
GETSAMXY;
  LD DE,(58881)           ; Collect Sam's x- and y-coordinates in E and D
  LD A,(STATUS)           ; Pick up Sam's status flags from STATUS
  BIT 3,A                 ; Is Sam rolling or somersaulting?
  JR NZ,GETSAMXY_0        ; Jump if so
  AND 129                 ; Is Sam either being carried by a gangster or
                          ; policeman, or falling from the roof of a building?
  LD A,(58884)            ; Return with A holding Sam's z-coordinate if not
  RET Z                   ;
; Sam is either being carried by a policeman, or falling from the roof of a
; building.
  LD A,2                  ; 2=behind people on the sidewalk
  LD DE,9896              ; D=38, E=168 (out of reach)
  RET
; Sam is rolling or somersaulting.
GETSAMXY_0;
  LD A,(SAMCBUF)          ; A=Sam's animatory state
  AND 127                 ; Discard bit 7 (the direction bit)
  CP 15                   ; Is Sam horizontal at the moment (animatory state 15
                          ; or 31)?
  JR C,GETSAMXY_1         ; Jump if not
  INC E                   ; Add 2 to Sam's x-coordinate if he's horizontal
  INC E                   ;
GETSAMXY_1;
  LD A,E                  ; A=x+2 if Sam's horizontal, or x otherwise (where x
                          ; is Sam's x-coordinate)
  CALL RDORSWALK_2        ; Reset the carry flag if Sam is on or above the
                          ; sidewalk, or set it if he's on or above the road
  ADC A,34                ; D=34 if Sam's on or above the sidewalk, 35 if he's
  SUB E                   ; on or above the road
  LD D,A                  ;
  LD A,4                  ; 4=outside
  RET

; Unused
  DEFB 0

; Sprite tile references susceptible to bullet impact
;
; Used by the routine at CHKSHOT. Sprite tiles with references in the range
; 16-25 are used in areas within Sam's sprite that are susceptible to damage if
; hit by a bullet. The references of other such tiles outside that range are
; listed here.
BULLETREFS;
  DEFB 3,6,9,12           ; These are the references of the tiles in the middle
                          ; column of Sam's sprite in animatory states 0 and 2
  DEFB 229,230            ; These are the references of the two leftmost tiles
                          ; in the bottom row of Sam's sprite in animatory
                          ; state 6 (Sam bending his knees)
  DEFB 240,243,245        ; These tiles are used in animatory states 9, 10, 15
                          ; and 31 (Sam in the middle of a roll or somersault)

; Unused
  DEFS 3

; Check whether Sam has been hit by a bullet
;
; Used by the routine at MVBULLETS. Returns with the carry flag set if Sam has
; been hit by a bullet.
;
; D Bullet's next screen y-coordinate (1-20)
; E Bullet's next screen x-coordinate (0-31)
CHKSHOT;
  EXX
  XOR A                   ; Initialise E' to 0; E' may be updated by the call
  LD E,A                  ; to GETTILE_2 below
  EXX
  PUSH HL
  PUSH DE                 ; Save the bullet's screen coordinates
  LD HL,(LEFTCOL)         ; Collect the x- and y-coordinates of the top-left
                          ; tile of the play area on screen in L and H
  ADD HL,DE               ; Add the bullet's screen coordinates
  EX DE,HL                ; Now DE holds the bullet's play area coordinates
  LD HL,58884             ; Point HL at byte 4 of Sam's buffer
  LD A,(HL)               ; A=Sam's z-coordinate
  DEC A                   ; Set the zero flag if Sam's indoors
  CALL GETTILE_2          ; Print the play area tile where the bullet will be
                          ; next (if Sam's not indoors)
  LD A,E                  ; A=reference of the sprite tile (of Sam's) that was
                          ; printed, or 0 if none was printed
  AND A                   ; Was a sprite tile printed?
  JR Z,CHKSHOT_4          ; Jump if not (Sam was not hit)
  CP 16                   ; Was the sprite tile reference in the range 1-15?
  JR C,CHKSHOT_0          ; Jump if so
  CP 26                   ; Was the sprite tile reference in the range 16-25?
  JR C,CHKSHOT_2          ; Jump if so (Sam was hit by the bullet)
; The reference of the sprite tile upon which the bullet impinged was in the
; range 1-15 or greater than 25. Closer examination is required to determine
; whether Sam was hit.
CHKSHOT_0;
  LD HL,BULLETREFS        ; Point HL at the table of sprite tile references at
                          ; BULLETREFS
  LD B,9                  ; There are 9 sprite tile references in the table
CHKSHOT_1;
  CP (HL)                 ; Compare the reference of the sprite tile that was
                          ; printed with a reference from the table
  JR Z,CHKSHOT_2          ; Jump if they match (Sam was hit)
  INC HL                  ; Point HL at the next sprite tile reference in the
                          ; table
  DJNZ CHKSHOT_1          ; Jump back to compare it with the sprite tile that
                          ; was printed
  AND A                   ; Reset the carry flag; Sam was not hit by the bullet
  JR CHKSHOT_4
; Sam was hit by the bullet.
CHKSHOT_2;
  CALL SHOTSOUND          ; Make the sound effect of Sam being hit by a bullet
  LD HL,LIVES             ; LIVES holds the number of remaining first aid kits
  LD A,(HL)               ; Pick this up in A
  ADD A,A                 ; Discard a first aid kit
  LD (HL),A               ;
  JR C,CHKSHOT_3          ; Jump if there was a first aid kit left to discard
; Sam has already used all his first aid kits. Game over.
  LD L,158                ; HL=BUCKS (bucks)
  LD (HL),A               ; Reduce Sam's cash supply to 0
  INC L                   ;
  LD (HL),A               ;
  LD A,99                 ; Message 99; 'I HAD TO GO TO HOSPITAL...'
  JP SCORECASH_0          ; Display the ending cutscene with this message
; Sam had a first aid kit left.
CHKSHOT_3;
  CALL INITMSGFA_0        ; Display any remaining first aid kits
  SCF                     ; Set the carry flag; Sam was hit by the bullet
CHKSHOT_4;
  POP DE                  ; Restore the bullet's screen coordinates to DE
  POP HL
  RET

; Move and draw the bullets
;
; Used by the routine at MNLPTASKS2. For each bullet currently in flight,
; calculates the bullet's next location and draws it there (unless it has hit
; Sam).
MVBULLETS;
  LD HL,BTIMER            ; BTIMER holds the bullet timer
  DEC (HL)                ; Is it time to move and redraw the bullets?
  RET NZ                  ; Return if not
  LD A,(32671)            ; Collect the MSB of Sam's cash supply
  LD C,3                  ; Keep only bits 0 and 1 of the MSB
  AND C                   ;
  XOR C                   ; A=6-A
  ADD A,C                 ;
  LD (HL),A               ; Reinitialise the bullet timer at BTIMER to 3, 4, 5
                          ; or 6
  LD L,192                ; HL=BULLET1 (first byte of bullet buffer 1)
; The following loop checks each bullet to see whether it is in flight or has
; flown off the screen.
MVBULLETS_0;
  LD DE,(LEFTCOL)         ; Collect the x- and y-coordinates of the top-left
                          ; tile of the play area on screen in E and D
  LD A,(HL)               ; A=x-coordinate of the leftmost column of the play
                          ; area that was on screen the last time the bullet
                          ; was drawn
  LD (HL),E               ; Replace that x-coordinate with the current value
  SUB E                   ; A=bullet's current screen x-coordinate
  INC HL                  ;
  ADD A,(HL)              ;
  LD E,A                  ; Copy this to E
  LD (HL),A               ; Also store it in the bullet buffer
  INC HL                  ; Point HL at the third byte of the bullet buffer
  CP 32                   ; Has the bullet flown off screen to the right?
  JR NC,MVBULLETS_1       ; Jump if so
  LD A,(HL)               ; A=bullet's current screen y-coordinate (or 0 if the
                          ; bullet is not in flight)
  AND A                   ; Is the bullet in flight at the moment?
  JR NZ,MVBULLETS_3       ; Jump if so
MVBULLETS_1;
  LD (HL),0               ; Set the third byte of the bullet's buffer to 0,
                          ; indicating that it is not in flight
  INC L                   ; Point HL at the last byte of the bullet buffer
MVBULLETS_2;
  INC L                   ; Point HL at the first byte of the next bullet
                          ; buffer
  BIT 3,L                 ; Have we dealt with both bullets yet?
  JR Z,MVBULLETS_0        ; Jump back if not
  RET
; This bullet is currently in flight.
MVBULLETS_3;
  LD A,D                  ; A=y-coordinate of the topmost row of the play area
                          ; on screen
  CP 20                   ; Is the sidewalk on screen at the moment?
  JR NZ,MVBULLETS_1       ; Terminate the bullet if not
  LD D,(HL)               ; D=bullet's current screen y-coordinate
  PUSH HL                 ; Save the pointer to the bullet buffer
  EX DE,HL                ; Transfer the bullet's screen x- and y-coordinates
                          ; to L and H
  CALL PRINTTILE          ; Print the play area tile at these coordinates, thus
                          ; erasing the bullet
  POP HL                  ; Restore the bullet buffer pointer to HL
  INC HL                  ; Point HL at the fourth byte of the bullet buffer
  LD A,32                 ; Flip bit 5 of this byte
  XOR (HL)                ;
  LD (HL),A               ;
  DEC HL                  ; Point HL at the second byte of the bullet buffer
  DEC HL                  ; (which holds the bullet's screen x-coordinate)
  DEC (HL)                ; Decrement the bullet's screen x-coordinate
  ADD A,A                 ; Is the bullet flying leftwards?
  JR NC,MVBULLETS_4       ; Jump if so
  INC (HL)                ; Otherwise increment the bullet's x-coordinate
  INC (HL)                ;
MVBULLETS_4;
  LD E,(HL)               ; E=bullet's next screen x-coordinate
  INC HL                  ; Point HL at the third byte of the bullet buffer
  BIT 5,E                 ; Would the bullet now be off-screen to the left or
                          ; right?
  JR NZ,MVBULLETS_1       ; Terminate the bullet if so
  ADD A,A                 ; Is the bullet flying perfectly horizontally?
  JR NC,MVBULLETS_6       ; Jump if so
; The bullet is flying at an angle towards the ground or the sky.
  ADD A,A                 ; Push what was bit 5 of the fourth byte of the
                          ; bullet buffer into the carry flag (and ignore it)
  NOP
  NOP
  ADD A,A                 ; Set the carry flag if the bullet is flying towards
                          ; the sky
  INC HL                  ; Point HL at the fourth byte of the bullet buffer
  JR C,MVBULLETS_5        ; Jump if the bullet is flying towards the sky
; The bullet is flying at an angle towards the ground.
  RES 3,(HL)              ; Reset bit 3 to prevent overflow (which would affect
                          ; bits 4-7)
  INC (HL)                ; Increment the pixel row counter in bits 0-2
  LD A,(HL)               ; Pick up the fourth byte of the bullet buffer
  AND 7                   ; Keep only bits 0-2 (the pixel row counter)
  DEC HL                  ; Point HL at the third byte of the bullet buffer
  JR NZ,MVBULLETS_6       ; Jump unless the pixel row counter rolled over from
                          ; 7 to 0
  INC (HL)                ; Increment the bullet's screen y-coordinate
  LD A,(HL)               ; A=bullet's next screen y-coordinate
  CP 20                   ; Has the bullet flown off the bottom of the screen?
  JR Z,MVBULLETS_1        ; Terminate it if so
  JR MVBULLETS_6
; The bullet is flying at an angle towards the sky.
MVBULLETS_5;
  SET 3,(HL)              ; Set bit 3 to prevent underflow (which would affect
                          ; bits 4-7)
  LD A,(HL)               ; Pick up the fourth byte of the bullet buffer
  DEC (HL)                ; Decrement the pixel row counter in bits 0-2
  AND 7                   ; A=previous value of the pixel row counter (0-7)
  DEC HL                  ; Point HL at the third byte of the bullet buffer
  JR NZ,MVBULLETS_6       ; Jump unless the pixel row counter rolled over from
                          ; 0 to 7
  DEC (HL)                ; Decrement the bullet's screen y-coordinate
MVBULLETS_6;
  LD D,(HL)               ; D=bullet's next screen y-coordinate
; Having calculated where the bullet is going next, we check whether it would
; hit Sam.
  CALL CHKSHOT            ; Would the bullet hit Sam?
  JR C,MVBULLETS_1        ; Terminate the bullet if so
; The bullet has not flown off the screen or hit Sam, so now we draw it.
  LD A,D                  ; A=bullet's next screen y-coordinate
  AND 7                   ; Point DE at the top pixel row of the screen cell in
  RRCA                    ; which the bullet will be drawn
  RRCA                    ;
  RRCA                    ;
  ADD A,E                 ;
  LD E,A                  ;
  LD A,D                  ;
  AND 24                  ;
  ADD A,64                ;
  LD D,A                  ;
  INC HL                  ; Point HL at the fourth byte of the bullet buffer
  LD A,(HL)               ; Point DE at the exact pixel row of the screen cell
  AND 7                   ; in which the bullet will be drawn
  ADD A,D                 ;
  LD D,A                  ;
  LD A,(DE)               ; Pick up the current pixel row from the display file
  OR 60                   ; Set bits 2-5
  AND 189                 ; Reset bits 6 and 1
  LD (DE),A               ; Draw the bullet
  JR MVBULLETS_2          ; Jump back to deal with the next bullet

; Unused
  DEFS 2

; Update the sniper's sprite tile references
;
; Used by the routine at MVSNIPER2. Updates the sprite tile references for
; animatory states 54/182. On entry, the carry flag is set if the sniper is
; firing, in which case a new bullet will be initialised.
;
; A Sniper's animatory state (54/182)
; D Sniper's next y-coordinate (34-37)
; E Sniper's x-coordinate
; H 227 (sniper)
UPDSNIPER;
  PUSH AF                 ; Save the sniper's animatory state
  LD A,D                  ; A=sniper's next y-coordinate (34-37)
  EXX
  PUSH AF                 ; Save the sniper's next y-coordinate
  LD C,3                  ; There are three columns in the sniper's sprite
  SUB 33                  ; E'=1 (sniper is at full height), 2 (sniper is at
  LD E,A                  ; half-height), 3 (only the sniper's head is
                          ; visible), or 4 (the sniper has ducked out of sight)
  CPL                     ; D'=5-E' (number of rows of the sniper's sprite that
  ADD A,6                 ; will be filled with non-blank tiles)
  LD D,A                  ;
; The next section of code modifies the sprite tile references for animatory
; states 54/182 column by column.
  LD H,215                ; 215 is the base page for sprite tile references
UPDSNIPER_0;
  LD B,D                  ; B=number of non-blank tiles to initialise in this
                          ; column
UPDSNIPER_1;
  LD L,162                ; Animatory state 162 (gangster) will be used as a
                          ; template for the sniper's sprite
  LD A,(HL)               ; Collect a sprite tile reference from the template
  LD L,182                ; Copy the sprite tile reference into place
  LD (HL),A               ;
  INC H                   ; Move down a row
  DJNZ UPDSNIPER_1        ; Jump back until all non-blank rows in this column
                          ; have been done
  LD A,E                  ; A=number of blank rows in the sniper's sprite (1-4)
  AND A                   ; Are there any?
  JR Z,UPDSNIPER_3        ; Jump if not (this jump is never made)
  LD B,E                  ; Fill the remaining slots in this column with blank
UPDSNIPER_2;
  LD (HL),0               ; tiles
  INC H                   ;
  DJNZ UPDSNIPER_2        ;
UPDSNIPER_3;
  DEC C                   ; Have we done all three columns yet?
  JR NZ,UPDSNIPER_0       ; Jump back if not
  POP AF                  ; Restore the sniper's next y-coordinate (34-37) to A
  JR NC,UPDSNIPER_6       ; Jump unless the sniper is firing
; The sniper is firing, so some further modifications to the sniper's sprite
; are required.
  LD H,217                ; Set the reference for tile 2 to 234
  LD (HL),234             ;
  INC H                   ; Set the reference for tile 3 to 0 (blank tile)
  LD (HL),0               ;
  LD H,222                ; Set the reference for tile 7 to 235
  LD (HL),235             ;
; Now we initialise a bullet.
  LD HL,32706             ; Point HL' at the third byte of bullet buffer 1 (at
                          ; BULLET1)
  SUB 18                  ; D=16 or 17 (bullet's initial screen y-coordinate)
  LD D,A                  ;
  LD A,(HL)               ; Is bullet buffer 1 at BULLET1 already being used?
  AND A                   ;
  JR Z,UPDSNIPER_4        ; Jump if not
  LD L,198                ; Point HL' at the third byte of bullet buffer 2
UPDSNIPER_4;
  LD (HL),D               ; Store the bullet's initial screen y-coordinate
  LD A,(LEFTCOL)          ; A=x-coordinate of the leftmost column of the play
                          ; area on screen
  LD B,A                  ; Copy this to B'
  INC L                   ; Point HL' at the fourth byte of the bullet buffer
  CALL GETRANDOM          ; Get a random number in A
  AND 112                 ; Keep only bits 4-6
  ADD A,4                 ; The initial pixel row at which the bullet will be
                          ; drawn inside a cell is 4
  LD (HL),A               ; Initialise bits 0-6 of the fourth byte of the
                          ; bullet buffer
  POP AF                  ; Restore the sniper's animatory state to A
  PUSH AF                 ; Save the animatory state again
  AND 128                 ; Keep only bit 7 (the direction bit)
  OR (HL)                 ; Initialise bit 7 of the fourth byte of the bullet
  LD (HL),A               ; buffer (the bullet's direction bit)
  DEC L                   ; Store the x-coordinate of the leftmost column of
  DEC L                   ; the play area on screen in the first byte of the
  DEC L                   ; bullet buffer
  LD (HL),B               ;
  INC L                   ; Point HL' at the second byte of the bullet buffer
  EXX
  RLCA                    ; Set the carry flag if the sniper is facing right
  LD A,E                  ; A=sniper's x-coordinate
  EXX
  JR NC,UPDSNIPER_5       ; Jump if the sniper is facing left
  INC A                   ; Add 2 to the sniper's x-coordinate
  INC A                   ;
UPDSNIPER_5;
  SUB B                   ; Subtract the x-coordinate of the leftmost column of
                          ; the play area on screen to obtain the bullet's
                          ; initial screen x-coordinate
  LD (HL),A               ; Store this in the second byte of the bullet buffer
UPDSNIPER_6;
  EXX
  POP AF                  ; Restore the sniper's animatory state to A
  JP UPDATEAS             ; Update the sniper's animatory state and location
                          ; and update the SRB

; Check whether Sam is within firing range of the sniper
;
; Used by the routine at MVSNIPER2. Returns with the zero flag set if the
; sniper (who is not visible at this point) has an x-coordinate that would
; place him on screen and at least 8 x-coordinates away from Sam.
;
; H 227 (sniper)
SAMINRANGE;
  LD L,1                  ; Point HL at byte 1 of the sniper's buffer
; This entry point is used by the routine at MVSNIPER1 with HL pointing at byte
; 1 of the sniper's buffer.
SAMINRANGE_0;
  LD A,(58881)            ; A=Sam's x-coordinate
  SUB (HL)                ; Subtract the sniper's x-coordinate
  JR NC,SAMINRANGE_1      ; Jump if the result is non-negative
  NEG                     ; Negate the (negative) result
SAMINRANGE_1;
  CP 8                    ; Is Sam less than 8 x-coordinates away from the
                          ; sniper?
  RET C                   ; Return with the zero flag reset if so
  LD A,(LEFTCOL)          ; A=x-coordinate of the leftmost column of the play
                          ; area on screen
  SUB 2                   ; Is the sniper off-screen to the left or right?
  SUB (HL)                ;
  ADD A,32                ;
  RET NC                  ; Return with the zero flag reset if so
  XOR A                   ; Set the zero flag
  RET

; Make the sound effect of Sam being hit by a bullet
;
; Used by the routine at CHKSHOT.
SHOTSOUND;
  LD DE,65021             ; Prepare the sound effect parameters; E=253 (initial
  LD A,2                  ; pitch), D=253 (pitch adjustment), A=2 (initial
                          ; border colour)
  JP SNDEFFECT1           ; Make the sound effect

; Unused
  DEFB 64,0,65,0,66,0,67,0

; Message 3; 'PRESS'
;
; Used as a submessage of messages 32, 38 and 69.
MSG003;
  DEFM "PRESS"
  DEFB 0                  ; End marker

; Message 4; 'KEY'
;
; Used as a submessage of messages 32, 38, 55, 57, 61, 62, 66 and 76.
MSG004;
  DEFM "KEY"
  DEFB 0                  ; End marker

; Message 5; 'PLAY'
;
; Used as a submessage of messages 19, 23, 32, 38 and 67.
MSG005;
  DEFM "PLAY"
  DEFB 0                  ; End marker

; Message 6; ' RIGHT '
;
; Used as a submessage of messages 32, 45, 65 and 69.
MSG006;
  DEFM " RIGHT "
  DEFB 0                  ; End marker

; Message 7; ' WHEN'
;
; Used as a submessage of messages 24, 62, 67 and 120.
MSG007;
  DEFM " WHEN"
  DEFB 0                  ; End marker

; Message 8; 'RATCATCHER'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG008;
  DEFM "RATCATCHER"
  DEFB 0                  ; End marker

; Message 9; 'POLICE CHIEF'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG009;
  DEFM "POLICE CHIEF"
  DEFB 0                  ; End marker

; Message 10; 'CHICAGO BEARS'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG010;
  DEFM "CHICAGO BEARS"
  DEFB 0                  ; End marker

; Message 11; 'REVENUE MAN'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG011;
  DEFM "REVENUE"
  DEFB 115                ; 115; ' MAN'
  DEFB 0                  ; End marker

; Message 12; 'VIOLIN CASE MAKER'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG012;
  DEFM "VIOLIN CASE MAKER"
  DEFB 0                  ; End marker

; Message 13; 'GARBAGE MAN'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG013;
  DEFM "GARBAGE"
  DEFB 115                ; 115; ' MAN'
  DEFB 0                  ; End marker

; Message 14; 'JAMES GANG'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG014;
  DEFM "JAMES GANG"
  DEFB 0                  ; End marker

; Message 15; 'RENT COLLECTOR'
;
; This message replaces submessage 97 (randomly chosen person or group of
; people) where it appears in message 119.
MSG015;
  DEFM "RENT COLLECTOR"
  DEFB 0                  ; End marker

; Message 16; 'MAKE COFFEE'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG016;
  DEFM "MAKE COFFEE"
  DEFB 0                  ; End marker

; Message 17; 'TAPDANCE'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG017;
  DEFM "TAPDANCE"
  DEFB 0                  ; End marker

; Message 18; 'SCUBA DIVE'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG018;
  DEFM "SCUBA DIVE"
  DEFB 0                  ; End marker

; Message 19; 'PLAY POKER'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG019;
  DEFB 5                  ; 5; 'PLAY'
  DEFM " POKER"
  DEFB 0                  ; End marker

; Message 20; 'TYPE'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG020;
  DEFM "TYPE"
  DEFB 0                  ; End marker

; Message 21; 'ICE-SKATE'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG021;
  DEFM "ICE-SKATE"
  DEFB 0                  ; End marker

; Message 22; 'WOLFWHISTLE'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG022;
  DEFM "WOLFWHISTLE"
  DEFB 0                  ; End marker

; Message 23; 'PLAY THE HARMONICA'
;
; This message replaces submessage 98 (randomly chosen verb) where it appears
; in message 24.
MSG023;
  DEFB 5                  ; 5; 'PLAY'
  DEFB 100                ; 100; ' THE '
  DEFM "HARMONICA"
  DEFB 0                  ; End marker

; Message 24; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE AGENCY/I WAS
; TEACHING THE ROACHES TO {verb} WHEN'
;
; Used as a submessage of message 33.
MSG024;
  DEFB 112                ; 112; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE
                          ; AGENCY'
  DEFB 103                ; 103; 'I '
  DEFB 117                ; 117; 'WAS '
  DEFM "TEACH"
  DEFB 127                ; 127; 'ING'
  DEFB 100                ; 100; ' THE '
  DEFM "ROACHES"
  DEFB 118                ; 118; ' TO '
  DEFB 98                 ; 98; randomly chosen verb (see GETMSGNUM)
  DEFB 7                  ; 7; ' WHEN'
  DEFB 0                  ; End marker

; Message 25; ' BEGAN '
;
; Used as a submessage of messages 33 and 49.
MSG025;
  DEFM " BEGAN "
  DEFB 0                  ; End marker

; Unused
  DEFS 19

; Message 100; ' THE '
;
; Used as a submessage of messages 23, 24, 33, 41, 47, 48, 52, 53, 55, 56, 57,
; 58, 59, 60, 62, 63, 64, 65, 66, 67, 70, 72, 73, 74, 112 and 119.
MSG100;
  DEFM " THE "
  DEFB 0                  ; End marker

; Message 101; 'CRUISE '
;
; Used as a submessage of messages 51, 67, 70 and 112.
MSG101;
  DEFM "CRUISE "
  DEFB 0                  ; End marker

; Message 102; 'NO '
;
; Used as a submessage of messages 46, 50, 55, 57, 60, 61 and 64.
MSG102;
  DEFM "NO "
  DEFB 0                  ; End marker

; Message 103; 'I '
;
; Used as a submessage of messages 24, 34, 39, 40, 41, 42, 46, 56, 62, 67, 73,
; 99 and 120.
MSG103;
  DEFM "I "
  DEFB 0                  ; End marker

; Message 104; 'AL '
;
; Used as a submessage of messages 1, 69 and 99.
MSG104;
  DEFM "AL "
  DEFB 0                  ; End marker

; Message 105; 'BUD '
;
; Used as a submessage of messages 1 and 65.
MSG105;
  DEFM "BUD "
  DEFB 0                  ; End marker

; Message 106; 'CHAD '
;
; Used as a submessage of message 1.
MSG106;
  DEFM "CHAD "
  DEFB 0                  ; End marker

; Message 107; 'DON '
;
; Used as a submessage of messages 1 and 67.
MSG107;
  DEFM "DON "
  DEFB 0                  ; End marker

; Messages 108 and 109; 'ED ' and 'FRED '
;
; Message 109 ('FRED ') is used as a submessage of message 1.
MSG109;
  DEFM "FR"
; Message 108 ('ED ') is used as a submessage of messages 1, 33, 42, 55, 57,
; 59, 60, 61, 62, 65, 67, 70 and 73.
MSG108;
  DEFM "ED "
  DEFB 0                  ; End marker

; Message 110; 'GUS '
;
; Used as a submessage of message 1.
MSG110;
  DEFM "GUS "
  DEFB 0                  ; End marker

; Message 111; 'SAM '
;
; Used as a submessage of messages 1, 50, 63, 73 and 112.
MSG111;
  DEFM "SAM "
  DEFB 0                  ; End marker

; Message 112; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE AGENCY'
;
; Used as a submessage of messages 24 and 32.
MSG112;
  DEFM "JUST ANO"
  DEFB 122                ; 122; 'THE'
  DEFM "R DAY AT"
  DEFB 100                ; 100; ' THE '
  DEFB 111                ; 111; 'SAM '
  DEFB 101                ; 101; 'CRUISE '
  DEFM "DETECTIVE AGENCY"
  DEFB 96                 ; 96; newline
  DEFB 0                  ; End marker

; Message 113; ' A '
;
; Used as a submessage of messages 32, 33, 38, 53, 56, 63, 66, 69, 71, 119 and
; 125.
MSG113;
  DEFM " A "
  DEFB 0                  ; End marker

; Message 114; 'DAISY '
;
; Used as a submessage of messages 26, 50 and 119.
MSG114;
  DEFM "DAISY "
  DEFB 0                  ; End marker

; Message 115; ' MAN'
;
; Used as a submessage of messages 11, 13, 53, 55, 57, 60, 70 and 76.
MSG115;
  DEFM " MAN"
  DEFB 0                  ; End marker

; Message 116; ' AND '
;
; Used as a submessage of messages 55, 56, 59, 64, 69, 73, 74 and 119.
MSG116;
  DEFM " AND "
  DEFB 0                  ; End marker

; Message 117; 'WAS '
;
; Used as a submessage of messages 24, 33, 34, 35, 47, 52, 70 and 73.
MSG117;
  DEFM "WAS "
  DEFB 0                  ; End marker

; Message 118; ' TO '
;
; Used as a submessage of messages 24, 32, 33, 38, 44, 55, 56, 57, 66, 67, 69,
; 99 and 120.
MSG118;
  DEFM " TO "
  DEFB 0                  ; End marker

; Message 119; ' AND DAISY RAN OFF WITH THE {person/people}/TAKE MY ADVICE
; KID/DONT BECOME A PRIVATE EYE/IT'LL ONLY BREAK YOUR HEART'
;
; Used as a submessage of messages 34, 35, 48 and 99.
MSG119;
  DEFB 116                ; 116; ' AND '
  DEFB 114                ; 114; 'DAISY '
  DEFM "RAN OFF WITH"
  DEFB 100                ; 100; ' THE '
  DEFB 97                 ; 97; randomly chosen person or group of people (see
                          ; GETMSGNUM)
  DEFB 96                 ; 96; newline
  DEFM "TAKE MY ADVICE KID"
  DEFB 96                 ; 96; newline
  DEFM "DONT BECOME"
  DEFB 113                ; 113; ' A '
  DEFM "PRIVATE EYE"
  DEFB 96                 ; 96; newline
  DEFM "IT'LL ONLY BREAK"
  DEFB 126                ; 126; ' YOU'
  DEFM "R HEART"
  DEFB 0                  ; End marker

; Message 120; ' WHEN I CAME TO '
;
; Used as a submessage of messages 35 and 36.
MSG120;
  DEFB 7                  ; 7; ' WHEN'
  DEFM " "
  DEFB 103                ; 103; 'I '
  DEFM "CAME"
  DEFB 118                ; 118; ' TO '
  DEFB 0                  ; End marker

; Messages 121 and 122; ' THE' and 'THE'
;
; Message 121 (' THE') is used as a submessage of messages 32, 37, 48 and 66.
MSG121;
  DEFM " "
; Message 122 ('THE') is used as a submessage of messages 43, 53, 59, 71, 74
; and 112.
MSG122;
  DEFM "THE"
  DEFB 0                  ; End marker

; Message 123; 'ONE '
;
; Used as a submessage of messages 33, 35, 36, 41, 43, 65, 67, 70, 76 and 128.
MSG123;
  DEFM "ONE "
  DEFB 0                  ; End marker

; Message 124; 'SAID '
;
; Used as a submessage of messages 26, 33, 40, 50, 65, 67, 70, 73 and 125.
MSG124;
  DEFM "SAID "
  DEFB 0                  ; End marker

; Message 125; ' A VOICE SAID ''
;
; Used as a submessage of messages 37, 43, 44, 45, 51, 55, 64 and 66.
MSG125;
  DEFB 113                ; 113; ' A '
  DEFM "VOICE "
  DEFB 124                ; 124; 'SAID '
  DEFM "'"
  DEFB 0                  ; End marker

; Message 126; ' YOU'
;
; Used as a submessage of messages 32, 45, 55, 62, 63, 65, 67, 72, 73 and 119.
MSG126;
  DEFM " YOU"
  DEFB 0                  ; End marker

; Message 127; 'ING'
;
; Used as a submessage of messages 24, 30, 32, 44, 49, 51, 56 and 62.
MSG127;
  DEFM "ING"
  DEFB 0                  ; End marker

; Message 32; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE AGENCY/I'M WORKING
; ON A CASE RIGHT NOW BUT IF YOU WANT TO PLAY THEN PRESS A KEY.'
;
; Appears in Sam's initialisation parameters for demo mode at SAMMODE0.
MSG032;
  DEFB 112                ; 112; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE
                          ; AGENCY'
  DEFM "I'M WORK"
  DEFB 127                ; 127; 'ING'
  DEFM " ON"
  DEFB 113                ; 113; ' A '
  DEFM "CASE"
  DEFB 6                  ; 6; ' RIGHT '
  DEFM "NOW BUT IF"
  DEFB 126                ; 126; ' YOU'
  DEFM " WANT"
  DEFB 118                ; 118; ' TO '
  DEFB 5                  ; 5; 'PLAY'
  DEFB 121                ; 121; ' THE'
  DEFM "N "
  DEFB 3                  ; 3; 'PRESS'
  DEFB 113                ; 113; ' A '
  DEFB 4                  ; 4; 'KEY'
  DEFM "."
  DEFB 0                  ; End marker

; Message 33; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE AGENCY/I WAS
; TEACHING THE ROACHES TO {verb} WHEN THE PHONE RANG. IT WAS  A DAME NAMED
; LANA. SHE SAID TO MEET HER ON THE TOP FLOOR OF THE HOTEL ROYALE. SO BEGAN /
; THE CASE OF THE BALI BUDGIE'
;
; Appears in Sam's initialisation parameters for game mode 1 at SAMMODE1.
MSG033;
  DEFB 24                 ; 24; 'JUST ANOTHER DAY AT THE SAM CRUISE DETECTIVE
                          ; AGENCY/I WAS TEACHING...'
  DEFB 100                ; 100; ' THE '
  DEFM "PH"
  DEFB 123                ; 123; 'ONE '
  DEFM "RANG. IT "
  DEFB 117                ; 117; 'WAS '
  DEFB 113                ; 113; ' A '
  DEFM "DAME NAM"
  DEFB 108                ; 108; 'ED '
  DEFM "LANA. SHE "
  DEFB 124                ; 124; 'SAID '
  DEFB 118                ; 118; ' TO '
  DEFM "MEET HER ON"
  DEFB 100                ; 100; ' THE '
  DEFM "TOP FLOOR OF"
  DEFB 100                ; 100; ' THE '
  DEFM "HOTEL ROYALE. SO"
  DEFB 25                 ; 25; ' BEGAN '
  DEFB 96                 ; 96; newline
  DEFB 100                ; 100; ' THE '
  DEFM "CASE OF"
  DEFB 100                ; 100; ' THE '
  DEFM "BALI BUDGIE"
  DEFB 0                  ; End marker

; Message 34; 'I WAS BROKE AGAIN AND DAISY RAN OFF WITH THE
; {person/people}/TAKE MY ADVICE KID/DONT BECOME A PRIVATE EYE/IT'LL ONLY BREAK
; YOUR HEART'
;
; Used by the routine at SCORECASH.
MSG034;
  DEFB 103                ; 103; 'I '
  DEFB 117                ; 117; 'WAS '
  DEFM "BROKE AGAIN"
  DEFB 119                ; 119; ' AND DAISY RAN OFF WITH THE...'
  DEFB 0                  ; End marker

; Message 35; ' WHEN I CAME TO MY WALLET WAS GONE  AND DAISY RAN OFF WITH THE
; {person/people}/TAKE MY ADVICE KID/DONT BECOME A PRIVATE EYE/IT'LL ONLY BREAK
; YOUR HEART'
;
; Used by the routine at ROOFEDGE.
MSG035;
  DEFB 120                ; 120; ' WHEN I CAME TO '
  DEFM "MY WALLET "
  DEFB 117                ; 117; 'WAS '
  DEFM "G"
  DEFB 123                ; 123; 'ONE '
  DEFB 119                ; 119; ' AND DAISY RAN OFF WITH THE...'
  DEFB 0                  ; End marker

; Message 36; ' WHEN I CAME TO SOMEONE HAD TAKEN ${tens digit}0'
;
; Used by the routine at ROOFEDGE.
MSG036;
  DEFB 120                ; 120; ' WHEN I CAME TO '
  DEFM "SOME"
  DEFB 123                ; 123; 'ONE '
  DEFM "HAD TAKEN $"
  DEFB 1                  ; 1; '{tens digit}'
  DEFM "0"
  DEFB 0                  ; End marker

; Message 37; 'A VOICE SAID 'WHO'S THERE?''
;
; Used by the routine at WHOSTHERE.
MSG037;
  DEFB 125                ; 125; 'A VOICE SAID ''
  DEFM "WHO'S"
  DEFB 121                ; 121; ' THE'
  DEFM "RE?'"
  DEFB 0                  ; End marker

; Message 38; 'PRESS A KEY TO PLAY'
;
; Used by the routine at GETINPUT.
MSG038;
  DEFB 3                  ; 3; 'PRESS'
  DEFB 96                 ; 96; newline
  DEFB 3                  ; 3; 'PRESS'
  DEFB 113                ; 113; ' A '
  DEFB 96                 ; 96; newline
  DEFB 3                  ; 3; 'PRESS'
  DEFB 113                ; 113; ' A '
  DEFB 4                  ; 4; 'KEY'
  DEFB 96                 ; 96; newline
  DEFB 3                  ; 3; 'PRESS'
  DEFB 113                ; 113; ' A '
  DEFB 4                  ; 4; 'KEY'
  DEFB 118                ; 118; ' TO '
  DEFB 96                 ; 96; newline
  DEFB 3                  ; 3; 'PRESS'
  DEFB 113                ; 113; ' A '
  DEFB 4                  ; 4; 'KEY'
  DEFB 118                ; 118; ' TO '
  DEFB 5                  ; 5; 'PLAY'
  DEFB 96                 ; 96; newline
  DEFM " "
  DEFB 96                 ; 96; newline
  DEFM " "
  DEFB 0                  ; End marker

; Message 39; 'I HUNG UP'
;
; Used by the unused routine at XHANGUP.
MSG039;
  DEFB 103                ; 103; 'I '
  DEFM "HUNG UP"
  DEFB 0                  ; End marker

; Message 40; ''{name}' I SAID '
;
; Used by the routine at GIVENAME.
MSG040;
  DEFM "'"
  DEFB 1                  ; 1; '{name}'
  DEFM "' "
  DEFB 103                ; 103; 'I '
  DEFB 124                ; 124; 'SAID '
  DEFB 0                  ; End marker

; Message 41; 'I LIFTED THE PHONE '
;
; Used by the routine at PHONE.
MSG041;
  DEFB 103                ; 103; 'I '
  DEFM "LIFTED"
  DEFB 100                ; 100; ' THE '
  DEFM "PH"
  DEFB 123                ; 123; 'ONE '
  DEFB 0                  ; End marker

; Message 42; 'I DIALLED {number}'
;
; Used by the routine at ONPHONE.
MSG042;
  DEFB 103                ; 103; 'I '
  DEFM "DIALL"
  DEFB 108                ; 108; 'ED '
  DEFB 2                  ; 2; '{number}'
  DEFB 0                  ; End marker

; Message 43; 'A VOICE SAID 'THERES NOONE HERE''
;
; Used by the routine at PHONEMSG.
MSG043;
  DEFB 125                ; 125; 'A VOICE SAID ''
  DEFB 122                ; 122; 'THE'
  DEFM "RES NO"
  DEFB 123                ; 123; 'ONE '
  DEFM "HERE'"
  DEFB 0                  ; End marker

; Message 44; 'A VOICE SAID 'GET LOST - I'M TRYING TO SLEEP''
;
; Used by the routine at PHONEMSG.
MSG044;
  DEFB 125                ; 125; 'A VOICE SAID ''
  DEFM "GET LOST - I'M TRY"
  DEFB 127                ; 127; 'ING'
  DEFB 118                ; 118; ' TO '
  DEFM "SLEEP'"
  DEFB 0                  ; End marker

; Message 45; 'A VOICE SAID 'BE RIGHT WITH YOU''
;
; Used by the routine at PHONEMSG.
MSG045;
  DEFB 125                ; 125; 'A VOICE SAID''
  DEFM "BE"
  DEFB 6                  ; 6; ' RIGHT '
  DEFM "WITH"
  DEFB 126                ; 126; ' YOU'
  DEFM "'"
  DEFB 0                  ; End marker

; Message 46; 'I DUNNO NO {name}'
;
; Used by the routine at GIVENAME.
MSG046;
  DEFM "'"
  DEFB 103                ; 103; 'I '
  DEFM "DUN"
  DEFB 102                ; 102; 'NO '
  DEFB 102                ; 102; 'NO '
  DEFB 1                  ; 1; '{name}'
  DEFM "'"
  DEFB 0                  ; End marker

; Message 47; ' THE NUMBER WAS UNOBTAINABLE'
;
; Used by the routine at ONPHONE.
MSG047;
  DEFB 100                ; 100; ' THE '
  DEFM "NUMBER "
  DEFB 117                ; 117; 'WAS '
  DEFM "UNOBTAINABLE"
  DEFB 0                  ; End marker

; Message 48; 'AT THE JAIL THEY THREW THE BOOK AT ME AND DAISY RAN OFF WITH THE
; {person/people}/TAKE MY ADVICE KID/DONT BECOME A PRIVATE EYE/IT'LL ONLY BREAK
; YOUR HEART'
;
; Used by the routine at ARRESTSAM.
MSG048;
  DEFM "AT"
  DEFB 100                ; 100; ' THE '
  DEFM "JAIL"
  DEFB 121                ; 121; ' THE'
  DEFM "Y THREW"
  DEFB 100                ; 100; ' THE '
  DEFM "BOOK AT ME"
  DEFB 119                ; 119; ' AND DAISY RAN OFF WITH THE...'
  DEFB 0                  ; End marker

; Message 49; 'IT BEGAN RINGING'
;
; Used by the routine at PLACECALL.
MSG049;
  DEFM "IT"
  DEFB 25                 ; 25; ' BEGAN '
  DEFM "R"
  DEFB 127                ; 127; 'ING'
  DEFB 127                ; 127; 'ING'
  DEFB 0                  ; End marker

; Message 50; 'DAISY SAID 'NO MESSAGES SAM ''
;
; Used by the routine at PHONEMSG.
MSG050;
  DEFB 114                ; 114; 'DAISY '
  DEFB 124                ; 124; 'SAID '
  DEFM "'"
  DEFB 102                ; 102; 'NO '
  DEFM "MESSAGES "
  DEFB 111                ; 111; 'SAM '
  DEFM "'"
  DEFB 0                  ; End marker

; Message 51; 'A VOICE SAID 'OK CRUISE WE'RE COMING''
;
; Used by the routine at PHONEMSG.
MSG051;
  DEFB 125                ; 125; 'A VOICE SAID''
  DEFM "OK "
  DEFB 101                ; 101; 'CRUISE '
  DEFM "WE'RE COM"
  DEFB 127                ; 127; 'ING'
  DEFM "'"
  DEFB 0                  ; End marker

; Message 52; ' THE BAIL WAS ${tens digit}0'
;
; Used by the routine at FREESAM.
MSG052;
  DEFB 100                ; 100; ' THE '
  DEFM "BAIL "
  DEFB 117                ; 117; 'WAS '
  DEFM "$"
  DEFB 1                  ; 1; '{tens digit}'
  DEFM "0"
  DEFB 0                  ; End marker

; Message 53; 'THERE'S A MAN'S BODY ON THE FLOOR'
;
; Appears in the message location table entry at CORPSE.
MSG053;
  DEFB 122                ; 122; 'THE'
  DEFM "RE'S"
  DEFB 113                ; 113; ' A '
  DEFB 115                ; 115; ' MAN'
  DEFM "'S BODY ON"
  DEFB 100                ; 100; ' THE '
  DEFM "FLOOR"
  DEFB 0                  ; End marker

; Message 99; 'I HAD TO GO TO HOSPITAL  AND DAISY RAN OFF WITH THE
; {person/people}/TAKE MY ADVICE KID/DONT BECOME A PRIVATE EYE/IT'LL ONLY BREAK
; YOUR HEART'
;
; Used by the routine at CHKSHOT.
MSG099;
  DEFB 103                ; 103; 'I '
  DEFM "HAD"
  DEFB 118                ; 118; ' TO '
  DEFM "GO"
  DEFB 118                ; 118; ' TO '
  DEFM "HOSPIT"
  DEFB 104                ; 104; 'AL '
  DEFB 119                ; 119; ' AND DAISY RAN OFF WITH THE...'
  DEFB 0                  ; End marker

; Message 26; 'DAISY SAID ''
;
; Used as a submessage of messages 56, 58, 63, 68 and 76.
MSG026;
  DEFB 114                ; 114; 'DAISY '
  DEFB 124                ; 124; 'SAID '
  DEFM "'"
  DEFB 0                  ; End marker

; Message 27; 'LANA ANSWERED 'OOH SAM! '
;
; Used as a submessage of messages 59, 60, 65 and 72.
MSG027;
  DEFB 29                 ; 29; 'LANA '
  DEFM "ANSWERED 'OOH SAM! "
  DEFB 0                  ; End marker

; Message 28; 'LANA RANG - '
;
; Used as a submessage of messages 56, 58 and 76.
MSG028;
  DEFB 29                 ; 29; 'LANA '
  DEFM "RANG - "
  DEFB 0                  ; End marker

; Unused
  DEFS 2

; Phone numbers
;
; Used by the routine at TELNOVALID. Each entry here consists of five bytes.
; The first byte is the telephone identifier; bits 5-7 indicate the floor
; (000=5th, 001=4th, 010=3rd, 011=2nd, 100=1st), and bits 0-4 indicate the
; 8-tile wide column of the play area that contains the phone. The last four
; bytes of each entry contain the phone number.
PHONES;
  DEFB 7                  ; Hotel Royale (top floor, left-hand room)
  DEFM "8864"             ;
  DEFB 36                 ; Room to the right of the catwalk
  DEFM "7162"             ;
  DEFB 44                 ; Hotel Royale (right-hand green room)
  DEFM "9408"             ;
  DEFB 54                 ; Apartments next to no. 19 (top floor, cyan room)
  DEFM "3183"             ;
  DEFB 66                 ; Apartments next to no. 74 (third floor, magenta
  DEFM "4090"             ; room)
  DEFB 68                 ; No. 74 (third floor, left)
  DEFM "1776"             ;
  DEFB 71                 ; Hotel Royale (left-hand magenta room)
  DEFM "5278"             ;
  DEFB 91                 ; No. 19 (top floor, right)
  DEFM "6839"             ;
  DEFB 92                 ; No. 17 (Sam's office)
  DEFM "7337"             ;
  DEFB 94                 ; No. 15 (third floor, left)
  DEFM "2522"             ;
  DEFB 102                ; No. 74 (second floor, right)
  DEFM "6124"             ;
  DEFB 109                ; No. 31 (second floor, cyan room)
  DEFM "3979"             ;
  DEFB 121                ; Apartments next to no. 19 (second floor, magenta
  DEFM "4715"             ; room)
  DEFB 132                ; No. 74 (first floor, left)
  DEFM "7832"             ;
  DEFB 151                ; Apartments next to no. 19 (first floor, green room)
  DEFM "1369"             ;

; Ringing phone messages
;
; Used by the routines at RINGING, ONPHONE and PREPOBJS. Each entry here
; consists of three bytes. The first byte is the telephone identifier. The
; second byte, if non-zero, is the message number of the name that must be
; given when asked 'WHO'S THERE?'. The third byte is the phone message number.
;
; The first entry is for the phone on the top floor of the hotel. It is
; activated before a new game starts by the routine at PREPOBJS.
RINGPHONE1;
  DEFB 7                  ; Hotel Royale (top floor, left-hand room)
  DEFB 0
  DEFB 55                 ; Message 55; 'A VOICE SAID 'ED - TELL THE OIL MAN
                          ; THAT THE KEY TO  THE FAT MANS HOUSE...''
; The next entry is for the phone on the top floor of no. 19. It is activated
; before a new game starts by the routine at PREPOBJS.
RINGPHONE2;
  DEFB 91                 ; No. 19 (top floor, right)
  DEFB 108                ; Message 108; 'ED'
  DEFB 57                 ; Message 57; 'OK ED - THE FAT MAN HAS THE KEY TO NO
                          ; 27'
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT04).
RINGPHONE3;
  DEFB 0                  ; This becomes 94 (third floor, no. 15) when
                          ; activated
  DEFB 0
  DEFB 63                 ; Message 63; 'DAISY SAID 'SAM - A GANGSTER'S
                          ; WATCHING FOR YOU OUTSIDE THE POLICE STATION''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT04).
RINGPHONE4;
  DEFB 0                  ; This becomes 94 (third floor, no. 15) when
                          ; activated
  DEFB 0
  DEFB 64                 ; Message 64; 'A VOICE SAID 'OK FATS THE HOOK'S AT NO
                          ; 74 AND ALS GUARDING IT''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT07).
RINGPHONE5;
  DEFB 0                  ; This becomes 44 (hotel's right-hand green room)
                          ; when activated
  DEFB 0
  DEFB 66                 ; Message 66; 'A VOICE SAID 'OK LANA THE KEY TO 74'S
                          ; IN THE ROOM PAST THE CATWALK...''
; The next entry is for the phone on the third floor of no. 74. It is activated
; before a new game starts by the routine at PREPOBJS.
RINGPHONE6;
  DEFB 68                 ; No. 74 (third floor, left)
  DEFB 107                ; Message 107; 'DON'
  DEFB 69                 ; Message 69; 'TECHNICAL SERVICES HERE. TO USE A HOOK
                          ; GET TO RIGHT PLACE AND PRESS C'
; The next seven entries are unused. However, the first byte of each is
; initialised to 255 by the routine at PREPOBJS before a new game starts.
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0

; Phone messages for Sam
;
; Used by the routines at RINGING and ONPHONE. Each entry here consists of
; three bytes. The first byte is the telephone identifier. The second byte, if
; non-zero, is the message number of the name that must be given when asked
; 'WHO'S THERE?'. The third byte is the phone message number.
;
; The first entry is for the first message Daisy has for Sam. It is activated
; before a new game starts by the routine at PREPOBJS.
PHONEMSG1;
  DEFB 92                 ; Location; Sam's office (7337)
  DEFB 0
  DEFB 56                 ; Message 56; 'DAISY SAID 'LANA RANG - SHE HAD TO GET
                          ; OUT IN A HURRY...''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT03).
PHONEMSG2;
  DEFB 0                  ; This becomes 92 (Sam's office; 7337) when activated
  DEFB 0
  DEFB 58                 ; Message 58; 'DAISY SAID 'LANA RANG - HER NEW
                          ; NUMBERS 7162. THE POLICE WERE HERE''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT03).
PHONEMSG3;
  DEFB 0                  ; This becomes 36 (Lana; 7162) when activated
  DEFB 111                ; Message 111; 'SAM'
  DEFB 59                 ; Message 59; 'LANA ANSWERED 'OOH SAM! THEY KILLED MY
                          ; FIANCE AND STOLE THE BUDGIE''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT03).
PHONEMSG4;
  DEFB 0                  ; This becomes 36 (Lana; 7162) when activated
  DEFB 0
  DEFB 60                 ; Message 60; 'LANA ANSWERED 'OOH SAM! THAT CROOK THE
                          ; FAT MAN'S JUST MOVED INTO NO 15''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT04).
PHONEMSG5;
  DEFB 0                  ; This becomes 92 (Sam's office; 7337) when activated
  DEFB 0
  DEFB 76                 ; Message 76; 'DAISY SAID 'LANA RANG - THAT FAT MAN
                          ; HAS TWO KEYS NOT JUST ONE ''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT04).
PHONEMSG6;
  DEFB 0                  ; This becomes 36 (Lana; 7162) when activated
  DEFB 0
  DEFB 65                 ; Message 65; 'LANA ANSWERED 'OOH SAM! BUD SAID HE'D
                          ; MEET ME ALONE...''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT08).
PHONEMSG7;
  DEFB 0                  ; This becomes 92 (Sam's office; 7337) when activated
  DEFB 0
  DEFB 68                 ; Message 68; 'DAISY SAID 'ALS NUMBER'S 6124''
; The next entry is activated by the routine at EVENTS (using the event entry
; at EVENT11) when Sam gets the budgie, and deactivated by the routine at
; EVENTS (using the event entry at EVENT12) if Sam loses the budgie.
PHONEMSG8;
  DEFB 0                  ; This becomes 36 (Lana; 7162) when activated
  DEFB 0
  DEFB 72                 ; Message 72; 'LANA ANSWERED 'OOH SAM! YOUVE GOT THE
                          ; BIRD. SEE YOU IN YOUR OFFICE''
; The next four entries are unused. However, the first byte of each is
; initialised to 255 by the routine at PREPOBJS before a new game starts.
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0
  DEFB 255,0,0

; Unused
;
; These bytes are probably remnants of the phone message table at PHONEMSG1.
  DEFB 255,0

; Initial ringing phone locations
;
; The values below are copied into the first bytes of the entries at RINGPHONE1
; by the routine at PREPOBJS.
PHONEINIT1;
  DEFB 7,91,0,0,0,68
  DEFB 255,255,255,255,255,255,255

; Initial locations of phones with messages for Sam
;
; The values below are copied into the first bytes of the entries at PHONEMSG1
; by the routine at PREPOBJS.
PHONEINIT2;
  DEFB 92,0,0,0,0,0,0,0
  DEFB 255,255,255,255

; Message 65; 'LANA ANSWERED 'OOH SAM! BUD SAID HE'D MEET ME ALONE IN THE
; HOTELS RIGHT HAND GREEN ROOM. I'M SCARED - WILL YOU GO INSTEAD?''
;
; Appears in the phone message table entry at PHONEMSG6.
MSG065;
  DEFB 27                 ; 27; 'LANA ANSWERED 'OOH SAM! '
  DEFB 105                ; 105; 'BUD '
  DEFB 124                ; 124; 'SAID '
  DEFM "HE'D MEET ME AL"
  DEFB 123                ; 123; 'ONE '
  DEFM "IN"
  DEFB 100                ; 100; ' THE '
  DEFM "HOTELS"
  DEFB 6                  ; 6; ' RIGHT '
  DEFM "HAND GREEN ROOM. I'M SCAR"
  DEFB 108                ; 108; 'ED '
  DEFM "- WILL"
  DEFB 126                ; 126; ' YOU'
  DEFM " GO INSTEAD?'"
  DEFB 0                  ; End marker

; Unused
  DEFB 0,0,0
; If message 0 existed, the following byte would be the LSB of its address. The
; corresponding unused MSB can be found at XMSGMSBS1.
XMSGLSBS1;
  DEFB 209

; LSBs of addresses of messages 1-76
;
; The MSBs of the addresses of messages 1-76 can be found at MSGMSBS1. The LSBs
; of the addresses of messages 97-129 can be found at MSGLSBS2.
MSGLSBS1;
  DEFB 208                ; Message 1; '{tens digit}/{name}'
  DEFB 146                ; Message 2; '{number}'
  DEFB 0                  ; Message 3; 'PRESS'
  DEFB 6                  ; Message 4; 'KEY'
  DEFB 10                 ; Message 5; 'PLAY'
  DEFB 15                 ; Message 6; ' RIGHT '
  DEFB 23                 ; Message 7; ' WHEN'
  DEFB 29                 ; Message 8; 'RATCATCHER'
  DEFB 40                 ; Message 9; 'POLICE CHIEF'
  DEFB 53                 ; Message 10; 'CHICAGO BEARS'
  DEFB 67                 ; Message 11; 'REVENUE MAN'
  DEFB 76                 ; Message 12; 'VIOLIN CASE MAKER'
  DEFB 94                 ; Message 13; 'GARBAGE MAN'
  DEFB 103                ; Message 14; 'JAMES GANG'
  DEFB 114                ; Message 15; 'RENT COLLECTOR'
  DEFB 129                ; Message 16; 'MAKE COFFEE'
  DEFB 141                ; Message 17; 'TAPDANCE'
  DEFB 150                ; Message 18; 'SCUBA DIVE'
  DEFB 161                ; Message 19; 'PLAY POKER'
  DEFB 169                ; Message 20; 'TYPE'
  DEFB 174                ; Message 21; 'ICE-SKATE'
  DEFB 184                ; Message 22; 'WOLFWHISTLE'
  DEFB 196                ; Message 23; 'PLAY THE HARMONICA'
  DEFB 208                ; Message 24; 'JUST ANOTHER DAY AT THE SAM CRUISE
                          ; DETECTIVE AGENCY/I WAS TEACHING...'
  DEFB 229                ; Message 25; ' BEGAN '
  DEFB 220                ; Message 26; 'DAISY SAID ''
  DEFB 224                ; Message 27; 'LANA ANSWERED 'OOH SAM! '
  DEFB 245                ; Message 28; 'LANA RANG - '
  DEFB 200                ; Message 29; 'LANA '
  DEFB 206                ; Message 30; 'ING '
  DEFB 209                ; Message 31; 'THAT'
  DEFB 0                  ; Message 32; 'JUST ANOTHER DAY AT THE SAM CRUISE
                          ; DETECTIVE AGENCY/I'M WORKING ON A CASE...'
  DEFB 45                 ; Message 33; '...SO BEGAN THE CASE OF THE BALI
                          ; BUDGIE'
  DEFB 146                ; Message 34; 'I WAS BROKE AGAIN...'
  DEFB 161                ; Message 35; ' WHEN I CAME TO MY WALLET WAS GONE...'
  DEFB 177                ; Message 36; ' WHEN I CAME TO SOMEONE HAD TAKEN
                          ; ${tens digit}0'
  DEFB 197                ; Message 37; 'A VOICE SAID 'WHO'S THERE?''
  DEFB 209                ; Message 38; 'PRESS A KEY TO PLAY'
  DEFB 233                ; Message 39; 'I HUNG UP'
  DEFB 242                ; Message 40; ''{name}' I SAID '
  DEFB 249                ; Message 41; 'I LIFTED THE PHONE '
  DEFB 5                  ; Message 42; 'I DIALLED {number}'
  DEFB 14                 ; Message 43; 'A VOICE SAID 'THERES NOONE HERE''
  DEFB 29                 ; Message 44; 'A VOICE SAID 'GET LOST - I'M TRYING TO
                          ; SLEEP''
  DEFB 57                 ; Message 45; 'A VOICE SAID 'BE RIGHT WITH YOU''
  DEFB 68                 ; Message 46; 'I DUNNO NO {name}'
  DEFB 78                 ; Message 47; ' THE NUMBER WAS UNOBTAINABLE'
  DEFB 100                ; Message 48; 'AT THE JAIL THEY THREW THE BOOK AT
                          ; ME...'
  DEFB 128                ; Message 49; 'IT BEGAN RINGING'
  DEFB 135                ; Message 50; 'DAISY SAID 'NO MESSAGES SAM ''
  DEFB 151                ; Message 51; 'A VOICE SAID 'OK CRUISE WE'RE COMING''
  DEFB 168                ; Message 52; ' THE BAIL WAS ${tens digit}0'
  DEFB 179                ; Message 53; 'THERE'S A MAN'S BODY ON THE FLOOR'
  DEFB 203                ; Message 54; 'I HAD TO GO TO HOSPITAL...'
  DEFB 0                  ; Message 55; 'A VOICE SAID 'ED - TELL THE OIL MAN
                          ; THAT THE KEY TO THE FAT MAN'S HOUSE...''
  DEFB 70                 ; Message 56; 'DAISY SAID 'LANA RANG - SHE HAD TO GET
                          ; OUT IN A HURRY...''
  DEFB 126                ; Message 57; 'OK ED - THE FAT MAN HAS THE KEY TO NO
                          ; 27'
  DEFB 145                ; Message 58; 'DAISY SAID 'LANA RANG - HER NEW
                          ; NUMBERS 7162. THE POLICE WERE HERE''
  DEFB 89                 ; Message 59; 'LANA ANSWERED 'OOH SAM! THEY KILLED MY
                          ; FIANCE AND STOLE THE BUDGIE''
  DEFB 122                ; Message 60; 'LANA ANSWERED 'OOH SAM! THAT CROOK THE
                          ; FAT MAN'S JUST MOVED INTO NO 15''
  DEFB 155                ; Message 61; 'SOMEONE GROWLED 'NO KEY EH!''
  DEFB 171                ; Message 62; 'IT ALL WENT BLACK. AS I FELL SOMEONE
                          ; FAT PUSHED PAST ME...'
  DEFB 96                 ; Message 63; 'DAISY SAID 'SAM - A GANGSTER'S
                          ; WATCHING FOR YOU OUTSIDE THE POLICE STATION''
  DEFB 176                ; Message 64; 'A VOICE SAID 'OK FATS THE HOOK'S AT NO
                          ; 74 AND ALS GUARDING IT''
  DEFB 177                ; Message 65; 'LANA ANSWERED 'OOH SAM! BUD SAID HE'D
                          ; MEET ME ALONE...''
  DEFB 211                ; Message 66; 'A VOICE SAID 'OK LANA THE KEY TO 74'S
                          ; IN THE ROOM PAST THE CATWALK...''
  DEFB 5                  ; Message 67; 'SOMEONE HIT ME. I PLAYED DEAD. TWO MEN
                          ; WALKED OFF...'
  DEFB 97                 ; Message 68; 'DAISY SAID 'ALS NUMBER'S 6124''
  DEFB 117                ; Message 69; 'TECHNICAL SERVICES HERE. TO USE A HOOK
                          ; GET TO RIGHT PLACE AND PRESS C'
  DEFB 187                ; Message 70; 'SOMEONE BELOW SAID 'CRUISE WAS DRESSED
                          ; AS THE OIL MAN. DONT LET ANYONE PAST''
  DEFB 232                ; Message 71; 'THERES A SAFE WITH 4 LOCKS'
  DEFB 166                ; Message 72; 'LANA ANSWERED 'OOH SAM! YOUVE GOT THE
                          ; BIRD. SEE YOU IN YOUR OFFICE''
  DEFB 199                ; Message 73; 'I STARED AT THE LOVELY LANA WAS IT
                          ; THOSE RUBY LIPS OR THE SLIM AUTOMATIC...'
  DEFB 105                ; Message 74; 'SHE'S IN JAIL NOW. ANOTHER CASE
                          ; SOLVED...'
  DEFB 194                ; Message 75; 'SHE FIRED'
  DEFB 146                ; Message 76; 'DAISY SAID 'LANA RANG - THAT FAT MAN
                          ; HAS TWO KEYS NOT JUST ONE ''

; Unused
;
; If messages 77-96 existed, these bytes would be the LSBs of their addresses.
; The corresponding unused MSBs can be found at XMSGMSBS2.
XMSGLSBS2;
  DEFB 248,248,248
  DEFB 248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248
  DEFB 203

; LSBs of addresses of messages 97-129
;
; The MSBs of the addresses of messages 97-129 can be found at MSGMSBS2. The
; LSBs of the addresses of messages 1-76 can be found at MSGLSBS1.
MSGLSBS2;
  DEFB 204                ; Message 97; 'JOYSTICK?'
  DEFB 203                ; Unused
  DEFB 203                ; Message 99; 'I HAD TO GO TO HOSPITAL...'
  DEFB 0                  ; Message 100; ' THE '
  DEFB 6                  ; Message 101; 'CRUISE '
  DEFB 14                 ; Message 102; 'NO '
  DEFB 18                 ; Message 103; 'I '
  DEFB 21                 ; Message 104; 'AL '
  DEFB 25                 ; Message 105; 'BUD '
  DEFB 30                 ; Message 106; 'CHAD '
  DEFB 36                 ; Message 107; 'DON '
  DEFB 43                 ; Message 108; 'ED '
  DEFB 41                 ; Message 109; 'FRED '
  DEFB 47                 ; Message 110; 'GUS '
  DEFB 52                 ; Message 111; 'SAM '
  DEFB 57                 ; Message 112; 'JUST ANOTHER DAY AT THE SAM CRUISE
                          ; DETECTIVE AGENCY'
  DEFB 95                 ; Message 113; ' A '
  DEFB 99                 ; Message 114; 'DAISY '
  DEFB 106                ; Message 115; ' MAN'
  DEFB 111                ; Message 116; ' AND '
  DEFB 117                ; Message 117; 'WAS '
  DEFB 122                ; Message 118; ' TO '
  DEFB 127                ; Message 119; ' AND DAISY RAN OFF WITH THE...'
  DEFB 212                ; Message 120; ' WHEN I CAME TO '
  DEFB 221                ; Message 121; ' THE'
  DEFB 222                ; Message 122; 'THE'
  DEFB 226                ; Message 123; 'ONE '
  DEFB 231                ; Message 124; 'SAID '
  DEFB 237                ; Message 125; ' A VOICE SAID ''
  DEFB 247                ; Message 126; ' YOU'
  DEFB 252                ; Message 127; 'ING'
  DEFB 214                ; Message 128; 'SOMEONE '
  DEFB 220                ; Message 129; 'FAT'

; Unused
;
; If messages 130-199 existed, these bytes would be the LSBs of their
; addresses. The corresponding unused MSBs can be found at XMSGMSBS3.
XMSGLSBS3;
  DEFB 254,254,254,254,254,254
  DEFB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
  DEFB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
  DEFB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
  DEFB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254

; Message 29; 'LANA '
;
; Used as a submessage of messages 27, 28, 66 and 73.
MSG029;
  DEFM "LANA "
  DEFB 0                  ; End marker

; Message 30; 'ING '
;
; Used as a submessage of messages 62, 63 and 64.
MSG030;
  DEFB 127                ; 127; 'ING'
  DEFM " "
  DEFB 0                  ; End marker

; Message 31; 'THAT'
;
; Used as a submessage of messages 55, 60, 67 and 73 and 76.
MSG031;
  DEFM "THAT"
  DEFB 0                  ; End marker

; Message 128; 'SOMEONE '
;
; Used as a submessage of messages 61, 62, 67 and 70.
MSG128;
  DEFM "SOME"
  DEFB 123                ; 123; 'ONE '
  DEFB 0                  ; End marker

; Message 129; 'FAT'
;
; Used as a submessage of messages 55, 57, 60, 62, 64 and 76.
MSG129;
  DEFM "FAT"
  DEFB 0                  ; End marker

; Unused
;
; If messages 224-243 existed, these bytes would be the LSBs of their
; addresses. The corresponding unused MSBs can be found at XMSGMSBS4.
XMSGLSBS4;
  DEFB 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254
  DEFB 254,254,254,254

; Check whether Sam is at the right place to pick up a telephone
;
; Used by the routine at BYPHONE. Returns with the zero flag reset if the
; x-coordinate of the front column of Sam's sprite is between 1 and 6 mod 8
; (which is where telephones are located in rooms).
;
; H 230 (Sam)
BYPHONEX;
  CALL FRONTX             ; Calculate the x-coordinate of the front column of
                          ; Sam's sprite (x)
  LD B,A                  ; B=x%8
  DEC A                   ; Set the zero flag if x is 0 or 7 mod 8 (telephones
  CP 6                    ; are located at x-coordinates between 1 and 6 mod 8)
  SBC A,A                 ;
  LD A,B                  ; A=x%8
  LD B,2                  ; Bit 1 set; check for the presence of a telephone
  RET

; Unused
;
; If message 0 existed, this byte would be the MSB of its address. The
; corresponding unused LSB can be found at XMSGLSBS1.
XMSGMSBS1;
  DEFB 127

; MSBs of addresses of messages 1-76
;
; The LSBs of the addresses of messages 1-76 can be found at MSGLSBS1. The MSBs
; of the addresses of messages 97-129 can be found at MSGMSBS2.
MSGMSBS1;
  DEFB 127                ; Message 1; '{tens digit}/{name}'
  DEFB 127                ; Message 2; '{number}'
  DEFB 103                ; Message 3; 'PRESS'
  DEFB 103                ; Message 4; 'KEY'
  DEFB 103                ; Message 5; 'PLAY'
  DEFB 103                ; Message 6; ' RIGHT '
  DEFB 103                ; Message 7; ' WHEN'
  DEFB 103                ; Message 8; 'RATCATCHER'
  DEFB 103                ; Message 9; 'POLICE CHIEF'
  DEFB 103                ; Message 10; 'CHICAGO BEARS'
  DEFB 103                ; Message 11; 'REVENUE MAN'
  DEFB 103                ; Message 12; 'VIOLIN CASE MAKER'
  DEFB 103                ; Message 13; 'GARBAGE MAN'
  DEFB 103                ; Message 14; 'JAMES GANG'
  DEFB 103                ; Message 15; 'RENT COLLECTOR'
  DEFB 103                ; Message 16; 'MAKE COFFEE'
  DEFB 103                ; Message 17; 'TAPDANCE'
  DEFB 103                ; Message 18; 'SCUBA DIVE'
  DEFB 103                ; Message 19; 'PLAY POKER'
  DEFB 103                ; Message 20; 'TYPE'
  DEFB 103                ; Message 21; 'ICE-SKATE'
  DEFB 103                ; Message 22; 'WOLFWHISTLE'
  DEFB 103                ; Message 23; 'PLAY THE HARMONICA'
  DEFB 103                ; Message 24; 'JUST ANOTHER DAY AT THE SAM CRUISE
                          ; DETECTIVE AGENCY/I WAS TEACHING...'
  DEFB 103                ; Message 25; ' BEGAN '
  DEFB 106                ; Message 26; 'DAISY SAID ''
  DEFB 106                ; Message 27; 'LANA ANSWERED 'OOH SAM! '
  DEFB 106                ; Message 28; 'LANA RANG - '
  DEFB 108                ; Message 29; 'LANA '
  DEFB 108                ; Message 30; 'ING '
  DEFB 108                ; Message 31; 'THAT'
  DEFB 105                ; Message 32; 'JUST ANOTHER DAY AT THE SAM CRUISE
                          ; DETECTIVE AGENCY/I'M WORKING ON A CASE...'
  DEFB 105                ; Message 33; '...SO BEGAN THE CASE OF THE BALI
                          ; BUDGIE'
  DEFB 105                ; Message 34; 'I WAS BROKE AGAIN...'
  DEFB 105                ; Message 35; ' WHEN I CAME TO MY WALLET WAS GONE...'
  DEFB 105                ; Message 36; ' WHEN I CAME TO SOMEONE HAD TAKEN
                          ; ${tens digit}0'
  DEFB 105                ; Message 37; 'A VOICE SAID 'WHO'S THERE?''
  DEFB 105                ; Message 38; 'PRESS A KEY TO PLAY'
  DEFB 105                ; Message 39; 'I HUNG UP'
  DEFB 105                ; Message 40; ''{name}' I SAID '
  DEFB 105                ; Message 41; 'I LIFTED THE PHONE '
  DEFB 106                ; Message 42; 'I DIALLED {number}'
  DEFB 106                ; Message 43; 'A VOICE SAID 'THERES NOONE HERE''
  DEFB 106                ; Message 44; 'A VOICE SAID 'GET LOST - I'M TRYING TO
                          ; SLEEP''
  DEFB 106                ; Message 45; 'A VOICE SAID 'BE RIGHT WITH YOU''
  DEFB 106                ; Message 46; 'I DUNNO NO {name}'
  DEFB 106                ; Message 47; ' THE NUMBER WAS UNOBTAINABLE'
  DEFB 106                ; Message 48; 'AT THE JAIL THEY THREW THE BOOK AT
                          ; ME...'
  DEFB 106                ; Message 49; 'IT BEGAN RINGING'
  DEFB 106                ; Message 50; 'DAISY SAID 'NO MESSAGES SAM ''
  DEFB 106                ; Message 51; 'A VOICE SAID 'OK CRUISE WE'RE COMING''
  DEFB 106                ; Message 52; ' THE BAIL WAS ${tens digit}0'
  DEFB 106                ; Message 53; 'THERE'S A MAN'S BODY ON THE FLOOR'
  DEFB 106                ; Message 54; 'I HAD TO GO TO HOSPITAL...'
  DEFB 91                 ; Message 55; 'A VOICE SAID 'ED - TELL THE OIL MAN
                          ; THAT THE KEY TO THE FAT MAN'S HOUSE...''
  DEFB 91                 ; Message 56; 'DAISY SAID 'LANA RANG - SHE HAD TO GET
                          ; OUT IN A HURRY...''
  DEFB 91                 ; Message 57; 'OK ED - THE FAT MAN HAS THE KEY TO NO
                          ; 27'
  DEFB 91                 ; Message 58; 'DAISY SAID 'LANA RANG - HER NEW
                          ; NUMBERS 7162. THE POLICE WERE HERE''
  DEFB 125                ; Message 59; 'LANA ANSWERED 'OOH SAM! THEY KILLED MY
                          ; FIANCE AND STOLE THE BUDGIE''
  DEFB 125                ; Message 60; 'LANA ANSWERED 'OOH SAM! THAT CROOK THE
                          ; FAT MAN'S JUST MOVED INTO NO 15''
  DEFB 125                ; Message 61; 'SOMEONE GROWLED 'NO KEY EH!''
  DEFB 125                ; Message 62; 'IT ALL WENT BLACK. AS I FELL SOMEONE
                          ; FAT PUSHED PAST ME...'
  DEFB 93                 ; Message 63; 'DAISY SAID 'SAM - A GANGSTER'S
                          ; WATCHING FOR YOU OUTSIDE THE POLICE STATION''
  DEFB 93                 ; Message 64; 'A VOICE SAID 'OK FATS THE HOOK'S AT NO
                          ; 74 AND ALS GUARDING IT''
  DEFB 107                ; Message 65; 'LANA ANSWERED 'OOH SAM! BUD SAID HE'D
                          ; MEET ME ALONE...''
  DEFB 93                 ; Message 66; 'A VOICE SAID 'OK LANA THE KEY TO 74'S
                          ; IN THE ROOM PAST THE CATWALK...''
  DEFB 94                 ; Message 67; 'SOMEONE HIT ME. I PLAYED DEAD. TWO MEN
                          ; WALKED OFF...'
  DEFB 94                 ; Message 68; 'DAISY SAID 'ALS NUMBER'S 6124''
  DEFB 94                 ; Message 69; 'TECHNICAL SERVICES HERE. TO USE A HOOK
                          ; GET TO RIGHT PLACE AND PRESS C'
  DEFB 91                 ; Message 70; 'SOMEONE BELOW SAID 'CRUISE WAS DRESSED
                          ; AS THE OIL MAN. DONT LET ANYONE PAST''
  DEFB 91                 ; Message 71; 'THERES A SAFE WITH 4 LOCKS'
  DEFB 94                 ; Message 72; 'LANA ANSWERED 'OOH SAM! YOUVE GOT THE
                          ; BIRD. SEE YOU IN YOUR OFFICE''
  DEFB 94                 ; Message 73; 'I STARED AT THE LOVELY LANA WAS IT
                          ; THOSE RUBY LIPS OR THE SLIM AUTOMATIC...'
  DEFB 95                 ; Message 74; 'SHE'S IN JAIL NOW. ANOTHER CASE
                          ; SOLVED...'
  DEFB 95                 ; Message 75; 'SHE FIRED'
  DEFB 93                 ; Message 76; 'DAISY SAID 'LANA RANG - THAT FAT MAN
                          ; HAS TWO KEYS NOT JUST ONE ''

; Unused
;
; If messages 77-96 existed, these bytes would be the MSBs of their addresses.
; The corresponding unused LSBs can be found at XMSGLSBS2.
XMSGMSBS2;
  DEFB 102,102,102
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 95

; MSBs of addresses of messages 97-129
;
; The LSBs of the addresses of messages 97-129 can be found at MSGLSBS2. The
; MSBs of the addresses of messages 1-76 can be found at MSGMSBS1.
MSGMSBS2;
  DEFB 95                 ; Message 97; 'JOYSTICK?'
  DEFB 106                ; Unused
  DEFB 106                ; Message 99; 'I HAD TO GO TO HOSPITAL...'
  DEFB 104                ; Message 100; ' THE '
  DEFB 104                ; Message 101; 'CRUISE '
  DEFB 104                ; Message 102; 'NO '
  DEFB 104                ; Message 103; 'I '
  DEFB 104                ; Message 104; 'AL '
  DEFB 104                ; Message 105; 'BUD '
  DEFB 104                ; Message 106; 'CHAD '
  DEFB 104                ; Message 107; 'DON '
  DEFB 104                ; Message 108; 'ED '
  DEFB 104                ; Message 109; 'FRED '
  DEFB 104                ; Message 110; 'GUS '
  DEFB 104                ; Message 111; 'SAM '
  DEFB 104                ; Message 112; 'JUST ANOTHER DAY AT THE SAM CRUISE
                          ; DETECTIVE AGENCY'
  DEFB 104                ; Message 113; ' A '
  DEFB 104                ; Message 114; 'DAISY '
  DEFB 104                ; Message 115; ' MAN'
  DEFB 104                ; Message 116; ' AND '
  DEFB 104                ; Message 117; 'WAS '
  DEFB 104                ; Message 118; ' TO '
  DEFB 104                ; Message 119; ' AND DAISY RAN OFF WITH THE...'
  DEFB 104                ; Message 120; ' WHEN I CAME TO '
  DEFB 104                ; Message 121; ' THE'
  DEFB 104                ; Message 122; 'THE'
  DEFB 104                ; Message 123; 'ONE '
  DEFB 104                ; Message 124; 'SAID '
  DEFB 104                ; Message 125; ' A VOICE SAID ''
  DEFB 104                ; Message 126; ' YOU'
  DEFB 104                ; Message 127; 'ING'
  DEFB 108                ; Message 128; 'SOMEONE '
  DEFB 108                ; Message 129; 'FAT'

; Unused
;
; If messages 130-245 existed, these bytes would be the MSBs of their
; addresses. The corresponding unused LSBs for messages 130-199 can be found at
; XMSGLSBS3; the unused LSBs for messages 224-243 can be found at XMSGLSBS4.
XMSGMSBS3;
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
XMSGMSBS4;
  DEFB 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
  DEFB 102,102,102,102,102,102

; Set A=1
;
; Used by the routine at CHKCHASE. Returns with A=1.
;
; A 122 (the MSB of the routine at HOODWALK)
SETA1;
  LD L,1
  DEC A                   ; This instruction resets the zero flag
  LD A,L                  ; A=1
  RET NZ                  ; This return always happens
; The following instructions are never executed.
  LD A,(58884)            ; A=Sam's z-coordinate
  RET

; Unused
;
; If message 255 existed, this byte would be the MSB of its address.
  DEFB 102

; Print a message
;
; Used by the routines at PRINTNUM and QUEUEMSG.
;
; DE Display file address
; HL Message address
PRINTMSG;
  LD A,(HL)               ; Pick up the ASCII code of the next character to
                          ; print
  ADD A,A                 ; Have we reached the end of the message?
  RET Z                   ; Return if so
  NOP
  NOP
  INC HL                  ; Point HL at the next character in the message
  PUSH HL                 ; Save this pointer for now
  PUSH DE                 ; Save the display file address
  LD H,15                 ; Point HL at the base address of the graphic data
  LD L,A                  ; for the font character (in the ROM)
  ADD HL,HL               ;
  ADD HL,HL               ;
  LD B,8                  ; Print the character on the screen
PRINTMSG_0;
  LD A,(HL)               ;
  LD (DE),A               ;
  INC L                   ;
  INC D                   ;
  DJNZ PRINTMSG_0         ;
  POP DE                  ; Restore the display file address to DE
  POP HL                  ; Restore the pointer to the next character in the
                          ; message
  INC E                   ; Point DE at the next display file location
  JR PRINTMSG             ; Jump back to print the next character

; Print a number
;
; Used by the routines at CHGBUCKS, INCSCORE and INITSTATUS. Computes the ASCII
; codes for the digits of the number in HL, stores them in the buffer at
; NUMSTRBUF, and then prints them.
;
; DE Display file address
; HL Number to print
PRINTNUM;
  PUSH DE                 ; Save the display file address
  EX DE,HL                ; Transfer the number to print to DE
  LD HL,32719             ; Fill the number string buffer at NUMSTRBUF with
  LD B,5                  ; space characters
PRINTNUM_0;
  DEC L                   ;
  LD (HL),32              ;
  DJNZ PRINTNUM_0         ;
  LD A,48                 ; 48 is the ASCII code for the digit '0'
  LD BC,55536             ; BC=-10000
  EX DE,HL                ; Transfer the number to print to HL
  ADD HL,BC               ; Is HL>=10000?
  JR C,PRINTNUM_1         ; Jump if so to compute and store the 10000s digit
  INC E                   ; Point DE at the slot for the 1000s digit in the
                          ; number string buffer
  SBC HL,BC               ; Add the 10000 back
  LD BC,64536             ; BC=-1000
  ADD HL,BC               ; Is HL>=1000?
  JR C,PRINTNUM_2         ; Jump if so to compute and store the 1000s digit
  INC E                   ; Point DE at the slot for the 100s digit in the
                          ; number string buffer
  SBC HL,BC               ; Add the 1000 back
  LD BC,65436             ; BC=-100
  ADD HL,BC               ; Is HL>=100?
  JR C,PRINTNUM_3         ; Jump if so to compute and store the 100s digit
  INC E                   ; Point DE at the slot for the 10s digit in the
                          ; number string buffer
  SBC HL,BC               ; Add the 100 back
  LD C,246                ; BC=-10
  ADD HL,BC               ; Is HL>=10?
  JR C,PRINTNUM_4         ; Jump if so to compute and store the 10s digit
  JR PRINTNUM_5           ; Jump forward to compute and store the units digit
; Compute and store the 10000s digit.
PRINTNUM_1;
  INC A                   ; Get the ASCII code for the 10000s digit in A
  ADD HL,BC               ;
  JR C,PRINTNUM_1         ;
  LD (DE),A               ; Place the 10000s digit into the number string
                          ; buffer
  SBC HL,BC
  INC E                   ; Point DE at the slot for the 1000s digit
  LD A,47
  LD BC,64536             ; BC=-1000
; Compute and store the 1000s digit.
PRINTNUM_2;
  INC A                   ; Get the ASCII code for the 1000s digit in A
  ADD HL,BC               ;
  JR C,PRINTNUM_2         ;
  LD (DE),A               ; Place the 1000s digit into the number string buffer
  LD A,47
  SBC HL,BC
  LD BC,65436             ; BC=-100
  INC E                   ; Point DE at the slot for the 100s digit
; Compute and store the 100s digit.
PRINTNUM_3;
  INC A                   ; Get the ASCII code for the 100s digit in A
  ADD HL,BC               ;
  JR C,PRINTNUM_3         ;
  LD (DE),A               ; Place the 100s digit into the number string buffer
  LD A,47
  SBC HL,BC
  LD C,246                ; BC=-10
  INC E                   ; Point DE at the slot for the 10s digit
; Compute and store the 10s digit.
PRINTNUM_4;
  INC A                   ; Get the ASCII code for the 10s digit in A
  ADD HL,BC               ;
  JR C,PRINTNUM_4         ;
  LD (DE),A               ; Place the 10s digit into the number string buffer
  LD A,48
; Compute and store the units digit.
PRINTNUM_5;
  SBC HL,BC
  INC E                   ; Point DE at the slot for the units digit
  ADD A,L                 ; A=ASCII code for the units digit
  LD (DE),A               ; Place it into the number string buffer
; The number string buffer is now ready.
  LD E,202                ; DE=NUMSTRBUF (start of the number string buffer)
  POP HL                  ; Restore the display file address to HL
  EX DE,HL                ; Transfer it to DE, and point HL at the number
                          ; string buffer at NUMSTRBUF
  JP PRINTMSG             ; Print the number

; Unused
  DEFS 3

; Adjust Sam's cash supply and print the new amount
;
; Used by the routines at FREESAM, ARRESTSAM and ROOFEDGE. Returns with the
; zero flag set if Sam has run out of money.
;
; A N/10 (N=number of bucks to subtract)
CHGBUCKS;
  LD E,A                  ; A=N
  ADD A,A                 ;
  ADD A,A                 ;
  ADD A,E                 ;
  ADD A,A                 ;
; This entry point is used by the routine at PHONE with A=2.
CHGBUCKS_0;
  LD D,255                ; Prepare DE for subtraction
  NEG                     ; A=-N
  JR CHGBUCKS_2
; This entry point is used by the routines at ADDRBUCKS, INITSTATUS and
; FOUNDOBJ with A holding the number of bucks to add to Sam's cash supply.
CHGBUCKS_1;
  LD D,0                  ; Prepare DE for addition
CHGBUCKS_2;
  LD E,A                  ; Now DE=number of bucks to add (may be negative)
; This entry point is used by the routine at INCSCORE with DE=65535 (-1).
CHGBUCKS_3;
  LD HL,(BUCKS)           ; Collect the current number of bucks from BUCKS
  ADD HL,DE               ; Adjust the number
  INC H                   ; Is the result negative?
  JR NZ,CHGBUCKS_4        ; Jump if not
  LD HL,256               ; Set HL up so that the next instruction reduces it
                          ; to 0
CHGBUCKS_4;
  DEC H                   ; Restore the value of HL (if it was non-negative),
                          ; or set it to 0 (if it was negative)
  LD A,H                  ; Set the zero flag if the number of bucks is now 0
  OR L                    ;
  PUSH AF                 ; Save the zero flag temporarily
  LD (BUCKS),HL           ; Store the new amount at BUCKS
  LD DE,20728             ; DE=display file address
  CALL PRINTNUM           ; Print the number of bucks
  POP AF                  ; Restore the zero flag
  RET

; Unused
  DEFS 3

; Increment the score and decrement Sam's cash supply
;
; Used by the routine at SCORECASH.
INCSCORE;
  LD HL,(SCORE)           ; Collect the score from SCORE
  INC HL                  ; Increment it
  LD (SCORE),HL           ; Store the new score
  LD DE,20696             ; DE=display file address
  CALL PRINTNUM           ; Print the score
  LD DE,65535             ; DE=-1
  JR CHGBUCKS_3           ; Decrement Sam's cash supply and print the new
                          ; amount

; Unused
  DEFS 2

; Add a message to the message queue
;
; Used by the routines at QUEUEMSGU, FOUNDOBJ, CUTSCENE, GETINPUT, FREESAM and
; ROOFEDGE. Adds a message to the message queue, and updates the message line
; (by clearing it or displaying the next message or message portion) if
; necessary.
;
; A Message number
QUEUEMSG;
  LD E,A                  ; E=number of the message to be queued
  LD HL,MSGINDEX          ; MSGINDEX holds the index of the current message in
                          ; the message queue at MSGQUEUE
  LD A,(HL)               ; Pick up the index of the current message
  DEC A                   ; A=index of the last message in the queue
  AND 7                   ;
  ADD A,184               ; Point HL at the corresponding slot in the message
  LD L,A                  ; queue at MSGQUEUE
  LD A,(HL)               ; Pick up the message number from this slot
  AND A                   ; Is the slot empty?
  JR Z,QUEUEMSG_1         ; Jump if so
; The message queue is full. To make space for the new message, we remove the
; second message from the queue, and move the following messages up a slot,
; thus leaving the final slot free.
  LD B,7                  ; There are six messages to move up a slot, and one
                          ; to remove completely
  LD C,0                  ; The final slot will be made empty
QUEUEMSG_0;
  LD A,(HL)               ; Pick up the message number from this slot
  LD (HL),C               ; Replace it with 0 or the message number from the
                          ; previous slot
  LD C,A                  ; Save the old contents of this slot
  LD A,L                  ; Point HL at the previous slot in the message queue
  DEC A                   ;
  OR 8                    ;
  LD L,A                  ;
  DJNZ QUEUEMSG_0         ; Jump back to deal with the remaining slots
; The following loop looks for the first empty slot in the message queue, and
; stores the message number there.
QUEUEMSG_1;
  LD L,183                ; HL=MSGINDEX (which holds the index of the current
                          ; message in the message queue at MSGQUEUE)
  LD L,(HL)               ; Copy the index to L
QUEUEMSG_2;
  LD A,L                  ; A=index of the next message in the queue
  INC A                   ;
  AND 7                   ;
  ADD A,184               ; Point HL at the corresponding slot in the queue
  LD L,A                  ;
  LD A,(HL)               ; Pick up the message number from this slot
  AND A                   ; Is the slot empty?
  JR NZ,QUEUEMSG_2        ; Jump back if not to check the next slot
  LD (HL),E               ; Store the message number in this slot
  NOP                     ;
  NOP                     ;
  NOP                     ;
; This entry point is used by the routines at MSGINQUEUE, CUTSCENE and
; MNLPTASKS1.
QUEUEMSG_3;
  LD HL,MSGINDEX          ; MSGINDEX holds the index of the current message in
                          ; the message queue at MSGQUEUE
  LD A,(HL)               ; Pick up the index of the current message (0-7)
  AND 7                   ; Point HL at the corresponding slot in the message
  ADD A,184               ; queue
  LD L,A                  ;
  LD A,(HL)               ; Pick up the number of the current message
  AND A                   ; Is there a message being displayed at the moment?
  JR NZ,QUEUEMSG_4        ; Jump if so
  CALL CHKQUEUE           ; Check whether there are any messages remaining in
                          ; the message queue
  LD HL,(23672)           ; Collect the two least significant bytes of the
                          ; system variable FRAMES in HL
  JR NZ,QUEUEMSG_6        ; Jump if there is another message waiting in the
                          ; queue
  RET Z                   ; This return always happens
; There is a message being displayed at the moment.
QUEUEMSG_4;
  CALL MSGDELAY           ; A=minimum number of subintervals of 0.64s that the
                          ; current message (or message portion) should be
                          ; displayed for before being replaced
  LD HL,0                 ; DE=32*A
  LD DE,32                ;
QUEUEMSG_5;
  ADD HL,DE               ;
  DEC A                   ;
  JR NZ,QUEUEMSG_5        ;
  EX DE,HL                ;
  LD HL,(23672)           ; Collect the two least significant bytes of the
                          ; system variable FRAMES in HL
  LD BC,(MSGTIME)         ; BC=two least significant bytes of the system
                          ; variable FRAMES as they were when the last message
                          ; was displayed
  SBC HL,BC               ; Is it time to display the next message (or next
  SBC HL,DE               ; portion of the current message) yet?
  RET C                   ; Return if not
  ADD HL,DE               ; Restore the current value of the two least
  ADD HL,BC               ; significant bytes of the system variable FRAMES to
                          ; HL
QUEUEMSG_6;
  LD (MSGTIME),HL         ; Update the message display timer at MSGTIME
; This entry point is used by the routine at INITMSGFA.
QUEUEMSG_7;
  EXX
  LD HL,32639             ; Fill the message buffer at MSGBUFFER with spaces
  LD BC,8224              ;
QUEUEMSG_8;
  LD (HL),C               ;
  DEC L                   ;
  DJNZ QUEUEMSG_8         ;
  EXX
  LD HL,SUBMSGS           ; SUBMSGS holds the submessage indicator (0, 2, 4, 6
                          ; or 8)
  LD A,(HL)               ; Pick it up in A
  AND A                   ; Are we in the middle of a message at the moment?
QUEUEMSG_9;
  JR NZ,QUEUEMSG_11       ; Jump if so
; We've reached the end of the current message. Time to display the next
; message, or clear the message line if there are no messages waiting in the
; queue.
  LD L,183                ; HL=MSGINDEX (which holds the index of the current
                          ; message in the message queue at MSGQUEUE)
  LD A,(HL)               ; Pick up this index
  INC (HL)                ; Increment the index
  AND 7                   ; Point HL at the current message in the queue
  ADD A,184               ;
  LD L,A                  ;
  LD (HL),0               ; Set the current message number to 0 (no message)
  SUB 7                   ; Point HL at the next message in the queue
  OR 8                    ;
  LD L,A                  ;
  LD A,(HL)               ; Pick up the message number
  AND A                   ; Is there another message waiting in the queue?
  JR Z,QUEUEMSG_13        ; Jump if not to clear the message line
; Here we transition from no message to top-level message, or from one message
; level to a submessage. A holds the (sub)message number.
QUEUEMSG_10;
  LD C,A                  ; Point BC at the LSB of the message address
  LD B,108                ;
  LD L,129                ; Increase the submessage indicator at SUBMSGS by 2
  INC (HL)                ; (to 2, 4, 6 or 8)
  INC (HL)                ;
  LD L,(HL)               ; Point HL at where the LSB of the message address
  SET 7,L                 ; will be stored
  LD A,(BC)               ; Copy the LSB of the message address here
  LD (HL),A               ;
  INC B                   ; Point BC at the MSB of the message address
  INC L                   ; Point HL at where the MSB of the message address
                          ; will be stored
  LD A,(BC)               ; Copy the MSB of the message address here
  LD (HL),A               ;
QUEUEMSG_11;
  LD L,129                ; HL=SUBMSGS (submessage indicator)
  LD L,(HL)               ; Point HL at the LSB of the address of the next
  SET 7,L                 ; character in the message
  LD E,(HL)               ; Pick up the LSB in E
  INC (HL)                ; Increment the LSB
  INC HL                  ; Point HL at the MSB of the address of the next
                          ; character in the message
  LD D,(HL)               ; Pick up the MSB in D
  JR NZ,QUEUEMSG_12       ; Jump unless the LSB rolled over to 0
  INC (HL)                ; Increment the MSB
QUEUEMSG_12;
  LD A,(DE)               ; A=ASCII code of the next character in the message
  AND A                   ; Is it the end marker?
  JR NZ,QUEUEMSG_14       ; Jump if not
; We've reached the end of the top-level message or a submessage.
  LD L,129                ; HL=SUBMSGS (submessage indicator)
  DEC (HL)                ; Reduce the submessage indicator by 2
  DEC (HL)                ;
  JR NZ,QUEUEMSG_9        ; Jump unless we've reached the end of the top-level
                          ; message
; It's time to print the contents of the message buffer.
QUEUEMSG_13;
  LD HL,MSGBUFFER         ; Point HL at the first byte of the message buffer at
                          ; MSGBUFFER
  LD DE,20608             ; DE=display file address
  JP PRINTMSG             ; Print the contents of the message buffer
; At this point A holds the ASCII code of the next character in the message.
QUEUEMSG_14;
  CP 32                   ; Is the ASCII code of the character < 32?
  JR C,QUEUEMSG_10        ; Jump if so to deal with a submessage
  JR NZ,QUEUEMSG_15       ; Jump if the ASCII code of the character is > 32
; The next character in the message is a space. In case there's not enough room
; left in the message buffer for the word that follows, we now save the
; submessage indicator and submessage addresses.
  LD HL,SUBMSGS           ; Copy the submessage indicator and submessage
  LD BC,16                ; addresses from SUBMSGS to 32512-32527
  LD DE,SRB               ;
  LDIR                    ;
QUEUEMSG_15;
  CP 96                   ; Is the ASCII code of the character < 96?
  JR C,QUEUEMSG_16        ; Jump if so
  JR Z,QUEUEMSG_13        ; Jump if the ASCII code of the character is 96
                          ; (newline)
  CP 100                  ; Is the ASCII code of the character >= 100?
  JR NC,QUEUEMSG_10       ; Jump if so to deal with a submessage
  JR QUEUEMSG_18          ; Jump forward to deal with ASCII code 97 or 98 (99
                          ; is not used)
QUEUEMSG_16;
  EXX
  INC L                   ; Point HL' at the next free byte in the message
                          ; buffer at MSGBUFFER
  LD (HL),A               ; Store the ASCII code of the message character there
  BIT 7,L                 ; Reset the zero flag if we've reached the end of the
                          ; message buffer (HL'=32640)
  EXX
  JR Z,QUEUEMSG_11        ; Jump if there's still space left in the message
                          ; buffer
; The message buffer at MSGBUFFER is full.
  LD HL,SRB               ; Restore the submessage indicator and message
  LD DE,SUBMSGS           ; addresses to SUBMSGS
  LD BC,16                ;
  LDIR                    ;
  LD L,128                ; HL=32640 (message buffer overflow byte)
QUEUEMSG_17;
  LD A,(HL)               ; Remove all characters from the end of the message
  LD (HL),C               ; buffer back to the last space
  DEC L                   ;
  LD C,32                 ;
  CP 32                   ;
  JR NZ,QUEUEMSG_17       ;
  JR QUEUEMSG_13          ; Print the contents of the message buffer
; The ASCII code of the next character in the message is 97 (person or group of
; people) or 98 (verb).
QUEUEMSG_18;
  ADD A,100               ; A=197 or 198
  CALL GETMSGNUM          ; Randomly select a message number for either a verb
                          ; or a person or group of people
  JR QUEUEMSG_10

; Unused
  DEFB 0

; Message display interval
;
; Updated by the routine at MSGSPEED and checked by the routine at MSGDELAY.
; The value stored here defines the minimum number of subintervals of 0.64s for
; which a message (or portion of a message) will normally be displayed in the
; message line.
MSGDISPINT;
  DEFB 4

; Last used random message numbers
;
; Used by the routine at GETMSGNUM. When it appears in a message, ASCII code 97
; is replaced by a randomly chosen message denoting a person or group of
; people; similarly, ASCII code 98 is replaced by a randomly chosen message
; containing a verb (see QUEUEMSG). The numbers of those randomly chosen
; messages are stored here for future reference.
RANDMSGS;
  DEFB 8                  ; Last used message number for a person or group of
                          ; people (e.g. message 8; RATCATCHER)
  DEFB 16                 ; Last used message number for a verb (e.g. message
                          ; 17; TAPDANCE)

; Unused
  DEFB 248

; Randomly select a message number
;
; Used by the routine at QUEUEMSG. Returns with a randomly chosen message
; number (different from the last one used) in A. On entry, A holds 197 or 198
; depending on the type of message required; 197 for a person or group of
; people, 198 for a verb.
;
; A 197 or 198
GETMSGNUM;
  LD C,A                  ; Point BC at the relevant last used message number
  LD B,111                ; (see RANDMSGS)
  LD A,(BC)               ; E=last used message number (8-15, 16-23)
  LD E,A                  ;
  AND 248                 ; Discard bits 0-2
  LD D,A                  ; D=8 or 16
GETMSGNUM_0;
  CALL GETRANDOM          ; Get a random number in A
  AND 7                   ; A=message number (8-15, 16-23)
  ADD A,D                 ;
  CP E                    ; Is this the same message number as last time?
  JR Z,GETMSGNUM_0        ; Jump back to try again if so
  LD (BC),A               ; Store the randomly chosen message number for
                          ; comparison next time
  RET

; 'M' pressed - toggle message speed
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'M' is
; pressed.
MSGSPEED;
  LD A,(MSGDISPINT)       ; Toggle the message display interval at MSGDISPINT
  XOR 3                   ; between 4 (fast) and 7 (slow)
  LD (MSGDISPINT),A       ;
  JP LEFT_1               ; Make a sound effect

; Make the sound effect of a sniper firing
;
; Used by the routine at MVSNIPER2.
FIRESOUND;
  LD DE,418               ; Prepare the sound effect parameters; E=162 (initial
                          ; pitch), D=1 (pitch adjustment)
  CALL SNDEFFECT1         ; Make the sound effect
  AND A                   ; Clear the carry flag to indicate that the sniper is
                          ; no longer firing
  JP MVSNIPER2_1          ; Update the sniper's sprite tile references

; Unused
  NOP
  LD A,(20654)            ; This is the display file address for the byte in
                          ; the top-left corner of the telephone icon; the byte
                          ; is 129 when the phone is ringing, or 1 otherwise

; Update the telephone icon
;
; Used by the routine at ICONPANEL2. The main entry point is used to make the
; telephone appear to vibrate as if ringing.
UPDPHONE;
  LD HL,PHONERING         ; Point HL at the graphic data for the telephone when
                          ; ringing (at PHONERING)
  NOP
  JR UPDPHONE_1
; This entry point is also used by the routine at ICONPANEL2 to make the
; telephone appear still (as between rings, or when not ringing).
UPDPHONE_0;
  LD HL,PHONEQUIET        ; Point HL at the graphic data for the telephone when
                          ; not ringing (at PHONEQUIET)
UPDPHONE_1;
  LD DE,20654             ; Point DE at the display file address of the top
                          ; pixel row of the top-left tile of the telephone
                          ; icon
  LD A,6                  ; Update the top six pixel rows of the top two tiles
UPDPHONE_2;
  LDI                     ; of the telephone icon
  LDI                     ;
  DEC E                   ;
  DEC E                   ;
  INC D                   ;
  DEC A                   ;
  JR NZ,UPDPHONE_2        ;
  LD A,(HL)               ; Update the bottom two pixel rows of the top-left
  LD (DE),A               ; tile of the telephone icon
  INC L                   ;
  INC D                   ;
  LD A,(HL)               ;
  LD (DE),A               ;
  LD B,3                  ; There are three more pixel rows to update
  LD DE,20686             ; Point DE at the display file address of the top
                          ; pixel row of the bottom-left tile of the telephone
                          ; icon
UPDPHONE_3;
  INC L                   ; Update the top three pixel rows of the bottom-left
  LD A,(HL)               ; tile of the telephone icon
  LD (DE),A               ;
  INC D                   ;
  DJNZ UPDPHONE_3         ;
  RET

; Unused
  DEFB 0

; Show or hide an icon in the icon panel
;
; Used by the routine at ICONPANEL1.
;
; E Attribute file address LSB
;
; The main entry point is used to show an icon in the icon panel.
UPDICONS;
  LD A,48                 ; 48=PAPER 6; INK 0
  JR UPDICONS_1
; This entry point is used by the routine at ICONPANEL1 to hide an icon in the
; icon panel.
UPDICONS_0;
  LD A,54                 ; 54=PAPER 6; INK 6
; This entry point is used by the routine at FOUNDOBJ_12 with A=6 (PAPER 0; INK
; 6) to show an icon for an object that can be picked up (by pressing 'G').
UPDICONS_1;
  LD D,90                 ; Point DE at the attribute file address for the
                          ; top-left tile of the icon
  LD (DE),A               ; Set the attributes for the top two tiles of the
  INC E                   ; icon
  LD (DE),A               ;
  SET 6,E                 ; Point DE at the attribute file address for the
  RES 5,E                 ; bottom-right tile of the icon
  LD (DE),A               ; Set the attributes for the bottom two tiles of the
  DEC E                   ; icon
  LD (DE),A               ;
  RET

; Graphic data for the telephone when ringing
;
; Used by the routine at UPDPHONE.
PHONERING;
  DEFB 129,194            ; Top six pixel rows of the top two tiles of the
  DEFB 71,180             ; telephone icon
  DEFB 11,112             ;
  DEFB 11,176             ;
  DEFB 93,196             ;
  DEFB 156,194            ;
  DEFB 8                  ; Bottom two pixel rows of the top-left tile
  DEFB 12                 ;
  DEFB 10                 ; Top three pixel rows of the bottom-left tile
  DEFB 9                  ;
  DEFB 28                 ;

; Unused
;
; These bytes are probably remnants of the graphic data for the telephone when
; ringing (see PHONERING). That these bytes are unused may be a bug.
  DEFB 28,0

; Graphic data for the telephone when not ringing
;
; Used by the routine at UPDPHONE.
PHONEQUIET;
  DEFB 1,192              ; Top six pixel rows of the top two tiles of the
  DEFB 7,176              ; telephone icon
  DEFB 11,112             ;
  DEFB 11,176             ;
  DEFB 9,192              ;
  DEFB 28,192             ;
  DEFB 28                 ; Bottom two pixel rows of the top-left tile
  DEFB 12                 ;
  DEFB 10                 ; Top three pixel rows of the bottom-left tile
  DEFB 9                  ;
  DEFB 8                  ;

; Unused
;
; These bytes are probably remnants of the graphic data for the telephone when
; not ringing (see PHONEQUIET). That these bytes are unused may be a bug.
  DEFB 28,28

; Initialise the icon panel, score box and message line
;
; Used by the routine at PREPGAME.
INITSTATUS;
  LD HL,23208             ; Set the attribute bytes of the icon panel to 54
  LD E,3                  ; (INK 6; PAPER 6), thus hiding every icon
INITSTATUS_0;
  LD BC,3092              ;
INITSTATUS_1;
  LD (HL),54              ;
  INC L                   ;
  DJNZ INITSTATUS_1       ;
  ADD HL,BC               ;
  DEC E                   ;
  JR NZ,INITSTATUS_0      ;
  LD HL,(HISCORE)         ; Collect the high score from HISCORE
  LD DE,20664             ; DE=display file address
  CALL PRINTNUM           ; Print the high score
  LD HL,0                 ; The score starts at 0
  LD DE,20696             ; DE=display file address
  CALL PRINTNUM           ; Print the score
  LD A,50                 ; Sam's cash supply starts at $50
  CALL CHGBUCKS_1         ; Set and print the number of bucks
  JP INITMSGFA            ; Clear the message line and display 8 first aid kits

; Check whether a character is on a roof with edges on each side
;
; Used by the routine at NEXTMOVE. Returns to the caller of that routine with A
; holding 1 (go right), 2 (go left) or 3 (go up) if the character is on the
; roof of the police station or the apartment building next to no. 19 and is
; heading for the edge of that roof. Otherwise returns with the zero flag set
; if the character is standing outside the entrance to a shop or other
; building.
;
; A Identifier for the character's current location (see LOCID)
; H Character number (215-230)
; L 12
ROOFEDGES;
  CP 252                  ; Is the character on the roof of the apartment
                          ; building next to no. 19?
  JR Z,ROOFEDGES_0        ; Jump if so
  CP 108                  ; Is the character on the roof of the police station?
  JR NZ,ROOFEDGES_1       ; Jump if not
ROOFEDGES_0;
  INC A                   ; A=109 (police station) or 253 (apartment building
                          ; next to no. 19)
  CP (HL)                 ; Is the character's destination on the edge of the
                          ; roof of either the police station or the apartment
                          ; building next to no. 19?
  JR Z,ROOFEDGES_2        ; Jump if so
  DEC A                   ; A=108 or 252
ROOFEDGES_1;
  AND 15                  ; Keep only bits 0-3 of the location identifier
  CP 2                    ; Set the zero flag if the character is standing
                          ; outside the entrance to a shop or other building
  RET
; The character is on the roof of the apartment building next to no. 19 or on
; the roof of the police station, and his destination is on the edge of that
; roof.
ROOFEDGES_2;
  POP BC                  ; Drop the return address from the stack
  LD L,10                 ; Point HL at byte 10 of the character's buffer
  LD A,(HL)               ; A=character's destination x-coordinate
  LD L,1                  ; Compare this with the character's current
  CP (HL)                 ; x-coordinate
  DEC HL                  ; Point HL at byte 0 of the character's buffer
  BIT 7,(HL)              ; Set the zero flag if the character is facing left
  LD A,3                  ; A=3 (go up)
  JR C,ROOFEDGES_3        ; Jump if the character is to the right of his
                          ; destination
  RET NZ                  ; Return to the caller of NEXTMOVE with A=3 (go up)
                          ; if the character is to the left of his destination
                          ; and facing right
  LD A,1                  ; A=1 (go right)
ROOFEDGES_3;
  RET Z                   ; Return to the caller of NEXTMOVE with A=1 (go
                          ; right) if the character is to the left of his
                          ; destination and facing left, or with A=3 (go up) if
                          ; the character is to the right of his destination
                          ; and facing left
  DEC A                   ; Return to the caller of NEXTMOVE with A=2 (go left)
  RET                     ; if the character is to the right of his destination
                          ; and facing right

; Unused
  DEFB 0

; Check whether a policeman can spot Sam
;
; Used by the routine at COPTOSAM. Compares the policeman's coordinates with
; Sam's, and returns with the carry flag set if they are close enough that the
; policeman has a chance of spotting Sam (if other conditions are favourable).
;
; H 222 or 223 (policeman)
COPSEESAM;
  LD L,1                  ; Point HL at byte 1 of the policeman's buffer
  LD A,(58881)            ; A=Sam's x-coordinate
  SUB (HL)                ; Subtract the policeman's x-coordinate
  DEC HL                  ; Point HL at byte 0 of the policeman's buffer
  JR NC,COPSEESAM_0       ; Jump if the policeman's x-coordinate is less than
                          ; or equal to Sam's
  NEG                     ; A=horizontal distance between Sam and the policeman
  BIT 7,(HL)              ; Is the policeman facing left (and thus facing Sam)?
  JR Z,COPSEESAM_2        ; Jump if so
  JR COPSEESAM_1
COPSEESAM_0;
  BIT 7,(HL)              ; Is the policeman facing right (and thus facing
                          ; Sam)?
  JR NZ,COPSEESAM_2       ; Jump if so
COPSEESAM_1;
  CP 3                    ; Is the policeman (who is not facing Sam) at least 3
                          ; x-coordinates away from Sam?
  RET NC                  ; Return with the carry flag reset if so
COPSEESAM_2;
  CP 16                   ; Is the policeman at least 16 x-coordinates away
                          ; from Sam?
  RET NC                  ; Return with the carry flag reset if so
; At this point, the policeman is either facing Sam and located less than 16
; x-coordinates away from him, or facing away from Sam and located less than 3
; x-coordinates away from him. Now we check the vertical distance between the
; two characters.
  LD E,A                  ; E=horizontal distance between Sam and the policeman
  LD L,2                  ; Point HL at byte 2 of the policeman's buffer
  LD A,(58882)            ; A=Sam's y-coordinate
  SUB (HL)                ; Subtract the policeman's y-coordinate
  JR NC,COPSEESAM_3       ; Jump if the policeman's y-coordinate is less than
                          ; or equal to Sam's
  NEG
COPSEESAM_3;
  LD D,A                  ; D=vertical distance between Sam and the policeman
  ADD A,E                 ; Add the horizontal distance between Sam and the
                          ; policeman
  CP 33                   ; Set the carry flag if the result is less than 33
  RET

; Unused
  DEFB 0

; Check whether a character is visible to passers-by
;
; Used by the routine at COPTOSAM. Returns with the zero flag set if the
; character is not inside any building, or is in the stairwell of the police
; station or one of the apartment buildings, or is on the catwalk, or is on the
; roof of a building.
;
; H Character number (215-230)
CHRVISIBLE;
  LD L,4                  ; Point HL at byte 4 of the character's buffer
  BIT 0,(HL)              ; Is the character indoors?
  RET Z                   ; Return with the zero flag set if not
; The character is indoors, so examine his location more precisely.
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=x (character's x-coordinate)
  INC A                   ; A=INT((x+1)/8)
  AND 248                 ;
  CP 8                    ; Return if 7<=x<=14 (the character is in the
  RET Z                   ; stairwell of the apartment building at the far left
                          ; of town)
  CP 136                  ; Return if 135<=x<=142 (the character is in the
  RET Z                   ; stairwell of the police station)
  CP 192                  ; Return if 191<=x<=198 (the character is in the
  RET Z                   ; stairwell of the apartment building next to no. 19)
  CP 24                   ; Return if 23<=x<=30 (the character is on the
  RET Z                   ; catwalk)
; The character is neither on the catwalk, nor in a stairwell that is visible
; from outside.
  LD A,(HL)               ; A=x (the character's x-coordinate)
  DEC L                   ; L=0 (this should be 'INC L', so that HL points at
                          ; the character's y-coordinate)
  CP 56                   ; Jump if x<56 (the character is in no. 74 or the
  JR C,CHRVISIBLE_0       ; apartment building next to it)
  CP 104                  ; Return with the zero flag reset if 56<=x<=103 (the
  RET C                   ; character is in the hotel, whose roof is
                          ; inaccessible)
  CP 123                  ; Jump if 104<=x<=122 (the character is in no. 31)
  JR C,CHRVISIBLE_1       ;
  CP 207                  ; Jump if 123<=x<=206 (the character is in the police
  JR C,CHRVISIBLE_0       ; station, no. 27 or the apartment building next to
                          ; no. 19)
  CP 222                  ; Jump if 207<=x<=221 (the character is in no. 19)
  JR C,CHRVISIBLE_1       ;
; If we get here, then the character is in the apartment building at the far
; left of town, no. 74, the police station, no. 27, the apartment building next
; to no. 19, no. 17, or no. 15.
CHRVISIBLE_0;
  LD A,8                  ; If the character's y-coordinate is greater than
                          ; this, he's inside (as opposed to on the roof)
  JR CHRVISIBLE_2
; If we get here, then the character is in no. 31 or no. 19.
CHRVISIBLE_1;
  LD A,14                 ; If the character's y-coordinate is greater than
                          ; this, he's inside (as opposed to on the roof)
; The next instruction is supposed to compare A with the character's
; y-coordinate to see whether he's on the roof of a building (as opposed to
; inside it), but because of the erroneous 'DEC L' instruction above, it
; instead compares A with the character's animatory state. This is a bug.
CHRVISIBLE_2;
  CP (HL)                 ; Compare A (8 or 14) with the character's animatory
                          ; state
  RET C                   ; Return with the zero flag reset if A is smaller
  XOR A                   ; Set the zero flag (the character is visible)
  RET

; Unused
  DEFS 2

; Check whether a character is close enough to Sam to pick him up
;
; Used by the routines at RUNFORSAM and MVCOP2. Returns with the carry flag set
; if the character is facing Sam and close enough to him to pick him up, and
; Sam is not already being carried.
;
; H Character number (215-229)
CHKNEARSAM;
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  DEC A                   ; Now A=0 if Sam's being carried at the moment
  AND A                   ; Clear the carry flag, and set the zero flag if
                          ; Sam's being carried
  RET Z                   ; Return with the carry flag reset if Sam's being
                          ; carried
; Sam is not being carried at the moment. Compare his x- and y-coordinates with
; those of the character chasing him.
  LD L,2                  ; Point HL at byte 2 of the character's buffer
  CALL GETSAMXY           ; Collect Sam's x- and y-coordinates in E and D
  NOP
  LD A,(HL)               ; A=character's y-coordinate
  INC A                   ; Is the character more than one y-coordinate above
  SUB D                   ; or below Sam?
  CP 3                    ;
  RET NC                  ; Return if so
  DEC L                   ; L=1
  LD A,(HL)               ; A=character's x-coordinate
  DEC L                   ; L=0
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,CHKNEARSAM_0       ; Jump if so
  ADD A,2                 ; A=2+character's x-coordinate
CHKNEARSAM_0;
  SUB E                   ; Is the character facing Sam and no more than two
  CP 3                    ; x-coordinates away from him?
  RET NC                  ; Return if not
; The character is facing Sam, no more than one y-coordinate above or below
; him, and no more than two x-coordinates to the left or right of him. Now we
; compare the z-coordinates.
  LD A,(58884)            ; A=Sam's z-coordinate
  LD L,4                  ; Set the zero flag if the character's z-coordinate
  CP (HL)                 ; matches Sam's
CHKNEARSAM_1;
  SCF                     ; Return with the carry flag set if the character can
  RET Z                   ; pick up Sam at his current location
; The z-coordinates don't match. However, the character will still be able to
; pick up Sam if they are both standing at or near the open entrance to a
; building (one inside and the other outside).
  PUSH HL                 ; Save the character number briefly
  LD H,230                ; 230=Sam
  CALL LOCDESCS           ; Obtain descriptors for Sam's current location
  POP HL                  ; Restore the character number to H
  CP 3                    ; Is Sam standing at the open entrance to a building?
  JR Z,CHKNEARSAM_1       ; Jump if so (Sam can be picked up here)
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  CP 3                    ; Is the character standing at the open entrance to a
                          ; building?
  JR Z,CHKNEARSAM_1       ; Jump if so (the character can pick Sam up here)
  AND A                   ; Clear the carry flag (Sam cannot be picked up)
  RET

; Unused
  DEFB 0

; Check whether a character is immobilised by a blown fuse
;
; Used by the routine at MVCHARS. Returns with the carry flag set if the
; character is in an area affected by a blown fuse.
;
; H Character number (215-229)
FROZEN;
  LD L,4                  ; Point HL at byte 4 of the character's buffer
  BIT 0,(HL)              ; Is the character indoors?
  RET Z                   ; Return if not
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=character's x-coordinate
  INC A                   ; Point DE at the entry in the table at BFUSELOCS
  AND 248                 ; that corresponds to the 8-tile wide column of the
  RRA                     ; play area containing the character
  RRA                     ;
  RRA                     ;
  ADD A,192               ;
  LD E,A                  ;
  LD D,255                ;
  LD A,(DE)               ; Point DE at the delay counter for the fuse that is
  LD E,A                  ; in the same building as the character (see
  LD D,127                ; FUSECTRS)
  LD A,(DE)               ; Pick up the blown fuse delay counter in A
  AND A                   ; Return with the carry flag reset if there is no
  RET Z                   ; fuse here, or the fuse is not currently blown
  INC L                   ; L=2
  LD A,E                  ; A=162-167
  LD E,0                  ; For no. 74 or the hotel, use this y-coordinate for
                          ; comparison (the roofs of these buildings are
                          ; inaccessible)
  CP 164                  ; Is it the fuse at no. 74 or the hotel?
  JR C,FROZEN_0           ; Jump if so
  LD E,16                 ; For no. 31 or no. 19, use this y-coordinate for
                          ; comparison (any character on the roof will be
                          ; unaffected by a blown fuse)
  CP 166                  ; Is it the fuse at no. 31 or no. 19?
  JR C,FROZEN_0           ; Jump if so
  LD E,10                 ; For no. 17 or no. 15, use this y-coordinate for
                          ; comparison (any character on the roof will be
                          ; unaffected by a blown fuse)
FROZEN_0;
  LD A,E                  ; A=0 (no. 74 or the hotel), 16 (no. 31 or no. 19),
                          ; or 10 (no. 17 or no. 15)
  CP (HL)                 ; Compare this value with the character's
                          ; y-coordinate
  RET C                   ; Return with the carry flag set if the character is
                          ; inside the building (as opposed to on the roof)
  XOR A                   ; Clear the carry flag
  RET

; Unused
  DEFB 0

; Make a policeman switch a light on if possible
;
; Used by the routine at MVCOP2.
;
; H 222 or 223 (policeman)
COPLIGHT;
  CALL BYLIGHT            ; Is the policeman standing next to a light switch?
  RET Z                   ; Return if not
  BIT 5,A                 ; Set the zero flag if the light switch affects the
                          ; light in only one window or window-pair
  LD A,(BC)               ; A=window flags for the policeman's location
  JP NZ,LSWITCH1_5        ; Jump if the light switch affects the light in more
                          ; than one window or window-pair
  BIT 5,A                 ; Is the light switch here in the 'on' position?
  RET Z                   ; Return if so
  JP LSWITCH1_2           ; Switch the light on

; Unused
  DEFS 4

; Set a character's destination to Sam's current location
;
; Used by the routines at COPTOSCL and HOODTOSAM2. Copies Sam's coordinates and
; location identifier into bytes 10, 11 and 12 of the character's buffer.
;
; H Character number (215-229)
DESTTOSAM;
  CALL GETSAMXY           ; Get Sam's x-, y- and z-coordinates in E, D and A
  LD C,A                  ; C=Sam's z-coordinate
; This entry point is used by the routines at COPTOSLKW and MVCOP2 with H=222
; or 223 (a policeman) and E, D and C holding the destination x-, y- and
; z-coordinates.
DESTTOSAM_0;
  LD L,10                 ; Copy the coordinates into bytes 10 and 11 of the
  LD (HL),E               ; character's buffer, thus making it his destination
  INC L                   ;
  LD (HL),D               ;
; This entry point is used by the routine at GETDEST with DE holding the
; character's destination y- and x-coordinates (copied from his command list)
; and C=1.
DESTTOSAM_1;
  CALL LOCID_0            ; Obtain an identifier for the location whose
                          ; coordinates are in D, E and C
  LD L,12                 ; Copy the location identifier into byte 12 of the
  LD (HL),A               ; character's buffer
  RET

; Set a policeman's destination to Sam's current location
;
; Used by the routines at COPTOSAM and SAMWANTED. Copies Sam's coordinates and
; location identifier into bytes 10, 11 and 12 of the policeman's buffer, and
; also to SAMLOCX (where they can be checked by the other policeman).
;
; H 222 or 223 (policeman), or 127 (when coming from SAMWANTED)
COPTOSCL;
  CALL DESTTOSAM          ; Set the policeman's destination to Sam's current
                          ; location (when coming from COPTOSAM)
; This entry point is used by the routine at COPTOSLKW with HL pointing at byte
; 12 of a policeman's buffer.
COPTOSCL_0;
  LD DE,SAMLOCID          ; Copy either (a) bytes 10, 11 and 12 of the
  LD BC,3                 ; policeman's buffer (which hold his destination
  LDDR                    ; coordinates and location identifier), or (b) Sam's
                          ; coordinates and location identifier (just copied
                          ; into 32522-32524 when coming from SAMWANTED) to
                          ; SAMLOCX
  RET

; Send a policeman to Sam's last known whereabouts
;
; Continues from the routine at CHASESAM. The policeman recently spotted Sam
; while he was wearing a disguise unknown to the police; this routine sends
; that policeman back to where he first spotted Sam when the disguise becomes
; known.
;
; H 222 or 223 (policeman)
COPTOSLKW;
  LD L,31                 ; Pick up byte 31 of the policeman's buffer
  LD A,(HL)               ;
  AND 63                  ; D=Sam's y-coordinate when he was spotted by the
  LD D,A                  ; policeman while wearing a disguise unknown to the
                          ; police
  LD A,(HL)               ; Pick up byte 31 again
  LD C,4                  ; Initialise the destination z-coordinate to 4
  AND 192                 ; Was Sam's z-coordinate 4 (on the sidewalk or road)
                          ; when he was spotted?
  JR Z,COPTOSLKW_0        ; Jump if so
  RLCA                    ; Move bits 6 and 7 of A into bits 0 and 1
  RLCA                    ;
  LD C,A                  ; C=Sam's z-coordinate when he was spotted
COPTOSLKW_0;
  DEC L                   ; L=30
  LD E,(HL)               ; E=Sam's x-coordinate when he was spotted
  CALL DESTTOSAM_0        ; Set the policeman's destination coordinates to
                          ; (E,D)
  CALL COPTOSCL_0         ; Copy the destination coordinates and location
                          ; identifier to SAMLOCX
  LD L,29                 ; Point HL at byte 29 of the policeman's buffer
; This entry point is used by the routine at COPTOSAM.
COPTOSLKW_1;
  LD A,(HL)               ; Pick up byte 29 of the policeman's buffer
  LD (HL),0               ; Set byte 29 of the policeman's buffer to 0 now that
                          ; the disguise Sam was wearing is known to the police
  RLCA                    ; Move bits 5-7 of A (which hold the ID of the
  RLCA                    ; disguise that Sam was wearing) into bits 0-2
  RLCA                    ;
  AND 7                   ; Keep only bits 0-2
  ADD A,160               ; Now A=64, 32, 16, 8, 4, 2, or 1, with the set bit
  LD D,A                  ; corresponding to the disguise that Sam was wearing
  LD E,21                 ;
  LD A,(DE)               ;
  LD DE,GUISEFLAGS        ; GUISEFLAGS holds the disguise status flags
  EX DE,HL                ; Set the appropriate bit at GUISEFLAGS, making the
  OR (HL)                 ; disguise known to the police
  LD (HL),A               ;
  JP GUISEATTR            ; Set the attribute bytes for Sam's current disguise
                          ; in the bottom right corner of the screen

; Make a gangster or policeman pick Sam up
;
; Used by the routines at WAITFORSAM, HOODTOSAM2 and ARRESTSAM.
;
; H Character number (215-229)
LIFTSAM;
  XOR A                   ; OPHONEID holds the ID of the telephone that Sam is
  LD (OPHONEID),A         ; calling; set this to 0, effectively making Sam hang
                          ; up
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  LD A,(HL)               ; A=character's animatory state
  AND 112                 ; Discard bits 0-3 and 7
  SUB 16                  ; 16; Is this character a policeman?
  JR NZ,LIFTSAM_0         ; Jump if not
  LD (COPFLAGS),A         ; Clear all flags at COPFLAGS (Sam is no longer
                          ; wanted by the police, because he's just been
                          ; arrested)
LIFTSAM_0;
  LD A,1                  ; Set bit 0 of Sam's status flags at STATUS,
  LD (STATUS),A           ; indicating that he's being carried
  BIT 0,(HL)              ; Is the character midstride?
  CALL NZ,ENDSTRIDE       ; If so, move the character from the midstride
                          ; position and update the SRB
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  ADD A,8                 ; A=animatory state of the character while carrying
                          ; Sam
  CALL UPDATEAS           ; Update the character's animatory state and location
                          ; and update the SRB
  LD L,9                  ; Remove the address of the primary command routine
  LD (HL),0               ; from bytes 8 and 9 of the character's buffer, thus
                          ; moving to the next command in the command list
  LD HL,1                 ; Set Sam's main action timer (in byte 8 of his
  LD (58888),HL           ; buffer) to 1, and his midstride/mid-action timer
                          ; (in byte 9) to 0
  RET

; Vertical and horizontal ranges within which Sam can be spotted by a policeman
;
; Used by the routine at COPTOSAM. This data table consists of eight entries of
; three bytes each. The exact entry used depends on Sam's and the policeman's
; locations, and whether Sam's disguise is known to the police. A policeman
; will be able to spot Sam if the vertical distance between them is no greater
; than the first byte, the horizontal distance between them is no greater than
; the second byte, and the sum of the horizontal and vertical distances between
; them is no greater than the third byte.
;
; One of the first two entries is used when Sam is neither visible to
; passers-by (according to the routine at CHRVISIBLE) nor standing next to a
; light switch in the 'on' position, and the policeman is not visible to
; passers-by.
VISRANGES;
  DEFB 1,7,7              ; This entry is used when Sam's disguise is unknown
                          ; to the police
  DEFB 3,14,14            ; This entry is used when Sam's disguise is known to
                          ; the police
; One of the next two entries is used when Sam is neither visible to passers-by
; nor standing next to a light switch in the 'on' position, and the policeman
; is visible to passers-by.
  DEFB 2,2,2              ; This entry is used when Sam's disguise is unknown
                          ; to the police
  DEFB 3,9,9              ; This entry is used when Sam's disguise is known to
                          ; the police
; One of the next two entries is used when Sam is standing next to a light
; switch in the 'on' position.
  DEFB 4,12,12            ; This entry is used when Sam's disguise is unknown
                          ; to the police
  DEFB 4,20,20            ; This entry is used when Sam's disguise is known to
                          ; the police
; One of the next two entries is used when either (a) Sam is visible to
; passers-by, or (b) Sam is standing next to a light switch in the 'on'
; position and the policeman is visible to passers-by.
  DEFB 9,9,9              ; This entry is used when Sam's disguise is unknown
                          ; to the police
  DEFB 32,24,32           ; This entry is used when Sam's disguise is known to
                          ; the police

; Make a policeman start chasing Sam if appropriate
;
; Used by the routine at CHASESAM. Returns with the carry flag reset if the
; policeman spots, recognises and starts chasing Sam.
;
; H 222 or 223 (policeman)
COPTOSAM;
  CALL COPSEESAM          ; Is Sam close enough that the policeman has a chance
                          ; of spotting him?
  CCF                     ; Return with the carry flag set if not
  RET C                   ;
  PUSH DE                 ; E and D hold the horizontal and vertical distances
                          ; between Sam and the policeman; save these briefly
  PUSH HL                 ; Save the policeman's character number briefly
  LD H,230                ; 230=Sam
  CALL CHRVISIBLE         ; Check whether Sam is visible to passers-by
  LD B,6                  ; Prepare B for the case where Sam is visible to
                          ; passers-by
  JR Z,COPTOSAM_1         ; Jump if Sam is visible to passers-by
  CALL BYLIGHT            ; Is Sam standing next to a light switch?
  JR Z,COPTOSAM_0         ; Jump if not
  LD A,(BC)               ; A=window flags for Sam's location
  AND 32                  ; Set the zero flag if the light switch for this
                          ; window is in the 'on' position
  LD A,4                  ; Prepare A for the case where Sam is standing next
                          ; to a light switch in the 'on' position
  JR Z,COPTOSAM_0         ; Jump if the light switch for this window is in the
                          ; 'on' position
  XOR A                   ; Prepare A for the case where Sam is neither visible
                          ; to passers-by nor standing next to a light switch
                          ; in the 'on' position
COPTOSAM_0;
  LD B,A                  ; B=0, 4 or 6
; Now B=6 (if Sam is visible to passers-by), or 4 (if Sam is standing next to a
; light switch that is in the 'on' position), or 0 otherwise.
COPTOSAM_1;
  CALL CHKGUISE           ; Check whether Sam's disguise is known to the police
  POP HL                  ; Restore the policeman's character number to H
  POP DE                  ; Restore the horizontal and vertical distances
                          ; between Sam and the policeman to E and D
  LD A,B                  ; A=0, 1, 4, 5, 6 or 7
  CP 6                    ; Is Sam visible to passers-by?
  JR NC,COPTOSAM_2        ; Jump if so
  CALL CHRVISIBLE         ; Is the policeman visible to passers-by?
  JR NZ,COPTOSAM_2        ; Jump if not
  INC B                   ; B=2, 3, 6 or 7
  INC B                   ;
COPTOSAM_2;
  LD A,B                  ; A=0-7
  LD L,A                  ; Save this value in L
  ADD A,A                 ; Point BC at an entry in the table at VISRANGES
  ADD A,B                 ;
  ADD A,10                ;
  LD C,A                  ;
  LD B,114                ;
  LD A,(BC)               ; Pick up the first byte of the entry
  CP D                    ; Compare it with the vertical distance between Sam
                          ; and the policeman
  RET C                   ; Return (with the carry flag set) if the vertical
                          ; distance is greater
  INC C                   ; Pick up the second byte of the entry
  LD A,(BC)               ;
  CP E                    ; Compare it with the horizontal distance between Sam
                          ; and the policeman
  RET C                   ; Return (with the carry flag set) if the horizontal
                          ; distance is greater
  INC C                   ; Pick up the third byte of the entry
  LD A,(BC)               ;
  SUB D                   ; Subtract both the horizontal and vertical distances
  SUB E                   ; between Sam and the policeman
  RET C                   ; Return (with the carry flag set) if the result is
                          ; negative
  BIT 0,L                 ; Bit 0 of L is set if Sam's current disguise (if
                          ; any) is known to the police
  LD L,29                 ; Point HL at byte 29 of the policeman's buffer
  JR NZ,COPTOSAM_4        ; Jump if Sam's current disguise is known to the
                          ; police
; Sam has been spotted by the policeman, but he's wearing a disguise that is
; not (yet) known to the police.
  LD A,(DISGUISEID)       ; Collect Sam's current disguise ID (1-7) from
                          ; DISGUISEID
  RRCA                    ; Move bits 0-2 into bits 5-7
  RRCA                    ;
  RRCA                    ;
  LD C,A                  ; Copy these disguise identifier bits into C
  LD A,(HL)               ; Pick up byte 29 of the policeman's buffer
  AND 31                  ; Keep only bits 0-4 (the disguise timeout counter)
  JR NZ,COPTOSAM_3        ; Jump unless they are all 0
  LD A,16                 ; The disguise timeout counter will be initialised to
                          ; 16
COPTOSAM_3;
  OR C                    ; Copy the disguise identifier bits from C into bits
                          ; 5-7 of A
  LD (HL),A               ; Copy the disguise identifier bits and the timeout
                          ; counter into byte 29 of the policeman's buffer
  INC L                   ; L=30
  CALL GETSAMXY           ; Determine Sam's location
  LD (HL),E               ; Copy Sam's x-coordinate into byte 30 of the
                          ; policeman's buffer
  INC L                   ; L=31
  AND 3                   ; A=0 if z (Sam's z-coordinate) is 4, 2 if z is 2, or
                          ; 1 if z is 1
  RRCA                    ; A=0 if z=4, 128 (bit 7 set) if z=2, or 64 (bit 6
  RRCA                    ; set) if z=1
  OR D                    ; Copy Sam's y-coordinate into bits 0-5 of A
  LD (HL),A               ; Copy this value into byte 31 of the policeman's
                          ; buffer
  SCF                     ; Set the carry flag; the policeman is not chasing
                          ; Sam
  RET
; Sam has been spotted by the policeman, and his current disguise (if any) is
; known to the police.
COPTOSAM_4;
  LD A,(HL)               ; Collect byte 29 of the policeman's buffer
  AND A                   ; Is there a disguise ID in bits 5-7?
  CALL NZ,COPTOSLKW_1     ; If so, make that disguise known to the police (if
                          ; it isn't already)
  CALL COPTOSCL           ; Set the policeman's destination to Sam's current
                          ; location
  AND A                   ; Clear the carry flag to indicate that the policeman
                          ; is now chasing Sam
  RET

; Check whether Sam's disguise is known to the police
;
; Used by the routines at COPTOSAM and GUISEATTR. Returns with the appropriate
; attribute byte to use for Sam's current disguise in A. Also sets bit 0 of B
; if Sam's disguise is known to the police.
;
; B 0, 4 or 6 (when called from COPTOSAM)
CHKGUISE;
  LD A,(DISGUISEID)       ; A=Sam's current disguise ID (0-7)
  ADD A,160               ; Byte 21 of pages 160-167 holds the values 128, 64,
  LD H,A                  ; 32, 16, 8, 4, 2 and 1
  LD L,21                 ;
  LD A,(GUISEFLAGS)       ; Collect the disguise status flags from GUISEFLAGS
  AND (HL)                ; Set the zero flag if this disguise is unknown to
                          ; the police
  LD HL,23229             ; 23229 holds the attribute byte for the top-left
                          ; tile of Sam's disguise in the bottom right of the
                          ; screen
  LD A,79                 ; 79=INK 7; PAPER 1; BRIGHT 1
  RET Z                   ; Return if this disguise is unknown to the police
  INC B                   ; Set bit 0 of B to indicate that Sam's disguise is
                          ; known to the police
  LD A,87                 ; 87=INK 7; PAPER 2; BRIGHT 1
  RET

; Control a policeman (1)
;
; Used by the command list at CLIST02. Makes the policeman begin patrol duty,
; and chase and pick up Sam when appropriate.
;
; H 222 or 223 (policeman)
MVCOP1;
  LD L,8                  ; Change the address of the primary command routine
  LD (HL),177             ; in bytes 8 and 9 of the policeman's buffer to
                          ; MVCOP2
  JP MVCOP2_8             ; Send the policeman to a randomly chosen spot on the
                          ; sidewalk or road

; Control a policeman (2)
;
; The address of this primary command routine is placed into bytes 8 and 9 of a
; policeman's buffer by the routine at MVCOP1. It makes the policeman continue
; patrol duty, and chase and pick up Sam when appropriate.
;
; H 222 or 223 (policeman)
MVCOP2;
  CALL MIDSTRIDE          ; Exit now if the policeman is midstride
  CALL CHKWANTED          ; Is Sam wanted by the police at the moment?
  RRA                     ;
  JR NC,MVCOP2_4          ; Jump if not
  LD L,8                  ; Change the address of the primary command routine
  LD (HL),190             ; in bytes 8 and 9 of the policeman's buffer to
                          ; MVCOP2_0 (below)
; This entry point is used when the policeman is not chasing Sam.
MVCOP2_0;
  CALL MIDSTRIDE          ; Exit now if the policeman is midstride
  CALL CHKWANTED          ; Is Sam wanted by the police at the moment?
  RRA                     ;
  JR C,MVCOP2_1           ; Jump if so
  LD L,29                 ; Clear any disguise identifier and timeout counter
  LD (HL),0               ; in byte 29 of the policeman's buffer
  LD L,3                  ; Reset bit 7 of byte 3 of the policeman's buffer (no
  RES 7,(HL)              ; need to run if Sam's not wanted by the police)
  LD L,8                  ; Change the address of the primary command routine
  LD (HL),177             ; in bytes 8 and 9 of the policeman's buffer to
                          ; MVCOP2
  JR MVCOP2_4             ; Determine the policeman's next move
; Sam is wanted by the police.
MVCOP2_1;
  CALL CHASESAM           ; Make the policeman start chasing Sam if he spots
                          ; him, or go to Sam's last known whereabouts if Sam's
                          ; disguise has become known to the police
  JR NC,MVCOP2_2          ; Jump if the policeman is now doing either of those
                          ; things
  LD DE,SAMLOCY           ; SAMLOCY holds the y-coordinate of the location the
                          ; police should be heading for to get Sam
  LD A,(DE)               ; Pick it up in A
  AND A                   ; Do the police know where they should be heading to
                          ; get Sam?
  JR Z,MVCOP2_4           ; Jump if not to make the policeman continue to go
                          ; about his normal business
  DEC E                   ; DE=SAMLOCX
  LD BC,3                 ; Copy the coordinates and location identifier of the
  LD L,10                 ; spot to which the police should be heading to get
  EX DE,HL                ; Sam into byte 10-12 of the policeman's buffer, thus
  LDIR                    ; making it his destination
  EX DE,HL                ;
MVCOP2_2;
  LD L,3                  ; Set bit 7 of byte 3 of the policeman's buffer (to
  SET 7,(HL)              ; make him run)
  LD L,8                  ; Change the address of the primary command routine
  LD (HL),245             ; in bytes 8 and 9 of the policeman's buffer to
                          ; CHASINGSAM (below)
  JR MVCOP2_4
; This entry point is used when the policeman is chasing Sam or heading to his
; last known whereabouts.
CHASINGSAM;
  CALL CHKWANTED          ; Should the police be chasing Sam at the moment?
  RRA                     ;
  JR NC,MVCOP2_0          ; Jump if not
  LD A,(DISGUISEID)       ; Collect the ID of Sam's current disguise from
                          ; DISGUISEID
  ADD A,160               ; B=160-167
  LD B,A                  ;
  EX DE,HL                ; Transfer the policeman's character number to D
                          ; briefly
  LD C,21                 ; Point BC at byte 21 of one of the pages 160-167,
                          ; which hold the values 128, 64, 32, 16, 8, 4, 2 and
                          ; 1
  LD HL,GUISEFLAGS        ; The disguise status flags are stored at GUISEFLAGS
  LD A,(BC)               ; Set the zero flag if Sam's disguise is unknown to
  AND (HL)                ; the police
  EX DE,HL                ; Transfer the policeman's character number back to H
  JR Z,MVCOP2_3           ; Jump if Sam's disguise is unknown to the police
  CALL CHKNEARSAM         ; Is the policeman close enough to Sam to pick him
                          ; up?
  JR NC,MVCOP2_3          ; Jump if not
  XOR A                   ; Clear the y-coordinate of the spot to which the
  LD (SAMLOCY),A          ; police should run to get Sam at SAMLOCY (Sam has
                          ; been caught)
  LD L,29                 ; Clear any disguise ID and timeout counter in byte
  LD (HL),A               ; 29 of the policeman's buffer
  JP ARRESTSAM            ; End the game if Sam has less than $46, or make the
                          ; policeman pick Sam up
; Sam's disguise is unknown to the police, or the policeman is not close enough
; to Sam to pick him up.
MVCOP2_3;
  CALL MIDSTRIDE          ; Exit now if the policeman is midstride
  CALL CHASESAM           ; Make the policeman start chasing Sam if his
                          ; disguise becomes known
  CALL COPLIGHT           ; Make the policeman switch a light on if possible
MVCOP2_4;
  CALL NEXTMOVE           ; Determine the next move the policeman should make
                          ; to reach his destination
; This entry point is used by the routine at GOTO with A=1-6.
MVCOP2_5;
  CP 5                    ; Is the character standing behind or in front of a
                          ; closed door?
  JP NC,GOTO_9            ; Jump if so
  AND A                   ; Is the character already at his destination?
  JP NZ,GOTO_4            ; Jump if not
; The policeman has reached his destination.
  LD L,8                  ; Collect the LSB of the primary command routine
  LD A,(HL)               ; address from byte 8 of the policeman's buffer
  CP 245                  ; Is the primary command routine address CHASINGSAM
                          ; (which is true if the policeman was either chasing
                          ; Sam or heading towards his last known whereabouts)?
  JR C,MVCOP2_8           ; If not, send the policeman to a randomly chosen
                          ; spot on the sidewalk or road
  LD DE,SAMLOCY           ; Collect the y-coordinate of the location to which
  LD A,(DE)               ; the police should run to get Sam from SAMLOCY
  AND A                   ; Do the police know where to run to get Sam?
  JR Z,MVCOP2_6           ; Jump if not
  LD L,2                  ; Point HL at byte 2 of the policeman's buffer
  CP (HL)                 ; Compare the policeman's y-coordinate with that of
                          ; the spot to which the police should run to get Sam
  DEC DE                  ; DE=32731
  JR NZ,MVCOP2_7          ; Jump unless the policeman's y-coordinate matches
  DEC L                   ; L=1
  LD A,(DE)               ; A=x-coordinate of the spot to which the police
                          ; should run to get Sam
  SUB (HL)                ; Does it match the policeman's x-coordinate?
  JR NZ,MVCOP2_7          ; Jump if not
  INC E                   ; Set SAMLOCY to 0 now that a policeman has made it
  LD (DE),A               ; to the spot to which the police should run to get
                          ; Sam
MVCOP2_6;
  LD L,3                  ; Reset bit 7 of byte 3 of the policeman's buffer (to
  RES 7,(HL)              ; make him stop running)
  LD L,8                  ; Change the address of the primary command routine
  LD (HL),190             ; in bytes 8 and 9 of the policeman's buffer to
                          ; MVCOP2_0 (above)
  JR MVCOP2_8             ; Send the policeman to a randomly chosen spot on the
                          ; sidewalk or road
MVCOP2_7;
  LD L,10                 ; Copy the coordinates and location identifier of the
  LD BC,3                 ; spot to which the police should run to get Sam from
  EX DE,HL                ; SAMLOCX into bytes 10-12 of the policeman's buffer,
  LDIR                    ; thus making it his destination
  EX DE,HL                ; Point HL back at the policeman's buffer
  JR MVCOP2_4             ; Determine the policeman's next move
; This entry point is used by the routine at MVCOP1. It sets the policeman's
; destination to a randomly chosen spot on the sidewalk or road.
MVCOP2_8;
  CALL GETRANDOM          ; Get a random number in A
COPDESTOR;
  OR 0                    ; The operand of this OR instruction is changed by
                          ; the routine at EVENTS; to 0 (using the event entry
                          ; at EVENT01), or to 192 (using the event entry at
                          ; EVENT10) to keep the policeman close to Sam's
                          ; office
  AND 253                 ; Discard bit 1
  LD E,A                  ; Copy this x-coordinate to E
  CALL RDORSWALK_2        ; Set the carry flag if there is no sidewalk at this
                          ; x-coordinate
  ADC A,34                ; A=34 (if there is sidewalk) or 35 (if there is no
  SUB E                   ; sidewalk)
  LD D,A                  ; Copy this y-coordinate to D
  LD C,0                  ; Clear bit 0 of C to indicate that the destination
                          ; is not indoors
  CALL DESTTOSAM_0        ; Set the policeman's destination to the coordinates
                          ; in E, D and C
  JR MVCOP2_4             ; Determine the policeman's next move

; Unused
  DEFB 0

; Make a policeman chase Sam or go to his last known whereabouts if appropriate
;
; Used by the routine at MVCOP2. Returns with the carry flag reset if the
; policeman starts either chasing Sam, or returning to where he first spotted
; Sam wearing a disguise that has just become known to the police.
;
; H 222 or 223 (policeman)
CHASESAM;
  CALL COPTOSAM           ; Make the policeman start chasing Sam if appropriate
  RET NC                  ; Return if the policeman is now chasing Sam
  LD L,29                 ; Pick up byte 29 of the policeman's buffer
  LD A,(HL)               ;
  AND A                   ; Was Sam recently spotted by the policeman while
                          ; wearing a disguise that is unknown to the police?
  SCF                     ; Return with the carry flag set if not
  RET Z                   ;
  DEC (HL)                ; Decrement the disguise timeout counter in bits 0-4
                          ; of byte 29 of the policeman's buffer
  LD A,(HL)               ; Pick up the result
  AND 31                  ; Has the disguise timeout counter reached 0 (meaning
                          ; that the disguise should now become known to the
                          ; police)?
  SCF                     ; Return with the carry flag set if not
  RET NZ                  ;
  JP COPTOSLKW            ; Make the disguise known to the police, and send the
                          ; policeman back to where he first spotted Sam
                          ; wearing the disguise

; Check whether Sam or a gangster is inside a region
;
; Used by the routines at CHKCHASE and HOODTOSAM2. On entry, HL points at the
; first or second entry in a table of region definitions (at HOODREG1,
; HOODREG2, HOODREG3, HOODREG4 or HOODREG5) used by a gangster who is on the
; lookout for Sam. On exit, the carry flag is set if Sam or the gangster is
; outside the region.
;
; D Gangster's character number (215-224), or 230 (Sam)
; HL Address of a region definition
CHKREGION;
  LD E,1                  ; A=Sam's or the gangster's x-coordinate
  LD A,(DE)               ;
  CP (HL)                 ; Is Sam or the gangster to the left of the region?
  RET C                   ; Return with the carry flag set if so
  INC HL                  ; Point HL at the upper x-coordinate
  CP (HL)                 ; Is Sam or the gangster to the right of the region?
  CCF                     ; Return with the carry flag set if so
  RET C                   ;
  INC HL                  ; Point HL at the lower y-coordinate
  INC E                   ; A=Sam's or the gangster's y-coordinate
  LD A,(DE)               ;
  CP (HL)                 ; Is Sam or the gangster above the region?
  RET C                   ; Return with the carry flag set if so
  INC HL                  ; Point HL at the upper y-coordinate
  CP (HL)                 ; Compare it with Sam's or the gangster's
                          ; y-coordinate
  INC HL                  ; Point HL at either the disguise ID, or the first
                          ; byte of the second entry in the table of region
                          ; definitions
  CCF                     ; Set the carry flag if Sam or the gangster is below
                          ; the region
  RET

; Check whether a gangster should start chasing Sam
;
; Used by the routine at HOODWALK. Returns with the carry flag reset if Sam is
; close enough (and not disguised well enough) that the gangster should start
; chasing him, and the appropriate command list offset in A.
;
; H Gangster's character number (215-224)
CHKCHASE;
  CALL SETA1              ; Set A=1
  DEC A                   ; Set the zero flag
  SCF                     ; Set the carry flag
  RET NZ                  ; This return never happens
  LD L,23                 ; Point HL at byte 23 of the gangster's buffer
  LD E,(HL)               ; Collect the command list start address in DE
  INC L                   ;
  LD D,(HL)               ;
  LD B,H                  ; B=gangster's character number
  LD HL,65530             ; Point HL at the second entry in the relevant table
  ADD HL,DE               ; of region definitions at HOODREG1, HOODREG2,
                          ; HOODREG3, HOODREG4 or HOODREG5
  LD D,230                ; 230=Sam
  CALL CHKREGION          ; Is Sam inside the region?
  JR C,CHKCHASE_0         ; Jump if not
  LD A,(DISGUISEID)       ; Collect the ID of Sam's current disguise (0-7) from
                          ; DISGUISEID
  CP (HL)                 ; Compare it with the disguise ID in the region
                          ; definition table
  SCF                     ; Set the carry flag
  JR Z,CHKCHASE_0         ; Jump if Sam's current disguise matches (the
                          ; gangster will let Sam pass)
  INC HL                  ; Collect the command list offset from the region
  LD A,(HL)               ; definition table
  AND A                   ; Clear the carry flag
CHKCHASE_0;
  LD H,B                  ; H=gangster's character number
  RET

; Unused
  DEFS 3

; Locations of fuses
;
; Used by the routine at BYFUSE. The locations are stored as (y,x) coordinate
; pairs.
FUSELOCS;
  DEFB 19,33              ; No. 74 (third floor)
  DEFB 7,66               ; Hotel (top floor)
  DEFB 19,105             ; No. 31 (top floor)
  DEFB 13,208             ; No. 19 (roof)
  DEFB 25,224             ; No. 17 (second floor)
  DEFB 13,241             ; No. 15 (top floor)

; x-coordinates of doors
;
; Used by the routine at ICONPANEL2. The first data table contains the
; x-coordinates of the front doors of the houses.
HOUSEDOORX;
  DEFB 42,43              ; No. 74
  DEFB 114,115            ; No. 31
  DEFB 155,156            ; No. 27
  DEFB 210,211            ; No. 19
  DEFB 235,236            ; No. 17
  DEFB 251,252            ; No. 15
  DEFB 255                ; End marker
; The next data table contains the x-coordinates of the doors to the shops.
SHOPDOORX;
  DEFB 0                  ; Left-hand shop under the apartments next to no. 74
  DEFB 15,16              ; Right-hand shop under the apartments next to no. 74
  DEFB 223,224            ; Shop under no. 17
  DEFB 239,240            ; Shop under no. 15
  DEFB 255                ; End marker

; Show or hide the fuse, door, light bulb or phone in the icon panel (1)
;
; Used by the routines at CUTSCENE and MNLPTASKS2. Shows or hides the fuse,
; door, light bulb or phone in the icon panel depending on Sam's current
; location and activity.
ICONPANEL1;
  LD HL,SAMCBUF           ; Point HL at byte 0 of Sam's buffer
  BIT 0,(HL)              ; Is Sam midstride?
  RET NZ                  ; Return if so
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND A                   ; Is Sam engaged in an action at the moment?
  JR Z,ICONPANEL1_2       ; Jump if not
; This entry point is used by the routine at ICONPANEL2. Now that the relevant
; bits at IPFLAGS have been set or reset, it's time to show or hide the fuse,
; door, light bulb or phone in the icon panel.
ICONPANEL1_0;
  LD B,4                  ; There are four icons to show or hide
  LD A,(IPFLAGS)          ; Collect the icon panel status flags from IPFLAGS
  LD E,166                ; E will hold the LSB of the attribute file address
                          ; for the icon; initialise it to 166
ICONPANEL1_1;
  INC E                   ; Set E to the LSB of the attribute file address for
  INC E                   ; the next icon in the panel
  ADD A,A                 ; Set the carry flag if this icon should be shown
  PUSH AF                 ; Save the icon status flags
  PUSH DE                 ; Save the LSB of the attribute file address
  CALL C,UPDICONS         ; Reveal the icon if necessary
  CALL NC,UPDICONS_0      ; Or hide it if necessary
  POP DE                  ; Restore the LSB of the attribute file address to E
  POP AF                  ; Restore the icon status flags to A
  DJNZ ICONPANEL1_1       ; Jump back until the fuse, door, light bulb and
                          ; phone icons have been revealed or hidden
  LD (IPFLAGS),A          ; Clear all the icon panel status flags at IPFLAGS
  RET
; Sam is not engaged in any action at the moment (no status flags at STATUS are
; set).
ICONPANEL1_2;
  LD A,(COPFLAGS)         ; Collect the police flags from COPFLAGS
  RLCA                    ; Is Sam in jail?
  JR C,ICONPANEL2_2       ; Jump if so
  LD L,2                  ; Point HL at byte 2 of Sam's buffer
  JR ICONPANEL2           ; Check whether Sam is standing next to a fuse, door,
                          ; light switch or telephone, and return here to
                          ; update the icon panel as appropriate

; Clear the message line and display the first aid kits
;
; Used by the routine at INITSTATUS.
INITMSGFA;
  CALL QUEUEMSG_7         ; Clear the message line
; This entry point is used by the routine at CHKSHOT to display the remaining
; first aid kits.
INITMSGFA_0;
  LD A,(LIVES)            ; LIVES holds the number of first aid kits
  LD HL,23272             ; Point HL at the attribute byte for the leftmost
                          ; first aid kit in the icon panel
  LD BC,2098              ; B=8, C=50 (INK 2; PAPER 6)
  JP FOUNDOBJ_15          ; Set the attribute bytes for the first aid kits

; Unused
  DEFS 2

; Show or hide the fuse, door, light bulb or phone in the icon panel (2)
;
; Continues from the routine at ICONPANEL1. Checks whether Sam is standing next
; to a fuse, door, light switch or telephone, and updates the icon panel as
; appropriate.
;
; HL 58882 (byte 2 of Sam's buffer)
ICONPANEL2;
  LD A,(HL)               ; A=Sam's y-coordinate
  LD DE,HOUSEDOORX        ; Point DE at the list of x-coordinates of the house
                          ; doors (at HOUSEDOORX)
  CP 31                   ; 31 is the y-coordinate of the house doors
  JR Z,ICONPANEL2_0       ; Jump if Sam's y-coordinate is 31
  CP 33                   ; 33 is the y-coordinate of the shop doors
  JR NZ,ICONPANEL2_3      ; Jump unless Sam's y-coordinate is 33
  LD E,220                ; DE=SHOPDOORX (list of x-coordinates of shop doors)
ICONPANEL2_0;
  DEC L                   ; L=1
ICONPANEL2_1;
  LD A,(DE)               ; A=x-coordinate of a door (or 255)
  INC E                   ; Point DE at the next x-coordinate in the list
  INC A                   ; Have we reached the end of the list?
  JR Z,ICONPANEL2_3       ; Jump if so (Sam's not standing next to a door)
  DEC A                   ; A=x-coordinate of the door
  CP (HL)                 ; Is Sam's x-coordinate the same?
  JR NZ,ICONPANEL2_1      ; Jump back if not to check the next door
; This entry point is used by the routine at ICONPANEL1.
ICONPANEL2_2;
  LD A,(IPFLAGS)          ; Set bit 6 at IPFLAGS; door icon
  SET 6,A                 ;
  LD (IPFLAGS),A          ;
ICONPANEL2_3;
  LD L,4                  ; Point HL at byte 4 of Sam's buffer
  BIT 0,(HL)              ; Is Sam indoors?
  JP Z,ICONPANEL1_0       ; Update the icon panel now if not
  LD L,2                  ; A=Sam's y-coordinate
  LD A,(HL)               ;
  CP 33                   ; Is Sam inside a shop?
  JR Z,ICONPANEL2_5       ; Jump if so
ICONPANEL2_4;
  SUB 6                   ; Keep subtracting 6 (the height of a floor) from
  JR NC,ICONPANEL2_4      ; Sam's y-coordinate until it's negative
  CP 251                  ; Is Sam's y-coordinate 1, 7, 13, 19, 25 or 31?
  JP NZ,ICONPANEL1_0      ; Update the icon panel now if not (Sam's on a
                          ; staircase)
  CALL BYFUSE             ; Is Sam standing next to a fuse that has not been
                          ; blown yet?
  JR NZ,ICONPANEL2_5      ; Jump if not
  LD HL,IPFLAGS           ; Set bit 7 at IPFLAGS; fuse icon
  SET 7,(HL)              ;
  LD H,230                ; 230=Sam
ICONPANEL2_5;
  CALL BYLIGHT            ; Is Sam standing next to a light switch?
  JR Z,ICONPANEL2_6       ; Jump if not
  LD HL,IPFLAGS           ; Set bit 5 at IPFLAGS; light bulb icon
  SET 5,(HL)              ;
  LD H,230                ; 230=Sam
ICONPANEL2_6;
  CALL BYPHONE            ; Is Sam standing next to a telephone?
  JP Z,ICONPANEL1_0       ; Update the icon panel now if not
; Sam is standing next to a telephone. Before showing the telephone icon, we
; need to update the icon graphic depending on whether the phone is ringing.
  LD HL,IPFLAGS           ; Set bit 4 at IPFLAGS; telephone icon
  SET 4,(HL)              ;
  JR C,ICONPANEL2_7       ; Jump if the telephone is not ringing
  LD A,(23672)            ; Collect the value of the system variable FRAMES,
                          ; which is incremented every 20ms
  BIT 5,A                 ; Bit 5 of FRAMES alternates every 0.64s
  JR Z,ICONPANEL2_7       ; Jump if it's zero now
  LD A,(20654)            ; This is the display file address for the byte in
                          ; the top-left corner of the telephone icon
  DEC A                   ; Is the telephone icon in the ringing phase at the
                          ; moment?
  CALL Z,UPDPHONE         ; If not, make it so
  JR ICONPANEL2_8
ICONPANEL2_7;
  LD A,(20654)            ; This is the display file address for the byte in
                          ; the top-left corner of the telephone icon
  DEC A                   ; Is the telephone icon in the ringing phase at the
                          ; moment?
  CALL NZ,UPDPHONE_0      ; If so, make it appear still (as when between rings)
ICONPANEL2_8;
  JP ICONPANEL1_0         ; Update the icon panel

; Unused
  DEFS 3

; Check whether Sam is standing next to a telephone
;
; Used by the routines at ICONPANEL2 and PHONE. Returns with the zero flag
; reset if Sam is standing next to a telephone, and the carry flag reset as
; well if the telephone is ringing.
;
; H 230 (Sam)
BYPHONE;
  CALL BYPHONEX           ; Is the x-coordinate of the front column of Sam's
                          ; sprite between 1 and 6 mod 8 (where phones can be
                          ; picked up)?
  RET Z                   ; Return if not
  NOP
  CALL BYLIGHT_1          ; Is Sam standing next to a telephone?
  RET Z                   ; Return if not
  JP RINGING              ; Check whether the phone is ringing

; 'F' pressed - fuse
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'F' is
; pressed.
;
; H 230 (Sam)
FUSE;
  CALL BYFUSE             ; Is Sam standing next to a fuse that has not yet
                          ; been blown?
  JR NZ,FUSE_1            ; Jump if not
  LD HL,FUSEFLAGS         ; FUSEFLAGS holds the fuse flags
  LD A,(HL)               ; Indicate that this fuse has been blown by setting
  OR C                    ; the relevant flag
  LD (HL),A               ;
  LD L,161                ; Point HL at the relevant blown fuse delay counter
FUSE_0;
  INC L                   ; in the table at FUSECTRS
  RRC C                   ;
  JR NC,FUSE_0            ;
  LD (HL),96              ; Initialise the delay counter
  CALL CHKFUSES_2         ; Switch off all the lights affected by the fuse
  LD H,230                ; 230=Sam
FUSE_1;
  JP RAISEARM             ; Raise Sam's arm and make a sound effect

; Unused
  DEFS 2

; Addresses of Sam-handling routines
;
; Used by the routine at HANDLESAM.
SAMHR;
  DEFW ROOFEDGE_5         ; Used when bit 7 is set at STATUS (Sam is falling
                          ; from the roof of a building)
  DEFW SAMBYDOOR          ; Used when bit 6 is set at STATUS (Sam is knocking
                          ; on or opening a door)
  DEFW ARMDOWN            ; Used when bit 5 is set at STATUS (Sam's arm is
                          ; raised or his knees are bent)
  DEFW ONPHONE            ; Used when bit 4 is set at STATUS (Sam is on the
                          ; phone)
  DEFW SOMERSAULT_1       ; Used when bit 3 is set at STATUS (Sam is rolling or
                          ; somersaulting)
  DEFW 0                  ; Unused
  DEFW SAMLANA            ; Used when bit 1 is set at STATUS (Sam is transfixed
                          ; by Lana)
  DEFW CARRIED            ; Used when bit 0 is set at STATUS (Sam is being
                          ; carried)

; Deal with Sam
;
; Called from the main loop at MAINLOOP when one of Sam's status flags at
; STATUS is set, indicating that he is in the middle of an action. Returns with
; the zero flag set if Sam has finished the action by the end of the routine.
HANDLESAM;
  LD HL,58888             ; Decrement Sam's main action timer in byte 8 of his
  DEC (HL)                ; buffer
  RET NZ                  ; Return unless it's time to deal with Sam
  LD HL,HANDLESAM_1       ; We will continue at HANDLESAM_1 (below) after
  PUSH HL                 ; calling the routine to handle Sam
  LD L,198                ; HL=29894
  LD A,(STATUS)           ; Pick up Sam's status flags from STATUS
HANDLESAM_0;
  INC L                   ; Point HL at one of the entries in the table of
  INC L                   ; Sam-handling routine addresses at SAMHR
  RLCA                    ;
  JR NC,HANDLESAM_0       ;
  LD C,(HL)               ; Collect the routine address into BC
  INC L                   ;
  LD B,(HL)               ;
  PUSH BC                 ; Push it onto the stack, ready for an indirect jump
  LD HL,SAMCBUF           ; Point HL at byte 0 of Sam's buffer
  RET                     ; Make an indirect jump to the Sam-handling routine
; We come here after the Sam-handling routine has returned.
HANDLESAM_1;
  LD HL,STATUS            ; STATUS holds Sam's status flags
  LD A,(HL)               ; Pick them up in A
  AND A                   ; Has Sam finished the action yet?
  RET Z                   ; Return with the zero flag set if so
  LD A,(58888)            ; Collect Sam's main action timer from byte 8 of his
                          ; buffer
  AND A                   ; Did the Sam-handling routine set the action timer
                          ; to a non-zero value (meaning that the action is
                          ; still in progress)?
  RET NZ                  ; Return with the zero flag reset if so
  LD (HL),A               ; Otherwise clear all of Sam's status flags at STATUS
  RET                     ; Return with the zero flag set

; Process the event table
;
; Used by the routine at MNLPTASKS2. Scans the event table at EVENT01 and
; processes every active entry.
EVENTS;
  LD HL,INITOBJ_0         ; Set the operand of the JP instruction at EVENTJP
  LD (29964),HL           ; (below) to INITOBJ_0 (RET)
  LD HL,EVENT01           ; Point HL at the event table at EVENT01
EVENTS_0;
  LD A,(HL)               ; Collect the first byte of an entry
  INC A                   ; Set the zero flag if it's 255
; The operand of the JP instruction that follows is changed (by this routine)
; using entries in the event table at EVENT01 during the game as follows;
;
; +-----------+---------+----------------------------------------------------+
; | Operand   | Entry   | Occasion                                           |
; +-----------+---------+----------------------------------------------------+
; | SAMWANTED | EVENT05 | Sam finds the dead body in the hotel               |
; | PREPMODE  | EVENT04 | Sam enters no. 15 using the key (in game mode 1)   |
; | PREPMODE  | EVENT08 | Sam climbs the stairs up to the roof of the        |
; |           |         | apartment building next to no. 74 (in game mode 2, |
; |           |         | after he has entered the hotel's right-hand green  |
; |           |         | room while disguised as a woman)                   |
; +-----------+---------+----------------------------------------------------+
EVENTJP;
  JP Z,INITOBJ_0          ; Jump if we've reached the end of the event table
  AND 2                   ; Is this event active?
  JR NZ,EVENTS_2          ; Jump if not
  PUSH HL                 ; Save the event table entry pointer
  INC HL                  ; Point HL at the third byte of the entry
  INC HL                  ;
  LD B,(HL)               ; B=number of conditions to check
EVENTS_1;
  INC HL                  ; DE=address to check
  LD E,(HL)               ;
  INC HL                  ;
  LD D,(HL)               ;
  INC HL                  ; A=opcode of the 'JR' instruction to place at
  LD A,(HL)               ; EVENTJR (below)
  INC HL                  ; Point HL at the value to compare with (DE)
  LD (EVENTJR),A          ; Set the instruction at EVENTJR (below) to 'JR Z',
                          ; 'JR NZ', 'JR C' or 'JR NC' as appropriate
  LD A,(DE)               ; Check the condition
  CP (HL)                 ;
EVENTJR;
  JR EVENTS_3             ; This instruction is set to 'JR Z', 'JR NZ', 'JR C'
                          ; or 'JR NC' above
  POP HL                  ; Restore the event table entry pointer to HL
EVENTS_2;
  INC HL                  ; Point HL at the second byte of the entry
  LD E,(HL)               ; Move HL along to the first byte of the next entry
  LD D,0                  ;
  ADD HL,DE               ;
  JR EVENTS_0             ; Jump back to examine the next entry
EVENTS_3;
  DJNZ EVENTS_1           ; Jump back to check the next condition in the entry
; If we get here, then every condition in the entry was satisfied.
  INC HL                  ; B=number of POKEs in the entry
  LD B,(HL)               ;
EVENTS_4;
  INC HL                  ; DE=address to POKE
  LD E,(HL)               ;
  INC HL                  ;
  LD D,(HL)               ;
  INC HL                  ; A=byte to POKE
  LD A,(HL)               ;
  LD (DE),A               ; Do the POKE
  DJNZ EVENTS_4           ; Jump back until every POKE has been done
; The entry has been processed.
  POP HL                  ; Restore the event table entry pointer to HL
  BIT 6,(HL)              ; Should this entry be deactivated now?
  JR NZ,EVENTS_2          ; Move along to the next entry if not
  INC (HL)                ; Otherwise deactivate the entry by setting bit 0 of
                          ; the first byte
  JR EVENTS_2             ; Move along to the next entry

; Initialise the events and objects for a new game
;
; Continues from the routine at PREPOBJS. First we initialise the entries in
; the event table at EVENT01.
INITOBJS;
  LD HL,EVENT01           ; The event table starts at EVENT01
  LD DE,0                 ; DE will be used to move HL from one entry to the
                          ; next; initialise it to 0
INITOBJS_0;
  ADD HL,DE               ; Point HL at the next entry in the table
  CALL INITOBJ            ; Initialise the entry
  INC HL                  ; Prepare DE to point HL at the next event entry
  LD E,(HL)               ;
  JR NZ,INITOBJS_0        ; Jump back until every entry has been processed
; Now we initialise the entries in the object location table at HOOK.
  LD E,4                  ; Each entry is 4 bytes long
  LD HL,HOOK              ; The object location table starts at HOOK
INITOBJS_1;
  CALL INITOBJ            ; Initialise the entry
  RET Z                   ; Return if we've reached the end of the table
  ADD HL,DE               ; Point HL at the next entry
  JR INITOBJS_1           ; Jump back to process the next entry

; Initialise an event or object for a new game
;
; Used by the routine at INITOBJS. Activates or deactivates an entry in the
; event table at EVENT01 or the object location table at HOOK as appropriate
; for a new game.
;
; HL Address of the first byte of the event/object entry
INITOBJ;
  LD A,(HL)               ; Pick up the first byte of the entry
  INC A                   ; Have we reached the end of the table?
  RET Z                   ; Return with the zero flag set if so
  RES 0,(HL)              ; Reset bit 0 of the first byte of the entry, thus
                          ; activating it
  ADD A,A                 ; Should this entry be active at the start of the
                          ; game?
  RET NC                  ; Return if so
  INC (HL)                ; Otherwise set bit 0 of the first byte of the entry,
                          ; thus deactivating it
; This entry point is used by the routine at EVENTS.
INITOBJ_0;
  RET

; Unused
  DEFB 244

; Make the cash bonus/key sound effect
;
; Used by the routine at FOUNDOBJ.
;
; A 2 (initial border colour)
; C 144 (pitch)
; DE 509 (duration)
; H 20 (repetitions)
; L 6 (border XOR value)
CASHKEYSND;
  PUSH DE                 ; Save the duration
  XOR L                   ; Toggle the border colour between 2 (red) and 4
                          ; (green)
  CALL SNDEFFECT3         ; Make a mini-sound effect
  LD B,A                  ; Save the border colour in B briefly
  LD A,C                  ; Modify the pitch for the next mini-sound effect (it
  CPL                     ; is 144 for the first, and then toggles between 111
  AND 127                 ; and 16 for the remainder)
  LD C,A                  ;
  LD A,B                  ; Restore the border colour to A
  POP DE                  ; Restore the duration to DE
  DEC H                   ; Have we played 20 mini-sound effects yet?
  JR NZ,CASHKEYSND        ; Jump back if not
  RET

; 'L' pressed - light on/off
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'L' is
; pressed.
;
; H 230 (Sam)
LIGHT;
  CALL BYLIGHT            ; Is Sam standing next to a light switch?
  JR Z,LIGHT_2            ; Jump if not
  BIT 5,A                 ; Does the light switch affect the light in only one
                          ; window or window-pair?
  JR Z,LIGHT_0            ; Jump if so
  CALL LSWITCH1_6         ; Switch the lights on or off
  JR LIGHT_1
LIGHT_0;
  CALL LSWITCH1_2         ; Switch the light on or off
LIGHT_1;
  LD H,230                ; 230=Sam
LIGHT_2;
  JP RAISEARM             ; Raise Sam's arm and make a sound effect

; 'B' pressed - raise/lower blind
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'B' is
; pressed.
;
; H 230 (Sam)
BLIND;
  CALL LIGHTBLIND         ; Is Sam standing next to a light switch or a window
                          ; blind?
  JR Z,BLIND_1            ; Jump if not
  AND 28                  ; Is Sam standing next to a window blind?
  JR Z,BLIND_1            ; Jump if not
  CP 8                    ; Set the zero flag if Sam is standing next to the
                          ; right-hand window of a pair
  LD A,1                  ; Bit 0 set; right-hand window blind toggle
  JR Z,BLIND_0            ; Jump if Sam is standing next to the right-hand
                          ; window of a pair
  LD A,64                 ; Bit 6 set; left-hand window blind toggle
BLIND_0;
  CALL LSWITCH1_3         ; Raise or lower the window blind
BLIND_1;
  JP RAISEARM             ; Raise Sam's arm and make a sound effect

; Unused
  DEFB 0

; Check whether Sam is standing next to a fuse that has not been blown yet
;
; Used by the routines at ICONPANEL2 and FUSE. Returns with the zero flag set
; if Sam is standing next to a fuse that has not been blown yet.
;
; H 230 (Sam)
BYFUSE;
  LD DE,FUSELOCS          ; Point DE at the fuse location table at FUSELOCS
  LD L,2                  ; Point HL at byte 2 of Sam's buffer
  LD BC,1537              ; B=6 (there are six fuses), C=1 (fuse identifier)
BYFUSE_0;
  LD A,(DE)               ; A=y-coordinate of a fuse
  INC DE                  ; Point DE at the x-coordinate of the fuse
  CP (HL)                 ; Does the fuse's y-coordinate match Sam's
                          ; y-coordinate?
  JR NZ,BYFUSE_1          ; Jump if not
  DEC L                   ; Point HL at byte 1 of Sam's buffer
  LD A,(DE)               ; A=x-coordinate of the fuse
  CP (HL)                 ; Compare it with Sam's x-coordinate
  INC HL                  ; Point HL back at byte 2 of Sam's buffer
  JR NZ,BYFUSE_1          ; Jump unless Sam is standing next to the fuse
  LD A,(FUSEFLAGS)        ; Collect the fuse flags from FUSEFLAGS
  AND C                   ; Set the zero flag if the fuse has not been blown
                          ; yet
  RET
BYFUSE_1;
  RLC C                   ; Move the fuse identifier bit in C leftwards
  INC DE                  ; Point DE at the next entry in the fuse location
                          ; table
  DJNZ BYFUSE_0           ; Jump back until all fuse locations have been
                          ; checked
  RET

; Deal with Sam when his arm is raised or his knees are bent
;
; Used by the routine at HANDLESAM when bit 5 at STATUS is set (by the routine
; at FUSE, LIGHT, BLIND, GETOBJECT or USEHOOK), indicating that Sam is blowing
; a fuse, switching a light on or off, raising or lowering a blind, or throwing
; the hook (and therefore has his arm raised), or is picking up an object (and
; therefore has his knees bent).
ARMDOWN;
  XOR A                   ; Clear all of Sam's status flags at STATUS
  LD (STATUS),A           ;
  JP MVSAM                ; Make a sound effect and lower Sam's arm or unbend
                          ; his knees

; Urgent message number
;
; Used by the routines at QUEUEMSGU and MSGDELAY.
URGENTMSG;
  DEFB 0

; Add an urgent message to the message queue
;
; Used by the routines at SAMLANA, JOYSTICK, WHOSTHERE, PHONE, GIVENAME,
; ONPHONE and PLACECALL. When an urgent message is queued, it will be brought
; to the front of the queue and displayed as soon as possible (see MSGDELAY).
;
; A Message number
QUEUEMSGU;
  LD (URGENTMSG),A        ; Store the message number at URGENTMSG
  JP QUEUEMSG             ; Add the message to the queue

; Determine the interval between the last message and the next
;
; Used by the routine at QUEUEMSG. Returns with the interval in A, which
; indicates the minimum number of subintervals of 0.64s that the current
; message should be displayed for.
MSGDELAY;
  LD A,(URGENTMSG)        ; Collect the urgent message number from URGENTMSG
  AND A                   ; Is it 0 (no message)?
  JR Z,MSGDELAY_2         ; Jump if so
  LD HL,MSGINDEX          ; Collect the index of the current message in the
  LD A,(HL)               ; queue from MSGINDEX
  INC A                   ; A=index of the next message in the queue
  AND 7                   ;
  ADD A,184               ; Point HL at the slot for the next message in the
  LD L,A                  ; queue
  LD B,7                  ; There are up to 7 messages ahead in the queue
  LD A,(URGENTMSG)        ; A=urgent message number
MSGDELAY_0;
  CP (HL)                 ; Set the zero flag if the urgent message is in this
                          ; slot in the queue
  INC HL                  ; Move HL along to the next slot in the message queue
                          ; (or past the end of the queue and into the bullet
                          ; buffers at BULLET1 and BULLET2, which is a bug)
  JR NZ,MSGDELAY_1        ; Jump unless the urgent message is at this position
                          ; in the queue
  LD A,1                  ; Set A=1 so that the next message is displayed as
                          ; soon as possible
  RET
MSGDELAY_1;
  DJNZ MSGDELAY_0         ; Jump back until all messages in the queue have been
                          ; checked
  XOR A                   ; Clear the urgent message number at URGENTMSG; it
  LD (URGENTMSG),A        ; was not in the queue
MSGDELAY_2;
  LD A,(MSGDISPINT)       ; Collect the normal message display interval from
                          ; MSGDISPINT
  RET

; Ask Sam 'WHO'S THERE?' when he takes or makes a phone call
;
; Used by the routine at PHONEMSG.
WHOSTHERE;
  PUSH HL
  LD A,37                 ; Message 37; 'A VOICE SAID 'WHO'S THERE?''
  CALL QUEUEMSGU          ; Queue this message urgently
  LD HL,CALLFLAGS         ; Set bit 6 of the telephone call status flags at
  SET 6,(HL)              ; CALLFLAGS, indicating that Sam must give a name
  POP HL
  RET

; Check whether Sam has found something and update the icon panel
;
; Used by the routines at GETOBJECT and MNLPTASKS2. Scans the object location
; table at HOOK to check whether Sam has found the hook, the budgie, a key,
; some money, or a location that requires a message to be displayed, and then
; updates the icon panel appropriately.
FOUNDOBJ;
  LD HL,58881             ; Point HL at byte 1 of Sam's buffer
  LD C,(HL)               ; C=Sam's x-coordinate
  INC L                   ; L=2
  LD B,(HL)               ; B=Sam's y-coordinate
  LD HL,HOOK              ; Point HL at the object location table at HOOK
FOUNDOBJ_0;
  LD A,(HL)               ; Collect the first byte of an entry
  INC A                   ; Have we reached the end of the table?
  JR Z,FOUNDOBJ_3         ; Jump if so
  INC HL                  ; Move HL to the second byte of the entry
  AND 2                   ; Is this entry active?
  JR NZ,FOUNDOBJ_1        ; Proceed to the next entry if not
  LD A,(HL)               ; A=x-coordinate of the object
  CP C                    ; Is Sam's x-coordinate the same?
  JR NZ,FOUNDOBJ_1        ; Jump if not
  INC HL                  ; Move HL to the third byte of the entry
  LD A,(HL)               ; A=y-coordinate of the object
  CP B                    ; Set the zero flag if Sam's y-coordinate is the same
  DEC HL                  ; Move HL back to the second byte of the entry
  JR Z,FOUNDOBJ_2         ; Jump if Sam's coordinates match the object's
FOUNDOBJ_1;
  INC HL                  ; Point HL at the first byte of the next entry
  INC HL                  ;
  INC HL                  ;
  JR FOUNDOBJ_0           ; Jump back to check the next entry
; Sam's coordinates match those of the object. Is it the hook or the budgie?
FOUNDOBJ_2;
  DEC HL                  ; Move HL back to the first byte of the entry
  BIT 6,(HL)              ; Is this entry for an object that can be picked up
                          ; (i.e. the hook or the budgie)?
  JR Z,FOUNDOBJ_5         ; Jump if not
  LD A,(SAMCBUF)          ; A=Sam's animatory state
  AND 127                 ; Discard bit 7 (the direction bit)
  CP 6                    ; 6; Is Sam bending his knees?
  JR NZ,FOUNDOBJ_4        ; Jump if not
  INC (HL)                ; Increment the first byte of the entry (thus
                          ; deactivating it)
  INC HL                  ; Point HL at the fourth byte of the entry
  INC HL                  ;
  INC HL                  ;
  LD A,(HL)               ; Pick up the fourth byte of the entry
  LD HL,OBJINV            ; Set the appropriate bit at OBJINV to give Sam the
  OR (HL)                 ; object
  LD (HL),A               ;
FOUNDOBJ_3;
  JR FOUNDOBJ_12          ; Jump forward to update the icon panel
FOUNDOBJ_4;
  DEC (HL)                ; Decrement the first byte of the entry
FOUNDOBJ_5;
  INC (HL)                ; Increment the first byte of the entry (thus
                          ; deactivating it if it's not the hook or the budgie)
  LD A,(HL)               ; A=first byte of the entry
  INC HL                  ; Point HL at the fourth byte of the entry
  INC HL                  ;
  INC HL                  ;
  PUSH HL                 ; Save the object table entry pointer
  PUSH BC                 ; Save Sam's coordinates
  BIT 6,A                 ; Is this entry for an object that can be picked up
                          ; (i.e. the hook or the budgie)?
  JR Z,FOUNDOBJ_7         ; Jump if not
  LD A,(HL)               ; A=fourth byte of the entry
  LD HL,IPFLAGS           ; Store the object ID at IPFLAGS for now
  LD (HL),A               ;
FOUNDOBJ_6;
  POP BC                  ; Restore Sam's coordinates to BC
  POP HL                  ; Restore the object table entry pointer to HL
  INC HL                  ; Point HL at the first byte of the next entry
  JR FOUNDOBJ_0           ; Jump back to check the next entry
; It's not the hook or the budgie. Does a message need to be displayed?
FOUNDOBJ_7;
  BIT 5,A                 ; Is this entry for a message that needs to be
                          ; displayed?
  JR Z,FOUNDOBJ_8         ; Jump if not
  LD A,(HL)               ; A=message number
  CALL QUEUEMSG           ; Queue the message
  JR FOUNDOBJ_6           ; Jump back to check the next entry
; It's not the hook, the budgie or a message. Is it a key?
FOUNDOBJ_8;
  BIT 4,A                 ; Is this entry for a key?
  JR Z,FOUNDOBJ_9         ; Jump if not
  LD A,(HL)               ; A=key identifier (8, 16, 32 or 64)
  LD HL,KEYINV            ; Set the appropriate bit at KEYINV, thus giving Sam
  OR (HL)                 ; the key
  LD (HL),A               ;
  LD A,100                ; $100 to add to Sam's cash supply
  JR FOUNDOBJ_10
  INC D                   ; This block of code is never executed
  LD D,2                  ;
  JR FOUNDOBJ_11          ;
; If it's not the hook, the budgie, a message or a key, it must be cash.
FOUNDOBJ_9;
  LD A,(HL)               ; A=number of bucks
FOUNDOBJ_10;
  CALL CHGBUCKS_1         ; Add this to Sam's total
  LD HL,5126              ; Prepare the cash bonus sound effect parameters
  LD C,144                ;
  LD D,1                  ;
FOUNDOBJ_11;
  LD A,2
  CALL CASHKEYSND         ; Make a sound effect
  JR FOUNDOBJ_6           ; Jump back to check the next entry
; Now we set the attribute bytes for the budgie and hook in the icon panel.
FOUNDOBJ_12;
  LD HL,IPFLAGS           ; IPFLAGS holds the ID of the object Sam is standing
                          ; next to (if any)
  LD A,(HL)               ; A=object ID
  LD (HL),0               ; Reset IPFLAGS to 0
  LD L,233                ; HL=OBJINV (object inventory)
  LD H,(HL)               ; H=object inventory flags
  LD L,A                  ; L=ID of the object Sam is standing next to (if any)
  LD E,176                ; 176 is the LSB of 23216 (the attribute file address
                          ; for the top-left tile of the budgie icon)
  LD BC,1538              ; B=6, C=2 (2 objects; budgie and hook)
FOUNDOBJ_13;
  RL L                    ; Move an object ID bit (if any) into bit 0 of H, and
  RL H                    ; an object inventory flag into the carry flag
  LD A,48                 ; 48=PAPER 6; INK 0
  JR C,FOUNDOBJ_14        ; Jump if Sam already has this object
  ADD A,B                 ; A=56 (INK 6; PAPER 6)
  BIT 0,H                 ; Is Sam standing next to this object?
  JR Z,FOUNDOBJ_14        ; Jump if not
  LD A,B                  ; A=6 (INK 6; PAPER 0)
FOUNDOBJ_14;
  CALL UPDICONS_1         ; Set the attribute bytes for the object in the icon
                          ; panel
  LD E,178                ; 178 is the LSB of 23218 (the attribute file address
                          ; for the top-left tile of the hook icon)
  DEC C                   ; Have we dealt with both objects yet?
  JR NZ,FOUNDOBJ_13       ; Jump back to deal with the second object if not
; Now we display the keys Sam has found.
  LD A,(KEYINV)           ; Pick up the key inventory flags from KEYINV
  ADD A,A                 ; Move bits 3-6 into bits 4-7 (thus discarding bit 7,
                          ; which corresponds to the key to no. 19)
  LD BC,1072              ; B=4 (there are 4 keys), C=48 (INK 6; PAPER 0)
  LD HL,23280             ; Point HL at the attribute byte for the leftmost key
                          ; in the icon panel
; This entry point is used by the routine at INITMSGFA with HL=23272 (attribute
; byte for the leftmost first aid kit in the icon panel) and C=50 (INK 2; PAPER
; 6).
FOUNDOBJ_15;
  LD (HL),54              ; Set the attribute byte to 54 (INK 6; PAPER 6) by
                          ; default
  ADD A,A                 ; Should there be a first aid kit or key displayed
                          ; here?
  JR NC,FOUNDOBJ_16       ; Jump if not
  LD (HL),C               ; Otherwise reveal the first aid kit or key by
                          ; setting the attribute byte to 50 (INK 2; PAPER 6)
                          ; or 48 (INK 6; PAPER 0)
FOUNDOBJ_16;
  INC L                   ; Move HL to the attribute byte for the next first
                          ; aid kit or key
  DJNZ FOUNDOBJ_15        ; Jump back until all the first aid kits or keys have
                          ; been done
  RET

; Deal with a character who is at the entrance to a building
;
; Used by the routine at MOVELEFT. On entry, the bit set in A indicates the
; direction in which the character is going to move next;
;
; +-----+-----------------------+
; | Bit | Direction             |
; +-----+-----------------------+
; | 7   | Left                  |
; | 6   | Right                 |
; | 5   | Up and to the left    |
; | 4   | Up and to the right   |
; | 3   | Down and to the left  |
; | 2   | Down and to the right |
; +-----+-----------------------+
;
; Also on entry, the zero flag is set if the character is indoors. If the
; character is Sam, we also check whether he's entering a house other than no.
; 19 without a key.
;
; A Direction indicator (128, 64, 32, 16, 8 or 4)
; B Third byte of the character's location descriptor (see LOCDESCS)
; H Character number (215-230)
; L 4
BYDOOR;
  JR NZ,BYDOOR_1          ; Jump unless the character is indoors
  AND B                   ; Is the character going to leave the building?
  RET NZ                  ; Return if not
BYDOOR_0;
  INC (HL)                ; Set the character's z-coordinate to 2
  RET
BYDOOR_1;
  AND B                   ; Is the character going to enter the building?
  JR Z,BYDOOR_0           ; Jump if not
  LD A,H                  ; A=character number
  CP 230                  ; Is this Sam?
  RET NZ                  ; Return if not
  BIT 0,B                 ; Does the entrance have a door?
  RET Z                   ; Return if not
  CALL CHKDOOR            ; Point HL at the status flags for the door that Sam
                          ; is standing next to (see DOORFLAGS)
  LD A,L                  ; A=LSB of the address of the door status flags
                          ; (240-249)
  CP 245                  ; Is Sam standing in the doorway of no. 19?
  JR Z,BYDOOR_2           ; Jump if so
  LD A,(HL)               ; Pick up the door status flags for the doorway Sam
                          ; is standing in
  AND 248                 ; Set the zero flag if the door requires no key to
                          ; unlock it
BYDOOR_2;
  LD H,230                ; 230=Sam
  RET Z                   ; Return if the door requires no key to unlock it
  JP ENTRYNOKEY           ; Check whether Sam has entered a house through the
                          ; front door without a key

; Check whether Sam is standing next to a ringing telephone
;
; Continues from the routine at BYPHONE. On entry, E holds the identifier of
; the telephone that Sam is standing next to. Returns with the zero flag always
; reset, and the carry flag reset if the telephone is ringing.
;
; E Telephone identifier
RINGING;
  LD A,(23673)            ; Collect the second byte of the FRAMES system
                          ; variable, which is incremented every 5.12s
  LD HL,RPHONETIME        ; RPHONETIME holds the value of the second byte of
                          ; the FRAMES system variable as it was the last time
                          ; Sam lifted a ringing telephone
  SUB (HL)                ; Subtract the current value
  CP 3                    ; Has less than 10.24s passed since Sam last lifted a
                          ; ringing telephone?
  RET C                   ; Return with the carry flag set if so
  LD HL,RINGPHONE1        ; Point HL at the ringing phone location table at
                          ; RINGPHONE1
; This entry point is used by the routine at PHONEMSG (with HL=RINGPHONE1 or
; PHONEMSG1).
RINGING_0;
  LD A,E                  ; A=telephone identifier
  CP (HL)                 ; Does it match the first byte of the phone entry?
  JR Z,RINGING_1          ; Jump if so
  LD A,(HL)               ; Have we reached the end of the phone table?
  ADD A,2                 ;
  RET C                   ; Return with the carry flag set if so
  INC HL                  ; Point HL at the first byte of the next entry in the
  INC HL                  ; phone table
  INC HL                  ;
  JR RINGING_0            ; Check the next entry
RINGING_1;
  AND A                   ; Reset the carry and zero flags
  RET

; Unused
  DEFB 0

; 'T' pressed - telephone
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'T' is
; pressed.
;
; H 230 (Sam)
PHONE;
  CALL BYPHONE            ; Is Sam standing next to a telephone?
  RET Z                   ; Return if not
  LD HL,MSG002            ; The buffer at MSG002 will hold the digits dialled
                          ; by Sam
  LD BC,1280              ; B=5, C=0
PHONE_0;
  LD (HL),C               ; Initialise the digit buffer at MSG002 by filling it
  INC L                   ; with zeroes
  DJNZ PHONE_0            ;
  LD L,155                ; HL=CALLFLAGS (telephone call status flags)
  CCF                     ; A=128 if the phone is ringing, 0 otherwise
  SBC A,A                 ;
  AND 128                 ;
  LD (HL),A               ; Set bit 7 at CALLFLAGS if Sam has picked up a
                          ; ringing telephone
  LD L,252                ; HL=STATUS (Sam's status flags)
  LD (HL),16              ; Set bit 4; Sam is on the phone
  LD L,211                ; Store the phone's identifier at PHONEID
  LD (HL),E               ;
  JR NZ,PHONE_1           ; Jump if the phone is ringing
  LD A,2                  ; Subtract $2 from Sam's cash supply
  CALL CHGBUCKS_0         ;
  JR PHONE_2
; Sam has picked up a telephone that is ringing.
PHONE_1;
  LD A,(23673)            ; Collect the second byte of the FRAMES system
                          ; variable, which is incremented every 5.12s
  LD L,153                ; Copy this byte to RPHONETIME
  LD (HL),A               ;
PHONE_2;
  LD A,41                 ; Message 41; 'I LIFTED THE PHONE '
; This entry point is used by the unused routine at XHANGUP with A=39; 'I HUNG
; UP'.
PHONE_3;
  CALL QUEUEMSGU          ; Queue the message urgently
; This entry point is used by the routine at PHONEKEY.
PHONE_4;
  LD H,230                ; 230=Sam
  JP LEFT_1               ; Make a sound effect

; Check whether a character can answer the telephone that Sam is calling
;
; Used by the routine at ONPHONE. Returns with the carry flag set if the
; telephone that Sam is calling is both off-screen and not his own, or if there
; is a character close enough to the telephone to pick it up.
CHKANSWER;
  LD HL,OPHONEID          ; OPHONEID holds the identifier of the telephone that
                          ; Sam is calling
  LD A,(HL)               ; Pick this up in A
  AND 31                  ; E=x-coordinate of the leftmost column of the
  ADD A,A                 ; 8-tile-wide segment of the play area that contains
  ADD A,A                 ; the telephone (0, 8, 16,...248)
  ADD A,A                 ;
  LD E,A                  ;
  LD A,(HL)               ; A=telephone identifier
  CP 92                   ; Is Sam calling his office?
  JR Z,CHKANSWER_0        ; Jump if so
  LD A,E                  ; A=telephone's x-coordinate (0, 8, 16,...248)
  LD L,254                ; HL=LEFTCOL, which holds the leftmost column of the
                          ; play area on screen
  CP (HL)                 ; Is the telephone that Sam is calling off screen to
                          ; the left?
  RET C                   ; Return with the carry flag set if so
  SUB 32                  ; Does the telephone that Sam is calling have an
                          ; x-coordinate that is less than 32?
  JR C,CHKANSWER_0        ; Jump if so (it's on screen)
  CP (HL)                 ; Is the telephone that Sam is calling off screen to
                          ; the right?
  CCF                     ; Return with the carry flag set if so
  RET C                   ;
; Sam has called his office, or a telephone that is on screen. In this case,
; Sam will get an answer only if another character is close to the telephone.
CHKANSWER_0;
  LD L,154                ; Collect the telephone identifier from OPHONEID
  LD A,(HL)               ;
  AND 224                 ; D=y-coordinate of the telephone (7, 13, 19, 25 or
  RRCA                    ; 31)
  RRCA                    ;
  RRCA                    ;
  LD D,A                  ;
  RRCA                    ;
  ADD A,D                 ;
  ADD A,7                 ;
  LD D,A                  ;
  LD HL,55042             ; Point HL at byte 2 of character buffer 215
  LD B,15                 ; We will check the locations of characters 215-229
CHKANSWER_1;
  LD A,(HL)               ; A=character's y-coordinate
  CP D                    ; Does it match that of the telephone?
  JR NZ,CHKANSWER_2       ; Jump to consider the next character if not
  DEC L                   ; L=1
  LD A,(HL)               ; A=character's x-coordinate
  INC L                   ; L=2
  AND 248                 ; Set the zero flag if the character is in the same
  CP E                    ; 8-tile-wide segment of the play area as the
                          ; telephone
  SCF                     ; Set the carry flag
  RET Z                   ; Return with the carry flag set if the character is
                          ; close to the telephone
CHKANSWER_2;
  INC H                   ; Next character
  DJNZ CHKANSWER_1        ; Jump back until every character has been checked
  AND A                   ; Reset the carry flag (there is no one close to the
                          ; telephone)
  RET

; Unused
  DEFB 0

; Deal with Sam when he's on the phone and has been asked 'WHO'S THERE?'
;
; Used by the routine at ONPHONE. Waits for a keypress, and then queues message
; 40 (''{name}' I SAID ') followed by either message 46 ('I DUNNO NO {name}')
; or the message Sam is supposed to receive upon giving the correct name.
GIVENAME;
  CALL PHONEKEY           ; Check for keypresses or hang up the phone
  RET Z                   ; Return if no key with an ASCII code in the range
                          ; 48-127 was pressed
  CP 97                   ; Is the ASCII code of the keypress less than 97
                          ; ('a')?
  RET C                   ; Return if so
  CP 104                  ; Is the ASCII code of the keypress less than 104
                          ; ('h')?
  JR C,GIVENAME_0         ; Jump if so
  CP 115                  ; Was 's' pressed?
  RET NZ                  ; Return if not
  SUB 11                  ; A=104
GIVENAME_0;
  ADD A,7                 ; A=104-111 (message number of a name)
  LD (MSG001),A           ; Store this at MSG001
  PUSH AF                 ; Save the name message number briefly
  LD A,40                 ; Message 40; ''{name}' I SAID '
  CALL QUEUEMSGU          ; Queue this message urgently
  LD HL,(PTABLEADDR)      ; Collect from PTABLEADDR the address of either the
                          ; second byte of the relevant phone table entry (if
                          ; the phone was ringing, or the person Sam's calling
                          ; has a message for him), or the final byte of the
                          ; phone message table at PHONEMSG1 (if the person
                          ; Sam's calling has no message for him); the final
                          ; byte of the phone message table is 255, which does
                          ; not match the message number of any name
  POP AF                  ; Restore the name message number to A
  CP (HL)                 ; Set the zero flag if Sam has used the correct name
  LD A,46                 ; Message 46; 'I DUNNO NO {name}'
  JR NZ,GIVENAME_2        ; Jump unless Sam has used the correct name
; This entry point is used by the routine at PHONEMSG.
GIVENAME_1;
  DEC HL                  ; Point HL at the first byte of the phone entry
  LD (HL),0               ; Mark the phone entry inactive
  INC HL                  ; Point HL at the third byte of the phone entry
  INC HL                  ;
  LD A,(HL)               ; A=telephone message number
; This entry point is used by the routines at PHONEMSG (with A=43, 44, 45 or
; 50) and ONPHONE (with A=47).
GIVENAME_2;
  LD HL,512               ; Clear OPHONEID and set bit 1 of the telephone call
  LD (OPHONEID),HL        ; status flags at CALLFLAGS (to disconnect the call)
  JP QUEUEMSGU            ; Queue the telephone message urgently

; Unused
  DEFB 0

; Check whether there is a telephone message for Sam
;
; Used by the routine at ONPHONE. On entry, A holds the identifier of either
; the telephone that Sam is holding (which was ringing when he picked it up),
; or the telephone that Sam is calling. If there is a message for Sam, it will
; be queued unless Sam needs to identify himself first, in which case message
; 37 ('A VOICE SAID 'WHO'S THERE?'') will be queued instead. If there is no
; message for Sam, the message that is queued will depend on who Sam is calling
; (Daisy, the police, or someone else).
;
; A Telephone identifier (see PHONES)
; HL RINGPHONE1 or PHONEMSG1
PHONEMSG;
  LD E,A                  ; E=telephone identifier
  CALL RINGING_0          ; Is the telephone ringing, or does the person on the
                          ; other end have a message for Sam?
  JR C,PHONEMSG_0         ; Jump if not
  INC HL                  ; Point HL at the second byte of the entry in the
                          ; phone table
  LD A,(HL)               ; Pick this up in A
  AND A                   ; Does Sam need to identify himself in order to
                          ; receive the message?
  JR Z,GIVENAME_1         ; Jump if not to queue the message
PHONEMSG_0;
  LD (PTABLEADDR),HL      ; Store at PTABLEADDR the address of either the
                          ; second byte of the relevant phone table entry (if
                          ; the phone was ringing, or the person Sam's calling
                          ; has a message for him), or the final byte of the
                          ; phone message table at PHONEMSG1 (if the person
                          ; Sam's calling has no message for him)
PHONEMSG_1;
  JP NC,WHOSTHERE         ; Jump if Sam must be asked to identify himself
  LD A,E                  ; A=telephone identifier
  CP 92                   ; 92 is the identifier of Sam's telephone
  LD A,50                 ; Message 50; 'DAISY SAID 'NO MESSAGES SAM ''
  JR Z,PHONEMSG_3         ; Jump if Sam called his office
  LD A,E                  ; A=telephone identifier
  CP 112                  ; 112 is the identifier of the telephone in the
                          ; police station
  JR NZ,PHONEMSG_2        ; Jump unless Sam called the police
  CALL SAMWANTED          ; Send the police after Sam
  LD A,51                 ; Message 51; 'A VOICE SAID 'OK CRUISE WE'RE COMING''
  JR PHONEMSG_3           ; Queue this message
PHONEMSG_2;
  CALL GETRANDOM          ; Get a random number in A
  AND 3                   ; Keep only bits 0 and 1
  JR Z,PHONEMSG_1         ; Jump if the result is 0 (25% of the time); ask Sam
                          ; 'WHO'S THERE?'
  ADD A,42                ; A=43 (A VOICE SAID 'THERES NOONE HERE'), 44 (A
                          ; VOICE SAID 'GET LOST - I'M TRYING TO SLEEP') or 45
                          ; (A VOICE SAID 'BE RIGHT WITH YOU')
PHONEMSG_3;
  JP GIVENAME_2           ; Queue this message

; Deal with Sam when he's on the phone
;
; Used by the routine at HANDLESAM when bit 4 at STATUS is set (by the routine
; at PHONE), indicating that Sam is on the phone.
ONPHONE;
  LD HL,CALLFLAGS         ; The telephone call status flags are stored at
                          ; CALLFLAGS
  BIT 6,(HL)              ; Has someone asked Sam 'WHO'S THERE?'
  JP NZ,GIVENAME          ; Jump if so
  BIT 1,(HL)              ; Is the telephone call still in progress?
  JR Z,ONPHONE_0          ; Jump if so
  CALL PHONEKEY           ; Hang up if 'h' was pressed
  RET
; The telephone call is still in progress.
ONPHONE_0;
  BIT 7,(HL)              ; Has Sam picked up a telephone that was ringing?
  JR Z,ONPHONE_2          ; Jump if not
  CALL PHONEKEY           ; Hang up if 'h' was pressed
  LD A,(PHONEID)          ; A=ID of the telephone that Sam is holding
  LD HL,RINGPHONE1        ; The ringing phone location table is at RINGPHONE1
ONPHONE_1;
  JP PHONEMSG             ; Check whether there is a message for Sam
ONPHONE_2;
  BIT 5,(HL)              ; Is the destination telephone ringing?
  JR Z,ONPHONE_3          ; Jump if not
  CALL PHONEKEY           ; Hang up if 'h' was pressed
  CALL CHKANSWER          ; Is the telephone that Sam is calling either
                          ; off-screen or close enough to a character that can
                          ; pick it up?
  RET NC                  ; Return if not
  LD A,(OPHONEID)         ; A=ID of the telephone that Sam is calling
  LD HL,PHONEMSG1         ; The phone message table is at PHONEMSG1
  JR ONPHONE_1            ; Check whether Sam has called someone who has a
                          ; message for him
; Sam is still dialling the telephone number.
ONPHONE_3;
  BIT 4,(HL)              ; Are we currently making the sound effect of a digit
                          ; being dialled?
  JR NZ,ONPHONE_6         ; Jump if so
  CALL PHONEKEY           ; Check for keypresses and hang up if 'h' was pressed
  RET Z                   ; Return if no key with an ASCII code in the range
                          ; 48-127 was pressed
  CP 58                   ; Was the ASCII code of the keypress greater than 57
                          ; ('9')?
  RET NC                  ; Return if so
  CP 48                   ; Was the ASCII code less than 48 ('0')?
  RET C                   ; Return if so
  LD HL,32657             ; Store the ASCII code of the digit in the first
ONPHONE_4;
  INC L                   ; available space at MSG002
  BIT 5,(HL)              ;
  JR NZ,ONPHONE_4         ;
  LD (HL),A               ;
  SUB 48                  ; A=digit that was dialled (0-9)
  JR NZ,ONPHONE_5         ; Jump unless '0' was dialled
  LD A,10                 ; The digit '0' will give 10 clicks
ONPHONE_5;
  INC A                   ; A=1-11
  LD (58900),A            ; Store this in byte 20 of Sam's buffer
  LD L,155                ; HL=CALLFLAGS (telephone call status flags)
  LD (HL),16              ; Set bit 4
  LD A,42                 ; Message 42; 'I DIALLED {number}'
  JP QUEUEMSGU            ; Queue this message urgently
; The sound effect of a digit being dialled is currently in progress.
ONPHONE_6;
  LD HL,58888             ; Set Sam's main action timer (in byte 8 of his
  LD (HL),3               ; buffer) to 3
  LD L,20                 ; Point HL at byte 20 of Sam's buffer
  DEC (HL)                ; Are there any more clicks to make?
  JP NZ,SNDEFFECT2        ; Make a click if so
; Sam has finished dialling a digit of the telephone number. Check whether the
; number dialled so far is valid.
  LD HL,CALLFLAGS         ; Clear all the telephone call status flags at
  LD (HL),0               ; CALLFLAGS
  LD L,146                ; Collect the ASCII code of the first digit that was
  LD A,(HL)               ; dialled from MSG002
  CP 48                   ; Was it '0'?
  JR Z,ONPHONE_8          ; Jump if so (no telephone numbers start with 0)
  INC L                   ; Add the ASCII codes of the second and third digits
  ADD A,(HL)              ; to the first
  INC L                   ;
  ADD A,(HL)              ;
  INC L                   ; Point HL at the fourth digit
  CP 171                  ; Set the zero flag if '999' was dialled
  LD A,112                ; 112 is the ID of the telephone in the police
                          ; station
  JR Z,ONPHONE_7          ; Jump if Sam has dialled the police
  BIT 5,(HL)              ; Has Sam dialled four digits yet?
  RET Z                   ; Return if not
  CALL TELNOVALID         ; Has Sam dialled a valid telephone number?
  JR NZ,ONPHONE_8         ; Jump if not
ONPHONE_7;
  LD HL,PHONEID           ; PHONEID holds the ID of the telephone Sam is
                          ; holding
  CP (HL)                 ; Does it match the ID of the telephone Sam is
                          ; calling?
  JP NZ,PLACECALL         ; Jump if not to place the call
ONPHONE_8;
  LD A,47                 ; Message 47; ' THE NUMBER WAS UNOBTAINABLE'
  JP GIVENAME_2           ; Disconnect the call and queue this message urgently

; Prepare for a cutscene
;
; Used by the routine at SCORECASH. On entry, A holds the LSB of the address of
; the screen refresh buffer byte that corresponds to the top row of the portion
; of the play area to be displayed during the cutscene.
;
; A Screen refresh buffer address LSB
; D New y-coordinate for the topmost row of the play area on screen
; E New x-coordinate for the leftmost column of the play area on screen
PREPCSCENE;
  PUSH DE                 ; Save the play area coordinates briefly
  PUSH AF                 ; Save the screen refresh buffer address LSB briefly
  CALL HIDEPA             ; Hide the play area
  POP AF                  ; Restore the screen refresh buffer address LSB to A
  LD L,A                  ; Point HL at the first screen refresh buffer (SRB)
                          ; byte that will need updating later
  POP DE                  ; Restore the play area coordinates to DE
  PUSH HL                 ; Save the SRB address for now
  AND 3                   ; Compute Sam's new x-coordinate (x+5, where x is the
  ADD A,A                 ; x-coordinate of the leftmost column of the portion
  ADD A,A                 ; of the play area to be displayed)
  ADD A,A                 ;
  ADD A,5                 ;
  ADD A,E                 ;
  LD C,A                  ; C=Sam's new x-coordinate
  LD A,D                  ; Set the new y-coordinate of the topmost row of the
  LD (TOPROW),A           ; play area on screen
  LD A,L                  ; A=screen refresh buffer address LSB
  SUB 12                  ; Compute Sam's new y-coordinate
  AND 252                 ;
  RRCA                    ;
  RRCA                    ;
  ADD A,D                 ;
  LD HL,SAMCBUF           ; Point HL at byte 0 of Sam's character buffer
  LD (HL),0               ; Set Sam's animatory state to 0 (standing/walking
                          ; phase 1)
  INC L                   ; L=1
  LD (HL),C               ; Set Sam's x-coordinate
  INC L                   ; L=2
  LD (HL),A               ; Set Sam's y-coordinate
  INC L                   ; L=4
  INC L                   ;
  LD (HL),1               ; Set Sam's z-coordinate
; Next we cycle character buffer groups forwards or backwards as appropriate to
; correspond with the portion of the play area that will be on screen.
  LD HL,CBUFGFWD_S        ; Place a RET instruction at CBUFGFWD_S so that the
  LD (HL),201             ; screen will not scroll right
  LD L,224                ; Place a RET instruction at CBUFGREV_S so that the
  LD (HL),201             ; screen will not scroll left
  PUSH HL
  LD HL,LEFTCOL           ; Collect X (the x-coordinate of the leftmost column
  LD A,(HL)               ; of the play area on screen) from LEFTCOL
PREPCSCENE_0;
  CP E                    ; Does X match the target x-coordinate (in E)?
  JR Z,PREPCSCENE_3       ; Jump if so
  PUSH DE                 ; Save the target x-coordinate briefly
  JR C,PREPCSCENE_1       ; Jump if X<E
  CALL CBUFGFWD           ; Cycle a character buffer group forwards (but
                          ; without scrolling the screen)
  LD A,248                ; A=-8
  JR PREPCSCENE_2
PREPCSCENE_1;
  CALL CBUFGREV           ; Cycle a character buffer group backwards (but
                          ; without scrolling the screen)
  LD A,8
PREPCSCENE_2;
  POP DE                  ; Restore the target x-coordinate to E
  LD HL,LEFTCOL           ; Add 8 to or subtract 8 from X (the x-coordinate of
  ADD A,(HL)              ; the leftmost column of the play area on screen,
  LD (HL),A               ; stored at LEFTCOL)
  JR PREPCSCENE_0         ; Jump back to check whether we need to cycle any
                          ; more character buffers backwards or forwards
PREPCSCENE_3;
  POP HL
  LD (HL),195             ; Restore the JP instruction at CBUFGREV_S
  LD L,183                ; Restore the JP instruction at CBUFGFWD_S
  LD (HL),195             ;
; Next we determine whether any lights near Sam need to be switched on and any
; window blinds need to be raised.
  LD H,230                ; 230=Sam
  CALL FRONTX             ; Collect in C the x-coordinate of the front column
                          ; of Sam's sprite
  LD B,192                ; Is there a light switch next to Sam?
  CALL BYLIGHT_1          ;
  JR Z,PREPCSCENE_7       ; Jump if not (we can reveal the play area now)
  BIT 5,A                 ; Set the zero flag if the light switch affects the
                          ; light in only one window or window-pair
  LD A,(BC)               ; A=window flags for Sam's location
  JR Z,PREPCSCENE_4       ; Jump if the light switch affects the light in only
                          ; one window or window-pair
  BIT 5,A                 ; Is the light switch in the 'on' position?
  CALL NZ,LSWITCH1_6      ; If not, switch the light on
  JR PREPCSCENE_7         ; Jump forward to reveal the play area
PREPCSCENE_4;
  BIT 1,A                 ; Is there a right-hand window here with a blind?
  JR Z,PREPCSCENE_5       ; Jump if not
  RES 0,A                 ; Reset bit 0; blind raised in the right-hand window
PREPCSCENE_5;
  BIT 7,A                 ; Is there a left-land or single window here with a
                          ; blind?
  JR Z,PREPCSCENE_6       ; Jump if not
  RES 6,A                 ; Reset bit 6; blind raised in the left-hand or only
                          ; window
PREPCSCENE_6;
  RES 5,A                 ; Reset bit 5; light switch on
  LD (BC),A               ; Save the new window flags (blinds raised, light
                          ; switch on)
  XOR A                   ; Clear A to prevent the following call from changing
                          ; the window flags (we've already updated them)
  CALL LSWITCH1_3         ; Update the SRB for the window
; Finally we can reveal the portion of the play area in which Sam will walk up
; and down until the cutscene message has been displayed and the game resumes.
PREPCSCENE_7;
  POP HL                  ; Restore the SRB address to HL
  LD B,6                  ; The portion is 6 rows high
  LD A,L                  ; Initialise A for the loop that follows
PREPCSCENE_8;
  LD L,A                  ; Set all bits in the relevant SRB bytes
  LD (HL),255             ;
  ADD A,4                 ;
  DJNZ PREPCSCENE_8       ;
  JP UPDATESCR            ; Update the display

; Unused
  DEFS 3

; Check whether a message is in the message queue
;
; Used by the routines at SAMLANA, JOYSTICK and CUTSCENE. Returns with the zero
; flag set if the message whose number is stored at MSGNUM is present in the
; message queue (meaning it is currently being displayed or has yet to be
; displayed).
MSGINQUEUE;
  CALL QUEUEMSG_3         ; Update the message line and process the message
                          ; queue as appropriate
; This entry point is used by the routine at GETINPUT.
MSGINQUEUE_0;
  LD HL,MSGNUM            ; Collect the message number stored at MSGNUM
  LD A,(HL)               ;
  LD B,8                  ; There are 8 slots in the message queue
  LD L,184                ; HL=MSGQUEUE (the first byte in the message queue)
MSGINQUEUE_1;
  CP (HL)                 ; Set the zero flag if the message number is in the
                          ; queue
  INC HL                  ; Point HL at the next byte in the message queue
  RET Z                   ; Return if the message whose number is stored at
                          ; MSGNUM is in the message queue
  DJNZ MSGINQUEUE_1       ; Jump back until all 8 bytes of the message queue
                          ; have been checked
  RET

; Display a cutscene
;
; Used by the routine at SCORECASH. Displays a cutscene, and then enters demo
; mode or resumes the game in the next mode.
;
; A Cutscene message number
CUTSCENE;
  LD (MSGNUM),A           ; Store the cutscene message number at MSGNUM so that
                          ; it can be monitored
  CALL QUEUEMSG           ; Add the message to the message queue
  XOR A                   ; A=0
  LD (DISGUISEID),A       ; Set Sam's disguise ID (stored at DISGUISEID) to 0
                          ; (none)
  LD (OPHONEID),A         ; Disconnect any phone call Sam may be making by
                          ; setting OPHONEID to 0
  LD (STATUS),A           ; Clear all of Sam's status flags at STATUS
  CALL CHGGUISE_0         ; Update Sam's sprite and the disguise icon now that
                          ; Sam's wearing no disguise
; The loop that follows makes Sam pace up and down until the cutscene is over.
CUTSCENE_0;
  LD HL,58889             ; Reset the midstride/mid-action timer in byte 9 of
  XOR A                   ; Sam's buffer
  LD (HL),A               ;
  LD L,A                  ; L=0
  BIT 0,(HL)              ; Is Sam midstride?
  JR Z,CUTSCENE_4         ; Jump if not
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  DEC E                   ; Set E to Sam's next x-coordinate (immediately in
  BIT 7,A                 ; front of him)
  JR Z,CUTSCENE_1         ;
  INC E                   ;
  INC E                   ;
CUTSCENE_1;
  INC A                   ; Set A to Sam's new animatory state
  AND 251                 ;
CUTSCENE_2;
  CALL UPDATEAS           ; Update Sam's animatory state and location and
                          ; update the SRB
  CALL SNDEFFECT2         ; Make a walking sound effect
  CALL UPDATESCR          ; Update the display
  CALL QUEUEMSG_3         ; Update the message line
  LD HL,LFRAMES           ; LFRAMES holds the value of the LSB of the system
                          ; variable FRAMES as it was at the end of the last
                          ; pass through the main loop (or this routine)
CUTSCENE_3;
  LD A,(23672)            ; Wait about 240ms
  SUB (HL)                ;
  CP 12                   ;
  JR C,CUTSCENE_3         ;
  ADD A,(HL)              ; Store the current value of the LSB of the system
  LD (HL),A               ; variable FRAMES at LFRAMES for comparison next time
  JR CUTSCENE_0           ; Jump back to the beginning of this loop
; Sam is not midstride at the moment.
CUTSCENE_4;
  CALL ICONPANEL1         ; Show or hide the fuse, door, light bulb or phone in
                          ; the icon panel
  CALL MSGINQUEUE         ; Has the entire cutscene message been displayed yet?
  JP NZ,ENDCSCENE         ; Jump if so to end the cutscene
; The cutscene is not over yet. Check whether Sam should turn round before
; pacing up or down again.
  LD HL,58881             ; Point HL at byte 1 of Sam's buffer
  LD A,(HL)               ; A=Sam's x-coordinate
  DEC L                   ; L=0
  AND 7                   ; Is Sam's x-coordinate exactly divisible by 8?
  JR NZ,CUTSCENE_6        ; Jump if not
  BIT 7,(HL)              ; Is Sam facing right?
  JR NZ,CUTSCENE_7        ; Jump if so
CUTSCENE_5;
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  XOR 128                 ; Flip bit 7 of Sam's animatory state, thus turning
                          ; him round
  JR CUTSCENE_2           ; Jump back to update Sam's animatory state and the
                          ; SRB
CUTSCENE_6;
  CP 5                    ; Is Sam's x-coordinate congruent to 5 mod 8?
  JR NZ,CUTSCENE_7        ; Jump if not
  BIT 7,(HL)              ; Is Sam facing right?
  JR NZ,CUTSCENE_5        ; Jump back to turn Sam round if so
CUTSCENE_7;
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  JR CUTSCENE_1

; Unused
  DEFS 4

; Keypress offsets to use for Sam in demo mode
;
; Used by the routine at GETINPUT. The return value from the routine at
; NEXTMOVE (A=1-6) maps to one of the keypress offsets in this table.
DEMOKEYS;
  DEFB 13                 ; Right
  DEFB 15                 ; Left
  DEFB 9                  ; Up
  DEFB 11                 ; Down
  DEFB 19                 ; Open a door from the inside
  DEFB 19                 ; Open a door from the outside

; Locations for Sam to visit in demo mode
;
; Used by the routine at GETINPUT.
DEMODESTS;
  DEFB 5,33               ; Shop at the far left of town
  DEFB 225,19             ; Sam's office
  DEFB 243,13             ; Top floor of no. 15
  DEFB 58,7               ; Left-hand room on the top floor of the hotel
  DEFB 100,13             ; Right-hand green room in the hotel
  DEFB 154,7              ; Roof of no. 27
  DEFB 126,7              ; Roof of the police station
  DEFB 200,7              ; Roof of the apartment building next to no. 19

; Collect a keypress during the game (or simulate one in demo mode)
;
; Called from the main loop at MAINLOOP.
GETINPUT;
  LD A,(GAMEMODE)         ; A=current game mode (0-4)
  AND A                   ; Is it demo mode?
  JP NZ,KEYOFFSET1        ; Jump if not
; It's demo mode.
  CALL READKEY            ; Collect the ASCII code of the last key pressed in A
  JP NZ,ENDCSCENE_4       ; Start a new game if a game key was pressed
  LD A,38                 ; Message 38; 'PRESS A KEY TO PLAY'
  LD (MSGNUM),A           ; Store this message number at MSGNUM so that it can
                          ; be monitored
  CALL MSGINQUEUE_0       ; Is this message in the message queue?
  CALL NZ,QUEUEMSG        ; If not, add it to the message queue (again)
  LD A,248                ; Set bits 3-7 at KEYINV, effectively giving Sam the
  LD (KEYINV),A           ; keys to all the houses
  LD A,(58891)            ; Pick up byte 11 of Sam's buffer (which holds his
                          ; destination y-coordinate)
  AND A                   ; Has a destination been set for Sam yet?
  JR NZ,GETINPUT_1        ; Jump if so
; We need to set a new destination for Sam.
GETINPUT_0;
  CALL GETRANDOM          ; Get an even random number between 134 and 148 in A
  AND 14                  ;
  ADD A,134               ;
  LD L,A                  ; Point HL at an entry in the table of locations at
  LD H,121                ; DEMODESTS
  LD E,(HL)               ; Collect the location coordinates in DE
  INC L                   ;
  LD D,(HL)               ;
  LD HL,58890             ; Copy the location coordinates into bytes 10 and 11
  LD (HL),E               ; of Sam's buffer
  INC L                   ;
  LD (HL),D               ;
  LD C,1                  ; Assume a z-coordinate of 1 (indoors)
  CALL LOCID_1            ; Obtain an identifier for the location
  LD L,12                 ; Copy the destination location identifier into byte
  LD (HL),A               ; 12 of Sam's buffer
GETINPUT_1;
  LD H,230                ; 230=Sam
  CALL NEXTMOVE           ; Determine the next move Sam should make to reach
                          ; his destination
  AND A                   ; Is Sam already at his destination?
  JR Z,GETINPUT_0         ; Jump back to set a new destination if so
; Sam's destination has been set. Now to simulate a keypress that will make him
; take the next step towards it.
  ADD A,127               ; Point HL at the offset of the appropriate keypress
  LD L,A                  ; to simulate in the table at DEMOKEYS
  LD H,121                ;
  LD A,(HL)               ; Pick up the keypress offset
  AND A                   ; Make sure the zero flag is reset to indicate that a
                          ; simulated keypress was made (this instruction is
                          ; redundant)
  RET

; 'G' pressed - get object
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'G' is
; pressed.
;
; H 230 (Sam)
GETOBJECT;
  LD A,32                 ; Set bit 5 of Sam's status flags at STATUS
  LD (STATUS),A           ;
  LD BC,3                 ; Copy bytes 0-2 of Sam's buffer (which hold his
  LD DE,58885             ; animatory state and coordinates) into bytes 5-7 for
  LD L,B                  ; later retrieval
  LDIR                    ;
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  AND 128                 ; A=6 or 134; Sam bending his knees
  ADD A,6                 ;
  CALL UPDATEAS           ; Update Sam's animatory state and location and
                          ; update the SRB
  CALL FOUNDOBJ           ; Check whether Sam has picked up the hook or the
                          ; budgie and update the icon panel accordingly
  LD H,230                ; 230=Sam
  JP LEFT_1               ; Make a sound effect

; Send the police after Sam
;
; Used by the routines at EVENTS (when Sam finds the dead body in the hotel)
; and PHONEMSG (when Sam has called the police).
SAMWANTED;
  LD HL,COPFLAGS          ; The police flags are stored at COPFLAGS
  LD (HL),1               ; Set bit 0; Sam is wanted by the police
  JP COPTOSCL             ; Copy Sam's coordinates and location identifier to
                          ; SAMLOCX, thus informing the police where they
                          ; should head for to get Sam

; Place a telephone call
;
; Used by the routine at ONPHONE. On entry, A holds the identifier of the
; telephone that Sam is calling.
;
; A Telephone identifier
; H 127
PLACECALL;
  LD L,154                ; Store the identifier of the telephone that Sam is
  LD (HL),A               ; calling at OPHONEID
  INC L                   ; Set bit 5 of the telephone status flags at
  LD (HL),32              ; CALLFLAGS
  LD A,49                 ; Message 49; 'IT BEGAN RINGING'
  JP QUEUEMSGU            ; Queue this message urgently

; Check whether Sam has dialled a valid telephone number
;
; Used by the routine at ONPHONE. Returns with the zero flag set if Sam has
; dialled a valid telephone number, and with the telephone identifier in A.
TELNOVALID;
  LD HL,27466             ; Point HL at the end of the phone number and
                          ; location table at PHONES
  LD C,15                 ; There are 15 entries to check
TELNOVALID_0;
  LD DE,32661             ; Point DE at the last digit of the phone number
                          ; dialled by Sam (stored at MSG002)
  LD B,4                  ; There are 4 digits in a phone number
TELNOVALID_1;
  LD A,(DE)               ; A=digit of the phone number dialled by Sam
  CP (HL)                 ; Compare it with that of a phone number in the table
  DEC HL                  ; Point HL at the previous digit of the phone number
  DEC DE                  ; Point DE at the previous digit dialled by Sam
  JR NZ,TELNOVALID_3      ; Jump if there's no match
  DJNZ TELNOVALID_1       ; Jump back until all 4 digits have been compared
  LD A,(HL)               ; A=identifier of the matching telephone
  RET                     ; Return with the zero flag set
TELNOVALID_2;
  DEC HL                  ; Point HL at the first byte of the phone number
TELNOVALID_3;
  DJNZ TELNOVALID_2       ; entry (the telephone identifier)
  DEC HL                  ; Point HL at the last digit of the previous phone
                          ; number in the table
  DEC C                   ; Are there any more phone numbers to check?
  JR NZ,TELNOVALID_0      ; Jump back if so
  AND A                   ; Reset the zero flag
  RET

; Queue the message 'I HUNG UP' (unused)
XHANGUP;
  LD A,39                 ; Message 39; 'I HUNG UP'
  JP PHONE_3              ; Queue this message urgently and make a sound effect

; Check whether Sam has entered a house through the front door without a key
;
; Continues from the routine at BYDOOR. Sends the police after Sam if he has
; entered a house through the front door without a key.
;
; A Door status flags for the doorway Sam is standing in (see DOORFLAGS)
; H 230 (Sam)
ENTRYNOKEY;
  LD C,A                  ; C=door status flags
  LD A,(KEYINV)           ; Collect the key inventory flags from KEYINV
  AND C                   ; Does Sam have the key to the door?
  RET NZ                  ; Return if so
; Sam is entering a house through the front door without a key. The police will
; need to be alerted.
  PUSH DE
  LD DE,(58881)           ; Copy Sam's coordinates to SAMLOCX
  LD (SAMLOCX),DE         ;
  LD C,1                  ; Assume a z-coordinate of 1 (indoors)
  CALL LOCID_1            ; Obtain an identifier for Sam's current location
  LD (SAMLOCID),A         ; Store it at SAMLOCID
  LD A,1                  ; Set bit 0 at COPFLAGS; Sam is wanted by the police
  LD (COPFLAGS),A         ;
  POP DE
  RET

; Make a gangster walk up or down until Sam arrives
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a gangster's buffer by the primary command routine at AWAITSAM. It
; makes the gangster start or continue walking up or down a few paces unless he
; spots Sam, in which case the subcommand and current primary command are
; terminated.
;
; H Gangster's character number (215-224)
HOODWALK;
  CALL CHKHOOD            ; Abort now if the gangster is midstride or has his
                          ; arm up
  CALL CHKCHASE           ; Is Sam nearby, and should the gangster go after
                          ; him?
  JP C,WALK_0             ; Jump if not
  LD L,22                 ; Copy the command list offset (from the gangster's
  LD (HL),A               ; region definition table) into byte 22 of the
                          ; gangster's buffer
  LD L,15                 ; Remove the address of this interruptible subcommand
  LD (HL),0               ; routine from bytes 14 and 15 of the gangster's
                          ; buffer
  JP NEXTCMD              ; Terminate the current primary command, and move to
                          ; the portion of the command list that deals with
                          ; catching Sam

; Make a gangster walk up and down while watching for Sam
;
; Used by the command lists at CLIST04, CLIST05, CLIST06 and CLIST11.
;
; H Gangster's character number (215-224)
AWAITSAM;
  LD L,11                 ; Copy the door identifier (168 or 175) and walkabout
  CALL GETPARAMS          ; duration indicator (always 0) from the command list
                          ; into bytes 11 and 12 of the gangster's buffer
  LD L,13                 ; Set byte 13 of the gangster's buffer to a non-zero
  LD (HL),63              ; value to ensure that he walks up and down
                          ; indefinitely
  LD L,1                  ; A=gangster's x-coordinate
  LD A,(HL)               ;
  LD L,10                 ; Copy this to byte 10 of the gangster's buffer, thus
  LD (HL),A               ; making it his walkabout origin x-coordinate
  CALL CHGPRICMD          ; Change the gangster's primary command routine
                          ; address to AWAITLOOP (below)
AWAITLOOP;
  LD BC,HOODWALK          ; The routine at HOODWALK makes the gangster walk up
                          ; or down until Sam arrives
  JP DOORDUTY_1

; Make a gangster chase and pick up Sam
;
; Used by the routine at HOODTOSAM1. Makes a gangster start or continue chasing
; Sam if appropriate. Whether the gangster continues to chase Sam depends on
; Sam's and the gangster's locations relative to the two regions defined in the
; gangster's region definition table. If Sam has left the first region, the
; gangster gives up the chase and restarts his command list; if the gangster
; has already chased Sam to the boundary of the second region, he will stand on
; guard there; and if the gangster is close enough to Sam to pick him up, he
; will do so and move to the next command in the command list.
;
; H Gangster's character number (215-224)
HOODTOSAM2;
  CALL RUNFORSAM          ; Is the gangster close enough to Sam to pick him up?
  JP C,LIFTSAM            ; Jump if so
  CALL MIDSTRIDE          ; Exit now if the gangster is midstride
  LD L,23                 ; Point HL at byte 23 of the gangster's buffer
  LD E,(HL)               ; Collect the command list start address in DE
  INC L                   ;
  LD D,(HL)               ;
  LD B,H                  ; B=gangster's character number
  LD HL,65526             ; Point HL at the relevant table of region
  ADD HL,DE               ; definitions (HOODREG1, HOODREG2, HOODREG3, HOODREG4
                          ; or HOODREG5)
  LD D,230                ; 230=Sam
  CALL CHKREGION          ; Check whether Sam is inside the first region
  LD D,B                  ; D=gangster's character number
  EX DE,HL                ; H=gangster's character number
  JP C,RESTART            ; Restart the command list if Sam is outside the
                          ; first region
  EX DE,HL                ; D=gangster's character number
  CALL CHKREGION          ; Check whether the gangster is inside the second
                          ; region
  RET C                   ; Return if he's outside the second region
; Sam is inside the first region, and the gangster hasn't reached the boundary
; of the second region, so the chase is still on.
  LD H,B                  ; H=gangster's character number
  CALL DESTTOSAM          ; Set the gangster's destination to Sam's current
                          ; location
  CALL NEXTMOVE           ; Determine the next move the gangster should make to
                          ; reach Sam
  CP 5                    ; Is the gangster standing next to a closed door?
  JP NC,GOTO_9            ; Jump if so
  AND A                   ; Has the gangster reached his destination?
  RET Z                   ; Return if so
  JP GOTO_4               ; Move the gangster one step closer to Sam

; Unused
  DEFB 0

; Increment the score and decrement Sam's cash supply at regular intervals
;
; Used by the routine at MNLPTASKS1. Increments the score and decrements Sam's
; cash supply every 5.12s. Displays the endgame cutscene and enters demo mode
; if Sam runs out of money.
SCORECASH;
  LD A,(GAMEMODE)         ; Collect the current game mode (0-4) from GAMEMODE
  AND A                   ; Is it demo mode?
  RET Z                   ; Return if so
  LD HL,(23672)           ; Collect the two least significant bytes of the
                          ; system variable FRAMES in HL
  LD DE,(SCOREINCTS)      ; DE=two least significant bytes of the system
                          ; variable FRAMES as they were the last time the
                          ; score was incremented
  LD BC,65280             ; BC=-256
  SBC HL,DE               ; Was the score last incremented at least 5.12s ago?
  ADD HL,BC               ;
  RET NC                  ; Return if not
  LD HL,(23672)           ; Collect the two least significant bytes of the
                          ; system variable FRAMES in HL
  LD (SCOREINCTS),HL      ; Store these bytes at SCOREINCTS for comparison next
                          ; time
  CALL INCSCORE           ; Increment the score and decrement Sam's cash supply
  RET NZ                  ; Return unless Sam has no money left
  LD A,34                 ; Message 34; 'I WAS BROKE AGAIN...'
; This entry point is used by the routines at SAMLANA, CHKSHOT and ROOFEDGE.
SCORECASH_0;
  PUSH AF                 ; Save the message number briefly
  LD A,57                 ; A=57, D=8, E=216; the top-left corner of the
  LD DE,2264              ; cutscene window will be at (224,19), with Sam at
                          ; (229,19) (in his office)
; This entry point is used by the routines at ARRESTSAM and PREPGAME.
SCORECASH_1;
  CALL PREPCSCENE         ; Prepare for the cutscene
  POP AF                  ; Restore the cutscene message number to A
  JP CUTSCENE             ; Display the cutscene

; Prepare the phone messages, events and objects for a new game
;
; Used by the routine at PREPGAME.
PREPOBJS;
  LD HL,PHONEINIT1        ; The phone initialisation data is at PHONEINIT1 and
                          ; PHONEINIT2
  LD DE,RINGPHONE1        ; The phone message entries begin at RINGPHONE1
  LD BC,6655              ; B=25, C=255
PREPOBJS_0;
  LDI                     ; Initialise the first byte of a phone message entry
  INC E                   ; Point DE at the first byte of the next entry
  INC E                   ;
  DJNZ PREPOBJS_0         ; Jump back until all the entries have been
                          ; initialised
  JP INITOBJS             ; Initialise the event table at EVENT01 and the
                          ; object location table at HOOK

; Deal with Sam when he's being carried by a gangster or policeman
;
; Used by the routine at HANDLESAM when bit 0 at STATUS is set (by the routine
; at LIFTSAM), indicating that Sam is being carried by a gangster or policeman.
CARRIED;
  LD HL,1                 ; Set Sam's main action timer to 1 (so that we come
  LD (58888),HL           ; here on the next pass through the main loop) and
                          ; his midstride/mid-action timer to 0
; First we need to determine who is carrying Sam.
  LD HL,CBUF215           ; Point HL at byte 0 of character 215's buffer
  LD B,15                 ; We will check characters 215-229
CARRIED_0;
  LD A,(HL)               ; A=character's animatory state
  AND 120                 ; A=character's base animatory state (bits 0-2 and 7
                          ; reset)
  CP 24                   ; 24; Is this character a policeman carrying Sam?
  JR Z,CARRIED_1          ; Jump if so
  CP 40                   ; 40; Is this character a gangster carrying Sam?
  JR Z,CARRIED_1          ; Jump if so
  INC H                   ; Next character
  DJNZ CARRIED_0          ; Jump back until we find who's carrying Sam
; No one is carrying Sam at the moment. Whoever was carrying him must have just
; dropped him.
  LD L,2                  ; Point HL at byte 2 of Sam's buffer
  LD A,(HL)               ; A=Sam's y-coordinate
  CP 19                   ; Set the carry flag if it's less than 19
  LD B,1                  ; B=1 indicates that Sam is being dropped off the
                          ; roof of a building
  JP C,ROOFEDGE_0         ; Jump if Sam's being dropped off the roof of a
                          ; building
; Sam is being dropped by a policeman onto the floor of the jail cell.
  XOR A                   ; Clear all of Sam's status flags at STATUS
  LD (STATUS),A           ;
  LD L,8                  ; Set Sam's main action timer to 8
  LD (HL),8               ;
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  AND 128                 ; Sam's new animatory state is 0 (bit 7 of A is
                          ; reset, because Sam's always facing left when he's
                          ; dropped here)
  INC D                   ; Drop him one level (to the floor)
  JP UPDATEAS             ; Update Sam's animatory state and location and
                          ; update the SRB
; Sam is still being carried by a gangster or policeman. Calculate Sam's new
; animatory state and location (which depend on those of his carrier).
CARRIED_1;
  LD L,4                  ; Point HL at byte 4 of Sam's carrier's buffer
  LD A,(HL)               ; A=carrier's z-coordinate
  LD (58884),A            ; Set Sam's z-coordinate to the same value
  LD L,0                  ; Point HL at byte 0 of Sam's carrier's buffer
  LD C,5                  ; Animatory state 5; Sam being carried (facing left)
  LD E,255                ; E=-1
  BIT 0,(HL)              ; Is Sam's carrier midstride?
  JR Z,CARRIED_2          ; Jump if not
  DEC E                   ; E=-2
  LD C,2                  ; Animatory state 2; Sam standing (facing left)
CARRIED_2;
  LD A,E                  ; A=-2 if Sam's carrier is midstride, -1 otherwise
  BIT 7,(HL)              ; Is Sam's carrier facing left?
  JR Z,CARRIED_3          ; Jump if so
  SET 7,C                 ; C=130 or 133 (animatory states of Sam being
                          ; carried, facing right)
  NEG                     ; A=2 if Sam's carrier is midstride, 1 otherwise
CARRIED_3;
  INC L                   ; Add Sam's carrier's x-coordinate to obtain Sam's
  ADD A,(HL)              ; x-coordinate
  LD E,A                  ; Copy this to E
  INC L                   ; D=Sam's carrier's y-coordinate
  LD D,(HL)               ;
  DEC D                   ; Decrement it to obtain Sam's y-coordinate
  LD A,C                  ; A=Sam's animatory state
  PUSH AF                 ; Save Sam's animatory state briefly
  PUSH DE                 ; Save Sam's new coordinates
  LD H,230                ; 230=Sam
  CALL UPDATESRB          ; Update the SRB for Sam's current animatory state
                          ; and location
  POP DE                  ; Restore Sam's new coordinates to DE
  POP AF                  ; Restore Sam's animatory state to A
  CALL UPDATEAS           ; Update Sam's animatory state and location and
                          ; update the SRB
  JP MVSAM_0              ; Scroll the screen left, right, up or down if
                          ; necessary

; Unused
  DEFS 2

; Deal with a character who is standing next to the jail cell door
;
; Used by the routine at MOVELEFT. Deals with a character who is standing just
; behind the jail cell door and trying to move right. If the character is Sam,
; this routine prevents him from escaping from the jail cell while he's
; imprisoned there.
;
; H Character number (215-230)
BYJAILDOOR;
  LD A,H                  ; A=character number
  CP 230                  ; Are we dealing with Sam?
  JP NZ,MOVELEFT_7        ; Jump back into the calling routine if not (and
                          ; allow the character to move right)
  LD A,(COPFLAGS)         ; Collect the police flags from COPFLAGS
  RLCA                    ; Is Sam in jail?
  JP NC,MOVELEFT_7        ; Jump back into the calling routine if not (and
                          ; allow Sam to move right)
  RET

; Let Sam out of jail if necessary
;
; Used by the command list at CLIST03. Does nothing if Sam is not in jail;
; otherwise sets Sam's bail to some amount that he can afford, and lets him out
; of jail.
;
; H 219 (Jailer)
FREESAM;
  XOR A                   ; Remove the address of this primary command routine
  LD L,9                  ; from bytes 8 and 9 of the jailer's buffer,
  LD (HL),A               ; triggering a move to the next command in the
                          ; command list after we are finished here
  LD HL,COPFLAGS          ; The police flags are stored at COPFLAGS
  BIT 7,(HL)              ; Is Sam in jail?
  RET Z                   ; Return if not
  LD (HL),A               ; Clear the police flags
  LD H,A                  ; H=0
  LD DE,(BUCKS)           ; Collect the number of bucks from BUCKS
FREESAM_0;
  CALL GETRANDOM          ; Get a random number in A
  AND 7                   ; Now HL holds a randomly chosen multiple of 10
  ADD A,2                 ; between 20 and 90
  LD C,A                  ;
  ADD A,A                 ;
  ADD A,A                 ;
  ADD A,C                 ;
  ADD A,A                 ;
  LD L,A                  ;
  SBC HL,DE               ; Subtract Sam's cash supply from this number
  JR NC,FREESAM_0         ; Jump back to generate another bail amount if Sam's
                          ; cash supply is too small (which could lead to an
                          ; infinite loop)
  LD A,C                  ; A=ASCII code for the tens digit of the bail amount
  ADD A,48                ;
  LD (MSG001),A           ; Store this at MSG001
  LD A,C                  ; Subtract the bail amount from Sam's cash supply
  CALL CHGBUCKS           ;
  LD A,52                 ; Message 52; ' THE BAIL WAS ${tens digit}0'
  JP QUEUEMSG             ; Queue this message

; Make a policeman arrest Sam, and end the game if he cannot pay his bail
;
; Used by the routine at MVCOP2. Sam has been caught by a policeman; this
; routine makes the policeman pick Sam up if he has at least $46 on him, and
; ends the game otherwise.
;
; H 222 or 223 (policeman)
ARRESTSAM;
  PUSH HL                 ; Save the policeman's character number
  LD HL,(BUCKS)           ; HL=number of bucks (stored at BUCKS)
  LD DE,65490             ; DE=-46
  ADD HL,DE               ; Set the carry flag if Sam has at least $46
  POP HL                  ; Restore the policeman's character number to H
  JP C,LIFTSAM            ; Jump if Sam has at least $46 (to make the policeman
                          ; pick him up)
; Sam has less than $46. Game over.
  LD A,9                  ; Reduce Sam's cash supply to 0
  CALL CHGBUCKS           ;
  LD A,48                 ; Message 48; 'AT THE JAIL THEY THREW THE BOOK AT
                          ; ME...'
  LD DE,5232              ; D=20, E=112
  PUSH AF                 ; Save the message number
  LD A,58                 ; Combined with (E,D)=(112,20), this places the
                          ; top-left corner of the cutscene window at (128,31)
                          ; and Sam at (133,31) (in the jail cell)
  JP SCORECASH_1          ; Display the cutscene and end the game

; Control the hook while it's flying
;
; The address of this uninterruptible subcommand routine is placed into bytes
; 18 and 19 of the hook's buffer by the routine at USEHOOK. It controls the
; hook until the end of its flight, at which point it places a rope above the
; roof of no. 19 if necessary, or else restores the hook to its original
; location on the top floor of no. 74.
;
; H 229 (hook)
MVHOOK;
  CALL UPDATESRB          ; Update the SRB for the hook's current animatory
                          ; state and location
  LD L,20                 ; Byte 20 of the hook's buffer holds the distance
                          ; remaining in the hook's flight
  DEC (HL)                ; Decrease this by 1
  JR Z,MVHOOK_1           ; Jump if the hook's flight has ended
  RLCA                    ; Set the carry flag if the hook is flying rightwards
  RRCA                    ;
  DEC E                   ; Decrement the hook's x-coordinate
  JR NC,MVHOOK_0          ; Jump if the hook is flying leftwards
  INC E                   ; Otherwise increment the hook's x-coordinate
  INC E                   ;
MVHOOK_0;
  JP NZ,UPDATEAS          ; Update the hook's animatory state and location and
                          ; update the SRB (unless the hook has flown off the
                          ; edge of the play area)
; The hook's flight has ended (either naturally or by escaping the play area).
; Check whether it reached the roof of no. 17.
MVHOOK_1;
  DEC L                   ; L=19
  XOR A                   ; Remove the address of this routine from bytes 18
  LD (HL),A               ; and 19 of the hook's buffer
  LD L,3                  ; Clear all flags in byte 3 of the hook's buffer
  LD (HL),A               ;
  DEC L                   ; Set the hook's y-coordinate to 50 (out of sight)
  LD (HL),50              ;
  LD A,D                  ; A=hook's y-coordinate while it was flying
  CP 9                    ; Was it greater than 9?
  JR NC,MVHOOK_2          ; Jump if so
  LD A,E                  ; A=x-coordinate of the hook at the end of its flight
  CP 223                  ; Did the hook reach the roof of no. 17?
  JP NC,TOGGLEROPE        ; Jump if so
MVHOOK_2;
  LD HL,HOOK              ; Reactivate the entry for the hook in the object
  DEC (HL)                ; table at HOOK
  RET

; 'C' pressed - use hook
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'C' is
; pressed.
USEHOOK;
  LD A,(OBJINV)           ; Collect the object inventory flags from OBJINV
  BIT 6,A                 ; Has Sam got the hook?
  RET Z                   ; Return if not
  LD A,(58884)            ; A=Sam's z-coordinate
  LD HL,(58881)           ; Collect Sam's x- and y-coordinates in L and H
  RRCA                    ; Is Sam's z-coordinate 1 (indoors)?
  JR NC,USEHOOK_3         ; Jump if not
  LD A,L                  ; A=x (Sam's x-coordinate)
  CP 222                  ; Is Sam in no. 17 or no. 15 (x>=222)?
  RET NC                  ; Return if so
  CP 207                  ; Is Sam in no. 19 (207<=x<222)?
  JR NC,USEHOOK_1         ; Jump if so
  CP 122                  ; Is Sam in the police station, no. 27, or the
                          ; apartments next to no. 19 (122<=x<207)?
  JR NC,USEHOOK_0         ; Jump if so
  CP 103                  ; Is Sam in no. 31 (103<=x<122)?
  JR NC,USEHOOK_1         ; Jump if so
  CP 25                   ; Is Sam in no. 74 or the hotel (25<=x<103)?
  RET NC                  ; Return if so
USEHOOK_0;
  LD A,7                  ; 7 is the y-coordinate of the roof of the police
                          ; station, no. 27, and the apartment building next to
                          ; no. 19
  JR USEHOOK_2
USEHOOK_1;
  LD A,13                 ; 13 is the y-coordinate of the roofs of no. 19 and
                          ; no. 31
USEHOOK_2;
  CP H                    ; Is Sam on the roof of a building?
  RET C                   ; Return if not
; Sam is in a location that is amenable to hook-throwing.
USEHOOK_3;
  INC H                   ; H=1+Sam's y-coordinate
  LD A,(SAMCBUF)          ; A=Sam's animatory state
  AND 128                 ; Keep only the direction bit (bit 7)
  JR Z,USEHOOK_4          ; Jump if Sam is facing left
  INC L                   ; L=1+Sam's x-coordinate
USEHOOK_4;
  ADD A,121               ; A=121/249 (hook)
  EX DE,HL                ; DE=hook's initial coordinates
  LD HL,58643             ; Point HL at byte 19 of character buffer 229
  INC (HL)                ; Is the current owner of character buffer 229 (the
  DEC (HL)                ; hook or a banknote) under the control of an
                          ; uninterruptible subcommand routine?
  RET NZ                  ; Return if so (the hook must currently be in flight,
                          ; which is unlikely)
; The hook will be thrown. Prepare it for launch now.
  INC L                   ; Initialise the distance remaining for the hook to
  LD (HL),20              ; fly (stored in byte 20 of the hook's buffer)
  DEC L                   ; Place the address of the uninterruptible subcommand
  LD (HL),123             ; routine at MVHOOK into bytes 18 and 19 of the
  DEC L                   ; hook's buffer
  LD (HL),182             ;
  LD L,4                  ; Set the hook's z-coordinate to 4
  LD (HL),L               ;
  DEC L                   ; Set bit 7 of byte 3 of the hook's buffer, thus
  LD (HL),128             ; making the hook fly as fast as possible
  DEC L                   ; Initialise the hook's x- and y-coordinates
  LD (HL),D               ;
  DEC L                   ;
  LD (HL),E               ;
  DEC L                   ; Initialise the hook's animatory state
  LD (HL),A               ;
  CALL UPDATEAS           ; Update the hook's animatory state and location and
                          ; update the SRB
  LD HL,OBJINV            ; The object inventory flags are stored at OBJINV
  RES 6,(HL)              ; Clear bit 6, thus removing the hook from Sam's
                          ; possession
  LD H,230                ; 230=Sam
  JP RAISEARM             ; Raise Sam's arm and make a sound effect

; Unused
  DEFB 0

; Check whether a character will soon be entering or leaving the hotel
;
; Used by the routine at NEXTMOVE. Checks whether a character will soon be
; entering or leaving the hotel, and if so, determines where he should start
; climbing the front steps (depending on his current location), or through
; which door he should leave (left or right, depending on his destination).
;
; H Character number (215-230)
BYHOTEL;
  CALL LOCID              ; Obtain an identifier for the character's current
                          ; location
  PUSH AF                 ; Save the identifier
  AND A                   ; Is the character on the sidewalk or the road?
  JR NZ,BYHOTEL_3         ; Jump if not
; The character is on the sidewalk or the road.
  LD L,12                 ; Collect the character's destination location
  LD A,(HL)               ; identifier from byte 12 of his buffer
  AND 240                 ; Keep only the region identifier bits (bits 4-7)
  CP 144                  ; Is the character going to the hotel?
  JR NZ,BYHOTEL_2         ; Jump if not
; The character is on the sidewalk or road, and destined for somewhere inside
; or outside the hotel. Figure out which entrance (left or right) the character
; should use, based on his current location and his destination.
  LD A,(HL)               ; A=destination location identifier
  CP 149                  ; Set the carry flag if the destination is on the
                          ; first floor or the front steps of the hotel
  LD L,10                 ; Point HL at byte 10 of the character's buffer
  LD A,(HL)               ; A=x' (the character's destination x-coordinate)
  JR C,BYHOTEL_0          ; Jump if the destination is on the first floor or
                          ; the front steps of the hotel (in which case
                          ; 75<=x'<=82)
  LD A,79                 ; Assume x'=79 (the x-coordinate of the middle of the
                          ; doorsteps of the hotel)
BYHOTEL_0;
  LD L,1                  ; Add x (the character's current x-coordinate)
  ADD A,(HL)              ;
  SUB 158                 ; Reset the carry flag if 158-x'<=x<=285-x'
  RLCA                    ;
  LD A,88                 ; This is the x-coordinate of the rightmost front
                          ; doorstep of the hotel
  JR NC,BYHOTEL_1         ; Jump if x>=158-x' (the character will enter the
                          ; hotel from the right)
  LD A,67                 ; This is the x-coordinate of the leftmost front
                          ; doorstep of the hotel
BYHOTEL_1;
  LD BC,65448             ; Point BC at the first byte of the entry that
                          ; corresponds to the hotel in the data table of
                          ; building entrance x-coordinates at ENTRANCEX
  LD (BC),A               ; Set the first byte to 67 or 88
  ADD A,2                 ; Set the second byte of the entry to 69 or 90
  INC C                   ;
  LD (BC),A               ;
BYHOTEL_2;
  POP AF                  ; Restore the identifier for the character's current
                          ; location to A
  RET
; The character is not on the sidewalk or the road.
BYHOTEL_3;
  CP 149                  ; If the character's location identifier is at least
                          ; 149, then he's not on the first floor or the front
                          ; steps of the hotel
  JR NC,BYHOTEL_2         ; Jump if this is the case
  CP 145                  ; Is the character on the front steps of the hotel
                          ; (below the level of the first floor)?
  JR Z,BYHOTEL_4          ; Jump if so
  AND 240                 ; Keep only the region identifier bits (bits 4-7)
  CP 144                  ; Is the character on the first floor of the hotel?
  JR NZ,BYHOTEL_2         ; Jump if not
; The character is on the first floor of the hotel.
  LD L,10                 ; Point HL at byte 10 of the character's buffer
  LD A,(HL)               ; A=x' (character's destination x-coordinate)
  LD L,1                  ; Add x (the character's current x-coordinate;
  ADD A,(HL)              ; 75<=x<=82)
  SUB 158                 ; Reset the carry flag if 158-x<=x'<=285-x
  RLCA                    ;
  LD D,76                 ; Set D (which holds the x-coordinate of the top of
                          ; the steps going down to the sidewalk below) to 76
                          ; (x-coordinate of the left-hand entrance of the
                          ; hotel)
  JR C,BYHOTEL_2          ; Jump if x'<158-x (the character will exit the hotel
                          ; on the left)
  LD D,81                 ; This is the x-coordinate of the right-hand entrance
                          ; of the hotel
  JR BYHOTEL_2            ; Return to the caller with D adjusted depending on
                          ; the character's destination x-coordinate
; The character is on the front steps of the hotel (below the level of the
; first floor).
BYHOTEL_4;
  LD L,13                 ; Set the location/destination indicator in byte 13
  LD (HL),0               ; of the character's buffer to 0 (the front steps of
                          ; the hotel count as part of the sidewalk if the
                          ; character is going somewhere other than the hotel)
  DEC L                   ; L=12
  LD A,(HL)               ; A=destination location identifier
  AND 240                 ; Keep only the region identifier bits (bits 4-7)
  CP 144                  ; Is the character going to the hotel?
  JR NZ,BYHOTEL_2         ; Jump if not
; The character is on the front steps of the hotel (below the level of the
; first floor), and his destination is somewhere inside or outside the hotel.
  INC L                   ; Set byte 13 of the character's buffer to 1
  INC (HL)                ; (indicating that the character is not on the
                          ; sidewalk or the road, and is in the same region as
                          ; his destination)
  DEC L                   ; L=12
  LD A,(HL)               ; A=destination location identifier
  CP 149                  ; Is the destination on or below the first floor of
                          ; the hotel?
  JR C,BYHOTEL_8          ; Jump if so
; The character is on the front steps of the hotel (below the level of the
; first floor), and his destination is somewhere inside the hotel, above the
; first floor.
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD B,L                  ; B=1 (go right)
  LD A,(HL)               ; A=x (the character's x-coordinate)
  CP 79                   ; Set the carry flag if x<79
  LD A,76                 ; This is the x-coordinate of the left edge of the
                          ; front door of the hotel
  JR C,BYHOTEL_5          ; Jump if x<79
  LD A,82                 ; This is the x-coordinate of the right edge of the
                          ; front door of the hotel
BYHOTEL_5;
  CP (HL)                 ; Compare A (76 or 82) with x (the character's
                          ; x-coordinate)
  DEC HL                  ; Point HL at byte 0 of the character's buffer
  JR C,BYHOTEL_7          ; Jump if x is 77 or 78, or greater than 82 (meaning
                          ; the character should go left to reach the hotel
                          ; entrance)
  BIT 7,(HL)              ; Is the character facing right?
  JR NZ,BYHOTEL_2         ; Jump if so
  POP AF                  ; Restore the identifier for the character's current
                          ; location to A (though it is ignored)
BYHOTEL_6;
  LD A,B                  ; A=1 (go right) or 2 (go left)
  POP BC                  ; Drop the return address from the stack
  RET                     ; Return to the caller of NEXTMOVE
BYHOTEL_7;
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,BYHOTEL_2          ; Jump if so
  INC B                   ; B=2 (go left)
  JR BYHOTEL_6
; The character is on the front steps of the hotel (below the level of the
; first floor), and his destination is on or below the first floor of the
; hotel.
BYHOTEL_8;
  POP AF                  ; Restore the identifier for the character's current
                          ; location to A (though it is ignored)
  POP BC                  ; Drop the return address from the stack
  JP NEXTMOVE_0           ; Re-enter the calling routine at NEXTMOVE_0

; Unused
  DEFB 0

; Collect a character's destination coordinates from a command list
;
; Used by the routine at GOTO. Copies the destination coordinates from the
; command list into bytes 10 and 11 of the character's buffer, and inserts the
; location identifier for the destination into byte 12.
;
; H Character number (215-229)
GETDEST;
  LD L,10                 ; Copy the destination coordinates from the command
  CALL GETPARAMS          ; list into bytes 10 and 11 of the character's buffer
  LD D,(HL)               ; Transfer the destination coordinates to DE
  DEC L                   ;
  LD E,(HL)               ;
  LD C,1                  ; Assume a destination z-coordinate of 1 (indoors)
  CALL DESTTOSAM_1        ; Obtain an identifier for the destination location
                          ; and copy it into byte 12 of the character's buffer
  LD L,8                  ; Point HL at byte 8 of the character's buffer
  RET

; Take the hook and budgie from Sam
;
; Used by the routine at ROOFEDGE. Removes the hook and the budgie from Sam's
; possession if he has either one.
RMOBJS;
  LD HL,HOOK              ; Point HL at the object location table at HOOK
RMOBJS_0;
  LD A,(HL)               ; Pick up the first byte of an entry
  INC A                   ; Have we reached the end of the table?
  RET Z                   ; Return if so
  INC HL                  ; Point HL at the last byte of the entry
  INC HL                  ;
  INC HL                  ;
  RRCA                    ; Is the entry active?
  JR C,RMOBJS_1           ; Jump to the next entry if not
  AND 32                  ; Is the entry for the hook or budgie?
  JR Z,RMOBJS_1           ; Jump to the next entry if not
  LD A,(OBJINV)           ; Collect the object inventory flags from OBJINV
  AND (HL)                ; Does Sam have this object?
  JR Z,RMOBJS_1           ; Jump if not
  LD A,(OBJINV)           ; Take the object from Sam by resetting the
  XOR (HL)                ; appropriate bit at OBJINV
  LD (OBJINV),A           ;
  DEC HL                  ; Point HL at the first byte of the entry
  DEC HL                  ;
  DEC HL                  ;
  DEC (HL)                ; Activate the entry by resetting bit 0 of the first
                          ; byte
  JR RMOBJS_0             ; Jump back to scan the remaining entries
RMOBJS_1;
  INC HL                  ; Move HL along to the first byte of the next entry
  JR RMOBJS_0             ; Jump back to scan this entry

; Check whether Sam should be chased by the police
;
; Used by the routine at MVCOP2. Returns with the police flags in A if Sam is
; neither falling from the roof of a building nor being carried by a gangster
; or policeman; otherwise returns with A=0.
CHKWANTED;
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND 129                 ; Keep only bits 0 and 7
  LD A,(COPFLAGS)         ; Collect the police flags from COPFLAGS
  RET Z                   ; Return unless Sam is being carried by a gangster or
                          ; policeman, or is falling from a building
  XOR A                   ; A=0
  RET

; Set the attribute bytes for Sam's current disguise
;
; Used by the routine at COPTOSLKW. Sets the attribute bytes for Sam's disguise
; in the bottom right corner of the screen.
GUISEATTR;
  EX DE,HL
; This entry point is used by the routine at CHGGUISE.
GUISEATTR_0;
  PUSH HL
  CALL CHKGUISE           ; Get the attribute byte to use for Sam's disguise
GUISEATTR_1;
  LD BC,797               ; B=3, C=29
GUISEATTR_2;
  LD (HL),A               ; Set a row of attribute bytes for Sam's disguise in
  INC L                   ; the bottom right of the screen
  DJNZ GUISEATTR_2        ;
  JR Z,GUISEATTR_3        ; Jump if we've done all 3 rows
  ADD HL,BC               ; Point HL at the attribute byte for the first tile
                          ; in the next row down
  JR GUISEATTR_1          ; Jump back to set the attribute bytes in this row
GUISEATTR_3;
  POP HL
  RET

; Object/key/cash/message location table
;
; Used by the routines at INITOBJS, FOUNDOBJ and RMOBJS. Each entry here
; consists of 4 bytes. The bits in the first byte have the following meanings;
;
; +--------+------------------------------------------------------------------+
; | Bit(s) | Meaning                                                          |
; +--------+------------------------------------------------------------------+
; | 7      | If set, the entry is initially inactive                          |
; | 4-6    | 000; entry corresponds to a cash bonus                           |
; |        | 001; entry corresponds to a key                                  |
; |        | 010; entry corresponds to a message                              |
; |        | 100; entry corresponds to an object that must be picked up (hook |
; |        | or budgie)                                                       |
; | 1-3    | Unused                                                           |
; | 0      | If set, the entry is inactive                                    |
; +--------+------------------------------------------------------------------+
;
; The second and third bytes contain the coordinates of the object. The
; contents of the fourth byte depend on the type of object; see the individual
; entry for details.
;
; The first entry in this table is for the hook. It is active from the
; beginning of the game, deactivated (by the routine at FOUNDOBJ) when the hook
; is picked up, and reactivated (by the routine at MVHOOK) after the hook has
; been thrown and finished flying.
HOOK;
  DEFB 64                 ; Bit 6 set; object that must be picked up
  DEFB 51,13              ; Location (top floor of no. 74)
  DEFB 64                 ; Bit 6 set (see OBJINV)
; The next entry is for the budgie. It is activated by the routine at EVENTS
; (using the event entry at EVENT10), and deactivated (by the routine at
; FOUNDOBJ) when the budgie is picked up.
BUDGIE;
  DEFB 193                ; Bit 6 set; object that must be picked up
  DEFB 225,13             ; Location (room above Sam's office)
  DEFB 128                ; Bit 7 set (see OBJINV)
; The next entry is for the key to no. 74. It is activated by the routine at
; EVENTS (using the event entry at EVENT07), and deactivated (by the routine at
; FOUNDOBJ) when the key is found.
KEY74;
  DEFB 145                ; Bit 4 set; key
  DEFB 34,13              ; Location (in the room past the catwalk)
  DEFB 8                  ; Bit 3 set (see KEYINV)
; The next entry is for the key to no. 31. It is active from the beginning of
; the game, and deactivated (by the routine at FOUNDOBJ) when the key is found.
KEY31;
  DEFB 16                 ; Bit 4 set; key
  DEFB 252,13             ; Location (top floor of no. 15)
  DEFB 16                 ; Bit 4 set (see KEYINV)
; The next entry is for the key to no. 27. It is activated by the routine at
; EVENTS (using the event entry at EVENT09), and deactivated (by the routine at
; FOUNDOBJ) when the key is found.
KEY27;
  DEFB 145                ; Bit 4 set; key
  DEFB 170,35             ; Location (middle of the road next to no. 27)
  DEFB 32                 ; Bit 5 set (see KEYINV)
; The next entry is for the key to no. 15. It is active from the beginning of
; the game, and deactivated (by the routine at FOUNDOBJ) when the key is found.
KEY15;
  DEFB 16                 ; Bit 4 set; key
  DEFB 106,25             ; Location (second floor of no. 31)
  DEFB 64                 ; Bit 6 set (see KEYINV)
; The next entry is for the dead man's body on the top floor of the hotel. It
; is active from the beginning of the game, and deactivated (by the routine at
; FOUNDOBJ) when Sam finds the body.
CORPSE;
  DEFB 32                 ; Bit 5 set; message
  DEFB 64,7               ; Location (top floor of the hotel)
  DEFB 53                 ; Message 53; 'THERE'S A MAN'S BODY ON THE FLOOR'
; The next entry is for where someone growls 'NO KEY EH!'. It is active from
; the beginning of the game, and deactivated by the routine at EVENTS (using
; the event entry at EVENT04).
NOKEYEH;
  DEFB 32                 ; Bit 5 set; message
  DEFB 249,27             ; Location (stairs up to the second floor of no. 15)
  DEFB 61                 ; Message 61; 'SOMEONE GROWLED 'NO KEY EH!''
; The next entry is for where there's a safe with four locks. It is active from
; the beginning of the game, and deactivated (by the routine at FOUNDOBJ) when
; Sam finds the safe.
SAFE;
  DEFB 32                 ; Bit 5 set; message
  DEFB 228,13             ; Location (room above Sam's office)
  DEFB 71                 ; Message 71; 'THERES A SAFE WITH 4 LOCKS'
; The next entry is for where someone below says 'CRUISE WAS DRESSED AS THE OIL
; MAN...'. It is deactivated (by the routine at FOUNDOBJ) when Sam is halfway
; across the rope, and checked by the routine at EVENTS (using the event entry
; at EVENT02).
ROPEMSG;
  DEFB 32                 ; Bit 5 set; message
  DEFB 214,6              ; Location (on the rope above no. 19)
  DEFB 70                 ; Message 70; 'SOMEONE BELOW SAID 'CRUISE WAS DRESSED
                          ; AS THE OIL MAN. DONT LET ANYONE PAST''
; The next entry is for the cash bonus on the top floor of the hotel. It is
; deactivated (by the routine at FOUNDOBJ) when Sam finds the money.
CASH1;
  DEFB 0                  ; Bits 4-6 reset; cash
  DEFB 58,7               ; Location
  DEFB 100                ; $100
; The next entry is for the cash bonus on the first floor of no. 19. It is
; deactivated (by the routine at FOUNDOBJ) when Sam finds the money.
CASH2;
  DEFB 0                  ; Bits 4-6 reset; cash
  DEFB 220,31             ; Location
  DEFB 50                 ; $50
; The next entry is for the cash bonus on the second floor of no. 15. It is
; deactivated (by the routine at FOUNDOBJ) when Sam finds the money.
CASH3;
  DEFB 0                  ; Bits 4-6 reset; cash
  DEFB 242,25             ; Location
  DEFB 100                ; $100
; The next entry is for the cash bonus on the top floor of no. 74. It is
; deactivated (by the routine at FOUNDOBJ) when Sam finds the money.
CASH4;
  DEFB 0                  ; Bits 4-6 reset; cash
  DEFB 40,13              ; Location
  DEFB 100                ; $100
; The last entry is for the cash bonus in the room above Sam's office. It is
; deactivated (by the routine at FOUNDOBJ) when Sam finds the money.
CASH5;
  DEFB 0                  ; Bits 4-6 reset; cash
  DEFB 226,13             ; Location
  DEFB 200                ; $200
; And finally the end marker.
  DEFB 255

; Message 59; 'LANA ANSWERED 'OOH SAM! THEY KILLED MY FIANCE AND STOLE THE
; BUDGIE''
;
; Appears in the phone message table entry at PHONEMSG3.
MSG059;
  DEFB 27                 ; 27; 'LANA ANSWERED 'OOH SAM! '
  DEFB 122                ; 122; 'THE'
  DEFM "Y KILL"
  DEFB 108                ; 108; 'ED '
  DEFM "MY FIANCE"
  DEFB 116                ; 116; ' AND '
  DEFM "STOLE"
  DEFB 100                ; 100; ' THE '
  DEFM "BUDGIE'"
  DEFB 0                  ; End marker

; Message 60; 'LANA ANSWERED 'OOH SAM! THAT CROOK THE FAT MAN'S JUST MOVED INTO
; NO 15''
;
; Appears in the phone message table entry at PHONEMSG4.
MSG060;
  DEFB 27                 ; 27; 'LANA ANSWERED 'OOH SAM! '
  DEFB 31                 ; 31; 'THAT'
  DEFM " CROOK"
  DEFB 100                ; 100; ' THE '
  DEFB 129                ; 129; 'FAT'
  DEFB 115                ; 115; ' MAN'
  DEFM "'S JUST MOV"
  DEFB 108                ; 108; 'ED '
  DEFM "INTO "
  DEFB 102                ; 102; 'NO '
  DEFM "15'"
  DEFB 0                  ; End marker

; Message 61; 'SOMEONE GROWLED 'NO KEY EH!''
;
; Appears in the message location table entry at NOKEYEH.
MSG061;
  DEFB 128                ; 128; 'SOMEONE '
  DEFM "GROWL"
  DEFB 108                ; 108; 'ED '
  DEFM "'"
  DEFB 102                ; 102; 'NO '
  DEFB 4                  ; 4; 'KEY'
  DEFM " EH!'"
  DEFB 0                  ; End marker

; Message 62; 'IT ALL WENT BLACK. AS I FELL SOMEONE FAT PUSHED PAST ME SHOUTING
; ' YOULL NOT GET THE KEY WHEN I'M STILL STANDING''
;
; Appears in Sam's initialisation parameters for game mode 2 at SAMMODE2.
MSG062;
  DEFM "IT ALL WENT BLACK. AS "
  DEFB 103                ; 103; 'I '
  DEFM "FELL "
  DEFB 128                ; 128; 'SOMEONE '
  DEFB 129                ; 129; 'FAT'
  DEFM " PUSH"
  DEFB 108                ; 108; 'ED '
  DEFM "PAST ME SHOUT"
  DEFB 30                 ; 30; 'ING '
  DEFM "'"
  DEFB 126                ; 126; ' YOU'
  DEFM "LL NOT GET"
  DEFB 100                ; 100; ' THE '
  DEFB 4                  ; 4; 'KEY'
  DEFB 7                  ; 7; ' WHEN'
  DEFM " I'M STILL STAND"
  DEFB 127                ; 127; 'ING'
  DEFM "'"
  DEFB 0                  ; End marker

; Unused
  DEFB 0

; Mirrored values of 0-255
;
; The contents of this table are generated by the routine at GENMIRROR and used
; by the routine at GETTILE to flip sprite tiles. This page of memory is also
; used as a temporary store for the top 8 rows of pixels on the screen by the
; routine at SCRUPDOWN7 when scrolling the screen up and down.
MIRROR;
  DEFB 0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240
  DEFB 8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248
  DEFB 4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244
  DEFB 12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252
  DEFB 2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242
  DEFB 10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250
  DEFB 6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246
  DEFB 14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254
  DEFB 1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241
  DEFB 9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249
  DEFB 5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245
  DEFB 13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253
  DEFB 3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243
  DEFB 11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251
  DEFB 7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247
  DEFB 15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255

; Screen refresh buffer
;
; Used by the routines at UPDATEAS, UPDATESCR, ENDCSCENE, MOVEDOOR, WINDOWSRB
; and HIDEPA. Each byte of the screen refresh buffer (SRB) corresponds to a
; segment of 8 character squares on the screen, the leftmost of which will be
; at x=0, x=8, x=16 or x=24. Each bit set in an SRB byte corresponds to a
; character square in the segment that needs refreshing. Bit 7 corresponds to
; the leftmost character square in the segment, bit 0 to the rightmost
; character square.
;
; Note that, owing to a quirk in the way the SRB-updating routine at UPDATEAS
; works, the first 16 bytes of the screen refresh buffer correspond not to any
; part of the screen, but to the four rows of the play area that are
; immediately above the currently visible portion of the play area. Therefore,
; the screen-updating routine at UPDATESCR ignores those bytes and starts
; inspecting SRB bytes at 32528 instead.
;
; Note also that the routine at QUEUEMSG uses the first 16 bytes of the SRB as
; a temporary backup store for the submessage indicator and submessage
; addresses at SUBMSGS, and the routine at SCRUPDOWN7 uses the first 32 bytes
; of the SRB as a temporary store for the top row of attribute bytes when
; scrolling the screen up and down.
SRB;
  DEFS 96

; Message buffer
;
; Used by the routine at QUEUEMSG to prepare a message before displaying it.
; Also used by the routines at CBUFGFWD and CBUFGREV as temporary storage for
; one of the character buffers in groups 215-221.
MSGBUFFER;
  DEFS 32                 ; The message is placed here
MSGBUFOF;
  DEFB 0                  ; Overflow byte

; Submessage indicator and message addresses
;
; Used by the routine at QUEUEMSG.
SUBMSGS;
  DEFB 0                  ; 0 (end of top-level message has been reached), 2
                          ; (top-level message), 4 (submessage), 6
                          ; (sub-submessage) or 8 (sub-sub-submessage)
  DEFW 0                  ; Address of the next character in the top-level
                          ; message
  DEFW 0                  ; Address of the next character in the submessage
  DEFW 0                  ; Address of the next character in the sub-submessage
  DEFW 0                  ; Address of the next character in the
                          ; sub-sub-submessage
  DEFW 0                  ; Unused (no message has more than 3 levels of
  DEFW 0                  ; submessages)
  DEFW 0                  ;
  DEFB 0                  ; Unused

; Unused
  DEFB 0

; Message 2; '{number}'
;
; Used as a submessage of message 42. This message is cleared by the routine at
; PHONE when Sam picks up a phone, and updated by the routine at ONPHONE as Sam
; dials.
MSG002;
  DEFS 4                  ; The message is placed here
  DEFB 0                  ; End marker

; Phone table entry address
;
; Used by the routines at GIVENAME and PHONEMSG. Holds either the address of
; the second byte of the entry in the phone message table at RINGPHONE1 or
; PHONEMSG1 that corresponds to the phone that Sam is calling (if the person on
; the other end has a message for him) or picking up a call from, or the
; address of the final byte of the phone table at PHONEMSG1 (if the person
; Sam's calling has no message to give); this address contains the number of
; the message corresponding to the name that Sam must give in order to receive
; the telephone message, or 0 if no name is required to receive the message, or
; 255 if the person Sam's calling will respond with message 46 (I DUNNO NO
; {name}).
PTABLEADDR;
  DEFW 0

; Time that Sam last lifted a ringing telephone
;
; Checked by the routine at RINGING and set by the routine at PHONE (to the
; value of the second byte of the the system variable FRAMES, which is
; incremented every 5.12s).
RPHONETIME;
  DEFB 0

; ID of the telephone that Sam is calling
;
; Checked by the routines at EVENTS (using the event entry at EVENT06) and
; CHKANSWER, and updated by the routines at LIFTSAM, GIVENAME, PLACECALL and
; PHONEKEY.
OPHONEID;
  DEFB 0

; Telephone call status flags
;
; Used by the routines at WHOSTHERE, PHONE, GIVENAME, ONPHONE and PLACECALL.
;
; +--------+----------------------------------------------------+
; | Bit(s) | Meaning if set                                     |
; +--------+----------------------------------------------------+
; | 0      | Unused                                             |
; | 1      | The telephone call is finished (disconnected)      |
; | 2,3    | Unused                                             |
; | 4      | A digit is being dialled                           |
; | 5      | The destination telephone is ringing               |
; | 6      | Sam must give a name in response to 'WHO'S THERE?' |
; | 7      | Sam has picked up a ringing telephone              |
; +--------+----------------------------------------------------+
CALLFLAGS;
  DEFB 0

; Score
;
; Checked by the routine at ENDCSCENE, and updated by the routine at INCSCORE.
SCORE;
  DEFW 0

; Bucks
;
; Checked by the routines at FREESAM, ARRESTSAM and ENDCSCENE, and updated by
; the routines at SAMLANA and CHGBUCKS.
BUCKS;
  DEFW 50

; Time the last message was displayed
;
; Used by the routine at QUEUEMSG. Holds the two least significant bytes of the
; system variable FRAMES as they were when the last message was displayed.
MSGTIME;
  DEFW 0

; Blown fuse delay counters
;
; When a fuse is blown, the corresponding delay counter here is initialised by
; the routine at FUSE. The delay counters are checked and decremented by the
; routine at CHKFUSES.
FUSECTRS;
  DEFB 0                  ; No. 74
  DEFB 0                  ; Hotel
  DEFB 0                  ; No. 31
  DEFB 0                  ; No. 19
  DEFB 0                  ; No. 17
  DEFB 0                  ; No. 15

; Icon panel status flags
;
; Used as a temporary buffer by the routines at ICONPANEL1, ICONPANEL2 and
; FOUNDOBJ. Each bit set here (by the routine at ICONPANEL2 or FOUNDOBJ)
; corresponds to an icon that should be displayed in the panel.
;
; +--------+-------------+
; | Bit(s) | Icon        |
; +--------+-------------+
; | 7      | Fuse/Budgie |
; | 6      | Door/Hook   |
; | 5      | Light bulb  |
; | 4      | Telephone   |
; | 0-3    | Unused      |
; +--------+-------------+
IPFLAGS;
  DEFB 0

; Main loop task timer
;
; Decremented and checked on every pass through the main loop by the routine at
; MNLPTASKS1, and also checked by the routine at SHUTDOORS.
TASKTIMER;
  DEFB 0

; Door knock status flags
;
; Used by the routines at CANOPEN, DOORDUTY and OPENDOOR. The bits in each byte
; here are used as follows;
;
; +--------+---------------------------------------+
; | Bit(s) | Meaning if set                        |
; +--------+---------------------------------------+
; | 7      | Somebody has just knocked on the door |
; | 6      | Somebody is going to answer the door  |
; | 0-5    | Unused                                |
; +--------+---------------------------------------+
KNOCKFLAGS;
  DEFB 0                  ; Shop at the far left of town (unused)
  DEFB 0                  ; Right-hand shop under the apartments next to no. 74
                          ; (unused)
  DEFB 0                  ; No. 74
  DEFB 0                  ; No. 31
  DEFB 0                  ; No. 27
  DEFB 0                  ; No. 19
  DEFB 0                  ; Shop under no. 17 (unused)
  DEFB 0                  ; No. 17
  DEFB 0                  ; Shop under no. 15 (unused)
  DEFB 0                  ; No. 15

; Blown fuse indicator
;
; Used by the routine at MVCHARS, which stores a non-zero value here if any
; fuses are currently blown.
BLOWNFUSE;
  DEFB 0

; Unused
  DEFB 0

; Fuse flags
;
; Used by the routines at FUSE and BYFUSE. A bit set here indicates that the
; corresponding fuse has already been blown once. Bits 6 and 7 are unused.
;
; +-----+--------+
; | Bit | Fuse   |
; +-----+--------+
; | 0   | No. 74 |
; | 1   | Hotel  |
; | 2   | No. 31 |
; | 3   | No. 19 |
; | 4   | No. 17 |
; | 5   | No. 15 |
; +-----+--------+
FUSEFLAGS;
  DEFB 0

; Index of the current message in the message queue
;
; Used by the routines at QUEUEMSG and MSGDELAY.
MSGINDEX;
  DEFB 0

; Message queue
;
; Used by the routines at QUEUEMSG, MSGDELAY and CHKQUEUE.
MSGQUEUE;
  DEFS 8

; Bullet buffer 1
;
; Used by the routines at MVSNIPER2, MVBULLETS and UPDSNIPER.
BULLET1;
  DEFB 0                  ; x-coordinate of the leftmost column of the play
                          ; area on screen the last time the bullet was drawn
  DEFB 0                  ; Bullet's screen x-coordinate; x
  DEFB 0                  ; Bullet's screen y-coordinate; y (0 if the bullet is
                          ; not in flight)
; The bits in the fourth byte of the bullet buffer have the following
; significance;
;
; +--------+------------------------------------------------------------------+
; | Bit(s) | Description                                                      |
; +--------+------------------------------------------------------------------+
; | 7      | Reset if the bullet is flying leftwards, set otherwise           |
; | 6      | Reset if the bullet is flying perfectly horizontally, set        |
; |        | otherwise (in which case bit 4 is also used)                     |
; | 5      | Unused                                                           |
; | 4      | Reset if the bullet is flying towards the ground, set if it's    |
; |        | flying towards the sky                                           |
; | 3      | Unused                                                           |
; | 0-2    | Pixel row at which the bullet should be drawn in the screen cell |
; |        | at (x,y)                                                         |
; +--------+------------------------------------------------------------------+
  DEFB 0

; Bullet buffer 2
;
; Used by the routines at MVSNIPER2, MVBULLETS and UPDSNIPER.
BULLET2;
  DEFB 0                  ; x-coordinate of the leftmost column of the play
                          ; area on screen the last time the bullet was drawn
  DEFB 0                  ; Bullet's screen x-coordinate; x
  DEFB 0                  ; Bullet's screen y-coordinate; y (0 if the bullet is
                          ; not in flight)
; The bits in the fourth byte of the bullet buffer have the following
; significance;
;
; +--------+------------------------------------------------------------------+
; | Bit(s) | Description                                                      |
; +--------+------------------------------------------------------------------+
; | 7      | Reset if the bullet is flying leftwards, set otherwise           |
; | 6      | Reset if the bullet is flying perfectly horizontally, set        |
; |        | otherwise (in which case bit 4 is also used)                     |
; | 5      | Unused                                                           |
; | 4      | Reset if the bullet is flying towards the ground, set if it's    |
; |        | flying towards the sky                                           |
; | 3      | Unused                                                           |
; | 0-2    | Pixel row at which the bullet should be drawn in the screen cell |
; |        | at (x,y)                                                         |
; +--------+------------------------------------------------------------------+
  DEFB 0

; Last value seen in the system variable FRAMES
;
; Stores the value of the LSB of the system variable FRAMES as it stood at the
; end of the last pass through the main loop at MAINLOOP or the routine at
; CUTSCENE.
LFRAMES;
  DEFB 0

; Current disguise
;
; Checked by the routines at COPTOSAM, CHKCHASE and EVENTS (using the event
; entry at EVENT07), and changed by the routine at CHGGUISE. Holds the ID of
; Sam's current disguise.
DISGUISEID;
  DEFB 0

; Number string buffer
;
; Used by the routine at PRINTNUM.
NUMSTRBUF;
  DEFS 5                  ; The number string is placed here
  DEFB 0                  ; End marker

; Message 1; '{tens digit}/{name}'
;
; Used as a submessage of messages 36, 40, 46 and 52. The message number of the
; name is inserted by the routine at GIVENAME; the tens digit of the number of
; bucks is inserted by the routine at FREESAM or ROOFEDGE.
MSG001;
  DEFB 0                  ; The tens digit of the number of bucks or the
                          ; message number of the name is inserted here
  DEFB 0                  ; End marker

; Message number to watch in the message queue
;
; Set by the routines at SAMLANA, CUTSCENE and GETINPUT, and checked by the
; routine at MSGINQUEUE.
MSGNUM;
  DEFB 0

; ID of the telephone Sam is holding
;
; Set by the routine at PHONE and checked by the routine at ONPHONE.
PHONEID;
  DEFB 0

; Time when the score was last incremented
;
; Checked and set by the routine at SCORECASH. Holds the value of the two least
; significant bytes of the system variable FRAMES as they were when the score
; was last incremented.
SCOREINCTS;
  DEFW 0

; Unused
  DEFS 5

; Location the police should head for when looking for Sam
;
; Set by the routines at COPTOSCL and ENTRYNOKEY, and checked by the routine at
; MVCOP2.
SAMLOCX;
  DEFB 0                  ; x-coordinate
SAMLOCY;
  DEFB 0                  ; y-coordinate
SAMLOCID;
  DEFB 0                  ; Location identifier (see LOCID)

; Random number seed
;
; Used by the routine at GETRANDOM.
RANDSEED;
  DEFW 65041              ; This is the initial value of the seed

; Unused
;
; Data is copied here from the game status buffer template at GSBTEMPLT, but is
; never used.
XUNKNOWN;
  DEFS 7

; Bullet timer
;
; Used by the routine at MVBULLETS.
BTIMER;
  DEFB 0

; Disguise status flags
;
; Modified by the routine at COPTOSLKW, and checked by the routine at CHKGUISE.
; Each bit set here corresponds to a disguise that is known by the police. Bit
; 7 (corresponding to no disguise) is always set.
GUISEFLAGS;
  DEFB 0

; Object inventory
;
; Changed by the routine at FOUNDOBJ, and checked by the routines at
; MVBANKNOTE, EVENTS (using the event entries at EVENT11 and EVENT13) and
; USEHOOK. Each bit set here corresponds to an object in Sam's possession.
;
; +--------+--------+
; | Bit(s) | Object |
; +--------+--------+
; | 0-5    | Unused |
; | 6      | Hook   |
; | 7      | Budgie |
; +--------+--------+
OBJINV;
  DEFB 0

; Key inventory
;
; Changed by the routines at FOUNDOBJ and GETINPUT, and checked by the routines
; at EVENTS (using the event entries at EVENT04 and EVENT10) and ENTRYNOKEY.
; Each bit set here corresponds to a key in Sam's possession.
;
; +--------+--------+
; | Bit(s) | Key    |
; +--------+--------+
; | 0-2    | Unused |
; | 3      | No. 74 |
; | 4      | No. 31 |
; | 5      | No. 27 |
; | 6      | No. 15 |
; | 7      | No. 19 |
; +--------+--------+
KEYINV;
  DEFB 0

; Police flags
;
; Changed by the routines at LIFTSAM, EVENTS (using the event entry at
; EVENT10), SAMWANTED, ENTRYNOKEY and DROPSAM; checked by the routines at
; ICONPANEL1, BYJAILDOOR, FREESAM and CHKWANTED. The bits set here have the
; following meaning;
;
; +--------+-----------------------------+
; | Bit(s) | Meaning if set              |
; +--------+-----------------------------+
; | 0      | Sam is wanted by the police |
; | 1-6    | Unused                      |
; | 7      | Sam is in jail              |
; +--------+-----------------------------+
COPFLAGS;
  DEFB 0

; High score
;
; The high score is copied here from the game status buffer template at
; GSBTEMPLT by the routine at PREPGAME, but never used afterwards.
XHISCORE;
  DEFW 0

; Game mode indicator
;
; Holds the current game mode (0-4). Checked by the routines at EVENTS (using
; the event entry at EVENT01), GETINPUT, SCORECASH and MNLPTASKS2, and updated
; by the routine at PREPGAME.
;
; +------+--------------------------------------------------------------------+
; | Mode | Meaning                                                            |
; +------+--------------------------------------------------------------------+
; | 0    | Demo mode                                                          |
; | 1    | The game has just started                                          |
; | 2    | Sam has entered no. 15 with the key                                |
; | 3    | Sam has had the phone call about the key to no. 74 and gone to the |
; |      | top of the apartment building                                      |
; | 4    | The mob is after Sam                                               |
; +------+--------------------------------------------------------------------+
GAMEMODE;
  DEFB 0

; Lives (first aid kits)
;
; Used by the routines at CHKSHOT and INITMSGFA. A first aid kit will be
; displayed in the icon panel for every bit that is set.
LIVES;
  DEFB 0

; Door status flags
;
; Used by the routines at BYDOOR, SHUTDOORS, CHKDOOR and CANOPEN. In each flag
; byte here, bits 0-2 hold the door close delay timer (0 if the door is shut),
; and the set bit (if any) in bits 3-7 indicates the key that is required to
; unlock the door;
;
; +-----+---------------+
; | Bit | Key           |
; +-----+---------------+
; | 3   | Key to no. 74 |
; | 4   | Key to no. 31 |
; | 5   | Key to no. 27 |
; | 6   | Key to no. 15 |
; | 7   | Key to no. 19 |
; +-----+---------------+
DOORFLAGS;
  DEFB 0                  ; Shop at the far left of town
  DEFB 0                  ; Right-hand shop under the apartments next to no. 74
  DEFB 8                  ; No. 74
  DEFB 16                 ; No. 31
  DEFB 32                 ; No. 27
  DEFB 128                ; No. 19
  DEFB 0                  ; Shop under no. 17
  DEFB 0                  ; No. 17
  DEFB 0                  ; Shop under no. 15
  DEFB 64                 ; No. 15

; Input device indicator
;
; Set by the routine at JOYSTICK, and used by the routine at KEYOFFSET1. Holds
; 107 ('k') if the Kempston joystick is being used, or 0 otherwise.
KEMPSTON;
  DEFB 0

; Number of the character just moved (215-229)
;
; Used by the routine at MVCHARS.
LASTCHAR;
  DEFB 0

; Sam's status flags
;
; Used by the routine at HANDLESAM to decide how to deal with Sam.
;
; +-----+-------------------------------------------------+--------------+
; | Bit | Meaning if set                                  | Routine      |
; +-----+-------------------------------------------------+--------------+
; | 0   | Sam is being carried by a gangster or policeman | CARRIED      |
; | 1   | Sam is immobilised (after meeting Lana)         | SAMLANA      |
; | 2   | Unused                                          |              |
; | 3   | Sam is rolling or somersaulting                 | SOMERSAULT_1 |
; | 4   | Sam is on the phone                             | ONPHONE      |
; | 5   | Sam is blowing a fuse                           | ARMDOWN      |
; |     | Sam is switching a light on or off              |              |
; |     | Sam is raising or lowering a blind              |              |
; |     | Sam is throwing the hook                        |              |
; |     | Sam is picking up an object                     |              |
; | 6   | Sam is knocking on or opening a door            | SAMBYDOOR    |
; | 7   | Sam is falling from the roof of a building      | ROOFEDGE_5   |
; +-----+-------------------------------------------------+--------------+
STATUS;
  DEFB 0

; Last key pressed
;
; Set by the main loop at MAINLOOP, and checked by the routine at LEFT. Holds
; the value from the keypress offset table corresponding to the last key
; pressed.
KEYCODE;
  DEFB 0

; x-coordinate of the leftmost column of the play area on screen
;
; Checked by many routines, and modified by the routines at LSCROLL8 and
; RSCROLL8.
LEFTCOL;
  DEFB 0

; y-coordinate of the topmost row of the play area on screen
;
; Checked by many routines, and modified by the routines at USCROLL6 and
; DSCROLL6.
TOPROW;
  DEFB 0

; Play area graphic data (tiles 0-255, base page 128)
;
; Used by the routine at PRINTTILE. Tiles 184, 185, 215, 216 and 229 are
; unused; tiles 184 and 185 are blank (all 0s); tiles 215, 216 and 229 would be
; used at play area locations (83,0), (83,1) and (98,0) (above the roof of the
; hotel), but the two rows of tiles at y-coordinates 0 and 1 are never
; displayed.
  DEFB 128,128,0,128,0,0,0,128,168,0,20,128,153,153,153,153
  DEFB 153,128,0,11,184,255,176,176,191,176,255,255,0,255,5,5
  DEFB 253,5,255,165,165,191,165,255,69,69,127,69,255,69,69,125
  DEFB 69,255,176,176,191,255,0,0,255,255,29,13,253,191,255,64
  DEFB 176,191,191,191,0,255,255,255,13,13,253,253,253,13,196,255
  DEFB 196,67,227,67,84,255,84,79,207,187,255,187,255,255,255,251
  DEFB 191,191,255,253,253,255,191,191,255,127,127,127,255,125,125,125
  DEFB 243,243,207,207,0,0,0,0,0,0,0,64,64,0,68,68
  DEFB 255,31,31,0,255,0,255,224,160,0,224,254,239,0,7,16
  DEFB 240,240,68,180,69,186,170,173,0,18,0,74,0,170,255,0
  DEFB 0,0,64,64,64,0,3,13,21,85,85,87,16,24,208,80
  DEFB 80,112,0,34,0,36,0,34,0,0,0,0,255,0,255,255
  DEFB 0,68,0,204,68,253,255,196,0,0,1,240,68,68,28,97
  DEFB 135,1,0,85,255,255,248,125,127,127,127,255,255,255,68,191
  DEFB 127,0,184,7,0,85,255,128,255,255,255,160,0,255,255,255
  DEFB 255,255,255,255,0,248,3,128,204,204,34,30,240,204,34,16
  DEFB 255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255
  DEFB 255,255,255,251,184,255,191,191,191,191,255,255,255,255,253,253
  DEFB 253,253,255,191,191,191,191,255,127,127,127,127,255,125,125,125
  DEFB 125,255,191,191,191,255,255,255,255,255,253,253,253,191,255,95
  DEFB 191,191,191,191,255,255,255,255,253,253,253,253,253,253,255,255
  DEFB 255,243,243,243,255,255,255,207,207,255,255,255,255,255,255,251
  DEFB 191,191,255,253,253,255,191,191,255,127,127,127,255,125,125,125
  DEFB 243,243,207,207,7,0,3,0,187,187,0,251,251,0,255,255
  DEFB 255,31,30,255,0,255,0,224,160,224,0,0,0,255,7,16
  DEFB 80,80,255,191,253,191,255,253,0,18,0,74,0,255,255,0
  DEFB 224,0,224,127,255,254,251,239,223,127,255,255,208,152,240,240
  DEFB 240,240,0,34,0,36,0,34,0,0,0,191,255,253,255,255
  DEFB 0,68,0,102,17,255,0,208,255,255,248,15,17,17,3,24
  DEFB 112,254,0,102,17,255,224,126,126,127,223,249,255,255,17,254
  DEFB 127,0,248,7,255,102,127,128,31,255,1,224,0,0,0,0
  DEFB 31,255,128,1,0,32,3,192,230,100,34,60,240,230,28,31
  DEFB 128,128,255,128,0,0,0,128,145,0,200,128,204,204,204,204
  DEFB 204,129,1,23,113,128,176,176,176,191,0,0,255,1,5,5
  DEFB 5,253,129,177,177,177,191,65,81,81,81,127,65,85,85,85
  DEFB 125,128,191,176,191,0,255,0,255,1,253,13,253,191,64,64
  DEFB 191,191,191,176,255,255,255,0,253,253,253,253,13,253,145,145
  DEFB 145,19,19,19,102,204,102,207,79,238,238,238,255,255,255,247
  DEFB 191,191,255,253,253,129,191,191,65,127,127,127,65,125,125,125
  DEFB 243,243,207,207,0,0,0,255,0,0,255,64,64,255,68,68
  DEFB 255,31,31,255,240,255,0,224,160,224,0,0,0,0,255,208
  DEFB 80,80,34,178,37,180,68,69,114,18,228,79,0,68,255,0
  DEFB 0,224,64,192,64,1,5,13,53,85,85,87,16,80,80,80
  DEFB 80,112,46,34,46,36,46,34,0,0,0,0,0,0,0,0
  DEFB 222,132,0,153,136,248,0,200,0,0,7,192,200,136,0,198
  DEFB 12,255,255,170,136,255,192,190,190,255,159,249,232,136,136,126
  DEFB 63,0,120,3,255,172,127,128,137,255,1,116,0,0,0,0
  DEFB 32,0,128,1,0,32,7,192,153,24,34,120,240,152,0,0
  DEFB 255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255
  DEFB 255,255,255,247,113,128,191,191,191,191,0,255,255,1,253,253
  DEFB 253,253,129,191,191,191,191,65,127,127,127,127,65,125,125,125
  DEFB 125,128,191,191,191,0,255,255,255,1,253,253,253,191,95,95
  DEFB 191,191,191,191,255,255,255,255,253,253,253,253,253,253,255,255
  DEFB 255,243,243,243,255,255,255,207,207,255,255,255,255,255,255,247
  DEFB 191,191,255,253,253,129,191,191,65,127,127,127,65,125,125,125
  DEFB 243,243,207,207,7,7,3,255,187,187,255,251,251,255,255,255
  DEFB 255,31,31,128,255,0,255,224,160,0,224,251,223,0,31,16
  DEFB 240,240,255,191,253,191,255,253,114,18,228,79,0,255,255,0
  DEFB 224,224,224,255,255,253,247,239,191,255,255,255,208,112,240,240
  DEFB 240,240,46,34,46,36,46,34,0,0,0,191,0,253,0,0
  DEFB 222,132,0,51,34,226,0,226,255,255,224,62,50,34,0,49
  DEFB 195,0,0,153,34,0,128,189,191,255,159,249,34,34,34,220
  DEFB 63,0,208,3,0,144,127,128,34,127,1,220,0,255,255,255
  DEFB 223,255,255,255,0,224,7,240,179,48,34,240,112,176,0,0
  DEFB 128,128,255,255,0,0,255,133,128,192,0,0,179,179,255,51
  DEFB 51,254,2,46,227,191,176,191,176,128,255,0,0,253,5,253
  DEFB 5,1,191,169,191,169,129,127,73,127,73,65,125,77,125,77
  DEFB 65,191,176,191,191,255,0,255,255,253,13,253,253,255,64,0
  DEFB 191,191,176,191,255,255,0,255,13,253,253,13,253,1,0,136
  DEFB 136,0,131,131,0,170,170,0,207,0,119,119,255,254,254,238
  DEFB 191,128,0,253,1,191,191,129,127,127,127,65,125,125,125,65
  DEFB 0,243,0,207,0,0,0,0,0,0,64,64,64,68,68,68
  DEFB 255,31,28,255,0,128,0,224,160,0,0,0,0,255,255,48
  DEFB 80,112,136,184,141,186,170,173,22,103,36,66,0,170,255,0
  DEFB 0,64,64,64,64,3,5,21,53,85,85,95,16,80,80,80
  DEFB 80,112,104,108,98,100,106,108,0,0,255,0,0,0,0,0
  DEFB 34,228,0,204,68,196,0,196,0,0,31,1,140,68,0,12
  DEFB 63,0,0,85,68,0,128,125,127,127,159,249,68,68,68,188
  DEFB 31,0,176,1,0,96,127,128,68,127,1,187,160,0,0,0
  DEFB 184,0,128,1,0,64,7,240,204,192,35,224,112,192,0,0
  DEFB 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
  DEFB 255,254,254,238,227,191,191,191,191,128,255,255,0,253,253,253
  DEFB 253,1,191,191,191,191,129,127,127,127,127,65,125,125,125,125
  DEFB 65,191,191,191,191,255,255,255,255,253,253,253,253,255,95,191
  DEFB 191,191,191,191,255,255,255,255,253,253,253,253,253,1,0,255
  DEFB 255,0,243,243,0,255,255,0,207,0,255,255,255,254,254,238
  DEFB 191,128,0,253,1,191,191,129,127,127,127,65,125,125,125,65
  DEFB 0,243,0,207,7,3,3,187,187,187,251,251,251,255,255,255
  DEFB 255,31,31,255,128,255,0,224,160,224,0,0,0,0,255,112
  DEFB 80,112,255,191,253,191,255,253,22,103,36,66,0,255,255,0
  DEFB 224,224,224,255,255,251,247,223,191,255,255,255,208,112,240,240
  DEFB 240,240,104,108,98,100,106,108,0,0,255,191,255,253,191,253
  DEFB 34,228,0,102,17,208,0,208,127,255,192,240,99,17,0,3
  DEFB 128,0,0,204,17,0,128,252,254,255,159,249,17,17,17,252
  DEFB 31,0,240,1,0,128,127,128,17,127,1,238,224,0,0,1
  DEFB 113,255,128,1,1,64,15,252,230,64,35,192,112,224,0,0
  DEFB 128,255,255,0,0,255,0,150,255,168,255,255,230,255,0,102
  DEFB 255,4,5,92,198,176,176,128,176,255,0,0,255,5,5,1
  DEFB 5,255,163,163,129,163,255,99,99,65,99,255,101,101,65,101
  DEFB 255,191,191,191,128,255,255,255,0,253,253,253,1,0,64,0
  DEFB 128,176,191,191,0,0,255,255,253,1,13,253,253,255,255,162
  DEFB 162,227,35,35,255,51,51,207,79,255,221,221,255,2,253,220
  DEFB 191,255,255,253,255,191,129,255,127,127,65,255,125,125,65,125
  DEFB 243,243,207,207,0,0,0,0,0,68,64,64,68,68,68,68
  DEFB 255,31,255,0,255,0,255,160,160,0,224,247,63,0,255,80
  DEFB 240,240,17,177,21,176,0,5,34,0,40,0,0,17,255,0
  DEFB 0,64,64,64,64,3,5,21,117,85,87,95,16,208,80,80
  DEFB 112,112,44,0,34,0,46,0,0,0,0,0,0,0,0,0
  DEFB 36,0,0,153,136,200,0,200,0,0,62,14,24,192,0,0
  DEFB 120,0,0,170,136,0,128,190,254,255,159,249,136,136,8,124
  DEFB 15,0,96,1,0,128,127,128,136,127,1,119,116,255,255,254
  DEFB 227,255,255,255,1,64,15,252,153,128,35,128,48,128,0,0
  DEFB 255,255,255,0,255,255,0,255,255,255,255,255,255,255,0,255
  DEFB 255,4,253,220,198,191,191,128,191,255,255,255,255,253,253,1
  DEFB 253,255,191,191,129,191,255,127,127,65,127,255,125,125,65,125
  DEFB 255,191,191,191,128,255,255,255,0,253,253,253,1,0,95,255
  DEFB 128,191,191,191,0,255,255,255,253,1,253,253,253,255,255,255
  DEFB 255,243,243,243,255,255,255,207,207,255,255,255,255,2,253,220
  DEFB 191,255,255,253,255,191,129,255,127,127,65,255,125,125,65,125
  DEFB 243,243,207,207,7,3,3,187,187,68,251,251,68,255,255,68
  DEFB 255,31,68,255,255,0,255,160,224,0,224,0,0,255,255,208
  DEFB 80,112,255,191,253,191,255,253,34,0,40,0,0,255,165,0
  DEFB 224,224,224,255,255,251,247,223,127,255,255,255,208,240,240,240
  DEFB 240,240,44,0,34,0,46,0,0,0,0,191,255,253,191,253
  DEFB 36,0,0,51,34,226,0,226,0,0,1,225,134,56,0,0
  DEFB 7,0,0,51,34,0,128,63,127,127,159,249,34,34,34,216
  DEFB 15,255,192,0,0,128,127,128,34,127,1,221,221,128,0,5
  DEFB 199,249,0,0,3,128,15,254,179,0,35,0,63,128,0,0

; Play area graphic data (tiles 0-255, base page 136)
;
; Used by the routine at PRINTTILE.
  DEFB 0,85,14,12,10,7,63,248,191,1,240,1,7,7,255,255
  DEFB 15,253,1,15,255,1,0,0,0,0,0,187,187,255,0,0
  DEFB 11,216,8,24,11,216,15,255,248,255,255,255,68,0,39,255
  DEFB 0,32,128,0,11,143,252,139,216,143,248,254,136,27,143,255
  DEFB 255,255,139,143,255,224,252,31,191,251,255,255,255,255,255,143
  DEFB 255,255,255,255,251,143,219,251,248,27,255,248,15,255,255,255
  DEFB 255,128,7,255,224,247,187,187,255,224,255,187,255,255,0,128
  DEFB 15,0,0,5,15,0,128,28,31,255,252,48,0,255,190,64
  DEFB 240,208,129,16,225,1,8,24,0,32,15,0,12,143,223,119
  DEFB 123,241,128,0,0,16,255,0,24,80,243,2,3,255,255,16
  DEFB 0,68,68,68,252,68,68,0,0,128,128,0,131,255,224,0
  DEFB 231,255,116,15,248,255,143,143,248,216,251,255,255,255,15,190
  DEFB 63,128,222,59,31,248,0,255,255,128,255,255,255,255,255,0
  DEFB 241,255,252,240,0,129,252,15,239,132,143,0,0,4,124,0
  DEFB 34,128,255,255,252,123,255,63,128,124,254,96,96,190,231,255
  DEFB 116,84,86,227,255,6,44,226,234,255,0,44,0,254,84,204
  DEFB 255,102,14,12,250,4,127,248,255,3,240,3,7,7,0,0
  DEFB 15,225,1,15,255,1,0,0,0,0,0,238,238,208,15,248
  DEFB 11,216,11,216,11,216,32,0,2,255,255,145,17,0,32,63
  DEFB 0,32,143,0,23,31,254,139,216,31,252,127,139,215,31,255
  DEFB 255,255,139,31,247,240,126,15,160,7,240,0,0,0,23,135
  DEFB 255,255,255,255,247,31,111,123,251,139,48,2,32,0,255,255
  DEFB 255,192,0,0,0,251,238,239,255,224,251,239,255,255,255,128
  DEFB 31,2,0,9,8,0,32,99,223,255,253,204,0,255,221,32
  DEFB 16,208,129,16,33,3,15,24,0,32,15,0,12,63,239,142
  DEFB 247,252,192,255,255,240,3,0,24,80,243,2,3,255,255,16
  DEFB 0,16,17,17,249,61,16,0,0,129,128,0,251,255,244,0
  DEFB 231,255,102,255,255,255,199,31,252,220,119,255,7,255,15,255
  DEFB 255,207,223,27,223,251,0,128,128,128,128,128,112,15,254,0
  DEFB 224,63,248,240,1,3,196,31,207,132,143,0,0,4,244,0
  DEFB 37,128,255,255,252,110,255,63,128,110,254,255,255,254,227,255
  DEFB 230,102,22,227,255,255,36,226,245,127,128,38,0,255,102,100
  DEFB 0,170,10,255,6,7,127,248,127,7,240,3,7,7,0,0
  DEFB 15,1,1,15,255,1,0,0,0,0,0,119,119,80,8,24
  DEFB 11,216,11,216,11,216,32,0,2,255,254,136,8,0,32,3
  DEFB 128,32,136,0,46,63,255,139,216,63,254,63,139,206,63,255
  DEFB 255,255,139,63,227,248,63,7,191,254,224,0,0,0,46,131
  DEFB 254,63,227,63,238,63,56,187,251,203,48,2,32,0,239,190
  DEFB 15,224,0,0,0,255,247,119,31,224,255,247,199,255,0,128
  DEFB 31,2,0,11,11,0,32,159,239,255,251,242,0,255,235,160
  DEFB 208,208,129,16,33,2,0,31,0,48,15,15,252,127,247,117
  DEFB 239,254,64,0,0,0,3,255,248,80,243,2,3,255,255,31
  DEFB 224,136,8,136,255,188,136,0,0,129,192,0,243,255,232,0
  DEFB 199,255,234,0,0,31,227,63,254,222,46,255,14,243,8,0
  DEFB 31,232,223,139,223,251,0,128,128,128,128,144,112,15,252,1
  DEFB 224,63,248,240,1,3,196,31,143,133,143,0,0,2,110,0
  DEFB 27,0,252,0,252,127,254,63,128,106,254,128,128,118,227,255
  DEFB 170,170,158,227,255,1,56,226,234,255,128,57,24,254,170,152
  DEFB 0,153,10,12,6,2,95,248,223,15,240,3,7,7,0,0
  DEFB 15,1,1,15,255,1,0,0,0,0,0,221,221,144,11,216
  DEFB 11,216,11,216,11,216,32,0,2,254,34,34,34,0,32,0
  DEFB 128,32,139,0,92,127,223,139,216,127,255,31,139,220,127,255
  DEFB 255,255,139,127,241,252,31,131,160,0,192,0,0,0,92,129
  DEFB 255,31,241,31,220,127,155,219,251,235,48,3,32,0,247,223
  DEFB 7,240,0,0,0,251,253,221,31,224,251,253,255,255,0,128
  DEFB 31,2,1,11,11,0,48,63,247,255,247,249,0,255,227,160
  DEFB 208,208,129,16,49,6,31,28,255,240,12,12,12,255,251,117
  DEFB 223,255,96,255,255,248,3,80,24,80,3,2,3,255,255,16
  DEFB 48,32,226,34,255,254,32,0,128,129,192,0,251,255,244,0
  DEFB 231,255,249,255,255,223,241,127,223,223,92,255,28,241,11,255
  DEFB 223,251,223,203,223,251,0,64,129,0,128,160,112,15,252,1
  DEFB 224,63,248,240,1,3,196,63,143,133,143,0,0,1,255,0
  DEFB 14,0,240,0,252,125,254,63,255,121,254,255,255,222,227,255
  DEFB 185,153,54,226,255,255,51,226,245,127,128,51,16,255,153,48
  DEFB 0,85,11,12,6,254,63,248,191,31,240,3,7,7,0,0
  DEFB 15,1,1,15,255,1,0,0,0,0,0,187,187,144,11,216
  DEFB 11,216,11,216,11,216,63,255,254,68,68,68,68,0,32,0
  DEFB 128,32,139,0,184,255,239,139,216,255,255,143,139,184,255,255
  DEFB 255,255,139,223,248,254,15,193,191,255,255,128,0,0,184,128
  DEFB 255,143,248,143,184,255,203,235,251,251,63,255,63,255,251,239
  DEFB 131,248,0,0,0,255,251,187,31,224,255,251,255,255,255,128
  DEFB 31,3,2,8,11,255,240,127,251,255,239,252,128,0,0,32
  DEFB 208,208,129,16,241,4,24,28,255,240,12,12,12,255,253,141
  DEFB 191,255,32,0,0,24,3,80,24,80,3,3,2,68,15,16
  DEFB 16,68,228,68,255,252,68,0,128,129,223,224,235,255,232,0
  DEFB 231,253,117,255,255,223,248,255,239,223,184,255,56,248,139,255
  DEFB 219,251,219,235,223,251,63,192,129,254,128,192,112,15,248,3
  DEFB 192,127,248,240,3,7,196,63,143,133,143,0,0,0,34,128
  DEFB 0,0,199,255,252,123,254,63,255,125,254,0,0,190,227,213
  DEFB 245,85,86,226,127,0,44,226,234,255,128,44,12,254,85,204
  DEFB 0,204,11,4,3,3,127,248,255,63,240,7,7,7,0,0
  DEFB 15,1,1,15,255,1,0,0,255,0,0,238,238,144,11,216
  DEFB 11,216,11,216,11,216,0,0,0,17,17,17,17,0,32,0
  DEFB 128,32,139,1,113,255,247,139,217,255,127,199,139,113,255,255
  DEFB 255,255,139,223,252,127,7,224,191,255,255,255,255,255,113,128
  DEFB 127,199,252,199,113,255,235,251,251,251,255,255,31,255,125,247
  DEFB 193,252,0,0,0,251,254,239,31,224,251,255,192,7,255,128
  DEFB 63,1,2,15,11,255,240,255,253,255,223,254,128,255,255,224
  DEFB 208,208,129,16,241,5,25,28,255,240,12,14,12,255,254,255
  DEFB 127,255,160,255,240,24,3,80,24,80,3,1,2,17,7,16
  DEFB 16,16,241,17,255,255,208,0,128,131,255,224,235,255,244,0
  DEFB 231,255,236,255,255,223,253,255,247,223,113,255,113,252,203,255
  DEFB 217,251,217,251,223,251,32,64,129,2,128,128,112,15,248,7
  DEFB 192,255,248,241,3,7,196,127,143,135,143,1,128,0,37,128
  DEFB 0,0,207,215,252,110,254,63,255,108,254,0,0,254,227,245
  DEFB 236,204,22,226,127,0,38,226,255,127,128,38,68,255,204,100
  DEFB 0,170,11,4,0,2,127,248,127,127,240,7,7,7,0,0
  DEFB 15,1,1,15,255,1,0,63,0,252,0,119,119,16,11,216
  DEFB 11,216,11,216,11,216,0,0,0,136,136,136,8,0,32,0
  DEFB 128,32,139,2,227,255,251,139,218,254,63,227,139,227,255,131
  DEFB 240,124,139,222,254,63,131,240,191,255,255,255,255,254,227,128
  DEFB 63,227,254,226,227,254,251,251,123,123,255,255,15,255,62,251
  DEFB 224,254,7,255,224,255,255,119,31,224,255,255,255,255,255,128
  DEFB 63,0,5,0,11,255,240,255,254,255,191,254,64,0,0,0
  DEFB 208,208,129,16,241,13,25,31,0,0,12,14,12,255,255,126
  DEFB 255,255,176,255,240,24,243,80,24,80,3,0,2,136,3,16
  DEFB 16,136,255,248,255,255,248,0,128,131,255,224,235,251,232,0
  DEFB 231,255,234,255,255,219,254,255,251,222,227,125,227,254,235,255
  DEFB 216,251,216,251,216,11,16,96,131,4,128,128,112,15,240,7
  DEFB 128,255,248,243,7,7,196,127,143,135,143,2,64,0,127,192
  DEFB 0,0,159,167,252,127,254,63,255,106,254,0,0,118,227,255
  DEFB 234,170,158,226,127,0,57,226,254,255,128,57,152,254,170,152
  DEFB 0,179,251,4,0,254,95,248,223,255,240,7,7,0,15,255
  DEFB 15,1,1,0,0,0,3,192,255,3,192,221,0,16,11,216
  DEFB 11,216,11,216,8,24,0,0,0,34,34,34,34,248,32,0
  DEFB 128,32,139,5,199,249,253,139,221,255,31,241,139,199,255,193
  DEFB 248,62,136,28,127,31,193,248,159,255,255,255,255,253,199,128
  DEFB 31,241,255,245,199,252,251,251,59,248,255,0,0,0,31,125
  DEFB 240,127,7,255,224,251,255,221,31,224,251,255,255,255,0,255
  DEFB 255,0,5,0,11,0,0,255,255,127,127,255,64,0,0,0
  DEFB 208,208,129,16,1,9,24,31,0,0,12,14,12,255,255,189
  DEFB 255,255,144,0,0,24,243,80,24,80,3,0,2,34,1,16
  DEFB 16,32,255,250,255,255,240,127,128,131,255,224,235,255,244,254
  DEFB 231,119,115,255,255,217,253,253,253,221,199,62,199,255,251,255
  DEFB 220,123,220,123,216,11,16,32,130,4,128,0,112,15,240,15
  DEFB 129,255,248,247,7,15,196,127,143,135,143,4,32,0,63,128
  DEFB 0,0,31,255,252,125,254,63,255,111,254,127,0,222,227,213
  DEFB 115,51,246,226,127,254,51,226,255,127,128,51,48,255,179,48

; Play area graphic data (tiles 0-255, base page 144)
;
; Used by the routine at PRINTTILE.
  DEFB 127,254,255,6,204,121,255,248,32,130,15,251,223,248,31,251
  DEFB 223,255,255,0,1,128,135,143,248,31,47,128,159,255,128,192
  DEFB 31,248,255,213,68,127,252,15,243,240,252,112,192,255,240,0
  DEFB 0,0,0,243,248,14,227,11,224,208,0,0,0,0,0,15
  DEFB 255,255,255,240,192,0,0,2,63,187,187,254,255,191,224,30
  DEFB 254,124,175,215,222,127,176,23,254,59,255,130,59,192,3,255
  DEFB 230,73,255,255,230,255,86,230,255,86,44,204,255,249,255,224
  DEFB 96,15,255,143,248,143,252,126,0,11,255,0,15,143,253,143
  DEFB 128,222,255,254,255,192,0,255,7,127,255,255,255,187,224,4
  DEFB 32,4,170,179,207,187,32,5,85,88,63,80,213,68,254,70
  DEFB 47,36,124,31,68,31,85,68,68,0,127,240,0,255,255,170
  DEFB 169,255,255,170,192,255,87,170,0,31,85,170,175,243,255,255
  DEFB 0,124,63,124,62,15,124,63,31,15,227,255,255,255,255,255
  DEFB 94,170,42,169,94,170,170,89,42,169,7,143,7,192,255,192
  DEFB 126,3,247,254,255,224,255,255,255,255,255,199,149,84,85,122
  DEFB 85,85,122,149,84,154,128,255,149,85,255,3,85,85,248,0
  DEFB 123,255,127,255,100,121,175,15,255,255,248,11,216,11,216,11
  DEFB 216,32,2,128,0,128,128,143,255,31,47,128,159,255,128,223
  DEFB 223,248,255,238,170,127,254,31,249,248,248,248,192,255,240,255
  DEFB 255,255,254,243,248,14,227,11,32,208,0,0,0,0,0,0
  DEFB 0,0,0,0,191,255,251,255,63,238,238,254,254,224,31,254
  DEFB 222,110,255,150,254,127,240,22,254,59,255,131,234,63,192,0
  DEFB 242,73,255,156,242,223,22,243,136,22,38,103,195,192,0,3
  DEFB 128,7,127,31,252,31,254,63,0,23,247,1,255,199,127,199
  DEFB 223,223,224,252,255,255,255,0,4,0,0,0,31,238,224,4
  DEFB 32,4,255,243,207,255,32,2,102,96,62,96,238,170,254,18
  DEFB 47,49,57,31,16,31,102,17,17,0,224,0,0,255,254,102
  DEFB 120,128,127,102,192,127,103,102,0,31,103,102,103,243,255,255
  DEFB 31,255,255,255,255,255,0,0,0,0,129,70,128,0,0,1
  DEFB 94,166,38,97,94,166,102,81,38,97,255,255,255,255,255,192
  DEFB 0,0,0,0,0,0,128,0,0,1,98,129,134,100,101,122
  DEFB 102,101,122,134,100,138,120,1,30,102,254,3,102,103,248,0
  DEFB 123,254,255,1,153,121,255,8,0,0,24,11,216,11,216,11
  DEFB 216,32,2,192,0,128,128,140,0,159,47,128,159,255,128,223
  DEFB 223,248,255,213,17,127,255,63,252,252,240,248,192,255,240,255
  DEFB 255,192,14,227,248,14,227,11,48,208,9,198,66,103,128,0
  DEFB 3,255,192,0,162,34,42,35,63,119,119,254,254,96,127,126
  DEFB 142,106,127,23,254,127,112,23,254,59,255,130,42,0,63,224
  DEFB 234,73,255,255,234,255,158,234,255,158,57,158,28,0,3,252
  DEFB 0,3,63,63,254,63,255,31,2,174,227,0,255,227,63,227
  DEFB 232,223,224,248,195,255,255,240,7,255,243,255,255,255,224,4
  DEFB 32,4,0,0,0,0,32,0,170,168,58,160,213,17,254,138
  DEFB 47,40,152,31,136,31,170,136,136,0,255,255,255,191,255,85
  DEFB 88,255,191,85,192,127,171,86,0,31,171,85,85,243,255,255
  DEFB 63,255,255,255,255,255,255,255,255,255,129,94,149,85,0,1
  DEFB 94,149,21,81,94,149,85,67,21,81,255,255,255,255,255,192
  DEFB 255,255,255,255,255,255,128,0,170,169,122,129,138,168,169,122
  DEFB 170,169,122,138,168,194,255,255,26,170,254,3,170,168,248,0
  DEFB 121,255,127,255,51,121,239,11,255,255,216,11,216,11,216,11
  DEFB 216,32,2,224,0,128,128,183,255,31,47,255,159,128,0,223
  DEFB 223,253,255,187,170,127,255,127,254,126,225,252,192,255,240,255
  DEFB 255,127,254,227,255,254,227,11,48,208,9,41,66,148,16,0
  DEFB 126,0,126,0,162,34,42,35,63,221,221,254,254,224,254,254
  DEFB 222,121,222,21,59,255,208,21,254,59,255,130,42,0,0,31
  DEFB 226,73,127,128,226,131,54,226,235,54,51,48,96,0,252,0
  DEFB 0,1,31,127,255,127,255,143,0,28,241,0,127,241,31,247
  DEFB 251,223,224,240,255,128,0,255,4,255,243,255,255,255,160,4
  DEFB 160,15,255,255,255,255,240,0,25,152,57,128,187,170,126,34
  DEFB 63,34,42,31,32,31,153,34,34,0,0,0,0,159,255,153
  DEFB 176,255,159,153,128,127,155,154,0,31,153,153,153,128,127,255
  DEFB 31,255,255,255,255,255,0,0,0,0,129,94,153,153,25,153
  DEFB 94,153,25,153,94,255,255,71,25,153,255,255,255,255,248,0
  DEFB 0,0,0,0,0,0,153,152,153,153,122,129,153,152,153,122
  DEFB 255,255,122,153,152,226,0,255,13,154,254,1,153,154,248,0
  DEFB 121,254,255,0,204,89,255,251,255,255,223,251,223,251,223,251
  DEFB 223,63,254,240,0,128,128,207,252,31,47,248,31,255,255,223
  DEFB 223,255,255,213,68,124,63,126,126,63,193,252,192,248,0,255
  DEFB 252,255,254,227,255,254,227,11,240,208,9,41,66,135,16,7
  DEFB 193,255,131,224,162,34,46,35,63,187,187,254,222,161,253,254
  DEFB 254,125,188,23,59,255,176,23,254,59,255,130,42,0,0,0
  DEFB 230,73,255,255,230,255,86,230,255,86,44,193,128,0,0,0
  DEFB 0,0,143,255,255,255,127,199,7,248,248,0,63,248,15,255
  DEFB 251,219,255,224,255,255,224,0,4,255,243,255,207,255,32,4
  DEFB 32,8,0,0,15,255,240,0,21,80,53,0,213,68,30,70
  DEFB 47,36,79,255,64,31,85,68,68,0,0,0,0,87,255,170
  DEFB 160,127,95,171,128,63,85,170,0,63,85,170,170,128,127,255
  DEFB 0,127,252,124,62,15,0,0,0,0,129,94,170,170,42,169
  DEFB 94,170,42,169,94,255,255,71,42,169,31,255,199,192,248,0
  DEFB 0,0,0,0,0,0,149,84,85,85,122,129,149,84,85,122
  DEFB 255,255,122,149,84,226,0,254,5,84,252,1,213,84,252,0
  DEFB 121,255,127,0,102,73,239,139,255,255,216,139,216,139,216,139
  DEFB 216,0,0,248,0,128,128,223,215,31,47,248,31,255,255,192
  DEFB 31,255,255,238,170,124,31,124,62,31,131,254,192,248,0,255
  DEFB 253,253,126,227,255,254,227,11,240,208,9,201,66,148,16,28
  DEFB 31,255,248,56,162,34,46,35,63,238,238,254,142,227,251,254
  DEFB 254,108,248,22,59,255,240,22,254,59,255,130,42,0,0,0
  DEFB 242,73,255,216,243,128,22,243,249,22,39,6,0,0,0,0
  DEFB 0,0,199,255,127,254,63,227,7,241,252,0,0,252,31,255
  DEFB 251,217,255,192,192,255,255,192,4,255,243,255,207,255,32,4
  DEFB 32,8,0,0,15,255,240,0,12,200,44,128,238,170,14,18
  DEFB 35,49,16,31,0,15,204,17,17,0,0,0,0,207,254,51
  DEFB 112,127,207,51,0,63,205,54,0,63,205,51,51,128,96,0
  DEFB 0,124,126,126,126,15,0,0,0,0,129,94,179,51,51,49
  DEFB 94,179,51,49,94,255,255,79,0,1,63,7,231,254,255,240
  DEFB 0,0,0,0,0,0,140,204,204,205,122,129,140,204,205,122
  DEFB 255,255,122,128,0,242,0,254,14,193,252,0,204,193,252,0
  DEFB 121,255,255,0,153,73,255,139,255,255,216,139,216,139,216,139
  DEFB 216,0,0,252,0,128,128,159,163,159,47,248,31,255,255,255
  DEFB 255,255,255,213,17,124,31,124,62,15,3,254,192,248,0,255
  DEFB 249,250,62,227,255,254,227,8,240,16,9,6,122,103,144,51
  DEFB 191,140,61,204,162,34,46,35,59,118,0,126,222,103,247,254
  DEFB 222,106,112,23,59,255,112,23,130,59,255,130,42,0,0,0
  DEFB 234,73,255,255,234,255,158,234,255,254,60,24,0,0,0,0
  DEFB 0,0,227,253,62,255,31,241,2,163,254,0,0,254,191,255
  DEFB 251,216,255,128,255,0,0,255,4,255,243,255,207,255,32,4
  DEFB 32,15,255,255,255,255,240,0,2,175,234,128,213,25,2,138
  DEFB 33,40,136,31,128,7,170,137,255,255,0,0,0,171,255,85
  DEFB 64,127,175,87,0,63,171,84,0,127,171,85,85,128,127,255
  DEFB 255,255,255,255,255,255,0,0,0,0,129,94,149,85,21,81
  DEFB 94,149,21,81,92,255,255,223,0,1,255,255,255,255,255,255
  DEFB 0,0,0,0,0,0,138,168,170,169,122,129,138,168,169,122
  DEFB 255,255,58,128,0,251,0,254,2,168,252,0,234,168,254,0
  DEFB 121,255,255,0,51,73,175,139,255,255,216,139,216,139,216,136
  DEFB 24,0,0,254,0,0,128,63,255,159,47,248,31,255,255,240
  DEFB 127,187,170,187,170,124,31,124,62,15,7,223,192,255,192,255
  DEFB 243,255,254,227,255,254,227,15,0,240,8,0,0,0,16,231
  DEFB 191,119,189,231,162,34,46,35,59,208,0,62,254,239,231,254
  DEFB 142,123,208,21,59,255,208,21,254,42,15,130,42,0,0,0
  DEFB 226,73,255,132,226,156,54,226,255,6,32,48,0,0,0,0
  DEFB 0,0,241,248,29,255,143,248,0,7,255,0,0,255,255,255
  DEFB 123,221,255,0,255,255,0,0,4,255,243,255,207,255,32,4
  DEFB 32,15,255,255,255,255,240,0,3,51,51,0,255,255,2,34
  DEFB 32,34,32,31,0,7,63,254,0,0,255,255,255,51,255,204
  DEFB 192,255,55,206,0,63,51,204,1,255,51,255,254,128,127,255
  DEFB 0,124,63,63,248,15,255,255,255,255,129,94,140,204,12,201
  DEFB 94,140,12,201,88,255,255,255,255,255,126,3,247,254,255,240
  DEFB 255,255,255,255,255,255,147,48,51,49,122,129,147,48,49,122
  DEFB 255,255,26,255,255,255,255,255,3,34,252,0,115,34,255,128

; Play area graphic data (tiles 0-255, base page 152)
;
; Used by the routine at PRINTTILE. Tiles 209 and 210 are unused; tile 209
; would be used at play area locations (9,40) and (193,40), and tile 210 would
; be used at play area locations (14,40) and (198,40), but the row of tiles at
; y-coordinate 40 is never displayed.
  DEFB 85,68,255,207,245,85,227,255,254,222,238,255,238,2,227,128
  DEFB 110,10,9,4,64,0,89,4,10,8,65,68,2,65,2,128
  DEFB 8,65,0,65,213,191,255,253,192,255,128,0,0,0,34,221
  DEFB 221,221,213,31,255,255,240,255,255,31,255,251,2,95,254,3
  DEFB 223,15,15,255,254,187,223,248,255,255,255,255,169,63,13,170
  DEFB 127,253,132,248,13,191,137,240,13,176,9,255,253,221,192,1
  DEFB 221,221,192,1,255,255,228,66,240,0,252,126,246,66,255,255
  DEFB 255,255,183,0,77,180,36,45,180,36,36,45,45,180,36,45
  DEFB 176,23,130,42,1,176,55,134,42,0,14,64,31,248,162,34
  DEFB 46,35,162,34,34,42,34,35,59,187,178,42,34,35,15,248
  DEFB 3,255,254,128,255,248,56,0,3,159,224,129,42,255,254,72
  DEFB 56,84,0,0,64,255,1,1,16,0,0,0,255,128,224,0
  DEFB 12,255,208,7,255,0,128,112,0,4,240,0,0,84,240,255
  DEFB 240,16,240,85,85,85,85,80,0,255,255,255,255,0,0,252
  DEFB 0,0,68,187,2,0,28,0,127,68,184,28,64,36,4,3
  DEFB 255,68,68,2,36,64,31,64,192,254,228,224,12,0,2,68
  DEFB 102,81,255,207,230,103,227,255,254,206,238,255,238,2,227,0
  DEFB 46,10,9,7,255,255,253,4,10,8,65,255,255,65,1,255
  DEFB 254,65,255,193,213,191,255,253,193,252,128,15,255,248,34,221
  DEFB 221,245,213,24,0,0,80,255,239,31,255,239,2,95,255,0
  DEFB 31,10,10,15,255,239,218,8,191,255,255,253,169,63,13,186
  DEFB 124,13,137,248,13,191,0,255,253,176,9,192,13,221,192,1
  DEFB 221,221,255,255,255,255,228,66,255,254,252,66,246,66,191,255
  DEFB 255,252,182,0,77,180,36,45,180,36,36,45,45,180,36,45
  DEFB 240,22,130,46,1,241,254,130,42,0,0,64,255,128,162,34
  DEFB 42,35,162,34,34,42,34,35,59,187,178,43,255,255,7,253
  DEFB 1,255,252,129,128,124,76,0,6,208,48,129,43,191,252,240
  DEFB 30,103,3,0,128,63,1,255,16,0,0,0,231,128,240,0
  DEFB 25,255,248,0,16,3,255,240,0,102,240,0,6,102,112,255
  DEFB 240,16,224,102,102,6,102,32,0,128,0,0,1,0,0,227
  DEFB 240,0,17,224,4,0,3,240,0,0,0,102,128,48,17,1
  DEFB 255,17,17,2,33,0,15,0,0,254,240,224,8,0,2,16
  DEFB 106,136,255,207,170,170,227,255,254,238,238,255,238,2,226,0
  DEFB 110,10,9,4,136,0,5,4,10,8,127,136,1,127,0,255
  DEFB 255,255,128,127,213,128,0,1,195,240,128,8,8,8,34,221
  DEFB 221,213,213,27,255,255,80,254,119,31,255,119,2,95,254,0
  DEFB 31,10,10,15,254,119,218,8,191,255,255,253,169,63,253,132
  DEFB 252,13,137,255,253,176,9,224,13,176,9,255,253,221,192,1
  DEFB 221,221,221,221,192,0,228,66,240,2,252,66,246,66,186,171
  DEFB 234,173,188,0,45,180,36,45,180,36,36,45,45,180,36,45
  DEFB 112,23,130,42,1,126,7,130,58,0,0,64,224,0,162,34
  DEFB 42,35,162,34,34,42,34,35,0,0,0,0,0,0,3,255
  DEFB 0,255,248,129,0,62,134,0,12,112,56,129,42,255,240,225
  DEFB 87,171,4,0,128,0,1,0,144,0,0,0,171,128,248,0
  DEFB 49,255,252,0,16,2,0,240,0,170,255,255,10,170,240,255
  DEFB 240,16,192,42,170,10,170,160,0,255,255,255,255,0,0,152
  DEFB 15,255,254,0,42,0,192,15,128,0,7,175,0,40,0,1
  DEFB 255,136,136,2,40,128,7,0,0,252,120,192,12,0,254,0
  DEFB 89,162,254,1,153,153,227,255,254,238,238,255,238,3,226,0
  DEFB 238,10,8,130,34,0,4,130,10,8,65,34,1,65,0,0
  DEFB 0,0,0,0,213,255,255,255,199,192,128,20,20,20,65,255
  DEFB 255,213,213,27,255,255,80,254,223,31,254,221,2,95,254,0
  DEFB 31,10,10,15,254,221,218,8,191,255,159,253,170,127,253,132
  DEFB 252,13,137,240,13,176,9,255,253,176,9,192,13,221,192,1
  DEFB 255,255,221,221,252,126,244,66,240,0,252,66,254,126,185,157
  DEFB 185,157,180,0,45,180,36,45,180,36,36,13,45,180,36,45
  DEFB 223,21,130,42,1,208,7,2,43,0,0,192,0,0,162,34
  DEFB 42,35,162,34,34,42,34,35,0,0,0,0,0,0,1,255
  DEFB 0,127,240,129,135,255,6,0,24,48,60,255,43,191,224,10
  DEFB 171,153,8,0,128,0,1,0,80,0,0,0,155,128,255,255
  DEFB 227,255,255,0,63,2,0,240,1,153,224,0,153,155,240,255
  DEFB 224,31,128,25,152,0,0,0,0,255,255,255,255,0,7,135
  DEFB 192,0,0,1,153,224,32,0,127,34,221,156,0,32,2,0
  DEFB 255,34,32,2,34,0,7,0,0,252,114,192,6,0,0,0
  DEFB 85,68,254,1,85,85,226,15,254,238,238,248,238,1,226,1
  DEFB 238,10,8,130,68,0,4,130,10,8,65,68,1,65,0,0
  DEFB 0,0,0,0,213,128,0,0,207,0,128,20,20,20,65,192
  DEFB 1,213,213,27,192,3,80,254,191,31,254,187,2,95,254,0
  DEFB 31,10,10,15,254,187,218,8,191,192,159,13,170,126,13,132
  DEFB 252,13,137,255,253,176,9,224,13,176,9,192,13,221,192,1
  DEFB 192,1,221,221,228,66,244,66,240,14,252,66,254,0,181,117
  DEFB 93,13,183,255,237,180,36,45,183,231,230,237,237,183,231,237
  DEFB 177,23,130,42,1,177,240,3,234,128,0,192,0,0,162,34
  DEFB 42,35,162,34,34,46,34,35,0,0,0,0,0,0,0,255
  DEFB 0,63,224,129,127,255,11,0,48,16,62,1,42,255,158,85
  DEFB 255,85,8,1,0,0,1,0,80,0,0,255,215,128,224,0
  DEFB 55,255,192,0,32,7,255,240,1,85,255,255,85,87,0,255
  DEFB 192,0,0,21,84,0,0,0,0,0,0,0,1,224,6,96
  DEFB 63,128,0,59,84,96,28,0,0,68,187,240,0,32,4,0
  DEFB 127,68,64,2,36,0,3,0,0,248,52,192,4,0,0,0
  DEFB 108,145,6,1,204,204,227,241,254,238,238,240,238,0,226,3
  DEFB 206,10,8,131,255,255,254,130,10,8,65,255,255,193,0,0
  DEFB 0,0,0,0,213,128,0,0,220,0,128,20,20,20,65,255
  DEFB 255,213,213,27,224,3,80,255,255,31,255,239,2,95,255,0
  DEFB 31,10,10,15,255,239,218,8,191,191,63,13,170,126,13,132
  DEFB 255,253,137,240,13,176,9,224,13,176,9,192,13,221,255,255
  DEFB 255,255,221,221,228,66,244,66,255,238,244,66,255,255,188,204
  DEFB 202,13,176,0,13,180,36,45,176,0,0,237,13,176,0,13
  DEFB 241,22,130,42,1,254,0,0,10,64,1,128,0,0,162,34
  DEFB 42,35,162,34,34,46,34,35,0,0,0,0,0,0,0,127
  DEFB 0,0,0,129,1,63,149,0,96,8,63,1,43,190,1,255
  DEFB 128,205,16,1,0,0,1,0,48,0,0,129,207,128,192,0
  DEFB 31,252,0,0,32,28,0,240,0,207,0,0,204,255,0,255
  DEFB 0,0,0,12,200,0,0,0,5,240,0,0,6,160,5,24
  DEFB 0,127,17,238,200,160,3,224,0,17,239,192,0,32,16,0
  DEFB 127,17,0,2,48,0,1,0,0,248,48,128,3,128,0,0
  DEFB 42,136,254,1,170,170,163,254,126,238,238,224,110,0,162,7
  DEFB 142,10,8,130,136,0,2,130,250,8,65,136,0,65,0,0
  DEFB 0,0,0,0,212,128,0,0,240,0,255,20,20,20,73,192
  DEFB 127,213,213,27,255,255,80,254,119,31,254,119,2,95,254,0
  DEFB 31,10,9,4,255,247,217,4,191,169,63,253,170,126,13,132
  DEFB 255,253,137,240,13,176,9,224,13,176,9,255,253,221,192,0
  DEFB 192,1,221,221,228,66,252,126,248,14,244,66,255,247,186,170
  DEFB 145,13,176,0,13,180,36,45,176,0,0,237,13,176,0,13
  DEFB 115,247,194,42,255,128,0,0,10,64,7,0,0,0,162,34
  DEFB 42,35,187,187,187,175,187,187,0,0,0,0,0,0,15,255
  DEFB 0,0,0,129,42,255,235,255,224,23,255,0,128,248,0,0
  DEFB 0,171,32,1,0,0,1,0,31,128,0,255,171,192,192,0
  DEFB 0,224,0,0,255,60,0,240,10,171,0,0,171,255,0,254
  DEFB 0,0,0,2,160,255,255,255,4,15,255,255,247,160,252,199
  DEFB 192,0,136,119,160,63,0,31,255,255,248,0,0,32,136,0
  DEFB 63,255,255,254,63,255,255,0,0,240,24,128,0,240,0,0
  DEFB 51,34,254,1,51,51,99,255,190,238,238,192,110,0,34,15
  DEFB 14,10,8,127,34,0,2,127,14,8,65,34,0,65,0,0
  DEFB 0,0,0,0,208,128,0,0,0,0,0,34,34,34,54,199
  DEFB 127,213,213,24,0,0,80,254,253,223,254,221,2,95,254,0
  DEFB 31,10,9,4,32,63,217,4,191,169,63,253,170,127,253,132
  DEFB 248,13,137,240,13,176,9,224,13,176,15,0,13,221,0,0
  DEFB 192,1,221,221,228,66,240,0,248,0,244,66,32,63,179,48
  DEFB 0,141,183,231,237,180,36,45,183,231,231,13,237,176,0,13
  DEFB 220,53,186,42,0,0,0,0,10,64,126,0,0,0,162,34
  DEFB 42,35,187,187,162,46,34,35,0,0,0,0,0,0,7,255
  DEFB 0,0,0,129,43,191,247,196,224,43,255,0,127,128,0,0
  DEFB 0,51,32,1,192,0,255,0,0,192,7,213,255,224,128,0
  DEFB 0,0,0,0,128,127,255,240,51,63,0,0,127,255,0,252
  DEFB 0,0,0,1,32,0,0,0,4,0,0,34,221,96,4,32
  DEFB 63,128,34,221,3,32,0,0,0,0,0,0,0,34,32,0
  DEFB 31,32,0,2,32,0,0,0,0,240,26,128,0,31,0,0

; Play area graphic data (tiles 0-20, base page 160, byte 1/8)
;
; Used by the routine at PRINTTILE.
  DEFB 1,80,16,8,255,248,4,85,85,71,128,0,225,198,56,128
  DEFB 3,129,255,129,192

; Mask value 1/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
MASKBITS;
  DEFB 128                ; Bit 7 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character moves in a certain direction from one of the
; following locations;
;
; +-----------------------------------------------+-----------+---------------+
; | Location(s)                                   | Direction | Descriptor(s) |
; +-----------------------------------------------+-----------+---------------+
; | Inside no. 74, just to the left of the front  | Left      | LOCDESCS39    |
; | door on the second and third floors           |           |               |
; | Between the stairwell and the first window to | Left      | LOCDESCS190   |
; | the left of the stairwell on each floor of    |           |               |
; | the apartment building next to no. 19         |           |               |
; | Between the stairwell and the first window to | Left      | LOCDESCS7     |
; | the left of the stairwell on the second,      |           |               |
; | third and top floors of the apartment         |           |               |
; | building next to no. 74                       |           |               |
; | Between the second and third windows from the |           |               |
; | left on the second, third and top floors of   |           |               |
; | no. 17                                        |           |               |
; | Between the second and third windows from the |           |               |
; | left on the second, third and top floors of   |           |               |
; | no. 15                                        |           |               |
; | Between the stairwell and the first window to | Right     | LOCDESCS14    |
; | the right of the stairwell on each floor of   |           |               |
; | the apartment building next to no. 19         |           |               |
; | Between the stairwell and the first window to |           |               |
; | the right of the stairwell on the second,     |           |               |
; | third and top floors of the apartment         |           |               |
; | building next to no. 74                       |           |               |
; | The right end of the catwalk                  |           |               |
; +-----------------------------------------------+-----------+---------------+
;
; However, the routine at MOVELEFT_7 does nothing special, which means that the
; location descriptors that invoke it (see the table above) are redundant.
;
; The other special location handler routine addresses can be found at
; SLHANDLER2, SLHANDLER3, SLHANDLER4, SLHANDLER5, SLHANDLER6 and SLHANDLER7.
SLHANDLER1;
  DEFW MOVELEFT_7

; Unused
  DEFB 0

; Direction indicators for a character facing left and going left
;
; Used by the routine at MOVELEFT. This list indicates, in descending order of
; preference, the directions in which a character who is facing left and moving
; left may go.
DIRINDLL;
  DEFB 128                ; Bit 7 set; left
  DEFB 32                 ; Bit 5 set; up/left
  DEFB 8                  ; Bit 3 set; down/left

; T values (6|y)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 0, 6, 12, 18, 24, 30 and 36; in
; practice, these T values are used only by the tiles at (138,18) and (140,18).
Z3VALUES0A;
  DEFB 1,1

; Play area tile back buffer byte 1/8
;
; Used by the routines at COPYTILE and GETTILE.
BACKBUF;
  DEFB 0

; T values (6|y)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 0, 6, 12, 18, 24, 30 and 36; in
; practice, these T values are used only by tiles at y-coordinates 18, 24, 30
; and 36.
  DEFB 3
  DEFB 68,3,3,68,3,19,19,19,19,80,80,80,80,80,76,76
  DEFB 64,64,15,15,12,12,12,12,8,0,0,64,76,15,15,15
  DEFB 15,76,64,76,64,64,76,72,64,224,216,0,12,0,0,0
  DEFB 76,3,3,3,3,3,3,71,76,3,3,3,11,3,15,15
  DEFB 3,3,3,3,76,76,76,76,76,76,0,12,12,76,76,68
  DEFB 77,77,77,77,78,78,76,76,77,77,13,13,13,13,64,64
  DEFB 64,76,78,78,76,64,64,64,76,76,76,76,76,76,76,76
  DEFB 1,13,15,15,15,15,15,15,64,76,64,5,1,9,1,64
  DEFB 64,72,72,72,72,72,72,72,74,74,74,74,74,74,74,74
  DEFB 74,74,74,74,72,72,72,72,72,72,72,72,73,65,0,3
  DEFB 7,11,7,8,8,72,75,75,75,75,75,75,72,68,68,68
  DEFB 68,72,68,68,68,68,68,72,68,68,72,68,72,64,9,0
  DEFB 9,8,11,0,4,4,5,5,0,8,4,68,68,68,64,64
  DEFB 68,68,64,64,68,68,1,193,1,253,1,68,64,11,11,11

; Play area graphic data (tiles 0-20, base page 160, byte 2/8)
;
; Used by the routine at PRINTTILE.
  DEFB 1,80,16,8,0,24,7,102,102,248,31,255,14,24,192,127
  DEFB 28,194,136,67,56

; Mask value 2/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 64                 ; Bit 6 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character moves right from the top-right edge of the roof of
; the apartment building next to no. 74 or the apartment building next to no.
; 19 (see LOCDESCS23), or moves left or right from the top-left edge of the
; roof of no. 17 (see LOCDESCS223).
;
; The other special location handler routine addresses can be found at
; SLHANDLER1, SLHANDLER3, SLHANDLER4, SLHANDLER5, SLHANDLER6 and SLHANDLER7.
SLHANDLER2;
  DEFW ROOFEDGE

; Unused
  DEFB 0

; Direction indicators for a character facing right and going right
;
; Used by the routine at MOVERIGHT. This list indicates, in descending order of
; preference, the directions in which a character who is facing right and
; moving right may go.
DIRINDRR;
  DEFB 64                 ; Bit 6 set; right
  DEFB 16                 ; Bit 4 set; up/right
  DEFB 4                  ; Bit 2 set; down/right

; T' values (6|y)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 0, 6, 12, 18, 24, 30 and 36; in practice, these
; T' values are used only by the tiles at (138,18) and (140,18).
  DEFB 128,128

; Play area tile back buffer byte 2/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T' values (6|y)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 0, 6, 12, 18, 24, 30 and 36; in practice, these
; T' values are used only by tiles at y-coordinates 18, 24, 30 and 36.
  DEFB 201
  DEFB 130,201,201,130,201,11,10,9,8,7,3,2,1,0,255,254
  DEFB 210,194,250,249,240,239,238,237,159,196,196,194,221,220,219,218
  DEFB 217,216,194,212,211,211,211,20,194,217,55,238,196,198,198,198
  DEFB 195,194,194,194,194,194,194,131,182,194,194,194,131,128,159,158
  DEFB 194,194,194,231,145,143,144,143,143,142,194,131,130,129,128,18
  DEFB 113,112,111,110,53,52,44,43,93,93,75,74,73,72,194,194
  DEFB 194,54,53,52,51,194,194,194,45,44,44,44,43,39,38,37
  DEFB 105,36,23,22,21,20,19,18,231,17,194,234,128,54,128,196
  DEFB 196,169,169,169,169,169,169,169,223,222,221,220,219,218,197,196
  DEFB 195,194,193,192,169,169,169,169,169,169,168,167,166,211,128,129
  DEFB 7,26,234,36,35,142,141,140,139,139,138,137,136,100,99,99
  DEFB 99,128,192,180,191,190,184,115,84,182,114,58,113,231,99,128
  DEFB 98,97,96,195,251,175,167,228,128,72,234,27,27,31,55,55
  DEFB 30,31,55,55,30,129,128,122,128,93,128,32,231,50,49,48

; Play area graphic data (tiles 0-20, base page 160, byte 3/8)
;
; Used by the routine at PRINTTILE.
  DEFB 0,208,31,248,255,252,4,170,171,129,224,0,48,99,0,255
  DEFB 113,61,17,188,142

; Mask value 3/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 32                 ; Bit 5 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character moves left from the top-left edge of the roof of the
; apartment building next to no. 19, or the left edge of the fire escape on the
; second, third or top floor of that building (see LOCDESCS175).
;
; The other special location handler routine addresses can be found at
; SLHANDLER1, SLHANDLER2, SLHANDLER4, SLHANDLER5, SLHANDLER6 and SLHANDLER7.
SLHANDLER3;
  DEFW ROOFEDGE

; Direction indicators for a character facing left and going up
;
; Used by the routine at MOVEUP. This list indicates, in descending order of
; preference, the directions in which a character who is facing left and moving
; up may go.
DIRINDLU;
  DEFB 32                 ; Bit 5 set; up/left
  DEFB 16                 ; Bit 4 set; up/right
  DEFB 128                ; Bit 7 set; left
  DEFB 8                  ; Bit 3 set; down/left

; T values (6|y-1)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 1, 7, 13, 19, 25, 31 and 37; in
; practice, these T values are used only by the tiles at (138,19) and (140,19).
  DEFB 1,1

; Play area tile back buffer byte 3/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T values (6|y-1)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 1, 7, 13, 19, 25, 31 and 37; in
; practice, these T values are used only by tiles at y-coordinates 19, 25, 31
; and 37.
  DEFB 19
  DEFB 19,3,19,19,19,3,3,19,19,19,19,19,19,19,19,19
  DEFB 19,76,15,15,12,8,12,12,12,12,12,76,15,15,15,15
  DEFB 15,15,76,76,76,76,72,72,72,76,216,0,12,12,0,0
  DEFB 64,3,3,3,3,3,3,79,15,15,3,3,3,15,15,15
  DEFB 3,3,3,3,76,76,76,76,76,76,12,12,12,76,76,76
  DEFB 77,77,77,77,77,77,76,76,77,77,13,13,13,1,64,64
  DEFB 64,68,13,13,64,64,64,64,76,76,76,76,76,72,72,76
  DEFB 13,13,15,15,15,15,15,15,64,76,64,13,13,13,1,72
  DEFB 72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72
  DEFB 72,72,72,72,72,72,72,72,72,72,72,72,72,72,0,3
  DEFB 7,11,7,8,8,68,67,67,67,67,67,67,72,68,0,0
  DEFB 68,68,72,129,129,68,72,72,72,68,72,72,64,64,9,1
  DEFB 1,8,11,0,4,4,5,5,0,8,8,72,72,68,133,133
  DEFB 68,68,129,129,68,68,1,193,1,193,1,68,64,72,72,11

; Play area graphic data (tiles 0-20, base page 160, byte 4/8)
;
; Used by the routine at PRINTTILE.
  DEFB 0,48,16,8,0,12,4,153,156,62,7,255,195,140,0,0
  DEFB 196,68,68,34,35

; Mask value 4/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 16                 ; Bit 4 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character moves left from the top-left edge of the roof of the
; police station (see LOCDESCS124).
;
; The other special location handler routine addresses can be found at
; SLHANDLER1, SLHANDLER2, SLHANDLER3, SLHANDLER5, SLHANDLER6 and SLHANDLER7.
SLHANDLER4;
  DEFW ROOFEDGE

; Direction indicators for a character facing right and going up
;
; Used by the routine at MOVEUP. This list indicates, in descending order of
; preference, the directions in which a character who is facing right and
; moving up may go.
DIRINDRU;
  DEFB 16                 ; Bit 4 set; up/right
  DEFB 32                 ; Bit 5 set; up/left
  DEFB 64                 ; Bit 6 set; right
  DEFB 4                  ; Bit 2 set; down/right

; T' values (6|y-1)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 1, 7, 13, 19, 25, 31 and 37; in practice, these
; T' values are used only by the tiles at (138,19) and (140,19).
  DEFB 158,128

; Play area tile back buffer byte 4/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T' values (6|y-1)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 1, 7, 13, 19, 25, 31 and 37; in practice, these
; T' values are used only by tiles at y-coordinates 19, 25, 31 and 37.
  DEFB 20
  DEFB 19,212,18,17,16,194,194,14,13,12,6,5,4,4,4,4
  DEFB 4,253,252,251,246,169,245,244,243,242,241,229,228,227,226,225
  DEFB 224,223,222,215,214,213,169,169,169,199,184,141,198,197,194,194
  DEFB 194,194,194,194,194,194,194,184,183,178,194,194,194,162,161,160
  DEFB 194,194,194,231,151,150,149,148,147,146,137,136,135,134,133,132
  DEFB 116,115,115,114,101,100,46,46,95,94,78,77,76,96,194,194
  DEFB 194,129,56,55,129,194,194,194,46,46,46,46,46,169,169,42
  DEFB 41,40,29,28,21,27,26,25,231,24,194,8,7,6,128,246
  DEFB 201,172,172,172,172,172,172,172,229,228,227,226,225,224,201,171
  DEFB 200,199,198,172,172,172,172,172,172,172,172,172,171,170,128,129
  DEFB 7,26,234,157,156,49,128,115,128,128,113,128,143,105,128,128
  DEFB 104,195,129,3,0,87,119,118,117,186,116,113,194,231,101,128
  DEFB 128,97,100,195,251,237,229,228,230,76,75,74,73,33,3,0
  DEFB 32,33,3,0,32,129,128,122,158,93,128,32,231,53,52,51

; Play area graphic data (tiles 0-20, base page 160, byte 5/8)
;
; Used by the routine at PRINTTILE.
  DEFB 0,8,16,4,0,15,252,85,113,192,248,0,252,48,0,0
  DEFB 34,34,34,68,68

; Mask value 5/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 8                  ; Bit 3 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character moves right from the top-right edge of the roof of
; no. 31 (see LOCDESCS118).
;
; The other special location handler routine addresses can be found at
; SLHANDLER1, SLHANDLER2, SLHANDLER3, SLHANDLER4, SLHANDLER6 and SLHANDLER7.
SLHANDLER5;
  DEFW ROOFEDGE

; Direction indicators for a character facing left and going down
;
; Used by the routine at MOVEUP. This list indicates, in descending order of
; preference, the directions in which a character who is facing left and moving
; down may go.
DIRINDLD;
  DEFB 8                  ; Bit 3 set; down/left
  DEFB 4                  ; Bit 2 set; down/right
  DEFB 128                ; Bit 7 set; left
  DEFB 32                 ; Bit 5 set; up/left

; T values (6|y-2)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 2, 8, 14, 20, 26, 32 and 38; in
; practice, these T values are used only by the tiles at (138,20) and (140,20).
  DEFB 1,1

; Play area tile back buffer byte 5/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T values (6|y-2)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 2, 8, 14, 20, 26, 32 and 38; in
; practice, these T values are used only by tiles at y-coordinates 20, 26, 32
; and 38.
  DEFB 3
  DEFB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,15,11,3,15,15,15,15,15,15
  DEFB 15,15,15,3,3,3,3,3,3,68,220,12,12,12,12,12
  DEFB 0,15,12,15,15,3,15,3,3,15,15,3,15,13,15,15
  DEFB 15,15,15,15,15,15,15,15,15,15,12,12,0,0,0,0
  DEFB 77,77,77,77,77,77,78,78,3,3,13,13,13,1,64,68
  DEFB 64,68,13,13,76,64,68,64,129,129,129,14,14,3,3,3
  DEFB 3,3,15,7,7,15,15,15,15,15,64,14,2,9,5,72
  DEFB 64,65,65,1,10,10,9,72,11,9,9,9,75,75,75,75
  DEFB 9,9,9,11,72,11,9,10,10,9,73,69,73,73,0,3
  DEFB 7,11,11,3,3,72,129,131,129,129,131,129,72,204,0,0
  DEFB 0,68,68,129,129,68,68,68,68,68,68,68,64,64,9,3
  DEFB 3,8,11,0,4,8,9,5,0,8,8,72,72,68,133,133
  DEFB 68,68,129,129,68,68,1,253,1,193,1,68,64,68,64,9

; Play area graphic data (tiles 0-20, base page 160, byte 6/8)
;
; Used by the routine at PRINTTILE.
  DEFB 0,6,24,4,255,252,4,205,198,31,3,254,1,192,0,0
  DEFB 136,136,136,17,17

; Mask value 6/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 4                  ; Bit 2 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character moves left from the left edge of the fire escape on
; the first floor of the apartment building next to no. 19 (see FIREESCAPE).
;
; The other special location handler routine addresses can be found at
; SLHANDLER1, SLHANDLER2, SLHANDLER3, SLHANDLER4, SLHANDLER5 and SLHANDLER7.
SLHANDLER6;
  DEFW ROOFEDGE

; Direction indicators for a character facing right and going down
;
; Used by the routine at MOVEUP. This list indicates, in descending order of
; preference, the directions in which a character who is facing right and
; moving down may go.
DIRINDRD;
  DEFB 4                  ; Bit 2 set; down/right
  DEFB 8                  ; Bit 3 set; down/left
  DEFB 64                 ; Bit 6 set; right
  DEFB 16                 ; Bit 4 set; up/right

; T' values (6|y-2)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 2, 8, 14, 20, 26, 32 and 38; in practice, these
; T' values are used only by the tiles at (138,20) and (140,20).
  DEFB 128,128

; Play area tile back buffer byte 6/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T' values (6|y-2)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 2, 8, 14, 20, 26, 32 and 38; in practice, these
; T' values are used only by tiles at y-coordinates 20, 26, 32 and 38.
  DEFB 194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,248,20,194,247,236,235,234,233,232
  DEFB 231,230,30,194,194,194,194,194,194,10,57,203,203,202,201,200
  DEFB 194,189,188,187,186,194,185,194,194,180,179,194,170,169,168,167
  DEFB 166,165,164,163,157,156,155,154,153,152,139,138,194,194,194,194
  DEFB 119,118,118,117,103,102,97,96,194,194,81,80,79,96,225,22
  DEFB 194,129,59,58,57,225,22,194,17,13,9,48,47,194,194,194
  DEFB 194,194,35,0,0,34,33,32,31,30,194,9,128,54,234,249
  DEFB 211,211,211,211,248,247,139,235,139,234,233,232,231,230,207,206
  DEFB 205,204,203,139,202,139,139,177,176,175,175,27,174,173,128,129
  DEFB 7,26,158,196,196,144,28,26,24,24,8,6,143,230,128,128
  DEFB 129,197,196,4,1,88,65,64,63,62,52,51,194,231,104,128
  DEFB 128,97,103,195,251,102,81,228,105,80,79,78,77,35,4,1
  DEFB 34,35,4,1,34,129,128,122,128,93,128,32,231,234,128,54

; Play area graphic data (tiles 0-20, base page 160, byte 7/8)
;
; Used by the routine at PRINTTILE.
  DEFB 0,1,24,4,0,4,4,174,24,224,124,0,30,0,0,0
  DEFB 17,17,17,136,136

; Mask value 7/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 2                  ; Bit 1 set

; Special location handler routine address
;
; Used by the routine at MOVELEFT. This special location handler routine is
; invoked when a character tries to move right from behind the door of the
; left-hand jail cell on the first floor of the police station (see
; LOCDESCS133).
;
; The other special location handler routine addresses can be found at
; SLHANDLER1, SLHANDLER2, SLHANDLER3, SLHANDLER4, SLHANDLER5 and SLHANDLER6.
SLHANDLER7;
  DEFW BYJAILDOOR

; Unused
  DEFS 4

; T values (6|y-3)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 3, 9, 15, 21, 27, 33 and 39; in
; practice, these T values are used only by the tiles at (138,21) and (140,21).
  DEFB 1,1

; Play area tile back buffer byte 7/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T values (6|y-3)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 3, 9, 15, 21, 27, 33 and 39; in
; practice, these T values are used only by tiles at y-coordinates 21, 27, 33
; and 39.
  DEFB 3
  DEFB 3,3,3,3,3,19,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,12,12,0,0,0,12,12
  DEFB 12,15,15,5,15,15,15,3,3,15,3,3,13,5,15,15
  DEFB 15,15,15,15,3,3,3,3,3,3,0,12,12,0,0,0
  DEFB 77,77,77,77,77,77,78,78,3,3,13,13,13,1,128,76
  DEFB 64,68,5,13,76,128,76,64,133,133,133,2,14,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,64,14,2,9,5,64
  DEFB 72,65,65,9,10,10,1,68,3,9,9,1,75,75,75,75
  DEFB 9,9,9,3,68,3,1,10,10,9,73,69,73,65,0,3
  DEFB 7,11,11,3,3,68,129,131,129,129,131,129,72,208,4,8
  DEFB 0,68,68,129,129,68,68,68,68,72,68,72,72,64,3,3
  DEFB 3,8,11,0,4,8,9,5,8,8,4,72,72,68,133,133
  DEFB 68,68,129,129,68,72,193,193,193,193,193,72,64,68,3,9

; Play area graphic data (tiles 0-20, base page 160, byte 8/8)
;
; Used by the routine at PRINTTILE.
  DEFB 0,0,216,7,0,7,252,56,115,7,128,0,224,0,0,0
  DEFB 68,68,68,34,34

; Mask value 8/8
;
; Used by the routines at COPTOSLKW, CHKGUISE, MVCOP2, PRINTTILE and UPDATEAS.
  DEFB 1                  ; Bit 0 set

; Unused
;
; The first two bytes here may once have been used as the address of a special
; location handler routine, which would have been invoked by a three-byte
; special location descriptor with 8 as the third byte (such as the unused
; three-byte location descriptor in the table at XLOCDESCS). The addresses of
; the special location handler routines that are used can be found at
; SLHANDLER1, SLHANDLER2, SLHANDLER3, SLHANDLER4, SLHANDLER5, SLHANDLER6 and
; SLHANDLER7.
  DEFB 10,115
  DEFB 0,0,0,0

; T' values (6|y-3)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 3, 9, 15, 21, 27, 33 and 39; in practice, these
; T' values are used only by the tiles at (138,21) and (140,21).
  DEFB 128,158

; Play area tile back buffer byte 8/8
;
; Used by the routines at COPYTILE and GETTILE.
  DEFB 0

; T' values (6|y-3)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 3, 9, 15, 21, 27, 33 and 39; in practice, these
; T' values are used only by tiles at y-coordinates 21, 27, 33 and 39.
  DEFB 228
  DEFB 228,228,228,228,228,15,210,210,210,210,228,228,228,228,228,228
  DEFB 228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228
  DEFB 228,228,228,228,228,228,228,228,228,208,207,194,194,194,206,205
  DEFB 204,194,193,241,192,191,190,228,228,181,194,194,177,241,176,175
  DEFB 174,173,172,171,228,228,228,228,228,228,194,141,140,228,228,228
  DEFB 123,122,121,120,105,104,99,98,228,228,84,83,82,96,31,60
  DEFB 194,129,103,62,61,30,60,194,28,27,26,105,49,228,228,228
  DEFB 228,228,228,228,228,228,228,228,228,228,194,10,128,54,234,196
  DEFB 253,211,211,252,251,250,128,130,128,239,238,211,237,236,211,210
  DEFB 175,209,208,128,130,128,128,181,180,179,175,27,178,211,128,129
  DEFB 7,160,159,196,196,49,29,27,25,25,23,7,143,102,109,132
  DEFB 129,36,37,5,2,89,71,70,69,122,183,121,120,231,128,128
  DEFB 128,97,103,195,251,102,81,228,85,84,234,83,82,37,5,2
  DEFB 36,37,5,2,36,57,90,92,90,91,90,55,231,234,128,54

; Play area attribute data
;
; Used by the routine at PRINTTILE.
  DEFB 120,120,48,56,48,120,56,48,48,120,48,56,56,56,56,120
  DEFB 56,48,48,120,40,80,120,120,120,56,40,56

; T values (6|y-4)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 4, 10, 16, 22, 28, 34 and 40; in
; practice, these T values are used only by the tiles at (138,22) and (140,22).
  DEFB 1,1

; Play area tile back buffer attribute byte
;
; Used by the routine at PRINTTILE.
BACKBUFATT;
  DEFB 56

; T values (6|y-4)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 4, 10, 16, 22, 28, 34 and 40; in
; practice, these T values are used only by tiles at y-coordinates 22, 28, 34
; and 40. In particular, the T values at addresses 43039-43119, 43128, 43129
; and 43149-43161 are used only by tiles at y-coordinate 40 (which are never
; displayed), and are therefore effectively unused.
  DEFB 3
  DEFB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,0,12,12,12,12,12,12
  DEFB 0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0
  DEFB 77,77,77,77,77,77,78,78,3,3,13,13,13,13,64,76
  DEFB 64,68,5,13,76,64,76,64,133,133,133,2,14,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,76,13,13,9,5,64
  DEFB 76,65,65,13,10,10,2,68,3,9,9,9,75,75,75,75
  DEFB 9,9,9,3,68,3,1,10,10,9,73,69,73,65,0,11
  DEFB 11,11,11,3,3,72,75,75,75,75,75,75,72,220,8,8
  DEFB 192,68,68,68,68,72,72,68,72,72,68,72,72,64,3,3
  DEFB 3,11,11,11,8,8,9,5,8,8,8,72,72,68,68,68
  DEFB 68,68,68,68,68,64,72,72,72,72,72,64,72,68,64,72

; Play area attribute data
;
; Used by the routine at PRINTTILE.
  DEFB 43,43,112,40,96,40,96,40,56,32,104,48,104,88,48,24
  DEFB 112,56,88,48,56,112,56,48,56,80,40,40

; T' values (6|y-4)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 4, 10, 16, 22, 28, 34 and 40; in practice, these
; T' values are used only by the tiles at (138,22) and (140,22).
  DEFB 128,128

; Unused
  DEFB 0

; T' values (6|y-4)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 4, 10, 16, 22, 28, 34 and 40; in practice, these
; T' values are used only by tiles at y-coordinates 22, 28, 34 and 40. In
; particular, the T' values at addresses 43295-43375, 43384, 43385 and
; 43405-43417 are used only by tiles at y-coordinate 40 (which are never
; displayed), and are therefore effectively unused.
  DEFB 194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,210,191,191,191,191,209
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 124,121,121,120,107,106,93,93,194,194,88,87,86,85,198,63
  DEFB 194,129,103,62,64,198,63,194,28,27,26,105,50,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,13,12,11,54,234,196
  DEFB 1,211,211,0,255,254,128,130,128,242,241,240,237,236,211,210
  DEFB 214,213,212,128,130,128,128,185,184,183,175,27,182,211,128,163
  DEFB 162,161,159,196,196,150,149,148,146,146,147,146,145,215,134,133
  DEFB 151,92,91,93,93,130,126,69,125,114,58,124,123,231,198,198
  DEFB 198,109,108,107,106,105,81,228,90,89,88,87,86,40,39,39
  DEFB 38,40,39,39,38,194,62,61,60,59,58,194,56,234,128,54

; Play area attribute data
;
; Used by the routine at PRINTTILE.
  DEFB 43
  DEFB 43                 ; Unused; this attribute byte would be used by the 16
                          ; tiles in the top two rows of the play area between
                          ; x-coordinates 80 and 87, but those tiles are never
                          ; displayed
  DEFB 40,40,56,40,48,104,40,40
  DEFB 0                  ; Unused
  DEFB 40
  DEFB 0,0                ; Unused
  DEFB 40
  DEFB 0,0                ; Unused
  DEFB 40
  DEFB 0                  ; Unused
  DEFB 121,48,112,96,121,32
  DEFB 56                 ; Unused
  DEFB 40
  DEFB 0                  ; Unused

; T values (6|y-5)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 5, 11, 17, 23, 29, 35 and 41; in
; practice, these T values are used only by the tiles at (138,23) and (140,23).
  DEFB 1,1

; Unused
  DEFB 0

; T values (6|y-5)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be used by play area tiles at y-coordinates 5, 11, 17, 23, 29, 35 and 41; in
; practice, these T values are used only by tiles at y-coordinates 23, 29, 35
; and 41. In particular, the T values at addresses 43551-43631, 43640, 43641
; and 43661-43673 are used only by tiles at y-coordinate 41 (which are never
; displayed), and are therefore effectively unused.
  DEFB 3
  DEFB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0
  DEFB 0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0
  DEFB 77,77,77,77,77,77,78,78,3,3,13,13,13,13,64,64
  DEFB 76,76,13,13,76,76,68,76,133,133,133,2,14,3,3,3
  DEFB 3,3,3,3,3,3,3,3,3,3,64,13,13,13,5,64
  DEFB 64,77,65,13,15,13,9,68,11,9,1,1,75,75,75,75
  DEFB 1,1,9,11,68,11,9,11,11,9,73,69,73,65,3,11
  DEFB 11,11,11,3,3,72,64,64,72,72,64,72,72,224,212,8
  DEFB 196,64,64,64,64,72,64,72,72,68,72,64,64,64,3,3
  DEFB 3,3,3,11,11,11,8,8,8,8,8,72,72,72,72,72
  DEFB 72,72,72,72,72,64,72,72,72,72,72,64,64,68,64,72

; Play area attribute data
;
; Used by the routine at PRINTTILE.
  DEFB 56,40,56,48,56,104
  DEFB 0                  ; Unused
  DEFB 56,46,96,56,48
  DEFB 0,0                ; Unused
  DEFB 47,88
  DEFB 0                  ; Unused
  DEFB 56,56,112
  DEFB 0,0                ; Unused
  DEFB 112,56,48,56
  DEFB 0                  ; Unused
  DEFB 56

; T' values (6|y-5)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 5, 11, 17, 23, 29, 35 and 41; in practice, these
; T' values are used only by the tiles at (138,23) and (140,23).
  DEFB 158,158

; Unused
  DEFB 0

; T' values (6|y-5)
;
; Used by the routine at PRINTTILE. T' values in this block may be used by play
; area tiles at y-coordinates 5, 11, 17, 23, 29, 35 and 41; in practice, these
; T' values are used only by tiles at y-coordinates 23, 29, 35 and 41. In
; particular, the T' values at addresses 43807-43887, 43896, 43897 and
; 43917-43929 are used only by tiles at y-coordinate 41 (which are never
; displayed), and are therefore effectively unused.
  DEFB 194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194
  DEFB 127,126,126,125,109,108,93,93,194,194,92,91,90,89,194,194
  DEFB 71,70,69,68,67,66,250,65,28,27,26,105,50,194,194,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,16,15,14,234,196
  DEFB 196,5,211,4,3,2,191,130,191,245,128,128,244,243,217,216
  DEFB 128,128,215,191,130,191,191,190,189,188,187,27,186,211,128,165
  DEFB 164,161,159,196,196,155,211,211,154,153,211,152,151,88,153,135
  DEFB 24,194,194,194,194,131,128,127,114,58,113,194,194,231,194,194
  DEFB 194,194,194,112,111,110,95,94,93,92,91,87,86,71,69,70
  DEFB 69,69,69,69,68,194,67,66,65,64,63,194,194,234,128,54

; T values (6|y)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be (and in practice are) used by play area tiles at y-coordinates 0, 6, 12,
; 18, 24, 30 and 36. The T values at addresses 44255-44260, 44265-44277 and
; 44284-44287 are used only by tiles at y-coordinate 0 (which are never
; displayed), and are therefore effectively unused.
Z3VALUES0B;
  DEFB 11,64,64,64,64,64,64,64,64,64,64,64,64,0,9,9
  DEFB 9,0,8,0,2,2,75,64,68,75,75,75,75,75,75,2
  DEFB 6,6,5,7,0,4,4,5,5,68,68,64,64,64,64,68
  DEFB 193,253,1,68,1,5,5,5,1,2,6,64,64,68,64,64
  DEFB 68,68,68,68,68,68,68,68,68,68,68,68,68,2,2,2
  DEFB 0,4,0,1,1,1,1,1,64,64,68,71,71,71,68,68
  DEFB 68,64,129,129,129,129,71,68,68,68,68,68,68,68,68,64
  DEFB 129,129,129,129,64,68,2,2,64,6,2,2,2,2,6,2
  DEFB 68,68,68,68,68,68,68,68,68,64,64,68,68,64,64,68
  DEFB 68,68,68,68,68,64,64,68,2,2,2,2,2,2,2,2
  DEFB 2,68,68,64,64,68,64,64,68,6,6,6,2,2,2,2
  DEFB 2,2,2,2,2,2,6,68,131,129,68,68,64,64,64,64
  DEFB 64,64,64,64,64,67,3,3,3,3,129,129,129,131,64,2
  DEFB 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,64
  DEFB 64,64,64,2,3,3,3,64,64,2,2,2,2,2,2,2
  DEFB 2,2,2,2,2,2,64,64,3,3,3,3,2,2,2,2

; T' values (6|y)
;
; Used by the routine at PRINTTILE. T' values in this block may be (and in
; practice are) used by play area tiles at y-coordinates 0, 6, 12, 18, 24, 30
; and 36. The T' values at addresses 44511-44516, 44521-44533 and 44540-44543
; are used only by tiles at y-coordinate 0 (which are never displayed), and are
; therefore effectively unused.
  DEFB 47,194,194,194,194,194,194,194,194,194,194,194,194,128,25,24
  DEFB 23,128,22,128,194,194,19,198,202,9,8,10,9,8,7,194
  DEFB 241,240,239,238,194,49,237,229,228,227,226,128,194,194,194,129
  DEFB 122,93,128,32,128,205,204,203,128,198,202,55,55,31,55,55
  DEFB 30,193,192,180,191,190,184,183,84,182,181,180,179,194,194,231
  DEFB 194,49,194,194,196,196,196,196,194,194,146,145,144,143,142,141
  DEFB 133,231,17,13,13,9,131,130,124,123,122,121,120,119,114,231
  DEFB 17,13,13,9,194,10,128,194,128,112,225,225,225,225,111,194
  DEFB 100,99,99,99,99,99,99,98,31,55,55,30,31,55,55,86
  DEFB 54,53,52,51,31,55,55,50,194,194,194,194,194,194,194,194
  DEFB 194,27,18,55,55,31,55,55,30,27,27,27,194,194,194,194
  DEFB 194,194,194,194,194,194,7,6,17,9,3,2,194,194,194,194
  DEFB 196,211,211,225,252,194,251,250,249,248,17,13,13,9,199,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,128
  DEFB 128,128,230,229,195,224,223,222,194,195,195,195,195,195,215,195
  DEFB 195,195,195,195,195,195,205,204,203,202,201,200,195,195,195,195

; T values (6|y-1)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be (and in practice are) used by play area tiles at y-coordinates 1, 7, 13,
; 19, 25, 31 and 37. The T values at addresses 44767-44772, 44777-44789 and
; 44796-44799 are used only by tiles at y-coordinate 1 (which are never
; displayed), and are therefore effectively unused.
  DEFB 3,129,129,129,129,64,64,64,64,129,129,129,129,0,9,9
  DEFB 9,5,0,0,2,75,72,64,64,133,133,75,129,129,75,2
  DEFB 6,6,7,7,0,4,4,5,5,5,68,68,64,64,64,68
  DEFB 193,193,1,68,0,5,5,5,5,2,2,133,133,68,129,129
  DEFB 68,68,68,129,129,68,68,68,68,68,68,129,129,2,2,2
  DEFB 0,4,0,1,1,1,1,1,64,64,68,68,68,68,68,68
  DEFB 68,64,129,129,129,129,71,68,68,68,68,68,68,68,68,64
  DEFB 129,129,129,129,64,68,2,2,64,249,249,249,249,249,249,2
  DEFB 68,0,0,68,68,68,68,68,68,133,133,68,68,129,129,68
  DEFB 68,68,68,68,68,129,129,68,2,2,6,2,2,2,2,2
  DEFB 2,68,68,133,133,68,129,129,68,6,6,6,1,5,5,5
  DEFB 1,1,6,2,2,2,6,68,131,129,7,7,64,129,129,129
  DEFB 64,64,64,7,3,67,3,3,3,3,129,129,129,131,64,2
  DEFB 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,64
  DEFB 64,64,64,2,3,3,3,64,64,2,2,2,2,2,2,2
  DEFB 2,2,2,2,2,2,64,3,3,3,3,3,2,2,2,2

; T' values (6|y-1)
;
; Used by the routine at PRINTTILE. T' values in this block may be (and in
; practice are) used by play area tiles at y-coordinates 1, 7, 13, 19, 25, 31
; and 37. The T' values at addresses 45023-45028, 45033-45045 and 45052-45055
; are used only by tiles at y-coordinate 1 (which are never displayed), and are
; therefore effectively unused.
  DEFB 128,13,13,13,9,194,194,194,194,17,13,13,13,128,28,27
  DEFB 26,230,231,128,194,19,20,194,231,3,0,12,3,0,11,194
  DEFB 241,178,244,243,194,49,242,233,228,232,231,230,194,194,194,129
  DEFB 122,93,128,32,128,16,10,207,206,194,231,3,0,33,3,0
  DEFB 32,195,194,3,0,87,59,58,57,186,185,3,0,194,194,231
  DEFB 194,49,194,194,196,196,196,196,194,194,149,148,147,147,147,147
  DEFB 134,231,18,21,14,10,131,130,127,125,125,126,125,125,115,231
  DEFB 18,21,14,10,194,10,128,194,128,29,29,29,29,29,29,194
  DEFB 105,128,128,104,103,102,101,12,33,3,0,32,33,3,0,87
  DEFB 59,58,57,52,56,3,0,55,194,194,45,225,194,194,194,194
  DEFB 194,27,18,3,0,33,3,0,32,27,27,27,234,15,15,14
  DEFB 198,198,11,194,194,194,7,6,18,10,5,4,194,17,13,9
  DEFB 196,211,211,0,255,194,194,254,194,253,18,21,14,10,199,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,128
  DEFB 128,128,105,231,195,227,226,196,225,195,195,195,195,195,216,195
  DEFB 195,195,195,195,195,195,208,207,206,194,194,194,195,195,195,195

; T values (6|y-2)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be (and in practice are) used by play area tiles at y-coordinates 2, 8, 14,
; 20, 26, 32 and 38.
  DEFB 3,129,129,129,129,64,64,64,64,129,129,129,129,0,1,5
  DEFB 9,5,8,8,6,72,64,64,64,133,133,75,129,129,75,6
  DEFB 6,6,0,7,0,4,4,5,5,1,68,68,64,64,64,68
  DEFB 253,193,1,68,0,1,5,4,4,2,2,134,134,68,130,130
  DEFB 68,68,68,129,129,68,68,68,68,68,68,129,129,2,6,2
  DEFB 0,4,0,1,5,1,1,5,64,64,68,68,0,0,68,68
  DEFB 68,64,129,129,129,129,71,68,68,193,253,193,193,193,68,64
  DEFB 129,129,129,129,64,68,2,2,64,249,249,251,249,249,249,2
  DEFB 204,0,0,0,4,0,4,192,68,133,133,68,68,129,129,68
  DEFB 68,68,68,68,68,129,129,68,6,4,4,0,3,7,3,7
  DEFB 7,68,68,133,133,68,129,129,68,6,6,6,5,5,1,5
  DEFB 1,1,6,2,2,2,6,68,131,129,3,3,64,129,129,129
  DEFB 64,64,64,3,3,3,3,3,3,3,129,129,129,131,64,2
  DEFB 2,2,2,64,2,2,2,2,2,2,2,2,2,2,2,64
  DEFB 64,64,64,2,3,3,3,3,3,1,1,1,1,1,1,1
  DEFB 1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1

; T' values (6|y-2)
;
; Used by the routine at PRINTTILE. T' values in this block may be (and in
; practice are) used by play area tiles at y-coordinates 2, 8, 14, 20, 26, 32
; and 38.
  DEFB 128,24,24,24,23,194,194,194,194,25,24,24,24,128,129,7
  DEFB 26,234,30,29,250,20,194,194,231,4,1,14,4,1,13,250
  DEFB 249,248,105,247,194,246,245,235,228,128,231,234,194,194,194,129
  DEFB 122,93,128,32,128,129,210,209,208,194,231,4,1,35,4,1
  DEFB 34,197,196,4,1,88,187,64,63,62,61,7,1,194,168,231
  DEFB 194,49,194,194,161,196,196,44,194,194,152,151,128,128,150,99
  DEFB 135,231,19,22,15,11,131,130,128,123,125,123,124,123,116,231
  DEFB 19,22,15,11,194,10,128,194,128,29,29,29,29,29,29,194
  DEFB 230,128,128,129,107,128,106,6,35,4,1,34,35,4,1,88
  DEFB 65,64,63,62,61,7,1,60,48,47,46,194,198,43,221,42
  DEFB 41,27,18,4,1,35,4,1,34,27,27,27,18,17,128,16
  DEFB 194,194,12,194,194,194,7,6,19,11,194,194,194,25,24,23
  DEFB 196,211,211,194,194,194,194,194,194,194,19,22,15,11,199,194
  DEFB 194,194,194,198,194,194,194,194,194,194,194,194,194,194,194,128
  DEFB 128,128,105,231,195,194,194,194,194,195,195,195,195,195,217,195
  DEFB 195,195,195,195,195,195,194,194,194,194,194,194,195,195,195,195

; T values (6|y-3)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be (and in practice are) used by play area tiles at y-coordinates 3, 9, 15,
; 21, 27, 33 and 39.
  DEFB 3,129,129,129,129,64,64,64,64,129,129,129,129,0,1,5
  DEFB 9,5,8,8,10,64,64,64,72,133,133,75,129,129,75,6
  DEFB 6,6,0,7,4,4,4,5,5,64,68,68,64,68,68,68
  DEFB 193,193,1,68,0,1,5,0,4,7,6,134,134,68,130,130
  DEFB 68,68,68,129,129,68,68,68,68,68,68,128,129,6,6,6
  DEFB 0,4,0,1,5,1,1,5,64,64,68,68,0,0,64,64
  DEFB 68,64,129,129,129,129,71,68,68,1,193,1,193,1,68,64
  DEFB 129,129,129,129,64,68,2,2,64,249,249,251,251,249,249,2
  DEFB 208,4,4,0,0,0,4,192,68,133,133,68,68,129,129,68
  DEFB 68,68,68,68,68,128,129,68,2,0,4,0,1,1,1,1
  DEFB 5,68,68,133,133,68,129,129,68,6,6,6,5,5,5,5
  DEFB 1,1,6,2,2,2,6,68,131,129,3,3,64,129,129,129
  DEFB 64,64,64,3,3,3,3,3,3,3,129,129,129,131,64,2
  DEFB 2,2,2,64,2,2,2,2,2,2,2,2,2,2,2,64
  DEFB 64,64,64,2,3,3,3,3,3,1,1,64,67,67,64,67
  DEFB 67,1,1,1,1,64,3,3,3,3,3,3,1,1,1,1

; T' values (6|y-3)
;
; Used by the routine at PRINTTILE. T' values in this block may be (and in
; practice are) used by play area tiles at y-coordinates 3, 9, 15, 21, 27, 33
; and 39.
  DEFB 128,16,16,16,12,194,194,194,194,20,16,16,16,128,129,7
  DEFB 26,234,32,31,21,194,194,194,21,5,2,16,5,2,15,254
  DEFB 249,253,105,247,252,251,237,229,228,128,231,234,194,220,219,129
  DEFB 122,93,128,32,128,129,7,128,213,212,211,5,2,37,5,2
  DEFB 36,36,37,5,2,89,71,70,69,68,67,8,6,171,170,169
  DEFB 194,49,194,194,161,196,196,44,194,194,131,153,128,128,113,128
  DEFB 16,231,20,16,16,12,131,130,129,158,122,128,93,128,32,231
  DEFB 20,16,16,12,194,10,128,194,128,29,29,29,29,29,29,194
  DEFB 102,109,108,129,128,128,106,6,37,5,2,36,37,5,2,89
  DEFB 71,70,69,68,67,8,6,66,231,194,49,194,194,196,196,196
  DEFB 44,27,18,5,2,37,5,2,36,27,28,28,21,21,20,19
  DEFB 194,194,13,194,194,194,7,6,20,12,228,228,194,20,16,12
  DEFB 196,211,211,228,228,228,228,228,228,228,20,16,16,12,199,194
  DEFB 194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,128
  DEFB 128,128,105,231,195,228,228,228,228,195,195,128,219,218,128,128
  DEFB 214,195,195,195,195,128,210,210,210,210,210,209,195,195,195,195

; T values (6|y-4)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be (and in practice are) used by play area tiles at y-coordinates 4, 10, 16,
; 22, 28, 34 and 40. The T values at addresses 46266, 46267, 46275-46281,
; 46309-46312 and 46326-46331 are used only by tiles at y-coordinate 40 (which
; are never displayed), and are therefore effectively unused.
  DEFB 3,64,64,64,64,64,64,64,64,64,64,64,64,0,1,5
  DEFB 9,5,8,8,68,68,68,68,68,68,68,72,68,68,72,6
  DEFB 10,10,8,7,4,4,4,5,5,64,68,68,68,68,68,68
  DEFB 253,193,1,68,0,1,5,5,4,4,0,68,68,68,68,68
  DEFB 68,68,68,68,68,68,68,68,68,68,68,68,68,6,5,7
  DEFB 0,4,0,1,5,1,5,5,68,64,68,68,0,0,68,64
  DEFB 68,68,68,68,68,68,71,68,68,1,253,1,193,1,68,68
  DEFB 68,68,68,68,68,68,2,2,64,249,251,251,251,249,249,68
  DEFB 208,200,196,192,192,192,192,192,68,68,68,68,68,68,68,68
  DEFB 68,68,68,68,68,68,68,68,2,0,4,0,1,1,1,1
  DEFB 1,68,68,68,68,68,68,68,68,6,68,64,64,64,64,64
  DEFB 64,64,64,64,68,6,6,68,64,64,3,3,64,64,64,64
  DEFB 64,64,64,3,3,3,3,3,3,3,64,64,64,64,64,2
  DEFB 2,2,2,64,2,2,2,2,2,2,2,2,2,2,2,64
  DEFB 64,64,64,64,64,3,3,3,3,64,64,64,64,64,64,64
  DEFB 64,64,64,64,64,64,3,3,3,3,3,3,64,64,2,2

; T' values (6|y-4)
;
; Used by the routine at PRINTTILE. T' values in this block may be (and in
; practice are) used by play area tiles at y-coordinates 4, 10, 16, 22, 28, 34
; and 40. The T' values at addresses 46522, 46523, 46531-46537, 46565-46568 and
; 46582-46587 are used only by tiles at y-coordinate 40 (which are never
; displayed), and are therefore effectively unused.
  DEFB 128,194,194,194,194,194,194,194,194,194,194,194,194,128,129,7
  DEFB 26,234,34,33,110,110,110,110,110,39,39,18,39,39,17,241
  DEFB 2,1,0,247,255,251,242,233,228,128,231,234,223,222,221,129
  DEFB 122,93,128,32,128,129,7,216,215,214,128,39,39,40,39,39
  DEFB 38,92,91,90,76,76,188,77,76,75,74,62,73,174,173,172
  DEFB 194,49,194,194,161,196,163,162,155,194,131,153,128,128,154,213
  DEFB 138,137,136,136,136,136,131,132,129,128,122,128,93,128,32,118
  DEFB 117,117,117,117,113,10,128,231,128,29,29,29,29,29,29,110
  DEFB 231,199,199,168,38,38,38,7,91,93,93,92,91,90,76,76
  DEFB 78,77,76,75,74,62,73,72,231,194,49,194,194,196,196,196
  DEFB 196,27,18,39,39,40,39,39,38,27,18,194,194,194,194,194
  DEFB 194,194,194,194,10,9,7,8,196,194,194,194,194,194,194,194
  DEFB 196,211,211,194,194,194,194,194,194,194,194,194,194,194,199,194
  DEFB 244,194,194,194,194,194,194,194,194,194,194,194,194,194,194,233
  DEFB 232,198,198,198,198,194,194,194,194,221,220,213,213,213,213,213
  DEFB 213,213,212,196,211,211,194,194,194,194,194,194,198,197,196,196

; T values (6|y-5)
;
; Used by the routines at PRINTTILE and WINDOWSRB. T values in this block may
; be (and in practice are) used by play area tiles at y-coordinates 5, 11, 17,
; 23, 29, 35 and 41. The T values at addresses 46778, 46779, 46787-46793,
; 46821-46824 and 46838-46843 are used only by tiles at y-coordinate 41 (which
; are never displayed), and are therefore effectively unused.
  DEFB 3,74,74,74,70,74,74,74,74,74,74,74,66,0,1,5
  DEFB 9,5,8,8,64,64,64,64,64,64,64,64,64,64,64,6
  DEFB 2,9,8,7,8,4,8,5,5,64,68,68,68,68,64,68
  DEFB 253,253,1,68,0,1,5,5,0,4,0,71,71,68,71,71
  DEFB 68,64,68,68,68,68,68,68,68,68,68,68,68,6,5,7
  DEFB 0,4,4,5,5,5,5,1,64,68,68,68,4,4,68,64
  DEFB 68,68,64,64,64,64,71,68,68,1,253,1,253,1,68,64
  DEFB 64,64,64,64,64,68,2,2,64,249,251,251,251,249,249,64
  DEFB 212,204,200,196,192,192,192,192,64,64,64,64,68,68,68,68
  DEFB 68,68,68,68,68,68,68,68,2,0,4,0,1,1,1,1
  DEFB 1,68,68,64,64,64,64,64,64,71,68,64,68,68,68,68
  DEFB 68,64,64,64,68,64,6,68,64,64,3,3,64,64,64,64
  DEFB 64,64,68,3,3,3,3,3,3,3,64,64,64,64,64,2
  DEFB 2,2,64,64,64,64,64,64,64,64,2,2,2,64,64,64
  DEFB 64,64,64,64,64,3,3,3,3,64,64,64,64,64,64,64
  DEFB 64,64,64,64,64,64,3,3,3,3,3,3,64,64,2,1

; T' values (6|y-5)
;
; Used by the routine at PRINTTILE. T' values in this block may be (and in
; practice are) used by play area tiles at y-coordinates 5, 11, 17, 23, 29, 35
; and 41. The T' values at addresses 47034, 47035, 47043-47049, 47077-47080 and
; 47094-47099 are used only by tiles at y-coordinate 41 (which are never
; displayed), and are therefore effectively unused.
  DEFB 128,46,45,44,12,43,42,41,40,39,38,37,194,128,129,7
  DEFB 26,234,36,35,194,194,194,194,194,194,194,194,194,194,194,241
  DEFB 128,6,5,247,4,251,3,236,228,128,231,234,225,224,194,129
  DEFB 122,93,158,32,128,129,7,218,128,217,128,200,199,201,200,199
  DEFB 198,194,97,96,95,94,85,84,83,80,189,81,80,178,177,176
  DEFB 194,49,175,167,166,165,164,128,194,160,159,153,158,157,156,194
  DEFB 140,139,194,194,194,194,131,18,129,158,122,158,93,158,32,194
  DEFB 194,194,194,194,194,10,128,231,128,29,29,29,29,29,29,194
  DEFB 104,72,72,70,39,39,39,8,194,194,194,194,97,96,95,94
  DEFB 85,84,83,80,82,81,80,79,231,194,49,194,194,196,196,196
  DEFB 196,27,18,194,194,194,194,194,194,29,18,194,26,25,24,23
  DEFB 22,194,194,194,10,128,7,8,196,194,194,194,194,194,194,194
  DEFB 196,211,1,194,194,194,194,194,194,194,194,194,194,194,199,247
  DEFB 246,245,243,238,242,241,240,239,238,237,194,236,235,234,198,105
  DEFB 196,194,194,194,194,194,194,194,194,196,196,194,194,194,194,194
  DEFB 194,194,196,196,211,211,194,194,194,194,194,194,194,199,196,196

; Z values (0<=y<=5)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high.
  DEFB 0,0,0              ; 0<=x<24; apartment building next to no. 74
  DEFB 0                  ; 24<=x<32
  DEFB 0,0,0              ; 32<=x<56; no. 74
  DEFB 1,3,4,5,6,8        ; 56<=x<104; hotel (roof)
  DEFB 0,0                ; 104<=x<120; no. 31
  DEFB 0                  ; 120<=x<128
  DEFB 0,0,0              ; 128<=x<152; police station
  DEFB 0                  ; 152<=x<160; no. 27
  DEFB 0,0                ; 160<=x<176
  DEFB 0,0,0,0            ; 176<=x<208; apartment building next to no. 19
  DEFB 0,0                ; 208<=x<224; no. 19
  DEFB 0,0                ; 224<=x<240; no. 17
  DEFB 0,0                ; 240<=x<256; no. 15

; Play area tile attribute address LSBs (0<=y<=5)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high.
  DEFB 0,0,0              ; 0<=x<24; apartment building next to no. 74
  DEFB 0                  ; 24<=x<32
  DEFB 0,0,0              ; 32<=x<56; no. 74
  DEFB 0,0,0,1,0,0        ; 56<=x<104; hotel (roof)
  DEFB 0,0                ; 104<=x<120; no. 31
  DEFB 0                  ; 120<=x<128
  DEFB 0,0,0              ; 128<=x<152; police station
  DEFB 0                  ; 152<=x<160; no. 27
  DEFB 0,0                ; 160<=x<176
  DEFB 0,0,0,0            ; 176<=x<208; apartment building next to no. 19
  DEFB 0,0                ; 208<=x<224; no. 19
  DEFB 0,0                ; 224<=x<240; no. 17
  DEFB 0,0                ; 240<=x<256; no. 15

; Window flags (0<=y<=5)
;
; Used by the routine at WINFLAGS. Since there are no windows between
; y-coordinates 0 and 5, these window flag bytes are always 0. The window flags
; for the next range of y-coordinates (6-11, corresponding to the 5th floor
; windows) are at WINFLAGS5.
WINFLAGS6;
  DEFS 32

; Location descriptors (x-coordinate 66)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the
; staircase between the third and fourth floors of the hotel.
LOCDESCS66;
  DEFB 22,24              ; y=15, z=1; up/right, down/left
  DEFB 26,36              ; y=17, z=1; up/left, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 220,255

; Location descriptors (x-coordinate 67)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the
; staircase between the third and fourth floors of the hotel.
LOCDESCS67;
  DEFB 20,72              ; y=14, z=1; right, down/left
  DEFB 28,36              ; y=18, z=1; up/left, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 76
  DEFB 122,220            ; y=33, z=2; left, right, up/right, down/left,
                          ; down/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 68)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircase between the third and
; fourth floors of the hotel.
LOCDESCS68;
  DEFB 20,144             ; y=14, z=1; left, up/right
  DEFB 30,224             ; y=19, z=1; left, right, up/left (bottom of the
                          ; staircase)
; The next descriptor corresponds to the front steps on the left side of the
; hotel.
  DEFB 122,28             ; y=33, z=2; up/right, down/left, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 200,255

; Location descriptors (x-coordinate 69)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the top of the staircase between the
; third and fourth floors of the hotel.
LOCDESCS69;
  DEFB 18,200             ; y=13, z=1; left, right, down/left
; The next descriptor corresponds to the front steps on the left side of the
; hotel.
  DEFB 120,72             ; y=32, z=2; right, down/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 220,255

; Z'' values (8|x)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N (0<=N<=31).
Z2VALUES0;
  DEFB 255,254,251,245,241,241,241,232,228,222,221,218,217,216,212,216
  DEFB 207,201,194,189,188,190,195,185,218,179,176,179,168,168,162,155
  DEFB 151,143,135,127,188,120,119,115,109,115,101,95,188,162,82,151
  DEFB 69,64,188,185,115,50,168,162,38,30,24,188,189,6,0,115
  DEFB 250,244,162,229,221,213,135,204,188,189,181,173,166,50,153,145
  DEFB 140,135,127,121,119,135,127,111,105,99,91,195,86,80,72,66
  DEFB 197,51,48,41,36,33

; Location descriptors (x-coordinates 13, 197)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircases between the top floor
; and the roof in the apartment buildings next to no. 74 (x=13) and no. 19
; (x=197).
LOCDESCS13;
  DEFB 14,36              ; y=11, z=1; up/left, down/right
  DEFB 18,208             ; y=13, z=1; left, right, up/right
; The next two descriptors correspond to the staircases between the third and
; top floors in the apartment buildings next to no. 74 (x=13) and no. 19
; (x=197).
  DEFB 26,36              ; y=17, z=1; up/left, down/right
  DEFB 30,208             ; y=19, z=1; left, right, up/right
; The next two descriptors correspond to the staircases between the second and
; third floors in the apartment buildings next to no. 74 (x=13) and no. 19
; (x=197).
  DEFB 38,36              ; y=23, z=1; up/left, down/right
  DEFB 42,208             ; y=25, z=1; left, right, up/right
; The next two descriptors correspond to the staircases between the first and
; second floors in the apartment buildings next to no. 74 (x=13) and no. 19
; (x=197).
  DEFB 50,36              ; y=29, z=1; up/left, down/right
  DEFB 54,208             ; y=31, z=1; left, right, up/right
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 38)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the wall in
; the room past the catwalk.
LOCDESCS38;
  DEFB 18,128             ; y=13, z=1; left (no access to no. 74)
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 40, 112, 208)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the wall on the top floor of no. 74 that
; separates it from the room past the catwalk (x=40).
LOCDESCS40;
  DEFB 18,64              ; y=13, z=1; right (no access to the room past the
                          ; catwalk)
; The next descriptor corresponds to the front steps of no. 74 (x=40), no. 31
; (x=112) and no. 19 (x=208).
LOCDESCS112;
  DEFB 120,84             ; y=32, z=2; right, up/right, down/right
; The next descriptor also corresponds to the front steps of no. 74 (x=40), no.
; 31 (x=112) and no. 19 (x=208).
  DEFB 122,92             ; y=33, z=2; right, up/right, down/left, down/right
; This block of location descriptors is implicitly terminated by the page
; boundary.

; Z values (6<=y<=11)
;
; Used by the routines at PRINTTILE, WINDOWSRB, CHKFUSES, PREPGAME, ROOFNO19
; and TOGGLEROPE. Each byte here corresponds to a segment of the play area that
; is eight tiles wide and six tiles high, and level with the 5th floor of a
; building (6<=y<=11).
ZVALUES5;
  DEFB 13,14,13           ; 0<=x<24; apartment building next to no. 74 (roof)
  DEFB 15                 ; 24<=x<32
  DEFB 9,9,9              ; 32<=x<56; no. 74 (roof)
  DEFB 16,18,19,20,21,23  ; 56<=x<104; hotel
  DEFB 11,11              ; 104<=x<120; above the roof of no. 31
  DEFB 24                 ; 120<=x<128
  DEFB 25,26,27           ; 128<=x<152; police station (roof)
  DEFB 9                  ; 152<=x<160; no. 27 (roof)
  DEFB 10,11              ; 160<=x<176
  DEFB 12,13,14,13        ; 176<=x<208; apartment building next to no. 19
                          ; (roof)
  DEFB 11,11              ; 208<=x<224; above the roof of no. 19 (these Z
                          ; values are checked by the routine at ROOFNO19 and
                          ; changed by the routines at PREPGAME and TOGGLEROPE)
  DEFB 9,9                ; 224<=x<240; no. 17 (roof)
  DEFB 9,9                ; 240<=x<256; no. 15 (roof)

; Play area tile attribute address LSBs (6<=y<=11)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high, and level with the
; 5th floor of a building (6<=y<=11).
  DEFB 2,3,3              ; 0<=x<24; apartment building next to no. 74 (roof)
  DEFB 3                  ; 24<=x<32
  DEFB 2,2,2              ; 32<=x<56; no. 74
  DEFB 5,5,5,5,5,5        ; 56<=x<104; hotel
  DEFB 2,2                ; 104<=x<120; above the roof of no. 31
  DEFB 2                  ; 120<=x<128
  DEFB 2,2,2              ; 128<=x<152; police station (roof)
  DEFB 3                  ; 152<=x<160; no. 27 (roof)
  DEFB 3,2                ; 160<=x<176
  DEFB 3,3,3,3            ; 176<=x<208; apartment building next to no. 19
                          ; (roof)
  DEFB 26,26              ; 208<=x<224; above the roof of no. 19
  DEFB 3,3                ; 224<=x<240; no. 17 (roof)
  DEFB 2,2                ; 240<=x<256; no. 15 (roof)

; 5th floor window flags (6<=y<=11)
;
; Used by the routines at BYLIGHT and WINFLAGS. Each byte here corresponds to a
; segment of the play area that is eight tiles wide, and level with the 5th
; floor of a building (6<=y<=11). The window flags for y-coordinate range 0-5
; are at WINFLAGS6; the 4th floor window flags are at WINFLAGS4.
WINFLAGS5;
  DEFB 0,0,0,0,0,0,0      ; 0<=x<56; no windows here
  DEFB 136,0,0,0,0,200    ; 56<=x<104; hotel
  DEFB 0,0,0              ; 104<=x<256; no windows here
  DEFB 0,0,0,0,0,0,0,0    ;
  DEFB 0,0,0,0,0,0,0,0    ;

; Location descriptors (x-coordinate 91)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircase between the fourth and
; top floors of the hotel.
LOCDESCS91;
  DEFB 10,36              ; y=9, z=1; up/left, down/right
  DEFB 14,24              ; y=11, z=1; up/right, down/left
; The next two descriptors correspond to the staircase between the second and
; third floors of the hotel.
  DEFB 34,36              ; y=21, z=1; up/left, down/right
  DEFB 38,24              ; y=23, z=1; up/right, down/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 236,255

; Location descriptors (x-coordinate 90)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircase between the fourth and
; top floors of the hotel.
LOCDESCS90;
  DEFB 8,132              ; y=8, z=1; left, down/right
  DEFB 16,24              ; y=12, z=1; up/right, down/left
; The next two descriptors correspond to the staircase between the second and
; third floors of the hotel.
  DEFB 32,132             ; y=20, z=1; left, down/right
  DEFB 40,24              ; y=24, z=1; up/right, down/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 140
  DEFB 122,236            ; y=33, z=2; left, right, up/left, down/left,
                          ; down/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 76)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the steps
; near the entrance to the hotel.
LOCDESCS76;
  DEFB 219,204,192        ; y=31, z=1 or 2; left, right, down/left, down/right
  DEFB 120,224            ; y=32, z=2; left, right, up/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 236,255

; Z'' values (8|x-1)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+1 (0<=N<=31).
  DEFB 255,253,250,244,241,241,241,232,228,222,220,218,216,216,211,209
  DEFB 206,200,193,191,188,190,195,204,218,179,175,171,167,167,161,154
  DEFB 150,142,134,127,126,206,218,114,108,114,100,94,188,161,81,76
  DEFB 68,63,58,204,114,49,167,161,37,29,23,19,191,5,0,114
  DEFB 249,243,236,228,220,212,134,203,196,188,180,172,165,158,152,144
  DEFB 139,134,126,120,118,134,126,110,104,98,91,195,85,79,71,65
  DEFB 58,50,47,40,35,33

; Location descriptors (x-coordinates 22, 149, 205, 222)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the top-right edge of the roof of the
; police station (x=149).
LOCDESCS149;
  DEFB 2,12               ; y=5, z=1; down/left, down/right
; The next descriptor corresponds to the rightmost edges on the top floor of
; the police station (x=149), the top floor of the apartment building next to
; no. 19 (x=205), and the roof of no. 19 (x=222).
LOCDESCS205;
  DEFB 18,128             ; y=13, z=1; left
; The next descriptor corresponds to the rightmost edges on the first floor of
; the police station (x=149), the apartment building next to no. 19 (x=205),
; and no. 19 (x=222).
  DEFB 54,128             ; y=31, z=1; left
; The next descriptor corresponds to the spot just to the left of the top-right
; edge of the roof of the apartment building next to no. 74 (x=22), the spot
; just to the left of the top-right edge of the roof of the apartment building
; next to no. 19 (x=205), and the right end of the rope across the roof of no.
; 19 (x=222); the location at (x,y,z)=(149,6,1) is not accessible.
LOCDESCS22;
  DEFB 4,72               ; y=6, z=1; right, down/left
; The next descriptor corresponds to the right edge of the roof of the
; apartment building next to no. 74 (x=22), the right edge of the roof of the
; apartment building next to no. 19 (x=205), and the spot just to the left of
; the right end of the rope across the roof of no. 19 (x=222); the location at
; (x,y,z)=(149,7,1) is not accessible.
  DEFB 6,128              ; y=7, z=1; left
; The next descriptor corresponds to the rightmost edges on the third floor of
; the apartment building next to no. 74 (x=22), the police station (x=149), the
; apartment building next to no. 19 (x=205), and no. 19 (x=222).
  DEFB 30,128             ; y=19, z=1; left
; The next descriptor corresponds to the rightmost edges on the second floor of
; the apartment building next to no. 74 (x=22), the police station (x=149), the
; apartment building next to no. 19 (x=205), and no. 19 (x=222).
  DEFB 42,128             ; y=25, z=1; left
; The next descriptor corresponds to the rightmost edge of the right-hand shop
; under the apartments next to no. 74 (x=22); the locations at
; (x,y,z)=(149,33,1), (205,33,1) and (222,33,1) are not accessible.
  DEFB 58,128             ; y=33, z=1; left
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 39)
;
; Used by the routine at LOCDESCS. These descriptors correspond to locations
; inside no. 74 just to the left of the front door, and invoke the special
; location handler routine whose address is at SLHANDLER1 when a character
; moves left at these locations. However, the handler routine does nothing
; special, and therefore these descriptors are redundant.
LOCDESCS39;
  DEFB 143,194,1          ; y=19, z=1; left, right (third floor)
  DEFB 149,194,1          ; y=25, z=1; left, right (second floor)
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 92,255

; Z values (12<=y<=17)
;
; Used by the routines at PRINTTILE and WINDOWSRB. Each byte here corresponds
; to a segment of the play area that is eight tiles wide and six tiles high,
; and level with the 4th floor of a building (12<=y<=17).
  DEFB 28,34,28           ; 0<=x<24; apartment building next to no. 74
  DEFB 36                 ; 24<=x<32
  DEFB 29,28,44           ; 32<=x<56; no. 74
  DEFB 37,18,19,20,21,23  ; 56<=x<104; hotel
  DEFB 35,35              ; 104<=x<120; no. 31 (roof)
  DEFB 38                 ; 120<=x<128
  DEFB 39,40,41           ; 128<=x<152; police station
  DEFB 29                 ; 152<=x<160; no. 27
  DEFB 30,31              ; 160<=x<176
  DEFB 32,33,34,28        ; 176<=x<208; apartment building next to no. 19
  DEFB 58,35              ; 208<=x<224; no. 19 (roof)
  DEFB 28,29              ; 224<=x<240; no. 17
  DEFB 28,29              ; 240<=x<256; no. 15

; Play area tile attribute address LSBs (12<=y<=17)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high, and level with the
; 4th floor of a building (12<=y<=17).
  DEFB 4,3,6              ; 0<=x<24; apartment building next to no. 74
  DEFB 3                  ; 24<=x<32
  DEFB 7,4,8              ; 32<=x<56; no. 74
  DEFB 9,9,9,9,9,9        ; 56<=x<104; hotel
  DEFB 2,2                ; 104<=x<120; no. 31 (roof)
  DEFB 2                  ; 120<=x<128
  DEFB 10,8,10            ; 128<=x<152; police station
  DEFB 11                 ; 152<=x<160; no. 27
  DEFB 11,2               ; 160<=x<176
  DEFB 12,13,3,6          ; 176<=x<208; apartment building next to no. 19
  DEFB 8,2                ; 208<=x<224; no. 19 (roof)
  DEFB 11,11              ; 224<=x<240; no. 17
  DEFB 8,8                ; 240<=x<256; no. 15

; 4th floor window flags (12<=y<=17)
;
; Used by the routines at BYLIGHT and WINFLAGS. Each byte here corresponds to a
; segment of the play area that is eight tiles wide, and level with the 4th
; floor of a building (12<=y<=17). The 5th floor window flags are at WINFLAGS5;
; the 3rd floor window flags are at WINFLAGS3.
WINFLAGS4;
  DEFB 159,0,254          ; 0<=x<24; apartment building next to no. 74
  DEFB 0                  ; 24<=x<32; no windows here
  DEFB 152,28,21          ; 32<=x<56; no. 74
  DEFB 200,32,32,32,32,232 ; 56<=x<104; hotel
  DEFB 0,0,0              ; 104<=x<128; no windows here
  DEFB 8,0,40             ; 128<=x<152; police station
  DEFB 24                 ; 152<=x<160; no. 27
  DEFB 0,0                ; 160<=x<176; no windows here
  DEFB 24,223,0,255       ; 176<=x<208; apartment building next to no. 19
  DEFB 0,0                ; 208<=x<224; no windows here
  DEFB 222,216            ; 224<=x<240; no. 17
  DEFB 223,56             ; 240<=x<256; no. 15

; Location descriptor (x-coordinate 74)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the front
; steps of the hotel.
LOCDESCS74;
  DEFB 220,208,144        ; y=32, z=1 or 2; left, right, up/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 77)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the entrance to the hotel, at the bottom
; of the staircase leading up to the second floor.
LOCDESCS77;
  DEFB 219,208,80         ; y=31, z=1 or 2; left, right, up/right
; The next descriptor corresponds to the front steps of the hotel.
  DEFB 120,224            ; y=32, z=2; left, right, up/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 81)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the top of the staircase between the
; first and second floors of the hotel.
LOCDESCS81;
  DEFB 42,200             ; y=25, z=1; left, right, down/left
; The next two descriptors correspond to the entrance to the hotel.
  DEFB 219,204,192        ; y=31, z=1 or 2; left, right, down/left, down/right
  DEFB 120,208            ; y=32, z=2; left, right, up/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 78)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the
; staircase between the first and second floors of the hotel.
LOCDESCS78;
  DEFB 48,20              ; y=28, z=1; up/right, down/right
  DEFB 52,24              ; y=30, z=1; up/right, down/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 120,200            ; y=32, z=2; left, right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 82)
;
; Used by the routine at LOCDESCS.
;
; These descriptors correspond to the entrance to the hotel.
LOCDESCS82;
  DEFB 219,140,128        ; y=31, z=1 or 2; left, down/left, down/right
  DEFB 120,224            ; y=32, z=2; left, right, up/left
  DEFB 255                ; End marker

; Z'' values (8|x-2)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+2 (0<=N<=31).
  DEFB 255,252,250,243,241,241,241,232,227,222,219,218,216,216,211,218
  DEFB 205,199,192,190,191,190,195,204,218,179,174,171,166,166,161,153
  DEFB 149,141,133,127,125,205,218,114,107,114,100,93,188,161,80,75
  DEFB 67,62,57,204,114,28,166,161,36,28,22,18,12,4,255,114
  DEFB 248,242,235,227,219,211,133,202,195,187,179,171,164,157,151,143
  DEFB 138,133,125,143,138,133,115,109,104,97,91,195,84,78,70,64
  DEFB 57,49,46,39,34,33

; Location descriptors (x-coordinates 32, 57, 103, 125, 150, 207)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the step just below the top-left edge of
; the roof of the police station (x=125), and the top-left edge of the roof of
; no. 27 (x=150).
LOCDESCS125;
  DEFB 4,36               ; y=6, z=1; up/left, down/right
; The next descriptor corresponds to the far left wall on the top floor of the
; hotel (x=57), the left edge of the roof of the police station (x=125), and
; the left edge of the roof of no. 27 (x=150).
LOCDESCS57;
  DEFB 6,64               ; y=7, z=1; right
; The next descriptor corresponds to the far left wall on the fourth floor of
; the hotel (x=57), the left edge of the roof of no. 31 (x=103), the far left
; wall on the top floor of the police station (x=125), the far left wall on the
; top floor of no. 27 (x=150), and the left edge of the roof of no. 19 (x=207).
LOCDESCS103;
  DEFB 18,64              ; y=13, z=1; right
; The next descriptor corresponds to the far left wall on the third floor of
; no. 74 (x=32), the hotel (x=57), no. 31 (x=103), the police station (x=125),
; no. 27 (x=150), and no. 19 (x=207).
LOCDESCS32;
  DEFB 30,64              ; y=19, z=1; right
; The next descriptor corresponds to the far left wall on the second floor of
; no. 74 (x=32), the hotel (x=57), no. 31 (x=103), the police station (x=125),
; no. 27 (x=150), and no. 19 (x=207).
  DEFB 42,64              ; y=25, z=1; right
; The next descriptor corresponds to the far left wall on the first floor of
; no. 74 (x=32), the far left wall of the inaccessible left-hand room on the
; first floor of the hotel (x=57), the far left wall on the first floor of no.
; 31 (x=103), the far left wall of the left-hand jail cell in the police
; station (x=125), the far left wall on the first floor of no. 27 (x=150), and
; the far left wall on the first floor of no. 19 (x=207).
  DEFB 54,64              ; y=31, z=1; right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinates 53, 62, 100, 254)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to a location on the front steps of no. 15
; (x=254) which is not accessible; this descriptor is therefore redundant.
LOCDESCS254;
  DEFB 122,168            ; y=33, z=2; left, up/left, down/left
; The next descriptor corresponds to the far right wall on the top floor of the
; hotel (x=100), and the rightmost edge of the roof of no. 15 (x=254).
LOCDESCS100;
  DEFB 6,128              ; y=7, z=1; left
; The next descriptor corresponds to the far right walls on the fourth floor of
; no. 74 (x=53), the hotel (x=100), and no. 15 (x=254).
LOCDESCS53;
  DEFB 18,128             ; y=13, z=1; left
; The next descriptor corresponds to the far right walls on the third floor of
; no. 74 (x=53), the hotel (x=100), and no. 15 (x=254).
  DEFB 30,128             ; y=19, z=1; left
; The next descriptor corresponds to the far right walls on the second floor of
; no. 74 (x=53), the hotel (x=100), and no. 15 (x=254).
  DEFB 42,128             ; y=25, z=1; left
; The next descriptor corresponds to the far right wall on the first floor of
; no. 74 (x=53), the wall on the right in the inaccessible left-hand room on
; the first floor of the hotel (x=62), the wall on the right in the
; inaccessible right-hand room on the first floor of the hotel (x=100), and the
; far right wall on the first floor of no. 15 (x=254).
LOCDESCS62;
  DEFB 54,128             ; y=31, z=1; left
; This block of location descriptors is implicitly terminated by the page
; boundary.

; Z values (18<=y<=23)
;
; Used by the routines at PRINTTILE and WINDOWSRB. Each byte here corresponds
; to a segment of the play area that is eight tiles wide and six tiles high,
; and level with the 3rd floor of a building (18<=y<=23).
  DEFB 28,34,28           ; 0<=x<24; apartment building next to no. 74
  DEFB 50                 ; 24<=x<32
  DEFB 29,28,44           ; 32<=x<56; no. 74
  DEFB 37,18,19,20,21,51  ; 56<=x<104; hotel
  DEFB 49,49              ; 104<=x<120; no. 31
  DEFB 38                 ; 120<=x<128
  DEFB 52,53,41           ; 128<=x<152; police station
  DEFB 44                 ; 152<=x<160; no. 27
  DEFB 45,46              ; 160<=x<176
  DEFB 47,48,34,28        ; 176<=x<208; apartment building next to no. 19
  DEFB 71,71              ; 208<=x<224; no. 19
  DEFB 28,44              ; 224<=x<240; no. 17
  DEFB 28,44              ; 240<=x<256; no. 15

; Play area tile attribute address LSBs (18<=y<=23)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high, and level with the
; 3rd floor of a building (18<=y<=23).
  DEFB 8,3,13             ; 0<=x<24; apartment building next to no. 74
  DEFB 14                 ; 24<=x<32
  DEFB 4,8,4              ; 32<=x<56; no. 74
  DEFB 15,15,15,15,15,15  ; 56<=x<104; hotel
  DEFB 4,4                ; 104<=x<120; no. 31
  DEFB 2                  ; 120<=x<128
  DEFB 2,8,4              ; 128<=x<152; police station
  DEFB 3                  ; 152<=x<160; no. 27
  DEFB 11,2               ; 160<=x<176
  DEFB 6,16,3,12          ; 176<=x<208; apartment building next to no. 19
  DEFB 17,18              ; 208<=x<224; no. 19
  DEFB 13,13              ; 224<=x<240; no. 17
  DEFB 2,2                ; 240<=x<256; no. 15

; 3rd floor window flags (18<=y<=23)
;
; Used by the routines at BYLIGHT and WINFLAGS. Each byte here corresponds to a
; segment of the play area that is eight tiles wide, and level with the 3rd
; floor of a building (18<=y<=23). The 4th floor window flags are at WINFLAGS4;
; the 2nd floor window flags are at WINFLAGS2.
WINFLAGS3;
  DEFB 60,0,190           ; 0<=x<24; apartment building next to no. 74
  DEFB 0                  ; 24<=x<32; no windows here
  DEFB 184,28,53          ; 32<=x<56; no. 74
  DEFB 200,0,0,0,0,200    ; 56<=x<104; hotel
  DEFB 254,159            ; 104<=x<120; no. 31
  DEFB 0                  ; 120<=x<128; no windows here
  DEFB 200,0,136          ; 128<=x<152; police station
  DEFB 20                 ; 152<=x<160; no. 27
  DEFB 0,0                ; 160<=x<176; no windows here
  DEFB 56,255,0,95        ; 176<=x<208; apartment building next to no. 19
  DEFB 72,72              ; 208<=x<224; no. 19
  DEFB 158,23             ; 224<=x<240; no. 17
  DEFB 223,52             ; 240<=x<256; no. 15

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 12,40              ; y=10, z=1; up/left, down/left

; Location descriptors (x-coordinate 92)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircase between the fourth and top
; floors of the hotel.
LOCDESCS92;
  DEFB 12,40              ; y=10, z=1; up/left, down/left
; The next descriptor corresponds to the staircase between the second and third
; floors of the hotel.
  DEFB 36,40              ; y=22, z=1; up/left, down/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 204,255,193,1
  DEFB 137,193,1          ; y=13, z=1; left, right
  DEFB 143,193,1          ; y=19, z=1; left, right
  DEFB 149,193,1          ; y=25, z=1; left, right
  DEFB 155,193,1          ; y=31, z=1; left, right
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 83)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the front
; steps of the hotel.
LOCDESCS83;
  DEFB 220,224,96         ; y=32, z=1 or 2; left, right, up/left
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 86)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the front
; steps of the hotel.
LOCDESCS86;
  DEFB 220,192,128        ; y=32, z=1 or 2; left, right
  DEFB 255                ; End marker

; Z'' values (8|x-3)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+3 (0<=N<=31).
  DEFB 255,252,250,242,240,238,241,232,226,222,218,218,216,216,211,218
  DEFB 204,198,192,190,190,189,195,203,218,179,173,171,165,165,160,152
  DEFB 148,140,132,127,125,204,218,113,106,113,99,92,188,87,79,74
  DEFB 66,61,56,203,113,48,165,43,35,27,21,17,11,3,254,113
  DEFB 247,241,234,226,218,210,132,201,194,186,178,170,163,156,150,142
  DEFB 137,132,124,142,137,132,114,108,104,96,91,195,83,77,69,63
  DEFB 56,232,45,38,34,33

; Location descriptors (x-coordinates 43, 115, 211)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircase between the third and
; fourth floors of no. 74 (x=43), the staircase leading up to the roof of no.
; 31 (x=115), and the staircase leading up to the roof of no. 19 (x=211).
LOCDESCS43;
  DEFB 24,36              ; y=16, z=1; up/left, down/right
; The next descriptor is identical to the first one, and is therefore
; redundant.
  DEFB 24,36              ; y=16, z=1; up/left, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 74 (x=43), no. 31 (x=115), and no. 19 (x=211).
  DEFB 36,24              ; y=22, z=1; up/right, down/left
; The next descriptor corresponds to the tops of the staircases between the
; first and second floors of no. 74 (x=43), no. 31 (x=115), and no. 19 (x=211).
  DEFB 42,196             ; y=25, z=1; left, right, down/right
; The next three descriptors correspond to the front doors of no. 74 (x=43),
; no. 31 (x=115) and no. 19 (x=211).
  DEFB 219,220,209        ; y=31, z=1 or 2; left, right, up/right, down/left,
                          ; down/right (door open)
  DEFB 54,208             ; y=31, z=1; left, right, up/right (inside, door
                          ; closed)
  DEFB 118,204            ; y=31, z=2; left, right, down/left, down/right
                          ; (outside, door closed)
; The next descriptor corresponds to the front steps of no. 74 (x=43), no. 31
; (x=115) and no. 19 (x=211).
  DEFB 120,252            ; y=32, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
; The next descriptor also corresponds to the front steps of no. 74 (x=43), no.
; 31 (x=115) and no. 19 (x=211).
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 1,255,172,255
  DEFB 122,76             ; y=33, z=2; right, down/left, down/right

; Z values (24<=y<=29)
;
; Used by the routines at PRINTTILE and WINDOWSRB. Each byte here corresponds
; to a segment of the play area that is eight tiles wide and six tiles high,
; and level with the 2nd floor of a building (24<=y<=29).
  DEFB 28,34,28           ; 0<=x<24; apartment building next to no. 74
  DEFB 59                 ; 24<=x<32
  DEFB 29,28,44           ; 32<=x<56; no. 74
  DEFB 37,18,60,61,21,51  ; 56<=x<104; hotel
  DEFB 57,57              ; 104<=x<120; no. 31
  DEFB 62                 ; 120<=x<128
  DEFB 63,64,41           ; 128<=x<152; police station
  DEFB 54                 ; 152<=x<160; no. 27
  DEFB 55,56              ; 160<=x<176
  DEFB 47,48,34,28        ; 176<=x<208; apartment building next to no. 19
  DEFB 71,71              ; 208<=x<224; no. 19
  DEFB 28,54              ; 224<=x<240; no. 17
  DEFB 28,54              ; 240<=x<256; no. 15

; Play area tile attribute address LSBs (24<=y<=29)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high, and level with the
; 2nd floor of a building (24<=y<=29).
  DEFB 10,3,12            ; 0<=x<24; apartment building next to no. 74
  DEFB 11                 ; 24<=x<32
  DEFB 8,7,7              ; 32<=x<56; no. 74
  DEFB 19,19,19,19,19,19  ; 56<=x<104; hotel
  DEFB 7,2                ; 104<=x<120; no. 31
  DEFB 2                  ; 120<=x<128
  DEFB 8,8,7              ; 128<=x<152; police station
  DEFB 6                  ; 152<=x<160; no. 27
  DEFB 11,2               ; 160<=x<176
  DEFB 16,12,3,13         ; 176<=x<208; apartment building next to no. 19
  DEFB 2,4                ; 208<=x<224; no. 19
  DEFB 6,6                ; 224<=x<240; no. 17
  DEFB 7,7                ; 240<=x<256; no. 15

; 2nd floor window flags (24<=y<=29)
;
; Used by the routines at BYLIGHT and WINFLAGS. Each byte here corresponds to a
; segment of the play area that is eight tiles wide, and level with the 2nd
; floor of a building (24<=y<=29). The 3rd floor window flags are at WINFLAGS3;
; the 1st floor window flags are at WINFLAGS1.
WINFLAGS2;
  DEFB 29,0,222           ; 0<=x<24; apartment building next to no. 74
  DEFB 0                  ; 24<=x<32; no windows here
  DEFB 152,28,22          ; 32<=x<56; no. 74
  DEFB 200,0,0,0,0,168    ; 56<=x<104; hotel
  DEFB 125,93             ; 104<=x<120; no. 31
  DEFB 0                  ; 120<=x<128; no windows here
  DEFB 136,0,136          ; 128<=x<152; police station
  DEFB 24                 ; 152<=x<160; no. 27
  DEFB 0,0                ; 160<=x<176; no windows here
  DEFB 24,255,0,28        ; 176<=x<208; apartment building next to no. 19
  DEFB 72,104             ; 208<=x<224; no. 19
  DEFB 158,216            ; 224<=x<240; no. 17
  DEFB 223,56             ; 240<=x<256; no. 15

; Unused
;
; These bytes are probably remnants of location descriptor tables.
  DEFB 46,24              ; y=27, z=1; up/right, down/left
  DEFB 48,40              ; y=28, z=1; up/left, down/left
  DEFB 50,36              ; y=29, z=1; up/left, down/right
  DEFB 255                ; End marker
  DEFB 44,24              ; y=26, z=1; up/right, down/left
  DEFB 52,36              ; y=30, z=1; up/left, down/right
  DEFB 120,208            ; y=32, z=2; left, right, up/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 75)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the entrance
; to the hotel.
LOCDESCS75;
  DEFB 219,76,64          ; y=31, z=1 or 2; right, down/left, down/right
  DEFB 120,208            ; y=32, z=2; left, right, up/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of location descriptor tables.
  DEFB 255
  DEFB 122,140            ; y=33, z=2; left, down/left, down/right
  DEFB 255                ; End marker
  DEFB 44,36              ; y=26, z=1; up/left, down/right
  DEFB 48,24              ; y=28, z=1; up/right, down/left
  DEFB 52,36              ; y=30, z=1; up/left, down/right
  DEFB 255                ; End marker
  DEFB 0

; Z'' values (8|x-4)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+4 (0<=N<=31).
  DEFB 255,252,249,241,239,237,241,232,225,222,218,218,216,216,216,218
  DEFB 204,197,191,190,190,188,195,204,181,178,172,171,168,188,159,218
  DEFB 147,139,131,127,124,204,118,114,105,114,100,91,168,86,78,73
  DEFB 65,64,55,204,114,29,46,42,34,30,20,16,10,2,253,114
  DEFB 246,240,233,225,217,209,208,200,193,185,177,169,162,155,149,142
  DEFB 137,131,123,142,137,117,113,107,103,95,91,195,82,76,68,62
  DEFB 55,232,44,250,34,33

; Location descriptors (x-coordinates 42, 114, 210)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the top of the staircase between the
; third and fourth floors of no. 74 (x=42), the top of the staircase leading up
; to the roof of no. 31 (x=114), and the top of the staircase leading up to the
; roof of no. 19 (x=210).
LOCDESCS42;
  DEFB 18,200             ; y=13, z=1; left, right, down/left
; The next descriptor corresponds to the staircase between the third and fourth
; floors of no. 74 (x=42), the staircase leading up to the roof of no. 31
; (x=114), and the staircase leading up to the roof of no. 19 (x=210).
  DEFB 22,36              ; y=15, z=1; up/left, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 74 (x=42), no. 31 (x=114), and no. 19 (x=210).
  DEFB 38,24              ; y=23, z=1; up/right, down/left
; The next two descriptors correspond to the front doors of no. 74 (x=42), no.
; 31 (x=114) and no. 19 (x=210).
  DEFB 219,204,193        ; y=31, z=1 or 2; left, right, down/left, down/right
                          ; (door open)
  DEFB 118,204            ; y=31, z=2; left, right, down/left, down/right
                          ; (outside, door closed)
; The next descriptor corresponds to the front steps of no. 74 (x=42), no. 31
; (x=114) and no. 19 (x=210).
  DEFB 120,252            ; y=32, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
; The next descriptor also corresponds to the front steps of no. 74 (x=42), no.
; 31 (x=114) and no. 19 (x=210).
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
; The next descriptor corresponds to the bottoms of the staircases between the
; second and third floors of no. 74 (x=42), no. 31 (x=114), and no. 19 (x=210).
  DEFB 42,224             ; y=25, z=1; left, right, up/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 252,255,252,255

; Location descriptor (x-coordinate 71)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the front
; steps of the hotel.
LOCDESCS71;
  DEFB 220,192,64         ; y=32, z=1 or 2; left, right
  DEFB 255                ; End marker

; Z values (30<=y<=35)
;
; Used by the routines at PRINTTILE, LOCDESCS, MOVEDOOR, WINDOWSRB and
; PREPGAME. Each byte here corresponds to a segment of the play area that is
; eight tiles wide and six tiles high, and level with the 1st floor of a
; building (30<=y<=35).
ZVALUES1;
  DEFB 84,70,84           ; 0<=x<24; apartment building next to no. 74
  DEFB 72                 ; 24<=x<32
  DEFB 65,86,65           ; 32<=x<56; no. 74
  DEFB 37,73,74,75,76,51  ; 56<=x<104; hotel
  DEFB 65,86              ; 104<=x<120; no. 31
  DEFB 77                 ; 120<=x<128
  DEFB 42,43,41           ; 128<=x<152; police station
  DEFB 85                 ; 152<=x<160; no. 27
  DEFB 66,67              ; 160<=x<176
  DEFB 68,69,70,65        ; 176<=x<208; apartment building next to no. 19
  DEFB 86,71              ; 208<=x<224; no. 19
  DEFB 84,85              ; 224<=x<240; no. 17
  DEFB 84,85              ; 240<=x<256; no. 15

; Play area tile attribute address LSBs (30<=y<=35)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high, and level with the
; 1st floor of a building (30<=y<=35).
  DEFB 20,3,21            ; 0<=x<24; apartment building next to no. 74
  DEFB 3                  ; 24<=x<32
  DEFB 8,4,8              ; 32<=x<56; no. 74
  DEFB 5,22,23,23,24,5    ; 56<=x<104; hotel
  DEFB 8,7                ; 104<=x<120; no. 31
  DEFB 17                 ; 120<=x<128
  DEFB 2,2,2              ; 128<=x<152; police station
  DEFB 11                 ; 152<=x<160; no. 27
  DEFB 11,2               ; 160<=x<176
  DEFB 3,6,3,16           ; 176<=x<208; apartment building next to no. 19
  DEFB 18,10              ; 208<=x<224; no. 19
  DEFB 26,6               ; 224<=x<240; no. 17
  DEFB 21,7               ; 240<=x<256; no. 15

; 1st floor window flags (30<=y<=35)
;
; Used by the routines at BYLIGHT and WINFLAGS. Each byte here corresponds to a
; segment of the play area that is eight tiles wide, and level with the 1st
; floor of a building (30<=y<=35). The 2nd floor window flags are at WINFLAGS2;
; the window flags for y-coordinate range 36-41 are at WINFLAGS0.
WINFLAGS1;
  DEFB 12,0,44            ; 0<=x<24; apartment building next to no. 74
  DEFB 0                  ; 24<=x<32; no windows here
  DEFB 93,64,93           ; 32<=x<56; no. 74 (windows and a house number sign)
  DEFB 200,0,0,0,0,136    ; 56<=x<104; hotel
  DEFB 222,0              ; 104<=x<120; no. 31 (windows and a house number
                          ; sign)
  DEFB 0                  ; 120<=x<128; no windows here
  DEFB 72,0,104           ; 128<=x<152; police station
  DEFB 128                ; 152<=x<160; no. 27 (windows and a house number
                          ; sign)
  DEFB 0,0                ; 160<=x<176; no windows here
  DEFB 0,223,0,28         ; 176<=x<208; apartment building next to no. 19
  DEFB 128,72             ; 208<=x<224; no. 19 (windows and a house number
                          ; sign)
  DEFB 46,64              ; 224<=x<240; no. 17 (windows and a house number
                          ; sign)
  DEFB 14,32              ; 240<=x<256; no. 15 (windows and a house number
                          ; sign)

; Location descriptors (x-coordinates 126, 151, 182, 183)
;
; Used by the routine at LOCDESCS.
;
; The first four descriptors correspond to the fire escape on the apartment
; building next to no. 19 (x=182).
LOCDESCS182;
  DEFB 4,140              ; y=6, z=1; left, down/left, down/right (roof)
  DEFB 78,200             ; y=11, z=2; left, right, down/left (top floor)
  DEFB 90,200             ; y=17, z=2; left, right, down/left (third floor)
  DEFB 102,200            ; y=23, z=2; left, right, down/left (second floor)
; The next descriptor corresponds to the first step up towards the top-left
; edge of the roof of the police station (x=126), the step up to the top-left
; edge of the roof of no. 27 (x=151), and the steps up to the fire escape on
; the roof of the apartment building next to no. 19 (x=182, 183).
LOCDESCS126;
  DEFB 6,224              ; y=7, z=1; left, right, up/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of location descriptor tables.
  DEFB 42,200             ; y=25, z=1; left, right, down/left
  DEFB 50,20              ; y=29, z=1; up/right, down/right
  DEFB 255                ; End marker
  DEFB 46,40              ; y=27, z=1; up/left, down/left
  DEFB 54,224             ; y=31, z=1; left, right, up/left
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 118)
;
; Used by the routine at LOCDESCS.  This descriptor corresponds to the
; top-right edge of the roof of no. 31. It is used to check whether Sam is
; going to step off the roof (see SLHANDLER5).
LOCDESCS118;
  DEFB 135,73,5           ; y=11, z=1; right, down/left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 172,255

; Location descriptor (x-coordinate 124)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the top-left
; edge of the roof of the police station. It is used to check whether Sam is
; going to step off the roof (see SLHANDLER4).
LOCDESCS124;
  DEFB 129,134,4          ; y=5, z=1; left, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Z'' values (8|x-5)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+5 (0<=N<=31).
  DEFB 255,252,248,241,239,236,241,231,224,222,218,218,215,216,216,218
  DEFB 203,196,190,189,190,188,195,184,180,177,179,171,164,188,158,218
  DEFB 146,138,130,127,123,203,117,112,104,112,98,90,164,85,77,72
  DEFB 138,60,54,184,112,47,45,41,33,26,127,15,9,1,117,112
  DEFB 245,239,232,224,216,138,207,199,192,184,176,168,161,117,148,142
  DEFB 137,130,122,142,137,116,112,106,102,94,91,195,81,75,68,61
  DEFB 54,232,43,250,34,33

; Location descriptors (x-coordinates 41, 113, 209)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircase between the third and
; fourth floors of no. 74 (x=41), the staircase leading up to the roof of no.
; 31 (x=113), and the staircase leading up to the roof of no. 19 (x=209).
LOCDESCS41;
  DEFB 20,20              ; y=14, z=1; up/right, down/right
; The next descriptor corresponds to the top of the front steps of no. 74
; (x=41), no. 31 (x=113) and no. 19 (x=209).
  DEFB 118,76             ; y=31, z=2; right, down/left, down/right
; The next descriptor corresponds to the front steps of no. 74 (x=41), no. 31
; (x=113) and no. 19 (x=209).
  DEFB 120,220            ; y=32, z=2; left, right, up/right, down/left,
                          ; down/right
; The next descriptor also corresponds to the front steps of no. 74 (x=41), no.
; 31 (x=113) and no. 19 (x=209).
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 74 (x=41), no. 31 (x=113), and no. 19 (x=209).
  DEFB 40,20              ; y=24, z=1; up/right, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of location descriptor tables.
  DEFB 120,252            ; y=32, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker
  DEFB 42,196             ; y=25, z=1; left, right, down/right
  DEFB 219,220,208        ; y=31, z=1 or 2; left, right, up/right, down/left,
                          ; down/right
  DEFB 120,224            ; y=32, z=2; left, right, up/left
  DEFB 255                ; End marker
  DEFB 255,255

; Z values (36<=y<=41)
;
; Used by the routines at PRINTTILE, MOVEDOOR and PREPGAME. Each byte here
; corresponds to a segment of the play area that is eight tiles wide and six
; tiles high.
ZVALUES0;
  DEFB 83,93,83           ; 0<=x<24; apartment building next to no. 74
  DEFB 96                 ; 24<=x<32
  DEFB 88,95,88           ; 32<=x<56; no. 74
  DEFB 97,99,100,101,2,7  ; 56<=x<104; hotel
  DEFB 88,95              ; 104<=x<120; no. 31
  DEFB 17                 ; 120<=x<128
  DEFB 22,98,91           ; 128<=x<152; police station
  DEFB 78                 ; 152<=x<160; no. 27
  DEFB 87,90              ; 160<=x<176
  DEFB 89,92,93,88        ; 176<=x<208; apartment building next to no. 19
  DEFB 95,94              ; 208<=x<224; no. 19
  DEFB 83,78              ; 224<=x<240; no. 17
  DEFB 83,78              ; 240<=x<256; no. 15

; Play area tile attribute address LSBs (36<=y<=41)
;
; Used by the routine at PRINTTILE. Each byte here corresponds to a segment of
; the play area that is eight tiles wide and six tiles high.
  DEFB 17,25,2            ; 0<=x<24; apartment building next to no. 74
  DEFB 2                  ; 24<=x<32
  DEFB 2,2,2              ; 32<=x<56; no. 74
  DEFB 0,0,0,0,0,0        ; 56<=x<104; hotel
  DEFB 2,2                ; 104<=x<120; no. 31
  DEFB 2                  ; 120<=x<128
  DEFB 2,2,2              ; 128<=x<152; police station
  DEFB 25                 ; 152<=x<160; no. 27
  DEFB 25,25              ; 160<=x<176
  DEFB 2,7,25,25          ; 176<=x<208; apartment building next to no. 19
  DEFB 2,2                ; 208<=x<224; no. 19
  DEFB 27,25              ; 224<=x<240; no. 17
  DEFB 2,2                ; 240<=x<256; no. 15

; Window flags (36<=y<=41)
;
; Used by the routine at WINFLAGS. Since there are no windows between
; y-coordinates 36 and 41, these window flag bytes are always 0. The window
; flags for the previous range of y-coordinates (30-35, corresponding to the
; 1st floor windows) are at WINFLAGS1.
WINFLAGS0;
  DEFS 32

; Location descriptors (x-coordinates 45, 117, 213)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the step leading up to the top-right edge
; of the roof of no. 31 (x=117).
LOCDESCS117;
  DEFB 16,24              ; y=12, z=1; up/right, down/left
; The next four descriptors correspond to the far right side of no. 31 (x=117).
  DEFB 18,128             ; y=13, z=1; left (roof)
  DEFB 30,128             ; y=19, z=1; left (top floor)
  DEFB 42,128             ; y=25, z=1; left (second floor)
  DEFB 54,128             ; y=31, z=1; left (first floor)
; The next descriptor corresponds to the staircase between the third and fourth
; floors of no. 74 (x=45), the staircase leading up to the roof of no. 31
; (x=117), and the staircase leading up to the roof of no. 19 (x=213).
LOCDESCS45;
  DEFB 28,40              ; y=18, z=1; up/left, down/left
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 74 (x=45), no. 31 (x=117) and no. 19 (x=213).
  DEFB 32,40              ; y=20, z=1; up/left, down/left
; The next descriptor corresponds to the staircases between the first and
; second floors of no. 74 (x=45), no. 31 (x=117) and no. 19 (x=213).
  DEFB 46,40              ; y=27, z=1; up/left, down/left
; The next descriptor also corresponds to the staircases between the first and
; second floors of no. 74 (x=45), no. 31 (x=117) and no. 19 (x=213).
  DEFB 50,40              ; y=29, z=1; up/left, down/left
; The next descriptor corresponds to the front steps of no. 74 (x=45), no. 31
; (x=117) and no. 19 (x=213).
  DEFB 120,168            ; y=32, z=2; left, up/left, down/left
; The next descriptor also corresponds to the front steps of no. 74 (x=45), no.
; 31 (x=117) and no. 19 (x=213).
  DEFB 122,172            ; y=33, z=2; left, up/left, down/left, down/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 135)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircase between the first and
; second floors of the police station.
LOCDESCS135;
  DEFB 50,20              ; y=29, z=1; up/right, down/right
; The next descriptor corresponds to a location beside the entrance to the
; police station that is not accessible; it is therefore redundant.
  DEFB 118,68             ; y=31, z=2; right, down/right
; The next two descriptors correspond to the front steps of the police station.
  DEFB 120,68             ; y=32, z=2; right, down/right
  DEFB 122,92             ; y=33, z=2; right, up/right, down/left, down/right
  DEFB 255                ; End marker

; Z'' values (8|x-6)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+6 (0<=N<=31).
  DEFB 255,252,247,241,241,235,234,230,223,222,218,218,214,216,216,218
  DEFB 204,195,190,188,189,192,187,183,179,177,179,170,163,188,157,218
  DEFB 145,137,129,127,122,204,188,111,188,103,97,89,163,84,218,71
  DEFB 137,59,53,183,111,188,44,40,32,25,127,14,8,189,188,252
  DEFB 188,238,231,223,215,137,206,198,191,183,175,167,160,188,147,142
  DEFB 137,129,188,142,137,129,188,80,101,93,90,88,85,74,67,60
  DEFB 53,232,42,250,34,32

; Location descriptors (x-coordinates 44, 116, 212)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the first step leading up to the
; top-right edge of the roof of no. 31 (x=116).
LOCDESCS116;
  DEFB 18,208             ; y=13, z=1; left, right, up/right
; The next descriptor corresponds to the staircase between the third and fourth
; floors of no. 74 (x=44), the staircase leading up to the roof of no. 31
; (x=116), and the staircase leading up to the roof of no. 19 (x=212).
LOCDESCS44;
  DEFB 26,36              ; y=17, z=1; up/left, down/right
; The next descriptor corresponds to the bottom of the staircase between the
; third and fourth floors of no. 74 (x=44), the bottom of the staircase leading
; up to the roof of no. 31 (x=116), and the bottom of the staircase leading up
; to the roof of no. 19 (x=212).
  DEFB 30,212             ; y=19, z=1; left, right, up/right, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 74 (x=44), no. 31 (x=116), and no. 19 (x=212).
  DEFB 34,24              ; y=21, z=1; up/right, down/left
; The next descriptor is identical to the one above, and is therefore
; redundant.
  DEFB 34,24              ; y=21, z=1; up/right, down/left
; The next descriptor corresponds to the staircases between the first and
; second floors of no. 74 (x=44), no. 31 (x=116), and no. 19 (x=212).
  DEFB 44,36              ; y=26, z=1; up/left, down/right
; The next descriptor also corresponds to the staircases between the first and
; second floors of no. 74 (x=44), no. 31 (x=116), and no. 19 (x=212).
  DEFB 48,20              ; y=28, z=1; up/right, down/right
; The next descriptor also corresponds to the staircases between the first and
; second floors of no. 74 (x=44), no. 31 (x=116), and no. 19 (x=212).
  DEFB 52,24              ; y=30, z=1; up/right, down/left
; The next descriptor corresponds to the top of the front steps of no. 74
; (x=44), no. 31 (x=116) and no. 19 (x=212).
  DEFB 118,140            ; y=31, z=2; left, down/left, down/right
; The next descriptor corresponds to the front steps of no. 74 (x=44), no. 31
; (x=116) and no. 19 (x=212).
  DEFB 120,236            ; y=32, z=2; left, right, up/left, down/left,
                          ; down/right
; The next descriptor also corresponds to the front steps of no. 74 (x=44), no.
; 31 (x=116) and no. 19 (x=212).
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 133)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the location
; just behind the door of the left-hand jail cell on the first floor of the
; police station. It is used to check whether Sam can leave the cell (see
; SLHANDLER7).
LOCDESCS133;
  DEFB 155,193,7          ; y=31, z=1; left, right
; This block of location descriptors is implicitly terminated by the page
; boundary.

; Z' values
;
; Used by the routines at PRINTTILE and WINDOWSRB. Each Z' value is used by one
; or more segments of the play area (a segment being six tiles high and eight
; tiles wide).
;
; The first Z' value is used by the segments at (0,0), (8,0), (16,0), (24,0),
; (32,0), (40,0), (48,0), (104,0), (112,0), (120,0), (128,0), (136,0), (144,0),
; (152,0), (160,0), (168,0), (176,0), (184,0), (192,0), (200,0), (208,0),
; (216,0), (224,0), (232,0), (240,0) and (248,0).
Z1VALUES;
  DEFB 255
; The next Z' value is used by the segment at (56,0).
  DEFB 255
; The next Z' value is used by the segment at (88,36).
  DEFB 255
; The next four Z' values are used by the segments at (64,0), (72,0), (80,0)
; and (88,0).
  DEFB 255,255,255,255
; The next Z' value is used by the segment at (96,36).
  DEFB 255
; The next Z' value is used by the segment at (96,0).
  DEFB 255
; The next Z' value is used by the segments at (32,6), (40,6), (48,6), (152,6),
; (208,6), (216,6), (224,6), (232,6), (240,6) and (248,6).
  DEFB 255
; The next Z' value is used by the segment at (160,6).
  DEFB 255
; The next Z' value is used by the segments at (104,6), (112,6), (168,6),
; (208,6) and (216,6).
  DEFB 255
; The next Z' value is used by the segment at (176,6).
  DEFB 255
; The next Z' value is used by the segments at (0,6), (16,6), (184,6) and
; (200,6).
  DEFB 255
; The next Z' value is used by the segments at (8,6) and (192,6).
  DEFB 255
; The next Z' value is used by the segment at (24,6).
  DEFB 255
; The next Z' value is used by the segment at (56,6).
  DEFB 255
; The next Z' value is used by the segment at (120,36).
  DEFB 255
; The next Z' value is used by the segments at (64,6), (64,12), (64,18) and
; (64,24).
  DEFB 255
; The next Z' value is used by the segments at (72,6), (72,12) and (72,18).
  DEFB 255
; The next Z' value is used by the segments at (80,6), (80,12) and (80,18).
  DEFB 255
; The next Z' value is used by the segments at (88,6), (88,12), (88,18) and
; (88,24).
  DEFB 255
; The next Z' value is used by the segment at (128,36).
  DEFB 255
; The next Z' value is used by the segments at (96,6) and (96,12).
  DEFB 255
; The next four Z' values are used by the segments at (120,6), (128,6), (136,6)
; and (144,6).
  DEFB 255,255,255,255
; The next Z' value is used by the segments at (0,12), (0,18), (0,24), (16,12),
; (16,18), (16,24), (40,12), (40,18), (40,24), (200,12), (200,18), (200,24),
; (224,12), (224,18), (224,24), (240,12), (240,18) and (240,24).
  DEFB 255
; The next Z' value is used by the segments at (32,12), (32,18), (32,24),
; (152,12), (232,12) and (248,12).
  DEFB 255
; The next four Z' values are used by the segments at (160,12), (168,12),
; (176,12) and (184,12).
  DEFB 255,255,255,255
; The next Z' value is used by the segments at (8,12), (8,18), (8,24),
; (192,12), (192,18) and (192,24).
  DEFB 255
; The next Z' value is used by the segments at (104,12), (112,12) and (216,12).
  DEFB 255
; The next Z' value is used by the segment at (24,12).
  DEFB 255
; The next Z' value is used by the segments at (56,12), (56,18), (56,24) and
; (56,30).
  DEFB 255
; The next Z' value is used by the segments at (120,12) and (120,18).
  DEFB 255
; The next two Z' values are used by the segments at (128,12) and (136,12).
  DEFB 255,255
; The next Z' value is used by the segments at (144,12), (144,18), (144,24) and
; (144,30).
  DEFB 255
; The next two Z' values are used by the segments at (128,30) and (136,30).
  DEFB 255,255
; The next Z' value is used by the segments at (48,12), (48,18), (48,24),
; (152,18), (232,18) and (248,18).
  DEFB 255
; The next two Z' values are used by the segments at (160,18) and (168,18).
  DEFB 255,255
; The next Z' value is used by the segments at (176,18) and (176,24).
  DEFB 255
; The next Z' value is used by the segments at (184,18) and (184,24).
  DEFB 255
; The next Z' value is used by the segments at (104,18) and (112,18).
  DEFB 255
; The next Z' value is used by the segment at (24,18).
  DEFB 255
; The next Z' value is used by the segments at (96,18), (96,24) and (96,30).
  DEFB 255
; The next two Z' values are used by the segments at (128,18) and (136,18).
  DEFB 255,215
; The next Z' value is used by the segments at (152,24), (232,24) and (248,24).
  DEFB 255
; The next two Z' values are used by the segments at (160,24) and (168,24).
  DEFB 255,255
; The next Z' value is used by the segments at (104,24) and (112,24).
  DEFB 255
; The next Z' value is used by the segment at (208,12).
  DEFB 255
; The next Z' value is used by the segment at (24,24).
  DEFB 255
; The next two Z' values are used by the segments at (72,24) and (80,24).
  DEFB 255,255
; The next three Z' values are used by the segments at (120,24), (128,24) and
; (136,24).
  DEFB 199,252,3
; The next Z' value is used by the segments at (32,30), (48,30), (104,30) and
; (200,30).
  DEFB 0
; The next four Z' values are used by the segments at (160,30), (168,30),
; (176,30) and (184,30).
  DEFB 128,0,0,7
; The next Z' value is used by the segments at (8,30) and (192,30).
  DEFB 240
; The next Z' value is used by the segments at (208,18), (208,24), (216,18),
; (216,24) and (216,30).
  DEFB 0
; The next Z' value is used by the segment at (24,30).
  DEFB 128
; The next four Z' values are used by the segments at (64,30), (72,30), (80,30)
; and (88,30).
  DEFB 0,0,0,0
; The next Z' value is used by the segment at (120,30).
  DEFB 134
; The next Z' value is used by the segments at (152,36), (232,36) and (248,36).
  DEFB 0
; The next Z' value is used by the segments at (0,36), (16,36), (224,36) and
; (240,36).
  DEFB 0
; The next Z' value is used by the segments at (0,30), (16,30), (224,30) and
; (240,30).
  DEFB 0
; The next Z' value is used by the segments at (152,30), (232,30) and (248,30).
  DEFB 0
; The next Z' value is used by the segments at (40,30), (112,30) and (208,30).
  DEFB 3
; The next Z' value is used by the segments at (0,36), (16,36), (224,36) and
; (240,36).
  DEFB 0
; The next Z' value is used by the segments at (0,30), (16,30), (224,30) and
; (240,30).
  DEFB 0
; The next Z' value is used by the segments at (152,30), (232,30) and (248,30).
  DEFB 0
; The next Z' value is used by the segments at (40,30), (112,30) and (208,30).
  DEFB 3
; The next Z' value is used by the segment at (160,36).
  DEFB 3
; The next Z' value is used by the segments at (32,36), (48,36), (104,36) and
; (200,36).
  DEFB 0
; The next Z' value is used by the segment at (176,36).
  DEFB 0
; The next Z' value is used by the segment at (168,36).
  DEFB 0
; The next Z' value is used by the segment at (144,36).
  DEFB 252
; The next Z' value is used by the segment at (184,36).
  DEFB 0
; The next Z' value is used by the segments at (8,36) and (192,36).
  DEFB 0
; The next Z' value is used by the segment at (216,36).
  DEFB 0
; The next Z' value is used by the segments at (40,36), (112,36) and (208,36).
  DEFB 0
; The next Z' value is used by the segment at (24,36).
  DEFB 128
; The next Z' value is used by the segment at (56,36).
  DEFB 31
; The next Z' value is used by the segment at (136,36).
  DEFB 1
; The next three Z' values are used by the segments at (64,36), (72,36) and
; (80,36).
  DEFB 14
  DEFB 0
  DEFB 0

; Location descriptor (x-coordinate 80)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the staircase
; between the first and second floors of the hotel.
LOCDESCS80;
  DEFB 44,24              ; y=26, z=1; up/right, down/left
  DEFB 255                ; End marker

; Unused
;
; This byte is probably a remnant of a location descriptor table.
  DEFB 255

; Location descriptor (x-coordinate 65)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the staircase
; between the second and third floors of the hotel.
LOCDESCS65;
  DEFB 24,20              ; y=16, z=1; up/right, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 204,255,194,1

; Location descriptors (x-coordinate 190)
;
; Used by the routine at LOCDESCS. These descriptors correspond to locations
; between the stairwell and the first window to the left of the stairwell on
; each floor of the apartment building next to no. 19, and invoke the special
; location handler routine whose address is at SLHANDLER1 when a character
; moves left at these locations. However, the handler routine does nothing
; special, and therefore these descriptors are redundant.
LOCDESCS190;
  DEFB 137,194,1          ; y=13, z=1; left, right (top floor)
  DEFB 143,194,1          ; y=19, z=1; left, right (third floor)
  DEFB 149,194,1          ; y=25, z=1; left, right (second floor)
  DEFB 155,194,1          ; y=31, z=1; left, right (first floor)
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 255,255

; Z'' values (8|x-7)
;
; Used by the routines at PRINTTILE and WINDOWSRB. These Z'' values correspond
; to x-coordinates 8N+7 (0<=N<=31).
  DEFB 255,252,246,241,241,241,233,229,255,222,218,218,213,216,210,208
  DEFB 202,195,190,188,191,192,186,182,179,177,179,169,165,188,156,218
  DEFB 144,136,128,127,121,202,116,110,116,102,96,88,165,83,218,70
  DEFB 136,61,52,120,51,116,188,39,31,27,127,13,7,191,116,251
  DEFB 116,237,230,222,214,136,205,197,190,182,174,181,159,154,146,141
  DEFB 136,128,188,141,136,128,188,80,100,92,89,87,85,73,72,59
  DEFB 52,232,195,37,34,31

; Location descriptors (x-coordinate 88)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the top of the staircase between the
; fourth and top floors of the hotel.
LOCDESCS88;
  DEFB 6,196              ; y=7, z=1; left, right, down/right
; The next descriptor corresponds to the top of the staircase between the
; second and third floors of the hotel.
  DEFB 30,196             ; y=19, z=1; left, right, down/right
; The next descriptor corresponds to the front steps of the hotel.
  DEFB 120,132            ; y=32, z=2; left, down/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 89)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircase between the fourth and
; top floors of the hotel.
LOCDESCS89;
  DEFB 8,96               ; y=8, z=1; right, up/left
  DEFB 18,208             ; y=13, z=1; left, right, up/right (bottom of the
                          ; staircase)
; The next two descriptors correspond to the staircase between the second and
; third floors of the hotel.
  DEFB 32,96              ; y=20, z=1; right, up/left
  DEFB 42,208             ; y=25, z=1; left, right, up/right (bottom of the
                          ; staircase)
; The next descriptor corresponds to the front steps of the hotel.
  DEFB 122,44             ; y=33, z=2; up/left, down/left, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 196,255

; Location descriptors (x-coordinate 79)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the
; staircase between the first and second floors of the hotel.
LOCDESCS79;
  DEFB 46,24              ; y=27, z=1; up/right, down/left
  DEFB 50,40              ; y=29, z=1; up/left, down/left
  DEFB 255                ; End marker

; Unused
;
; This byte is probably a remnant of a location descriptor table.
  DEFB 255

; Play area foreground tile references
;
; Used by the routine at PRINTTILE. Each byte here is the LSB of the first of a
; pair of half-tiles whose 8 graphic and mask bytes are found in pages 128-135.
; The LSBs of the second half-tiles in each pair can be found at FTILEREFS2.
FTILEREFS1;
  DEFB 0,2,0,4,2,4,0,2,19,21,22,24,22,26,4,27
  DEFB 4,29,30,32,30,4,27,22,4,30,147,146,148,0,178,152
  DEFB 92,2,92,92,2,92,92,2,95,49,96,96,96,53,92,92
  DEFB 92,57,99,99,99,92,92,96,92,99,96,92,99,0,178,152
  DEFB 7,2,0,9,2,4,78,80,81,34,35,37,35,39,40,42
  DEFB 40,44,45,47,45,40,42,83,84,86,87,88,89,91,180,154
  DEFB 92,2,92,92,2,92,98,92,112,101,96,96,96,104,105,105
  DEFB 105,108,109,109,109,105,105,113,98,92,114,115,98,92,180,154
  DEFB 0,2,0,0,2,4,116,117,118,49,51,24,22,53,55,27
  DEFB 4,57,59,32,30,55,62,163,164,165,149,150,151,157,192,182
  DEFB 92,2,92,92,2,92,119,120,122,49,96,96,96,53,92,92
  DEFB 92,57,99,99,99,92,92,167,169,171,96,92,99,0,192,182
  DEFB 12,2,12,15,2,15,123,125,126,49,50,65,67,53,54,69
  DEFB 71,57,72,74,76,54,69,172,174,176,4,187,189,187,0,0
  DEFB 92,2,92,92,2,92,160,161,162,49,96,96,96,53,92,92
  DEFB 92,57,99,99,99,92,92,0,0,0,189,188,190,191

; Unused
  DEFS 2

; Play area foreground tile references
;
; Used by the routine at PRINTTILE. Each byte here is the LSB of the second of
; a pair of half-tiles whose 8 graphic and mask bytes are found in pages
; 128-135. The LSBs of the first half-tiles in each pair can be found at
; FTILEREFS1.
FTILEREFS2;
  DEFB 1,0,3,5,4,6,17,18,20,22,23,22,25,4,6,4
  DEFB 28,30,31,30,33,6,4,22,4,30,147,146,148,0,179,153
  DEFB 92,92,56,92,92,56,93,94,20,96,52,96,97,92,56,92
  DEFB 98,99,60,99,100,56,92,96,92,99,96,92,99,0,179,153
  DEFB 8,0,3,10,4,6,79,80,82,35,36,35,38,40,41,40
  DEFB 43,45,46,45,48,41,40,83,85,86,88,88,90,91,181,155
  DEFB 92,92,56,92,92,56,92,92,113,96,102,96,103,105,106,105
  DEFB 107,109,110,109,111,106,105,113,92,92,115,115,92,92,181,155
  DEFB 1,0,3,11,4,6,116,118,118,50,52,22,25,54,56,4
  DEFB 28,58,60,30,33,61,63,164,164,166,149,150,151,157,193,183
  DEFB 92,92,56,92,92,56,120,121,123,96,52,96,97,92,56,92
  DEFB 98,99,60,99,100,56,92,168,170,128,96,92,99,0,193,183
  DEFB 13,12,14,16,15,14,124,126,127,50,64,66,25,54,68,70
  DEFB 28,58,73,75,77,68,70,173,175,177,186,186,186,187,0,0
  DEFB 92,92,56,92,92,56,160,162,162,96,52,96,97,92,56,92
  DEFB 98,99,60,99,100,56,92,0,0,0,189,4,187,189

; Unused
;
; The third byte here is probably a remnant of a location descriptor table.
  DEFB 0,0,8

; Location descriptors (x-coordinate 136)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircase leading up to the roof of
; the police station.
LOCDESCS136;
  DEFB 8,20               ; y=8, z=1; up/right, down/right
; The next descriptor corresponds to the staircase between the third and fourth
; floors of the police station.
  DEFB 20,20              ; y=14, z=1; up/right, down/right
; The next descriptor corresponds to the staircase between the second and third
; floors of the police station.
  DEFB 32,20              ; y=20, z=1; up/right, down/right
; The next three descriptors correspond to the staircase between the first and
; second floors of the police station.
  DEFB 44,20              ; y=26, z=1; up/right, down/right
  DEFB 48,24              ; y=28, z=1; up/right, down/left
  DEFB 52,36              ; y=30, z=1; up/left, down/right
; The next descriptor corresponds to a location beside the entrance to the
; police station that is not accessible; it is therefore redundant.
  DEFB 118,204            ; y=31, z=2; left, right, down/left, down/right
; The next two descriptors correspond to the front steps of the police station.
  DEFB 120,220            ; y=32, z=2; left, right, up/right, down/left,
                          ; down/right
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 137)
;
; Used by the routine at LOCDESCS.
;
; The first three descriptors correspond to the staircase leading up to the
; roof of the police station.
LOCDESCS137;
  DEFB 6,200              ; y=7, z=1; left, right, down/left (top of the
                          ; staircase)
  DEFB 10,36              ; y=9, z=1; up/left, down/right
  DEFB 18,216             ; y=13, z=1; left, right, up/right, down/left (bottom
                          ; of the staircase)
; The next two descriptors correspond to the staircase between the third and
; fourth floors of the police station.
  DEFB 22,36              ; y=15, z=1; up/left, down/right
  DEFB 30,216             ; y=19, z=1; left, right, up/right, down/left (bottom
                          ; of the staircase)
; The next two descriptors correspond to the staircase between the second and
; third floors of the police station.
  DEFB 34,36              ; y=21, z=1; up/left, down/right
  DEFB 42,216             ; y=25, z=1; left, right, up/right, down/left (bottom
                          ; of the staircase)
; The next two descriptors correspond to the staircase between the first and
; second floors of the police station.
  DEFB 46,40              ; y=27, z=1; up/left, down/left
  DEFB 219,236,224        ; y=31, z=1 or 2; left, right, up/left, down/left,
                          ; down/right (bottom of the staircase)
; The next two descriptors correspond to the front steps of the police station.
  DEFB 120,200            ; y=32, z=2; left, right, down/left
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0,0

; Location descriptors (x-coordinate 138)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircase leading up to the roof
; of the police station.
LOCDESCS138;
  DEFB 12,36              ; y=10, z=1; up/left, down/right
  DEFB 16,24              ; y=12, z=1; up/right, down/left
; The next two descriptors correspond to the staircase between the third and
; fourth floors of the police station.
  DEFB 24,36              ; y=16, z=1; up/left, down/right
  DEFB 28,24              ; y=18, z=1; up/right, down/left
; The next two descriptors correspond to the staircase between the second and
; third floors of the police station.
  DEFB 36,36              ; y=22, z=1; up/left, down/right
  DEFB 40,24              ; y=24, z=1; up/right, down/left
; The next three descriptors correspond to the front steps of the police
; station.
  DEFB 219,204,192        ; y=31, z=1 or 2; left, right, down/left, down/right
  DEFB 120,236            ; y=32, z=2; left, right, up/left, down/left,
                          ; down/right
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinate 139)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircase leading up to the roof of
; the police station.
LOCDESCS139;
  DEFB 14,40              ; y=11, z=1; up/left, down/left
; The next descriptor corresponds to the staircase between the third and fourth
; floors of the police station.
  DEFB 26,40              ; y=17, z=1; up/left, down/left
; The next descriptor corresponds to the staircase between the second and third
; floors of the police station.
  DEFB 38,40              ; y=23, z=1; up/left, down/left
; The next two descriptors correspond to the front steps of the police station.
  DEFB 120,168            ; y=32, z=2; left, up/left, down/left
  DEFB 122,172            ; y=33, z=2; left, up/left, down/left, down/right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of location descriptor tables.
XLOCDESCS;
  DEFB 0
  DEFB 120,136            ; y=32, z=2; left, down/left
  DEFB 122,172            ; y=33, z=2; left, up/left, down/left, down/right
  DEFB 255                ; End marker
  DEFB 155,194,8          ; y=31, z=1; left, right
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 148)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the step leading up to the top-right edge
; of the roof of the police station.
LOCDESCS148;
  DEFB 4,24               ; y=6, z=1; up/right, down/left
; The next descriptor corresponds to the right edge of the roof of the police
; station.
  DEFB 6,128              ; y=7, z=1; left
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 152, 232, 248)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircases between the third and
; fourth floors of no. 27 (x=152) and no. 15 (x=248).
LOCDESCS152;
  DEFB 20,20              ; y=14, z=1; up/right, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 27 (x=152), no. 17 (x=232) and no. 15 (x=248).
LOCDESCS232;
  DEFB 44,20              ; y=26, z=1; up/right, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0,0

; Location descriptors (x-coordinates 153, 233, 249)
;
; Used by the routine at LOCDESCS.
;
; The first three descriptors correspond to the staircases between the third
; and fourth floors of no. 27 (x=153) and no. 15 (x=249).
LOCDESCS153;
  DEFB 18,200             ; y=13, z=1; left, right, down/left (top of the
                          ; staircase)
  DEFB 22,36              ; y=15, z=1; up/left, down/right
  DEFB 26,20              ; y=17, z=1; up/right, down/right
; The next descriptor corresponds to the tops of the staircases between the
; first and second floors of no. 27 (x=153), no. 17 (x=233) and no. 15 (x=249).
LOCDESCS233;
  DEFB 42,200             ; y=25, z=1; left, right, down/left
; The next two descriptors correspond to the staircases between the first and
; second floors of no. 27 (x=153), no. 17 (x=233) and no. 15 (x=249).
  DEFB 46,36              ; y=27, z=1; up/left, down/right
  DEFB 50,20              ; y=29, z=1; up/right, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinates 154, 234, 250)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the bottoms of the staircases leading up
; to the roofs of no. 27 (x=154) and no. 17 (x=234).
LOCDESCS154;
  DEFB 18,208             ; y=13, z=1; left, right, up/right
; The next two descriptors correspond to the staircase between the third and
; fourth floors of no. 27 (x=154), inaccessible locations between the third and
; fourth floors of no. 17 (x=234), and the staircase between the third and
; fourth floors of no. 15 (x=250).
LOCDESCS250;
  DEFB 24,40              ; y=16, z=1; up/left, down/left
  DEFB 28,36              ; y=18, z=1; up/left, down/right
; The next descriptor corresponds to the bottoms of the staircases between the
; second and third floors of no. 27 (x=154), no. 17 (x=234) and no. 15 (x=250).
  DEFB 42,208             ; y=25, z=1; left, right, up/right
; The next two descriptors correspond to the staircases between the first and
; second floors of no. 27 (x=154), no. 17 (x=234) and no. 15 (x=250).
  DEFB 48,40              ; y=28, z=1; up/left, down/left
  DEFB 52,36              ; y=30, z=1; up/left, down/right
  DEFB 255                ; End marker

; Unused
;
; This byte is probably a remnant of a location descriptor table.
  DEFB 92

; Location descriptors (x-coordinate 155, 235, 251)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the location on the third floor of no. 17
; at which there could be (but isn't) a staircase leading up to the fourth
; floor (x=235).
LOCDESCS235;
  DEFB 30,192             ; y=19, z=1; left, right
; The next two descriptors correspond to the staircases leading up to the roofs
; of no. 27 (x=155) and no. 17 (x=235).
LOCDESCS155;
  DEFB 12,20              ; y=10, z=1; up/right, down/right
  DEFB 16,24              ; y=12, z=1; up/right, down/left
; The next descriptor corresponds to the bottoms of the staircases between the
; third and fourth floors of no. 27 (x=155) and no. 15 (x=251); the
; corresponding location in no. 17 (x=235, at which there is no staircase) is
; dealt with by the first descriptor in this block.
LOCDESCS251;
  DEFB 30,224             ; y=19, z=1; left, right, up/left
; The next two descriptors correspond to the staircases between the second and
; third floors of no. 27 (x=155), no. 17 (x=235) and no. 15 (x=251).
  DEFB 36,20              ; y=22, z=1; up/right, down/right
  DEFB 40,24              ; y=24, z=1; up/right, down/left
; The next three descriptors correspond to the front doors of no. 27 (x=155),
; no. 17 (x=235) and no. 15 (x=251).
  DEFB 219,228,225        ; y=31, z=1 or 2; left, right, up/left, down/right
                          ; (door open)
  DEFB 54,224             ; y=31, z=1; left, right, up/left (inside, door
                          ; closed)
  DEFB 118,68             ; y=31, z=2; right, down/right (outside, door closed)
; The next two descriptors correspond to the front steps of no. 27 (x=155), no.
; 17 (x=235) and no. 15 (x=251).
  DEFB 120,84             ; y=32, z=2; right, up/right, down/right
  DEFB 122,92             ; y=33, z=2; right, up/right, down/left, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinates 156, 236, 252)
;
; Used by the routine at LOCDESCS.
;
; The first three descriptors correspond to the staircases leading up to the
; roofs of no. 27 (x=156) and no. 17 (x=236).
LOCDESCS156;
  DEFB 6,196              ; y=7, z=1; left, right, down/right (top of the
                          ; staircase)
  DEFB 10,24              ; y=9, z=1; up/right, down/left
  DEFB 14,40              ; y=11, z=1; up/left, down/left
; The next descriptor is identical to the previous one, and is therefore
; redundant.
  DEFB 14,40              ; y=11, z=1; up/left, down/left
; The next descriptor corresponds to the tops of the staircases between the
; second and third floors of no. 27 (x=156), no. 17 (x=236) and no. 15 (x=252).
LOCDESCS252;
  DEFB 30,196             ; y=19, z=1; left, right, down/right (top of the
                          ; staircase)
; The next two descriptors correspond to the staircases between the second and
; third floors of no. 27 (x=156), no. 17 (x=236) and no. 15 (x=252).
  DEFB 34,24              ; y=21, z=1; up/right, down/left
  DEFB 38,40              ; y=23, z=1; up/left, down/left
; The next two descriptors correspond to the front doors of no. 27 (x=156), no.
; 17 (x=236) and no. 15 (x=252).
  DEFB 219,204,193        ; y=31, z=1 or 2; left, right, down/left, down/right
                          ; (door open)
  DEFB 118,140            ; y=31, z=2; left, down/left, down/right (outside,
                          ; door closed)
; The next two descriptors correspond to the front steps of no. 27 (x=156), no.
; 17 (x=236) and no. 15 (x=252).
  DEFB 120,236            ; y=32, z=2; left, right, up/left, down/left,
                          ; down/right
  DEFB 122,252            ; y=33, z=2; left, right, up/left, up/right,
                          ; down/left, down/right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinates 157, 237, 253)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircases leading up to the
; roofs of no. 27 (x=157) and no. 17 (x=237).
LOCDESCS157;
  DEFB 8,40               ; y=8, z=1; up/left, down/left
; The next descriptor corresponds to the staircases between the second and
; third floors of no. 27 (x=157), no. 17 (x=237) and no. 15 (x=253).
LOCDESCS253;
  DEFB 32,40              ; y=20, z=1; up/left, down/left
; The next two descriptors correspond to the front steps of no. 27 (x=157), no.
; 17 (x=237) and no. 15 (x=253).
  DEFB 120,168            ; y=32, z=2; left, up/left, down/left
  DEFB 122,172            ; y=33, z=2; left, up/left, down/left, down/right
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 158, 238)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the right edge of the roof of no. 27
; (x=158).
LOCDESCS158;
  DEFB 6,128              ; y=7, z=1; left
; The next descriptor corresponds to the far right wall on the top floors of
; no. 27 (x=158) and no. 17 (x=238).
LOCDESCS238;
  DEFB 18,128             ; y=13, z=1; left
; The next descriptor corresponds to the far right wall on the third floors of
; no. 27 (x=158) and no. 17 (x=238).
  DEFB 30,128             ; y=19, z=1; left
; The next descriptor corresponds to the far right wall on the second floors of
; no. 27 (x=158) and no. 17 (x=238).
  DEFB 42,128             ; y=25, z=1; left
; The next descriptor corresponds to the far right wall on the first floors of
; no. 27 (x=158) and no. 17 (x=238).
  DEFB 54,128             ; y=31, z=1; left
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 236,255

; Location descriptors (x-coordinate 181)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the fire
; escape on the apartment building next to no. 19.
LOCDESCS181;
  DEFB 194,204,196        ; y=6, z=1 or 2; left, right, down/left, down/right
  DEFB 6,240              ; y=7, z=1; left, right, up/left, up/right
  DEFB 80,24              ; y=12, z=2; up/right, down/left
  DEFB 92,24              ; y=18, z=2; up/right, down/left
  DEFB 104,24             ; y=24, z=2; up/right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 175)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the top-left
; edge of the roof of the apartment building next to no. 19, and the left edges
; of the fire escape on that building on the second, third and top floors. They
; are used to check whether Sam is going to step off the building at one of
; those locations (see SLHANDLER3).
;
; The first descriptor corresponds to the top-left edge of the roof of the
; apartment building next to no. 19.
LOCDESCS175;
  DEFB 130,194,3          ; y=6, z=1; left, right
; The next three descriptors correspond to the left edges of the fire escape on
; the top, third and second floors of the apartment building next to no. 19.
  DEFB 167,194,3          ; y=11, z=2; left, right (top floor)
  DEFB 173,194,3          ; y=17, z=2; left, right (third floor)
  DEFB 179,194,3          ; y=23, z=2; left, right (second floor)
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinate 177)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the step up to the top-left edge of the
; roof of the apartment building next to no. 19.
LOCDESCS177;
  DEFB 6,224              ; y=7, z=1; left, right, up/left
; The next three descriptors correspond to the fire escape on the apartment
; building next to no. 19.
  DEFB 76,24              ; y=10, z=2; up/right, down/left
  DEFB 88,24              ; y=16, z=2; up/right, down/left
  DEFB 100,24             ; y=22, z=2; up/right, down/left
; The next descriptor corresponds to the left edge of the fire escape on the
; first floor of the apartment building next to no. 19. It is used to check
; whether Sam is going to step off the fire escape at that location (see
; SLHANDLER6).
FIREESCAPE;
  DEFB 184,146,6          ; y=28, z=2; left, up/right
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinate 178)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the fire
; escape on the apartment building next to no. 19.
LOCDESCS178;
  DEFB 74,24              ; y=9, z=2; up/right, down/left
  DEFB 86,24              ; y=15, z=2; up/right, down/left
  DEFB 98,24              ; y=21, z=2; up/right, down/left
  DEFB 110,24             ; y=27, z=2; up/right, down/left
  DEFB 255                ; End marker

; Unused
  DEFB 0

; Location descriptors (x-coordinate 15)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the doorway
; of the right-hand shop under the apartments next to no. 74.
LOCDESCS15;
  DEFB 221,68,65          ; y=33, z=1 or 2; right, down/right (door open)
  DEFB 58,64              ; y=33, z=1; right (inside, door closed)
  DEFB 122,68             ; y=33, z=2; right, down/right (outside, door closed)
; This block of location descriptors is implicitly terminated by the page
; boundary.

; Unused
;
; This byte is probably a remnant of a location descriptor table.
  DEFB 6

; Location descriptors (x-coordinate 179)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to a location near the top of the fire
; escape on the roof of the apartment building next to no. 19.
LOCDESCS179;
  DEFB 6,208              ; y=7, z=1; left, right, up/right
; The next four descriptors correspond to the fire escape on the apartment
; building next to no. 19.
  DEFB 72,24              ; y=8, z=2; up/right, down/left
  DEFB 84,24              ; y=14, z=2; up/right, down/left
  DEFB 96,24              ; y=20, z=2; up/right, down/left
  DEFB 108,24             ; y=26, z=2; up/right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 180)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to locations near the top of the fire
; escape on the roof of the apartment building next to no. 19.
LOCDESCS180;
  DEFB 4,72               ; y=6, z=1; right, down/left
  DEFB 6,208              ; y=7, z=1; left, right, up/right
; The next four descriptors correspond to the fire escape on the apartment
; building next to no. 19.
  DEFB 70,24              ; y=7, z=2; up/right, down/left
  DEFB 82,24              ; y=13, z=2; up/right, down/left
  DEFB 94,24              ; y=19, z=2; up/right, down/left
  DEFB 106,24             ; y=25, z=2; up/right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinate 184)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the right
; edges of the fire escape on the apartment building next to no. 19.
LOCDESCS184;
  DEFB 78,128             ; y=11, z=2; left (top floor)
  DEFB 90,128             ; y=17, z=2; left (third floor)
  DEFB 102,128            ; y=23, z=2; left (second floor)
  DEFB 255                ; End marker

; Location descriptors (most x-coordinates)
;
; Used by the routine at LOCDESCS.
;
; The first four descriptors correspond to the left edge of the roof of the
; apartment building next to no. 74, and the far left walls inside that
; building on the top, third and second floors (x=0).
LOCDESCS0;
  DEFB 6,64               ; y=7, z=1; right (roof)
  DEFB 18,64              ; y=13, z=1; right (top floor)
  DEFB 30,64              ; y=19, z=1; right (third floor)
  DEFB 42,64              ; y=25, z=1; right (second floor)
; The next three descriptors correspond to the doorway of the shop at the far
; left of town (x=0).
  DEFB 221,68,65          ; y=33, z=1 or 2; right, down/right (door open)
  DEFB 58,64              ; y=33, z=1; right (inside, door closed)
  DEFB 122,4              ; y=33, z=2; down/right (outside, door closed)
; The following empty location descriptor table corresponds to x-coordinates
; 1-5, 8, 17-20, 24-29, 31, 33-37, 46-52, 54-56, 58-61, 63, 64, 70, 72, 73, 84,
; 85, 87, 93-99, 101, 102, 104-111, 119-123, 127-132, 134, 140-146, 159-174,
; 185-189, 191, 192, 199-203, 214-221, 227-229, 241-245 and 255; at these
; x-coordinates and any y-coordinate, a character can move left or right only.
LOCDESCS1;
  DEFB 255                ; End marker

; Keypress offset table
;
; Used by the routine at KEYOFFSET2. Each non-zero entry in this table
; corresponds to a game key, and points to an entry in the table of
; keypress-handling routine addresses at K_UPF.
KEYTABLE;
  DEFB 19                 ; '0'; Knock on or open a door
  DEFB 0                  ; '1'; Unused
  DEFB 0                  ; '2'; Unused
  DEFB 0                  ; '3'; Unused
  DEFB 0                  ; '4'; Unused
  DEFB 7                  ; '5'; Left (fast)
  DEFB 3                  ; '6'; Down (fast)
  DEFB 1                  ; '7'; Up (fast)
  DEFB 5                  ; '8'; Right (fast)
  DEFB 0                  ; '9'; Unused
  DEFB 0                  ; ';'; Unused
  DEFB 0                  ; ';'; Unused
  DEFB 0                  ; '<'; Unused
  DEFB 0                  ; '='; Unused
  DEFB 0                  ; '>'; Unused
  DEFB 0                  ; '?'; Unused
  DEFB 0                  ; '@'; Unused
  DEFB 3                  ; 'A'; Down (fast)
  DEFB 23                 ; 'B'; Raise/lower blind
  DEFB 35                 ; 'C'; Use hook
  DEFB 17                 ; 'D'; Change disguise
  DEFB 0                  ; 'E'; Unused
  DEFB 25                 ; 'F'; Fuse
  DEFB 33                 ; 'G'; Get object
  DEFB 0                  ; 'H'; Unused
  DEFB 0                  ; 'I'; Unused
  DEFB 29                 ; 'J'; Joystick
  DEFB 19                 ; 'K'; Knock on or open a door
  DEFB 21                 ; 'L'; Light on/off
  DEFB 27                 ; 'M'; Toggle message speed
  DEFB 0                  ; 'N'; Unused
  DEFB 7                  ; 'O'; Left (fast)
  DEFB 5                  ; 'P'; Right (fast)
  DEFB 1                  ; 'Q'; Up (fast)
  DEFB 37                 ; 'R'; Forward roll
  DEFB 39                 ; 'S'; Somersault
  DEFB 31                 ; 'T'; Telephone
  DEFB 0                  ; 'U'; Unused
  DEFB 0                  ; 'V'; Unused
  DEFB 0                  ; 'W'; Unused
  DEFB 0                  ; 'X'; Unused
  DEFB 0                  ; 'Y'; Unused
  DEFB 0                  ; 'Z'; Unused
  DEFB 0                  ; '['; Unused
  DEFB 0                  ; '\'; Unused
  DEFB 0                  ; ']'; Unused
  DEFB 0                  ; '↑'; Unused
  DEFB 0                  ; '_'; Unused
  DEFB 0                  ; '£'; Unused
  DEFB 11                 ; 'a'; Down (slow)
  DEFB 23                 ; 'b'; Raise/lower blind
  DEFB 35                 ; 'c'; Use hook
  DEFB 17                 ; 'd'; Change disguise
  DEFB 0                  ; 'e'; Unused
  DEFB 25                 ; 'f'; Fuse
  DEFB 33                 ; 'g'; Get object
  DEFB 0                  ; 'h'; Unused
  DEFB 0                  ; 'i'; Unused
  DEFB 29                 ; 'j'; Joystick
  DEFB 19                 ; 'k'; Knock on or open a door
  DEFB 21                 ; 'l'; Light on/off
  DEFB 27                 ; 'm'; Toggle message speed
  DEFB 0                  ; 'n'; Unused
  DEFB 15                 ; 'o'; Left (slow)
  DEFB 13                 ; 'p'; Right (slow)
  DEFB 9                  ; 'q'; Up (slow)
  DEFB 37                 ; 'r'; Forward roll
  DEFB 39                 ; 's'; Somersault
  DEFB 31                 ; 't'; Telephone
  DEFB 0                  ; 'u'; Unused
  DEFB 0                  ; 'v'; Unused
  DEFB 0                  ; 'w'; Unused
  DEFB 0                  ; 'x'; Unused
  DEFB 0                  ; 'y'; Unused
  DEFB 0                  ; 'z'; Unused
  DEFB 0                  ; '{'; Unused
  DEFB 0                  ; '|'; Unused
  DEFB 0                  ; '}'; Unused
  DEFB 0                  ; '~'; Unused
  DEFB 0                  ; '©'; Unused

; Location descriptors (x-coordinates 223, 239)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the top-left edge of the roof of no. 17
; (x=223). It is used to check whether Sam is going to step off the roof or
; away from the edge of the roof (see SLHANDLER2).
LOCDESCS223;
  DEFB 130,195,2          ; y=6, z=1; left, right
; The next three descriptors correspond to the far left walls of no. 17 (x=223)
; and no. 15 (x=239).
LOCDESCS239;
  DEFB 18,64              ; y=13, z=1; right (top floor)
  DEFB 30,64              ; y=19, z=1; right (third floor)
  DEFB 42,64              ; y=25, z=1; right (second floor)
; The next three descriptors correspond to the doorways of the shops under no.
; 17 (x=223) and no. 15 (x=239).
  DEFB 221,76,65          ; y=33, z=1 or 2; right, down/left, down/right (door
                          ; open)
  DEFB 58,64              ; y=33, z=1; right (inside, door closed)
  DEFB 122,76             ; y=33, z=2; right, down/left, down/right (outside,
                          ; door closed)
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 225)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the step down
; from the top edge of the roof of no. 17.
LOCDESCS225;
  DEFB 4,132              ; y=6, z=1; left, down/right
  DEFB 255                ; End marker

; Location descriptor (x-coordinate 226)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the step up
; to the top edge of the roof of no. 17.
LOCDESCS226;
  DEFB 6,96               ; y=7, z=1; right, up/left
  DEFB 255                ; End marker

; Unused
;
; This byte is probably a remnant of a location descriptor table.
  DEFB 255

; Location descriptors (x-coordinates 7, 231, 247)
;
; Used by the routine at LOCDESCS.
;
; The first three descriptors here invoke the special location handler routine
; whose address is at SLHANDLER1 when a character moves left at the designated
; locations. However, the handler routine does nothing special, and therefore
; the descriptors are redundant.
;
; The first descriptor corresponds to locations between the stairwell and the
; first window to the left of the stairwell on the top floor of the apartment
; building next to no. 74 (x=7), between the second and third windows from the
; left on the top floor of no. 17 (x=231), and between the second and third
; windows from the left on the top floor of no. 15 (x=247).
LOCDESCS7;
  DEFB 137,194,1          ; y=13, z=1; left, right
; The next descriptor corresponds to locations between the stairwell and the
; first window to the left of the stairwell on the third floor of the apartment
; building next to no. 74 (x=7), between the second and third windows from the
; left on the third floor of no. 17 (x=231), and between the second and third
; windows from the left on the third floor of no. 15 (x=247).
  DEFB 143,194,1          ; y=19, z=1; left, right
; The next descriptor corresponds to locations between the stairwell and the
; first window to the left of the stairwell on the second floor of the
; apartment building next to no. 74 (x=7), between the second and third windows
; from the left on the second floor of no. 17 (x=231), and between the second
; and third windows from the left on the second floor of no. 15 (x=247).
  DEFB 149,194,1          ; y=25, z=1; left, right (second floor)
; The next descriptor corresponds to the right sides of the walls between the
; shop at the far left of town and the stairwell in the apartment building next
; to no. 74 (x=7), between no. 17 and the shop under no. 17 (x=231), and
; between no. 15 and the shop under no. 15 (x=247).
  DEFB 54,64              ; y=31, z=1; right
  DEFB 255                ; End marker

; Location descriptor (x-coordinates 6, 230, 246)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the far right
; walls in the shop at the far left of town (x=6), the shop under no. 17
; (x=230), and the shop under no. 15 (x=246).
LOCDESCS6;
  DEFB 58,128             ; y=33, z=1; left
  DEFB 255                ; End marker

; Location descriptor (x-coordinates 9, 193)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the steps
; leading up from the road to the first floor of the apartment building next to
; no. 74 (x=9), and the steps leading up from the road to the first floor of
; the apartment building next to no. 74 (x=193).
LOCDESCS9;
  DEFB 124,24             ; y=34, z=2; up/right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 11, 195)
;
; Used by the routine at LOCDESCS.
;
; The first two descriptors correspond to the staircases between the top floor
; and the roof in the apartment building next to no. 74 (x=11) and the
; apartment building next to no. 19 (x=195).
LOCDESCS11;
  DEFB 6,200              ; y=7, z=1; left, right, down/left
  DEFB 10,36              ; y=9, z=1; up/left, down/right
; The next two descriptors correspond to the staircases between the third and
; top floors of the apartment building next to no. 74 (x=11) and the apartment
; building next to no. 19 (x=195).
  DEFB 18,200             ; y=13, z=1; left, right, down/left
  DEFB 22,36              ; y=15, z=1; up/left, down/right
; The next two descriptors correspond to the staircases between the second and
; third floors of the apartment building next to no. 74 (x=11) and the
; apartment building next to no. 19 (x=195).
  DEFB 30,200             ; y=19, z=1; left, right, down/left
  DEFB 34,36              ; y=21, z=1; up/left, down/right
; The next two descriptors correspond to the staircases between the first and
; second floors of the apartment building next to no. 74 (x=11) and the
; apartment building next to no. 19 (x=195).
  DEFB 42,200             ; y=25, z=1; left, right, down/left
  DEFB 46,36              ; y=27, z=1; up/left, down/right
; The next descriptor corresponds to the steps leading up to the first floor of
; the apartment building next to no. 74 (x=11) and the apartment building next
; to no. 19 (x=195).
  DEFB 220,24,16          ; y=32, z=1 or 2; up/right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 10, 194)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircases between the top floor and
; the roof in the apartment building next to no. 74 (x=10) and the apartment
; building next to no. 19 (x=194).
LOCDESCS10;
  DEFB 8,20               ; y=8, z=1; up/right, down/right
; The next descriptor corresponds to the staircases between the third and top
; floors of the apartment building next to no. 74 (x=10) and the apartment
; building next to no. 19 (x=194).
  DEFB 20,20              ; y=14, z=1; up/right, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of the apartment building next to no. 74 (x=10) and the
; apartment building next to no. 19 (x=194).
  DEFB 32,20              ; y=20, z=1; up/right, down/right
; The next descriptor corresponds to the staircases between the first and
; second floors of the apartment building next to no. 74 (x=10) and the
; apartment building next to no. 19 (x=194).
  DEFB 44,20              ; y=26, z=1; up/right, down/right
; The next descriptor corresponds to the steps leading up to the first floor of
; the apartment building next to no. 74 (x=10) and the apartment building next
; to no. 19 (x=194).
  DEFB 122,24             ; y=33, z=2; up/right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 12, 196)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the staircases between the top floor and
; the roof in the apartment building next to no. 74 (x=12) and the apartment
; building next to no. 19 (x=196).
LOCDESCS12;
  DEFB 12,36              ; y=10, z=1; up/left, down/right
; The next descriptor corresponds to the staircases between the third and top
; floors of the apartment building next to no. 74 (x=12) and the apartment
; building next to no. 19 (x=196).
  DEFB 24,36              ; y=16, z=1; up/left, down/right
; The next descriptor corresponds to the staircases between the second and
; third floors of the apartment building next to no. 74 (x=12) and the
; apartment building next to no. 19 (x=196).
  DEFB 36,36              ; y=22, z=1; up/left, down/right
; The next descriptor corresponds to the staircases between the first and
; second floors of the apartment building next to no. 74 (x=12) and the
; apartment building next to no. 19 (x=196).
  DEFB 48,36              ; y=28, z=1; up/left, down/right
; The next descriptor corresponds to the steps leading down from the first
; floor of the apartment building next to no. 74 (x=12) and the apartment
; building next to no. 19 (x=196).
  DEFB 219,200,192        ; y=31, z=1 or 2; left, right, down/left
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 16, 224, 240)
;
; Used by the routine at LOCDESCS. These descriptors correspond to the doorways
; of the right-hand shop under the apartments next to no. 74 (x=16), the shop
; under no. 17 (x=224), and the shop under no. 15 (x=240).
LOCDESCS16;
  DEFB 221,204,65         ; y=33, z=1 or 2; left, right, down/left, down/right
                          ; (door open)
  DEFB 122,140            ; y=33, z=2; left, down/left, down/right (outside,
                          ; door closed)
  DEFB 255                ; End marker

; Location descriptors (x-coordinates 14, 30, 198)
;
; Used by the routine at LOCDESCS.
;
; The first descriptor corresponds to the left side of the wall between the
; right-hand shop under the apartment building next to no. 74 and the stairwell
; of that building (x=14).
LOCDESCS14;
  DEFB 54,128             ; y=31, z=1; left
; The next descriptor corresponds to the staircases leading up to the roofs of
; the apartment building next to no. 74 (x=14) and the apartment building next
; to no. 19 (x=198).
LOCDESCS198;
  DEFB 16,40              ; y=12, z=1; up/left, down/left
; The next descriptor corresponds to the location between the stairwell and the
; first window to the right of the stairwell on the first floor of the
; apartment building next to no. 19 (x=198). It invokes the special location
; handler routine whose address is at SLHANDLER1 when a character moves right
; at this location. However, the handler routine does nothing special, and
; therefore the descriptor is redundant. (The location at (x,y,z)=(14,31,1) is
; dealt with by the first descriptor above.)
  DEFB 155,193,1          ; y=31, z=1; left, right
; The next descriptor corresponds to the staircases between the third and top
; floors in the apartment building next to no. 74 (x=14) and the apartment
; building next to no. 19 (x=198).
  DEFB 28,40              ; y=18, z=1; up/left, down/left
; The next descriptor corresponds to the location between the stairwell and the
; first window to the right of the stairwell on the third floor of the
; apartment building next to no. 74 (x=14), and the location between the
; stairwell and the first window to the right of the stairwell on the third
; floor of the apartment building next to no. 19 (x=198). It invokes the
; special location handler routine whose address is at SLHANDLER1 when a
; character moves right at these locations. However, the handler routine does
; nothing special, and therefore the descriptor is redundant.
  DEFB 143,193,1          ; y=19, z=1; left, right
; The next descriptor corresponds to the staircases between the second and
; third floors in the apartment building next to no. 74 (x=14) and the
; apartment building next to no. 19 (x=198).
  DEFB 40,40              ; y=24, z=1; up/left, down/left
; The next descriptor corresponds to the location between the stairwell and the
; first window to the right of the stairwell on the second floor of the
; apartment building next to no. 74 (x=14), and the location between the
; stairwell and the first window to the right of the stairwell on the second
; floor of the apartment building next to no. 19 (x=198). It invokes the
; special location handler routine whose address is at SLHANDLER1 when a
; character moves right at these locations. However, the handler routine does
; nothing special, and therefore the descriptor is redundant.
  DEFB 149,193,1          ; y=25, z=1; left, right
; The next descriptor corresponds to the staircases between the first and
; second floors in the apartment building next to no. 74 (x=14) and the
; apartment building next to no. 19 (x=198).
  DEFB 52,40              ; y=30, z=1; up/left, down/left
; The next descriptor corresponds to the location between the stairwell and the
; first window to the right of the stairwell on the top floor of the apartment
; building next to no. 74 (x=14), the right end of the catwalk (x=30), and the
; location between the stairwell and the first window to the right of the
; stairwell on the top floor of the apartment building next to no. 19 (x=198).
; It invokes the special location handler routine whose address is at
; SLHANDLER1 when a character moves right at these locations. However, the
; handler routine does nothing special, and therefore the descriptor is
; redundant.
LOCDESCS30;
  DEFB 137,193,1          ; y=13, z=1; left, right
  DEFB 255                ; End marker

; Location descriptor (x-coordinates 21, 147, 204)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the step up
; towards the top-right edge of the roof of the apartment building next to no.
; 74 (x=21), the first step up towards the top-right edge of the police station
; roof (x=147), and the step up towards the top-right edge of the roof of the
; apartment building next to no. 19 (x=204).
LOCDESCS21;
  DEFB 6,208              ; y=7, z=1; left, right, up/right
  DEFB 255                ; End marker

; Location descriptor (x-coordinates 23, 206)
;
; Used by the routine at LOCDESCS. This descriptor corresponds to the top right
; edges of the roofs the apartment building next to no. 74 (x=23) and the
; apartment building next to no. 19 (x=206). It is used to check whether a
; character is going to step off the roof (see SLHANDLER2).
LOCDESCS23;
  DEFB 130,193,2          ; y=6, z=1; left, right
  DEFB 255                ; End marker

; Unused
;
; These bytes are probably remnants of a location descriptor table.
  DEFB 44,36              ; y=26, z=1; up/left, down/right
  DEFB 52,24              ; y=30, z=1; up/right, down/left
  DEFB 120,224            ; y=32, z=2; left, right, up/left
  DEFB 255                ; End marker

; Location descriptors (all x-coordinates, z=4)
;
; Used by the routine at LOCDESCS.
;
; The first seven descriptors correspond to the sidewalk outside the shop at
; the far left of town.
LOCDESCSZ4;
  DEFB 64                 ; x=0; right
  DEFB 224                ; x=1; left, right, up/left
  DEFB 192                ; x=2; left, right
  DEFB 192                ; x=3; left, right
  DEFB 192                ; x=4; left, right
  DEFB 192                ; x=5; left, right
  DEFB 133                ; x=6; left, down/right
; The next eight descriptors correspond to the section of road containing the
; steps leading up to the first floor of the apartment building next to no. 74.
  DEFB 98                 ; x=7; right, up/left
  DEFB 208                ; x=8; left, right, up/right
  DEFB 192                ; x=9; left, right
  DEFB 192                ; x=10; left, right
  DEFB 192                ; x=11; left, right
  DEFB 192                ; x=12; left, right
  DEFB 192                ; x=13; left, right
  DEFB 145                ; x=14; left, up/right
; The next 24 descriptors correspond to the sidewalk from the doorway of the
; right-hand shop under the apartments next to no. 74 and the front steps of
; no. 74.
  DEFB 90                 ; x=15; right, up/right, down/left
  DEFB 224                ; x=16; left, right, up/left
  DEFB 224                ; x=17; left, right, up/left
  DEFB 192                ; x=18; left, right
  DEFB 192                ; x=19; left, right
  DEFB 192                ; x=20; left, right
  DEFB 192                ; x=21; left, right
  DEFB 192                ; x=22; left, right
  DEFB 192                ; x=23; left, right
  DEFB 192                ; x=24; left, right
  DEFB 192                ; x=25; left, right
  DEFB 192                ; x=26; left, right
  DEFB 192                ; x=27; left, right
  DEFB 192                ; x=28; left, right
  DEFB 192                ; x=29; left, right
  DEFB 192                ; x=30; left, right
  DEFB 192                ; x=31; left, right
  DEFB 192                ; x=32; left, right
  DEFB 192                ; x=33; left, right
  DEFB 192                ; x=34; left, right
  DEFB 192                ; x=35; left, right
  DEFB 192                ; x=36; left, right
  DEFB 192                ; x=37; left, right
  DEFB 192                ; x=38; left, right
; The next eight descriptors correspond to the sidewalk next to the front steps
; of no. 74.
  DEFB 208                ; x=39; left, right, up/right
  DEFB 208                ; x=40; left, right, up/right
  DEFB 240                ; x=41; left, right, up/left, up/right
  DEFB 240                ; x=42; left, right, up/left, up/right
  DEFB 240                ; x=43; left, right, up/left, up/right
  DEFB 240                ; x=44; left, right, up/left, up/right
  DEFB 224                ; x=45; left, right, up/left
  DEFB 224                ; x=46; left, right, up/left
; The next 20 descriptors correspond to the sidewalk between the front steps of
; no. 74 and the entrance to the hotel.
  DEFB 192                ; x=47; left, right
  DEFB 192                ; x=48; left, right
  DEFB 192                ; x=49; left, right
  DEFB 192                ; x=50; left, right
  DEFB 192                ; x=51; left, right
  DEFB 192                ; x=52; left, right
  DEFB 192                ; x=53; left, right
  DEFB 192                ; x=54; left, right
  DEFB 192                ; x=55; left, right
  DEFB 192                ; x=56; left, right
  DEFB 192                ; x=57; left, right
  DEFB 192                ; x=58; left, right
  DEFB 192                ; x=59; left, right
  DEFB 192                ; x=60; left, right
  DEFB 192                ; x=61; left, right
  DEFB 192                ; x=62; left, right
  DEFB 192                ; x=63; left, right
  DEFB 192                ; x=64; left, right
  DEFB 192                ; x=65; left, right
  DEFB 192                ; x=66; left, right
; The next three descriptors correspond to the sidewalk next to the left-hand
; entrance to the hotel.
  DEFB 208                ; x=67; left, right, up/right
  DEFB 192                ; x=68; left, right
  DEFB 224                ; x=69; left, right, up/left
; The next 18 descriptors correspond to the sidewalk outside the front doors of
; the hotel.
  DEFB 192                ; x=70; left, right
  DEFB 192                ; x=71; left, right
  DEFB 192                ; x=72; left, right
  DEFB 192                ; x=73; left, right
  DEFB 192                ; x=74; left, right
  DEFB 192                ; x=75; left, right
  DEFB 192                ; x=76; left, right
  DEFB 192                ; x=77; left, right
  DEFB 192                ; x=78; left, right
  DEFB 192                ; x=79; left, right
  DEFB 192                ; x=80; left, right
  DEFB 192                ; x=81; left, right
  DEFB 192                ; x=82; left, right
  DEFB 192                ; x=83; left, right
  DEFB 192                ; x=84; left, right
  DEFB 192                ; x=85; left, right
  DEFB 192                ; x=86; left, right
  DEFB 192                ; x=87; left, right
; The next three descriptors correspond to the sidewalk next to the right-hand
; entrance to the hotel.
  DEFB 208                ; x=88; left, right, up/right
  DEFB 192                ; x=89; left, right
  DEFB 224                ; x=90; left, right, up/left
; The next 20 descriptors correspond to the sidewalk between the right-hand
; entrance to the hotel and the front steps of no. 31.
  DEFB 192                ; x=91; left, right
  DEFB 192                ; x=92; left, right
  DEFB 192                ; x=93; left, right
  DEFB 192                ; x=94; left, right
  DEFB 192                ; x=95; left, right
  DEFB 192                ; x=96; left, right
  DEFB 192                ; x=97; left, right
  DEFB 192                ; x=98; left, right
  DEFB 192                ; x=99; left, right
  DEFB 192                ; x=100; left, right
  DEFB 192                ; x=101; left, right
  DEFB 192                ; x=102; left, right
  DEFB 192                ; x=103; left, right
  DEFB 192                ; x=104; left, right
  DEFB 192                ; x=105; left, right
  DEFB 192                ; x=106; left, right
  DEFB 192                ; x=107; left, right
  DEFB 192                ; x=108; left, right
  DEFB 192                ; x=109; left, right
  DEFB 192                ; x=110; left, right
; The next eight descriptors correspond to the sidewalk next to the front steps
; of no. 31.
  DEFB 208                ; x=111; left, right, up/right
  DEFB 208                ; x=112; left, right, up/right
  DEFB 240                ; x=113; left, right, up/left, up/right
  DEFB 240                ; x=114; left, right, up/left, up/right
  DEFB 240                ; x=115; left, right, up/left, up/right
  DEFB 240                ; x=116; left, right, up/left, up/right
  DEFB 224                ; x=117; left, right, up/left
  DEFB 224                ; x=118; left, right, up/left
; The next 15 descriptors correspond to the sidewalk between the front steps of
; no. 31 and the front steps of the police station.
  DEFB 192                ; x=119; left, right
  DEFB 192                ; x=120; left, right
  DEFB 192                ; x=121; left, right
  DEFB 192                ; x=122; left, right
  DEFB 192                ; x=123; left, right
  DEFB 192                ; x=124; left, right
  DEFB 192                ; x=125; left, right
  DEFB 192                ; x=126; left, right
  DEFB 192                ; x=127; left, right
  DEFB 192                ; x=128; left, right
  DEFB 192                ; x=129; left, right
  DEFB 192                ; x=130; left, right
  DEFB 192                ; x=131; left, right
  DEFB 192                ; x=132; left, right
  DEFB 192                ; x=133; left, right
; The next seven descriptors correspond to the sidewalk next to the front steps
; of the police station.
  DEFB 208                ; x=134; left, right, up/right
  DEFB 208                ; x=135; left, right, up/right
  DEFB 240                ; x=136; left, right, up/left, up/right
  DEFB 240                ; x=137; left, right, up/left, up/right
  DEFB 240                ; x=138; left, right, up/left, up/right
  DEFB 224                ; x=139; left, right, up/left
  DEFB 224                ; x=140; left, right, up/left
; The next 13 descriptors correspond to the sidewalk between the front steps of
; the police station and the front steps of no. 27.
  DEFB 192                ; x=141; left, right
  DEFB 192                ; x=142; left, right
  DEFB 192                ; x=143; left, right
  DEFB 192                ; x=144; left, right
  DEFB 192                ; x=145; left, right
  DEFB 192                ; x=146; left, right
  DEFB 192                ; x=147; left, right
  DEFB 192                ; x=148; left, right
  DEFB 192                ; x=149; left, right
  DEFB 192                ; x=150; left, right
  DEFB 192                ; x=151; left, right
  DEFB 192                ; x=152; left, right
  DEFB 192                ; x=153; left, right
; The next five descriptors correspond to the sidewalk next to the front steps
; of no. 27.
  DEFB 208                ; x=154; left, right, up/right
  DEFB 208                ; x=155; left, right, up/right
  DEFB 240                ; x=156; left, right, up/left, up/right
  DEFB 224                ; x=157; left, right, up/left
  DEFB 224                ; x=158; left, right, up/left
; The next five descriptors correspond to the sidewalk to the right of the
; front steps of no. 27.
  DEFB 192                ; x=159; left, right
  DEFB 192                ; x=160; left, right
  DEFB 192                ; x=161; left, right
  DEFB 192                ; x=162; left, right
  DEFB 133                ; x=163; left, down/right
; The next 35 descriptors correspond to the road between no. 27 and the
; right-hand side of the apartment building next to no. 19.
  DEFB 98                 ; x=164; right, up/left
  DEFB 192                ; x=165; left, right
  DEFB 192                ; x=166; left, right
  DEFB 192                ; x=167; left, right
  DEFB 192                ; x=168; left, right
  DEFB 192                ; x=169; left, right
  DEFB 192                ; x=170; left, right
  DEFB 192                ; x=171; left, right
  DEFB 192                ; x=172; left, right
  DEFB 192                ; x=173; left, right
  DEFB 192                ; x=174; left, right
  DEFB 192                ; x=175; left, right
  DEFB 192                ; x=176; left, right
  DEFB 192                ; x=177; left, right
  DEFB 192                ; x=178; left, right
  DEFB 192                ; x=179; left, right
  DEFB 192                ; x=180; left, right
  DEFB 192                ; x=181; left, right
  DEFB 192                ; x=182; left, right
  DEFB 192                ; x=183; left, right
  DEFB 192                ; x=184; left, right
  DEFB 192                ; x=185; left, right
  DEFB 192                ; x=186; left, right
  DEFB 192                ; x=187; left, right
  DEFB 192                ; x=188; left, right
  DEFB 192                ; x=189; left, right
  DEFB 192                ; x=190; left, right
  DEFB 192                ; x=191; left, right
  DEFB 208                ; x=192; left, right, up/right
  DEFB 192                ; x=193; left, right
  DEFB 192                ; x=194; left, right
  DEFB 192                ; x=195; left, right
  DEFB 192                ; x=196; left, right
  DEFB 192                ; x=197; left, right
  DEFB 145                ; x=198; left, up/right
; The next eight descriptors correspond to the sidewalk outside the right-hand
; side of the apartment building next to no. 19.
  DEFB 74                 ; x=199; right, down/left
  DEFB 192                ; x=200; left, right
  DEFB 192                ; x=201; left, right
  DEFB 192                ; x=202; left, right
  DEFB 192                ; x=203; left, right
  DEFB 192                ; x=204; left, right
  DEFB 192                ; x=205; left, right
  DEFB 192                ; x=206; left, right
; The next eight descriptors correspond to the sidewalk next to the front steps
; of no. 19.
  DEFB 208                ; x=207; left, right, up/right
  DEFB 208                ; x=208; left, right, up/right
  DEFB 240                ; x=209; left, right, up/left, up/right
  DEFB 240                ; x=210; left, right, up/left, up/right
  DEFB 240                ; x=211; left, right, up/left, up/right
  DEFB 240                ; x=212; left, right, up/left, up/right
  DEFB 224                ; x=213; left, right, up/left
  DEFB 224                ; x=214; left, right, up/left
; The next seven descriptors correspond to the sidewalk between the front steps
; of no. 19 and the shop under no. 17.
  DEFB 192                ; x=215; left, right
  DEFB 192                ; x=216; left, right
  DEFB 192                ; x=217; left, right
  DEFB 192                ; x=218; left, right
  DEFB 192                ; x=219; left, right
  DEFB 192                ; x=220; left, right
  DEFB 192                ; x=221; left, right
; The next four descriptors correspond to the sidewalk outside the door to the
; shop under no. 17.
  DEFB 208                ; x=222; left, right, up/right
  DEFB 208                ; x=223; left, right, up/right
  DEFB 224                ; x=224; left, right, up/left
  DEFB 224                ; x=225; left, right, up/left
; The next eight descriptors correspond to the sidewalk between the door to the
; shop under no. 17 and the front steps of no. 17.
  DEFB 192                ; x=226; left, right
  DEFB 192                ; x=227; left, right
  DEFB 192                ; x=228; left, right
  DEFB 192                ; x=229; left, right
  DEFB 192                ; x=230; left, right
  DEFB 192                ; x=231; left, right
  DEFB 192                ; x=232; left, right
  DEFB 192                ; x=233; left, right
; The next eight descriptors correspond to the sidewalk next to the front steps
; of no. 17 and the door to the shop under no. 15.
  DEFB 208                ; x=234; left, right, up/right
  DEFB 208                ; x=235; left, right, up/right
  DEFB 240                ; x=236; left, right, up/left, up/right
  DEFB 224                ; x=237; left, right, up/left
  DEFB 240                ; x=238; left, right, up/left, up/right
  DEFB 208                ; x=239; left, right, up/right
  DEFB 224                ; x=240; left, right, up/left
  DEFB 224                ; x=241; left, right, up/left
; The next eight descriptors correspond to the sidewalk between the door to the
; shop under no. 15 and the front steps of no. 15.
  DEFB 192                ; x=242; left, right
  DEFB 192                ; x=243; left, right
  DEFB 192                ; x=244; left, right
  DEFB 192                ; x=245; left, right
  DEFB 192                ; x=246; left, right
  DEFB 192                ; x=247; left, right
  DEFB 192                ; x=248; left, right
  DEFB 192                ; x=249; left, right
; The next five descriptors correspond to the sidewalk next to the front steps
; of no. 15.
  DEFB 208                ; x=250; left, right, up/right
  DEFB 208                ; x=251; left, right, up/right
  DEFB 240                ; x=252; left, right, up/left, up/right
  DEFB 160                ; x=253; left, up/left
  DEFB 160                ; x=254; left, up/left
; The next descriptor is unused, because no character can reach x=255.
  DEFB 128                ; x=255; left

; Location descriptor address LSBs
;
; Used by the routine at LOCDESCS. The location descriptor address MSBs can be
; found at LDESCMSBS.
LDESCLSBS;
  DEFB 32                 ; x=0; LOCDESCS0
  DEFB 47                 ; x=1; LOCDESCS1
  DEFB 47                 ; x=2; LOCDESCS1
  DEFB 47                 ; x=3; LOCDESCS1
  DEFB 47                 ; x=4; LOCDESCS1
  DEFB 47                 ; x=5; LOCDESCS1
  DEFB 164                ; x=6; LOCDESCS6
  DEFB 152                ; x=7; LOCDESCS7
  DEFB 47                 ; x=8; LOCDESCS1
  DEFB 167                ; x=9; LOCDESCS9
  DEFB 190                ; x=10; LOCDESCS10
  DEFB 170                ; x=11; LOCDESCS11
  DEFB 201                ; x=12; LOCDESCS12
  DEFB 230                ; x=13; LOCDESCS13
  DEFB 219                ; x=14; LOCDESCS14
  DEFB 249                ; x=15; LOCDESCS15
  DEFB 213                ; x=16; LOCDESCS16
  DEFB 47                 ; x=17; LOCDESCS1
  DEFB 47                 ; x=18; LOCDESCS1
  DEFB 47                 ; x=19; LOCDESCS1
  DEFB 47                 ; x=20; LOCDESCS1
  DEFB 242                ; x=21; LOCDESCS21
  DEFB 236                ; x=22; LOCDESCS22
  DEFB 245                ; x=23; LOCDESCS23
  DEFB 47                 ; x=24; LOCDESCS1
  DEFB 47                 ; x=25; LOCDESCS1
  DEFB 47                 ; x=26; LOCDESCS1
  DEFB 47                 ; x=27; LOCDESCS1
  DEFB 47                 ; x=28; LOCDESCS1
  DEFB 47                 ; x=29; LOCDESCS1
  DEFB 238                ; x=30; LOCDESCS30
  DEFB 47                 ; x=31; LOCDESCS1
  DEFB 236                ; x=32; LOCDESCS32
  DEFB 47                 ; x=33; LOCDESCS1
  DEFB 47                 ; x=34; LOCDESCS1
  DEFB 47                 ; x=35; LOCDESCS1
  DEFB 47                 ; x=36; LOCDESCS1
  DEFB 47                 ; x=37; LOCDESCS1
  DEFB 247                ; x=38; LOCDESCS38
  DEFB 247                ; x=39; LOCDESCS39
  DEFB 250                ; x=40; LOCDESCS40
  DEFB 230                ; x=41; LOCDESCS41
  DEFB 230                ; x=42; LOCDESCS42
  DEFB 230                ; x=43; LOCDESCS43
  DEFB 232                ; x=44; LOCDESCS44
  DEFB 106                ; x=45; LOCDESCS45
  DEFB 47                 ; x=46; LOCDESCS1
  DEFB 47                 ; x=47; LOCDESCS1
  DEFB 47                 ; x=48; LOCDESCS1
  DEFB 47                 ; x=49; LOCDESCS1
  DEFB 47                 ; x=50; LOCDESCS1
  DEFB 47                 ; x=51; LOCDESCS1
  DEFB 47                 ; x=52; LOCDESCS1
  DEFB 248                ; x=53; LOCDESCS53
  DEFB 47                 ; x=54; LOCDESCS1
  DEFB 47                 ; x=55; LOCDESCS1
  DEFB 47                 ; x=56; LOCDESCS1
  DEFB 232                ; x=57; LOCDESCS57
  DEFB 47                 ; x=58; LOCDESCS1
  DEFB 47                 ; x=59; LOCDESCS1
  DEFB 47                 ; x=60; LOCDESCS1
  DEFB 47                 ; x=61; LOCDESCS1
  DEFB 254                ; x=62; LOCDESCS62
  DEFB 47                 ; x=63; LOCDESCS1
  DEFB 47                 ; x=64; LOCDESCS1
  DEFB 106                ; x=65; LOCDESCS65
  DEFB 96                 ; x=66; LOCDESCS66
  DEFB 103                ; x=67; LOCDESCS67
  DEFB 112                ; x=68; LOCDESCS68
  DEFB 121                ; x=69; LOCDESCS69
  DEFB 47                 ; x=70; LOCDESCS1
  DEFB 252                ; x=71; LOCDESCS71
  DEFB 47                 ; x=72; LOCDESCS1
  DEFB 47                 ; x=73; LOCDESCS1
  DEFB 96                 ; x=74; LOCDESCS74
  DEFB 110                ; x=75; LOCDESCS75
  DEFB 120                ; x=76; LOCDESCS76
  DEFB 100                ; x=77; LOCDESCS77
  DEFB 114                ; x=78; LOCDESCS78
  DEFB 250                ; x=79; LOCDESCS79
  DEFB 102                ; x=80; LOCDESCS80
  DEFB 106                ; x=81; LOCDESCS81
  DEFB 122                ; x=82; LOCDESCS82
  DEFB 120                ; x=83; LOCDESCS83
  DEFB 47                 ; x=84; LOCDESCS1
  DEFB 47                 ; x=85; LOCDESCS1
  DEFB 124                ; x=86; LOCDESCS86
  DEFB 47                 ; x=87; LOCDESCS1
  DEFB 230                ; x=88; LOCDESCS88
  DEFB 237                ; x=89; LOCDESCS89
  DEFB 107                ; x=90; LOCDESCS90
  DEFB 96                 ; x=91; LOCDESCS91
  DEFB 98                 ; x=92; LOCDESCS92
  DEFB 47                 ; x=93; LOCDESCS1
  DEFB 47                 ; x=94; LOCDESCS1
  DEFB 47                 ; x=95; LOCDESCS1
  DEFB 47                 ; x=96; LOCDESCS1
  DEFB 47                 ; x=97; LOCDESCS1
  DEFB 47                 ; x=98; LOCDESCS1
  DEFB 47                 ; x=99; LOCDESCS1
  DEFB 246                ; x=100; LOCDESCS100
  DEFB 47                 ; x=101; LOCDESCS1
  DEFB 47                 ; x=102; LOCDESCS1
  DEFB 234                ; x=103; LOCDESCS103
  DEFB 47                 ; x=104; LOCDESCS1
  DEFB 47                 ; x=105; LOCDESCS1
  DEFB 47                 ; x=106; LOCDESCS1
  DEFB 47                 ; x=107; LOCDESCS1
  DEFB 47                 ; x=108; LOCDESCS1
  DEFB 47                 ; x=109; LOCDESCS1
  DEFB 47                 ; x=110; LOCDESCS1
  DEFB 47                 ; x=111; LOCDESCS1
  DEFB 252                ; x=112; LOCDESCS112
  DEFB 230                ; x=113; LOCDESCS41
  DEFB 230                ; x=114; LOCDESCS42
  DEFB 230                ; x=115; LOCDESCS43
  DEFB 230                ; x=116; LOCDESCS116
  DEFB 96                 ; x=117; LOCDESCS117
  DEFB 117                ; x=118; LOCDESCS118
  DEFB 47                 ; x=119; LOCDESCS1
  DEFB 47                 ; x=120; LOCDESCS1
  DEFB 47                 ; x=121; LOCDESCS1
  DEFB 47                 ; x=122; LOCDESCS1
  DEFB 47                 ; x=123; LOCDESCS1
  DEFB 123                ; x=124; LOCDESCS124
  DEFB 230                ; x=125; LOCDESCS125
  DEFB 104                ; x=126; LOCDESCS126
  DEFB 47                 ; x=127; LOCDESCS1
  DEFB 47                 ; x=128; LOCDESCS1
  DEFB 47                 ; x=129; LOCDESCS1
  DEFB 47                 ; x=130; LOCDESCS1
  DEFB 47                 ; x=131; LOCDESCS1
  DEFB 47                 ; x=132; LOCDESCS1
  DEFB 253                ; x=133; LOCDESCS133
  DEFB 47                 ; x=134; LOCDESCS1
  DEFB 119                ; x=135; LOCDESCS135
  DEFB 1                  ; x=136; LOCDESCS136
  DEFB 20                 ; x=137; LOCDESCS137
  DEFB 46                 ; x=138; LOCDESCS138
  DEFB 67                 ; x=139; LOCDESCS139
  DEFB 47                 ; x=140; LOCDESCS1
  DEFB 47                 ; x=141; LOCDESCS1
  DEFB 47                 ; x=142; LOCDESCS1
  DEFB 47                 ; x=143; LOCDESCS1
  DEFB 47                 ; x=144; LOCDESCS1
  DEFB 47                 ; x=145; LOCDESCS1
  DEFB 47                 ; x=146; LOCDESCS1
  DEFB 242                ; x=147; LOCDESCS21
  DEFB 88                 ; x=148; LOCDESCS148
  DEFB 230                ; x=149; LOCDESCS149
  DEFB 230                ; x=150; LOCDESCS125
  DEFB 104                ; x=151; LOCDESCS126
  DEFB 93                 ; x=152; LOCDESCS152
  DEFB 100                ; x=153; LOCDESCS153
  DEFB 114                ; x=154; LOCDESCS154
  DEFB 130                ; x=155; LOCDESCS155
  DEFB 153                ; x=156; LOCDESCS156
  DEFB 178                ; x=157; LOCDESCS157
  DEFB 187                ; x=158; LOCDESCS158
  DEFB 47                 ; x=159; LOCDESCS1
  DEFB 47                 ; x=160; LOCDESCS1
  DEFB 47                 ; x=161; LOCDESCS1
  DEFB 47                 ; x=162; LOCDESCS1
  DEFB 47                 ; x=163; LOCDESCS1
  DEFB 47                 ; x=164; LOCDESCS1
  DEFB 47                 ; x=165; LOCDESCS1
  DEFB 47                 ; x=166; LOCDESCS1
  DEFB 47                 ; x=167; LOCDESCS1
  DEFB 47                 ; x=168; LOCDESCS1
  DEFB 47                 ; x=169; LOCDESCS1
  DEFB 47                 ; x=170; LOCDESCS1
  DEFB 47                 ; x=171; LOCDESCS1
  DEFB 47                 ; x=172; LOCDESCS1
  DEFB 47                 ; x=173; LOCDESCS1
  DEFB 47                 ; x=174; LOCDESCS1
  DEFB 212                ; x=175; LOCDESCS175
  DEFB 128                ; x=176; LOCDESCS176
  DEFB 226                ; x=177; LOCDESCS177
  DEFB 239                ; x=178; LOCDESCS178
  DEFB 1                  ; x=179; LOCDESCS179
  DEFB 12                 ; x=180; LOCDESCS180
  DEFB 200                ; x=181; LOCDESCS181
  DEFB 96                 ; x=182; LOCDESCS182
  DEFB 104                ; x=183; LOCDESCS126
  DEFB 25                 ; x=184; LOCDESCS184
  DEFB 47                 ; x=185; LOCDESCS1
  DEFB 47                 ; x=186; LOCDESCS1
  DEFB 47                 ; x=187; LOCDESCS1
  DEFB 47                 ; x=188; LOCDESCS1
  DEFB 47                 ; x=189; LOCDESCS1
  DEFB 113                ; x=190; LOCDESCS190
  DEFB 47                 ; x=191; LOCDESCS1
  DEFB 47                 ; x=192; LOCDESCS1
  DEFB 167                ; x=193; LOCDESCS9
  DEFB 190                ; x=194; LOCDESCS10
  DEFB 170                ; x=195; LOCDESCS11
  DEFB 201                ; x=196; LOCDESCS12
  DEFB 230                ; x=197; LOCDESCS13
  DEFB 221                ; x=198; LOCDESCS198
  DEFB 47                 ; x=199; LOCDESCS1
  DEFB 47                 ; x=200; LOCDESCS1
  DEFB 47                 ; x=201; LOCDESCS1
  DEFB 47                 ; x=202; LOCDESCS1
  DEFB 47                 ; x=203; LOCDESCS1
  DEFB 242                ; x=204; LOCDESCS21
  DEFB 232                ; x=205; LOCDESCS205
  DEFB 245                ; x=206; LOCDESCS23
  DEFB 234                ; x=207; LOCDESCS103
  DEFB 252                ; x=208; LOCDESCS112
  DEFB 230                ; x=209; LOCDESCS41
  DEFB 230                ; x=210; LOCDESCS42
  DEFB 230                ; x=211; LOCDESCS43
  DEFB 232                ; x=212; LOCDESCS44
  DEFB 106                ; x=213; LOCDESCS45
  DEFB 47                 ; x=214; LOCDESCS1
  DEFB 47                 ; x=215; LOCDESCS1
  DEFB 47                 ; x=216; LOCDESCS1
  DEFB 47                 ; x=217; LOCDESCS1
  DEFB 47                 ; x=218; LOCDESCS1
  DEFB 47                 ; x=219; LOCDESCS1
  DEFB 47                 ; x=220; LOCDESCS1
  DEFB 47                 ; x=221; LOCDESCS1
  DEFB 232                ; x=222; LOCDESCS205
  DEFB 128                ; x=223; LOCDESCS223
  DEFB 213                ; x=224; LOCDESCS16
  DEFB 145                ; x=225; LOCDESCS225
  DEFB 148                ; x=226; LOCDESCS226
  DEFB 47                 ; x=227; LOCDESCS1
  DEFB 47                 ; x=228; LOCDESCS1
  DEFB 47                 ; x=229; LOCDESCS1
  DEFB 164                ; x=230; LOCDESCS6
  DEFB 152                ; x=231; LOCDESCS7
  DEFB 95                 ; x=232; LOCDESCS232
  DEFB 106                ; x=233; LOCDESCS233
  DEFB 114                ; x=234; LOCDESCS154
  DEFB 128                ; x=235; LOCDESCS235
  DEFB 153                ; x=236; LOCDESCS156
  DEFB 178                ; x=237; LOCDESCS157
  DEFB 189                ; x=238; LOCDESCS238
  DEFB 131                ; x=239; LOCDESCS239
  DEFB 213                ; x=240; LOCDESCS16
  DEFB 47                 ; x=241; LOCDESCS1
  DEFB 47                 ; x=242; LOCDESCS1
  DEFB 47                 ; x=243; LOCDESCS1
  DEFB 47                 ; x=244; LOCDESCS1
  DEFB 47                 ; x=245; LOCDESCS1
  DEFB 164                ; x=246; LOCDESCS6
  DEFB 152                ; x=247; LOCDESCS7
  DEFB 93                 ; x=248; LOCDESCS152
  DEFB 100                ; x=249; LOCDESCS153
  DEFB 116                ; x=250; LOCDESCS250
  DEFB 134                ; x=251; LOCDESCS251
  DEFB 161                ; x=252; LOCDESCS252
  DEFB 180                ; x=253; LOCDESCS253
  DEFB 244                ; x=254; LOCDESCS254
  DEFB 47                 ; x=255; LOCDESCS1

; Location descriptor address MSBs
;
; Used by the routine at LOCDESCS. The location descriptor address LSBs can be
; found at LDESCLSBS.
LDESCMSBS;
  DEFB 195                ; x=0; LOCDESCS0
  DEFB 195                ; x=1; LOCDESCS1
  DEFB 195                ; x=2; LOCDESCS1
  DEFB 195                ; x=3; LOCDESCS1
  DEFB 195                ; x=4; LOCDESCS1
  DEFB 195                ; x=5; LOCDESCS1
  DEFB 195                ; x=6; LOCDESCS6
  DEFB 195                ; x=7; LOCDESCS7
  DEFB 195                ; x=8; LOCDESCS1
  DEFB 195                ; x=9; LOCDESCS9
  DEFB 195                ; x=10; LOCDESCS10
  DEFB 195                ; x=11; LOCDESCS11
  DEFB 195                ; x=12; LOCDESCS12
  DEFB 184                ; x=13; LOCDESCS13
  DEFB 195                ; x=14; LOCDESCS14
  DEFB 194                ; x=15; LOCDESCS15
  DEFB 195                ; x=16; LOCDESCS16
  DEFB 195                ; x=17; LOCDESCS1
  DEFB 195                ; x=18; LOCDESCS1
  DEFB 195                ; x=19; LOCDESCS1
  DEFB 195                ; x=20; LOCDESCS1
  DEFB 195                ; x=21; LOCDESCS21
  DEFB 185                ; x=22; LOCDESCS22
  DEFB 195                ; x=23; LOCDESCS23
  DEFB 195                ; x=24; LOCDESCS1
  DEFB 195                ; x=25; LOCDESCS1
  DEFB 195                ; x=26; LOCDESCS1
  DEFB 195                ; x=27; LOCDESCS1
  DEFB 195                ; x=28; LOCDESCS1
  DEFB 195                ; x=29; LOCDESCS1
  DEFB 195                ; x=30; LOCDESCS30
  DEFB 195                ; x=31; LOCDESCS1
  DEFB 186                ; x=32; LOCDESCS32
  DEFB 195                ; x=33; LOCDESCS1
  DEFB 195                ; x=34; LOCDESCS1
  DEFB 195                ; x=35; LOCDESCS1
  DEFB 195                ; x=36; LOCDESCS1
  DEFB 195                ; x=37; LOCDESCS1
  DEFB 184                ; x=38; LOCDESCS38
  DEFB 185                ; x=39; LOCDESCS39
  DEFB 184                ; x=40; LOCDESCS40
  DEFB 189                ; x=41; LOCDESCS41
  DEFB 188                ; x=42; LOCDESCS42
  DEFB 187                ; x=43; LOCDESCS43
  DEFB 190                ; x=44; LOCDESCS44
  DEFB 190                ; x=45; LOCDESCS45
  DEFB 195                ; x=46; LOCDESCS1
  DEFB 195                ; x=47; LOCDESCS1
  DEFB 195                ; x=48; LOCDESCS1
  DEFB 195                ; x=49; LOCDESCS1
  DEFB 195                ; x=50; LOCDESCS1
  DEFB 195                ; x=51; LOCDESCS1
  DEFB 195                ; x=52; LOCDESCS1
  DEFB 186                ; x=53; LOCDESCS53
  DEFB 195                ; x=54; LOCDESCS1
  DEFB 195                ; x=55; LOCDESCS1
  DEFB 195                ; x=56; LOCDESCS1
  DEFB 186                ; x=57; LOCDESCS57
  DEFB 195                ; x=58; LOCDESCS1
  DEFB 195                ; x=59; LOCDESCS1
  DEFB 195                ; x=60; LOCDESCS1
  DEFB 195                ; x=61; LOCDESCS1
  DEFB 186                ; x=62; LOCDESCS62
  DEFB 195                ; x=63; LOCDESCS1
  DEFB 195                ; x=64; LOCDESCS1
  DEFB 191                ; x=65; LOCDESCS65
  DEFB 184                ; x=66; LOCDESCS66
  DEFB 184                ; x=67; LOCDESCS67
  DEFB 184                ; x=68; LOCDESCS68
  DEFB 184                ; x=69; LOCDESCS69
  DEFB 195                ; x=70; LOCDESCS1
  DEFB 188                ; x=71; LOCDESCS71
  DEFB 195                ; x=72; LOCDESCS1
  DEFB 195                ; x=73; LOCDESCS1
  DEFB 186                ; x=74; LOCDESCS74
  DEFB 188                ; x=75; LOCDESCS75
  DEFB 185                ; x=76; LOCDESCS76
  DEFB 186                ; x=77; LOCDESCS77
  DEFB 186                ; x=78; LOCDESCS78
  DEFB 191                ; x=79; LOCDESCS79
  DEFB 191                ; x=80; LOCDESCS80
  DEFB 186                ; x=81; LOCDESCS81
  DEFB 186                ; x=82; LOCDESCS82
  DEFB 187                ; x=83; LOCDESCS83
  DEFB 195                ; x=84; LOCDESCS1
  DEFB 195                ; x=85; LOCDESCS1
  DEFB 187                ; x=86; LOCDESCS86
  DEFB 195                ; x=87; LOCDESCS1
  DEFB 191                ; x=88; LOCDESCS88
  DEFB 191                ; x=89; LOCDESCS89
  DEFB 185                ; x=90; LOCDESCS90
  DEFB 185                ; x=91; LOCDESCS91
  DEFB 187                ; x=92; LOCDESCS92
  DEFB 195                ; x=93; LOCDESCS1
  DEFB 195                ; x=94; LOCDESCS1
  DEFB 195                ; x=95; LOCDESCS1
  DEFB 195                ; x=96; LOCDESCS1
  DEFB 195                ; x=97; LOCDESCS1
  DEFB 195                ; x=98; LOCDESCS1
  DEFB 195                ; x=99; LOCDESCS1
  DEFB 186                ; x=100; LOCDESCS100
  DEFB 195                ; x=101; LOCDESCS1
  DEFB 195                ; x=102; LOCDESCS1
  DEFB 186                ; x=103; LOCDESCS103
  DEFB 195                ; x=104; LOCDESCS1
  DEFB 195                ; x=105; LOCDESCS1
  DEFB 195                ; x=106; LOCDESCS1
  DEFB 195                ; x=107; LOCDESCS1
  DEFB 195                ; x=108; LOCDESCS1
  DEFB 195                ; x=109; LOCDESCS1
  DEFB 195                ; x=110; LOCDESCS1
  DEFB 195                ; x=111; LOCDESCS1
  DEFB 184                ; x=112; LOCDESCS112
  DEFB 189                ; x=113; LOCDESCS41
  DEFB 188                ; x=114; LOCDESCS42
  DEFB 187                ; x=115; LOCDESCS43
  DEFB 190                ; x=116; LOCDESCS116
  DEFB 190                ; x=117; LOCDESCS117
  DEFB 189                ; x=118; LOCDESCS118
  DEFB 195                ; x=119; LOCDESCS1
  DEFB 195                ; x=120; LOCDESCS1
  DEFB 195                ; x=121; LOCDESCS1
  DEFB 195                ; x=122; LOCDESCS1
  DEFB 195                ; x=123; LOCDESCS1
  DEFB 189                ; x=124; LOCDESCS124
  DEFB 186                ; x=125; LOCDESCS125
  DEFB 189                ; x=126; LOCDESCS126
  DEFB 195                ; x=127; LOCDESCS1
  DEFB 195                ; x=128; LOCDESCS1
  DEFB 195                ; x=129; LOCDESCS1
  DEFB 195                ; x=130; LOCDESCS1
  DEFB 195                ; x=131; LOCDESCS1
  DEFB 195                ; x=132; LOCDESCS1
  DEFB 190                ; x=133; LOCDESCS133
  DEFB 195                ; x=134; LOCDESCS1
  DEFB 190                ; x=135; LOCDESCS135
  DEFB 194                ; x=136; LOCDESCS136
  DEFB 194                ; x=137; LOCDESCS137
  DEFB 194                ; x=138; LOCDESCS138
  DEFB 194                ; x=139; LOCDESCS139
  DEFB 195                ; x=140; LOCDESCS1
  DEFB 195                ; x=141; LOCDESCS1
  DEFB 195                ; x=142; LOCDESCS1
  DEFB 195                ; x=143; LOCDESCS1
  DEFB 195                ; x=144; LOCDESCS1
  DEFB 195                ; x=145; LOCDESCS1
  DEFB 195                ; x=146; LOCDESCS1
  DEFB 195                ; x=147; LOCDESCS21
  DEFB 194                ; x=148; LOCDESCS148
  DEFB 185                ; x=149; LOCDESCS149
  DEFB 186                ; x=150; LOCDESCS125
  DEFB 189                ; x=151; LOCDESCS126
  DEFB 194                ; x=152; LOCDESCS152
  DEFB 194                ; x=153; LOCDESCS153
  DEFB 194                ; x=154; LOCDESCS154
  DEFB 194                ; x=155; LOCDESCS155
  DEFB 194                ; x=156; LOCDESCS156
  DEFB 194                ; x=157; LOCDESCS157
  DEFB 194                ; x=158; LOCDESCS158
  DEFB 195                ; x=159; LOCDESCS1
  DEFB 195                ; x=160; LOCDESCS1
  DEFB 195                ; x=161; LOCDESCS1
  DEFB 195                ; x=162; LOCDESCS1
  DEFB 195                ; x=163; LOCDESCS1
  DEFB 195                ; x=164; LOCDESCS1
  DEFB 195                ; x=165; LOCDESCS1
  DEFB 195                ; x=166; LOCDESCS1
  DEFB 195                ; x=167; LOCDESCS1
  DEFB 195                ; x=168; LOCDESCS1
  DEFB 195                ; x=169; LOCDESCS1
  DEFB 195                ; x=170; LOCDESCS1
  DEFB 195                ; x=171; LOCDESCS1
  DEFB 195                ; x=172; LOCDESCS1
  DEFB 195                ; x=173; LOCDESCS1
  DEFB 195                ; x=174; LOCDESCS1
  DEFB 194                ; x=175; LOCDESCS175
  DEFB 255                ; x=176; LOCDESCS176
  DEFB 194                ; x=177; LOCDESCS177
  DEFB 194                ; x=178; LOCDESCS178
  DEFB 195                ; x=179; LOCDESCS179
  DEFB 195                ; x=180; LOCDESCS180
  DEFB 194                ; x=181; LOCDESCS181
  DEFB 189                ; x=182; LOCDESCS182
  DEFB 189                ; x=183; LOCDESCS126
  DEFB 195                ; x=184; LOCDESCS184
  DEFB 195                ; x=185; LOCDESCS1
  DEFB 195                ; x=186; LOCDESCS1
  DEFB 195                ; x=187; LOCDESCS1
  DEFB 195                ; x=188; LOCDESCS1
  DEFB 195                ; x=189; LOCDESCS1
  DEFB 191                ; x=190; LOCDESCS190
  DEFB 195                ; x=191; LOCDESCS1
  DEFB 195                ; x=192; LOCDESCS1
  DEFB 195                ; x=193; LOCDESCS9
  DEFB 195                ; x=194; LOCDESCS10
  DEFB 195                ; x=195; LOCDESCS11
  DEFB 195                ; x=196; LOCDESCS12
  DEFB 184                ; x=197; LOCDESCS13
  DEFB 195                ; x=198; LOCDESCS198
  DEFB 195                ; x=199; LOCDESCS1
  DEFB 195                ; x=200; LOCDESCS1
  DEFB 195                ; x=201; LOCDESCS1
  DEFB 195                ; x=202; LOCDESCS1
  DEFB 195                ; x=203; LOCDESCS1
  DEFB 195                ; x=204; LOCDESCS21
  DEFB 185                ; x=205; LOCDESCS205
  DEFB 195                ; x=206; LOCDESCS23
  DEFB 186                ; x=207; LOCDESCS103
  DEFB 184                ; x=208; LOCDESCS112
  DEFB 189                ; x=209; LOCDESCS41
  DEFB 188                ; x=210; LOCDESCS42
  DEFB 187                ; x=211; LOCDESCS43
  DEFB 190                ; x=212; LOCDESCS44
  DEFB 190                ; x=213; LOCDESCS45
  DEFB 195                ; x=214; LOCDESCS1
  DEFB 195                ; x=215; LOCDESCS1
  DEFB 195                ; x=216; LOCDESCS1
  DEFB 195                ; x=217; LOCDESCS1
  DEFB 195                ; x=218; LOCDESCS1
  DEFB 195                ; x=219; LOCDESCS1
  DEFB 195                ; x=220; LOCDESCS1
  DEFB 195                ; x=221; LOCDESCS1
  DEFB 185                ; x=222; LOCDESCS205
  DEFB 195                ; x=223; LOCDESCS223
  DEFB 195                ; x=224; LOCDESCS16
  DEFB 195                ; x=225; LOCDESCS225
  DEFB 195                ; x=226; LOCDESCS226
  DEFB 195                ; x=227; LOCDESCS1
  DEFB 195                ; x=228; LOCDESCS1
  DEFB 195                ; x=229; LOCDESCS1
  DEFB 195                ; x=230; LOCDESCS6
  DEFB 195                ; x=231; LOCDESCS7
  DEFB 194                ; x=232; LOCDESCS232
  DEFB 194                ; x=233; LOCDESCS233
  DEFB 194                ; x=234; LOCDESCS154
  DEFB 194                ; x=235; LOCDESCS235
  DEFB 194                ; x=236; LOCDESCS156
  DEFB 194                ; x=237; LOCDESCS157
  DEFB 194                ; x=238; LOCDESCS238
  DEFB 195                ; x=239; LOCDESCS239
  DEFB 195                ; x=240; LOCDESCS16
  DEFB 195                ; x=241; LOCDESCS1
  DEFB 195                ; x=242; LOCDESCS1
  DEFB 195                ; x=243; LOCDESCS1
  DEFB 195                ; x=244; LOCDESCS1
  DEFB 195                ; x=245; LOCDESCS1
  DEFB 195                ; x=246; LOCDESCS6
  DEFB 195                ; x=247; LOCDESCS7
  DEFB 194                ; x=248; LOCDESCS152
  DEFB 194                ; x=249; LOCDESCS153
  DEFB 194                ; x=250; LOCDESCS250
  DEFB 194                ; x=251; LOCDESCS251
  DEFB 194                ; x=252; LOCDESCS252
  DEFB 194                ; x=253; LOCDESCS253
  DEFB 186                ; x=254; LOCDESCS254
  DEFB 195                ; x=255; LOCDESCS1

; Sprite graphic data
;
; Used by the routine at GETTILE.
;
; Tile 0 is unused by design (and would appear completely blank if it were
; used). Tiles 91-97, 99-102, 105 and 106 belong exclusively to the unused
; sprites of the Skinny Man character. Tiles 215 and 216 are unused, but
; resemble the body and tail of a cat. Tiles 238-247 are used for Sam's sprite
; when he's rolling or somersaulting (see PREPTILES); tiles 248-255 are used by
; the sprites of characters when they are lying down (see KOTILES).
  DEFB 0,0,0,60,0,0,192,128,1,9,128,0,255,0,0,0
  DEFB 3,192,12,8,16,152,15,240,15,240,0,0,75,0,190,44
  DEFB 0,0,6,176,9,224,20,160,0,0,0,255,7,137,0,82
  DEFB 0,0,15,240,120,144,8,192,121,48,49,32,0,0,0,255
  DEFB 198,124,0,0,15,240,12,96,61,224,12,7,128,0,52,146
  DEFB 0,0,3,64,9,32,52,9,32,2,192,60,3,192,0,97
  DEFB 0,154,84,6,16,9,160,11,32,9,160,5,128,0,0,84
  DEFB 3,148,0,0,5,64,57,64,57,64,0,18,0,60,0,5
  DEFB 51,0,20,126,24,242,129,16,52,48,0,0,0,0,190,11
  DEFB 224,11,224,0,56,0,243,0,3,179,3,128,15,48,59,48
  DEFB 0,53,14,0,0,224,15,27,0,53,0,0,222,5,183,0
  DEFB 0,13,224,91,112,91,112,0,80,0,0,0,0,0,112,0
  DEFB 5,19,7,234,7,0,81,48,126,160,126,160,0,149,0,0
  DEFB 1,0,96,0,16,1,0,0,0,0,6,3,0,96,63,6
  DEFB 3,96,53,15,240,10,72,0,63,192,0,84,0,56,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,255,189,255,254,192,191,253,9,191,254,255,127,255,255
  DEFB 251,223,236,11,208,155,239,251,239,251,199,255,75,127,190,173
  DEFB 252,127,246,183,233,239,212,175,255,255,254,255,247,137,255,82
  DEFB 255,255,239,247,120,151,232,223,121,55,177,47,252,31,254,255
  DEFB 198,125,193,255,175,247,236,111,189,239,236,247,159,255,181,146
  DEFB 255,255,251,95,223,47,181,223,47,250,223,189,251,223,255,97
  DEFB 254,154,85,246,23,233,175,235,47,233,175,245,191,252,15,85
  DEFB 251,149,192,255,229,95,185,95,185,95,255,210,252,188,255,245
  DEFB 51,252,212,126,216,242,129,215,181,183,255,255,255,255,190,235
  DEFB 239,235,239,255,185,254,243,127,251,179,251,159,239,55,187,55
  DEFB 255,181,206,254,252,239,239,219,255,181,255,254,222,245,183,255
  DEFB 255,237,231,91,119,91,119,254,86,255,7,240,127,255,119,255
  DEFB 245,19,247,234,247,127,81,55,126,175,126,175,255,149,255,255
  DEFB 253,126,111,255,215,249,127,127,255,255,246,251,255,97,191,246
  DEFB 251,96,181,239,247,202,75,239,63,223,254,84,255,187,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,34,0,0,192,64,0,138,128,0,41,0,0,0
  DEFB 2,32,12,4,8,168,9,144,6,96,56,0,75,0,186,36
  DEFB 3,128,6,176,10,160,20,160,0,0,0,185,7,137,0,82
  DEFB 0,0,11,144,120,144,8,192,121,48,35,16,3,224,0,255
  DEFB 206,124,62,0,79,240,12,224,60,240,12,7,192,0,74,98
  DEFB 0,0,4,160,6,32,52,6,32,2,64,60,3,192,0,69
  DEFB 0,146,84,4,80,9,32,10,144,9,32,9,64,1,240,194
  DEFB 5,98,31,0,12,32,86,32,86,32,0,17,3,15,0,2
  DEFB 227,1,14,122,23,97,129,40,74,40,0,0,0,0,126,7
  DEFB 224,7,224,0,70,0,173,0,3,189,4,96,10,208,59,208
  DEFB 0,18,62,0,3,224,10,11,0,18,0,0,127,5,183,0
  DEFB 0,7,240,91,112,91,112,0,88,0,248,15,128,0,184,0
  DEFB 5,225,3,198,11,128,94,16,60,96,60,96,0,125,0,0
  DEFB 3,129,128,0,56,6,0,128,0,0,7,3,0,126,63,5
  DEFB 1,95,28,2,144,48,72,16,96,192,0,130,0,72,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,255,34,255,254,192,95,254,138,191,254,41,127,255,255
  DEFB 242,47,236,5,232,171,233,151,246,103,187,255,75,127,186,165
  DEFB 251,191,246,183,234,175,212,175,255,255,254,185,247,137,255,82
  DEFB 255,255,235,151,120,151,232,223,121,55,163,23,251,231,254,255
  DEFB 206,125,190,127,79,247,236,239,188,247,236,247,223,195,74,98
  DEFB 248,127,244,175,246,47,181,246,47,250,95,189,251,223,255,69
  DEFB 254,146,85,244,87,233,47,234,151,233,47,223,95,253,247,194
  DEFB 245,98,223,127,236,47,86,47,86,47,255,209,251,207,255,250
  DEFB 227,253,238,122,215,97,129,171,74,171,255,129,248,31,126,247
  DEFB 239,247,239,254,70,254,173,127,251,189,228,111,234,215,187,215
  DEFB 254,210,190,254,251,239,234,235,255,210,255,255,127,245,183,255
  DEFB 255,247,247,91,119,91,119,254,88,254,251,239,191,254,187,252
  DEFB 245,225,251,198,203,191,94,23,188,111,188,111,252,125,255,255
  DEFB 251,129,159,255,184,6,255,128,31,255,247,251,255,126,191,245
  DEFB 253,95,220,226,151,176,75,213,96,207,254,130,143,75,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,255,0,0,194,64,0,132,128,0,41,0,0,0
  DEFB 15,240,12,36,8,72,9,72,2,96,124,0,139,0,106,20
  DEFB 7,192,10,176,12,160,24,112,0,0,1,113,2,73,0,82
  DEFB 0,0,23,16,36,144,9,192,37,48,37,16,1,248,1,223
  DEFB 254,124,31,128,93,240,15,224,56,240,15,7,192,120,82,74
  DEFB 7,128,5,32,4,160,52,4,160,1,64,126,7,224,0,197
  DEFB 0,130,84,12,80,8,32,10,80,8,32,11,64,1,136,146
  DEFB 9,74,24,128,9,32,148,160,148,160,0,15,1,7,0,1
  DEFB 11,1,7,106,12,129,65,52,210,20,0,126,7,224,126,7
  DEFB 224,7,224,1,249,0,240,128,3,173,31,144,15,8,58,208
  DEFB 1,8,126,0,7,224,15,10,0,8,0,0,255,3,215,0
  DEFB 0,15,240,61,112,61,112,0,47,1,124,23,192,1,248,3
  DEFB 5,225,3,206,63,128,94,16,60,224,60,224,3,125,0,0
  DEFB 7,254,0,0,127,248,0,255,224,0,5,3,0,95,61,5
  DEFB 1,88,25,2,144,64,72,18,112,48,128,130,112,144,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,254,255,127,254,194,95,254,132,191,255,169,127,255,255
  DEFB 239,247,236,37,232,75,233,75,250,111,125,254,139,127,106,213
  DEFB 247,223,234,183,236,175,217,119,255,15,253,113,250,73,255,82
  DEFB 240,255,215,23,164,151,233,223,165,55,165,23,253,251,245,223
  DEFB 254,125,223,191,93,247,239,239,186,247,239,247,223,123,82,74
  DEFB 231,191,229,47,244,175,181,244,175,253,95,126,247,239,254,197
  DEFB 254,130,85,236,87,232,47,234,87,232,47,235,95,249,139,146
  DEFB 249,74,152,191,233,47,148,175,148,175,159,239,253,247,255,253
  DEFB 11,249,247,106,236,129,65,180,210,212,254,126,231,239,126,247
  DEFB 239,247,239,253,249,254,240,191,251,173,223,159,239,11,186,215
  DEFB 253,232,126,254,247,239,239,234,255,232,255,254,255,251,215,255
  DEFB 255,239,247,189,119,189,119,254,175,253,125,215,223,253,251,251
  DEFB 245,225,251,206,191,191,94,23,188,239,188,239,251,125,255,255
  DEFB 247,254,127,255,127,249,255,255,239,255,245,243,255,95,61,245
  DEFB 253,88,217,250,151,64,75,210,119,55,190,130,119,151,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,126,0,0,130,64,0,128,128,0,41,0,0,0
  DEFB 7,224,8,36,8,8,9,72,2,96,124,0,139,0,74,30
  DEFB 7,192,10,176,8,160,24,112,0,240,1,97,2,79,0,82
  DEFB 15,0,22,16,36,240,9,64,37,240,36,144,3,240,9,255
  DEFB 254,124,63,0,47,240,31,224,56,240,15,7,192,252,130,82
  DEFB 15,192,8,32,5,32,52,5,32,1,224,12,0,192,0,197
  DEFB 0,130,84,12,80,8,32,10,80,8,32,11,64,3,252,146
  DEFB 0,210,63,192,9,32,13,32,13,32,96,6,3,11,0,0
  DEFB 255,3,3,74,6,9,67,11,130,19,1,250,31,160,126,7
  DEFB 224,7,224,2,98,0,164,128,3,161,38,32,10,72,58,16
  DEFB 2,4,124,0,7,192,10,10,0,4,0,1,95,3,215,0
  DEFB 0,21,240,61,112,61,112,0,33,1,252,31,192,1,184,0
  DEFB 5,233,3,254,11,128,94,144,31,224,31,224,0,61,0,0
  DEFB 2,254,0,0,47,240,0,255,128,0,7,9,0,127,159,7
  DEFB 0,127,9,2,144,65,56,36,72,8,0,146,72,144,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,255,126,255,254,130,95,254,128,191,255,169,127,255,255
  DEFB 247,239,232,37,232,11,233,75,250,111,125,254,139,127,74,222
  DEFB 247,223,234,183,232,175,217,119,254,247,253,97,250,79,255,82
  DEFB 239,127,214,23,164,247,233,95,165,247,164,151,251,247,233,255
  DEFB 254,125,191,127,175,247,223,239,186,247,239,247,223,253,130,82
  DEFB 239,223,232,47,245,47,181,245,47,253,239,141,240,223,254,197
  DEFB 254,130,85,236,87,232,47,234,87,232,47,235,95,251,253,146
  DEFB 246,210,191,223,233,47,109,47,109,47,111,246,251,251,255,254
  DEFB 255,251,251,74,246,9,67,235,130,211,253,250,223,175,126,247
  DEFB 239,247,239,250,98,254,164,191,251,161,166,47,234,75,186,23
  DEFB 250,244,124,254,247,223,234,234,255,244,255,253,95,251,215,255
  DEFB 255,213,247,189,119,189,119,254,161,253,253,223,223,253,187,252
  DEFB 245,233,251,254,203,191,94,151,223,239,223,239,252,189,255,255
  DEFB 250,254,255,255,175,247,255,255,159,255,247,249,255,127,159,247
  DEFB 254,127,233,250,151,65,59,165,75,203,0,146,75,151,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,102,0,0,130,64,0,128,128,0,41,0,0,0
  DEFB 6,96,8,36,8,8,10,40,2,96,94,0,106,0,74,14
  DEFB 5,224,6,176,9,160,24,112,1,8,2,201,1,57,0,82
  DEFB 16,128,44,144,19,144,9,64,19,112,36,144,0,16,13,255
  DEFB 254,124,1,0,55,240,31,224,56,240,15,7,224,252,146,66
  DEFB 15,192,9,32,4,32,52,4,32,0,224,76,4,192,0,133
  DEFB 0,130,84,8,80,8,32,10,80,8,32,11,64,1,248,147
  DEFB 0,82,31,128,9,48,5,32,5,32,144,0,0,13,0,0
  DEFB 99,1,1,74,3,57,62,4,146,8,1,250,31,160,126,7
  DEFB 224,7,224,1,28,1,68,128,0,161,17,192,20,72,10,16
  DEFB 1,3,88,1,5,128,20,10,0,3,0,2,167,1,249,0
  DEFB 0,42,112,31,48,31,48,0,18,3,254,63,224,3,24,0
  DEFB 7,233,1,254,1,128,126,144,31,224,31,224,0,31,0,0
  DEFB 0,118,0,0,15,248,0,118,0,0,4,13,0,65,223,5
  DEFB 0,95,9,2,144,65,232,40,40,4,127,34,40,160,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,255,102,255,254,130,95,254,128,191,255,169,127,255,255
  DEFB 246,111,232,37,232,11,234,171,250,111,94,254,106,127,74,238
  DEFB 245,239,230,183,233,175,217,119,253,11,250,201,253,57,255,82
  DEFB 208,191,172,151,115,151,233,95,211,119,164,151,252,23,237,255
  DEFB 254,125,193,127,183,247,223,239,186,247,239,247,239,253,146,66
  DEFB 239,223,233,47,244,47,181,244,47,254,239,77,244,223,254,133
  DEFB 254,130,85,232,87,232,47,234,87,232,47,235,95,249,249,147
  DEFB 254,82,159,159,233,63,229,47,229,47,151,248,252,253,255,255
  DEFB 99,249,253,74,251,57,62,244,146,232,253,250,223,175,126,247
  DEFB 239,247,239,253,29,253,68,191,252,161,209,223,212,75,202,23
  DEFB 253,251,91,253,245,191,212,234,255,251,255,250,167,253,249,255
  DEFB 255,170,119,223,55,223,55,254,210,251,254,191,239,251,27,255
  DEFB 247,233,253,254,225,191,126,151,223,239,223,239,255,223,255,255
  DEFB 253,118,255,255,207,251,255,118,127,247,244,253,127,65,223,245
  DEFB 254,95,233,250,151,65,235,167,167,245,127,34,171,175,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,106,0,0,131,64,0,128,128,0,41,0,0,0
  DEFB 6,160,8,52,8,8,10,40,2,80,78,0,114,0,74,14
  DEFB 4,224,6,160,15,96,24,112,1,92,2,137,0,134,0,82
  DEFB 21,192,40,144,12,96,11,64,29,144,36,176,1,8,6,255
  DEFB 254,252,16,128,23,240,31,224,121,240,15,15,224,94,82,124
  DEFB 5,224,5,32,11,192,52,7,192,0,224,68,4,64,0,137
  DEFB 0,130,84,8,144,8,32,10,80,8,32,11,64,1,28,115
  DEFB 0,126,17,192,7,48,7,224,7,224,104,0,1,6,0,0
  DEFB 114,1,0,74,2,193,134,3,210,4,0,186,11,160,126,15
  DEFB 224,7,224,0,236,1,78,128,0,161,14,192,20,232,10,16
  DEFB 0,1,24,1,1,128,20,10,0,1,0,2,183,0,250,0
  DEFB 0,43,112,31,112,31,96,0,10,1,172,26,192,1,152,0
  DEFB 7,249,1,254,9,128,127,144,31,224,31,224,0,3,0,0
  DEFB 0,67,0,0,28,60,0,67,0,8,5,6,128,80,111,1
  DEFB 0,17,7,2,144,63,252,72,36,2,7,194,16,64,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,255,106,255,254,131,95,254,128,191,255,169,127,255,255
  DEFB 246,175,232,53,232,11,234,171,242,87,78,255,114,255,74,238
  DEFB 244,239,246,175,239,111,217,119,253,93,250,137,254,134,254,82
  DEFB 213,223,168,151,236,111,235,95,221,151,164,183,253,11,246,255
  DEFB 254,253,208,191,215,247,223,239,121,247,239,239,239,94,82,124
  DEFB 245,239,245,47,235,223,181,247,223,254,239,69,244,95,254,137
  DEFB 254,130,85,232,151,232,47,234,87,232,47,235,95,253,29,115
  DEFB 255,126,209,223,231,63,231,239,231,239,107,254,141,246,251,255
  DEFB 114,253,254,74,250,193,134,251,210,244,254,186,235,175,126,239
  DEFB 239,247,239,254,237,252,78,191,254,161,238,223,212,235,234,23
  DEFB 206,253,25,253,241,159,212,234,207,253,255,250,183,254,250,255
  DEFB 255,171,119,223,119,223,111,254,234,253,173,218,223,221,155,254
  DEFB 247,249,253,254,223,191,127,151,223,239,223,239,254,227,255,255
  DEFB 255,83,127,255,156,61,255,83,127,251,245,246,191,80,111,249
  DEFB 254,145,231,250,151,191,253,75,165,250,7,194,215,95,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,115,0,0,130,64,0,128,128,0,127,0,0,0
  DEFB 7,48,8,36,8,8,30,72,15,240,46,0,100,0,126,28
  DEFB 3,224,4,192,14,32,48,112,1,4,3,137,0,98,1,254
  DEFB 16,64,56,144,4,64,29,192,21,16,120,224,1,188,3,127
  DEFB 254,92,27,192,59,240,63,224,185,112,15,23,192,78,36,52
  DEFB 4,224,2,64,9,160,108,2,64,1,192,44,2,192,0,146
  DEFB 0,126,124,9,32,15,224,30,240,7,224,29,128,0,36,230
  DEFB 0,124,2,64,14,96,11,32,4,128,40,0,113,3,4,0
  DEFB 134,0,0,126,3,129,98,0,36,3,0,138,8,160,126,15
  DEFB 224,7,224,0,142,2,252,128,0,161,8,224,47,200,10,16
  DEFB 48,2,78,0,4,224,15,10,48,0,0,5,119,0,126,0
  DEFB 0,87,112,63,224,15,224,0,5,1,12,16,192,33,228,1
  DEFB 7,241,0,252,30,64,127,16,31,224,15,192,1,3,0,0
  DEFB 0,65,0,0,112,10,0,65,0,4,5,3,64,91,55,2
  DEFB 0,34,14,7,240,7,236,112,18,0,130,12,40,0,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,255,255,115,127,254,130,95,254,128,191,255,127,127,255,255
  DEFB 247,55,232,37,232,11,222,75,239,247,174,255,100,255,126,221
  DEFB 251,239,244,223,238,47,179,119,253,5,251,137,255,98,253,254
  DEFB 208,95,184,151,244,95,221,223,213,23,122,239,253,189,251,127
  DEFB 254,93,219,223,187,247,191,239,185,119,239,215,223,78,165,181
  DEFB 244,239,226,95,233,175,109,250,95,253,223,173,250,223,254,146
  DEFB 255,126,125,233,47,239,239,222,247,247,239,221,191,252,37,230
  DEFB 255,125,194,95,238,111,235,47,244,159,42,254,117,251,245,255
  DEFB 125,228,254,126,251,129,98,252,165,251,254,138,232,175,126,239
  DEFB 239,247,239,254,142,250,252,191,254,161,232,239,175,203,234,23
  DEFB 182,250,78,254,244,239,239,234,183,254,255,245,119,255,126,255
  DEFB 255,87,119,191,239,239,239,254,245,253,13,208,223,173,229,253
  DEFB 247,241,254,253,222,95,127,23,223,239,239,223,157,251,255,255
  DEFB 255,93,127,255,115,202,255,93,127,245,245,251,95,91,183,250
  DEFB 254,162,238,247,247,199,237,119,210,255,186,13,171,191,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,0,0,176,128,1,92,128,0,128,128,0,255,0,0,0
  DEFB 11,8,21,200,8,8,62,240,15,224,62,0,76,0,36,60
  DEFB 3,224,5,192,15,32,104,208,1,14,7,137,0,82,1,254
  DEFB 16,224,120,144,4,64,63,192,19,32,249,224,0,126,1,191
  DEFB 254,252,7,224,27,240,63,224,249,224,15,31,192,44,76,52
  DEFB 2,192,4,192,18,160,252,2,64,3,192,114,7,32,0,150
  DEFB 0,84,220,9,96,11,32,61,224,4,128,63,128,0,168,204
  DEFB 0,84,10,128,28,192,11,32,4,128,37,1,88,1,10,0
  DEFB 124,24,1,36,7,129,82,0,76,0,0,24,1,128,52,10
  DEFB 160,2,64,0,105,2,249,0,0,255,6,144,47,144,10,240
  DEFB 72,2,110,1,6,224,31,10,72,1,0,5,119,0,126,0
  DEFB 0,87,112,63,224,15,192,1,5,1,8,16,128,81,10,3
  DEFB 7,243,0,252,48,160,127,48,63,224,15,192,99,7,0,0
  DEFB 0,130,0,0,0,4,0,130,0,14,2,1,224,39,27,2
  DEFB 1,42,28,15,240,0,50,112,0,0,1,244,48,0,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  DEFB 0,195,254,176,191,253,92,191,254,128,191,255,255,127,252,63
  DEFB 235,11,213,203,232,11,190,247,239,239,190,255,77,255,165,189
  DEFB 251,239,245,223,239,47,106,215,253,14,247,137,255,82,255,254
  DEFB 208,231,120,151,244,95,191,223,211,47,249,239,254,126,253,191
  DEFB 254,253,247,239,219,247,191,239,249,239,239,255,223,173,77,181
  DEFB 250,223,244,223,210,175,253,250,95,251,223,114,247,47,254,150
  DEFB 255,85,221,233,111,235,47,253,239,244,159,255,191,254,171,205
  DEFB 255,85,234,191,220,223,235,47,244,191,165,253,90,253,234,255
  DEFB 125,218,253,165,247,129,82,255,77,252,255,25,241,159,181,234
  DEFB 175,250,95,255,105,250,249,127,254,255,246,151,175,151,234,247
  DEFB 74,250,110,253,246,239,223,234,74,253,195,245,119,255,126,252
  DEFB 63,87,119,191,239,239,223,253,245,253,9,208,159,85,10,251
  DEFB 247,243,254,253,176,175,127,55,191,239,239,223,107,247,254,159
  DEFB 254,186,255,239,143,245,255,186,255,254,250,253,239,167,219,250
  DEFB 253,170,220,255,247,248,50,112,237,255,253,245,183,255,0,0
  DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

; Character buffers for character group 215
;
; See the character buffer documentation for details of how the buffers are
; used. These buffers belong to the following characters;
;
; +-----------------------+---------------------------------------------------+
; | Character             | Initial location                                  |
; +-----------------------+---------------------------------------------------+
; | Lady in a hat         | Third floor of the apartment building next to no. |
; |                       | 74                                                |
; | Girl with a pony tail | Third floor of no. 74                             |
; | Man in a bowler hat   | Top floor of the hotel                            |
; | None                  | Out of sight                                      |
; | Gangster              | Top floor of no. 19                               |
; +-----------------------+---------------------------------------------------+
;
; See C215INITP1 for more details.
CBUF215;
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 215 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
;
; The value stored here is part of the graphic data that is copied to the
; bottom 3 rows of the screen by the startup routine.
  DEFB 0

; Sprite tile references (tile 0, animatory states 0-127) and graphic data (UDG
; byte 1/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 0,64,3             ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 175,0,175,0,175,0,0 ; Sprite tile references for animatory states 0-7
  DEFB 192                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,0                ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 0,4,32             ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 15
  DEFB 4                  ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 16-20
  DEFB 0,0                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 18                 ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 220,217,220        ; Sprite tile references for animatory states 24-27
  DEFB 217                ; Sprite tile reference for unused animatory state 28
  DEFB 0,66               ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 0,240              ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 220,217,220,217    ; Sprite tile references for animatory states 40-44
  DEFB 0,0,15,0           ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 48-52
  DEFB 0                  ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 0                  ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 56-60
  DEFB 76                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 62-63
  DEFB 0                  ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 14,0,14,0          ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 65                 ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 60                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 8                  ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 0                  ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 14,0,14,0          ; Sprite tile references for animatory states 80-84
  DEFB 12,8               ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 196                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 88-92
  DEFB 3,192              ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 32                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 192,128            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 3                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 104-108
  DEFB 66,60              ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 192                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0,0,0,0      ; Sprite tile references for animatory states 112-119
  DEFB 0                  ; Unused
  DEFB 231                ; Sprite tile reference for animatory state 121
  DEFB 0,0,0,0,0,0        ; Sprite tile references for unused animatory states
                          ; 120 and 122-127

; Character buffers for character group 216
;
; See the character buffer documentation for details of how the buffers are
; used. These buffers belong to the following characters;
;
; +-----------------------+---------------------------------------------------+
; | Character             | Initial location                                  |
; +-----------------------+---------------------------------------------------+
; | Girl with a pony tail | Third floor of the apartment building next to no. |
; |                       | 74                                                |
; | None                  | Out of sight                                      |
; | Lady with big hair    | First floor of no. 31                             |
; | None                  | Out of sight                                      |
; | Gangster              | Top floor of no. 19                               |
; +-----------------------+---------------------------------------------------+
;
; See C216INITP1 for more details.
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 216 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
;
; The value stored here is part of the graphic data that is copied to the
; bottom 3 rows of the screen by the startup routine.
  DEFB 21

; Sprite tile references (tile 1, animatory states 0-127) and graphic data
; (mask byte 1/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 254,64,251         ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 16,2,16,122,16,175,251 ; Sprite tile references for animatory states 0-7
  DEFB 223                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,0                ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 255,244,47         ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 15
  DEFB 228                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 66,60,66,124       ; Sprite tile references for animatory states 16-20
  DEFB 255,255            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 251                ; Sprite tile reference for animatory state 23
  DEFB 210                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 221,218,221        ; Sprite tile references for animatory states 24-27
  DEFB 218                ; Sprite tile reference for unused animatory state 28
  DEFB 227,66             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 114,109,114,129    ; Sprite tile references for animatory states 32-36
  DEFB 255,240            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 251                ; Sprite tile reference for animatory state 39
  DEFB 255                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 225,223,225,223    ; Sprite tile references for animatory states 40-44
  DEFB 254,63,239,1       ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 32,0,32,126        ; Sprite tile references for animatory states 48-52
  DEFB 241                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,251              ; Sprite tile references for animatory states 54-55
  DEFB 240                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 48,40,48,40        ; Sprite tile references for animatory states 56-60
  DEFB 76                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,251              ; Sprite tile references for animatory states 62-63
  DEFB 31                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 92,0,92,0          ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 65                 ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 251                ; Sprite tile reference for unused animatory state 71
  DEFB 189                ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 80,27,80,27        ; Sprite tile references for animatory states 72-76
  DEFB 239                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 251                ; Sprite tile reference for animatory state 79
  DEFB 255                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 154,147,154,160    ; Sprite tile references for animatory states 80-84
  DEFB 236,11             ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 251                ; Sprite tile reference for animatory state 87
  DEFB 196                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 164,0,164,168      ; Sprite tile references for animatory states 88-92
  DEFB 251,223            ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 251                ; Sprite tile reference for animatory state 95
  DEFB 47                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 140,138,140,138    ; Sprite tile references for animatory states 96-100
  DEFB 192,191            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 251                ; Sprite tile reference for animatory state 103
  DEFB 251                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 187,185,187,189    ; Sprite tile references for animatory states 104-108
  DEFB 66,189             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 251                ; Sprite tile reference for animatory state 111
  DEFB 223                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 196,191,196,204,0,0,251 ; Sprite tile references for animatory states
                               ; 112-119
  DEFB 0                  ; Unused
  DEFB 232                ; Sprite tile reference for animatory state 121
  DEFB 0,0,0,0,0,0        ; Sprite tile references for unused animatory states
                          ; 120 and 122-127

; Character buffers for character group 217
;
; See the character buffer documentation for details of how the buffers are
; used.  These buffers belong to the following characters;
;
; +-----------------------+------------------------------+
; | Character             | Initial location             |
; +-----------------------+------------------------------+
; | Man in a baseball cap | Shop at the far left of town |
; | None                  | Out of sight                 |
; | Girl with a pony tail | Top floor of no. 31          |
; | None                  | Out of sight                 |
; | Man in a bowler hat   | Sidewalk outside no. 15      |
; +-----------------------+------------------------------+
;
; See C217INITP1 for more details.
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 217 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
;
; The value stored here is part of the graphic data that is copied to the
; bottom 3 rows of the screen by the startup routine.
  DEFB 24

; Sprite tile references (tile 2, animatory states 0-127) and graphic data (UDG
; byte 2/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 0,160,2            ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 18,183,18,123,18,16,255 ; Sprite tile references for animatory states
                               ; 0-7
  DEFB 160                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 244,239            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 0,4,32             ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 15
  DEFB 10                 ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 68,62,68,125       ; Sprite tile references for animatory states 16-20
  DEFB 0,0                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 255                ; Sprite tile reference for animatory state 23
  DEFB 16                 ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 222,219,222        ; Sprite tile references for animatory states 24-27
  DEFB 219                ; Sprite tile reference for unused animatory state 28
  DEFB 28,66              ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 116,5,116,130      ; Sprite tile references for animatory states 32-36
  DEFB 0,240              ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 255                ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 226,224,226,224    ; Sprite tile references for animatory states 40-44
  DEFB 1,192,15,254       ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 34,27,34,127       ; Sprite tile references for animatory states 48-52
  DEFB 14                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,255              ; Sprite tile references for animatory states 54-55
  DEFB 15                 ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 50,42,50,132       ; Sprite tile references for animatory states 56-60
  DEFB 92                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,255              ; Sprite tile references for animatory states 62-63
  DEFB 224                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 99,94,99,137       ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 1                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 255                ; Sprite tile reference for unused animatory state 71
  DEFB 42                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 82,27,82,135       ; Sprite tile references for animatory states 72-76
  DEFB 16                 ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 255                ; Sprite tile reference for animatory state 79
  DEFB 0                  ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 156,149,156,161    ; Sprite tile references for animatory states 80-84
  DEFB 12,196             ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 255                ; Sprite tile reference for animatory state 87
  DEFB 196                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 166,163,166,169    ; Sprite tile references for animatory states 88-92
  DEFB 3,224              ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 255                ; Sprite tile reference for animatory state 95
  DEFB 32                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 82,27,82,135       ; Sprite tile references for animatory states 96-100
  DEFB 204,64             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 255                ; Sprite tile reference for animatory state 103
  DEFB 2                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 177,171,177,184    ; Sprite tile references for animatory states 104-108
  DEFB 66,62              ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 255                ; Sprite tile reference for animatory state 111
  DEFB 160                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 198,192,198,205,0,0,255 ; Sprite tile references for animatory states
                               ; 112-119
  DEFB 0                  ; Unused
  DEFB 0                  ; Sprite tile reference for animatory state 121
  DEFB 0,0,0,0,0,0        ; Sprite tile references for unused animatory states
                          ; 120 and 122-127

; Character buffers for character group 218
;
; See the character buffer documentation for details of how the buffers are
; used. These buffers belong to the following characters;
;
; +---------------+----------------------------------------------------+
; | Character     | Initial location                                   |
; +---------------+----------------------------------------------------+
; | Cat           | Outside the shop on the right-hand side under the  |
; |               | apartments next to no. 74                          |
; | Lady in a hat | Second floor of the hotel                          |
; | None          | Out of sight                                       |
; | Cat           | Left edge of the apartment building next to no. 19 |
; | Lady in a hat | Sidewalk outside no. 17                            |
; +---------------+----------------------------------------------------+
;
; See C218INITP1 for more details.
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 218 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
;
; The value stored here is part of the graphic data that is copied to the
; bottom 3 rows of the screen by the startup routine.
  DEFB 0

; Sprite tile references (tile 3, animatory states 0-127) and graphic data
; (mask byte 2/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 254,160,242        ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 20,8,20,8,20,18,0  ; Sprite tile references for animatory states 0-7
  DEFB 175                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 241,245            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 127,196,39         ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 15
  DEFB 234                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 70,8,74,8          ; Sprite tile references for animatory states 16-20
  DEFB 255,252            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 208                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 70,8,74            ; Sprite tile references for animatory states 24-27
  DEFB 8                  ; Sprite tile reference for unused animatory state 28
  DEFB 221,66             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 246                ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 118,112,120,112    ; Sprite tile references for animatory states 32-36
  DEFB 252,240            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 254                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 118,112,120,112    ; Sprite tile references for animatory states 40-44
  DEFB 253,223,239,254    ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 36,11,36,11        ; Sprite tile references for animatory states 48-52
  DEFB 238                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 239                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 52,44,56,44        ; Sprite tile references for animatory states 56-60
  DEFB 92                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 62-63
  DEFB 239                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 101,96,105,96      ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 1                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 170                ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 84,11,87,11        ; Sprite tile references for animatory states 72-76
  DEFB 211                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 255                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 158,152,158,152    ; Sprite tile references for animatory states 80-84
  DEFB 236,197            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 196                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 167,8,167,8        ; Sprite tile references for animatory states 88-92
  DEFB 243,239            ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 47                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 143,11,145,11      ; Sprite tile references for animatory states 96-100
  DEFB 204,95             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 250                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 179,173,181,173    ; Sprite tile references for animatory states 104-108
  DEFB 66,62              ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 175                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 200,194,202,194,211,206,0 ; Sprite tile references for animatory states
                                 ; 112-119
  DEFB 0                  ; Unused
  DEFB 233                ; Sprite tile reference for animatory state 121
  DEFB 0,0,0,0,0,0        ; Sprite tile references for unused animatory states
                          ; 120 and 122-127

; Character buffers for character group 219
;
; See the character buffer documentation for details of how the buffers are
; used. These buffers belong to the following characters;
;
; +-----------------------+---------------------------------------------------+
; | Character             | Initial location                                  |
; +-----------------------+---------------------------------------------------+
; | Gangster              | Top floor of the apartment building next to no.   |
; |                       | 74                                                |
; | Man in a baseball cap | Third floor of the hotel                          |
; | Policeman (jailer)    | Third floor of the police station                 |
; | Lady with big hair    | Third floor of the apartment building next to no. |
; |                       | 19                                                |
; | Lady in a hat         | Third floor of no. 15                             |
; +-----------------------+---------------------------------------------------+
;
; See C219INITP1 for more details.
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 219 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
  DEFB 0

; Sprite tile references (tile 4, animatory states 0-119) and graphic data (UDG
; byte 3/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 1,18,13            ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 22,11,24,11,227,229,250 ; Sprite tile references for animatory states
                               ; 0-7
  DEFB 80                 ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,246              ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 128,63,248         ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 242                ; Sprite tile reference for animatory state 15
  DEFB 17                 ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 72,46,75,46        ; Sprite tile references for animatory states 16-20
  DEFB 0,3                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 250                ; Sprite tile reference for animatory state 23
  DEFB 15                 ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 72,46,75           ; Sprite tile references for animatory states 24-27
  DEFB 46                 ; Sprite tile reference for unused animatory state 28
  DEFB 62,255             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 247                ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 103,0,107,0        ; Sprite tile references for animatory states 32-36
  DEFB 3,242              ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 250                ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 103,0,107,0        ; Sprite tile references for animatory states 40-44
  DEFB 3,224,31,127       ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 38,0,38,0          ; Sprite tile references for animatory states 48-52
  DEFB 29                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,250              ; Sprite tile references for animatory states 54-55
  DEFB 7                  ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 54,46,58,46        ; Sprite tile references for animatory states 56-60
  DEFB 92                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,250              ; Sprite tile references for animatory states 62-63
  DEFB 240                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 103,0,107,0        ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 1                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 250                ; Sprite tile reference for unused animatory state 71
  DEFB 69                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 38,0,89,0          ; Sprite tile references for animatory states 72-76
  DEFB 16                 ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 250                ; Sprite tile reference for animatory state 79
  DEFB 0                  ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 38,0,89,0          ; Sprite tile references for animatory states 80-84
  DEFB 12,228             ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 250                ; Sprite tile reference for animatory state 87
  DEFB 196                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 38,0,89,0          ; Sprite tile references for animatory states 88-92
  DEFB 15,240             ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 250                ; Sprite tile reference for animatory state 95
  DEFB 64                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 38,0,89,0          ; Sprite tile references for animatory states 96-100
  DEFB 206,64             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 250                ; Sprite tile reference for animatory state 103
  DEFB 4                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 72,46,75,46        ; Sprite tile references for animatory states 104-108
  DEFB 68,255             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 250                ; Sprite tile reference for animatory state 111
  DEFB 80                 ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 72,46,75,46,212,208,250 ; Sprite tile references for animatory states
                               ; 112-119

; Unused
;
; These bytes are unused, but they may once have held attribute bytes to be
; used for animatory states 120-127/248-255 (see GETTILE).
OBJATTR;
  DEFS 8

; Character buffers for character group 220
;
; See the character buffer documentation for details of how the buffers are
; used. These buffers belong to the following characters;
;
; +-----------------------+---------------------------------------------------+
; | Character             | Initial location                                  |
; +-----------------------+---------------------------------------------------+
; | Lady with big hair    | Sidewalk by the left edge of no. 74               |
; | Lady with big hair    | Third floor of the hotel                          |
; | None                  | Out of sight                                      |
; | Man in a baseball cap | Third floor of the apartment building next to no. |
; |                       | 19                                                |
; | Lady with big hair    | Second floor of no. 15                            |
; +-----------------------+---------------------------------------------------+
;
; See C220INITP1 for more details.
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 220 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
  DEFB 0

; Sprite tile references (tile 5, animatory states 0-119) and graphic data
; (mask byte 3/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 253,18,237         ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 176,170,176,170,176,0,254 ; Sprite tile references for animatory states
                                 ; 0-7
  DEFB 87                 ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,0                ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 191,191,251        ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 15
  DEFB 209                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 16-20
  DEFB 255,251            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 254                ; Sprite tile reference for animatory state 23
  DEFB 239                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 0,0,0              ; Sprite tile references for animatory states 24-27
  DEFB 0                  ; Sprite tile reference for unused animatory state 28
  DEFB 190,255            ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 155,242            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 254                ; Sprite tile reference for animatory state 39
  DEFB 255                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 40-44
  DEFB 251,239,223,127    ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 48-52
  DEFB 221                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,254              ; Sprite tile references for animatory states 54-55
  DEFB 247                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 56-60
  DEFB 92                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,254              ; Sprite tile references for animatory states 62-63
  DEFB 247                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 15,1,15,1          ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 1                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 254                ; Sprite tile reference for unused animatory state 71
  DEFB 69                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 209                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 254                ; Sprite tile reference for animatory state 79
  DEFB 127                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 15,1,15,1          ; Sprite tile references for animatory states 80-84
  DEFB 236,228            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 254                ; Sprite tile reference for animatory state 87
  DEFB 196                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 88-92
  DEFB 239,247            ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 254                ; Sprite tile reference for animatory state 95
  DEFB 95                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 206,79             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 254                ; Sprite tile reference for animatory state 103
  DEFB 244                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 104-108
  DEFB 69,255             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 254                ; Sprite tile reference for animatory state 111
  DEFB 87                 ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0,0,0,254    ; Sprite tile references for animatory states 112-119

; Unused
  DEFS 8

; Character buffers for character group 221
;
; See the character buffer documentation for details of how the buffers are
; used. These buffers belong to the following characters;
;
; +---------------------+----------------------------------------------------+
; | Character           | Initial location                                   |
; +---------------------+----------------------------------------------------+
; | Gangster            | Second floor of no. 74                             |
; | Man in a bowler hat | Second floor of the hotel                          |
; | None                | Out of sight                                       |
; | Man in a bowler hat | Second floor of the apartment building next to no. |
; |                     | 19                                                 |
; | None                | Out of sight                                       |
; +---------------------+----------------------------------------------------+
;
; See C221INITP1 for more details.
CBUF221;
  DEFS 25                 ; Primary character buffer, used by the routine at
                          ; MVCHARS
  DEFS 25                 ; Secondary character buffers (for the characters in
  DEFS 25                 ; group 221 who are currently off screen)
  DEFS 25                 ;
  DEFS 25                 ;

; Unused
  DEFB 0

; Sprite tile references (tile 6, animatory states 0-119) and graphic data (UDG
; byte 4/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 1,82,7             ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 17,3,17,3,17,176,0 ; Sprite tile references for animatory states 0-7
  DEFB 224                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 247,242            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 0,7,224            ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 241                ; Sprite tile reference for animatory state 15
  DEFB 21                 ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 67,61,67,61        ; Sprite tile references for animatory states 16-20
  DEFB 0,0                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 7                  ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 67,61,67           ; Sprite tile references for animatory states 24-27
  DEFB 61                 ; Sprite tile reference for unused animatory state 28
  DEFB 66,126             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 245                ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 115,110,115,110    ; Sprite tile references for animatory states 32-36
  DEFB 96,226             ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 115,110,115,110    ; Sprite tile references for animatory states 40-44
  DEFB 4,32,30,226        ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 33,26,33,26        ; Sprite tile references for animatory states 48-52
  DEFB 20                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 14                 ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 49,41,49,41        ; Sprite tile references for animatory states 56-60
  DEFB 84                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 62-63
  DEFB 32                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 93,91,93,91        ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 1                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 68                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 81,77,81,77        ; Sprite tile references for animatory states 72-76
  DEFB 163                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 128                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 155,148,155,148    ; Sprite tile references for animatory states 80-84
  DEFB 8,231              ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 131                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 165,162,165,162    ; Sprite tile references for animatory states 88-92
  DEFB 7,224              ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 192                ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 141,139,141,139    ; Sprite tile references for animatory states 96-100
  DEFB 142,112            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 4                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 188,186,188,186    ; Sprite tile references for animatory states 104-108
  DEFB 60,126             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 72                 ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 197,190,197,190,0,0,0 ; Sprite tile references for animatory states
                             ; 112-119

; Unused
  DEFS 8

; Character buffer for character 222
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by one of the two policemen in demo mode and game modes
; 1-3, and is unused in game mode 4. See C222MODE0 for more details.
CBUFCOP1;
  DEFS 32

; Initialisation parameters for character 222
;
; The first set of parameters is used in demo mode.
C222MODE0;
  DEFB 16                 ; Animatory state (16; policeman)
  DEFB 20,34              ; Location (sidewalk outside the right-hand shop
                          ; under the apartments next to no. 74)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST12            ; Command list; Patrol duty (demo mode)
; The next set of parameters is used in game mode 1.
C222MODE1;
  DEFB 16                 ; Animatory state (16; policeman)
  DEFB 20,34              ; Location (sidewalk outside the right-hand shop
                          ; under the apartments next to no. 74)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST02            ; Command list; Patrol duty
; The next set of parameters is used in game mode 2.
C222MODE2;
  DEFB 16                 ; Animatory state (16; policeman)
  DEFB 20,34              ; Location (sidewalk outside the right-hand shop
                          ; under the apartments next to no. 74)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST02            ; Command list; Patrol duty
; The next set of parameters is used in game mode 3.
C222MODE3;
  DEFB 16                 ; Animatory state (16; policeman)
  DEFB 20,34              ; Location (sidewalk outside the right-hand shop
                          ; under the apartments next to no. 74)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST02            ; Command list; Patrol duty
; The next set of parameters is used in game mode 4.
C222MODE4;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing

; Sprite tile references used by Sam in disguise
;
; Used by the routine at CHGGUISE. When Sam changes disguise, the sprite tiles
; with the references listed here must be modified.
GUISEREFS;
  DEFB 2,3,4,170,183,6,7,175,176,16,17,18,19,122,123
  DEFB 0                  ; End marker

; Unused
  DEFS 48

; Sprite tile references (tile 7, animatory states 0-119) and graphic data
; (mask byte 4/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 253,82,247         ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 19,6,19,6,19,17,249 ; Sprite tile references for animatory states 0-7
  DEFB 239                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 243,240            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 127,199,231        ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 240                ; Sprite tile reference for animatory state 15
  DEFB 213                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 69,63,69,63        ; Sprite tile references for animatory states 16-20
  DEFB 255,252            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 249                ; Sprite tile reference for animatory state 23
  DEFB 247                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 69,63,69           ; Sprite tile references for animatory states 24-27
  DEFB 63                 ; Sprite tile reference for unused animatory state 28
  DEFB 66,126             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 243                ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 117,111,117,111    ; Sprite tile references for animatory states 32-36
  DEFB 108,226            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 249                ; Sprite tile reference for animatory state 39
  DEFB 254                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 117,111,117,111    ; Sprite tile references for animatory states 40-44
  DEFB 244,47,222,226     ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 35,28,35,128       ; Sprite tile references for animatory states 48-52
  DEFB 212                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,249              ; Sprite tile references for animatory states 54-55
  DEFB 238                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 51,43,51,133       ; Sprite tile references for animatory states 56-60
  DEFB 84                 ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,249              ; Sprite tile references for animatory states 62-63
  DEFB 47                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 100,95,100,95      ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 1                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 249                ; Sprite tile reference for unused animatory state 71
  DEFB 68                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 83,78,83,136       ; Sprite tile references for animatory states 72-76
  DEFB 163                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 249                ; Sprite tile reference for animatory state 79
  DEFB 191                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 157,150,157,150    ; Sprite tile references for animatory states 80-84
  DEFB 232,231            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 249                ; Sprite tile reference for animatory state 87
  DEFB 131                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 157,150,157,150    ; Sprite tile references for animatory states 88-92
  DEFB 247,239            ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 249                ; Sprite tile reference for animatory state 95
  DEFB 223                ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 83,78,83,136       ; Sprite tile references for animatory states 96-100
  DEFB 142,127            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 249                ; Sprite tile reference for animatory state 103
  DEFB 244                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 178,172,178,172    ; Sprite tile references for animatory states 104-108
  DEFB 61,126             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 249                ; Sprite tile reference for animatory state 111
  DEFB 75                 ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 199,193,199,193,0,0,249 ; Sprite tile references for animatory states
                               ; 112-119

; Unused
  DEFS 8

; Character buffer for character 223
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by one of the two policemen in game modes 1-3, and is
; unused in demo mode and game mode 4. See C223MODE0 for more details.
  DEFS 32

; Initialisation parameters for character 223
;
; The first set of parameters is used in demo mode.
C223MODE0;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing
; The next set of parameters is used in game mode 1.
C223MODE1;
  DEFB 146                ; Animatory state (146; policeman)
  DEFB 80,34              ; Location (sidewalk outside the hotel doors)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST02            ; Command list; Patrol duty
; The next set of parameters is used in game mode 2.
C223MODE2;
  DEFB 146                ; Animatory state (146; policeman)
  DEFB 80,34              ; Location (sidewalk outside the hotel doors)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST02            ; Command list; Patrol duty
; The next set of parameters is used in game mode 3.
C223MODE3;
  DEFB 146                ; Animatory state (146; policeman)
  DEFB 80,34              ; Location (sidewalk outside the hotel doors)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST02            ; Command list; Patrol duty
; The next set of parameters is used in game mode 4.
C223MODE4;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing

; Sprite tile references for Sam in disguise 0
;
; Used by the routine at CHGGUISE.
GUISE0REFS;
  DEFB 80,82,84,86,88
  DEFB 90,92,94,96,98
  DEFB 100,102,104,106,108

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 1/8)
;
; Used by the routine at CHGGUISE.
GUISEDATA1;
  DEFB 0,255,60,189,0,255,0,255,0,254,192,192,128,191,0,255
  DEFB 0,255,3,251,192,223,12,236,8,11,0,255,18,210,0,255
  DEFB 0,255,0,255,0,255,8,248,16,31,129,129,60,189

; Sprite tile references (tile 8, animatory states 0-119) and graphic data (UDG
; byte 5/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 1,18,6             ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 21,9,21,9,21,19,253 ; Sprite tile references for animatory states 0-7
  DEFB 96                 ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 240,243            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 0,4,96             ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 239                ; Sprite tile reference for animatory state 15
  DEFB 17                 ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 71,64,71,64        ; Sprite tile references for animatory states 16-20
  DEFB 0,0                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 253                ; Sprite tile reference for animatory state 23
  DEFB 1                  ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 71,64,71           ; Sprite tile references for animatory states 24-27
  DEFB 64                 ; Sprite tile reference for unused animatory state 28
  DEFB 70,70              ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 244                ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 119,113,121,113    ; Sprite tile references for animatory states 32-36
  DEFB 144,194            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 253                ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 119,113,121,113    ; Sprite tile references for animatory states 40-44
  DEFB 4,96,28,70         ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 37,30,37,131       ; Sprite tile references for animatory states 48-52
  DEFB 52                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,253              ; Sprite tile references for animatory states 54-55
  DEFB 4                  ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 53,45,57,134       ; Sprite tile references for animatory states 56-60
  DEFB 242                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,253              ; Sprite tile references for animatory states 62-63
  DEFB 96                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 102,97,106,97      ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 2                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 253                ; Sprite tile reference for unused animatory state 71
  DEFB 72                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 85,79,88,79        ; Sprite tile references for animatory states 72-76
  DEFB 66                 ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 253                ; Sprite tile reference for animatory state 79
  DEFB 128                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 159,153,159,153    ; Sprite tile references for animatory states 80-84
  DEFB 9,231              ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 253                ; Sprite tile reference for animatory state 87
  DEFB 130                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 159,153,159,153    ; Sprite tile references for animatory states 88-92
  DEFB 6,96               ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 253                ; Sprite tile reference for animatory state 95
  DEFB 64                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 144,142,146,142    ; Sprite tile references for animatory states 96-100
  DEFB 158,112            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 253                ; Sprite tile reference for animatory state 103
  DEFB 4                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 180,174,182,174    ; Sprite tile references for animatory states 104-108
  DEFB 36,102             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 253                ; Sprite tile reference for animatory state 111
  DEFB 136                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 201,195,203,195,206,0,253 ; Sprite tile references for animatory states
                                 ; 112-119

; Unused
  DEFS 8

; Character buffer for character 224
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by the following characters;
;
; +--------------+---------------------------------------------------+
; | Game mode(s) | Character                                         |
; +--------------+---------------------------------------------------+
; | 0            | Gangster                                          |
; | 1            | Gangster at no. 15                                |
; | 2, 3         | Gangster outside the police station               |
; | 4            | Gangster who drops Sam off the apartment building |
; +--------------+---------------------------------------------------+
;
; See C224MODE0 for more details.
  DEFS 32

; Initialisation parameters for character 224
;
; The first set of parameters is used in demo mode.
C224MODE0;
  DEFB 160                ; Animatory state (160; gangster)
  DEFB 100,34             ; Location (sidewalk at the right edge of the hotel)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST22            ; Command list; Hotel walkabout
; The next set of parameters is used in game mode 1.
C224MODE1;
  DEFB 160                ; Animatory state (160; gangster)
  DEFB 248,25             ; Location (second floor of no. 15)
  DEFB 1                  ; z-coordinate (indoors)
  DEFW CLIST01            ; Command list; Keep guard at no. 15
; The next set of parameters is used in game mode 2.
C224MODE2;
  DEFB 160                ; Animatory state (160; gangster)
  DEFB 147,34             ; Location (sidewalk outside the right-hand jail
                          ; cell)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST11            ; Command list; Keep guard outside the police station
; The next set of parameters is used in game mode 3.
C224MODE3;
  DEFB 160                ; Animatory state (160; gangster)
  DEFB 147,34             ; Location (sidewalk outside the right-hand jail
                          ; cell)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST11            ; Command list; Keep guard outside the police station
; The next set of parameters is used in game mode 4.
C224MODE4;
  DEFB 160                ; Animatory state (160; gangster)
  DEFB 147,34             ; Location (sidewalk outside the right-hand jail
                          ; cell)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST07            ; Command list; Chase Sam for ever

; Sprite tile references for Sam in disguise 1
;
; Used by the routine at CHGGUISE.
GUISE1REFS;
  DEFB 112,122,149,110,88
  DEFB 90,92,114,116,118
  DEFB 120,102,104,106,108

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 2/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,255,34,34,0,255,0,255,0,254,192,192,64,95,0,255
  DEFB 0,255,2,242,32,47,12,236,4,5,0,255,17,209,0,255
  DEFB 0,255,0,255,0,255,4,244,32,47,66,66,42,42

; Sprite tile references (tile 9, animatory states 0-119) and graphic data
; (mask byte 5/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 253,18,246         ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 23,12,25,12,228,230,0 ; Sprite tile references for animatory states 0-7
  DEFB 111                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 242,247            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 255,196,111        ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 244                ; Sprite tile reference for animatory state 15
  DEFB 209                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 73,65,76,65        ; Sprite tile references for animatory states 16-20
  DEFB 255,252            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 249                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 73,65,76           ; Sprite tile references for animatory states 24-27
  DEFB 65                 ; Sprite tile reference for unused animatory state 28
  DEFB 70,70              ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 239                ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 104,98,108,98      ; Sprite tile references for animatory states 32-36
  DEFB 148,194            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 255                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 104,98,108,98      ; Sprite tile references for animatory states 40-44
  DEFB 244,111,220,70     ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 39,31,39,31        ; Sprite tile references for animatory states 48-52
  DEFB 180                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 244                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 55,47,59,47        ; Sprite tile references for animatory states 56-60
  DEFB 242                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 236,0              ; Sprite tile references for animatory states 62-63
  DEFB 111                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 104,98,108,98      ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 2                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 237                ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 72                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 39,86,90,86        ; Sprite tile references for animatory states 72-76
  DEFB 66                 ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 191                ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 39,86,90,86        ; Sprite tile references for animatory states 80-84
  DEFB 233,231            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 130                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 39,86,90,86        ; Sprite tile references for animatory states 88-92
  DEFB 246,111            ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 95                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 39,86,90,86        ; Sprite tile references for animatory states 96-100
  DEFB 158,127            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 244                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 73,65,76,65        ; Sprite tile references for animatory states 104-108
  DEFB 37,102             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 139                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 73,65,76,65,213,209,0 ; Sprite tile references for animatory states
                             ; 112-119

; Unused
  DEFS 8

; Character buffer for character 225
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by the Fat Man in game mode 2, and by Lana in game mode
; 3; it is unused in demo mode and game modes 1 and 4. See C225MODE0 for more
; details.
CBUF225;
  DEFS 32

; Initialisation parameters for character 225
;
; The first set of parameters is used in demo mode.
C225MODE0;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing
; The next set of parameters is used in game mode 1.
C225MODE1;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST30            ; Command list; Do nothing
; The next set of parameters is used in game mode 2.
C225MODE2;
  DEFB 56                 ; Animatory state (56; Fat Man)
  DEFB 150,34             ; Location (sidewalk at the left edge of no. 27)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST13            ; Command list; Control the fat man
; The next set of parameters is used in game mode 3.
C225MODE3;
  DEFB 48                 ; Animatory state (48; Lana)
  DEFB 180,31             ; Location (first floor of the apartment building
                          ; next to no. 19, left-hand side)
  DEFB 1                  ; z-coordinate (indoors)
  DEFW CLIST14            ; Command list; Go to Sam's office
; The next set of parameters is used in game mode 4.
C225MODE4;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing

; Sprite tile references for Sam in disguise 2
;
; Used by the routine at CHGGUISE.
GUISE2REFS;
  DEFB 80,124,84,86,126
  DEFB 127,92,94,96,128
  DEFB 136,144,104,106,152

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 3/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,254,255,255,0,127,0,255,0,254,194,194,64,95,0,255
  DEFB 0,255,15,239,240,247,12,236,36,37,0,159,15,239,0,255
  DEFB 0,255,0,255,0,255,4,244,96,111,70,70,213,213

; Sprite tile references (tile 10, animatory states 0-119) and graphic data
; (UDG byte 6/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 0,163,6            ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0,0,0,248    ; Sprite tile references for animatory states 0-7
  DEFB 160                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,0                ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 0,62,160           ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 243                ; Sprite tile reference for animatory state 15
  DEFB 10                 ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 16-20
  DEFB 0,3                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 248                ; Sprite tile reference for animatory state 23
  DEFB 0                  ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 0,0,0              ; Sprite tile references for animatory states 24-27
  DEFB 0                  ; Sprite tile reference for unused animatory state 28
  DEFB 74,234             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 240                ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 107,131            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 248                ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 40-44
  DEFB 4,160,8,74         ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 48-52
  DEFB 38                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,248              ; Sprite tile references for animatory states 54-55
  DEFB 4                  ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 56-60
  DEFB 161                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,248              ; Sprite tile references for animatory states 62-63
  DEFB 160                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 2                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 248                ; Sprite tile reference for unused animatory state 71
  DEFB 72                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 4                  ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 248                ; Sprite tile reference for animatory state 79
  DEFB 64                 ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 80-84
  DEFB 9,247              ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 248                ; Sprite tile reference for animatory state 87
  DEFB 131                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 88-92
  DEFB 6,160              ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 248                ; Sprite tile reference for animatory state 95
  DEFB 64                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 159,112            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 248                ; Sprite tile reference for animatory state 103
  DEFB 4                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 104-108
  DEFB 52,106             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 248                ; Sprite tile reference for animatory state 111
  DEFB 132                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0,0,0,248    ; Sprite tile references for animatory states 112-119

; Unused
  DEFS 8

; Character buffer for character 226
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by Daisy in demo mode and game modes 1-3, and is unused
; in game mode 4. See C226MODE0 for more details.
  DEFS 32

; Initialisation parameters for character 226
;
; The first set of parameters is used in demo mode.
C226MODE0;
  DEFB 200                ; Animatory state (200; Daisy)
  DEFB 189,7              ; Location (roof of the apartment building next to
                          ; no. 19)
  DEFB 1                  ; z-coordinate (indoors)
  DEFW CLIST31            ; Command list; Walk up and down for ever
; The next set of parameters is used in game mode 1.
C226MODE1;
  DEFB 200                ; Animatory state (200; Daisy)
  DEFB 233,25             ; Location (second floor of no. 17, near the
                          ; rightmost window)
  DEFB 1                  ; z-coordinate (indoors)
  DEFW CLIST25            ; Command list; Control Daisy
; The next set of parameters is used in game mode 2.
C226MODE2;
  DEFB 200                ; Animatory state (200; Daisy)
  DEFB 233,25             ; Location (second floor of no. 17, near the
                          ; rightmost window)
  DEFB 1                  ; z-coordinate (indoors)
  DEFW CLIST25            ; Command list; Control Daisy
; The next set of parameters is used in game mode 3.
C226MODE3;
  DEFB 200                ; Animatory state (200; Daisy)
  DEFB 233,25             ; Location (second floor of no. 17, near the
                          ; rightmost window)
  DEFB 1                  ; z-coordinate (indoors)
  DEFW CLIST25            ; Command list; Control Daisy
; The next set of parameters is used in game mode 4.
C226MODE4;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing

; Sprite tile references for Sam in disguise 3
;
; Used by the routine at CHGGUISE.
GUISE3REFS;
  DEFB 168,176,84,160,88
  DEFB 90,92,160,160,184
  DEFB 192,102,104,108,108

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 4/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,255,126,126,0,255,0,255,0,254,130,130,64,95,0,255
  DEFB 0,255,7,247,224,239,8,232,36,37,96,111,6,246,0,255
  DEFB 0,255,0,255,0,255,7,247,224,239,126,126,126,126

; Sprite tile references (tile 11, animatory states 0-119) and graphic data
; (mask byte 6/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 254,163,246        ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 0,4,0,4,0,0,252    ; Sprite tile references for animatory states 0-7
  DEFB 175                ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 246,0              ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 255,190,175        ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 245                ; Sprite tile reference for animatory state 15
  DEFB 234                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 16-20
  DEFB 255,251            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 252                ; Sprite tile reference for animatory state 23
  DEFB 254                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 0,0,0              ; Sprite tile references for animatory states 24-27
  DEFB 0                  ; Sprite tile reference for unused animatory state 28
  DEFB 74,234             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 241                ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 107,131            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 252                ; Sprite tile reference for animatory state 39
  DEFB 255                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 40-44
  DEFB 244,175,232,74     ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 48-52
  DEFB 166                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,252              ; Sprite tile references for animatory states 54-55
  DEFB 244                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 56-60
  DEFB 173                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,252              ; Sprite tile references for animatory states 62-63
  DEFB 175                ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 2                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 252                ; Sprite tile reference for unused animatory state 71
  DEFB 72                 ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 5                  ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 252                ; Sprite tile reference for animatory state 79
  DEFB 95                 ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 80-84
  DEFB 233,247            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 252                ; Sprite tile reference for animatory state 87
  DEFB 131                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 88-92
  DEFB 246,175            ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 252                ; Sprite tile reference for animatory state 95
  DEFB 95                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 159,127            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 252                ; Sprite tile reference for animatory state 103
  DEFB 244                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 104-108
  DEFB 53,106             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 252                ; Sprite tile reference for animatory state 111
  DEFB 133                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0,0,0,252    ; Sprite tile references for animatory states 112-119

; Unused
  DEFS 8

; Character buffer for character 227
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by the sniper in game modes 1-4, and is unused in demo
; mode. See C227MODE0 for more details.
  DEFS 32

; Initialisation parameters for character 227
;
; The first set of parameters is used in demo mode.
C227MODE0;
  DEFB 118                ; Animatory state (118; cat)
  DEFB 0,45               ; Location (out of sight)
  DEFB 8                  ; z-coordinate (invisible)
  DEFW CLIST30            ; Command list; Do nothing
; The next set of parameters is used in game mode 1.
C227MODE1;
  DEFB 54                 ; Animatory state (54; sniper)
  DEFB 0,50               ; Location (out of sight)
  DEFB 2                  ; z-coordinate (behind people on the sidewalk)
  DEFW CLIST10            ; Command list; Control the sniper
; The next set of parameters is used in game mode 2.
C227MODE2;
  DEFB 54                 ; Animatory state (54; sniper)
  DEFB 0,50               ; Location (out of sight)
  DEFB 2                  ; z-coordinate (behind people on the sidewalk)
  DEFW CLIST10            ; Command list; Control the sniper
; The next set of parameters is used in game mode 3.
C227MODE3;
  DEFB 54                 ; Animatory state (54; sniper)
  DEFB 0,50               ; Location (out of sight)
  DEFB 2                  ; z-coordinate (behind people on the sidewalk)
  DEFW CLIST10            ; Command list; Control the sniper
; The next set of parameters is used in game mode 4.
C227MODE4;
  DEFB 54                 ; Animatory state (54; sniper)
  DEFB 0,50               ; Location (out of sight)
  DEFB 2                  ; z-coordinate (behind people on the sidewalk)
  DEFW CLIST10            ; Command list; Control the sniper

; Sprite tile references for Sam in disguise 4
;
; Used by the routine at CHGGUISE.
GUISE4REFS;
  DEFB 112,200,208,86,88
  DEFB 216,224,94,96,232
  DEFB 240,102,237,106,108

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 5/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,255,102,102,0,255,0,255,0,254,130,130,64,95,0,255
  DEFB 0,255,6,246,96,111,8,232,36,37,144,151,0,248,0,255
  DEFB 0,255,0,255,0,255,6,246,96,111,102,102,102,102

; Sprite tile references (tile 12, animatory states 0-119) and graphic data
; (UDG byte 7/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 0,66,7             ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 0,7,0,7,0,0,0      ; Sprite tile references for animatory states 0-7
  DEFB 48                 ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 245,241            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 0,5,48             ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 15
  DEFB 4                  ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,13,0,13          ; Sprite tile references for animatory states 16-20
  DEFB 0,0                ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 0                  ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 0,13,0             ; Sprite tile references for animatory states 24-27
  DEFB 13                 ; Sprite tile reference for unused animatory state 28
  DEFB 115,83             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 40,130             ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 40-44
  DEFB 7,48,8,115         ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,29,0,29          ; Sprite tile references for animatory states 48-52
  DEFB 47                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 7                  ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,13,0,13          ; Sprite tile references for animatory states 56-60
  DEFB 160                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 62-63
  DEFB 48                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 0,29,0,29          ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 252                ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 184                ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 8                  ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 64                 ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 0,151,0,151        ; Sprite tile references for animatory states 80-84
  DEFB 8,102              ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 130                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,151,0,151        ; Sprite tile references for animatory states 88-92
  DEFB 7,48               ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 64                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 134,96             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 11                 ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,13,0,13          ; Sprite tile references for animatory states 104-108
  DEFB 36,115             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 132                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,13,0,13,0,0,0    ; Sprite tile references for animatory states 112-119

; Unused
  DEFS 8

; Character buffer for character 228
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by a banknote in all game modes. See C228MODE0 for more
; details.
  DEFS 32

; Initialisation parameters for character 228
;
; The first set of parameters is used in demo mode.
C228MODE0;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST08            ; Command list; Control a banknote
; The next set of parameters is used in game mode 1.
C228MODE1;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST08            ; Command list; Control a banknote
; The next set of parameters is used in game mode 2.
C228MODE2;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST08            ; Command list; Control a banknote
; The next set of parameters is used in game mode 3.
C228MODE3;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST08            ; Command list; Control a banknote
; The next set of parameters is used in game mode 4.
C228MODE4;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST09            ; Command list; Control a banknote (unless Sam's got
                          ; the hook)

; Sprite tile references for Sam in disguise 5
;
; Used by the routine at CHGGUISE.
GUISE5REFS;
  DEFB 80,238,84,86,88
  DEFB 229,230,94,96,221
  DEFB 222,213,214,106,108

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 6/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,255,106,106,0,255,0,255,0,254,131,131,64,95,0,255
  DEFB 0,255,6,246,160,175,8,232,52,53,104,107,0,254,0,255
  DEFB 0,255,0,255,0,255,6,246,160,175,106,106,106,106

; Sprite tile references (tile 13, animatory states 0-119) and graphic data
; (mask byte 7/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 254,66,247         ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 0,10,0,10,0,0,0    ; Sprite tile references for animatory states 0-7
  DEFB 55                 ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 239,244            ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 127,197,55         ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 247                ; Sprite tile reference for animatory state 15
  DEFB 228                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 16-20
  DEFB 127,252            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 254                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 0,0,0              ; Sprite tile references for animatory states 24-27
  DEFB 0                  ; Sprite tile reference for unused animatory state 28
  DEFB 115,83             ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 242                ; Sprite tile reference for animatory state 31
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 168,130            ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 255                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 40-44
  DEFB 231,55,232,115     ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 48-52
  DEFB 175                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 247                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,29,0,29          ; Sprite tile references for animatory states 56-60
  DEFB 174                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 62-63
  DEFB 55                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 253                ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 184                ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 9                  ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 95                 ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 0,13,0,13          ; Sprite tile references for animatory states 80-84
  DEFB 232,102            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 130                ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,13,0,13          ; Sprite tile references for animatory states 88-92
  DEFB 247,55             ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 95                 ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 134,111            ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 235                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,29,0,29          ; Sprite tile references for animatory states 104-108
  DEFB 37,115             ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 133                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0,0,207,0    ; Sprite tile references for animatory states 112-119

; Unused
  DEFS 8

; Character buffer for character 229
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by a banknote in all game modes (see C229MODE0 for more
; details), but is also reserved for use by the hook when necessary (see
; MVBANKNOTE).
CBUF229;
  DEFS 32

; Initialisation parameters for character 229
;
; The first set of parameters is used in demo mode.
C229MODE0;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST09            ; Command list; Control a banknote (unless Sam's got
                          ; the hook)
; The next set of parameters is used in game mode 1.
C229MODE1;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST09            ; Command list; Control a banknote (unless Sam's got
                          ; the hook)
; The next set of parameters is used in game mode 2.
C229MODE2;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST09            ; Command list; Control a banknote (unless Sam's got
                          ; the hook)
; The next set of parameters is used in game mode 3.
C229MODE3;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST09            ; Command list; Control a banknote (unless Sam's got
                          ; the hook)
; The next set of parameters is used in game mode 4.
C229MODE4;
  DEFB 62                 ; Animatory state (62; banknote)
  DEFB 0,34               ; Location (sidewalk at the far left of town)
  DEFB 4                  ; z-coordinate (outside)
  DEFW CLIST09            ; Command list; Control a banknote (unless Sam's got
                          ; the hook)

; Sprite tile references for Sam in disguise 6
;
; Used by the routine at CHGGUISE.
GUISE6REFS;
  DEFB 112,157,149,160,126
  DEFB 166,92,160,160,173
  DEFB 174,175,104,106,152

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 7/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,255,115,115,0,127,0,255,0,254,130,130,64,95,0,255
  DEFB 0,255,7,247,48,55,8,232,36,37,40,42,0,254,0,129
  DEFB 0,254,0,248,0,31,7,231,48,55,115,115,115,115

; Sprite tile references (tile 14, animatory states 0-119) and graphic data
; (UDG byte 8/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 1,28,11            ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 0,13,0,13,0,0,0    ; Sprite tile references for animatory states 0-7
  DEFB 8                  ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,0                ; Sprite tile references for animatory states 8-10
  DEFB 0                  ; Sprite tile reference for unused animatory state 11
  DEFB 128,11,8           ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 246                ; Sprite tile reference for animatory state 15
  DEFB 17                 ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 16-20
  DEFB 128,0              ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 23
  DEFB 1                  ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 0,0,0              ; Sprite tile references for animatory states 24-27
  DEFB 0                  ; Sprite tile reference for unused animatory state 28
  DEFB 240,176            ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 31
  DEFB 0                  ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 32-36
  DEFB 37,92              ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 39
  DEFB 0                  ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 40-44
  DEFB 15,8,21,176        ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 48-52
  DEFB 44                 ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 54-55
  DEFB 11                 ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 56-60
  DEFB 192                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Sprite tile references for animatory states 62-63
  DEFB 8                  ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for unused animatory states
                          ; 64-68
  DEFB 0                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for animatory state 70
  DEFB 0                  ; Sprite tile reference for unused animatory state 71
  DEFB 136                ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 72-76
  DEFB 176                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0                  ; Sprite tile reference for unused animatory state 78
  DEFB 0                  ; Sprite tile reference for animatory state 79
  DEFB 32                 ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 80-84
  DEFB 21,206             ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 87
  DEFB 92                 ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 88-92
  DEFB 11,8               ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 95
  DEFB 128                ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 96-100
  DEFB 92,224             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 103
  DEFB 8                  ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Sprite tile references for animatory states 104-108
  DEFB 200,176            ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Sprite tile reference for animatory state 111
  DEFB 130                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0,214,210,0  ; Sprite tile references for animatory states 112-119

; Unused
  DEFS 8

; Character buffer for Sam
;
; See the character buffer documentation for details of how the buffer is used.
; This buffer is used by Sam in all game modes. See SAMMODE0 for more details.
SAMCBUF;
  DEFS 32

; Initialisation parameters for Sam
;
; Used by the routine at PREPGAME. Note that the last byte in each set of
; parameters is effectively unused, but because it is non-zero, the routine at
; INITCBUFS2 will needlessly copy the whole set of parameters into bytes 0, 1,
; 2, 4, 23 and 24 of Sam's buffer; the parameters are correctly used to
; initialise Sam upon return from that routine by the routine at PREPGAME.
;
; The first set of parameters is used in demo mode.
SAMMODE0;
  DEFB 0                  ; Unused
  DEFB 34                 ; LSB of the address of the screen refresh buffer
                          ; byte that corresponds to the top row of the
                          ; cutscene window (see PREPCSCENE); combined with the
                          ; coordinates below, this places the top-left corner
                          ; of the cutscene window at (224,19) with Sam at
                          ; (229,19) (in his office)
  DEFB 208                ; New x-coordinate for the leftmost column of the
                          ; play area on screen
  DEFB 14                 ; New y-coordinate for the topmost row of the play
                          ; area on screen
  DEFB 32                 ; Message 32; '...I'M WORKING ON A CASE RIGHT NOW...'
  DEFB 1                  ; Unused
; The next set of parameters is used in game mode 1.
SAMMODE1;
  DEFB 0                  ; Unused
  DEFB 34                 ; LSB of the address of the screen refresh buffer
                          ; byte that corresponds to the top row of the
                          ; cutscene window (see PREPCSCENE); combined with the
                          ; coordinates below, this places the top-left corner
                          ; of the cutscene window at (224,19) with Sam at
                          ; (229,19) (in his office)
  DEFB 208                ; New x-coordinate for the leftmost column of the
                          ; play area on screen
  DEFB 14                 ; New y-coordinate for the topmost row of the play
                          ; area on screen
  DEFB 33                 ; Message 33; '...SO BEGAN THE CASE OF THE BALI
                          ; BUDGIE'
  DEFB 1                  ; Unused
; The next set of parameters is used in game mode 2.
SAMMODE2;
  DEFB 0                  ; Unused
  DEFB 34                 ; LSB of the address of the screen refresh buffer
                          ; byte that corresponds to the top row of the
                          ; cutscene window (see PREPCSCENE); combined with the
                          ; coordinates below, this places the top-left corner
                          ; of the cutscene window at (240,19) with Sam at
                          ; (245,19) (third floor of no. 15)
  DEFB 224                ; New x-coordinate for the leftmost column of the
                          ; play area on screen
  DEFB 14                 ; New y-coordinate for the topmost row of the play
                          ; area on screen
  DEFB 62                 ; Message 62; 'IT ALL WENT BLACK. AS I FELL SOMEONE
                          ; FAT PUSHED PAST ME...'
  DEFB 1                  ; Unused
; The next set of parameters is used in game mode 3.
SAMMODE3;
  DEFB 0                  ; Unused
  DEFB 32                 ; LSB of the address of the screen refresh buffer
                          ; byte that corresponds to the top row of the
                          ; cutscene window (see PREPCSCENE); combined with the
                          ; coordinates below, this places the top-left corner
                          ; of the cutscene window at (0,7) with Sam at (5,7)
                          ; (on the roof of the apartment building next to no.
                          ; 74)
  DEFB 0                  ; New x-coordinate for the leftmost column of the
                          ; play area on screen
  DEFB 2                  ; New y-coordinate for the topmost row of the play
                          ; area on screen
  DEFB 67                 ; Message 67; 'SOMEONE HIT ME. I PLAYED DEAD. TWO MEN
                          ; WALKED OFF...'
  DEFB 1                  ; Unused
; The next set of parameters is used in game mode 4.
SAMMODE4;
  DEFB 0                  ; Unused
  DEFB 34                 ; LSB of the address of the screen refresh buffer
                          ; byte that corresponds to the top row of the
                          ; cutscene window (see PREPCSCENE); combined with the
                          ; coordinates below, this places the top-left corner
                          ; of the cutscene window at (224,19) with Sam at
                          ; (229,19) (in his office)
  DEFB 208                ; New x-coordinate for the leftmost column of the
                          ; play area on screen
  DEFB 14                 ; New y-coordinate for the topmost row of the play
                          ; area on screen
  DEFB 74                 ; Message 74; 'SHE'S IN JAIL NOW. ANOTHER CASE
                          ; SOLVED...'
  DEFB 1                  ; Unused

; Sprite tile references for Sam in disguise 7
;
; Used by the routine at CHGGUISE.
GUISE7REFS;
  DEFB 150,158,140,110,88
  DEFB 90,92,114,116,141
  DEFB 142,102,104,165,108

; Unused
  DEFS 3

; Sprite tile graphic data for Sam in disguise (byte pairs 8/8)
;
; Used by the routine at CHGGUISE.
  DEFB 0,254,176,176,128,191,0,195,1,253,92,92,128,191,0,252
  DEFB 0,63,11,235,8,11,21,213,200,203,37,165,1,253,126,126
  DEFB 0,254,7,247,224,239,11,235,8,11,176,176,176,176

; Sprite tile graphic data (mask byte 8/8)
;
; Used by the routines at PREPTILES, GETTILE and CHGGUISE.
  DEFB 253,28,235         ; Graphic data for sprite tiles 126-128 (used for
                          ; Sam's disguises)
  DEFB 204,196,6,240,80,24,92 ; Unused
  DEFB 11                 ; Graphic data for sprite tile 136 (used for Sam's
                          ; disguises)
  DEFB 0,0,255            ; Unused
  DEFB 191,235,11         ; Graphic data for sprite tiles 140-142 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Unused
  DEFB 209                ; Graphic data for sprite tile 144 (used for Sam's
                          ; disguises)
  DEFB 196,219,140,128    ; Unused
  DEFB 191,254            ; Graphic data for sprite tiles 149-150 (used for
                          ; Sam's disguises)
  DEFB 255                ; Unused
  DEFB 253                ; Graphic data for sprite tile 152 (used for Sam's
                          ; disguises)
  DEFB 1,15,17,222        ; Unused
  DEFB 240,176            ; Graphic data for sprite tiles 157-158 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Unused
  DEFB 255                ; Graphic data for sprite tile 160 (used for Sam's
                          ; disguises)
  DEFB 8,134,140,154      ; Unused
  DEFB 165,92             ; Graphic data for sprite tiles 165-166 (used for
                          ; Sam's disguises)
  DEFB 46                 ; Unused
  DEFB 254                ; Graphic data for sprite tile 168 (used for Sam's
                          ; disguises)
  DEFB 90,111,118,207     ; Unused
  DEFB 239,11,213,176     ; Graphic data for sprite tiles 173-176 (used for
                          ; Sam's disguises)
  DEFB 0,250,254,192      ; Unused
  DEFB 172                ; Graphic data for sprite tile 181 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Unused
  DEFB 235                ; Graphic data for sprite tile 184 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 223                ; Graphic data for sprite tile 189 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Unused
  DEFB 11                 ; Graphic data for sprite tile 192 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 3                  ; Graphic data for sprite tile 197 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Unused
  DEFB 136                ; Graphic data for sprite tile 200 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 176                ; Graphic data for sprite tile 205 (used by Sam when
                          ; he's rolling or somersaulting)
  DEFB 0,0                ; Unused
  DEFB 47                 ; Graphic data for sprite tile 208 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 213,206            ; Graphic data for sprite tiles 213-214 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Unused
  DEFB 92                 ; Graphic data for sprite tile 216 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 235,11             ; Graphic data for sprite tiles 221-222 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Unused
  DEFB 191                ; Graphic data for sprite tile 224 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 92,239             ; Graphic data for sprite tiles 229-230 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Unused
  DEFB 232                ; Graphic data for sprite tile 232 (used for Sam's
                          ; disguises)
  DEFB 0,0,0,0            ; Unused
  DEFB 203,176            ; Graphic data for sprite tiles 237-238 (used for
                          ; Sam's disguises)
  DEFB 0                  ; Unused
  DEFB 130                ; Graphic data for sprite tile 240 (used for Sam's
                          ; disguises)

; Unused
  DEFS 15

; Copy a play area tile into the back buffer
;
; Used by the routine at PRINTTILE.
;
; HL Play area tile base address
COPYTILE;
  LD DE,BACKBUF           ; The first byte of the back buffer is at BACKBUF
; This entry point is also used by the routine at PRINTTILE (with HL=BACKBUF
; and DE holding a display file address) to copy the tile from the back buffer
; to the screen.
COPYTILE_0;
  LD B,8                  ; There are 8 bytes to copy
COPYTILE_1;
  LD A,(HL)               ; Copy the 8 tile bytes to the back buffer or the
  LD (DE),A               ; screen
  INC H                   ;
  INC D                   ;
  DJNZ COPYTILE_1         ;
; The address of this entry point is placed into bytes 8 and 9 of a policeman's
; buffer by the routine at SAMLANA, and is also found in the command lists at
; CLIST14 and CLIST30.
DONOWT;
  RET

; Print a tile
;
; Used by the routines at MVBULLETS, LSCROLL8, RSCROLL8, USCROLL6, DSCROLL6 and
; UPDATESCR. Copies a background tile of the play area into the back buffer at
; BACKBUF, superimposes character sprite tiles and a foreground tile as
; appropriate, and then copies the resultant tile to the screen. Also sets the
; corresponding attribute byte.
;
; H Screen row number (0-19)
; L Screen column number (0-31)
PRINTTILE;
  PUSH HL                 ; Put the screen coordinates onto the stack
  LD A,H                  ; Compute the corresponding display file address in
  AND 7                   ; HL
  RRCA                    ;
  RRCA                    ;
  RRCA                    ;
  ADD A,L                 ;
  LD L,A                  ;
  LD A,H                  ;
  AND 24                  ;
  ADD A,64                ;
  LD H,A                  ;
  EX (SP),HL              ; Put the display file address onto the stack and get
                          ; the screen coordinates back in HL
  LD DE,(LEFTCOL)         ; DE=play area coordinates of the top-left corner of
                          ; the screen
  ADD HL,DE               ; HL=play area coordinates of the tile to be printed
  PUSH HL                 ; Push these coordinates onto the stack...
  EXX
  POP DE                  ; ...and pop them into DE'
  EXX
; In order to find the graphic data and attribute byte for the play area
; tile(s) to be printed at (X,Y), we need the T and T' values for that
; location; these values can be found in turn from the Z, Z' and Z'' values for
; the location.
;
; The Z value (0<=Z<=101) for the play area location (X,Y) is found in byte
; INT(X/8) of page 184+INT(Y/6). Then the Z' value is found in byte Z of page
; 191, and the Z'' value in byte 128+Z of page 184+X%8.
;
; Z'' and bit 7-(X%8) of Z' determine the address, P, of the T value for the
; play area location (X,Y); Z'' is the LSB, and the MSB is either 160+2*(Y%6)
; or 172+2*(Y%6), depending on whether bit 7-(X%8) of Z' is reset or set. The
; address of the T' value is P+256.
  LD A,H                  ; A=Y, the play area y-coordinate (2-39)
  LD D,183                ; Set D=184+INT(Y/6) (184-190)
PRINTTILE_0;
  INC D                   ;
  SUB 6                   ;
  JR NC,PRINTTILE_0       ;
  ADD A,86                ; 80<=A<=85
  ADD A,A                 ; A=160, 162, 164, 166, 168 or 170
  LD B,A                  ; B=160+2*(Y%6)
  LD A,L                  ; A=X, the play area x-coordinate (0-255)
  AND 248                 ; Keep only bits 3-7
  RRA                     ; Slide them down into bits 0-4; now A=INT(X/8)
  RRCA                    ;
  RRCA                    ;
  LD E,A                  ; Point DE at the Z value for the play area location
                          ; (X,Y)
  LD A,L                  ; A=X, the play area x-coordinate (0-255)
  AND 7                   ; Keep only bits 0-2; now A=X%8
  PUSH AF                 ; Save this value briefly
  ADD A,160               ; 160<=A<=167
  LD H,A                  ; H=160+(X%8)
  LD L,21                 ; Point HL at byte 21 of page 160+(X%8)
  LD C,(HL)               ; Now C=128 (if X%8=0), 64, 32, 16, 8, 4, 2, or 1 (if
                          ; X%8=7)
  LD A,(DE)               ; A=Z (value of byte INT(X/8) of page 184+INT(Y/6))
  LD L,A                  ; L=Z (0-101)
  LD H,191                ; Point HL at the table of Z' values at Z1VALUES
  LD A,(HL)               ; A=Z' (0, 1, 3, 7, 14, 31, 128, 134, 199, 215, 240,
                          ; 252, or 255)
  AND C                   ; Is bit 7-(X%8) of Z' set?
  JR Z,PRINTTILE_1        ; Jump if not
  LD A,B                  ; Otherwise set B=172+2*(Y%6)
  ADD A,12                ;
  LD B,A                  ;
PRINTTILE_1;
  SET 7,L                 ; L=128+Z (128-229)
  POP AF                  ; A=X%8
  ADD A,184               ; H=184+X%8
  LD H,A                  ;
  LD C,(HL)               ; C=Z'' (value of byte 128+Z of page 184+X%8)
  SET 5,E                 ; E=32+INT(X/8)
  LD A,(DE)               ; A=value of byte 32+INT(X/8) of page 184+INT(Y/6)
  LD L,A                  ; L=attribute byte address LSB (0-27)
  LD A,E                  ; A=32+INT(X/8)
  XOR 96                  ; A=64+INT(X/8)
  LD E,A                  ; Point DE at the window flags for the play area
                          ; location (X,Y)
  LD A,(BC)               ; A=T (value of byte Z'' of page 160+2*(Y%6) or
                          ; 172+2*(Y%6))
; We have collected the T value for the play area location (X,Y). Bits 7 and 6
; of T have the following meanings;
;
; +-------+-------------------------------------------------------------------+
; | Value | Meaning                                                           |
; +-------+-------------------------------------------------------------------+
; | 11    | This location has a background tile and a transparent foreground  |
; |       | tile                                                              |
; | 10    | This location has a blank background tile and a transparent       |
; |       | foreground tile (used by windows and house number signs)          |
; | 01    | This location has an opaque foreground tile only (characters with |
; |       | a z-coordinate of 1 will appear behind it)                        |
; | 00    | This location has a background tile only (characters with a       |
; |       | z-coordinate of 1 will appear in front of it)                     |
; +-------+-------------------------------------------------------------------+
;
; When bits 7 and 6 of T are both set (11), bits 2-5 of T and bit 7 of T'
; indicate the LSB of the address of the background tile's graphic data; the
; MSB is always 128. The LSBs of the addresses of the graphic data for the two
; half-tiles that make up the foreground tile are derived from bits 0-6 of T';
; the MSBs are always 128.
;
; When bit 7 of T is set and bit 6 is reset (10), bits 3-5 are unused, and bit
; 2 is set only if the right-hand window of a pair is at this location. The
; LSBs of the addresses of the graphic data for the two half-tiles that make up
; the foreground tile are derived from T' (0-31) and the window flags; the MSBs
; are always 128.
;
; When bit 7 of T is reset, bit 5 is unused (always reset), and bits 2-4
; indicate the MSB of the address of the tile's graphic data (128, 136, 144,
; 152 or 160); the LSB is equal to T'.
;
; Finally, bits 1 and 0 of T indicate the MSB of the address of the tile's
; attribute byte (168, 169, 170 or 171); the LSB (0-27, already collected in L
; at this point) is found in byte 32+INT(X/8) of page 184+INT(Y/6).
  AND 3                   ; Keep only bits 0 and 1 of T
  ADD A,168               ; 168<=A<=171
  LD H,A                  ; 168<=H<=171
  LD A,(HL)               ; A=play area tile attribute byte
  LD (BACKBUFATT),A       ; Save it at BACKBUFATT for later retrieval
  LD A,(BC)               ; A=T
  INC B                   ; B=161+2*(Y%6) or 173+2*(Y%6); now BC points at the
                          ; T' value
  RLCA                    ; Does this play area location have a background tile
                          ; and a foreground tile?
  JR NC,PRINTTILE_8       ; Jump if not
; The play area location under consideration has a background tile and a
; foreground tile.
  BIT 7,A                 ; Is there a window or a house number sign here?
  JR NZ,PRINTTILE_3       ; Jump if not
; There is a window or a house number sign at this location.
  CALL WINFLAGS           ; Collect the window flags
  JR Z,PRINTTILE_2        ; Jump unless we are dealing with the right-hand
                          ; window of a pair
  AND 35                  ; Keep only bits 5 (light indicator), 1 and 0
                          ; (decoration indicator) of the window flags
  ADD A,96                ; Set bit 7 if the light is off (i.e. copy bit 5 into
                          ; bit 7)
  RRCA                    ; Move bits 1 and 0 (decoration indicator) into bits
  RRCA                    ; 7 and 6, and the light indicator back into bit 5
PRINTTILE_2;
  AND 224                 ; Keep only bits 5 (light indicator), 6 and 7
                          ; (decoration indicator) of the window flags
  LD E,A                  ; Copy these bits to E
  LD A,(BC)               ; A=T' (0-31 for window tiles and house number sign
                          ; tiles)
  OR E                    ; A=foreground tile identifier
  LD L,159                ; Use tile 159 in page 128 (which is blank) as the
                          ; background tile
  JR PRINTTILE_5
; There is no window or house number sign at this location, and it has a
; background tile and a transparent foreground tile.
PRINTTILE_3;
  AND 120                 ; Keep only bits 2-5 of T
  RRA                     ;
  SCF                     ; Shift bits 2-5 into bits 1-4 and set bit 7
  RRA                     ;
  LD L,A                  ; L=background tile reference (even number >= 128)
  LD A,(BC)               ; A=T'
  RLCA                    ; Is bit 7 of T' set?
  JR NC,PRINTTILE_4       ; Jump if not
  INC L                   ; Increment the background tile reference (to an odd
                          ; number >= 129)
PRINTTILE_4;
  SCF                     ; A=T' with bit 7 set
  RRA                     ;
PRINTTILE_5;
  LD E,A                  ; E=foreground tile identifier
  LD H,128                ; Point HL at the background tile graphic data
; Now HL holds the base address of the background tile graphic data.
  PUSH DE                 ; Save the foreground tile identifier (in E)
  CALL COPYTILE           ; Copy the background tile into the back buffer at
                          ; BACKBUF
  LD A,1                  ; Superimpose sprite tiles for characters who are
  CALL GETTILE_0          ; indoors (z=1)
  POP BC                  ; Restore the foreground tile identifier to C
; Now we superimpose the foreground tile. The 16 graphic and mask bytes for the
; foreground tile are found in two groups of 8 bytes in pages 128-135.
  LD B,192                ; The LSB of the first group of 8 bytes is found in
                          ; page 192
  LD DE,BACKBUF           ; Point DE at the back buffer at BACKBUF
  LD A,(BC)               ; A=LSB of the first group of 8 bytes
PRINTTILE_6;
  LD L,A                  ; Copy the LSB to L
  LD H,128                ; Point HL at the first byte (a graphic byte) in the
                          ; group
  LD B,4                  ; There are 4 pairs of bytes per group
PRINTTILE_7;
  LD A,(DE)               ; A=back buffer byte
  OR (HL)                 ; OR on the graphic byte
  INC H                   ; Point HL at the corresponding mask byte
  AND (HL)                ; AND on the mask byte
  INC H                   ; Point HL at the next graphic byte
  LD (DE),A               ; Replace the back buffer byte
  INC D                   ; Point DE at the next back buffer byte
  DJNZ PRINTTILE_7        ; Jump back until all 8 bytes have been done
  LD B,193                ; The LSB of the second group of 8 bytes is found in
                          ; page 193
  LD A,(BC)               ; A=LSB of the second group of 8 bytes
  INC C                   ; Set the zero flag if we've just done the second
                          ; group
  LD C,255                ; Signal; the second group is next
  JR NZ,PRINTTILE_6       ; Jump back until both groups have been done
  JR PRINTTILE_9
; The play area location under consideration has only one tile; either a
; background tile (if bit 6 of T is reset), or an opaque foreground tile (bit 6
; of T set).
PRINTTILE_8;
  AND 184                 ; Keep only bits 3-5 and 7 (bits 2-4 and 6 of T)
  RLCA                    ; Copy bit 6 of T into the carry flag
  PUSH AF                 ; Save the carry flag
  SCF                     ; Now A has bit 7 set, and a copy of bits 2-4 of T in
  RRA                     ; bits 3-5
  LD H,A                  ; H=128, 136, 144, 152 or 160
  LD A,(BC)               ; A=T'
  LD L,A                  ; Point HL at the tile graphic data
  CALL COPYTILE           ; Copy the tile into the back buffer at BACKBUF
  POP AF                  ; Restore the carry flag
  LD A,1                  ; Superimpose sprite tiles for characters who are
  CALL NC,GETTILE_0       ; indoors (z=1) if we're dealing with a background
                          ; tile
; Now we can superimpose sprite tiles for characters who are in the foreground.
PRINTTILE_9;
  LD A,2                  ; Superimpose sprite tiles for characters who are
  CALL GETTILE            ; between a building and the sidewalk (z=2), and then
                          ; for characters who are on the sidewalk or road
                          ; (z=4)
; The tile in the back buffer is now ready to be drawn.
  POP DE                  ; DE=display file address
  LD C,E                  ; C=corresponding attribute file address LSB
  LD A,D                  ; A=display file address MSB (64, 72 or 80)
  LD HL,BACKBUF           ; Point HL at the back buffer containing the tile to
                          ; be drawn
  RRCA                    ; A=88, 89 or 90
  RRCA                    ;
  RRCA                    ;
  ADD A,80                ;
  LD B,A                  ; Point BC at the appropriate byte of the attribute
                          ; file
  LD A,(BACKBUFATT)       ; Collect the attribute byte saved earlier at
                          ; BACKBUFATT
  LD (BC),A               ; Copy it to the attribute file
  JP COPYTILE_0           ; Copy the tile to the display file

; Unused
  DEFS 2

; Move a row of the screen left, right, up or down
;
; Used by the routines at LSCROLL8 (to move a row left), RSCROLL8 (to move a
; row right), USCROLL6 (to move a row up) and DSCROLL6 (to move a row down).
;
; DE Destination attribute file address
; HL Source attribute file address
MOVEROW;
  XOR A                   ; Set A=0 initially to indicate that we are copying a
                          ; row of attribute bytes first
MOVEROW_0;
  PUSH HL                 ; Save the source attribute file address
  PUSH DE                 ; Save the destination attribute file address
MOVEROWBC;
  LD BC,31                ; The operand of this instruction is set to 31 by the
                          ; routines at LSCROLL8 and RSCROLL8, and to 32 by the
                          ; routines at USCROLL6, DSCROLL6 and SCRUPDOWN7
MOVEROWLD;
  LDDR                    ; This instruction is set to LDIR by the routines at
                          ; LSCROLL8, USCROLL6, DSCROLL6 and SCRUPDOWN7, and to
                          ; LDDR by the routine at RSCROLL8; it copies the
                          ; source row of attribute bytes or pixels to the
                          ; destination row
  POP DE                  ; Restore the destination attribute file address to
                          ; DE
  POP HL                  ; Restore the source attribute file address to HL
  AND A                   ; Have we just copied a row of attribute bytes?
  JR Z,MOVEROW_1          ; Jump if so to point DE and HL at the corresponding
                          ; display file bytes
  INC D                   ; Otherwise point DE and HL at the next destination
  INC H                   ; and source rows of pixels
  DEC A                   ; Have we copied 8 rows of pixels yet?
  JR NZ,MOVEROW_0         ; Jump back if not
  RET
MOVEROW_1;
  LD A,H                  ; Set HL to the display file address that corresponds
  AND 11                  ; to the source attribute file address
  ADD A,A                 ;
  ADD A,A                 ;
  ADD A,A                 ;
  LD H,A                  ;
  LD A,D                  ; Set DE to the display file address that corresponds
  AND 11                  ; to the destination attribute file address
  ADD A,A                 ;
  ADD A,A                 ;
  ADD A,A                 ;
  LD D,A                  ;
  LD A,8                  ; There are 8 rows of pixels to copy
  JR MOVEROW_0            ; Jump back to copy them

; Unused
  DEFB 0

; Scroll the screen left 8 columns
;
; Used by the routine at CBUFGREV.
LSCROLL8;
  LD HL,59372             ; Set the instruction at MOVEROWBC to 'LD BC,31'
  LD (HL),31              ;
  LD L,239                ; Set the instruction at MOVEROWLD to 'LDIR'
  LD (HL),176             ;
  LD B,8                  ; There are 8 columns to scroll on
LSCROLL8_0;
  PUSH BC                 ; Save the column counter
  LD B,20                 ; There are 20 rows to be scrolled left
  LD HL,22529             ; Point HL at the attribute byte for the cell at
                          ; screen coordinates (1,0)
LSCROLL8_1;
  LD D,H                  ; Point DE at the attribute byte for the adjacent
  LD E,L                  ; cell on the left
  DEC E                   ;
  PUSH BC                 ; Save the row counter
  PUSH HL                 ; Save the source attribute file address
  CALL MOVEROW            ; Shift this row of the screen left
  POP HL                  ; Restore the source attribute file address to HL
  LD C,32                 ; Point HL at the next row down in the attribute file
  ADD HL,BC               ;
  POP BC                  ; Restore the row counter to B
  DJNZ LSCROLL8_1         ; Jump back until all 20 rows have been scrolled left
  LD HL,LEFTCOL           ; LEFTCOL holds the x-coordinate of the leftmost
                          ; column of the play area on screen
  INC (HL)                ; Increment this x-coordinate
  LD HL,4895              ; L=31 (rightmost screen column), H=19 (bottom row of
                          ; the screen)
LSCROLL8_2;
  PUSH HL                 ; Save the screen coordinates
  CALL PRINTTILE          ; Print a tile at screen coordinates (31,H)
  POP HL                  ; Restore the screen coordinates to HL
  DEC H                   ; Have we printed every tile in the column yet?
  JP P,LSCROLL8_2         ; Jump back if not
  POP BC                  ; Restore the column counter to B
  DJNZ LSCROLL8_0         ; Jump back until 8 columns have been scrolled on
  RET

; Unused
  DEFS 3

; Scroll the screen right 8 columns
;
; Used by the routine at CBUFGFWD.
RSCROLL8;
  LD HL,59372             ; Set the instruction at MOVEROWBC to 'LD BC,31'
  LD (HL),31              ;
  LD L,239                ; Set the instruction at MOVEROWLD to 'LDDR'
  LD (HL),184             ;
  LD B,8                  ; There are 8 columns to scroll on
RSCROLL8_0;
  PUSH BC                 ; Save the column counter
  LD B,20                 ; There are 20 rows to be scrolled right
  LD HL,22558             ; Point HL at the attribute byte for the cell at
                          ; screen coordinates (0,0)
RSCROLL8_1;
  LD D,H                  ; Point DE at the attribute byte for the adjacent
  LD E,L                  ; cell on the right
  INC E                   ;
  PUSH BC                 ; Save the row counter
  PUSH HL                 ; Save the source attribute file address
  CALL MOVEROW            ; Shift this row of the screen right
  POP HL                  ; Restore the source attribute file address to HL
  LD C,32                 ; Point HL at the next row down in the attribute file
  ADD HL,BC               ;
  POP BC                  ; Restore the row counter to B
  DJNZ RSCROLL8_1         ; Jump back until all 20 rows have been scrolled
                          ; right
  LD HL,LEFTCOL           ; LEFTCOL holds the x-coordinate of the leftmost
                          ; column of the play area on screen
  DEC (HL)                ; Decrement this x-coordinate
  LD HL,4864              ; L=0 (leftmost screen column), H=19 (bottom row of
                          ; the screen)
RSCROLL8_2;
  PUSH HL                 ; Save the screen coordinates
  CALL PRINTTILE          ; Print a tile at screen coordinates (0,H)
  POP HL                  ; Restore the screen coordinates to HL
  DEC H                   ; Have we printed every tile in the column yet?
  JP P,RSCROLL8_2         ; Jump back if not
  POP BC                  ; Restore the column counter to B
  DJNZ RSCROLL8_0         ; Jump back until 8 columns have been scrolled on
  RET

; Unused
  DEFS 3

; Scroll the screen up 6 rows
;
; Used by the routine at MVSAM.
USCROLL6;
  LD HL,59372             ; Set the instruction at MOVEROWBC to 'LD BC,32'
  LD (HL),32              ;
  LD L,239                ; Set the instruction at MOVEROWLD to 'LDIR'
  LD (HL),176             ;
  LD B,6                  ; 6 rows will be scrolled on
USCROLL6_0;
  PUSH BC                 ; Save the primary screen row counter
; This entry point is used by the routine at SCRUPDOWN7.
USCROLL6_1;
  LD B,19                 ; There are 19 screen rows to move up
  LD DE,22528             ; DE=destination attribute file address (top row)
  LD HL,22560             ; HL=source attribute file address (second row from
                          ; the top)
USCROLL6_2;
  PUSH BC                 ; Save the secondary screen row counter
  PUSH HL                 ; Save the source attribute file address
  PUSH DE                 ; Save the destination attribute file address
  CALL MOVEROW            ; Move one screen row up
  POP HL                  ; HL=source attribute file address
  LD C,32                 ; Point HL at the next row down in the attribute file
  ADD HL,BC               ;
  EX DE,HL                ; Transfer this address to DE
  POP HL                  ; HL=destination attribute file address
  ADD HL,BC               ; Point HL at the next row down in the attribute file
  POP BC                  ; Restore the secondary screen row counter to B
  DJNZ USCROLL6_2         ; Jump back until all 19 screen rows have been moved
                          ; up
PRINTROW19;
  LD HL,TOPROW            ; TOPROW holds the y-coordinate of the topmost row of
                          ; the play area on screen
  INC (HL)                ; Increment this
  LD HL,4895              ; L=31 (rightmost screen column), H=19 (bottom row of
                          ; the screen)
USCROLL6_3;
  PUSH HL                 ; Save the screen coordinates briefly
  CALL PRINTTILE          ; Print a tile at screen coordinates (L,19)
  POP HL                  ; Restore the screen coordinates to HL
  DEC L                   ; Have we printed every tile in the row yet?
  JP P,USCROLL6_3         ; Jump back if not
  POP BC                  ; Restore the primary screen row counter to B
  DJNZ USCROLL6_0         ; Jump back until 6 rows have been scrolled on
  RET

; Unused
  DEFS 3

; Scroll the screen down 6 rows
;
; Used by the routine at MVSAM.
DSCROLL6;
  LD HL,59372             ; Set the instruction at MOVEROWBC to 'LD BC,32'
  LD (HL),32              ;
  LD L,239                ; Set the instruction at MOVEROWLD to 'LDIR'
  LD (HL),176             ;
  LD B,6                  ; 6 rows will be scrolled on
DSCROLL6_0;
  PUSH BC                 ; Save the primary screen row counter
; This entry point is used by the routine at SCRUPDOWN7.
DSCROLL6_1;
  LD B,19                 ; There are 19 screen rows to move down
  LD DE,23136             ; DE=destination attribute file address (bottom row)
  LD HL,23104             ; HL=source attribute file address (second row from
                          ; the bottom)
DSCROLL6_2;
  PUSH BC                 ; Save the secondary screen row counter
  PUSH HL                 ; Save the source attribute file address
  PUSH DE                 ; Save the destination attribute file address
  CALL MOVEROW            ; Move one screen row down
  POP HL                  ; HL=source attribute file address
  LD BC,GSBTEMPLT         ; Point HL at the next row up in the attribute file
  ADD HL,BC               ;
  EX DE,HL                ; Transfer this address to DE
  POP HL                  ; HL=destination attribute file address
  ADD HL,BC               ; Point HL at the next row up in the attribute file
  POP BC                  ; Restore the secondary screen row counter to B
  DJNZ DSCROLL6_2         ; Jump back until all 19 screen rows have been moved
                          ; down
PRINTROW0;
  LD HL,TOPROW            ; TOPROW holds the y-coordinate of the topmost row of
                          ; the play area on screen
  DEC (HL)                ; Decrement this
  LD HL,31                ; L=31 (rightmost screen column), H=0 (top row of the
                          ; screen)
DSCROLL6_3;
  PUSH HL                 ; Save the screen coordinates briefly
  CALL PRINTTILE          ; Print a tile at screen coordinates (L,0)
  POP HL                  ; Restore the screen coordinates to HL
  DEC L                   ; Have we printed every tile in the row yet?
  JP P,DSCROLL6_3         ; Jump back if not
  POP BC                  ; Restore the primary screen row counter to B
  DJNZ DSCROLL6_0         ; Jump back until 6 rows have been scrolled on
  RET

; Unused
  DEFS 3

; Superimpose sprite tiles onto a tile of the play area
;
; Used by the routine at PRINTTILE. If any part of a character's sprite needs
; to be printed at the row and column specified by DE', the appropriate tile is
; located and superimposed onto the contents of the buffer at BACKBUF.
;
; A 2
; D' Play area y-coordinate
; E' Play area x-coordinate
GETTILE;
  CALL GETTILE_0          ; Superimpose sprite tiles for characters whose
                          ; z-coordinate is 2 (between a building and the
                          ; sidewalk)
  LD A,4                  ; Prepare to superimpose sprite tiles for characters
                          ; whose z-coordinate is 4 (on the sidewalk or road)
; This entry point is used by the routine at PRINTTILE with A=1 (to superimpose
; sprite tiles for characters who are indoors).
GETTILE_0;
  EXX
  LD C,A                  ; C'=1 (indoors), 2 (between buildings and the
                          ; sidewalk) or 4 (on the sidewalk or road)
  LD H,215                ; 215 is the first character
GETTILE_1;
  LD L,4                  ; Point HL' at byte 4 of the character's buffer
  LD A,(HL)               ; A=character's z-coordinate (1, 2, 4 or 8)
  AND C                   ; Reset the zero flag if the character's sprite
                          ; should be printed
; This entry point is used by the routine at CHKSHOT with H=230 (Sam), DE
; holding the play area coordinates of a bullet, and the zero flag reset unless
; Sam's indoors.
GETTILE_2;
  JR Z,GETTILE_9          ; Consider the next character if this one should not
                          ; be printed
  LD L,0                  ; Point HL' at byte 0 of the character's buffer
  LD A,(HL)               ; A=character's animatory state
  AND 127                 ; Drop the direction bit (bit 7)
  CP 120                  ; Is this character's animatory state >= 120?
  JR NC,GETTILE_6         ; Jump if so
; The character's animatory state is < 120, which means he has a 5x3 sprite.
  INC L                   ; L'=1
  INC A                   ; A=character's animatory state + 1
  AND 7                   ; Reduce this modulo 8
  LD A,E                  ; A=X, the play area x-coordinate (0-255)
  JR Z,GETTILE_4          ; Jump if the character's animatory state is
                          ; congruent to 7 mod 8
; The character's animatory state is congruent to 0-6 mod 8, which means he has
; a sprite with 5 rows and 3 columns. Check whether any part of the sprite
; impinges on the tile at (X,Y).
  SUB (HL)                ; Subtract the character's x-coordinate
  CP 3                    ; Does any part of the sprite impinge on column X?
  JR NC,GETTILE_9         ; Jump if not
  DEC L                   ; L'=0
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,GETTILE_3          ; Jump if so
  CPL                     ; Set A to 2-A if the character is facing right
  ADD A,3                 ;
GETTILE_3;
  LD B,A                  ; B'=0, 1 or 2 (the column of the character's sprite
                          ; at (X,Y))
  ADD A,A                 ; A=5*B
  ADD A,A                 ;
  ADD A,B                 ;
  LD B,A                  ; B'=0, 5 or 10
  LD L,2                  ; Point HL' at byte 2 of the character's buffer
  LD A,D                  ; A=Y, the play area y-coordinate (2-39)
  SUB (HL)                ; Subtract the character's y-coordinate
  CP 5                    ; Set the carry flag if the sprite impinges on row Y
  JR GETTILE_8
; The character's animatory state is congruent to 7 mod 8, which means he has a
; sprite with 3 rows and 5 columns. Check whether any part of the sprite
; impinges on the tile at (X,Y).
GETTILE_4;
  SUB (HL)                ; Subtract the character's x-coordinate
  CP 5                    ; Does any part of the character impinge on column X?
  JR NC,GETTILE_9         ; Jump if not
  DEC L                   ; L'=0
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,GETTILE_5          ; Jump if so
  CPL                     ; Set A=4-A if the character is facing right
  ADD A,5                 ;
GETTILE_5;
  LD B,A                  ; B'=0, 1, 2, 3 or 4 (the column of the sprite at
                          ; (X,Y))
  ADD A,A                 ; A=3*B'
  ADD A,B                 ;
  LD B,A                  ; B'=0, 3, 6, 9 or 12
  LD L,2                  ; Point HL' at byte 2 of the character's buffer
  LD A,D                  ; A=Y, the play area y-coordinate (2-39)
  SUB (HL)                ; Subtract the character's y-coordinate
  CP 3                    ; Set the carry flag if the sprite impinges on row Y
  JR GETTILE_8
; The character's animatory state is >= 120, which means he has a sprite with 2
; rows and 2 columns. Check whether any part of the sprite impinges on the tile
; at (X,Y).
GETTILE_6;
  LD L,1                  ; Point HL' at byte 1 of the character's buffer
  LD A,E                  ; A=X, the play area x-coordinate (0-255)
  SUB (HL)                ; Subtract the character's x-coordinate
  CP 2                    ; Does any part of the sprite impinge on column X?
  JR NC,GETTILE_9         ; Consider the next character if not
  DEC L                   ; L'=0
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,GETTILE_7          ; Jump if so
  XOR 1                   ; Set A=1-A
GETTILE_7;
  ADD A,A                 ; A=0 or 2
  LD B,A                  ; B'=0 or 2
  LD L,2                  ; Point HL' at byte 2 of the character's buffer
  LD A,D                  ; A=Y, the play area y-coordinate (2-39)
  SUB (HL)                ; Subtract the character's y-coordinate
  CP 2                    ; Set the carry flag if the sprite impinges on row Y
GETTILE_8;
  JR C,GETTILE_10         ; Jump if the sprite impinges on row Y
GETTILE_9;
  INC H                   ; Next character
  LD A,H                  ; A=character number
  CP 231                  ; Have we done all the characters (215-230)?
  JR NZ,GETTILE_1         ; Jump back if not
  EXX
  RET
; The character's sprite impinges on the tile at coordinates (X,Y).
GETTILE_10;
  ADD A,B                 ; A=0-14 (index of the sprite tile at (X,Y))
  ADD A,215               ; 215<=A<=229
  EXX
  LD H,A                  ; 215<=H<=229
  EXX
  LD L,0                  ; Point HL' at byte 0 of the character's buffer
  LD A,(HL)               ; A=character's animatory state
  AND 7                   ; Keep only bits 0-2
  LD A,(HL)               ; A=character's animatory state
  JR NZ,GETTILE_11        ; Jump if the animatory state is congruent to 1-7 mod
                          ; 8
  ADD A,2                 ; Add 2 if the animatory state is congruent to 0 mod
                          ; 8
GETTILE_11;
  OR 128                  ; A>=129
  EXX
  LD L,A                  ; L>=129, 215<=H<=229
  LD A,(HL)               ; A=sprite tile reference (0-214, 217-255)
  LD E,A                  ; Copy this to E
  AND A                   ; Set the zero flag if this is the blank tile
  EXX
  JR Z,GETTILE_9          ; Jump back to consider the next character if the
                          ; sprite tile is blank
; A tile of this character's sprite needs to be printed at (X,Y). The apparent
; intention of the next section of code is to treat animatory states
; 120-127/248-255 (used only by the hook) specially, but the next instruction
; copies L' (which holds 0) instead of L (which holds the adjusted animatory
; state) into A.
  LD A,L                  ; A=0
  CP 248                  ; This instruction sets the carry flag
  EXX
  JR C,GETTILE_12         ; This jump is always made
; The next section of code is never executed.
  LD H,219                ; Point HL at one of the eight bytes at OBJATTR
                          ; (which are all zero)
  LD A,(HL)               ; Pick up the byte
  AND A                   ; Set the zero flag
  JR Z,GETTILE_12         ; This jump would always be made
  LD (BACKBUFATT),A       ; Update the attribute byte stored at BACKBUFATT
; Normal service resumes here.
GETTILE_12;
  EXX
  LD A,(HL)               ; A=character's animatory state
  EXX
  LD D,199                ; Point DE at the graphic data for the sprite tile
  LD HL,BACKBUF           ; Point HL at the back buffer at BACKBUF
  RLCA                    ; Is the character facing right?
  JR C,GETTILE_14         ; Jump if so
; The character is facing left, so we can use the tile as-is (there is no need
; to flip it).
  EX DE,HL                ; Now DE points at the back buffer, and HL points at
                          ; the graphic data for the sprite tile
GETTILE_13;
  LD A,(DE)               ; Pick up a graphic byte from the back buffer
  OR (HL)                 ; OR on the sprite tile graphic byte
  INC H                   ; Point HL at the sprite tile mask byte
  AND (HL)                ; AND on the sprite tile mask byte
  LD (DE),A               ; Update the back buffer byte
  INC H                   ; Point HL at the next graphic byte of the sprite
                          ; tile
  INC D                   ; Point DE at the next byte of the back buffer
  BIT 3,D                 ; Have we finished all 8 bytes?
  JR Z,GETTILE_13         ; Jump back if not
  EX DE,HL                ; This instruction is redundant
  JR GETTILE_16           ; Consider the next character
; The character is facing right, so we need to flip the tile.
GETTILE_14;
  LD B,126                ; The table of mirror bytes is in page 126
GETTILE_15;
  LD A,(DE)               ; Pick up a sprite tile graphic byte
  LD C,A                  ; Copy it to C
  LD A,(BC)               ; A=mirror image of the sprite tile graphic byte
  OR (HL)                 ; OR on the back buffer graphic byte
  LD (HL),A               ; Store the result in the back buffer
  INC D                   ; Point DE at the sprite tile mask byte
  LD A,(DE)               ; Pick this up in A
  LD C,A                  ; Copy it to C
  LD A,(BC)               ; A=mirror image of the sprite tile mask byte
  AND (HL)                ; AND on the back buffer graphic byte
  LD (HL),A               ; Store the result in the back buffer
  INC D                   ; Point DE at the next graphic byte of the sprite
                          ; tile
  INC H                   ; Point HL at the next byte of the back buffer
  BIT 3,H                 ; Have we finished all 8 bytes?
  JR Z,GETTILE_15         ; Jump back if not
GETTILE_16;
  EXX
  JR GETTILE_9            ; Jump back to consider the next character

; Unused
  DEFB 203,92,40,239,217,24,159,0,0

; Update the SRB for a character's current animatory state and location
;
; Used by the routines at MVSNIPER2, MVBANKNOTE, SOMERSAULT, LIFTSAM, CUTSCENE,
; GETOBJECT, CARRIED, MVHOOK, STANDUP, MOVELEFT, ENDSTRIDE, CHRKNOCK, BYDOOR2,
; DROPSAM, CATRUN, KNOCKOVER, KNOCKED1, KNOCKED2, DISGUISE and DESCEND. Updates
; the screen refresh buffer (SRB) for a character's current animatory state and
; location. Returns with the character's current coordinates in DE and
; animatory state in A.
;
; H Character number (215-230)
UPDATESRB;
  LD L,2                  ; Point HL at byte 2 of the character's buffer
  LD D,(HL)               ; D=character's y-coordinate
  DEC L                   ; L=1
  LD E,(HL)               ; E=character's x-coordinate
  DEC L                   ; L=0
  PUSH DE                 ; Save the character's coordinates briefly
  CALL UPDATEAS_0         ; Set the appropriate bits in the SRB for the
                          ; character's current animatory state and location
  POP DE                  ; Restore the character's coordinates to DE
  LD A,(HL)               ; A=character's animatory state
  RET

; Update a character's animatory state and location and update the SRB
;
; Used by the routines at MVBANKNOTE, SOMERSAULT, UPDSNIPER, LIFTSAM, CUTSCENE,
; GETOBJECT, CARRIED, MVHOOK, USEHOOK, MOVELEFT, ENDSTRIDE, CHRKNOCK, BYDOOR2,
; DROPSAM, CATRUN, KNOCKOVER, KNOCKED2 and DESCEND. Sets the new animatory
; state and location of a character, and updates the screen refresh buffer
; (SRB) accordingly.
;
; A New animatory state
; D New y-coordinate
; E New x-coordinate
; H Character number (215-230)
UPDATEAS;
  LD L,2                  ; Point HL at byte 2 of the character's buffer
  LD (HL),D               ; Fill in the new y-coordinate
  DEC L                   ; L=1
  LD (HL),E               ; Fill in the new x-coordinate
  DEC L                   ; L=0
  LD (HL),A               ; Fill in the new animatory state
; This entry point is used by the routine at UPDATESRB.
UPDATEAS_0;
  LD BC,514               ; B=2, C=2
  LD A,(HL)               ; A=character's animatory state
  AND 127                 ; Clear the 'direction' bit (bit 7)
  ADD A,136               ; Is the animatory state >= 120?
  JR C,UPDATEAS_1         ; Jump if so
  LD BC,1283              ; B=5, C=3
  INC A                   ; Is the animatory state equal to 7 mod 8?
  AND 7                   ;
  JR NZ,UPDATEAS_1        ; Jump if not
  LD BC,773               ; B=3, C=5
; Now B holds the height of the sprite in tiles, and C holds the width.
UPDATEAS_1;
  LD A,(TOPROW)           ; A=Y, the y-coordinate of the topmost row of the
                          ; play area on screen (2-20)
  SUB B                   ; A=Y-B
  JR C,UPDATEAS_2         ; Jump if B>Y
  CP D                    ; Is the character entirely above the portion of the
                          ; play area currently on screen?
  RET NC                  ; Return if so
UPDATEAS_2;
  ADD A,B                 ; A=Y
  ADD A,19                ; A=y-coordinate of the bottom row of the play area
                          ; on screen (21-39)
  SUB D                   ; Is the character entirely below the portion of the
                          ; play area currently on screen?
  RET C                   ; Return if so
  CPL                     ; A=4*(D-Y+4)
  ADD A,24                ;
  ADD A,A                 ;
  ADD A,A                 ;
  LD D,A                  ; Copy this value (0, 4, 8, 12,...92) to D
  LD A,(LEFTCOL)          ; A=X, the x-coordinate of the leftmost column of the
                          ; play area on screen
  SUB C                   ; A=X-C
  JR C,UPDATEAS_3         ; Jump if C>X
  CP E                    ; Is the character entirely off-screen to the left?
  RET NC                  ; Return if so
UPDATEAS_3;
  ADD A,C                 ; A=X
  ADD A,31                ; A=x-coordinate of the rightmost column of the play
                          ; area on screen
  SUB E                   ; Is the character entirely off-screen to the right?
  RET C                   ; Return if so
; If we get here, then the character's sprite (or at least a portion of it) is
; on-screen.
  CPL                     ; A=E-X; the character's screen x-coordinate (-4 to
  ADD A,32                ; 31)
  PUSH AF                 ; Save this temporarily
  LD A,(HL)               ; A=character's animatory state
  AND 7                   ; Set the zero flag if the animatory state is 0 mod 8
  LD A,(HL)               ; A=character's animatory state
  JR NZ,UPDATEAS_4        ; Jump unless the animatory state is 0 mod 8
  ADD A,2                 ; Add 2 if the animatory state is congruent to 0 mod
                          ; 8
UPDATEAS_4;
  PUSH BC                 ; Push the sprite dimensions onto the stack
  EXX
  POP BC                  ; Retrieve the sprite dimensions in BC'
  LD H,215                ; Page 215 holds sprite tile references for the
                          ; top-left tile (tile 0) in the left-facing sprites
  LD D,B                  ; D'=sprite height (2, 3 or 5)
  RLCA                    ; Set bit 7 of A, and set the carry flag if the
  SCF                     ; character is facing right
  RRA                     ;
  LD L,A                  ; L'=character's animatory state (with bit 7 set)
  JR NC,UPDATEAS_6        ; Jump if the character is facing left
  XOR A                   ; D'=-B' (negative sprite height)
  SUB B                   ;
  LD D,A                  ;
  LD E,C                  ; E'=C'-1 (sprite width minus 1)
  DEC E                   ;
  LD A,H                  ; A=215 (page containing references for sprite tile
                          ; 0)
UPDATEAS_5;
  ADD A,B                 ; A=215+B'*(C'-1)
  DEC E                   ;
  JR NZ,UPDATEAS_5        ;
  LD H,A                  ; Copy this value to H'
; Now HL' points at the sprite tile reference for the top-left tile in the
; character's sprite.
UPDATEAS_6;
  POP AF                  ; Restore the character's screen x-coordinate to A
  LD E,A                  ; Copy it to E'
  JR C,UPDATEAS_8         ; Jump if E'>=0 (meaning that the leftmost tiles in
                          ; the character's sprite are on-screen)
  LD A,H                  ; A=H'-D'*E' (sprite tile reference page number);
UPDATEAS_7;
  ADD A,D                 ; C'=C'+E'
  DEC C                   ;
  INC E                   ;
  JR NZ,UPDATEAS_7        ;
  LD H,A                  ; Copy the sprite tile reference page number to H'
; Now HL' points at the sprite tile reference for the tile in the top row and
; the leftmost column of the character's sprite that is on-screen. C' holds the
; number of tile columns of the character's sprite that are to the right of the
; left edge of the screen.
UPDATEAS_8;
  LD A,E                  ; A=leftmost column of the screen occupied by the
                          ; sprite (0-31)
  EXX
  LD E,A                  ; E=leftmost column of the screen occupied by the
                          ; sprite
  AND 7                   ; Point BC at byte 21 of page 160+(E%8)
  ADD A,160               ;
  LD B,A                  ;
  LD C,21                 ;
  LD A,(BC)               ; Pick up the contents in A
  LD C,A                  ; Copy them to C
; Now C holds 1, 2, 4, 8, 16, 32, 64 or 128. The bit set in C corresponds to
; the bit that needs to be set in the relevant byte of the screen refresh
; buffer (SRB).
  LD A,E                  ; A=leftmost column of the screen occupied by the
                          ; sprite (0-31)
  RRCA                    ; Set A to the LSB of the first byte of the SRB that
  RRCA                    ; needs to be modified; D+INT(E/8)
  RRCA                    ;
  AND 3                   ;
  ADD A,D                 ;
  LD B,A                  ; Copy this LSB to B
  LD D,127                ; The SRB is in page 127
  EXX
; Here we enter a loop to set the appropriate bits in the SRB. At this point B'
; holds the number of tile rows in the sprite (2, 3, or 5) and C' holds the
; number of tile columns of the sprite that are to the right of the left edge
; of the screen.
UPDATEAS_9;
  PUSH BC                 ; Save the tile row and column counters temporarily
  LD E,0                  ; Start at sprite tile row 0 (top row)
UPDATEAS_10;
  LD A,(HL)               ; Pick up the sprite tile reference in A
  AND A                   ; Is this the 'null' tile (blank square)?
  JR Z,UPDATEAS_11        ; Jump if so (no need to set a bit in the SRB)
  LD A,E                  ; A=sprite tile row number (0-4)
  EXX
  ADD A,A                 ; Multiply by 4 (the number of bytes of the SRB that
  ADD A,A                 ; correspond to one row of the screen)
  ADD A,B                 ; Point DE at the relevant byte of the SRB
  LD E,A                  ;
  LD A,(DE)               ; Pick up the SRB byte in A
  OR C                    ; Make sure the appropriate bit is set
  LD (DE),A               ; Restore the SRB byte with the appropriate bit set
  EXX
UPDATEAS_11;
  INC H                   ; Point HL' at the reference for the next tile in the
                          ; sprite (one row down)
  INC E                   ; Next row down in this column of the sprite
  DJNZ UPDATEAS_10        ; Jump back until we've set all the SRB bits for this
                          ; tile column of the sprite
  LD A,H                  ; Point HL' at the reference for the tile in the top
  ADD A,D                 ; row of the next column of the sprite
  POP BC                  ;
  SUB B                   ;
  LD H,A                  ;
  EXX
  RRC C                   ; Move the SRB marker bit in C one place to the right
                          ; (possibly wrapping round to bit 7)
  JR NC,UPDATEAS_12       ; Jump if there are still bits to be set in the
                          ; current SRB byte
  INC B                   ; Otherwise move along to the next byte in the SRB
  LD A,B                  ; A=LSB of the next SRB byte
  AND 3                   ; Does the next SRB byte correspond to a segment in
                          ; the leftmost 8 columns of the screen (i.e. have we
                          ; wrapped around from right to left)?
  RET Z                   ; Return if so (any remaining sprite tile columns are
                          ; off-screen to the right)
UPDATEAS_12;
  EXX
  DEC C                   ; Next sprite tile column
  JR NZ,UPDATEAS_9        ; Jump back until the relevant SRB bits for every
                          ; sprite tile column have been set
  EXX
  RET

; Update the display
;
; Used by the routines at PREPCSCENE, CUTSCENE, MVSAM, MAINLOOP, ENDCSCENE and
; ROOFEDGE. Goes through the screen refresh buffer (SRB) and for every set bit
; found, updates the corresponding character square on-screen.
UPDATESCR;
  LD B,80                 ; 20 screen rows, 4 bytes (32 bits) per row
  LD HL,32528             ; Point HL at the start of the portion of the screen
                          ; refresh buffer that corresponds to the visible part
                          ; of the play area
UPDATESCR_0;
  LD A,(HL)               ; Pick up a byte from the screen refresh buffer
  AND A                   ; Does anything need updating in this particular
                          ; 8-tile segment?
  JR Z,UPDATESCR_4        ; Jump if not
  PUSH BC                 ; Save the SRB byte counter
  LD A,L                  ; For this particular byte of the SRB, compute the
  SUB 16                  ; corresponding screen row number (0-19) in D
  AND 252                 ;
  RRCA                    ;
  RRCA                    ;
  LD D,A                  ;
  LD A,L                  ; Also for this particular SRB byte, compute the
  AND 3                   ; column of the screen (0, 8, 16 or 24) corresponding
  ADD A,A                 ; to bit 7
  ADD A,A                 ;
  ADD A,A                 ;
  DEC A                   ; Initialise E, which will hold the screen column
  LD E,A                  ; number of the character square to be checked
UPDATESCR_1;
  INC E                   ; Set DE to the screen coordinates of the next
                          ; character square to be checked
  SLA (HL)                ; Does this character square need updating?
  JR C,UPDATESCR_2        ; Jump if so
  JR NZ,UPDATESCR_1       ; Jump back if there are still non-zero bits left in
                          ; this SRB byte
  JR UPDATESCR_3          ; Jump forward to consider the next SRB byte
; We found a set bit in the current SRB byte. Print the corresponding character
; square.
UPDATESCR_2;
  PUSH HL                 ; Save the SRB pointer
  PUSH DE                 ; Save the screen (row,column) pointer
  EX DE,HL                ; Switch the screen (row,column) pointer to HL
  CALL PRINTTILE          ; Print the character square at this row and column
  POP DE                  ; Restore the screen (row,column) pointer to DE
  POP HL                  ; Restore the SRB pointer to HL
  JR UPDATESCR_1          ; Examine the next bit of the current SRB byte
; There are no set bits remaining in the current SRB byte. Move to the next SRB
; byte.
UPDATESCR_3;
  POP BC                  ; Restore the SRB byte counter to B
UPDATESCR_4;
  INC L                   ; Point HL at the next SRB byte
  DJNZ UPDATESCR_0        ; Jump back until all 80 SRB bytes have been dealt
                          ; with
  RET

; Get the keypress offset of the last key pressed (1)
;
; Used by the routine at GETINPUT. Returns with the zero flag set if no game
; keys were pressed. Otherwise returns with A holding the value from the
; keypress offset table corresponding to the last key pressed or joystick
; movement made. This offset (an odd number from 1 to 39) points at an entry in
; the table of keypress handling routines at K_UPF.
KEYOFFSET1;
  CALL READKEY            ; Collect the ASCII code of the last key pressed in A
  JR NZ,KEYOFFSET2        ; Jump if a key was pressed
  LD A,(KEMPSTON)         ; Collect the input device indicator from KEMPSTON
  AND A                   ; Are we using the Kempston joystick?
  RET Z                   ; Return with the zero flag set if not
; We are using the Kempston joystick.
  IN A,(31)               ; Take a reading from the joystick port
  AND 31                  ; Any input from the joystick?
  RET Z                   ; Return if not
  LD L,80                 ; 80='P' (RIGHT)
  RRCA                    ; Was the joystick moved right?
  JR C,KEYOFFSET2_0       ; Jump if so
  DEC L                   ; L=79='O' (LEFT)
  RRCA                    ; Was the joystick moved left?
  JR C,KEYOFFSET2_0       ; Jump if so
  LD L,65                 ; 65='A' (DOWN)
  RRCA                    ; Was the joystick moved down?
  JR C,KEYOFFSET2_0       ; Jump if so
  LD L,81                 ; 81='Q' (UP)
  RRCA                    ; Was the joystick moved up?
  JR C,KEYOFFSET2_0       ; Jump if so
  LD L,107                ; 107='k' (knock on or open a door)
  JR KEYOFFSET2_0         ; Collect and return the keypress offset that
                          ; corresponds to the joystick movement

; Unused
  DEFB 0

; Get the ASCII code of the last key pressed
;
; Used by the routines at JOYSTICK, GETINPUT, KEYOFFSET1, ENDCSCENE and
; PHONEKEY. Returns with the zero flag set if no key with an ASCII code in the
; range 48-127 was pressed. Otherwise returns with A holding the ASCII code of
; the last key pressed.
READKEY;
  LD HL,23611             ; Point HL at the system variable FLAGS
  BIT 5,(HL)              ; Check the keypress flag
  RES 5,(HL)              ; Reset the flag ready for the next keypress
  RET Z                   ; Return if no key was pressed
  LD A,(23560)            ; Collect the ASCII code of the key last pressed
  CP 48                   ; Is the ASCII code < 48 ('0')?
  JR C,READKEY_0          ; Jump if so
  CP 128                  ; Is the ASCII code < 128?
  RET C                   ; Return if so
READKEY_0;
  XOR A                   ; Set the zero flag to indicate that no (relevant)
                          ; key was pressed
  RET

; Unused
  DEFB 0
  CALL 60085
  RET Z

; Get the keypress offset of the last key pressed (2)
;
; Continues from the routine at KEYOFFSET1. Returns with A holding the entry
; from the keypress offset table corresponding to the key just pressed, and the
; zero flag set if it wasn't a game key.
;
; A ASCII code of the last keypress (48-127)
KEYOFFSET2;
  LD L,A                  ; Transfer the ASCII code to L
; This entry point is used by the routine at KEYOFFSET1 with L holding the
; ASCII code corresponding to the last joystick movement.
KEYOFFSET2_0;
  LD H,195                ; Point HL at the entry in the keypress offset table
                          ; corresponding to the last keypress or joystick
                          ; movement
  LD A,(HL)               ; Pick up the entry in A
  AND A                   ; Set the zero flag if it wasn't a game key
  RET

; Check whether a character is on the sidewalk or road
;
; Used by the routines at SOMERSAULT and LOCDESCS. Returns with the carry flag
; reset if the character has both feet on the ground (the sidewalk or road),
; and with the carry flag set otherwise.
;
; H Character number (215-230)
RDORSWALK;
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD E,(HL)               ; E=character's x-coordinate
  INC L                   ; L=2
  LD D,(HL)               ; D=character's y-coordinate
  LD L,4
; This entry point is used by the routines at SOMERSAULT and LOCID.
RDORSWALK_0;
  LD A,D                  ; A=y-coordinate for comparison
  CP 34                   ; 34 is the y-coordinate of a character on the
                          ; sidewalk
  RET C                   ; Return with the carry flag set if the character is
                          ; above the level of the sidewalk (A<=33)
  RET NZ                  ; Return with the carry flag reset if the character
                          ; is on the road (A=35)
; This entry point is used by the routine at MVBANKNOTE.
RDORSWALK_1;
  LD A,E                  ; A=x-coordinate for comparison
; This entry point is used by the routines at GETSAMXY, MVCOP2 and ROOFEDGE.
RDORSWALK_2;
  CP 7                    ; Is A<=6 (where there is sidewalk)?
  CCF                     ; Return with the carry flag reset if so
  RET NC                  ;
  CP 15                   ; Is 7<=A<=14 (where there is no sidewalk)?
  RET C                   ; Return with the carry flag set if so
  CP 164                  ; Is 15<=A<=163 (where there is sidewalk)?
  CCF                     ; Return with the carry flag reset if so
  RET NC                  ;
  CP 199                  ; Set the carry flag if 164<=A<=198 (where there is
                          ; no sidewalk), or reset it if A>=199 (where there is
                          ; sidewalk)
  RET

; Obtain descriptors for a character's current location
;
; Used by the routines at CHKNEARSAM, MOVELEFT, NEXTMOVE, SAMBYDOOR and
; KNOCKED1. Looks for a location descriptor that corresponds to the character's
; current location and returns with A and C (and possibly also B) holding
; values derived from that descriptor.
;
; A location descriptor is a single byte (Q) if the location is on the sidewalk
; or road, or a sequence of two bytes ((Q,Q'), where bit 7 of Q is reset), or a
; sequence of three bytes ((Q,Q',Q''), where bit 7 of Q is set). For the
; location it corresponds to, a descriptor indicates the directions in which a
; character may move, and the directions that would require a change of
; z-coordinate; it may also indicate whether there is a door that can close at
; the location, and whether any movement from the location requires special
; handling by a separate routine (e.g. on the edge of a roof, or just behind
; the jail cell door).
;
; The single-byte location descriptors (Q) that correspond to locations on the
; sidewalk or road can be found in the table at LOCDESCSZ4. The blocks of two-
; and three-byte location descriptors for locations not on the sidewalk or road
; are organised by x-coordinate; the LSBs and MSBs of their addresses can be
; found in the tables at LDESCLSBS and LDESCMSBS.
;
; The first byte, Q, of a multi-byte location descriptor indicates the
; y-coordinate (y) and z-coordinate(s) (z) of the location to which the
; descriptor corresponds. In a two-byte descriptor (bit 7 of Q reset), bits 1-5
; of Q hold y-4, and z is 2 if bit 6 is set, or 1 otherwise. In a three-byte
; descriptor (bit 7 of Q set), bits 0-4 of Q hold y-4, and z is determined by
; bits 5 and 6; if bit 6 is set, z=1 or 2 (meaning that the location is next to
; the entrance to a building); otherwise, z=2 if bit 5 is set or 1 if it's
; reset.
;
; This routine returns with A holding the location type indicator (1-5), and C
; and B holding the values derived from the relevant location descriptor;
;
; +---+----+-----+--------------------------------------+
; | A | C  | B   | Meaning                              |
; +---+----+-----+--------------------------------------+
; | 1 | Q  | -   | The sidewalk or the road             |
; | 3 | Q' | Q'' | At the (open) entrance to a building |
; | 4 | Q' | Q'' | Behind or in front of a closed door  |
; | 5 | Q' | Q'' | Location requires special handling   |
; | 2 | Q' | -   | Regular location (none of the above) |
; +---+----+-----+--------------------------------------+
;
; The value in C (Q or Q') is the direction descriptor, which indicates the
; directions that are available, and (when A=1 or 5) the directions that
; require special handling;
;
; +-----+---------------------------------------------------------------------+
; | Bit | Meaning if set                                                      |
; +-----+---------------------------------------------------------------------+
; | 7   | Access to the left is granted                                       |
; | 6   | Access to the right is granted                                      |
; | 5   | There is a step going up to the left                                |
; | 4   | There is a step going up to the right                               |
; | 3   | There is a step going down to the left                              |
; | 2   | There is a step going down to the right                             |
; | 1   | Character's z-coordinate will be 2 after going up to the left (when |
; |     | A=1), or moving left requires special handling (when A=5; see       |
; |     | MOVELEFT_12)                                                        |
; | 0   | Character's z-coordinate will be 2 after going up to the right      |
; |     | (when A=1), or moving right requires special handling (when A=5;    |
; |     | see MOVELEFT_12)                                                    |
; +-----+---------------------------------------------------------------------+
;
; When A=3, B returns holding Q'', the third byte of the location descriptor.
; Bit 0 of this byte is set if there is a door that can close at the given
; location; bits 2-7 indicate whether the adjacent location in the
; corresponding direction is inside (set) or outside (reset) the building, and
; therefore may require a transition of the character's z-coordinate between 1
; and 2 (see BYDOOR);
;
; +-----+------------+
; | Bit | Direction  |
; +-----+------------+
; | 7   | Left       |
; | 6   | Right      |
; | 5   | Up/left    |
; | 4   | Up/right   |
; | 3   | Down/left  |
; | 2   | Down/right |
; +-----+------------+
;
; When A=5, B returns holding Q'', the third byte of the location descriptor;
; this byte determines the address of the routine to handle movement to the
; left or right at a special location (see MOVELEFT_12).
;
; H Character number (215-230)
LOCDESCS;
  CALL RDORSWALK          ; Is the character on the sidewalk or the road?
  JR C,LOCDESCS_0         ; Jump if not
  LD (HL),L               ; Set the character's z-coordinate to 4 (on the
                          ; sidewalk or road)
  LD D,196                ; Collect a location descriptor from the table at
  LD A,(DE)               ; LOCDESCSZ4
  LD C,A                  ; Copy the location descriptor to C
  LD A,1                  ; A=1 (character is on the sidewalk or the road)
  RET
; The character is not on the sidewalk or the road.
LOCDESCS_0;
  LD A,(HL)               ; A=character's z-coordinate
  CP 4                    ; Is the character outside?
  JR NZ,LOCDESCS_1        ; Jump if not
  LD (HL),2               ; Set the character's z-coordinate to 2
LOCDESCS_1;
  LD A,D                  ; A=y, the character's y-coordinate (6-35)
  SUB 4                   ; B=4*(y-4)
  ADD A,A                 ;
  ADD A,A                 ;
  LD B,A                  ;
  BIT 0,(HL)              ; Is the character indoors?
  JR NZ,LOCDESCS_2        ; Jump if so
  SET 7,B                 ; B=128+4*(y-4) if the character's z-coordinate is 2
; Now B holds a value indicating the character's y-coordinate (bits 2-6; y-4)
; and z-coordinate (bit 7; z-1).
LOCDESCS_2;
  EX DE,HL                ; L=character's x-coordinate
  LD H,197                ; Collect an LSB from the table at LDESCLSBS
  LD A,(HL)               ;
  SUB 2                   ; Subtract 2 from this LSB
  INC H                   ; Point HL at an MSB in the table at LDESCMSBS
  LD H,(HL)               ; Pick up the MSB in H
  LD E,L                  ; E=character's x-coordinate
  LD L,A                  ; Now HL holds 2 less than the address formed by the
                          ; LSB and MSB just collected from the tables at
                          ; LDESCLSBS and LDESCMSBS
; The loop that iterates over the location descriptors for the character's
; x-coordinate begins here.
LOCDESCS_3;
  INC L                   ; Move HL along the location descriptor table
; This entry point is used by the routine at LOCDESCSD.
LOCDESCS_4;
  INC L                   ; Point HL at the first byte of a location descriptor
  JR Z,LOCDESCS_5         ; Jump if we reached a page boundary
  LD A,(HL)               ; Pick up the first byte (Q) of the location
                          ; descriptor
  INC A                   ; Have we reached the end of the location descriptors
                          ; for the character's x-coordinate?
  JR NZ,LOCDESCS_6        ; Jump if not
; The character is not at any of the locations to which the location
; descriptors for his x-coordinate correspond.
LOCDESCS_5;
  LD C,192                ; Bits 7 and 6 set; the character can move left or
                          ; right only
  LD A,2                  ; A=2; regular location
  RET
; Here we examine a location descriptor and check whether the character is at
; the location to which it corresponds.
LOCDESCS_6;
  DEC A                   ; A=Q (first byte of the location descriptor)
  INC L                   ; Point HL at the second byte of the location
                          ; descriptor
  ADD A,A                 ; Is bit 7 of Q set (meaning this location is next to
                          ; the entrance to a building or requires special
                          ; handling)?
  JR C,LOCDESCS_7         ; Jump if so
  CP B                    ; Is the character at the location to which the
                          ; location descriptor corresponds?
  JR NZ,LOCDESCS_4        ; Move along to the next location descriptor if not
  LD C,(HL)               ; C=Q' (second byte of the location descriptor)
  LD A,2                  ; A=2; regular location
  RET
; The location descriptor being examined has bit 7 of its first byte set, which
; means that it corresponds to a location that is next to the entrance to a
; building, or a location that requires special handling.
LOCDESCS_7;
  ADD A,A                 ; Is bit 6 of Q set (meaning this location is next to
                          ; the entrance to a building)?
  JR C,LOCDESCS_9         ; Jump if so
  CP B                    ; Is the character at the location to which the
                          ; location descriptor corresponds?
  JR NZ,LOCDESCS_3        ; Move along to the next location descriptor if not
  LD A,5                  ; A=5; this location requires special handling
LOCDESCS_8;
  LD C,(HL)               ; Collect the second and third bytes of the location
  INC L                   ; descriptor (Q' and Q'') in C and B
  LD B,(HL)               ;
  RET
; The location descriptor being examined has bits 7 and 6 of its first byte
; set, which means that it corresponds to a location that is next to the
; entrance to a building (where a character's z-coordinate may be 1 or 2).
LOCDESCS_9;
  LD C,B                  ; C=4*(y-4) (where y is the character's y-coordinate)
  RES 7,C                 ;
  CP C                    ; Is the character at the location to which the
                          ; location descriptor corresponds?
  JR NZ,LOCDESCS_3        ; Move along to the next location descriptor if not
; The character is standing next to the entrance to a building. Check whether a
; closed door is in his way.
  INC L                   ; Point HL at the third byte of the location
                          ; descriptor
  BIT 0,(HL)              ; Is there a door at this location?
  JR Z,LOCDESCS_10        ; Jump if not
  LD A,E                  ; A=x, the character's x-coordinate
  INC A                   ; A=INT((x+1)/8)
  RRCA                    ;
  RRCA                    ;
  RRCA                    ;
  AND 31                  ;
  PUSH HL                 ; Save the location descriptor pointer briefly
  LD L,A                  ; Point HL at the entry in the table of Z values at
  LD H,189                ; ZVALUES1 that corresponds to the door
  BIT 2,(HL)              ; Set the zero flag if the door is open
  POP HL                  ; Restore the location descriptor pointer to HL
  JP NZ,LOCDESCSD         ; Jump if the door is closed to find the location
                          ; descriptor that corresponds to the character's
                          ; z-coordinate (1=behind the door, 2=in front of it)
LOCDESCS_10;
  LD A,3                  ; A=3; the character is standing next to the open
                          ; entrance to a building
  DEC L                   ; Point HL at the second byte of the location
                          ; descriptor
  JR LOCDESCS_8           ; Jump back to collect the second and third bytes (Q'
                          ; and Q'') in C and B

; Unused
  DEFS 2

; Make a character stand up if he's lying down
;
; Used by the routines at MOVEUP, MOVERIGHT and MOVELEFT. Makes a character
; stand up if he's lying down, and returns with the carry flag set if the
; character was lying down.
;
; H Character number (215-230)
STANDUP;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  LD A,(HL)               ; A=character's animatory state
  INC A                   ; Set the zero flag if the animatory state is
  AND 7                   ; congruent to 7 mod 8 (the sprite has 3 rows and 5
                          ; columns)
  RET NZ                  ; Return (with the carry flag reset) if the
                          ; character's sprite has 5 rows and 3 columns
; This entry point is used by the routines at KNOCKED1 and ROOFEDGE.
STANDUP_0;
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  BIT 7,A                 ; Is the character facing left?
  JR Z,STANDUP_1          ; Jump if so
  INC E                   ; Add 2 to the character's x-coordinate
  INC E                   ;
STANDUP_1;
  DEC D                   ; Subtract 2 from the character's y-coordinate
  DEC D                   ;
  AND 248                 ; A=character's base animatory state (standing
                          ; upright)
  JR MOVELEFT_1           ; Update the character's animatory state and location
                          ; and update the SRB, and return with the carry flag
                          ; set

; Make a character move up
;
; Used by the routines at UP, UPDOWNSC and GOTO. Attempts to move a character
; in the following ways, in the given order, depending on the directions that
; are available at the character's current location;
;
; +------------+------------------------------------------------------------+
; | Move       | Condition                                                  |
; +------------+------------------------------------------------------------+
; | Up         | There is a step going up in the direction the character is |
; |            | facing                                                     |
; | Turn round | There is a step going up in the other direction            |
; | Forwards   | There is no step going up                                  |
; | Down       | The character can only step down from his current location |
; +------------+------------------------------------------------------------+
;
; H Character number (215-230)
MOVEUP;
  LD DE,DIRINDLU          ; Point DE at the direction indicator table at
                          ; DIRINDLU
  JR MOVEDOWN_0

; Make a character move down
;
; Used by the routines at DOWN, UPDOWNSC and GOTO to attempt to move a
; character in the following ways, in the given order, depending on the
; directions that are available at the character's current location;
;
; +------------+--------------------------------------------------------------+
; | Move       | Condition                                                    |
; +------------+--------------------------------------------------------------+
; | Down       | There is a step going down in the direction the character is |
; |            | facing                                                       |
; | Turn round | There is a step going down in the other direction            |
; | Forwards   | There is no step going down                                  |
; | Up         | The character can only step up from his current location     |
; +------------+--------------------------------------------------------------+
;
; H Character number (215-230)
MOVEDOWN;
  LD DE,DIRINDLD          ; Point DE at the direction indicator table at
                          ; DIRINDLD
; This entry point is used by the routine at MOVEUP with DE=DIRINDLU.
MOVEDOWN_0;
  CALL STANDUP            ; Make the character stand up if he's lying down
  RET C                   ; Return if the character was lying down
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,MOVELEFT_2         ; Jump if so
  INC D                   ; DE=DIRINDRU or DIRINDRD
  JR MOVELEFT_2           ; Move the character and update the SRB accordingly

; Make a character move right
;
; Used by the routines at RIGHT, WALKFLOOR, GOTO and WALK. Turns the character
; round if he's facing left; otherwise moves him right, or up and to the right,
; or down and to the right (in that order of preference).
;
; H Character number (215-230)
MOVERIGHT;
  CALL STANDUP            ; Make the character stand up if he's lying down
  RET C                   ; Return if the character was lying down
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,MOVELEFT_0         ; Make him turn round if so
  LD DE,DIRINDRR          ; Point DE at the direction indicator table at
                          ; DIRINDRR
  JR MOVELEFT_2           ; Move the character and update the SRB accordingly

; Make a character move left
;
; Used by the routines at LEFT, WALKFLOOR, GOTO and WALK. Turns the character
; round if he's facing right; otherwise moves him left, or up and to the left,
; or down and to the left (in that order of preference, and if possible).
; Returns with the carry flag set unless the character could not move.
;
; H Character number (215-230)
MOVELEFT;
  CALL STANDUP            ; Make the character stand up if he's lying down
  RET C                   ; Return if the character was lying down
  BIT 7,(HL)              ; Set the zero flag if the character is facing left
  LD DE,DIRINDLL          ; Point DE at the direction indicator table at
                          ; DIRINDLL
  JR Z,MOVELEFT_2         ; Jump if the character is facing left
; The character is facing right, so we make him turn round first. This entry
; point is also used by the routine at MOVERIGHT to make a character who is
; facing left turn round.
MOVELEFT_0;
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  XOR 128                 ; Flip bit 7 of the character's animatory state, thus
                          ; turning him round
; This entry point is used by the routine at STANDUP.
MOVELEFT_1;
  CALL UPDATEAS           ; Update the character's animatory state and location
                          ; and update the SRB
  SCF                     ; Set the carry flag to indicate that the character
                          ; was moved
  RET
; This entry point is used by the routine at MOVEUP (with DE=DIRINDLU,
; DIRINDRU, DIRINDLD or DIRINDRD) to move a character up or down, and by the
; routine at MOVERIGHT (with DE=DIRINDRR) to make a character move right.
MOVELEFT_2;
  PUSH HL                 ; Save the character buffer pointer briefly
  PUSH DE                 ; Save the pointer to the direction indicator table
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Point HL at the direction indicator table
                          ; (DIRINDLL, DIRINDRR, DIRINDLU, DIRINDRU, DIRINDLD
                          ; or DIRINDRD)
  LD E,A                  ; E=location type indicator (1-5; see LOCDESCS)
MOVELEFT_3;
  LD A,C                  ; A=direction descriptor (see LOCDESCS)
  AND (HL)                ; Does this direction indicator correspond to a
                          ; direction that is available at the character's
                          ; current location?
  JR NZ,MOVELEFT_4        ; Jump if so
  INC L                   ; Point HL at the next byte in the direction
                          ; indicator table
  BIT 2,L                 ; Have we reached the end of the direction indicator
                          ; table?
  JR Z,MOVELEFT_3         ; Jump back if not
  POP HL                  ; Restore the character buffer pointer to HL
  RET                     ; Return with the carry flag reset (the character did
                          ; not move)
; Now A=128, 64, 32, 16, 8 or 4; the bit set in A indicates the direction in
; which the character has chosen to move next;
;
; +-----+-----------------------+
; | Bit | Direction             |
; +-----+-----------------------+
; | 7   | Left                  |
; | 6   | Right                 |
; | 5   | Up and to the left    |
; | 4   | Up and to the right   |
; | 3   | Down and to the left  |
; | 2   | Down and to the right |
; +-----+-----------------------+
MOVELEFT_4;
  LD D,A                  ; D=direction indicator (128, 64, 32, 16, 8 or 4)
  POP HL                  ; Restore the character buffer pointer to HL
  BIT 7,(HL)              ; Set the zero flag if the character is facing left
  LD A,84                 ; A=84; bits 6 (right), 4 (up/right) and 2
                          ; (down/right) set
  JR NZ,MOVELEFT_5        ; Jump if the character is facing right
  ADD A,A                 ; A=168; bits 7 (left), 5 (up/left) and 3 (down/left)
                          ; set
MOVELEFT_5;
  AND D                   ; Is the character facing the direction in which he
                          ; wants to move?
  JR Z,MOVELEFT_0         ; Make him turn round if not
; The character is facing the direction in which he wants to move. Now we
; examine the character's current location to determine whether the desired
; move requires any special handling.
  LD L,4                  ; Point HL at byte 4 of the character's buffer
  LD A,E                  ; A=location type indicator for the character's
                          ; current location (1-5; see LOCDESCS)
  DEC A                   ; Is the character on the sidewalk or the road?
  JR NZ,MOVELEFT_6        ; Jump if not
; The character is on the sidewalk or the road. In this case we need to check
; whether the character is going up a step, and change his z-coordinate
; accordingly.
  LD A,D                  ; A=direction indicator (128, 64, 32, 16, 8 or 4)
  AND 48                  ; Check bits 4 and 5; is the character going to move
                          ; up a step?
  JR Z,MOVELEFT_7         ; Jump if not
  RRCA                    ; Slide bits 5 and 4 of A into bits 1 and 0
  RRCA                    ;
  RRCA                    ;
  RRCA                    ;
  AND C                   ; Will going up the step change the character's
                          ; z-coordinate to 2?
  JR Z,MOVELEFT_7         ; Jump if not
  LD (HL),2               ; Set the character's z-coordinate to 2
  JR MOVELEFT_7
; The character is not on the sidewalk or the road.
MOVELEFT_6;
  RRCA                    ; Is the location type indicator 3 (at the open
                          ; entrance to a building) or 5 (a location that
                          ; requires special handling)?
  JR NC,MOVELEFT_11       ; Jump if so
; Finally we can move the character midstride in the desired direction and
; update the SRB accordingly. This entry point is used by the routines at
; BYJAILDOOR and ROOFNO19. The address of this entry point is also found at
; SLHANDLER1; it is used to handle a character who is moving from one of a set
; of certain special locations, but it does not actually do anything special.
MOVELEFT_7;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  LD C,5                  ; Point BC at byte 5 of the character's buffer
  LD B,H                  ;
  LD A,(HL)               ; A=character's animatory state
  XOR 2                   ; A=character's post-midstride animatory state
  LD (BC),A               ; Save this in byte 5 of the character's buffer
  INC L                   ; Point HL at byte 1 of the character's buffer
  INC C                   ; Point BC at byte 6 of the character's buffer
  RLCA                    ; A=-1 if the character is facing left, 1 if he's
  SBC A,A                 ; facing right
  ADD A,A                 ;
  CPL                     ;
  ADD A,(HL)              ; Add the character's current x-coordinate to obtain
                          ; his post-midstride x-coordinate
  LD (BC),A               ; Save this in byte 6 of the character's buffer
  INC L                   ; Point HL at byte 2 of the character's buffer
  INC C                   ; Point BC at byte 7 of the character's buffer
  LD A,D                  ; A=direction indicator (128, 64, 32, 16, 8 or 4)
  AND 60                  ; Is the character going up or down a step?
  JR Z,MOVELEFT_9         ; Jump if not
  AND 48                  ; Is the character going up a step?
  JR Z,MOVELEFT_8         ; Jump if not
  LD A,254                ; A=-2
MOVELEFT_8;
  INC A                   ; A=-1 if the character is going up a step, or 1 if
                          ; he's going down a step
MOVELEFT_9;
  ADD A,(HL)              ; Add the character's y-coordinate; now the carry
                          ; flag is set if the character will be going up a
                          ; step
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  LD (BC),A               ; Save the character's post-midstride y-coordinate in
                          ; byte 7 of his buffer
  LD A,(HL)               ; A=character's animatory state
  PUSH AF                 ; Save the carry flag briefly
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  POP AF                  ; Restore the carry flag
  JR NC,MOVELEFT_10       ; Jump unless the character is going up a step
  DEC D                   ; D=character's new y-coordinate
MOVELEFT_10;
  INC A                   ; A=character's new animatory state
  CALL UPDATEAS           ; Update the character's animatory state and location
                          ; and update the SRB
  SCF                     ; Set the carry flag to indicate that the character
                          ; was moved
  RET
; The location type indicator is 3 (at the open entrance to a building) or 5 (a
; location that requires special handling).
MOVELEFT_11;
  RRCA                    ; Is the location type indicator 5 (a location that
                          ; requires special handling)?
  JR NC,MOVELEFT_12       ; Jump if so
; The character is standing at the open entrance to a building.
  DEC (HL)                ; Set the zero flag if the character is indoors
  LD (HL),1               ; Set the character's z-coordinate to 1 (indoors)
  LD A,D                  ; A=direction indicator (128, 64, 32, 16, 8 or 4)
  CALL BYDOOR             ; Adjust the character's z-coordinate according to
                          ; whether he is going to enter or exit the building,
                          ; and, if dealing with Sam, check whether he is
                          ; entering a house without a key
  JR MOVELEFT_7           ; Move the character midstride
; The character is at a location that may require special handling depending on
; the direction in which he is going.
MOVELEFT_12;
  LD A,D                  ; A=direction indicator (128, 64, 32, 16, 8 or 4)
  RLCA                    ; Move bits 7 (left) and 6 (right) into bits 1 and 0
  RLCA                    ; for comparison with bits 1 and 0 of the direction
                          ; descriptor in C
  AND C                   ; Is the character moving in a direction that
                          ; requires special handling (e.g. off the edge of a
                          ; roof)?
  JR Z,MOVELEFT_7         ; Jump if not to move the character midstride
; The character's next move requires special handling.
  LD A,B                  ; A=Q'', the third byte of the location descriptor
                          ; (1-7; see LOCDESCS)
  ADD A,159               ; A=160-166
  PUSH HL                 ; Save the character number briefly
  LD H,A                  ; Collect in HL the special location handler routine
  LD L,22                 ; address (BYJAILDOOR, MOVELEFT_7 or ROOFEDGE) from
  LD A,(HL)               ; SLHANDLER1, SLHANDLER2, SLHANDLER3, SLHANDLER4,
  INC L                   ; SLHANDLER5, SLHANDLER6 or SLHANDLER7
  LD H,(HL)               ;
  LD L,A                  ;
  EX (SP),HL              ; Restore the character number to H, and copy the
                          ; special location handler routine address onto the
                          ; stack
  RET                     ; To BYJAILDOOR (if Q''=7), MOVELEFT_7 (Q''=1) or
                          ; ROOFEDGE (Q''=2, 3, 4, 5 or 6)

; Unused
  DEFS 2

; Move a character from the midstride or mid-action position and update the SRB
;
; Used by the routines at LIFTSAM, MVSAM, UPDOWNSC, WALKFLOOR and MIDSTRIDE.
; Updates the character's animatory state and location, and updates the screen
; refresh buffer (SRB) accordingly.
;
; H Character number (215-230)
ENDSTRIDE;
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  LD L,5                  ; Point HL at byte 5 of the character's buffer
  LD A,(HL)               ; A=character's post-midstride/post-action animatory
                          ; state
  INC L                   ; Collect the character's post-midstride/post-action
  LD E,(HL)               ; coordinates in DE from bytes 6 and 7 of his buffer
  INC L                   ;
  LD D,(HL)               ;
  LD (HL),0               ; Set byte 7 of the character's buffer to 0 (to
                          ; indicate that he is neither midstride nor
                          ; mid-action now)
  JP UPDATEAS             ; Update the character's animatory state and location
                          ; and update the SRB

; Make a sound effect
;
; Used by the routines at SOMERSAULT, ONPHONE, CUTSCENE, MVSAM, LEFT, DISGUISE
; and ROOFEDGE. Makes the sound effect that is used when 'M' is pressed to
; toggle the message speed, and also by Sam when he is walking, finishes a roll
; or somersault, picks up the hook or budgie, picks up a telephone, is dialling
; a telephone number, hangs up a phone, changes disguise, lowers his arm,
; knocks on a door, blows a fuse, flips a light switch, raises or lowers a
; window blind, throws the hook, or is falling from the roof of a building.
SNDEFFECT2;
  PUSH BC
  LD A,1                  ; BORDER 1 (blue)
  LD C,7                  ; Initialise the duration counter
SNDEFFECT2_0;
  XOR 16                  ; Flip bit 4 (the speaker bit)
  OUT (254),A             ; Change the speaker state
  LD B,192                ; Perform the pitch delay
SNDEFFECT2_1;
  DJNZ SNDEFFECT2_1       ;
  DEC C                   ; Have we finished the sound effect yet?
  JR NZ,SNDEFFECT2_0      ; Jump back if not
  POP BC
  RET

; Move Sam from the midstride or mid-action position and scroll the screen if
; necessary
;
; Called from the main loop at MAINLOOP, and also used by the routines at
; ARMDOWN and SAMBYDOOR.
MVSAM;
  CALL SNDEFFECT2         ; Make a sound effect
  LD H,230                ; 230=Sam
  CALL ENDSTRIDE          ; Move Sam from the midstride or mid-action position
                          ; and update the SRB
; This entry point is used by the routines at SOMERSAULT, CARRIED and ROOFEDGE.
MVSAM_0;
  LD DE,LEFTCOL           ; LEFTCOL holds X, the x-coordinate of the leftmost
                          ; column of the play area on screen
  LD L,1                  ; Point HL at byte 1 of Sam's buffer
  LD A,(DE)               ; A=X
  SUB (HL)                ; Subtract Sam's x-coordinate
  JR Z,MVSAM_1            ; Jump if they are equal
  CP 247                  ; Is Sam's x-coordinate >= X+10?
  JR C,MVSAM_2            ; Jump if so (no need to scroll right)
MVSAM_1;
  LD A,(DE)               ; A=X
  AND A                   ; Is X=0?
  JR Z,MVSAM_3            ; Jump if so (no need to scroll right)
  CALL UPDATESCR          ; Update the display
  CALL CBUFGFWD           ; Cycle a character buffer group forwards and scroll
                          ; the screen right
  JR MVSAM_3
MVSAM_2;
  CP 235                  ; Is Sam's x-coordinate <= X+21?
  JR NC,MVSAM_3           ; Jump if so (no need to scroll left)
  LD A,(DE)               ; A=X
  CP 224                  ; Is X=224?
  JR Z,MVSAM_3            ; Jump if so (no need to scroll left)
  CALL UPDATESCR          ; Update the display
  CALL CBUFGREV           ; Cycle a character buffer group backwards and scroll
                          ; the screen left
; Now that any required horizontal scrolling has been done, it's time to check
; whether any vertical scrolling is required.
MVSAM_3;
  LD DE,TOPROW            ; TOPROW holds Y, the y-coordinate of the topmost row
                          ; of the play area on screen
  LD HL,58882             ; Point HL at byte 2 of Sam's buffer
  LD A,(DE)               ; A=Y-3
  SUB 3                   ;
  SUB (HL)                ; Subtract Sam's y-coordinate
  CP 252                  ; Is Sam's y-coordinate >= Y+2?
  JR C,MVSAM_4            ; Jump if so (no need to scroll down)
  LD A,(DE)               ; A=Y
  CP 2                    ; Is Y=2?
  RET Z                   ; Return if so (no need to scroll down)
  CALL UPDATESCR          ; Update the display
  JP DSCROLL6             ; Scroll the screen down
MVSAM_4;
  CP 240                  ; Is Sam's y-coordinate <= Y+13?
  RET NC                  ; Return if so (no need to scroll up)
  LD A,(DE)               ; A=Y
  CP 20                   ; Is Y=20?
  RET Z                   ; Return if so (no need to scroll up)
  CALL UPDATESCR          ; Update the display
  JP USCROLL6             ; Scroll the screen up

; Unused
  DEFS 2

; 'Q' pressed - up
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'Q' is
; pressed.
;
; H 230 (Sam)
UP;
  CALL MOVEUP             ; Move Sam up (or in the next best direction) if
                          ; possible
  JR LEFT_0               ; Reset Sam's action timers and make a sound effect

; 'A' pressed - down
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'A' is
; pressed.
;
; H 230 (Sam)
DOWN;
  CALL MOVEDOWN           ; Move Sam down (or in the next best direction) if
                          ; possible
  JR LEFT_0               ; Reset Sam's action timers and make a sound effect

; 'P' pressed - right
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'P' is
; pressed.
;
; H 230 (Sam)
RIGHT;
  CALL MOVERIGHT          ; Move Sam right (or in the next best direction) if
                          ; possible
  JR LEFT_0               ; Reset Sam's action timers and make a sound effect

; 'O' pressed - left
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'O' is
; pressed.
;
; H 230 (Sam)
LEFT;
  CALL MOVELEFT           ; Move Sam left (or in the next best direction) if
                          ; possible
; This entry point is used by the routines at UP, DOWN and RIGHT.
LEFT_0;
  RET NC                  ; Return if Sam could not move in the desired
                          ; direction
  LD A,(KEYCODE)          ; Collect the offset of the last key pressed from
                          ; KEYCODE
  BIT 3,A                 ; Set the zero flag if a 'fast' key (upper case Q, A,
                          ; O or P) was pressed
  LD B,4                  ; 4=fast
  JR Z,LEFT_2             ; Jump if a 'fast' key was pressed
; This entry point is used by the routines at MSGSPEED, PHONE, GETOBJECT and
; KNOCK.
LEFT_1;
  LD B,8                  ; 8=slow
LEFT_2;
  CALL SNDEFFECT2         ; Make a sound effect
  LD L,7                  ; Point HL at byte 7 of Sam's buffer
  LD A,(HL)               ; A=0 if Sam is neither midstride nor mid-action now
  INC L                   ; Set Sam's main action timer in byte 8 of his buffer
  LD (HL),B               ; to either 4 (fast) or 8 (slow)
  AND A                   ; Is Sam midstride or mid-action?
  RET Z                   ; Return if not
  INC L                   ; Set Sam's midstride/mid-action timer in byte 9 of
  LD (HL),B               ; his buffer to either 4 (fast) or 8 (slow)
  RET

; Unused
  DEFS 3

; Addresses of keypress handling routines
;
; Used by the main loop at MAINLOOP. Each non-zero entry in the keypress offset
; table at KEYTABLE points to a routine address in this table.
K_UPF;
  DEFW UP                 ; 1; Up (fast)
K_DOWNF;
  DEFW DOWN               ; 3; Down (fast)
K_RIGHTF;
  DEFW RIGHT              ; 5; Right (fast)
K_LEFTF;
  DEFW LEFT               ; 7; Left (fast)
K_UP;
  DEFW UP                 ; 9; Up (slow)
K_DOWN;
  DEFW DOWN               ; 11; Down (slow)
K_RIGHT;
  DEFW RIGHT              ; 13; Right (slow)
K_LEFT;
  DEFW LEFT               ; 15; Left (slow)
K_DISGUISE;
  DEFW DISGUISE           ; 17; Change disguise
K_KNOCK;
  DEFW KNOCK              ; 19; Knock
K_LIGHT;
  DEFW LIGHT              ; 21; Light on/off
K_BLIND;
  DEFW BLIND              ; 23; Raise/lower blind
K_FUSE;
  DEFW FUSE               ; 25; Fuse
K_MSGSPEED;
  DEFW MSGSPEED           ; 27; Toggle message speed
K_JOYSTICK;
  DEFW JOYSTICK           ; 29; Joystick
K_PHONE;
  DEFW PHONE              ; 31; Telephone
K_GETOBJECT;
  DEFW GETOBJECT          ; 33; Get object
K_USEHOOK;
  DEFW USEHOOK            ; 35; Use hook
K_ROLL;
  DEFW ROLL               ; 37; Forward roll
K_SOMSAULT;
  DEFW SOMERSAULT         ; 39; Somersault
  DEFW XRETBASIC          ; 41; Unused

; Unused
  DEFS 6

; Obtain location descriptors for a character standing next to a closed door
;
; Used by the routine at LOCDESCS. A location descriptor for the character's
; current location has been found, and it corresponds to a location that is
; next to a door that happens to be closed. In this case we process the
; remaining location descriptors for the character's x-coordinate, one of which
; may be specific to the character's z-coordinate (1=behind the closed door, or
; 2=in front of it), and thus provide the appropriate direction descriptors
; (which are returned in C). For an example of where this can happen, see the
; three descriptors in the location descriptor table at LOCDESCS0 that
; correspond to the entrance to the shop at the far left of town.
;
; B Character's y-coordinate (bits 2-6; y-4) and z-coordinate (bit 7; z-1)
; E Character's x-coordinate
; HL Address of the third byte of the location descriptor just processed
LOCDESCSD;
  CALL LOCDESCS_4         ; Process the remaining location descriptors for the
                          ; character's x-coordinate
  LD A,4                  ; A=4; the character is standing behind or in front
                          ; of a closed door
  RET

; Obtain an identifier for a character's current location
;
; Used by the routine at BYHOTEL. Returns with A=255 if the character's
; z-coordinate is 2 or 4, and his y-coordinate is less than 31 (meaning he is
; on the fire escape of the apartment building next to no. 19, or falling from
; the roof of a building); with A=0 if he's on the sidewalk or the road; or
; with certain bits of A set or reset depending on the location;
;
; +--------+-----------------------------------------------------------------+
; | Bit(s) | Meaning                                                         |
; +--------+-----------------------------------------------------------------+
; | 0      | 0; On the floor of a shop or other building                     |
; |        | 1; On a staircase between floors, or on the front steps of a    |
; |        | building below the first floor, or on the rim of a roof         |
; | 1-3    | 000; On the front steps of a building below the first floor     |
; |        | 001; Next to the entrance to a shop or other building (outside) |
; |        | 010; Shop or first floor of other building (inside)             |
; |        | 011; Second floor of a building                                 |
; |        | 100; Third floor of a building                                  |
; |        | 101; Fourth floor of a building (could be the roof)             |
; |        | 110; Fifth floor of a building (could be the roof)              |
; | 4-7    | Region ID (see below)                                           |
; +--------+-----------------------------------------------------------------+
;
; The region ID in bits 4-7 corresponds to a certain shop or other building in
; the play area;
;
; +-----------+-----------------------------------------------------+
; | Region ID | Building                                            |
; +-----------+-----------------------------------------------------+
; | 0001      | Left-hand shop under the apartments next to no. 74  |
; | 0010      | Right-hand shop under the apartments next to no. 74 |
; | 0011      | Shop under no. 17                                   |
; | 0100      | Shop under no. 15                                   |
; | 0101      | Apartment building next to no. 74                   |
; | 0110      | Police station                                      |
; | 0111      | No. 27                                              |
; | 1000      | No. 74                                              |
; | 1001      | Hotel                                               |
; | 1010      | No. 31                                              |
; | 1011      | No. 19                                              |
; | 1100      | No. 17                                              |
; | 1101      | Unused                                              |
; | 1110      | No. 15                                              |
; | 1111      | Apartment building next to no. 19                   |
; +-----------+-----------------------------------------------------+
;
; In addition, on return E holds the x-coordinate of the bottom of the
; staircase going up to the floor above, and D holds the x-coordinate of the
; top of the staircase going down to the floor below.
;
; H Character number (215-230)
LOCID;
  LD L,1                  ; E=character's x-coordinate
  LD E,(HL)               ;
  INC L                   ; D=character's y-coordinate
  LD D,(HL)               ;
  LD L,4                  ; C=character's z-coordinate
  LD C,(HL)               ;
; This entry point is used by the routine at DESTTOSAM.
LOCID_0;
  BIT 0,C                 ; Is the z-coordinate 1 (indoors)?
  JR NZ,LOCID_1           ; Jump if so
  LD A,D                  ; A=y-coordinate
  CP 31                   ; A=255 if the y-coordinate is less than 31, 0
  SBC A,A                 ; otherwise
  RET C                   ; Return with A=255 if the y-coordinate is less than
                          ; 31, and the z-coordinate is 2 or 4
; This entry point is used by the routines at GETINPUT and ENTRYNOKEY.
LOCID_1;
  CALL RDORSWALK_0        ; Check whether the character is on the sidewalk or
                          ; road
  LD A,0                  ; Return with A=0 if the character is on the sidewalk
  RET NC                  ; or road
; At this point we have determined that the character is on the front steps of
; or inside a building.
  PUSH HL                 ; Save the character number
  LD A,37                 ; L=10 (if 31<D), 11 (25<D<=31), 12 (19<D<=25), 13
  LD L,9                  ; (13<D<=19), 14 (7<D<=13) or 15 (1<D<=7)
LOCID_2;
  INC L                   ;
  SUB 6                   ;
  CP D                    ;
  JR NC,LOCID_2           ;
  SUB D                   ; Set the zero flag if D=7, 13, 19, 25 or 31
  ADD A,6                 ; (corresponding to the floor of a building)
  PUSH AF                 ; Save A and the zero flag
  LD H,239                ; The region identifier tables are in page 239
  LD A,E                  ; A=x-coordinate
  LD L,(HL)               ; Point HL at one of the tables at REGIDS0, REGIDS1,
                          ; REGIDS2, REGIDS3, REGIDS4 and REGIDS5
LOCID_3;
  CP (HL)                 ; Find the first entry whose first byte is greater
  INC HL                  ; than A (the target x-coordinate)
  INC HL                  ;
  INC HL                  ;
  INC HL                  ;
  JR NC,LOCID_3           ;
  DEC HL                  ; E=fourth byte of the entry (x-coordinate of the
  LD E,(HL)               ; bottom of the staircase going up to the floor
                          ; above)
  DEC HL                  ; D=third byte of the entry (x-coordinate of the top
  LD D,(HL)               ; of the staircase going down to the floor below)
  DEC HL                  ; A=second byte of the entry (location identifier)
  LD A,(HL)               ;
  CP 80                   ; Is the second byte of the entry less than 80?
  JR NC,LOCID_5           ; Jump if not
; The second byte of the entry is less than 80, which is true only for the four
; entries in the region identifier table at REGIDS0 that correspond to the
; shops.
  POP AF                  ; Restore A and the zero flag (though the values are
                          ; ignored at this point)
LOCID_4;
  LD A,(HL)               ; A=location identifier
  BIT 0,C                 ; Set the zero flag if the z-coordinate is 1
                          ; (indoors)
  POP HL                  ; Restore the character number to H
  RET NZ                  ; Return if the z-coordinate is 1
  SUB 2                   ; Reset bit 2 of A, and set bit 1 (to indicate that
                          ; the character is standing outside the door of a
                          ; shop or house)
  RET
; The second byte of the entry (held in A) is at least 80, which means it
; corresponds to a location other than one of the four shops.
LOCID_5;
  AND 15                  ; Keep only bits 0-3 of the location identifier
  CP 4                    ; Is this location on the first floor of a building?
  JR NZ,LOCID_6           ; Jump if not
  POP AF                  ; Restore A and the zero flag
  JR Z,LOCID_4            ; Jump if the y-coordinate corresponds to a floor of
                          ; a building
  PUSH AF                 ; Save A and the zero flag again
LOCID_6;
  POP AF                  ; Restore A and the zero flag
  LD A,(HL)               ; A=location identifier
  POP HL                  ; Restore the character number to H
  RET Z                   ; Return if the y-coordinate corresponds to a floor
                          ; of a building
  INC A                   ; Set bit 0 of A to indicate that the character is on
                          ; a staircase between two floors of a building, or on
                          ; the front steps of a building below the first
                          ; floor, or on the rim of a roof
  RET

; Unused
  DEFS 2

; Determine the next move a character should make to reach his destination
;
; Used by the routines at MVCOP2, GETINPUT, HOODTOSAM2 and GOTO. Returns with A
; holding a value that indicates the next move the character should make (if
; any) to reach his destination.
;
; +---+----------------------------------------------------------+
; | A | Meaning the character should...                          |
; +---+----------------------------------------------------------+
; | 0 | Do nothing (the character is already at his destination) |
; | 1 | Go right                                                 |
; | 2 | Go left                                                  |
; | 3 | Go up                                                    |
; | 4 | Go down                                                  |
; | 5 | Open a door from the inside                              |
; | 6 | Knock on a door or use a key                             |
; +---+----------------------------------------------------------+
;
; H Character number (215-230)
NEXTMOVE;
  CALL BYHOTEL            ; Deal with the case where the character will soon be
                          ; entering or leaving the hotel; otherwise return
                          ; here
  LD L,13                 ; Initialise the location/destination indicator in
  LD (HL),0               ; byte 13 of the character's buffer to 0
  AND A                   ; Is the character on the sidewalk or the road?
  JR NZ,NEXTMOVE_4        ; Jump if not
  DEC L                   ; L=12
  LD A,(HL)               ; A=destination location identifier (see LOCID)
  AND A                   ; Is the character's destination on the sidewalk or
                          ; the road?
  JR NZ,NEXTMOVE_1        ; Jump if not
; The next section of code deals with the case where the character can reach
; his destination simply by continuing to move left or right. The routine at
; BYHOTEL re-enters here (from the opening CALL in this routine) if the
; character is on the front steps of the hotel, and his destination is on the
; first floor or the front steps of the hotel.
NEXTMOVE_0;
  LD L,10                 ; Point HL at byte 10 of the character's buffer
  LD E,(HL)               ; E=destination x-coordinate
  LD A,E                  ; Copy this to A
  LD L,1                  ; Does the character's x-coordinate match the
  CP (HL)                 ; destination x-coordinate?
  LD A,0                  ; Return with A=0 (do nothing) if so
  RET Z                   ;
  LD A,1                  ; Return with A=1 (go right) if the character's
  RET NC                  ; x-coordinate is less than the destination
                          ; x-coordinate
  INC A                   ; A=2 (go left)
  RET
; The character is on the sidewalk or the road, and his destination is
; somewhere other than the sidewalk or the road. Move the character left or
; right towards the building he's destined for, or make him go up a step if
; he's reached the front steps of the building.
NEXTMOVE_1;
  AND 240                 ; Keep only the region identifier bits (bits 4-7) of
                          ; the destination
  RRCA                    ; Shift them into bits 1-4
  RRCA                    ;
  RRCA                    ;
  ADD A,150               ; A=152+2n (n=0-11, 13 or 14)
  LD C,A                  ; Point BC at the entry in the table of building
  LD B,255                ; entrance x-coordinates at ENTRANCEX that
                          ; corresponds to the character's destination
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(BC)               ; Pick up the lower x-coordinate of the building
                          ; entrance
  LD E,A                  ; Copy it to E
  CP (HL)                 ; Compare it with the character's x-coordinate
  LD A,L                  ; A=1 (go right)
  JR NZ,NEXTMOVE_2        ; Jump unless the x-coordinates match
  DEC L                   ; L=0
  BIT 7,(HL)              ; Is the character facing right?
  JR NZ,NEXTMOVE_3        ; Jump if so
NEXTMOVE_2;
  RET NC                  ; Return with A=1 (go right)
  INC C                   ; Pick up the upper x-coordinate of the building
  LD A,(BC)               ; entrance
  LD E,A                  ; Copy it to E
  CP (HL)                 ; Compare it with the character's x-coordinate
  LD A,2                  ; A=2 (go left)
  RET NZ                  ; Return unless the x-coordinates match
  DEC L                   ; L=0
  BIT 7,(HL)              ; Is the character facing right?
  RET NZ                  ; Return with A=2 (go left) if so
NEXTMOVE_3;
  LD L,13                 ; Set byte 13 of the character's buffer to 1
  INC (HL)                ; (indicating that the character is no longer on the
                          ; sidewalk or the road, and is in the same region as
                          ; his destination)
  LD A,3                  ; A=3 (go up)
  RET
; The character is on neither the sidewalk nor the road.
NEXTMOVE_4;
  INC (HL)                ; Set byte 13 of the character's buffer to 1
                          ; (indicating that the character is on neither the
                          ; sidewalk nor the road)
  DEC L                   ; L=12
  INC A                   ; Is the character on the fire escape of the
                          ; apartment building next to no. 19?
  JR NZ,NEXTMOVE_7        ; Jump if not
; The character is on the fire escape of the apartment building next to no. 19.
  LD A,(HL)               ; A=destination location identifier (see LOCID)
  INC A                   ; Set the zero flag if the destination is on the fire
                          ; escape
  SCF                     ; Set the carry flag; the character will go back up
                          ; the fire escape (if his destination is not on the
                          ; fire escape)
  JR NZ,NEXTMOVE_5        ; Jump if the destination is not on the fire escape
  DEC L                   ; L=11
  LD A,(HL)               ; A=character's destination y-coordinate
  LD L,2                  ; Point HL at byte 2 of the character's buffer
  CP (HL)                 ; Does the character's y-coordinate match that of his
                          ; destination?
  JR Z,NEXTMOVE_0         ; If so, move the character left or right towards his
                          ; destination
NEXTMOVE_5;
  PUSH AF                 ; Save the carry flag briefly
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  POP AF                  ; Restore the carry flag
  LD A,C                  ; Copy the direction descriptor bits (see LOCDESCS)
                          ; to A
  JR NC,NEXTMOVE_6        ; Jump if the character's y-coordinate is less than
                          ; that of his destination
; The character is on the fire escape of the apartment building next to no. 19,
; and his destination is either not on the fire escape, or somewhere further up
; the fire escape. In this case the character will go up the fire escape.
  AND 16                  ; Set the zero flag unless the character is next to a
                          ; step going up to the right
  LD A,3                  ; A=3 (go up)
  RET NZ                  ; Return if the character is next to a step going up
                          ; to the right
  DEC A                   ; A=2 (go left)
  RET
; The character is on the fire escape of the apartment building next to no. 19,
; and his destination is somewhere further down the fire escape. In this case
; the character will go down the fire escape.
NEXTMOVE_6;
  AND 8                   ; Set the zero flag unless the character is next to a
                          ; step going down to the left
  LD A,4                  ; A=4 (go down)
  RET NZ                  ; Return if the character is next to a step going
                          ; down to the left
  LD A,1                  ; A=1 (go right)
  RET
; The character is on neither the sidewalk nor the road, nor on the fire escape
; of the apartment building next to no. 19.
NEXTMOVE_7;
  DEC A                   ; A=identifier for the character's current location
                          ; (see LOCID)
  LD B,(HL)               ; B=destination location identifier (see LOCID)
  INC B                   ; Is the destination on the fire escape of the
                          ; apartment building next to no. 19?
  JR NZ,NEXTMOVE_8        ; Jump if not
  CP 253                  ; Is the character on the rim of the roof of the
                          ; apartment building next to no. 19?
  JR NZ,NEXTMOVE_8        ; Jump if not
  LD A,4                  ; A=4 (go down)
  RET
; The character is on neither the sidewalk nor the road, nor on the fire escape
; of the apartment building next to no. 19; in addition, either his destination
; is not on the fire escape, or he is not on the rim of the roof of the
; apartment building next to no. 19.
NEXTMOVE_8;
  LD B,A                  ; B=identifier for the character's current location
                          ; (see LOCID)
  AND 240                 ; Keep only the region identifier bits (bits 4-7)
  LD C,A                  ; Copy them to C
  LD A,(HL)               ; Collect the destination location identifier from
                          ; byte 12 of the character's buffer
  AND 240                 ; Keep only the region identifier bits (bits 4-7)
  CP C                    ; Is the character in the same region as his
                          ; destination?
  JP NZ,NEXTMOVE_18       ; Jump if not
; The character is in the same region as his destination.
  LD A,B                  ; A=identifier for the character's current location
                          ; (see LOCID)
  CP (HL)                 ; Compare it with the identifier for the character's
                          ; destination
  JR NZ,NEXTMOVE_9        ; Jump unless they match
; The character is in the same region as his destination, and also on the same
; floor.
  LD L,11                 ; A=character's destination y-coordinate
  LD A,(HL)               ;
  LD L,2                  ; Compare this with the character's current
  CP (HL)                 ; y-coordinate
  JP Z,NEXTMOVE_0         ; If they match, move the character left or right
                          ; towards his destination
  LD A,3                  ; A=3 (go up)
  RET C                   ; Return if the character's current y-coordinate is
                          ; greater than that of his destination
  INC A                   ; A=4 (go down)
  RET
; The character is in the same region as his destination, but either on a
; different floor, or outside the entrance to a shop or building when the
; destination is on the first floor inside (or vice versa).
NEXTMOVE_9;
  JR C,NEXTMOVE_14        ; Jump if the character is below his destination
  AND 15                  ; Keep only bits 0-3 of the identifier for the
                          ; character's current location
  CP 4                    ; Is the character in a shop or on the first floor of
                          ; a building (inside)?
  JR NZ,NEXTMOVE_13       ; Jump if not
  LD A,(HL)               ; A=destination location identifier
  AND 15                  ; Keep only bits 0-3
  CP 2                    ; Set the zero flag if the destination is outside the
                          ; entrance
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  JR NZ,NEXTMOVE_11       ; Jump unless the destination is outside the entrance
  LD A,(HL)               ; A=character's x-coordinate
  LD L,10                 ; Does it match the destination x-coordinate?
  CP (HL)                 ;
  JR NZ,NEXTMOVE_10       ; Jump if not
  PUSH DE                 ; Save the staircase endpoint x-coordinates briefly
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  POP DE                  ; Restore the staircase endpoint x-coordinates to DE
  SUB 3                   ; Is the character standing at the (open) entrance to
                          ; a building?
  RET Z                   ; Return with A=0 (do nothing) if so
NEXTMOVE_10;
  LD L,1                  ; Point HL at byte 1 of the character's buffer
NEXTMOVE_11;
  LD A,(HL)               ; A=character's x-coordinate
  CP D                    ; Is the character standing at the top of the steps
                          ; down to the sidewalk or the floor below?
  JR NZ,NEXTMOVE_12       ; If not, send the character towards the top of the
                          ; steps
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  INC A                   ; Is the character standing next to the open entrance
  CP 4                    ; to a building?
  RET Z                   ; Return with A=4 (go down) if so
  LD A,5                  ; A=5 (open the door)
  RET
NEXTMOVE_12;
  LD A,1                  ; A=1 (go right)
  RET C
  INC A                   ; A=2 (go left)
  RET
; Either the character is in the same region as his destination, but above it,
; and not in a shop or on the first floor of a building (inside); or the
; character is not in the same region as his destination, and is inside a
; building somewhere above the first floor.
NEXTMOVE_13;
  BIT 0,A                 ; Set the zero flag unless the character is on a
                          ; staircase between floors
  LD A,4                  ; A=4 (go down)
  RET NZ                  ; Return if the character is on a staircase between
                          ; floors
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=character's x-coordinate
  CP D                    ; Compare it with the x-coordinate of the top of the
                          ; staircase leading down to the floor below
  LD A,4                  ; A=4 (go down)
  RET Z                   ; Return if the character is standing at the top of
                          ; the staircase leading down to the floor below
  JR NEXTMOVE_12          ; Send the character towards the top of the staircase
; The character is in the same region as his destination, but below it.
NEXTMOVE_14;
  CALL ROOFEDGES          ; Deal with the case where the character is on the
                          ; roof of the police station or the apartment
                          ; building next to no. 19 and is destined for the
                          ; edge of that roof; otherwise return here
  NOP
  JR NZ,NEXTMOVE_16       ; Jump unless the character is standing outside the
                          ; entrance to a shop or other building
  LD A,(HL)               ; A=destination location identifier (see LOCID)
  AND 15                  ; Keep only bits 0-3
  CP 4                    ; Set the zero flag if the destination is inside the
                          ; shop or on the first floor of the building outside
                          ; the entrance to which the character is standing
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  JR NZ,NEXTMOVE_15       ; Jump unless the destination is inside the shop or
                          ; on the first floor of the building outside the
                          ; entrance to which the character is standing
  LD A,(HL)               ; A=character's x-coordinate
  LD L,10                 ; Compare this with the destination x-coordinate
  CP (HL)                 ;
  JR NZ,NEXTMOVE_15       ; Jump unless they match
  PUSH DE                 ; Save the staircase endpoint x-coordinates briefly
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  POP DE                  ; Restore the staircase endpoint x-coordinates to DE
  SUB 3                   ; Is the entrance next to which the character is
                          ; standing open?
  RET Z                   ; Return with A=0 (do nothing) if so
NEXTMOVE_15;
  NOP
; The character is standing outside the entrance to a shop or other building,
; and his destination is somewhere inside that shop or building.
  CALL BYENTRY            ; Is the character standing at the right spot to
                          ; enter the building or knock on the door?
  JR NZ,NEXTMOVE_17       ; Jump if not
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  CP 3                    ; Set the zero flag if the entrance is open
  JP CHKENTRY             ; Check whether the character should enter the
                          ; building or knock first
  NOP                     ; This instruction is never executed
; If we get here, then either the character is in the same region as his
; destination, but below it, and is not standing outside the entrance to a shop
; or other building; or the character is inside or on the roof of the police
; station and heading for no. 27 (or vice versa), and will be going via the
; roofs (instead of going down to the sidewalk).
NEXTMOVE_16;
  BIT 0,A                 ; Bit 0 of A is set if the character is on a
                          ; staircase
  LD A,3                  ; A=3 (go up)
  RET NZ                  ; Return if the character is on a staircase
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=character's x-coordinate
  CP E                    ; Compare this with the x-coordinate of the bottom of
                          ; the staircase leading to the floor above
  LD A,3                  ; Return with A=3 (go up) if the character is at the
  RET Z                   ; bottom of the staircase leading to the floor above
NEXTMOVE_17;
  LD A,L                  ; Return with A=1 (go right) if the character is to
  RET C                   ; the left of either the bottom of the staircase
                          ; leading to the floor above, or the correct spot at
                          ; which to enter the building or knock on the door
  INC A                   ; A=2 (go left)
  RET
; The character is not in the same region as his destination.
NEXTMOVE_18;
  INC L                   ; Set byte 13 of the character's buffer to 2 (to
  INC (HL)                ; indicate that the character is not on the sidewalk
                          ; or the road, and is heading for some region other
                          ; than the one he's in)
  DEC L                   ; L=12
  CP 96                   ; Is the character going to the police station?
  JR Z,NEXTMOVE_19        ; Jump if so
  CP 112                  ; Is the character going to no. 27?
  JR NZ,NEXTMOVE_21       ; Jump if not
; The character is going to no. 27, and is not in the same region as that
; building.
  LD A,C                  ; A=region identifier for the character's current
                          ; location
  CP 96                   ; Is the character inside or on the roof of the
                          ; police station?
  JR NZ,NEXTMOVE_21       ; Jump if not
  JR NEXTMOVE_20
; The character is going to the police station, and is not in the same region
; as that building.
NEXTMOVE_19;
  LD A,C                  ; A=region identifier for the character's current
                          ; location
  CP 112                  ; Is the character inside or on the roof of no. 27?
  JR NZ,NEXTMOVE_21       ; Jump if not
; The character is either inside or on the roof of no. 27 and heading for the
; police station, or inside or on the roof of the police station and heading
; for no. 27.
NEXTMOVE_20;
  LD A,B                  ; A=identifier for the character's current location
                          ; (96-109 if it's the police station, or 112-125 if
                          ; it's no. 27; see LOCID)
  ADD A,(HL)              ; Add the destination location identifier
  CP 225                  ; Reset the carry flag if it would be quicker to go
                          ; via the roofs than back down to the sidewalk
  LD A,B                  ; A=identifier for the character's current location
                          ; (see LOCID)
  JR NC,NEXTMOVE_16       ; Jump if it would be quicker to go via the roofs
                          ; than back down to the sidewalk
; The character is not in the same region as his destination. Figure out his
; next move towards the destination via the sidewalk.
NEXTMOVE_21;
  LD A,B                  ; A=identifier for the character's current location
                          ; (see LOCID)
  AND 15                  ; Keep only bits 0-3
  CP 4                    ; Is the character inside a shop or on the first
                          ; floor of a building (inside)?
  JP Z,NEXTMOVE_10        ; If so, send him towards the entrance
  CP 1                    ; Is the character on the front steps of a building
                          ; below the first floor?
  JP NZ,NEXTMOVE_13       ; If not, send the character towards the top of the
                          ; staircase leading down to the floor below
; The character is not in the same region as his destination, and is on the
; front steps of a building below the first floor. Figure out which direction
; to take down the steps towards the destination.
  PUSH HL                 ; Save the character number briefly
  CALL LOCDESCS           ; Obtain descriptors for the character's current
                          ; location
  POP HL                  ; Restore the character number to H
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=character's x-coordinate
  LD L,10                 ; Compare this with the character's destination
  CP (HL)                 ; x-coordinate
  LD A,C                  ; Copy the direction descriptor bits (see LOCDESCS)
                          ; to A
  JR NC,NEXTMOVE_24       ; Jump if the character's x-coordinate is greater
                          ; than or equal to the destination x-coordinate
  AND 4                   ; Is the character next to a step going down to the
                          ; right?
  JR NZ,NEXTMOVE_23       ; Jump if not
NEXTMOVE_22;
  LD A,4                  ; A=4 (go down)
  RET
NEXTMOVE_23;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  BIT 7,(HL)              ; Is the character facing right?
  JR NZ,NEXTMOVE_22       ; Jump if so to set A=4 (go down)
  LD A,1                  ; A=1 (go right)
  RET
NEXTMOVE_24;
  AND 8                   ; Is the character standing next to a step going down
                          ; to the left?
  JR Z,NEXTMOVE_22        ; Jump if not to set A=4 (go down)
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  BIT 7,(HL)              ; Is the character facing left?
  JR Z,NEXTMOVE_22        ; Jump if so to set A=4 (go down)
  LD A,2                  ; A=2 (go left)
  RET

; Unused
  DEFS 8

; Region identifier tables
;
; Used by the routine at LOCID. The first six bytes here are the LSBs of the
; addresses of the tables that follow at REGIDS0, REGIDS1, REGIDS2, REGIDS3,
; REGIDS4 and REGIDS5.
REGIDS;
  DEFB 16                 ; LSB of REGIDS0
  DEFB 72                 ; LSB of REGIDS1
  DEFB 112                ; LSB of REGIDS2
  DEFB 152                ; LSB of REGIDS3
  DEFB 192                ; LSB of REGIDS4
  DEFB 232                ; LSB of REGIDS5
; Each of the six tables that follow corresponds to a range of y-coordinates in
; the play area. Each 4-byte entry in those tables corresponds to a range of
; x-coordinates;
;
; +------+------------------------------------------------------+
; | Byte | Meaning                                              |
; +------+------------------------------------------------------+
; | 1    | x-coordinate upper bound                             |
; | 2    | Location identifier                                  |
; | 3    | x-coordinate of the top of the staircase going down  |
; | 4    | x-coordinate of the bottom of the staircase going up |
; +------+------------------------------------------------------+
;
; The first table corresponds to y-coordinates 32 and 33 (shops and doorsteps).
REGIDS0;
  DEFB 7,20,0,0           ; 0<=x<=6; Left-hand shop under the apartments next
                          ; to no. 74
  DEFB 15,80,12,12        ; 7<=x<=14; Stairwell of the apartment building next
                          ; to no. 74
  DEFB 23,36,16,16        ; 15<=x<=22; Right-hand shop under the apartments
                          ; next to no. 74
  DEFB 55,128,43,43       ; 23<=x<=54; No. 74
  DEFB 103,144,77,77      ; 55<=x<=102; Hotel
  DEFB 119,160,115,115    ; 103<=x<=118; No. 31
  DEFB 151,96,138,138     ; 119<=x<=150; Police station
  DEFB 159,112,156,156    ; 151<=x<=158; No. 27
  DEFB 207,240,196,196    ; 159<=x<=206; Apartment building next to no. 19
  DEFB 223,176,211,211    ; 207<=x<=222; No. 19
  DEFB 231,52,224,224     ; 223<=x<=230; Shop under no. 17
  DEFB 239,192,236,236    ; 231<=x<=238; No. 17 (door)
  DEFB 247,68,240,240     ; 239<=x<=246; Shop under no. 15
  DEFB 255,224,252,252    ; 247<=x<=254; No. 15 (door)
; The next table corresponds to y-coordinates 26-31 (first floor).
REGIDS1;
  DEFB 23,84,12,13        ; 0<=x<=22; Apartment building next to no. 74
  DEFB 55,132,43,43       ; 23<=x<=54; No. 74
  DEFB 103,148,76,77      ; 55<=x<=102; Hotel
  DEFB 119,164,115,115    ; 103<=x<=118; No. 31
  DEFB 150,100,138,137    ; 119<=x<=149; Police station
  DEFB 159,116,156,155    ; 150<=x<=158; No. 27
  DEFB 207,244,196,197    ; 159<=x<=206; Apartment building next to no. 19
  DEFB 223,180,211,211    ; 207<=x<=222; No. 19
  DEFB 239,196,236,235    ; 223<=x<=238; No. 17
  DEFB 255,228,252,251    ; 238<=x<=254; No. 15
; The next table corresponds to y-coordinates 20-25 (second floor).
REGIDS2;
  DEFB 23,86,11,13        ; 0<=x<=22; Apartment building next to no. 74
  DEFB 55,134,43,42       ; 23<=x<=54; No. 74
  DEFB 103,150,81,89      ; 55<=x<=102; Hotel
  DEFB 119,166,115,114    ; 103<=x<=118; No. 31
  DEFB 150,102,137,137    ; 119<=x<=149; Police station
  DEFB 159,118,153,154    ; 150<=x<=158; No. 27
  DEFB 207,246,195,197    ; 159<=x<=206; Apartment building next to no. 19
  DEFB 223,182,211,210    ; 207<=x<=222; No. 19
  DEFB 239,198,233,234    ; 223<=x<=238; No. 17
  DEFB 255,230,249,250    ; 238<=x<=254; No. 15
; The next table corresponds to y-coordinates 14-19 (third floor).
REGIDS3;
  DEFB 23,88,11,13        ; 0<=x<=22; Apartment building next to no. 74 (third
                          ; floor)
  DEFB 55,136,44,44       ; 23<=x<=54; No. 74 (third floor)
  DEFB 103,152,88,68      ; 55<=x<=102; Hotel (third floor)
  DEFB 119,168,116,116    ; 103<=x<=118; No. 31 (top floor)
  DEFB 150,104,137,137    ; 119<=x<=149; Police station (third floor)
  DEFB 159,120,156,155    ; 150<=x<=158; No. 27 (third floor)
  DEFB 207,248,195,197    ; 159<=x<=206; Apartment building next to no. 19
                          ; (third floor)
  DEFB 223,184,212,212    ; 207<=x<=222; No. 19 (top floor)
  DEFB 239,200,236,235    ; 223<=x<=238; No. 17 (third floor)
  DEFB 255,232,252,251    ; 238<=x<=254; No. 15 (third floor)
; The next table corresponds to y-coordinates 8-13.
REGIDS4;
  DEFB 39,90,11,13        ; 0<=x<=38; Apartment building next to no. 74 (top
                          ; floor), through the catwalk, into the room at the
                          ; top left of no. 74
  DEFB 55,138,42,56       ; 39<=x<=54; No. 74 (top floor, right-hand side)
  DEFB 103,154,69,89      ; 55<=x<=102; Hotel (fourth floor)
  DEFB 119,170,114,116    ; 103<=x<=118; No. 31 (roof)
  DEFB 150,106,137,137    ; 119<=x<=149; Police station (top floor)
  DEFB 159,122,153,154    ; 150<=x<=158; No. 27 (top floor)
  DEFB 207,250,195,197    ; 159<=x<=206; Apartment building next to no. 19 (top
                          ; floor)
  DEFB 223,186,210,225    ; 207<=x<=222; No. 19 (roof)
  DEFB 239,202,233,234    ; 223<=x<=238; No. 17 (top floor)
  DEFB 255,234,249,250    ; 238<=x<=254; No. 15 (top floor)
; The next table corresponds to y-coordinates 2-7.
REGIDS5;
  DEFB 23,92,11,20        ; 0<=x<=22; Apartment building next to no. 74 (roof)
  DEFB 103,156,88,157     ; 23<=x<=102; No. 74 (roof) and hotel (top floor)
  DEFB 150,108,137,147    ; 103<=x<=149; Police station (roof)
  DEFB 159,124,156,151    ; 150<=x<=158; No. 27 (roof)
  DEFB 207,252,195,182    ; 159<=x<=206; Apartment building next to no. 19
                          ; (roof)
  DEFB 255,204,236,226    ; 207<=x<=254; No. 17 (roof) and no. 15 (roof)

; Perform various main loop tasks
;
; Called from the main loop at MAINLOOP. Closes any doors that need closing,
; decrements and checks the blown fuse delay counters, updates the on-screen
; message if necessary, and increments the score and decrements Sam's cash
; supply at regular intervals.
MNLPTASKS1;
  LD HL,TASKTIMER         ; The main loop task timer is at TASKTIMER
  DEC (HL)                ; Decrement it
  LD A,(HL)               ; Pick up the new value
  AND 7                   ; Is the value 0 mod 8?
  JP Z,SHUTDOORS          ; If so, close any doors that need closing
  CP 4                    ; Is the value 4 mod 8?
  JP Z,CHKFUSES           ; If so, decrement and check the blown fuse delay
                          ; counters
  CP 2                    ; Is the value 2 mod 8?
  JP Z,QUEUEMSG_3         ; If so, update the on-screen message if necessary
  CP 6                    ; Is the value 6 mod 8?
  JP Z,SCORECASH          ; If so, increment the score and decrement Sam's cash
                          ; supply at regular intervals
  RET

; Unused
  DEFS 17

; Main loop
MAINLOOP;
  CALL MNLPTASKS1         ; Close any doors that need closing, decrement and
                          ; check the blown fuse delay counters, update the
                          ; on-screen message if necessary, and increment the
                          ; score and decrement Sam's cash supply at regular
                          ; intervals
  CALL MNLPTASKS2         ; Update the icon panel, draw the bullets, and scan
                          ; the event table at EVENT01
  CALL MVCHARS            ; Move the characters
  LD A,(STATUS)           ; Pick up Sam's status flags from STATUS
  AND A                   ; Is Sam in the middle of an action?
  JR Z,MAINLOOP_1         ; Jump if not
  CALL HANDLESAM          ; Otherwise deal with Sam
  JR NZ,MAINLOOP_3        ; Jump if Sam has not finished the action yet
; This entry point is used by the routines at PREPMODE and ENDCSCENE.
MAINLOOP_0;
  LD HL,5                 ; Reset Sam's main action timer and
  LD (58888),HL           ; midstride/mid-action timer (in bytes 8 and 9 of his
                          ; buffer) to 5 and 0 now that he's finished the
                          ; action
MAINLOOP_1;
  LD HL,58889             ; Collect Sam's midstride/mid-action timer from byte
  LD A,(HL)               ; 9 of his buffer
  AND A                   ; Is Sam midstride or in the middle of a short action
                          ; at the moment?
  JR NZ,MAINLOOP_2        ; Jump if so
  DEC L                   ; Point HL at Sam's main action timer in byte 8 of
                          ; his buffer
  DEC (HL)                ; Decrement it
  JR NZ,MAINLOOP_3        ; Jump unless it's time to check the keyboard
  LD (HL),2               ; Reset Sam's main action timer to 2
  CALL GETINPUT           ; Check for keypresses
  JR Z,MAINLOOP_3         ; Jump if there haven't been any
  LD (KEYCODE),A          ; Store the offset of the last keypress in KEYCODE
  LD H,237                ; Point HL at the appropriate entry in the table of
  LD L,A                  ; keypress handling routines at K_UPF
  LD DE,MAINLOOP_3        ; Push the address MAINLOOP_3 (see below) onto the
  PUSH DE                 ; stack so we return there after dealing with the
                          ; keypress
  LD B,(HL)               ; Copy the address of the routine for dealing with
  DEC L                   ; the keypress into BC
  LD C,(HL)               ;
  PUSH BC                 ; Push this address onto the stack
  LD HL,SAMCBUF           ; Point HL at byte 0 of Sam's buffer
  RET                     ; Make an indirect jump to the relevant
                          ; keypress-handling routine, and then return to
                          ; MAINLOOP_3
; Sam is midstride or in the middle of a short action (which involves raising
; his arm or bending his knees) at the moment.
MAINLOOP_2;
  DEC (HL)                ; Decrement Sam's midstride/mid-action timer in byte
                          ; 9 of his buffer
  CALL Z,MVSAM            ; If it's now zero, move Sam from the
                          ; midstride/mid-action position, update the SRB, and
                          ; scroll the screen if necessary
; Now that Sam's movements have been dealt with, the main loop continues.
MAINLOOP_3;
  CALL UPDATESCR          ; Update the display
; This next section of code ensures that we don't pass through the main loop
; more than once every 1/50th of a second.
  LD HL,LFRAMES           ; HL=LFRAMES (which holds the LSB of the system
                          ; variable FRAMES as it was when the last pass
                          ; through the main loop was completed)
MAINLOOP_4;
  LD A,(23672)            ; A=LSB of the system variable FRAMES, which is
                          ; incremented every 1/50th of a second
  SUB (HL)                ; Now A=0 if FRAMES hasn't been incremented since the
                          ; last pass through the main loop
  CP 1                    ; Was FRAMES incremented?
  JR C,MAINLOOP_4         ; Jump back if not to check again
  ADD A,(HL)              ; Store the current value of the LSB of FRAMES at
  LD (HL),A               ; LFRAMES
  JR MAINLOOP             ; Jump back to the start of the main loop

; Unused
  DEFB 0

; Update the icon panel, draw the bullets, and scan the event table
;
; Called from the main loop at MAINLOOP. Updates the icon panel, draws the
; bullets, scans the event table at EVENT01 for events to trigger, and checks
; whether Sam has found the hook, the budgie, a key, some money, or a location
; that requires a message to be displayed.
MNLPTASKS2;
  CALL ICONPANEL1         ; Show or hide the fuse, door, light bulb or phone in
                          ; the icon panel
  LD A,(GAMEMODE)         ; A=current game mode (0-4)
  AND A                   ; Is it demo mode?
  RET Z                   ; Return if so
  CALL MVBULLETS          ; Move and draw the bullets
  LD A,(STATUS)           ; Collect Sam's status flags from STATUS
  AND 129                 ; Is Sam being carried or falling from a building?
  RET NZ                  ; Return if so
  CALL EVENTS             ; Scan the event table at EVENT01 for events to
                          ; trigger
  LD A,(SAMCBUF)          ; A=Sam's animatory state
  AND 29                  ; Is Sam's animation phase standing/walking phase 1
                          ; or 3?
  RET NZ                  ; Return if not
  JP FOUNDOBJ             ; Check whether Sam has found something and update
                          ; the icon panel

; Unused
  DEFS 3

; Start (continued)
;
; After the game has loaded, the startup routine copies 512 bytes of message
; data from the top and bottom lines of the display file to MSG063 onwards,
; pushes ENDCSCENE_2 onto the stack, and then jumps here.
;
; BC 512
; DE 32768
; HL 32256
PREP128;
  LDIR                    ; Copy 32256-32767 to 32768-33279 (overwriting the
                          ; startup routine)
  RET                     ; To ENDCSCENE_2

; Populate addresses 32256-32767 (unused)
  LD DE,MIRROR
  LD BC,512
  LDIR
  RET

; Start the game (unused)
XSETSP;
  LD (61619),HL           ; Set the operand of the 'LD SP' instruction at
                          ; XRETBASIC
  JP ENDCSCENE_2          ; Prepare the bottom 4 lines of the screen and enter
                          ; demo mode

; Return to BASIC (unused)
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF, but it is not bound to any key. Perhaps it was used to
; return to BASIC while the game was in development.
XRETBASIC;
  LD SP,29965             ; The operand of this instruction is set by the
                          ; unused routine at XSETSP
  EXX
  POP DE                  ; Restore the values of the DE', BC' and HL'
  POP BC                  ; registers
  POP HL                  ;
  EXX
  POP BC                  ; Restore the values of the DE, BC and HL registers
  POP DE                  ;
  POP HL                  ;
  RET

; End a cutscene
;
; Used by the routine at CUTSCENE. Ends the cutscene by entering demo mode or
; resuming the game in the next mode.
ENDCSCENE;
  CALL READKEY            ; Check the keyboard (to flush any recent keypress)
  LD HL,(BUCKS)           ; BUCKS holds the number of bucks Sam has left
  LD A,H                  ; Has Sam's cash supply run out?
  OR L                    ;
  JR Z,ENDCSCENE_1        ; Jump if so
  LD HL,32607             ; Set every bit of the screen refresh buffer so that
ENDCSCENE_0;
  LD (HL),255             ; the entire display will be updated
  DEC L                   ;
  JR NZ,ENDCSCENE_0       ;
  JP UPDATESCR            ; Update the display
; Sam is out of money, so it must be the end of the game. Time to check for a
; new high score and enter demo mode.
ENDCSCENE_1;
  LD HL,(HISCORE)         ; Collect the old high score from HISCORE
  LD DE,(SCORE)           ; Collect the score from SCORE
  SBC HL,DE               ; Do we have a new high score?
  JR NC,ENDCSCENE_3       ; Jump if not
  LD (HISCORE),DE         ; Otherwise set the new high score
  JR ENDCSCENE_3          ; Jump forward to enter demo mode
; This entry point is used by the routine at PREP128 and by the unused routine
; at XSETSP.
ENDCSCENE_2;
  CALL 56576              ; This startup routine prepares the bottom 4 lines of
                          ; the screen just after the game has loaded
ENDCSCENE_3;
  XOR A                   ; A=0 (demo mode)
  JR ENDCSCENE_5
; This entry point is used by the routine at GETINPUT to start a new game.
ENDCSCENE_4;
  LD A,1                  ; A=1 (new game)
ENDCSCENE_5;
  LD (T_GAMEMODE),A       ; Store the game mode (0 or 1) at T_GAMEMODE, from
                          ; where it will be copied to GAMEMODE
  LD SP,23898             ; Reset the stack pointer
  NOP
  CALL PREPGAME           ; Prepare for demo mode or a new game
  JP MAINLOOP_0           ; Enter the main loop

; Unused
  DEFS 7

; Open or close a door and update the screen refresh buffer
;
; Used by the routines at SHUTDOORS and OPENDOOR. Updates the play area
; graphics for the door being opened or closed, and updates the screen refresh
; buffer (SRB) accordingly.
;
; HL Address of the door status flags (see DOORFLAGS)
MOVEDOOR;
  LD A,L                  ; A=240-249
  SUB 58                  ; A=182-191
  LD L,A                  ; Point HL at the relevant entry in the door
  LD H,255                ; locations table at DOORSEGX
  LD A,(HL)               ; Pick up the entry from the door locations table
  AND 248                 ; Discard bits 0-2 of the x-coordinate
  LD E,A                  ; Copy the result to E
  RRCA                    ; Now divide the result by 8
  RRCA                    ;
  RRCA                    ;
  LD L,A                  ; Point HL at the entry in the table of Z values at
  LD H,189                ; ZVALUES1 that corresponds to the door
  LD A,(HL)               ; Flip bit 2 of the Z value for y-coordinates 30-35
  XOR 4                   ; (set=closed, reset=open)
  LD (HL),A               ;
  AND 3                   ; Set the zero flag if this is a shop door
  LD BC,8764              ; B=34 (y-coordinate of the base of a house door),
                          ; C=60 (00111100)
  JR NZ,MOVEDOOR_0        ; Jump unless this is a shop door
  LD BC,9408              ; B=36 (y-coordinate of the base of a shop door),
                          ; C=192 (11000000)
  INC H                   ; Point HL at the entry in the table of Z values at
                          ; ZVALUES0 that corresponds to the door
  LD A,(HL)               ; Flip bits 2, 3 and 4 of the Z value for
  XOR 28                  ; y-coordinates 36-41
  LD (HL),A               ;
; This entry point is used by the routine at TOGGLEROPE with B=10 (y-coordinate
; of the rope), C=255 (11111111), and E=208 or 216.
MOVEDOOR_0;
  LD HL,LEFTCOL           ; LEFTCOL holds X, the x-coordinate of the leftmost
                          ; column of the play area on screen
  LD A,E                  ; A=x-coordinate of the door or rope (rounded down to
                          ; the nearest multiple of 8)
  SUB (HL)                ; Subtract X
  RRCA                    ; Divide the result by 8
  RRCA                    ;
  RRCA                    ;
  CP 4                    ; Is the door or rope off-screen to the left or
                          ; right?
  RET NC                  ; Return if so
  LD E,A                  ; E=0, 1, 2 or 3, denoting the 8-tile wide column of
                          ; the screen that contains the door or rope
  INC L                   ; HL=TOPROW, which holds Y, the y-coordinate of the
                          ; topmost row of the play area on screen
  LD A,B                  ; A=10 (y-coordinate of the rope), 34 or 36
                          ; (y-coordinate of the base of the door)
  LD B,6                  ; Doors are at most 6 tiles high
  SUB (HL)                ; Subtract Y from the y-coordinate of the rope or
                          ; base of the door
  ADD A,A                 ; Multiply by 4
  ADD A,A                 ;
  ADD A,E                 ; Add E (0-3)
MOVEDOOR_1;
  LD L,A                  ; Point HL at a byte of the screen refresh buffer
                          ; (SRB)
  CP 96                   ; Is this part of the door below the visible portion
                          ; of the play area?
  RET NC                  ; Return if so
  LD A,(HL)               ; Set the appropriate bits in the SRB byte for the
  OR C                    ; rope or door
  LD (HL),A               ;
  LD A,L                  ; Compute the LSB of the address of the next SRB byte
  ADD A,4                 ;
  DJNZ MOVEDOOR_1         ; Jump back to check whether this SRB byte needs
                          ; updating
  RET

; Close any doors that need closing
;
; Used by the routine at MNLPTASKS1. Periodically checks whether any open doors
; need closing, and closes them.
;
; HL TASKTIMER (main loop task timer)
SHUTDOORS;
  LD A,(HL)               ; Collect the current value of the main loop task
                          ; timer from TASKTIMER
  AND 15                  ; Is it time to close any currently open doors?
  RET NZ                  ; Return if not
  LD L,250                ; HL will be used to index the door status flags at
                          ; DOORFLAGS
SHUTDOORS_0;
  DEC L                   ; Point HL at the status flags for the next door
  BIT 4,L                 ; Have we checked every door yet?
  RET Z                   ; Return if so
  LD A,(HL)               ; Pick up the status flags for this door
  AND 7                   ; Is the door currently closed?
  JR Z,SHUTDOORS_0        ; If so, jump back to check the next door
  DEC (HL)                ; Decrement the door close delay timer in bits 0-2 of
                          ; the status flags
  DEC A                   ; Is it time to close the door?
  JR NZ,SHUTDOORS_0       ; If not, jump back to check the next door
  PUSH HL                 ; Save the door status flags pointer
  CALL MOVEDOOR           ; Close the door and update the screen refresh buffer
  POP HL                  ; Restore the door status flags pointer to HL
  JR SHUTDOORS_0          ; Jump back to check the next door

; Unused
  DEFB 0

; Collect one byte from a command list
;
; Used by the routine at GETPARAMS. Collects a byte from a character's current
; command list and returns it in A.
;
; H Character number (215-229)
GETPARAM;
  PUSH HL                 ; Save the character number
  PUSH DE
  LD L,22                 ; Byte 22 of the character's buffer holds the offset
                          ; of the point reached in the command list (relative
                          ; to the start)
  LD E,(HL)               ; Pick up this offset in E
  INC (HL)                ; Increment the offset
  INC L                   ; Collect the start address of the command list from
  LD A,(HL)               ; bytes 23 and 24 of the character's buffer into HL
  INC L                   ;
  LD H,(HL)               ;
  LD L,A                  ;
  LD D,0                  ; DE=offset
  ADD HL,DE               ; Point HL at the byte to collect from the command
                          ; list
  LD A,(HL)               ; Pick up the byte
  POP DE
  POP HL                  ; Restore the character number to H
  RET

; Copy two bytes from a command list into a character's buffer
;
; Used by the routines at AWAITSAM, GETDEST, MVCHARS and DOORDUTY. Copies two
; bytes from a character's current command list into his buffer. Returns with
; HL pointing at the second byte of the pair in the character's buffer.
;
; H Character number (215-229)
; L Destination for the copied bytes
GETPARAMS;
  LD A,2                  ; Two bytes will be copied
GETPARAMS_0;
  PUSH AF                 ; Save the byte counter
  CALL GETPARAM           ; Collect one byte from the character's command list
  LD (HL),A               ; Copy it to the character's buffer
  POP AF                  ; Restore the byte counter to A
  INC L                   ; Point HL at the destination for the second byte
  DEC A                   ; Have we copied both bytes yet?
  JR NZ,GETPARAMS_0       ; Jump back to copy the second one if not
  DEC L                   ; Point HL at the second byte that was copied
  RET

; Get a random number
;
; Used by the routines at ADDRBUCKS, MVSNIPER2, MVSNIPER1, MVBANKNOTE,
; UPDSNIPER, GETMSGNUM, MVCOP2, PHONEMSG, GETINPUT, FREESAM, LSWITCH1, WALK,
; DOORDUTY, MVCAT, KNOCKED1 and ROOFEDGE. Returns with a random number in A.
GETRANDOM;
  PUSH HL
  LD HL,(RANDSEED)        ; Collect the random number seed from RANDSEED
  INC HL                  ; Add 257 to it
  INC H                   ;
  LD (RANDSEED),HL        ; Store the new seed
  LD A,(23672)            ; Collect the LSB of the system variable FRAMES,
                          ; which is incremented every 20ms
  XOR (HL)                ; A=random number
  POP HL
  RET

; Cycle a character buffer group forwards and scroll the screen right 8 columns
;
; Used by the routines at PREPCSCENE and MVSAM. Cycles one of the character
; buffer groups in pages 215-221 forwards depending on the current leftmost
; column of the play area that is on screen (X=(LEFTCOL));
;
; +-------------------+------------------------+
; | X                 | Character buffer group |
; +-------------------+------------------------+
; | 8, 64, 120, 176   | 215                    |
; | 16, 72, 128, 184  | 216                    |
; | 24, 80, 136, 192  | 217                    |
; | 32, 88, 144, 200  | 218                    |
; | 40, 96, 152, 208  | 219                    |
; | 48, 104, 160, 216 | 220                    |
; | 56, 112, 168, 224 | 221                    |
; +-------------------+------------------------+
CBUFGFWD;
  LD A,(LEFTCOL)          ; LEFTCOL holds X, the x-coordinate of the leftmost
                          ; column of the play area on screen
  SUB 8                   ; A=0, 8, 16, 24, 32, 40 or 48 (depending on the
CBUFGFWD_0;
  SUB 56                  ; value of X)
  JR NC,CBUFGFWD_0        ;
  ADD A,56                ;
  RRCA                    ; A=215-221
  RRCA                    ;
  RRCA                    ;
  ADD A,215               ;
  LD H,A                  ; Point HL at the last byte of the last buffer in the
  LD L,124                ; group
  LD DE,32632             ; Copy the last buffer in the group (buffer 5) to
  LD BC,25                ; MSGBUFFER temporarily
  LDDR                    ;
  LD E,124                ; Point DE at the last byte of the last buffer in the
  LD D,H                  ; group
  LD C,100                ; Move buffers 1-4 up into slots 2-5 (thus
  LDDR                    ; overwriting buffer 5)
  LD HL,32632             ; Copy buffer 5 from its temporary storage location
  LD C,25                 ; into slot 1
  LDDR                    ;
CBUFGFWD_S;
  JP RSCROLL8             ; Scroll the screen right 8 columns (the routine at
                          ; PREPCSCENE replaces this instruction with a RET)

; Cycle a character buffer group backwards and scroll the screen left 8 columns
;
; Used by the routines at PREPCSCENE and MVSAM. Cycles one of the character
; buffer groups in pages 215-221 backwards depending on the current leftmost
; column of the play area that is on screen (X=(LEFTCOL));
;
; +-------------------+------------------------+
; | X                 | Character buffer group |
; +-------------------+------------------------+
; | 0, 56, 112, 168   | 215                    |
; | 8, 64, 120, 176   | 216                    |
; | 16, 72, 128, 184  | 217                    |
; | 24, 80, 136, 192  | 218                    |
; | 32, 88, 144, 200  | 219                    |
; | 40, 96, 152, 208  | 220                    |
; | 48, 104, 160, 216 | 221                    |
; +-------------------+------------------------+
CBUFGREV;
  LD A,(LEFTCOL)          ; LEFTCOL holds X, the x-coordinate of the leftmost
                          ; column of the play area on screen
CBUFGREV_0;
  SUB 56                  ; A=0, 8, 16, 24, 32, 40 or 48 (depending on the
  JR NC,CBUFGREV_0        ; value of X)
  ADD A,56                ;
  RRCA                    ; A=215-221
  RRCA                    ;
  RRCA                    ;
  ADD A,215               ;
  LD H,A                  ; Point HL at the first byte of the first buffer in
  LD L,0                  ; the group
  LD DE,MSGBUFFER         ; Copy the first buffer in the group (buffer 1) to
  LD BC,25                ; MSGBUFFER temporarily
  LDIR                    ;
  LD E,B                  ; Point DE at the first byte of the first buffer in
  LD D,H                  ; the group
  LD C,100                ; Move buffers 2-5 down into slots 1-4 (thus
  LDIR                    ; overwriting buffer 1)
  LD HL,MSGBUFFER         ; Copy buffer 1 from its temporary storage location
  LD C,25                 ; into slot 5
  LDIR                    ;
CBUFGREV_S;
  JP LSCROLL8             ; Scroll the screen left 8 columns (the routine at
                          ; PREPCSCENE replaces this instruction with a RET)

; Check for keypresses when Sam is on the phone
;
; Used by the routines at GIVENAME and ONPHONE. Returns with the zero flag set
; if no key with an ASCII code in the range 48-127 has been pressed. Otherwise
; returns with the ASCII code of the last keypress (converted to lower case) in
; A, or hangs up if 'h' was pressed.
PHONEKEY;
  LD HL,58888             ; Reset Sam's main action timer (in byte 8 of his
  LD (HL),4               ; buffer) to 4
  CALL READKEY            ; Collect the ASCII code of the last key pressed in A
  RET Z                   ; Return if no key with an ASCII code in the range
                          ; 48-127 was pressed
  SET 5,A                 ; Convert the ASCII code to lower case
  CP 104                  ; Was 'h' (hang up) pressed?
  RET NZ                  ; Return if not
  POP BC                  ; Drop the return address from the stack
  XOR A                   ; A=0
  LD (STATUS),A           ; Clear all of Sam's status flags at STATUS
  LD (OPHONEID),A         ; Clear the ID of the phone that Sam is calling at
                          ; OPHONEID
  JP PHONE_4              ; Make a sound effect

; Move the characters
;
; Called from the main loop at MAINLOOP.
MVCHARS;
  LD HL,FUSECTRS          ; The blown fuse delay counters are stored at
                          ; FUSECTRS
  LD B,5                  ; Set A to a non-zero value if any of the fuses are
  LD A,(HL)               ; currently blown
MVCHARS_0;
  INC L                   ;
  OR (HL)                 ;
  DJNZ MVCHARS_0          ;
  LD (BLOWNFUSE),A        ; Store this value at BLOWNFUSE
  CALL MVCHARS_1          ; Move one character
  CALL MVCHARS_1          ; Move the next character
MVCHARS_1;
  LD HL,LASTCHAR          ; LASTCHAR holds the number of the character just
                          ; moved
  INC (HL)                ; Increment this
  LD A,(HL)               ; A=number of the character to move next
  CP 230                  ; Is it Sam?
  JR NZ,MVCHARS_2         ; Jump if not
  LD A,215                ; Rewind to character 215 (we don't want to move Sam)
  LD (HL),A               ; Store the number of the character to be moved next
MVCHARS_2;
  LD H,A                  ; H=number of the character to move next (215-229)
; First check whether the character is immobilised by a blown fuse.
  LD A,(BLOWNFUSE)        ; Collect the blown fuse indicator from BLOWNFUSE
  AND A                   ; Are any fuses currently blown?
  CALL NZ,FROZEN          ; If so, check to see whether the character is
                          ; immobilised by a blown fuse
  RET C                   ; Return if the character is immobilised
; Now to determine whether to move the character this time round. The answer
; will be yes if bit 7 of byte 3 of the character's buffer is set (indicating
; that he is running), or if bit 6 of byte 3 (which is flipped on each pass
; through this routine) is set.
  LD L,3                  ; Point HL at byte 3 of the character's buffer
  BIT 7,(HL)              ; Is the character running?
  JR NZ,MVCHARS_3         ; Jump if so
  LD A,(HL)               ; Flip bit 6 of byte 3 of the character's buffer
  XOR 64                  ;
  LD (HL),A               ;
  AND 64                  ; Is bit 6 set now?
  RET Z                   ; Return if not
; The character will be moved. From this point, the following steps are taken;
;
; +------+--------------------------------------------------------------------+
; | Step | Action                                                             |
; +------+--------------------------------------------------------------------+
; | 1    | If there is an uninterruptible subcommand routine address in bytes |
; |      | 18 and 19 of the character's buffer, jump to it                    |
; | 2    | If there is a continual subcommand routine address in bytes 27 and |
; |      | 28 of the character's buffer - which there never is - call it (and |
; |      | then return to step 3)                                             |
; | 3    | If there is an interruptible subcommand routine address in bytes   |
; |      | 14 and 15 of the character's buffer, jump to it                    |
; | 4    | Restart the command list if bit 4 of byte 3 of the character's     |
; |      | buffer is set (and carry on to step 5)                             |
; | 5    | If there is a primary command routine address in bytes 8 and 9 of  |
; |      | the character's buffer, jump to it                                 |
; | 6    | Remove any continual subcommand routine address from bytes 27 and  |
; |      | 28 of the character's buffer                                       |
; | 7    | Collect the next primary command routine address from the command  |
; |      | list, place it into bytes 8 and 9 of the character's buffer, and   |
; |      | jump to it                                                         |
; +------+--------------------------------------------------------------------+
;
; The address of one of the following uninterruptible subcommand routines (or
; an entry point thereof) may be present in bytes 18 and 19 of the character's
; buffer;
;
; +----------+----------------------------------------------------------------+
; | Address  | Description                                                    |
; +----------+----------------------------------------------------------------+
; | MVHOOK   | Control the hook while it's flying                             |
; | KNOCKED1 | Deal with a character who has been knocked over                |
; | KNOCKED2 | Deal with a character who has nearly recovered from being      |
; |          | knocked over                                                   |
; | OFFROOF  | Control a character who has stepped off the roof of a building |
; +----------+----------------------------------------------------------------+
;
; The address of one of the following interruptible subcommand routines (or an
; entry point thereof) may be present in bytes 14 and 15 of the character's
; buffer;
;
; +------------+--------------------------------------------------------------+
; | Address    | Description                                                  |
; +------------+--------------------------------------------------------------+
; | MVSNIPER2  | Control the sniper while active                              |
; | HOODWALK   | Make a gangster walk up or down until Sam arrives            |
; | BYDOOR1    | Control a character who is knocking on or opening a door (1) |
; | DOORWAIT   | Control a character who has knocked on a door and is waiting |
; |            | for an answer                                                |
; | BYDOOR3    | Control a character who is knocking on or opening a door (3) |
; | UPDOWNSC   | Guide a character up or down staircases                      |
; | WALKFLOOR  | Guide a character across a floor to his destination          |
; | WALKSTREET | Guide a character from one spot on the sidewalk or road to   |
; |            | another                                                      |
; | WALK       | Make a character walk up or down                             |
; | CATRUN     | Make a cat run up or down                                    |
; +------------+--------------------------------------------------------------+
;
; The address of one of the following primary command routines (or an entry
; point thereof) may be present in bytes 8 and 9 of the character's buffer;
;
; +------------+--------------------------------------------------------------+
; | Address    | Description                                                  |
; +------------+--------------------------------------------------------------+
; | RESETHOOD  | Reset a gangster's location and restart the command list     |
; | WAITFORSAM | Make the gangster at no. 15 lie in wait for Sam              |
; | MVSNIPER1  | Control the sniper                                           |
; | HOODTOSAM1 | Make a gangster chase Sam                                    |
; | MVBANKNOTE | Control a banknote                                           |
; | MVCOP1     | Control a policeman (1)                                      |
; | MVCOP2     | Control a policeman (2)                                      |
; | AWAITSAM   | Make a gangster walk up and down while watching for Sam      |
; | FREESAM    | Let Sam out of jail if necessary                             |
; | DONOWT     | Do nothing                                                   |
; | GOTO       | Make a character go to a location                            |
; | RESTART    | Restart the command list                                     |
; | DROPSAM    | Make a character drop Sam                                    |
; | DOORDUTY   | Make a character walk up and down until somebody knocks on a |
; |            | door                                                         |
; | ANSWERDOOR | Make a character open a door that has been knocked on        |
; | WALKABOUT  | Make a character walk up and down for a while                |
; | MVCAT      | Control a cat                                                |
; +------------+--------------------------------------------------------------+
MVCHARS_3;
  LD L,19                 ; Is there an uninterruptible subcommand routine
  LD A,(HL)               ; address in bytes 18 and 19 of the character's
  AND A                   ; buffer?
  JR NZ,MVCHARS_8         ; Jump if so
  LD A,H                  ; A=number of the character being moved (215-229)
  CP 222                  ; Does the character belong to one of the character
                          ; groups 215-221?
  JR C,MVCHARS_4          ; Jump if so
; We're dealing with one of the primary characters (222-229). Here we check
; whether there is a continual subcommand routine address in bytes 27 and 28 of
; the character's buffer. The answer is always no.
  LD L,28                 ; Byte 28 is unused and always holds 0
  LD A,(HL)               ;
  AND A                   ;
  JR Z,MVCHARS_4          ; This jump is always made
  PUSH HL                 ; Save the character number
  LD BC,DONECS            ; We will return to DONECS (below) after calling the
  PUSH BC                 ; subcommand routine
  LD B,A                  ; Collect the continual subcommand routine address
  DEC L                   ; into BC
  LD C,(HL)               ;
  PUSH BC                 ; Push it onto the stack
  RET                     ; Call the continual subcommand routine and then
                          ; return to DONECS (below)
DONECS;
  POP HL                  ; Restore the character number to H
; This entry point is used by the routine at NEXTCMD.
MVCHARS_4;
  LD L,15                 ; Is there an interruptible subcommand routine
  LD A,(HL)               ; address in bytes 14 and 15 of the character's
  AND A                   ; buffer?
  JR NZ,MVCHARS_8         ; Jump if so
; Bit 4 of byte 3 of the character's buffer is never set, but if it were, it
; would mean that the character's command list should be restarted. Check bit 4
; of byte 3 now.
  LD L,3                  ; Bit 4 of byte 3 is unused and always reset
  BIT 4,(HL)              ;
  JR Z,MVCHARS_5          ; This jump is always made
  RES 4,(HL)              ; Reset bit 4 of byte 3
  LD L,26                 ; Copy the command list address from bytes 25 and 26
  LD D,H                  ; of the character's buffer into bytes 23 and 24
  LD E,24                 ;
  LDD                     ;
  LDD                     ;
  LD (DE),A               ; Set byte 22 of the character's buffer (which holds
                          ; the offset reached in the command list) to 0
  JR MVCHARS_6
; Now we look for a primary command routine address.
MVCHARS_5;
  LD L,9                  ; Is there a primary command routine address in bytes
  LD A,(HL)               ; 8 and 9 of the character's buffer?
  AND A                   ;
  JR NZ,MVCHARS_8         ; Jump if so
MVCHARS_6;
  LD A,H                  ; A=number of the character being moved (215-229)
  CP 222                  ; Does the character belong to one of the character
                          ; groups 215-221?
  JR C,MVCHARS_7          ; Jump if so
  LD L,28                 ; Remove any continual subcommand routine address
  LD (HL),0               ; from bytes 27 and 28 of the character's buffer
MVCHARS_7;
  LD L,8                  ; Copy the next primary command routine address from
  CALL GETPARAMS          ; the command list into bytes 8 and 9 of the
                          ; character's buffer
MVCHARS_8;
  LD B,(HL)               ; Copy the address of the primary command or
  DEC L                   ; subcommand routine into BC
  LD C,(HL)               ;
  PUSH BC                 ; Make an indirect jump to the routine
  RET                     ;

; Terminate a command
;
; The main entry point is used by the routines at HOODWALK, GOTO, RESTART,
; DOORDUTY and ANSWERDOOR. Removes the primary command routine address from
; bytes 8 and 9 of the character's buffer, which has the effect of making the
; routine at MVCHARS move immediately to the next command in the command list.
NEXTCMD;
  LD L,9                  ; Byte 9 of the buffer contains the MSB of the
                          ; primary command routine address
  JR NEXTCMD_2            ; Jump forward to replace it with 0
; This entry point is used by the routines at MVSNIPER2, DOORWAIT, BYDOOR3,
; UPDOWNSC, WALKFLOOR, WALK and CATRUN. Removes the interruptible subcommand
; routine address from bytes 14 and 15 of the character's buffer, which has the
; effect of making the routine at MVCHARS immediately hand control of the
; character back to the primary command.
NEXTCMD_0;
  LD L,15                 ; Byte 15 of the buffer contains the MSB of the
                          ; interruptible subcommand routine address
  JR NEXTCMD_2            ; Jump forward to replace it with 0
; This entry point is used by the routines at KNOCKED2 and OFFROOF. Removes the
; uninterruptible subcommand routine address from bytes 18 and 19 of the
; character's buffer, which has the effect of making the routine at MVCHARS
; immediately hand control of the character back to the interruptible
; subcommand or the primary command.
NEXTCMD_1;
  LD L,19                 ; Byte 19 of the buffer contains the MSB of the
                          ; uninterruptible subcommand routine address
NEXTCMD_2;
  LD A,(LASTCHAR)         ; A=number of the character being moved (215-229)
  LD H,A                  ; Zero out the relevant routine address MSB (in byte
  LD (HL),0               ; 9, 15 or 19) in the character's buffer
  JP MVCHARS_4            ; Re-enter the character-moving routine (MVCHARS) at
                          ; the checkpoint for the interruptible subcommand

; Check whether the door that a character is standing next to is closed
;
; Used by the routines at BYDOOR, CANOPEN, SAMBYDOOR, DOORWAIT and BYDOOR3.
; Returns with the zero flag set if the door is closed, and with HL pointing at
; the door status flags.
;
; H Character number (215-230)
CHKDOOR;
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=character's x-coordinate
  LD HL,65461             ; Find the first entry in the door location table at
CHKDOOR_0;
  INC L                   ; DOORSEGX that is greater than the character's
  CP (HL)                 ; x-coordinate
  JR NC,CHKDOOR_0         ;
  LD A,L                  ; A=LSB of the entry (182-191)
  ADD A,58                ; Point HL at one of the 10 door status flag bytes at
  LD L,A                  ; at DOORFLAGS
  LD H,127                ;
  LD A,(HL)               ; Pick up the door status flags
  AND 7                   ; Set the zero flag if the door is closed
  RET

; Unused
  DEFB 0

; Check whether a character can open a door
;
; Used by the routines at SAMBYDOOR and BYDOOR1. Returns with the carry flag
; reset if the door is already open, or the character can open the door (either
; because the door requires no key, or because the character has the key);
; otherwise returns with the carry flag set, and the zero flag set if the
; character has no keys. If the door is closed and requires a key, this routine
; will either open it (if the character has the key), or signal that the door
; was knocked on.
;
; H Character number (215-230)
CANOPEN;
  LD D,H                  ; D=character number
  CALL CHKDOOR            ; Check whether the door is open
  EX DE,HL                ; H=character number
  RET NZ                  ; Return (with the carry flag reset) if the door is
                          ; open
  EX DE,HL                ; Point HL at the door status flags
  LD A,(HL)               ; A=door status flags
  AND A                   ; Does the door require a key to unlock it?
  JR NZ,CANOPEN_1         ; Jump if so
; This entry point is used by the routines at SAMBYDOOR and BYDOOR3.
CANOPEN_0;
  LD A,(HL)               ; Initialise the door close delay timer (in bits 0-2
  ADD A,7                 ; of the door status flags) to 7
  LD (HL),A               ;
  PUSH DE                 ; Save the character number (in D) briefly
  CALL OPENDOOR           ; Open the door
  POP HL                  ; Restore the character number to H
  XOR A                   ; Reset the carry flag
  RET
; The door requires a key to unlock it.
CANOPEN_1;
  LD A,D                  ; A=character number (215-230)
  CP 230                  ; Is this Sam?
  JR NZ,CANOPEN_2         ; Jump if not
  LD A,(KEYINV)           ; Pick up the key inventory flags from KEYINV
  JR CANOPEN_3
CANOPEN_2;
  ADD A,10                ; A=character number + 10 (225-239)
  LD C,A                  ; Point BC at the entry in the table of key ownership
  LD B,242                ; flags at KEYOWNERS that corresponds to this
                          ; character
  LD A,(BC)               ; Pick up the key ownership flags
CANOPEN_3;
  LD C,A                  ; C=character's key ownership flags
  AND (HL)                ; Does the character have the key to this door?
  JR NZ,CANOPEN_0         ; Jump if so
  LD A,L                  ; A=LSB of the door status flag byte (240-249)
  SUB 70                  ; A=170-179
  LD L,A                  ; Point HL at the door knock status flags for the
                          ; door (at KNOCKFLAGS)
  SET 7,(HL)              ; Signal; somebody has knocked on the door
  LD A,C                  ; A=character's key ownership flags
  AND A                   ; Set the zero flag if the character has no keys
  SCF                     ; Signal; the character cannot open the door
  EX DE,HL                ; Restore the character number to H
  RET

; Unused
  DEFS 4

; Key ownership flags
;
; Used by the routine at CANOPEN.
KEYOWNERS;
  DEFB 8                  ; Character 215 (bit 3 set; key to no. 74)
  DEFB 16                 ; Character 216 (bit 4 set; key to no. 31)
  DEFB 8                  ; Character 217 (bit 3 set; key to no. 74)
  DEFB 16                 ; Character 218 (bit 4 set; key to no. 31)
  DEFB 8                  ; Character 219 (bit 3 set; key to no. 74)
  DEFB 16                 ; Character 220 (bit 4 set; key to no. 31)
  DEFB 8                  ; Character 221 (bit 3 set; key to no. 74)
  DEFB 0                  ; Character 222; policeman (no keys)
  DEFB 0                  ; Character 223; policeman (no keys)
  DEFB 248                ; Character 224; gangster (bits 3-7 set; keys to all
                          ; houses)
  DEFB 248                ; Character 225; Fat Man, Lana (bits 3-7 set; keys to
                          ; all houses)
  DEFB 248                ; Character 226; Daisy (bits 3-7 set; keys to all
                          ; houses)
  DEFB 248                ; Character 227; sniper (bits 3-7 set; keys to all
                          ; houses)
  DEFB 248                ; Character 228; banknote (bits 3-7 set; keys to all
                          ; houses)
  DEFB 248                ; Character 229; banknote, hook (bits 3-7 set; keys
                          ; to all houses)

; 'K' pressed - knock on or open a door
;
; The address of this routine is found in the table of keypress handling
; routines at K_UPF. It is called from the main loop at MAINLOOP when 'K' is
; pressed.
;
; H 230 (Sam)
KNOCK;
  LD A,64                 ; Set bit 6 of A
; This entry point is used by the routine at RAISEARM with A=32 (bit 5 set).
KNOCK_0;
  LD (STATUS),A           ; Set the appropriate status flag at STATUS
  LD DE,58885             ; Point DE at byte 5 of Sam's buffer
  LD BC,3                 ; Copy bytes 0-2 of Sam's buffer (which hold his
  LD L,B                  ; current animatory state and location) into bytes
  LDIR                    ; 5-7 for later retrieval
  CALL CHRKNOCK_0         ; Raise Sam's arm
  JP LEFT_1               ; Make a sound effect

; Make Sam raise his arm
;
; Used by the routines at FUSE, LIGHT, BLIND and USEHOOK.
;
; H 230 (Sam)
RAISEARM;
  LD A,32                 ; Set bit 5 of A
  JR KNOCK_0              ; Raise Sam's arm and make a sound effect

; Deal with Sam when he has knocked on or is opening a door
;
; Used by the routine at HANDLESAM when bit 6 at STATUS is set (by the routine
; at KNOCK), indicating that Sam has knocked on or is opening a door.
;
; H 230 (Sam)
SAMBYDOOR;
  XOR A                   ; Clear Sam's status flags at STATUS
  LD (STATUS),A           ;
  PUSH HL                 ; Save Sam's character number (in H) briefly
  CALL LOCDESCS           ; Obtain descriptors for Sam's current location
  POP HL                  ; Restore Sam's character number to H
  CP 4                    ; Is Sam standing behind or in front of a closed
                          ; door?
  JR NZ,SAMBYDOOR_0       ; Jump if not
  LD L,4                  ; Point HL at byte 4 of Sam's buffer
  BIT 0,(HL)              ; Is Sam indoors?
  JR NZ,SAMBYDOOR_1       ; Jump if so
  CALL CANOPEN            ; Open the door if Sam has the key, or signal that he
                          ; has knocked on the door
  JR SAMBYDOOR_0
  EX DE,HL                ; These three instructions are never executed; but if
  SET 5,(HL)              ; the relative jump above were made only when the
  EX DE,HL                ; carry flag is reset (meaning Sam has opened the
                          ; door), these instructions would set bit 5 of the
                          ; door knock status flags for the door (see
                          ; KNOCKFLAGS)
SAMBYDOOR_0;
  JP MVSAM                ; Lower Sam's arm and make a sound effect
; Sam is standing behind a closed door.
SAMBYDOOR_1;
  CALL MVSAM              ; Lower Sam's arm and make a sound effect
  LD H,230                ; 230=Sam
; This entry point is used by the routines at GOTO and ANSWERDOOR.
SAMBYDOOR_2;
  LD D,H                  ; D=character number
  CALL CHKDOOR            ; Check whether the door is open
  EX DE,HL                ; Restore the character number to H
  RET NZ                  ; Return if the door is open
  EX DE,HL                ; Point HL at the door status flags
  JP CANOPEN_0            ; Open the door

; Unused
  DEFS 2

; Make a character knock on a door or open it with a key
;
; Continues from the routine at GOTO. Raises the character's arm and then hands
; control over to the interruptible subcommand routine at BYDOOR1.
;
; H Character number (215-229)
CHRKNOCK;
  LD L,14                 ; Set the address of the interruptible subcommand
  LD (HL),70              ; routine in bytes 14 and 15 of the character's
                          ; buffer to BYDOOR1
; This entry point is used by the routines at KNOCK, BYDOOR3 and WALK.
CHRKNOCK_0;
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  AND 248                 ; A=character's base animatory state
  ADD A,4                 ; A=animatory state of the character with his arm up
  JP UPDATEAS             ; Update the character's animatory state and location
                          ; and update the SRB

; Control a character who is knocking on or opening a door (1)
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at CHRKNOCK. It makes the
; character open the door if he can, or knock and begin waiting for an answer.
;
; H Character number (215-229)
BYDOOR1;
  CALL CANOPEN            ; Check whether the character can open the door, and
                          ; open it if so
  LD L,16                 ; Point HL at byte 16 of the character's buffer
  JR NC,BYDOOR2           ; Jump if the character has opened the door
  JR Z,BYDOOR2            ; Jump if the character has no keys (only policemen
                          ; have no keys)
; This character (who is not a policeman) has knocked on the door.
  LD (HL),E               ; Store the LSB of the address of the door knock
                          ; status flags (see KNOCKFLAGS) for the door in byte
                          ; 16 of the character's buffer
  INC L                   ; Initialise the counter in byte 17 of the
  LD (HL),30              ; character's buffer to 30; this determines how long
                          ; the character will wait for someone to open the
                          ; door before giving up
  LD L,14                 ; Change the address of the interruptible subcommand
  LD (HL),89              ; routine in bytes 14 and 15 of the character's
                          ; buffer to DOORWAIT
  JR BYDOOR2_0            ; Lower the character's arm

; Control a character who has knocked on a door and is waiting for an answer
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at BYDOOR1. It makes the
; character continue to wait for someone to open the door, or give up and move
; on if he's already waited long enough.
;
; H Character number (215-229)
DOORWAIT;
  LD D,H                  ; D=character number
  CALL CHKDOOR            ; Check whether the door is open
  EX DE,HL                ; H=character number
  JP NZ,NEXTCMD_0         ; Terminate this subcommand if the door is open
  LD L,17                 ; Decrement the wait counter in byte 17 of the
  DEC (HL)                ; character's buffer
  RET NZ                  ; Return unless it's now zero
  DEC (HL)                ; Set the wait counter in byte 17 to 255; since it
                          ; could just as well be left at 0, this instruction
                          ; is redundant
  DEC L                   ; L=16
  LD E,(HL)               ; Point DE at the door knock status flags for the
  LD D,127                ; door that the character knocked on
  LD A,(DE)               ; Pick up the flags
  BIT 6,A                 ; Is somebody coming to answer the door?
  RET NZ                  ; Return if so
; The character has waited long enough for someone to open the door, and will
; now give up and move on.
  LD L,15                 ; Remove the address of this routine from bytes 14
  LD (HL),0               ; and 15 of the character's buffer
  JP RESTART              ; Restart the command list

; Control a character who is knocking on or opening a door (2)
;
; Continues from the routine at BYDOOR1. Lowers the character's arm and then
; hands control over to the interruptible subcommand routine at BYDOOR3.
;
; H Character number (215-229)
; L 16
BYDOOR2;
  LD (HL),20              ; Initialise the counter in byte 16 of the
                          ; character's buffer to 20; this determines how long
                          ; a policeman will keep knocking before busting the
                          ; door open
  LD L,14                 ; Change the address of the interruptible subcommand
  LD (HL),131             ; routine in bytes 14 and 15 of the character's
                          ; buffer to BYDOOR3
; This entry point is used by the routines at BYDOOR1, BYDOOR3, CHKHOOD and
; WALK to make a character lower his arm.
BYDOOR2_0;
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  AND 248                 ; A=character's base animatory state
  JP UPDATEAS             ; Update the character's animatory state and location
                          ; and update the SRB

; Control a character who is knocking on or opening a door (3)
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at BYDOOR2. At this point,
; either the character has opened the door already (in which case this routine
; does nothing more than verify that the door is still open and then terminate
; the subcommand), or he is knocking on the door repeatedly (in which case he
; must be a policeman).
;
; H Character number (215-229)
BYDOOR3;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  BIT 2,(HL)              ; Does the character have his arm raised?
  JR NZ,BYDOOR2_0         ; Make the character lower his arm if so
  LD D,H                  ; D=character number
  CALL CHKDOOR            ; Check whether the door is open
  EX DE,HL                ; H=character number
  JP NZ,NEXTCMD_0         ; Terminate this subcommand if the door is open
; This character must be a policeman. In this case, he will knock repeatedly
; for a while, and then open the door by force if there's no answer.
  LD L,16                 ; Decrement the counter in byte 16 of the policeman's
  DEC (HL)                ; buffer
  JP NZ,CHRKNOCK_0        ; Raise the policeman's arm for another knock if the
                          ; counter has not reached zero
  EX DE,HL                ; Point HL at the door status flags
  JP CANOPEN_0            ; Bust open the door

; Unused
  DEFS 5

; Update the SRB for a window
;
; Used by the routines at CHKFUSES and LSWITCH1. Updates the screen refresh
; buffer (SRB) for a window (or window-pair) after a light switch has been
; flipped or a blind has been raised or lowered.
;
; H 185-189 (corresponding to the 5th, 4th, 3rd, 2nd or 1st floor)
; L 0-31 or 64-95 (corresponding to the x-coordinate of the window)
WINDOWSRB;
  RES 6,L                 ; Now L=X'/8 (where X' is the x-coordinate of the
                          ; left edge of the window), and HL points at the Z
                          ; value corresponding to the window
  LD BC,(LEFTCOL)         ; The play area coordinates of the top-left corner of
                          ; the screen are stored at LEFTCOL and TOPROW
  LD A,C                  ; A=X (the x-coordinate of the leftmost column of the
                          ; play area on screen)
  RRCA                    ; A=X/8
  RRCA                    ;
  RRCA                    ;
  LD E,A                  ; E=X/8 (0-31)
  LD A,L                  ; A=X'/8 (0-31)
  SUB E                   ; A=X'/8-X/8
  CP 4                    ; Is the window off screen to the right or left?
  RET NC                  ; Return if so
  LD E,A                  ; E=0-3 (index of the 8-tile wide column containing
                          ; the window)
  LD A,H                  ; A=1 (5th floor), 2, 3, 4 or 5 (1st floor)
  SUB 184                 ;
  LD D,A                  ; D=6 (5th floor), 12, 18, 24 or 30 (1st floor)
  ADD A,A                 ;
  ADD A,D                 ;
  ADD A,A                 ;
  LD D,A                  ;
  SUB B                   ; Subtract Y, the y-coordinate of the topmost row of
                          ; the play area on screen (2, 8, 14 or 20)
  ADD A,4                 ; Is the window off screen?
  CP 21                   ;
  RET NC                  ; Return if so
  ADD A,A                 ; A=4*(D-Y+4)+E
  ADD A,A                 ;
  ADD A,E                 ;
  LD E,A                  ; Point DE at the SRB byte corresponding to the top
  LD D,127                ; row of the window
  LD C,128                ; C=128 (10000000)
  LD A,(HL)               ; Pick up the Z value for the window
  LD L,A                  ; Point HL at the Z'' value for the leftmost column
  SET 7,L                 ; of tiles in the 8-tile wide segment that contains
  LD H,184                ; the window
  EXX
  LD L,A                  ; Point HL' at the Z' value for the 8x6 block of
  LD H,191                ; tiles that contains the window
  LD C,1                  ; C'=1 (00000001)
  EXX
; The following loop examines the 8x6 block of tiles that contains the window
; and updates the relevant SRB bytes for the affected window tiles.
WINDOWSRB_0;
  EXX
  RRC C                   ; Rotate the set bit in C' one place to the right
  LD A,(HL)               ; A=Z' value
  AND C                   ; Set the zero flag if we should use the T values in
                          ; pages 160, 162, 164, 166, 168 and 170
  EXX
  PUSH HL                 ; Save the pointer to the Z'' value
  LD L,(HL)               ; L=Z'' value
  LD H,160                ; Point HL at the T value in page 160
  JR Z,WINDOWSRB_1        ; Jump unless we should use the T values in pages
                          ; 172, 174, 176, 178, 180 and 182
  LD H,172                ; Point HL at the T value in page 172
WINDOWSRB_1;
  LD B,6                  ; There are 6 rows of tiles to consider
WINDOWSRB_2;
  LD A,(HL)               ; A=T
  AND 192                 ; Keep only bits 6 and 7
  CP 128                  ; Is there a window tile here?
  JR NZ,WINDOWSRB_3       ; Jump if not
  LD A,(DE)               ; Set the appropriate bit in the SRB byte
  OR C                    ;
  LD (DE),A               ;
WINDOWSRB_3;
  INC H                   ; Point HL at the next T value (in page 162, 164,
  INC H                   ; 166, 168, 170, 174, 176, 178, 180 or 182)
  LD A,E                  ; Point DE at the SRB byte for the next row down
  ADD A,4                 ;
  LD E,A                  ;
  DJNZ WINDOWSRB_2        ; Jump back to consider the tile in the next row down
  LD A,E                  ; Point DE back at the SRB byte corresponding to the
  SUB 24                  ; top row of the window
  LD E,A                  ;
  POP HL                  ; Restore the Z'' value pointer to HL
  INC H                   ; Point HL at the Z'' value for the next column of
                          ; tiles to the right (in page 185-191)
  RRC C                   ; Rotate the set bit in C one place to the right
  JR NC,WINDOWSRB_0       ; Jump back until 8 tile columns have been checked
  RET

; Unused
  DEFS 3

; Decrement and check the blown fuse delay counters
;
; Used by the routine at MNLPTASKS1. Checks each fuse to see whether it was
; recently blown and should now be fixed, and updates the SRB for the windows
; affected by the fuse accordingly.
CHKFUSES;
  LD HL,FUSECTRS          ; Point HL at the first of the blown fuse delay
                          ; counters at FUSECTRS
CHKFUSES_0;
  LD A,(HL)               ; Pick up a delay counter
  AND A                   ; Is it 0?
  JR Z,CHKFUSES_1         ; Jump if so to examine the next fuse
  DEC (HL)                ; Otherwise decrement the delay counter (this fuse
                          ; was recently blown)
  JR Z,CHKFUSES_2         ; Jump if it's time to fix this fuse
CHKFUSES_1;
  INC L                   ; Move to the next fuse
  BIT 3,L                 ; Have we examined all the fuses yet?
  JR Z,CHKFUSES_0         ; Jump back if not
  RET
; If we're entering here from the loop above, it's time to fix a fuse that was
; recently blown. This entry point is also used by the routine at FUSE to blow
; a fuse.
CHKFUSES_2;
  LD A,L                  ; A=162-167, corresponding to the fuse
  LD HL,65471             ; Prepare HL to scan the table at BFUSELOCS
CHKFUSES_3;
  INC L                   ; Point HL at the next byte in the table
  BIT 5,L                 ; Have we reached the end of the table yet?
  RET NZ                  ; Return if so
  CP (HL)                 ; Does this byte correspond to a segment that is
                          ; affected by the fuse?
  JR NZ,CHKFUSES_3        ; Jump back to check the next byte if not
  PUSH AF                 ; Save the LSB of the address of the blown fuse delay
                          ; counter
  PUSH HL                 ; Save the table pointer
  LD A,L                  ; A=x/8 (where x is the x-coordinate of the leftmost
  AND 31                  ; column of the 8-tile wide segment that is affected
                          ; by the fuse)
  LD L,A                  ; Point HL at the Z value for the 5th floor in this
  LD H,185                ; segment
CHKFUSES_4;
  PUSH HL                 ; Save the Z value pointer
  CALL WINDOWSRB          ; Update the SRB for any windows on this floor
  POP HL                  ; Restore the Z value pointer to HL
  INC H                   ; Point HL at the Z value for the next floor down in
                          ; this segment
  LD A,H                  ; Have we done every floor down to the first yet?
  CP 190                  ;
  JR NZ,CHKFUSES_4        ; Jump back if not
  POP HL                  ; Restore the table pointer to HL
  POP AF                  ; Restore the LSB of the address of the blown fuse
                          ; delay counter to A
  JR CHKFUSES_3           ; Check the next byte in the table

; Check whether a character is standing next to a light switch
;
; Used by the routines at COPLIGHT, COPTOSAM, ICONPANEL2, LIGHT, LSWITCH1,
; LSWITCH2 and LSWITCH3. Returns with the zero flag reset if the character is
; standing next to a light switch.
;
; H Character number (215-230)
BYLIGHT;
  LD L,4                  ; Point HL at byte 4 of the character's buffer
  BIT 0,(HL)              ; Is the character indoors?
  RET Z                   ; Return if not
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  LD A,(HL)               ; A=character's animatory state
  RLCA                    ; Set the carry flag if the character is facing left,
  CCF                     ; reset it if he's facing right
  SBC A,A                 ; Now A=0 if the character is facing left, or 2 if
  INC A                   ; he's facing right
  ADD A,A                 ;
  INC L                   ; Point HL at byte 1 of the character's buffer
  ADD A,(HL)              ; Add the character's x-coordinate
  LD B,128                ; Bit 7 set; check for a light switch at the left
                          ; side of the room
  LD C,A                  ; C=x-coordinate of the front column of the
                          ; character's sprite
  AND 7                   ; Is C=0 mod 8?
  JR Z,BYLIGHT_1          ; Jump if so (left-hand light switches are at such
                          ; coordinates)
  LD B,64                 ; Bit 6 set; check for a light switch at the right
                          ; side of the room
  SUB 7                   ; Is C=7 mod 8?
  JR Z,BYLIGHT_1          ; Jump if so (right-hand light switches are at such
                          ; coordinates)
BYLIGHT_0;
  XOR A                   ; Set the zero flag (no target object here)
  RET
; This entry point is used by the routines at BYPHONE (with B=2 to check for
; the presence of a telephone), PREPCSCENE (with B=192 to check for a light
; switch) and LIGHTBLIND (with B=4, 8, 16, 64 or 128 to check for a light
; switch or window blind).
BYLIGHT_1;
  LD A,C                  ; A=x-coordinate of the front column of the
                          ; character's sprite
  AND 248                 ; C=INT(C/8)
  RRCA                    ;
  RRCA                    ;
  RRCA                    ;
  LD C,A                  ;
  INC L                   ; Point HL at byte 2 of the character's buffer
  LD A,(HL)               ; A=character's y-coordinate
  CP 33                   ; This is the y-coordinate of a character who's in a
                          ; shop
  JR NZ,BYLIGHT_2         ; Jump if the character's not in a shop
  SUB 2                   ; Adjust a y-coordinate of 33 down to 31
BYLIGHT_2;
  LD L,254                ; L=INT(A/6)-1 (0-4)
BYLIGHT_3;
  INC L                   ;
  SUB 6                   ;
  JR NC,BYLIGHT_3         ;
  CP 251                  ; Is the character's y-coordinate 7, 13, 19, 25, 31
                          ; or 33?
  JR NZ,BYLIGHT_0         ; Jump if not (he's not on a floor)
  LD A,L                  ; A=0-4
  CP 5                    ; Is the character's y-coordinate >= 36?
  JR NC,BYLIGHT_0         ; Jump if so
  RRCA                    ; A=0 (5th floor), 32 (4th floor), 64, 96 or 128 (1st
  RRCA                    ; floor)
  RRCA                    ;
  ADD A,C                 ; Add INT(x/8) (where x is the x-coordinate of the
                          ; front column of the character's sprite)
  LD E,A                  ; Transfer this to E
  LD D,245                ; Point DE at an entry in the fixture location table
                          ; at FIXTURES
  LD A,(DE)               ; Pick up the entry
  AND B                   ; Is there an object of the desired type here?
  RET Z                   ; Return if not
  LD A,L                  ; A=0-4
  ADD A,185               ; B=185-189
  LD B,A                  ;
  LD A,(DE)               ; Pick up the entry from the fixture location table
                          ; at FIXTURES
  SET 6,C                 ; Point BC at the window flags for the character's
                          ; location (in one of the data blocks at WINFLAGS5,
                          ; WINFLAGS4, WINFLAGS3, WINFLAGS2, or WINFLAGS1)
  RET                     ; Return with the zero flag reset

; Make a character flip a light switch off or on occasionally
;
; Used by the routines at UPDOWNSC and GOTO. If the character is standing next
; to a light switch, this routine makes him flip the switch on (if it's off and
; affects the lights in more than one window or window-pair), or consider
; flipping the switch off (if it's on and affects the lights in only one window
; or window-pair).
;
; H Character number (215-229)
LSWITCH1;
  CALL BYLIGHT            ; Is the character standing next to a light switch?
  RET Z                   ; Return if not
  BIT 5,A                 ; Does the light switch affect lights in more than
                          ; one window or window-pair?
  JR NZ,LSWITCH1_4        ; Jump if so
; This entry point is used by the routine at LSWITCH3.
LSWITCH1_0;
  LD A,(BC)               ; A=window flags for the character's location
  BIT 5,A                 ; Is the light switch here in the 'off' position?
  RET NZ                  ; Return if so
; This entry point is used by the routine at LSWITCH2.
LSWITCH1_1;
  CALL GETRANDOM          ; Get a random number in A
  CP 110                  ; Is it greater than 109?
  RET NC                  ; Return if so
; This entry point is used by the routines at COPLIGHT and LIGHT.
LSWITCH1_2;
  LD A,32                 ; Bit 5 set; light switch toggle
; This entry point is used by the routines at BLIND (with A=1 or 64),
; PREPCSCENE (with A=0) and WALK (with A=1, 32 or 64).
LSWITCH1_3;
  PUSH BC                 ; Push the address of the window flags onto the stack
  EX (SP),HL              ; Transfer this address into HL
  XOR (HL)                ; Flip bit 1, 5 or 6 of the window flags, thus
  LD (HL),A               ; flipping the light switch that affects the window,
                          ; or raising or lowering the blind
  CALL WINDOWSRB          ; Update the SRB for the window
  POP HL                  ; Restore the character number to H
  RET
; The character is standing next to a light switch that affects lights in more
; than one window or window-pair.
LSWITCH1_4;
  LD A,(BC)               ; A=window flags for the character's location
; This entry point is used by the routine at COPLIGHT.
LSWITCH1_5;
  BIT 5,A                 ; Is the light switch here in the 'on' position?
  RET Z                   ; Return if so
; This entry point is used by the routines at LIGHT, PREPCSCENE and LSWITCH2.
LSWITCH1_6;
  PUSH BC                 ; Push the address of the window flags onto the stack
  EX (SP),HL              ; Transfer this address into HL
  LD A,C                  ; A=LSB of the address of the window flags
  LD BC,1056              ; B=4 (the four central windows on a floor of the
                          ; hotel span four 8-tile wide segments), C=32 (bit 5
                          ; set; light switch toggle)
  CP 72                   ; Are we dealing with a window that is second from
                          ; the left in the hotel?
  JR NZ,LSWITCH1_9        ; Jump if not
; A light switch that affects the lights in the the four central windows on one
; of the floors of the hotel has been flipped.
LSWITCH1_7;
  LD L,72                 ; Point HL at the window flags for the leftmost of
                          ; the four central windows
LSWITCH1_8;
  PUSH HL                 ; Save the window flags pointer
  PUSH BC                 ; Save the segment counter
  LD A,(HL)               ; Flip bit 5 of the window flags, thus flipping the
  XOR C                   ; light switch into the 'on' or 'off' position
  LD (HL),A               ;
  CALL WINDOWSRB          ; Update the SRB for the window
  POP BC                  ; Restore the segment counter
  POP HL                  ; Restore the window flags pointer to HL
  INC L                   ; Move to the next window along
  DJNZ LSWITCH1_8         ; Jump back until all four windows have been done
  POP HL                  ; Restore the character number to H
  RET
LSWITCH1_9;
  CP 75                   ; Are we dealing with a window that is second from
                          ; the right in the hotel?
  JR Z,LSWITCH1_7         ; Jump if so
; A light switch that affects the lights in the windows on more than one floor
; of a building other than the hotel has been flipped.
  SUB C                   ; Subtract 32 from the LSB of the window flags
                          ; address
  DEC B                   ; B=3 (there are three floors to consider)
  NOP
  LD E,A                  ; Point DE at the fixture location flags for the area
                          ; on the fourth floor (if any) above the light switch
  LD H,186                ; The fourth floor window flags are in bytes 64-95 of
                          ; page 186 (at WINFLAGS4)
LSWITCH1_10;
  LD A,(DE)               ; Collect the fixture location flags for the fourth
                          ; floor
  BIT 5,A                 ; Does the light switch affect any windows on this
                          ; floor?
  JR Z,LSWITCH1_11        ; Jump if not
  PUSH HL                 ; Save the window flags pointer
  PUSH DE                 ; Save the fixture location flags pointer
  PUSH BC                 ; Save the floor counter
  LD A,(HL)               ; Flip bit 5 of the window flags, thus flipping the
  XOR 32                  ; light switch into the 'on' or 'off' position
  LD (HL),A               ;
  CALL WINDOWSRB          ; Update the SRB for the windows on this floor
  POP BC                  ; Restore the floor counter to B
  POP DE                  ; Restore the fixture location flags pointer to DE
  POP HL                  ; Restore the window flags pointer to HL
LSWITCH1_11;
  INC H                   ; Point HL at the window flags for the next floor
                          ; down
  LD A,E                  ; Point DE at the fixture location flags for the next
  ADD A,32                ; floor down
  LD E,A                  ;
  DJNZ LSWITCH1_10        ; Jump back until the windows on the fourth, third
                          ; and second floors have been dealt with
  POP HL                  ; Restore the character number to H
  RET

; Make a character flip a light switch on or off occasionally
;
; Used by the routine at WALKFLOOR. If the character is standing next to a
; light switch, this routine makes him flip the switch off (if it's on and
; affects the lights in more than one window or window-pair), or consider
; flipping the switch on (if it's off and affects the lights in only one window
; or window-pair).
;
; H Character number (215-229)
LSWITCH2;
  CALL BYLIGHT            ; Is the character standing next to a light switch?
  RET Z                   ; Return if not
  BIT 5,A                 ; Reset the zero flag if the light switch affects the
                          ; lights in more than one window or window-pair
; This entry point is used by the routine at LSWITCH3.
LSWITCH2_0;
  LD A,(BC)               ; A=window flags
  JR NZ,LSWITCH2_1        ; Jump if the light switch affects the lights in more
                          ; than one window or window-pair
  BIT 5,A                 ; Is the light switch in the 'on' position?
  RET Z                   ; Return if so
  JP LSWITCH1_1           ; Flip the light switch on 109 times out of 256
LSWITCH2_1;
  BIT 5,A                 ; Is the light switch in the 'off' position?
  RET NZ                  ; Return if so
  JP LSWITCH1_6           ; Flip the light switch off

; Unused
  DEFS 5

; Fixture locations
;
; Used by the routine at BYLIGHT. The data here is split into 5 groups of 32
; bytes. Each byte corresponds to a segment of the play area that is eight
; tiles wide, and level with the floor of a building. A bit set in any byte
; indicates the presence of an object in that segment.
;
; +-----+-------------------------------------------------------------------+
; | Bit | Meaning if set                                                    |
; +-----+-------------------------------------------------------------------+
; | 7   | Light switch on the left side of the room                         |
; | 6   | Light switch on the right side of the room                        |
; | 5   | Any light switches here affect the lights in more than one window |
; |     | or window-pair                                                    |
; | 4   | Blind on the left-hand window                                     |
; | 3   | Blind on the right-hand window                                    |
; | 2   | Blind on a large central window                                   |
; | 1   | Telephone                                                         |
; | 0   | Unused                                                            |
; +-----+-------------------------------------------------------------------+
;
; The first group of bytes corresponds to the 5th floor.
FIXTURES;
  DEFB 0,0,0,0,0,0,0      ; 0<=x<=55; No fixtures here
  DEFB 70,224,32,32,224,132 ; 56<=x<=103; Hotel
  DEFB 0,0,0,0,0,0,0,0    ; 104<=x<=255; No fixtures here
  DEFB 0,0,0,0,0,0,0,0    ;
  DEFB 0,0,0              ;
; The next group of bytes corresponds to the 4th floor.
  DEFB 88,0,152           ; 0<=x<=23; Apartment building next to no. 74
  DEFB 0                  ; 24<=x<=31; Catwalk
  DEFB 146,224,128        ; 32<=x<=55; No. 74
  DEFB 68,224,32,32,224,134 ; 56<=x<=103; Hotel
  DEFB 0,0,0              ; 104<=x<=127; No fixtures here
  DEFB 64,0,128           ; 128<=x<=151; Police station
  DEFB 224                ; 152<=x<=159; No. 27
  DEFB 0,0                ; 160<=x<=175; No fixtures here
  DEFB 66,216,0,152       ; 176<=x<=207; Apartment building next to no. 19
  DEFB 0,0                ; 208<=x<=223; No fixtures here
  DEFB 88,144             ; 224<=x<=239; No. 17
  DEFB 88,160             ; 240<=x<=255; No. 15
; The next group of bytes corresponds to the 3rd floor.
  DEFB 64,0,154           ; 0<=x<=23; Apartment building next to no. 74
  DEFB 0                  ; 24<=x<=31; No fixtures here
  DEFB 82,224,128         ; 32<=x<=55; No. 74
  DEFB 70,224,32,32,224,132 ; 56<=x<=103; Hotel
  DEFB 88,184             ; 104<=x<=119; No. 31
  DEFB 0                  ; 120<=x<=127; No fixtures here
  DEFB 68,0,132           ; 128<=x<=151; Police station
  DEFB 32                 ; 152<=x<=159; No. 27
  DEFB 0,0                ; 160<=x<=175; No fixtures here
  DEFB 64,216,0,136       ; 176<=x<=207; Apartment building next to no. 19
  DEFB 96,130             ; 208<=x<=223; No. 19
  DEFB 90,168             ; 224<=x<=239; No. 17
  DEFB 90,160             ; 240<=x<=255; No. 15
; The next group of bytes corresponds to the 2nd floor.
  DEFB 64,0,152           ; 0<=x<=23; Apartment building next to no. 74
  DEFB 0                  ; 24<=x<=31; No fixtures here
  DEFB 80,224,138         ; 32<=x<=55; No. 74
  DEFB 68,224,32,32,224,132 ; 56<=x<=103; Hotel
  DEFB 66,160             ; 104<=x<=119; No. 31
  DEFB 0                  ; 120<=x<=127; No fixtures here
  DEFB 70,0,132           ; 128<=x<=151; Police station
  DEFB 32                 ; 152<=x<=159; No. 27
  DEFB 0,0                ; 160<=x<=175; No fixtures here
  DEFB 64,216,0,130       ; 176<=x<=207; Apartment building next to no. 19
  DEFB 96,128             ; 208<=x<=223; No. 19
  DEFB 88,48              ; 224<=x<=239; No. 17
  DEFB 88,32              ; 240<=x<=255; No. 15
; The next group of bytes corresponds to the 1st floor.
  DEFB 192                ; 0<=x<=7; Left-hand shop under the apartments next
                          ; to no. 74
  DEFB 0                  ; 8<=x<=15; No fixtures here
  DEFB 192                ; 16<=x<=23; Right-hand shop under the apartments
                          ; next to no. 74
  DEFB 0                  ; 24<=x<=31; No fixtures here
  DEFB 66,224,128         ; 32<=x<=55; No. 74
  DEFB 0,0,0,0,0,0        ; 56<=x<=103; Hotel
  DEFB 88,160             ; 104<=x<=119; No. 31
  DEFB 0                  ; 120<=x<=127; No fixtures here
  DEFB 0,0,0              ; 128<=x<=151; Police station
  DEFB 160                ; 152<=x<=159; No. 27
  DEFB 0,0                ; 160<=x<=175; No fixtures here
  DEFB 0,218,0,128        ; 176<=x<=207; Apartment building next to no. 19
  DEFB 224,128            ; 208<=x<=223; No. 19
  DEFB 192,160            ; 224<=x<=239; No. 17
  DEFB 192,160            ; 240<=x<=255; No. 15

; Make a character flip a light switch off occasionally
;
; Used by the unused routine at XFLIPLT and the routine at GOTO. If the
; character is standing next to a light switch, this routine makes him flip the
; switch off (if it's on and affects the lights in more than one window or
; window-pair), or consider flipping the switch off (if it's on and affects the
; lights in only one window or window-pair).
;
; H Character number (215-229)
LSWITCH3;
  CALL BYLIGHT            ; Is the character standing next to a light switch?
  RET Z                   ; Return if not
  BIT 5,A                 ; Does the light switch affect the lights in more
                          ; than one window or window pair?
  JP Z,LSWITCH1_0         ; If not, flip the light switch off 109 times out of
                          ; 256
  JP LSWITCH2_0           ; Flip the light switch off

; Guide a character up or down staircases
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at GOTO. It guides the
; character down to the first floor of a building (so that he can then leave it
; on the way to his final destination), or up to the floor he is heading for.
;
; H Character number (215-229)
UPDOWNSC;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  BIT 0,(HL)              ; Is the character midstride?
  JP NZ,ENDSTRIDE         ; If so, move the character from the midstride
                          ; position and update the SRB
  LD L,3                  ; Has this character's command list been marked for a
  BIT 4,(HL)              ; restart?
  JP NZ,NEXTCMD_0         ; Terminate this subcommand if so (this jump is never
                          ; made because bit 4 of byte 3 is unused)
  DEC L                   ; L=2
  LD A,(HL)               ; A=character's y-coordinate
  LD L,16                 ; Compare it with the y-coordinate of the character's
  CP (HL)                 ; intermediate or final destination
  JP Z,NEXTCMD_0          ; Terminate this subcommand if they match
  PUSH AF                 ; Save the carry flag
  CALL LSWITCH1           ; Make the character consider flipping a light switch
  POP AF                  ; Restore the carry flag
  JP C,MOVEDOWN           ; Make the character move down if he's above the
                          ; level of his destination
  JP MOVEUP               ; Otherwise make the character move up

; Unused
  DEFB 0

; Guide a character across a floor to his destination
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at GOTO. It guides the
; character left or right across the floor of a building to his final
; destination.
;
; H Character number (215-229)
WALKFLOOR;
  LD BC,LSWITCH2          ; Point BC at the routine at LSWITCH2
; This entry point is used by the unused routine at XFLIPLT (with BC=LSWITCH3)
; and by the routine at WALKSTREET (with BC=DONOWT2; RET).
WALKFLOOR_0;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  BIT 0,(HL)              ; Is the character midstride?
  JP NZ,ENDSTRIDE         ; If so, move the character from the midstride
                          ; position and update the SRB
  LD L,3                  ; Has this character's command list been marked for a
  BIT 4,(HL)              ; restart?
  JP NZ,NEXTCMD_0         ; Terminate this subcommand if so (this jump is never
                          ; made because bit 4 of byte 3 is unused)
  LD L,1                  ; Collect the character's x-coordinate from byte 1 of
  LD A,(HL)               ; his buffer
  LD L,16                 ; Compare this with the character's intermediate or
  CP (HL)                 ; final destination x-coordinate
  JP Z,NEXTCMD_0          ; Terminate this subcommand if they match
  PUSH AF                 ; Save the carry flag
  LD DE,DONECMD           ; Push the address of the instruction at DONECMD
  PUSH DE                 ; (below) onto the stack
  PUSH BC                 ; Make an indirect jump to the routine whose address
DONOWT2;
  RET                     ; is in BC, and then return to DONECMD (below)
DONECMD;
  POP AF                  ; Restore the carry flag
  JP C,MOVERIGHT          ; Make the character move right if he's to the left
                          ; of his intermediate or final destination
  JP MOVELEFT             ; Otherwise make the character move left

; Make a character consider switching a light off (unused)
XFLIPLT;
  LD BC,LSWITCH3          ; Point BC at the routine at LSWITCH3
  JR WALKFLOOR_0          ; Move the character left or right towards his
                          ; destination

; Guide a character from one spot on the sidewalk or road to another
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at GOTO. It guides the
; character left or right over the sidewalk or road towards his destination.
;
; H Character number (215-229)
WALKSTREET;
  LD BC,DONOWT2           ; Point BC at the RET instruction at DONOWT2
  JR WALKFLOOR_0          ; Move the character left or right towards his
                          ; destination

; Make a character go to a location
;
; Used by many command lists to make a character go to a specified place.
;
; H Character number (215-229)
GOTO;
  CALL GETDEST            ; Collect the destination coordinates from the
                          ; command list
  JR GOTO_0
; This entry point is used by the command lists at CLIST01, CLIST02, CLIST04,
; CLIST05, CLIST06, CLIST07 and CLIST11 to make a character carry Sam to a
; location.
  CALL GETDEST            ; Collect the destination coordinates from the
                          ; command list
  LD (HL),10              ; Change the address of the primary command routine
                          ; in bytes 8 and 9 of the character's buffer to
                          ; CARRYSAM (below)
CARRYSAM;
  CALL MIDSTRIDE          ; Exit now if the character is midstride
  CALL NEXTMOVE           ; Determine the next move the character should make
                          ; to reach his destination
  AND A                   ; Has the character reached his destination?
  JR Z,GOTO_1             ; Move to the next command in the command list if so
  JP MVCOP2_5             ; Move the character one step towards his destination
; The character is not carrying Sam.
GOTO_0;
  LD (HL),24              ; Change the address of the primary command routine
                          ; in bytes 8 and 9 of the character's buffer to
                          ; GOTODEST (below)
GOTODEST;
  CALL MIDSTRIDE          ; Exit now if the character is midstride
  CALL NEXTMOVE           ; Determine the next move the character should make
                          ; to reach his destination
  AND A                   ; Has the character reached his destination?
GOTO_1;
  JP Z,NEXTCMD            ; Move to the next command in the command list if so
  CP 5                    ; Is the character standing next to a closed door?
  JR NC,GOTO_9            ; Jump if so
  PUSH AF                 ; Save the direction indicator
  LD BC,WALKFLOOR         ; Point BC at the interruptible subcommand routine at
                          ; WALKFLOOR
  LD L,13                 ; Pick up the location/destination indicator from
  LD A,(HL)               ; byte 13 of the character's buffer
  AND A                   ; Is the character on the sidewalk or the road (or on
                          ; the front steps of the hotel but heading somewhere
                          ; other than the hotel)?
  JR NZ,GOTO_5            ; Jump if not
  LD BC,WALKSTREET        ; Point BC at the interruptible subcommand routine at
                          ; WALKSTREET
GOTO_2;
  LD L,16                 ; Place the x- or y-coordinate of the character's
  LD (HL),E               ; intermediate destination into byte 16 of his buffer
  LD L,15                 ; Copy the interruptible subcommand routine address
  LD (HL),B               ; in BC (UPDOWNSC, WALKFLOOR or WALKSTREET) into
  DEC L                   ; bytes 14 and 15 of the character's buffer
  LD (HL),C               ;
GOTO_3;
  POP AF                  ; Restore the direction indicator (1-4) to A
; This entry point is used by the routines at MVCOP2 and HOODTOSAM2.
GOTO_4;
  DEC A                   ; Does the character need to move right next to reach
                          ; his destination?
  JP Z,MOVERIGHT          ; Jump if so
  DEC A                   ; Does the character need to move left?
  JP Z,MOVELEFT           ; Jump if so
  DEC A                   ; Does the character need to move up?
  JP Z,MOVEUP             ; Jump if so
  JP MOVEDOWN             ; Make the character move down
; The character is not on the sidewalk or road.
GOTO_5;
  DEC A                   ; Is the character's destination in a region other
                          ; than the one he's in at the moment?
  JR NZ,GOTO_8            ; Jump if so
  LD L,2                  ; Collect the character's y-coordinate from byte 2 of
  LD A,(HL)               ; his buffer
  CP 31                   ; Is the character on or below the level of the first
                          ; floor?
  JR NC,GOTO_7            ; Jump if so
  LD L,10                 ; Point HL at byte 10 of the character's buffer
  LD E,(HL)               ; E=character's destination x-coordinate
  INC L                   ; L=11
  CP (HL)                 ; Is the character's y-coordinate the same as that of
                          ; his destination?
  JR Z,GOTO_2             ; If so, send the character to his destination
                          ; x-coordinate (on the same floor)
  LD E,(HL)               ; E=character's destination y-coordinate
GOTO_6;
  LD BC,UPDOWNSC          ; Point BC at the interruptible subcommand routine at
                          ; UPDOWNSC
  JR GOTO_2               ; Send the character up or down the stairs towards
                          ; his destination
; The character is in the same region as his destination, and on or below the
; level of the first floor.
GOTO_7;
  LD L,4                  ; Byte 4 of the character's buffer holds his
                          ; z-coordinate
  BIT 0,(HL)              ; Is the character indoors (z=1)?
  CALL NZ,LSWITCH1        ; If so, make him consider flipping a light switch
  JR GOTO_3               ; Move the character one step closer to his
                          ; destination
; The character's destination is in a region other than the one he's in at the
; moment.
GOTO_8;
  LD L,2                  ; Collect the character's y-coordinate from byte 2 of
  LD A,(HL)               ; his buffer
  LD E,31                 ; This is the y-coordinate of the first floor
  CP E                    ; Is the character above the first floor?
  JR C,GOTO_6             ; Jump if so to send him down to the first floor
  LD L,4                  ; Byte 4 of the character's buffer holds his
                          ; z-coordinate
  BIT 0,(HL)              ; Is the character indoors (z=1)?
  CALL NZ,LSWITCH3        ; If so, make him consider flipping a light switch
                          ; off before leaving
  JR GOTO_3               ; Move the character one step closer to his
                          ; destination
; The character is standing next to a closed door. This entry point is used by
; the routines at MVCOP2 and HOODTOSAM2.
GOTO_9;
  JP Z,SAMBYDOOR_2        ; Jump if the character is standing behind a closed
                          ; door
  LD L,15                 ; Prepare the MSB of the address of the interruptible
  LD (HL),243             ; subcommand routine at BYDOOR1 in byte 15 of the
                          ; character's buffer
  JP CHRKNOCK             ; Prepare the LSB and raise the character's arm

; Make a character stop running and restart the command list
;
; Continues from the routine at DROPSAM.
;
; H Character number (215-229)
WALKRST;
  LD L,3                  ; Reset bit 7 of byte 3 of the character's buffer
  RES 7,(HL)              ; (he's no longer running)
  JP RESTART              ; Restart the command list

; Unused
  DEFB 0

; Check whether a gangster is midstride or has his arm raised
;
; Used by the routine at HOODWALK. Returns to the caller unless the gangster is
; midstride or has his arm raised; otherwise moves the gangster from the
; midstride position or lowers his arm, and returns to the routine at MVCHARS
; to move the next character.
;
; H Gangster's character number (215-224)
CHKHOOD;
  LD L,0                  ; Point HL at byte 0 of the gangster's buffer
  BIT 2,(HL)              ; Is the gangster's arm raised?
  JR Z,MIDSTRIDE_0        ; Jump if not
  POP BC                  ; Drop the return address from the stack
  JP BYDOOR2_0            ; Lower the gangster's arm

; Check whether a character is midstride
;
; Used by the routines at MVCOP2, HOODTOSAM2, GOTO and WALK. Returns to the
; caller unless the character is midstride; otherwise moves the character from
; the midstride position and returns to the routine at MVCHARS to move the next
; character.
;
; H Character number (215-229)
MIDSTRIDE;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
; This entry point is used by the routine at CHKHOOD.
MIDSTRIDE_0;
  BIT 0,(HL)              ; Is the character midstride?
  RET Z                   ; Return if not
  POP BC                  ; Drop the return address from the stack
  JP ENDSTRIDE            ; Move the character from the midstride position and
                          ; update the SRB

; Unused
  DEFB 0

; Calculate the x-coordinate of the front column of a character's sprite
;
; Used by the routines at BYPHONEX, PREPCSCENE and LIGHTBLIND. Returns with C
; holding the x-coordinate of the front column of a character's sprite (that
; is, the left column if he's facing left, or the right column if he's facing
; right), A holding the remainder when C is divided by 8, and the zero flag set
; if the remainder is 0.
;
; H Character number (215-230)
FRONTX;
  LD L,0                  ; Point HL at byte 0 of the character's buffer
  LD A,(HL)               ; A=character's animatory state
  RLCA                    ; Set the carry flag if the character is facing left,
  CCF                     ; reset it if he's facing right
  SBC A,A                 ; Now A=0 if the character is facing left, or 2 if
  INC A                   ; he's facing right
  ADD A,A                 ;
  INC L                   ; Point HL at byte 1 of the character's buffer
  ADD A,(HL)              ; Add the character's x-coordinate
  LD C,A                  ; C=x-coordinate of the front column of the
                          ; character's sprite
  AND 7                   ; A=C%8, with the zero flag if this is 0
  RET

; Check whether a character is standing next to a light switch or window blind
;
; Used by the routines at BLIND and WALK. Returns with the zero flag reset if
; the character is standing next to a light switch or a window that has a
; blind, and with the bit set in A identifying the fixture that was found.
;
; H Character number (215-230)
LIGHTBLIND;
  LD L,4                  ; Point HL at byte 4 of the character's buffer
  BIT 0,(HL)              ; Is the character indoors?
  RET Z                   ; Return if not
  CALL FRONTX             ; Collect in C the x-coordinate of the front column
                          ; of the character's sprite
  LD B,128                ; Bit 7 set; check for a light switch at the left
                          ; side of the room
  JR Z,LIGHTBLIND_0       ; Jump if C=0 mod 8
  LD B,16                 ; Bit 4 set; check for a blind on the left-hand
                          ; window
  SUB 3                   ; Does C=1 or 2 mod 8?
  JR C,LIGHTBLIND_0       ; Jump if so
  LD B,4                  ; Bit 2 set; check for a blind on a large central
                          ; window
  SUB 2                   ; Does C=3 or 4 mod 8?
  JR C,LIGHTBLIND_0       ; Jump if so
  LD B,8                  ; Bit 3 set; check for a blind on the right-hand
                          ; window
  SUB 2                   ; Does C=5 or 6 mod 8?
  JR C,LIGHTBLIND_0       ; Jump if so
  LD B,64                 ; Bit 6 set; check for a light switch at the right
                          ; side of the room (when C=7 mod 8)
LIGHTBLIND_0;
  PUSH BC                 ; Save the fixture identifier bit (in B)
  CALL BYLIGHT_1          ; Is the character standing next to a light switch or
                          ; a window that has a blind?
  JR NZ,LIGHTBLIND_1      ; Jump if so
  POP AF                  ; Restore the fixture identifier bit to A (though we
                          ; don't need it now)
  XOR A                   ; Set the zero flag
  RET
LIGHTBLIND_1;
  POP AF                  ; Restore the fixture identifier bit to A
  AND A                   ; Reset the zero flag
  RET

; Unused
  DEFS 2

; Restart the command list
;
; Used by the routines at RESETHOOD, HOODTOSAM2, DOORWAIT and WALKRST, and by
; the command lists at CLIST03, CLIST12, CLIST13, CLIST15, CLIST16, CLIST17,
; CLIST18, CLIST19, CLIST20, CLIST21, CLIST22, CLIST23, CLIST24, CLIST25,
; CLIST26, CLIST27, CLIST28 and CLIST33.
;
; H Character number (215-229)
RESTART;
  LD L,22                 ; Byte 22 of the character's buffer holds the offset
                          ; of the point reached in the command list (relative
                          ; to the start)
  LD (HL),0               ; Set this offset to 0, thus restarting the command
                          ; list
  JP NEXTCMD              ; Remove any existing primary command routine address
                          ; from the character's buffer

; Unused
  DEFS 4

; Make a character walk up or down
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a character's buffer by the routine at DOORDUTY. It makes a
; character start or continue walking up or down towards his walkabout
; destination, stopping occasionally on the way to flip a light switch or raise
; or lower a window blind.
;
; H Character number (215-229)
WALK;
  CALL MIDSTRIDE          ; Exit now if the character is midstride
  BIT 2,(HL)              ; Is the character's arm raised?
  JP NZ,BYDOOR2_0         ; Lower his arm if so
; This entry point is used by the routine at HOODWALK.
WALK_0;
  LD L,17                 ; The counter in byte 17 of the character's buffer
                          ; determines the delay until the character will next
                          ; consider flipping a light switch or raising or
                          ; lowering a window blind
  DEC (HL)                ; Decrement that counter
  JR NZ,WALK_3            ; Jump unless the counter has reached 0
  LD (HL),4               ; Reset the counter to 4 (in case the character is
                          ; not standing next to a light switch or window blind
                          ; at the moment)
  CALL LIGHTBLIND         ; Is the character standing next to a light switch or
                          ; window blind?
  JR Z,WALK_3             ; Jump if not
; The character is standing next to a light switch or window blind.
  CP 64                   ; Is the character standing next to a window blind?
  JR C,WALK_1             ; Jump if so
  LD A,(DE)               ; A=fixture location flags
  BIT 5,A                 ; Does the light switch affect the lights in more
                          ; than one window or window pair?
  JR NZ,WALK_3            ; Jump if so (the character will not flip the switch)
  LD A,32                 ; Bit 5 set; light switch toggle
  JR WALK_2
WALK_1;
  CP 8                    ; Set the zero flag if the character standing next to
                          ; the right-hand window of a pair
  LD A,1                  ; Bit 0 set; right-hand window blind toggle
  JR Z,WALK_2             ; Jump if the character is standing next to the
                          ; right-hand window of a pair
  LD A,64                 ; Bit 6 set; left-hand window blind toggle
WALK_2;
  CALL LSWITCH1_3         ; Flip the light switch, or raise or lower the window
                          ; blind
  CALL GETRANDOM          ; Get a random number between 32 and 159 in A
  AND 127                 ;
  ADD A,32                ;
  LD L,17                 ; Reset the counter in byte 17 of the character's
  LD (HL),A               ; buffer to this number
  JP CHRKNOCK_0           ; Raise the character's arm
; The character will not be flipping any light switches or raising or lowering
; any window blinds at this stage of his walkabout.
WALK_3;
  LD L,1                  ; Collect the character's x-coordinate from byte 1 of
  LD A,(HL)               ; his buffer
  LD L,16                 ; Byte 16 of the character's buffer holds his
                          ; walkabout destination x-coordinate
  CP (HL)                 ; Has the character reached his walkabout
                          ; destination?
  JP Z,NEXTCMD_0          ; Terminate this subcommand if so
  JP C,MOVERIGHT          ; Move the character right if he's still to the left
                          ; of his destination
  JP MOVELEFT             ; Otherwise move him left

; Make a character drop Sam
;
; Used by the command lists at CLIST02, CLIST04, CLIST05, CLIST06 and CLIST07.
; Makes the character drop Sam and stop running, and restarts the command list.
;
; H Character number (215-229)
DROPSAM;
  CALL UPDATESRB          ; Update the SRB for the character's current
                          ; animatory state and location
  AND 242                 ; A=animatory state of the character in phase 1 or 3
                          ; of his walking animation
  CALL UPDATEAS           ; Update the character's animatory state and location
                          ; and update the SRB
  LD A,(HL)               ; A=character's animatory state
  AND 112                 ; Keep only bits 4-6
  CP 16                   ; 16; Is this character a policeman?
  JR NZ,DROPSAM_0         ; Jump if not
  LD A,128                ; Set bit 7 at COPFLAGS; Sam is in jail
  LD (COPFLAGS),A         ;
DROPSAM_0;
  JP WALKRST              ; Make the character stop running and restart the
                          ; command list

; Make a character walk up and down until somebody knocks on a door
;
; Used by the command lists at CLIST03, CLIST24, CLIST27, CLIST28 and CLIST31.
; Makes the character start walking up or down towards his next walkabout
; destination, unless the character is on door duty and someone has knocked on
; the door (in which case this primary command terminates).
;
; H Character number (215-229)
DOORDUTY;
  LD L,11                 ; Copy the door identifier (168, 172, 173 or 179) and
  CALL GETPARAMS          ; walkabout duration indicator (0 or 255) from the
                          ; command list into bytes 11 and 12 of the
                          ; character's buffer
; This entry point is used by the routine at WALKABOUT.
DOORDUTY_0;
  CALL GETRANDOM          ; Get a random number between 32 and 63 in A
  AND 31                  ;
  ADD A,32                ;
  LD L,13                 ; Store this number in byte 13 of the character's
  LD (HL),A               ; buffer; it is the number of mini-walkabouts the
                          ; character will perform (if the walkabout duration
                          ; indicator in byte 12 is 255)
  LD L,1                  ; Point HL at byte 1 of the character's buffer
  LD A,(HL)               ; A=character's x-coordinate
  LD L,10                 ; Copy this into byte 10 of the character's buffer
  LD (HL),A               ; (it will be the walkabout origin)
  CALL CHGPRICMD          ; Change the character's primary command routine
                          ; address to DDUTYLOOP (below)
DDUTYLOOP;
  LD BC,WALK              ; Point BC at the interruptible subcommand routine
                          ; address at WALK
; This entry point is used by the routine at AWAITSAM with BC=HOODWALK.
DOORDUTY_1;
  LD L,11                 ; Collect the door identifier (168, 172, 173, 175 or
  LD E,(HL)               ; 179) from byte 11 of the character's buffer
  LD D,127                ; Point HL at IPFLAGS (always 0) or the door knock
  EX DE,HL                ; status flags for the door in question (see
                          ; KNOCKFLAGS)
  BIT 7,(HL)              ; Has somebody knocked at the door?
  JR Z,DOORDUTY_3         ; Jump if not
  LD A,192                ; Reset bit 7 and set bit 6 of the door knock status
  XOR (HL)                ; flags to indicate that someone is going to answer
  LD (HL),A               ; the door
  EX DE,HL                ; Restore the character number to H
DOORDUTY_2;
  JP NEXTCMD              ; Move to the next command in the command list (which
                          ; will send the character to the door)
; Either nobody has knocked on the door, or the character is not on door duty.
DOORDUTY_3;
  EX DE,HL                ; Restore the character number to H
  LD L,12                 ; Collect the walkabout duration indicator (0 or 255)
  LD A,(HL)               ; from byte 12 of the character's buffer
  INC L                   ; L=13
  ADD A,(HL)              ; Decrement the walkabout counter in byte 13 of the
  LD (HL),A               ; character's buffer, or leave it unchanged
  LD L,10                 ; Point HL at byte 10 of the character's buffer
  JR NZ,DOORDUTY_4        ; Jump unless the walkabout counter is now 0
; The character has finished walking up and down. If the character is not on
; door duty, we move to the next command in the command list; if the character
; is on door duty, we move six bytes ahead in the command list (past the
; door-opening commands).
  INC L                   ; Collect the door identifier (168, 172, 173, 175 or
  LD A,(HL)               ; 179) from byte 11 of the character's buffer
  ADD A,87                ; Set the carry flag if it's > 168 (meaning the
                          ; character was on door duty)
  SBC A,A                 ; A=6 if the character was on door duty, 0 otherwise
  AND 6                   ;
  LD L,22                 ; Add 0 or 6 to the character's command list offset
  ADD A,(HL)              ; (in byte 22 of his buffer)
  LD (HL),A               ;
  JR DOORDUTY_2           ; Terminate this primary command
; It's time to set another walkabout destination for this character.
DOORDUTY_4;
  CALL GETRANDOM          ; Get a random number in A
  OR 249                  ; A=-6, -4, -2 or 0
  INC A                   ;
  ADD A,(HL)              ; Add the walkabout origin x-coordinate
  LD L,16                 ; Store this x-coordinate in byte 16 of the
  LD (HL),A               ; character's buffer
  JP EXECISC              ; Copy the interruptible subcommand routine address
                          ; (HOODWALK or WALK) from BC into bytes 14 and 15 of
                          ; the character's buffer, and then jump to it

; Initialise a cat's interruptible subcommand
;
; Used by the routine at MVCAT. Places the address of the interruptible
; subcommand routine at CATRUN into bytes 14 and 15 of the cat's buffer, and
; then jumps to it.
;
; BC CATRUN
; H 218 (Cat)
INITISC;
  LD L,14                 ; Copy the address of the interruptible subcommand
  LD (HL),C               ; routine at CATRUN into bytes 14 and 15 of the cat's
  INC L                   ; buffer
  LD (HL),B               ;
  LD A,H                  ; Save the character number in A briefly
  POP HL                  ; Drop the return address from the stack
  PUSH BC                 ; Push the address of the interruptible subcommand
                          ; routine onto the stack
  LD C,L                  ; Set BC to the original return address, and point HL
  LD L,8                  ; at byte 8 of the cat's buffer
  LD B,H                  ;
  LD H,A                  ;
; This entry point is used by the routine at EXECISC with an interruptible
; subcommand routine address in BC, and HL pointing at byte 14 of the
; character's buffer.
INITISC_0;
  LD (HL),C               ; Set the address of the character's primary command
  INC L                   ; routine or interruptible subcommand routine
  LD (HL),B               ;
  RET

; Initialise and execute an interruptible subcommand
;
; Used by the routines at MVSNIPER1 (to activate the sniper) and DOORDUTY (to
; make a character start walking up or down to his next walkabout destination).
;
; BC Interruptible subcommand routine address (MVSNIPER2, HOODWALK or WALK)
; H Character number (215-229)
EXECISC;
  PUSH BC                 ; Push the interruptible subcommand routine address
                          ; onto the stack in preparation for an indirect jump
  LD L,14                 ; Copy the interruptible subcommand routine address
  JR INITISC_0            ; from BC into bytes 14 and 15 of the character's
                          ; buffer, and then jump to it

; Unused
  DEFB 0

; Change the primary command routine address
;
; Used by the routines at MVBANKNOTE, AWAITSAM and DOORDUTY. Places the address
; of the instruction following the CALL to this routine into bytes 8 and 9 of
; the character's buffer, thus making it the address of the character's primary
; command routine.
;
; H Character number (215-229)
CHGPRICMD;
  EX DE,HL                ; Collect the return address from the stack into DE
  EX (SP),HL              ;
  EX DE,HL                ;
  LD A,L                  ; Save L in A briefly
  LD L,8                  ; Copy the return address into bytes 8 and 9 of the
  LD (HL),E               ; character's buffer
  INC L                   ;
  LD (HL),D               ;
  LD L,A                  ; Restore the original contents of L
  EX DE,HL                ; Restore the return address to the stack
  EX (SP),HL              ;
  EX DE,HL                ;
  RET

; Make a character open a door that has been knocked on
;
; Used by the command lists at CLIST06, CLIST24, CLIST27 and CLIST28. Opens the
; door that the character is standing behind, and then rewinds the command list
; such that the character returns to the spot where he was walking up and down
; before going to answer the door.
;
; H Character number (215-229)
ANSWERDOOR;
  PUSH HL                 ; Save the character number briefly
  CALL SAMBYDOOR_2        ; Open the door
  POP HL                  ; Restore the character number to H
  LD L,22                 ; Byte 22 of the character's buffer holds the offset
                          ; of the point reached in the command list
  LD A,(HL)               ; Subtract 14 from this offset; this has the effect
  SUB 14                  ; of sending the character back to the spot where he
  LD (HL),A               ; was walking up and down before answering the door
  JP NEXTCMD              ; Terminate this primary command

; Open a door
;
; Used by the routine at CANOPEN. Updates the play area graphics and screen
; refresh buffer (SRB) for a door so that it appears open.
;
; HL Address of the door status flags (see DOORFLAGS)
OPENDOOR;
  PUSH HL                 ; Save the address of the door status flags
  LD A,L                  ; A=240-249
  SUB 70                  ; Point HL at the door knock status flags for the
  LD L,A                  ; door (see KNOCKFLAGS)
  LD A,(HL)               ; Reset the door knock status flags
  AND 63                  ;
  LD (HL),A               ;
  POP HL                  ; Restore the address of the door status flags to HL
  JP MOVEDOOR             ; Update the play area graphics and the SRB for the
                          ; door

; Collect the window flags for a play area location
;
; Used by the routine at PRINTTILE. On entry, A holds the T value (rotated left
; once), and DE points at the window flags for the play area location under
; consideration at (X,Y) (in one of the data blocks at WINFLAGS6, WINFLAGS5,
; WINFLAGS4, WINFLAGS3, WINFLAGS2, WINFLAGS1 and WINFLAGS0). The window flags
; have the following meanings;
;
; +--------+------------------------------------------------------------------+
; | Bit(s) | Meaning                                                          |
; +--------+------------------------------------------------------------------+
; | 6,7    | Decorations for the only window, or the left-hand window of a    |
; |        | pair; 11=blind is down; 10=blind is up; 01=other; 00=none        |
; | 5      | If set, the light switch is in the 'off' position; reset='on'    |
; | 2-4    | Unused                                                           |
; | 0,1    | Decorations for the right-hand window of a pair (used when bit 2 |
; |        | of T is set)                                                     |
; +--------+------------------------------------------------------------------+
;
; The window flags are also relevant for play area locations (41,33), (113,33),
; (154,33), (209,33), (234,33) and (250,33), where house number signs are
; displayed. In this case, bits 6 and 7 of the window flags determine which
; sign to display.
;
; On exit, A holds the window flags (with bit 5 set if the lights are out,
; reset otherwise), and the zero flag is reset if the play area location
; contains part of the right-hand window of a pair.
;
; A T value, rotated left once
; DE Address of the window flags
WINFLAGS;
  BIT 3,A                 ; Reset the zero flag if we're dealing with a tile
                          ; for the right-hand window of a pair
  LD A,(DE)               ; A=window flags
  PUSH AF                 ; Save the window flags briefly
  SET 7,E                 ; Point DE at the entry in the table at BFUSELOCS
  LD D,255                ; that corresponds to the window's location
  LD A,(DE)               ; Pick up the entry from the table
  LD E,A                  ; Point DE at the blown fuse delay counter for the
  LD D,127                ; fuse that affects the window (if any; see FUSECTRS)
  LD A,(DE)               ; Pick up the blown fuse delay counter
  AND A                   ; Is the fuse currently blown?
  JR Z,WINFLAGS_0         ; Jump if not
  POP AF                  ; Restore the window flags to A
  SET 5,A                 ; Signal; the lights are out (because the fuse is
                          ; blown)
  RET
WINFLAGS_0;
  POP AF                  ; Restore the window flags to A
  RET

; Initialise the character buffers for character groups 215-221
;
; Used by the routine at PREPGAME. Initialises the animatory state, location
; and command list address for every character in character groups 215-221.
INITCBUFS1;
  LD HL,C215INITP1        ; The initialisation parameters for character groups
                          ; 215-221 are located at C215INITP1 onwards
  LD D,215                ; Begin with the buffers for character group 215
INITCBUFS1_0;
  LD E,0                  ; Point DE at the first byte of the first buffer in
                          ; the group
  LD C,5                  ; There are 5 characters in the group
INITCBUFS1_1;
  LD B,3                  ; Initialise a character's animatory state and
INITCBUFS1_2;
  LD A,(HL)               ; location
  INC HL                  ;
  LD (DE),A               ;
  INC E                   ;
  DJNZ INITCBUFS1_2       ;
  XOR A                   ; Reset the flags in byte 3 of the character's buffer
  LD (DE),A               ;
  INC C                   ; Increment C to compensate for the LDI instruction
                          ; that follows
  INC E                   ; Initialise the character's z-coordinate
  LDI                     ;
  LD B,18                 ; Zero out bytes 5-22 of the character's buffer
INITCBUFS1_3;
  LD (DE),A               ;
  INC E                   ;
  DJNZ INITCBUFS1_3       ;
  LD B,2                  ; Copy the command list address into bytes 23 and 24
INITCBUFS1_4;
  LD A,(HL)               ; of the character's buffer
  INC HL                  ;
  LD (DE),A               ;
  INC E                   ;
  DJNZ INITCBUFS1_4       ;
  DEC C                   ; Have we initialised the buffers of all 5 characters
                          ; in the group yet?
  JR NZ,INITCBUFS1_1      ; Jump back if not
  INC D                   ; Point DE at the next character group
  LD A,D                  ; Have we initialised the buffers in every character
  CP 222                  ; group yet?
  JR NZ,INITCBUFS1_0      ; Jump back if not
  RET

; Unused
  DEFB 0

; Make a character walk up and down for a while
;
; Used by the command lists at CLIST13, CLIST15, CLIST16, CLIST17, CLIST19,
; CLIST20, CLIST23, CLIST25, CLIST26, CLIST32 and CLIST33.
;
; H Character number (215-229)
WALKABOUT;
  LD L,11                 ; Set the door identifier in byte 11 of the
  LD (HL),168             ; character's buffer to 168 (which corresponds to no
                          ; door, meaning the character will not be on door
                          ; duty)
  INC L                   ; Set the walkabout duration counter in byte 12 of
  LD (HL),255             ; the character's buffer to 255 (meaning the
                          ; character will walk up and down for a finite period
                          ; instead of indefinitely)
  JP DOORDUTY_0           ; Make the character begin walking up and down

; Control a cat
;
; Used by the command list at CLIST29. Makes the cat run up and down for ever.
;
; H 218 (Cat)
MVCAT;
  LD L,1                  ; Point HL at byte 1 of the cat's buffer
  LD A,(HL)               ; A=cat's initial x-coordinate
  LD L,3                  ; Set bit 7 of byte 3 of the cat's buffer (cats
  LD (HL),128             ; always run)
  LD L,10                 ; The cat's initial x-coordinate will be its
  LD (HL),A               ; walkabout origin; store it in byte 10 of the cat's
                          ; buffer
; The following loop controls the cat from now on.
MVCAT_0;
  CALL GETRANDOM          ; Get a random number between 0 and 15 in A
  AND 15                  ;
  LD L,10                 ; Add the x-coordinate of the cat's walkabout origin
  ADD A,(HL)              ; to get the next walkabout destination x-coordinate
  INC L                   ; Store this in byte 11 of the cat's buffer
  LD (HL),A               ;
  LD BC,CATRUN            ; Copy the address of the interruptible subcommand
  CALL INITISC            ; routine at CATRUN into bytes 14 and 15 of the cat's
                          ; buffer, and change the address of the primary
                          ; command routine to MVCATLOOP (below)
MVCATLOOP;
  JR MVCAT_0

; Make a cat run up or down
;
; The address of this interruptible subcommand routine is placed into bytes 14
; and 15 of a cat's buffer by the routine at MVCAT. It makes a cat run up or
; down to his next walkabout destination, and then terminates.
;
; H 218 (Cat)
CATRUN;
  LD L,0                  ; Point HL at byte 0 of the cat's buffer
  BIT 0,(HL)              ; Is the cat in running phase 2 (animatory state
                          ; 118/246)?
; The cat's animatory state is 117 or 245 (running phase 1). Move him forward
; and advance his animatory state.
  JR Z,CATRUN_0           ; Jump if so
  CALL UPDATESRB          ; Update the SRB for the cat's current animatory
                          ; state and location
  INC A                   ; A=118/246 (cat running phase 2)
  PUSH AF                 ; Save this animatory state briefly
  RLCA                    ; A=-1 if the cat is facing left, 1 if he's facing
  CCF                     ; right
  SBC A,A                 ;
  ADD A,A                 ;
  INC A                   ;
  ADD A,E                 ; Adjust the cat's x-coordinate appropriately
  LD E,A                  ;
  POP AF                  ; Restore the cat's next animatory state to A
  JP UPDATEAS             ; Update the cat's animatory state and location and
                          ; update the SRB
; The cat's animatory state is 118 or 246 (running phase 2). Either advance his
; animatory state, or turn him round.
CATRUN_0;
  LD L,1                  ; Point HL at byte 1 of the cat's buffer
  LD A,(HL)               ; A=cat's current x-coordinate
  LD L,11                 ; The cat's walkabout destination x-coordinate is
                          ; stored in byte 11 of the cat's buffer
  CP (HL)                 ; Has the cat reached his walkabout destination?
  JP Z,NEXTCMD_0          ; Terminate this subcommand if so
  LD B,255                ; B=-1 (which will set the cat's animatory state to
                          ; running phase 1)
  LD L,0                  ; Point HL at byte 0 of the cat's buffer
  BIT 7,(HL)              ; Set the zero flag if the cat is facing left
  JR C,CATRUN_3           ; Jump if the cat is to the left of his walkabout
                          ; destination
  JR Z,CATRUN_2           ; Jump if the cat is facing left
CATRUN_1;
  LD B,128                ; B=128 (which will turn the cat round)
CATRUN_2;
  PUSH BC                 ; Save the animatory state adjustment
  CALL UPDATESRB          ; Update the SRB for the cat's current animatory
                          ; state and location
  POP BC                  ; Restore the animatory state adjustment to B
  ADD A,B                 ; A=cat's next animatory state (running phase 1, or
                          ; turned round)
  JP UPDATEAS             ; Update the cat's animatory state and location and
                          ; update the SRB
CATRUN_3;
  JR NZ,CATRUN_2          ; Jump if the cat is facing right
  JR CATRUN_1             ; Turn the cat round

; Initialise the character buffers for characters 222-230
;
; Used by the routine at PREPGAME. Initialises the animatory states, locations
; and command list addresses for characters 222-230 for the next game mode.
;
; A Game mode (0-4)
INITCBUFS2;
  LD C,A                  ; Point HL at the last byte in the set of
  ADD A,A                 ; initialisation parameters for the current game mode
  ADD A,C                 ; for character 222 (see C222MODE0)
  ADD A,A                 ;
  ADD A,37                ;
  LD L,A                  ;
  LD H,222                ;
INITCBUFS2_0;
  LD D,H                  ; Point DE at byte 31 of the character's buffer
  LD E,31                 ;
  LD A,(HL)               ; Pick up the last byte in the set of initialisation
                          ; parameters (the MSB of a command list address, or 1
                          ; if we're dealing with Sam)
  AND A                   ; Is there a command list address (or 1) here?
  JR Z,INITCBUFS2_3       ; Jump if not
  XOR A                   ; Prepare A for filling parts of the character's
                          ; buffer with zeroes
  PUSH HL                 ; Save the pointer to the initialisation parameters
  LD BC,1794              ; B=7, C=2
INITCBUFS2_1;
  LD (DE),A               ; Fill bytes 25-31 of the character's buffer with
  DEC E                   ; zeroes
  DJNZ INITCBUFS2_1       ;
  LDDR                    ; Copy the command list address (or message number
                          ; and 1 if dealing with Sam) into bytes 23 and 24 of
                          ; the character's buffer
  LD BC,4612              ; B=18, C=4
INITCBUFS2_2;
  LD (DE),A               ; Fill bytes 5-22 of the character's buffer with
  DEC E                   ; zeroes
  DJNZ INITCBUFS2_2       ;
  LDD                     ; Copy the z-coordinate (or y-coordinate of the
                          ; topmost row of the play area on screen if dealing
                          ; with Sam) into byte 4 of the character's buffer
  LD (DE),A               ; Reset all flags in byte 3 of the character's buffer
  DEC E                   ; Point DE at byte 2 of the character's buffer
  LDDR                    ; Copy the x- and y-coordinates and animatory state
                          ; (or, if dealing with Sam, the x-coordinate of the
                          ; leftmost column of the play area on screen, 32 or
                          ; 34, and 0) into bytes 0-2 of the character's buffer
  POP HL                  ; Restore the pointer to the initialisation
                          ; parameters to HL
INITCBUFS2_3;
  INC H                   ; Next character
  LD A,H                  ; Have we initialised all the character buffers yet?
  CP 231                  ;
  JR NZ,INITCBUFS2_0      ; Jump back if not
  RET

; Prepare for demo mode or a new game
;
; Used by the routine at ENDCSCENE. Prepares everything for demo mode or a new
; game and then displays the introductory cutscene.
PREPGAME;
  CALL GENMIRROR          ; Generate the table of mirrored values of 0-255 at
                          ; MIRROR
; Now we initialise the game status buffer.
  INC H                   ; HL=32512
  LD (HL),B               ; Zero out the first 222 bytes of the game status
  LD C,221                ; buffer
  LD DE,32513             ;
  LDIR                    ;
  LD E,224                ; DE=32736
  LD HL,GSBTEMPLT         ; Copy the data at GSBTEMPLT into the last 32 bytes
  LD C,32                 ; of the game status buffer
  LDIR                    ;
; Next we ensure that all the shop and house doors are closed.
  LD B,32                 ; There are 32 Z values to check (one for each 8-tile
                          ; wide segment of the play area)
  LD HL,ZVALUES1          ; Point HL at the first Z value for y-coordinates
                          ; 30-35 at ZVALUES1
PREPGAME_0;
  LD A,(HL)               ; Pick up the Z value
  CP 83                   ; Jump unless the Z value corresponds to the open
  JR NC,PREPGAME_1        ; door of a shop (80) or house (81 or 82)
  CP 80                   ;
  JR C,PREPGAME_1         ;
  SET 2,(HL)              ; Set bit 2 of the Z value, thus closing the door
  JR NZ,PREPGAME_1        ; Jump unless we are dealing with a shop door
  INC H                   ; Update the Z value in the block at ZVALUES0 if we
  LD (HL),83              ; are dealing with a shop door
  DEC H                   ; Point HL 